function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */

import ClayIcon from '@clayui/icon';
import ClayLink from '@clayui/link';
import classNames from 'classnames';
import React from 'react';
export const ItemAfter = /*#__PURE__*/React.forwardRef((_ref, ref) => {
  let {
    children,
    className,
    ...otherProps
  } = _ref;
  return /*#__PURE__*/React.createElement("span", _extends({}, otherProps, {
    className: classNames(className, 'label-item label-item-after'),
    ref: ref
  }), children);
});
ItemAfter.displayName = 'ClayLabelItemAfter';
export const ItemBefore = /*#__PURE__*/React.forwardRef((_ref2, ref) => {
  let {
    children,
    className,
    ...otherProps
  } = _ref2;
  return /*#__PURE__*/React.createElement("span", _extends({}, otherProps, {
    className: classNames(className, 'label-item label-item-before'),
    ref: ref
  }), children);
});
ItemBefore.displayName = 'ClayLabelItemBefore';
export const ItemExpand = /*#__PURE__*/React.forwardRef((_ref3, ref) => {
  let {
    children,
    className,
    href,
    ...otherProps
  } = _ref3;
  const TagName = href ? ClayLink : 'span';
  return /*#__PURE__*/React.createElement(TagName, _extends({}, otherProps, {
    className: classNames(className, 'label-item label-item-expand'),
    href: href,
    ref: ref
  }), children);
});
ItemExpand.displayName = 'ClayLabelItemExpand';
const OldLabel = /*#__PURE__*/React.forwardRef((_ref4, ref) => {
  let {
    children,
    className,
    dismissible,
    displayType = 'secondary',
    large = false,
    ...otherProps
  } = _ref4;
  return /*#__PURE__*/React.createElement("span", _extends({}, otherProps, {
    className: classNames('label', className, {
      'label-dismissible': dismissible,
      'label-lg': large,
      [`label-${displayType}`]: displayType
    }),
    ref: ref
  }), children);
});
OldLabel.displayName = 'ClayLabel';
function forwardRef(component) {
  return /*#__PURE__*/React.forwardRef(component);
}
const Label = forwardRef((_ref5, ref) => {
  let {
    children,
    closeButtonProps,
    href,
    innerElementProps = {},
    withClose = true,
    spritemap,
    ...otherProps
  } = _ref5;
  return /*#__PURE__*/React.createElement(OldLabel, _extends({
    dismissible: withClose && !!closeButtonProps
  }, otherProps, {
    ref: ref
  }), !withClose && children, withClose && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(ItemExpand, _extends({}, innerElementProps, {
    href: href
  }), children), closeButtonProps && /*#__PURE__*/React.createElement(ItemAfter, null, /*#__PURE__*/React.createElement("button", _extends({}, closeButtonProps, {
    className: classNames(closeButtonProps.className, 'close'),
    type: "button"
  }), /*#__PURE__*/React.createElement(ClayIcon, {
    spritemap: spritemap,
    symbol: "times-small"
  })))));
});
Label.displayName = 'ClayLabel';
Label.ItemAfter = ItemAfter;
Label.ItemBefore = ItemBefore;
Label.ItemExpand = ItemExpand;
export default Label;