/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
import React from 'react';
export declare const ItemAfter: React.ForwardRefExoticComponent<React.HTMLAttributes<HTMLSpanElement> & React.RefAttributes<HTMLSpanElement>>;
export declare const ItemBefore: React.ForwardRefExoticComponent<React.HTMLAttributes<HTMLSpanElement> & React.RefAttributes<HTMLSpanElement>>;
export declare const ItemExpand: React.ForwardRefExoticComponent<React.BaseHTMLAttributes<HTMLSpanElement | HTMLAnchorElement> & React.RefAttributes<HTMLSpanElement | HTMLAnchorElement>>;
interface IBaseProps extends React.BaseHTMLAttributes<HTMLSpanElement> {
    /**
     * Flag to indicate if `label-dismissible` class should be applied.
     */
    dismissible?: boolean;
    /**
     * Determines the style of the label.
     */
    displayType?: 'secondary' | 'info' | 'warning' | 'danger' | 'success' | 'unstyled';
    /**
     * Flag to indicate if the label should be of the `large` variant.
     */
    large?: boolean;
}
interface IProps extends IBaseProps {
    /**
     * HTML properties that are applied to the 'x' button.
     */
    closeButtonProps?: React.ButtonHTMLAttributes<HTMLButtonElement> & {
        ref?: (instance: HTMLButtonElement | null) => void;
    };
    /**
     * Pros to add to the inner label item
     */
    innerElementProps?: React.ComponentProps<typeof ItemExpand>;
    /**
     * Path to the location of the spritemap resource used for Icon.
     */
    spritemap?: string;
    /**
     * Flag to indicate if component should include the close button
     */
    withClose?: boolean;
}
interface IForwardRef<T, P = {}> extends React.ForwardRefExoticComponent<P & React.RefAttributes<T>> {
    ItemAfter: typeof ItemAfter;
    ItemBefore: typeof ItemBefore;
    ItemExpand: typeof ItemExpand;
}
declare const Label: IForwardRef<HTMLSpanElement | HTMLAnchorElement, IProps>;
export default Label;
