/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
import React from 'react';
interface IProps extends React.AnchorHTMLAttributes<HTMLAnchorElement> {
    /**
     * Renders the button as a block element.
     */
    block?: boolean;
    /**
     * Flag to indicate if link should be borderless.
     */
    borderless?: boolean;
    /**
     * Config for button props
     */
    button?: boolean | {
        block?: boolean;
        monospaced?: boolean;
        small?: boolean;
    };
    /**
     * Indicates if the text should be underlined
     */
    decoration?: 'none' | 'underline' | null;
    /**
     * Determines how the link is displayed.
     */
    displayType?: 'danger' | 'primary' | 'secondary' | 'tertiary' | 'unstyled';
    /**
     * Sets the text size based on a number scale.
     */
    fontSize?: Number;
    /**
     * Messages for the Link.
     */
    messages?: {
        opensNewWindow: string;
    };
    /**
     * Flag to indicate if the link should be monospaced.
     */
    monospaced?: boolean;
    /**
     * Flag to indicate if the link should use the outlined style.
     */
    outline?: boolean;
    /**
     * Indicates whether the button should use the small variant.
     */
    small?: boolean;
    /**
     * Determines the font-weight of the link.
     */
    weight?: 'normal' | 'semi-bold';
}
declare const Link: React.ForwardRefExoticComponent<IProps & React.RefAttributes<HTMLAnchorElement>>;
export default Link;
