"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _Context = _interopRequireDefault(require("./Context"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
const LINK_PRESETS = {
  danger: {
    base: 'c-link text-danger',
    decoration: 'underline'
  },
  primary: {
    base: 'c-link link-primary',
    decoration: 'underline'
  },
  secondary: {
    base: 'c-link link-secondary',
    decoration: 'underline'
  },
  tertiary: {
    base: 'c-link text-tertiary',
    decoration: null
  },
  unstyled: {
    base: 'link-unstyled',
    decoration: null
  }
};
const FONT_WEIGHTS = {
  normal: 'font-weight-normal',
  'semi-bold': 'font-weight-semi-bold'
};
const defaultMessages = {
  opensNewWindow: '(Opens a new window)'
};
const Link = /*#__PURE__*/_react.default.forwardRef((_ref, ref) => {
  let {
    block,
    borderless,
    button,
    children,
    className,
    decoration,
    displayType,
    fontSize,
    messages = defaultMessages,
    monospaced,
    outline,
    rel,
    small,
    target,
    weight,
    ...otherProps
  } = _ref;
  const TagOrComponent = _react.default.useContext(_Context.default);
  let classes;
  if (button) {
    button = button === true ? {} : button;
    classes = {
      btn: !!button,
      'btn-block': button.block || block,
      'btn-monospaced': button.monospaced || monospaced,
      'btn-outline-borderless': borderless,
      'btn-sm': button.small || small,
      [`btn-${displayType}`]: displayType && !outline && !borderless,
      [`btn-outline-${displayType}`]: displayType && (outline || borderless),
      [FONT_WEIGHTS[weight]]: weight,
      [`text-${fontSize}`]: fontSize,
      [`text-decoration-${decoration}`]: decoration
    };
  } else {
    decoration = decoration === null || outline ? undefined : decoration || LINK_PRESETS[displayType]?.decoration;
    classes = {
      'link-monospaced': monospaced,
      'link-outline': outline,
      'link-outline-borderless': borderless,
      [LINK_PRESETS[displayType]?.base]: displayType && !outline,
      [`link-outline-${displayType}`]: displayType && outline,
      [FONT_WEIGHTS[weight]]: weight,
      [`text-${fontSize}`]: fontSize,
      [`text-decoration-${decoration}`]: decoration
    };
  }
  if (target && !rel) {
    rel = 'noreferrer noopener';
  }
  return /*#__PURE__*/_react.default.createElement(TagOrComponent, _extends({
    className: (0, _classnames.default)(className, classes),
    ref: ref,
    rel: rel,
    target: target
  }, otherProps), children, target === '_blank' && /*#__PURE__*/_react.default.createElement("span", {
    className: "sr-only"
  }, messages.opensNewWindow));
});
Link.displayName = 'ClayLink';
var _default = exports.default = Link;