function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */

import classNames from 'classnames';
import React from 'react';
const LoadingIndicator = /*#__PURE__*/React.forwardRef((_ref, ref) => {
  let {
    className,
    displayType,
    light,
    shape,
    size,
    small,
    ...otherProps
  } = _ref;
  return /*#__PURE__*/React.createElement("span", _extends({
    "aria-hidden": "true"
  }, otherProps, {
    className: classNames(className, {
      'loading-animation': [null, undefined, '', 'circle'].indexOf(shape) > -1,
      [`loading-animation-${shape}`]: shape && ['', 'circle'].indexOf(shape) === -1,
      'loading-animation-light': light,
      [`loading-animation-${displayType}`]: displayType && !light,
      'loading-animation-sm': small,
      [`loading-animation-${size}`]: size
    }),
    ref: ref
  }));
});
LoadingIndicator.displayName = 'ClayLoadingIndicator';
export default LoadingIndicator;