/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
import React from 'react';
interface IProps extends React.HTMLAttributes<HTMLDivElement> {
    /**
     * Determines the color of the visual indicator.
     */
    displayType?: null | 'primary' | 'secondary' | 'light';
    /**
     * Determines the style of the visual indicator.
     */
    shape?: null | 'circle' | 'squares';
    /**
     * Determines the size of the visual indicator.
     */
    size?: null | 'xs' | 'sm' | 'md' | 'lg';
    /**
     * Flag to indicate the 'light' variant
     * @deprecated since v3.59.0 - use `displayType` instead.
     */
    light?: boolean;
    /**
     * Flag to indicate the small size
     * @deprecated since v3.59.0 - use `size` instead.
     */
    small?: boolean;
}
declare const LoadingIndicator: React.ForwardRefExoticComponent<IProps & React.RefAttributes<HTMLSpanElement>>;
export default LoadingIndicator;
