/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
import React from 'react';
export interface IBodyProps extends React.HTMLAttributes<HTMLDivElement> {
    /**
     * Props to add to the iframe element
     */
    iFrameProps?: React.HTMLAttributes<HTMLIFrameElement>;
    /**
     * Flag to indicate if body should be a fixed height with a scrollable overflow.
     */
    scrollable?: boolean;
    /**
     * Url to place an iframe in the body of the modal.
     */
    url?: string;
}
declare const Body: ({ children, className, iFrameProps, scrollable, url, ...otherProps }: IBodyProps) => JSX.Element;
export default Body;
