/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
import React from 'react';
export interface IFooterProps extends React.HTMLAttributes<HTMLDivElement> {
    /**
     * Sets the elements that are positioned `first following
     * the LTR direction on the footer.
     */
    first?: React.ReactElement;
    /**
     * Sets the elements that are positioned `last` following
     * the LTR direction on the footer.
     */
    last?: React.ReactElement;
    /**
     * Sets the elements that are positioned in the middle
     * of the footer.
     */
    middle?: React.ReactElement;
}
declare const Footer: ({ className, first, last, middle, ...otherProps }: IFooterProps) => JSX.Element;
export default Footer;
