/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
import React from 'react';
export declare const ItemGroup: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
export interface IItemProps extends React.HTMLAttributes<HTMLDivElement> {
    /**
     * Flag for indicating if item should autofitting the width
     */
    shrink?: boolean;
}
export declare const Item: ({ children, className, shrink, ...otherProps }: IItemProps) => JSX.Element;
export declare const TitleSection: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
export declare const Title: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
export declare const TitleIndicator: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
export declare const SubtitleSection: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
export declare const Subtitle: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
export interface IHeaderProps extends React.HTMLAttributes<HTMLDivElement> {
    /**
     * Aria label for the modal close button.
     */
    closeButtonAriaLabel?: string;
    /**
     * Flag for indicating if you want to use the Header its children being the title.
     * Set to `false` if you want to use this as a low-level component.
     */
    withTitle?: boolean;
}
declare const Header: ({ children, closeButtonAriaLabel, withTitle, ...otherProps }: IHeaderProps) => JSX.Element;
export default Header;
