/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
import { IPortalBaseProps } from '@clayui/shared';
import React from 'react';
import { IContext } from './Context';
import { Observer } from './types';
interface IProps extends React.HTMLAttributes<HTMLDivElement>, Omit<IContext, 'onClose' | 'ariaLabelledby'> {
    /**
     * Flag indicating to vertically center the modal.
     */
    center?: boolean;
    /**
     * Container element to render modal into.
     */
    containerElementRef?: React.RefObject<Element>;
    /**
     * Props to add to the ClayPortal.
     */
    containerProps?: IPortalBaseProps;
    /**
     * A flag indicating if the modal shouldn't
     * be closed when either the ESC key is pressed
     * or when clicking outside the modal
     */
    disableAutoClose?: boolean;
    /**
     * The size of element modal.
     */
    size?: 'full-screen' | 'lg' | 'sm';
    /**
     * Observer is Modal's communication system with `useModal`
     * hook, adds observer from `useModal` hook here.
     */
    observer: Observer;
    /**
     * Allows setting a custom z-index value, overriding the default one which is 1040, modal body z-index will be +10 of this value
     */
    zIndex?: number;
}
declare const Modal: {
    ({ center, children, className, containerElementRef, containerProps, disableAutoClose, observer, role, size, spritemap, status, zIndex, ...otherProps }: IProps): JSX.Element;
    Body: ({ children, className, iFrameProps, scrollable, url, ...otherProps }: import("./Body").IBodyProps) => JSX.Element;
    Footer: ({ className, first, last, middle, ...otherProps }: import("./Footer").IFooterProps) => JSX.Element;
    Header: ({ children, closeButtonAriaLabel, withTitle, ...otherProps }: import("./Header").IHeaderProps) => JSX.Element;
    Item: ({ children, className, shrink, ...otherProps }: import("./Header").IItemProps) => JSX.Element;
    ItemGroup: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
    Subtitle: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
    SubtitleSection: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
    Title: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
    TitleIndicator: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
    TitleSection: ({ children, className, ...otherProps }: React.HTMLAttributes<HTMLDivElement>) => JSX.Element;
};
export default Modal;
