/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
import React from 'react';
import { Size, Status } from './types';
declare enum Action {
    Close = "CLOSE",
    Open = "OPEN"
}
interface IProps {
    children: React.ReactNode;
    /**
     * The path to the SVG spritemap file containing the icons.
     */
    spritemap?: string;
}
declare type TState = {
    /**
     * Renders an element in the modal body.
     */
    body: React.ReactElement | React.ReactText;
    /**
     * Flag indicating to vertically center the modal.
     */
    center?: boolean;
    /**
     * Render the action buttons on the footer following the order of `ClayModal.Footer`:
     * - first
     * - middle
     * - last
     */
    footer?: Array<React.ReactElement | undefined>;
    /**
     * Renders an element in the modal header.
     */
    header?: React.ReactElement | React.ReactText;
    /**
     * The size of element modal.
     */
    size?: Size;
    /**
     * Status messages.
     */
    status?: Status;
    /**
     * Url to place an iframe in the body of the modal.
     */
    url?: string;
};
declare type TAction = {
    type: Action.Open | 1;
    payload: TState;
} | {
    type: Action.Close | 0;
};
declare type TProvider = [TState & {
    onClose: () => void;
}, React.Dispatch<TAction>];
declare const Context: React.Context<TProvider>;
declare const ModalProvider: ({ children, spritemap }: IProps) => JSX.Element;
export { Context };
export default ModalProvider;
