"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
const Body = _ref => {
  let {
    children,
    className,
    iFrameProps = {},
    scrollable,
    url,
    ...otherProps
  } = _ref;
  const elementRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    const onKeyDown = event => {
      if (elementRef.current && (event.key === 'ArrowUp' || event.key === 'ArrowDown') && !elementRef.current.contains(document.activeElement)) {
        if (event.defaultPrevented) {
          return;
        }
        elementRef.current.focus();
      }
    };
    document.addEventListener('keydown', onKeyDown);
    return () => {
      document.removeEventListener('keydown', onKeyDown);
    };
  }, [elementRef]);
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: (0, _classnames.default)('modal-body', className, {
      'inline-scroller': scrollable,
      'modal-body-iframe': url
    }),
    ref: elementRef,
    tabIndex: scrollable ? -1 : undefined
  }, otherProps), url ? /*#__PURE__*/_react.default.createElement("iframe", _extends({}, iFrameProps, {
    src: url,
    title: url
  })) : children);
};
var _default = exports.default = Body;