"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TitleSection = exports.TitleIndicator = exports.Title = exports.SubtitleSection = exports.Subtitle = exports.ItemGroup = exports.Item = void 0;
var _button = _interopRequireDefault(require("@clayui/button"));
var _icon = _interopRequireDefault(require("@clayui/icon"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _Context = _interopRequireDefault(require("./Context"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
const ItemGroup = _ref => {
  let {
    children,
    className,
    ...otherProps
  } = _ref;
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: (0, _classnames.default)('modal-item-group', className)
  }, otherProps), children);
};
exports.ItemGroup = ItemGroup;
const Item = _ref2 => {
  let {
    children,
    className,
    shrink,
    ...otherProps
  } = _ref2;
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: (0, _classnames.default)('modal-item', className, {
      'modal-item-shrink': shrink
    })
  }, otherProps), children);
};
exports.Item = Item;
const TitleSection = _ref3 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref3;
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: (0, _classnames.default)('modal-title-section', className)
  }, otherProps), children);
};
exports.TitleSection = TitleSection;
const Title = _ref4 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref4;
  const {
    ariaLabelledby
  } = _react.default.useContext(_Context.default);
  return /*#__PURE__*/_react.default.createElement("h1", _extends({
    className: (0, _classnames.default)('modal-title', className),
    tabIndex: -1
  }, otherProps, {
    id: ariaLabelledby
  }), children);
};
exports.Title = Title;
const TitleIndicator = _ref5 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref5;
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: (0, _classnames.default)('modal-title-indicator', className)
  }, otherProps), children);
};
exports.TitleIndicator = TitleIndicator;
const SubtitleSection = _ref6 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref6;
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: (0, _classnames.default)('modal-subtitle-section', className)
  }, otherProps), children);
};
exports.SubtitleSection = SubtitleSection;
const Subtitle = _ref7 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref7;
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: (0, _classnames.default)('modal-subtitle', className)
  }, otherProps), children);
};
exports.Subtitle = Subtitle;
const ICON_MAP = {
  danger: 'exclamation-full',
  info: 'info-circle',
  success: 'check-circle-full',
  warning: 'warning-full'
};
const HighLevel = _ref8 => {
  let {
    children,
    closeButtonAriaLabel = 'Close',
    onClose,
    spritemap,
    status
  } = _ref8;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Title, null, status && /*#__PURE__*/_react.default.createElement(TitleIndicator, null, /*#__PURE__*/_react.default.createElement(_icon.default, {
    spritemap: spritemap,
    symbol: ICON_MAP[status]
  })), children), /*#__PURE__*/_react.default.createElement(_button.default, {
    "aria-label": closeButtonAriaLabel,
    className: "close",
    displayType: "unstyled",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    spritemap: spritemap,
    symbol: "times"
  })));
};
const ClayModalHeader = _ref9 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref9;
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: (0, _classnames.default)('modal-header', className)
  }, otherProps), children);
};
const Header = _ref10 => {
  let {
    children,
    closeButtonAriaLabel,
    withTitle = true,
    ...otherProps
  } = _ref10;
  const {
    onClose,
    spritemap,
    status
  } = _react.default.useContext(_Context.default);
  return /*#__PURE__*/_react.default.createElement(ClayModalHeader, otherProps, withTitle && /*#__PURE__*/_react.default.createElement(HighLevel, {
    closeButtonAriaLabel: closeButtonAriaLabel,
    onClose: onClose,
    spritemap: spritemap,
    status: status
  }, children), !withTitle && children);
};
var _default = exports.default = Header;