"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserInteractions = void 0;
var _shared = require("@clayui/shared");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * A hook that takes care of controlling click, keyup and keydown events
 * respectively close the modal after a click on the overlay, close the
 * modal by pressing the ESC key and control the focus within the Modal.
 */
const useUserInteractions = (modalElementRef, modalBodyElementRef, onClick, show, content) => {
  const mouseEventTargetRef = _react.default.useRef(null);
  const getFocusableNodes = () => {
    if (modalBodyElementRef.current) {
      const nodes = modalBodyElementRef.current.querySelectorAll(_shared.FOCUSABLE_ELEMENTS);
      return Object.keys(nodes).map(key => nodes[key]);
    }
    return [];
  };
  const handleKeydown = event => {
    if (event.key === _shared.Keys.Esc && _shared.stack[_shared.stack.length - 1] === modalElementRef) {
      onClick();
    }
    if (event.key === _shared.Keys.Tab) {
      if (modalElementRef.current && event.target !== null && !modalElementRef.current.contains(event.target)) {
        modalBodyElementRef.current.focus();
      } else {
        const focusableNodes = getFocusableNodes();
        const focusedItemIndex = focusableNodes.indexOf(document.activeElement);
        if (event.shiftKey && focusedItemIndex === 0) {
          focusableNodes[focusableNodes.length - 1].focus();
          event.preventDefault();
        }
        if (!event.shiftKey && focusedItemIndex === focusableNodes.length - 1) {
          focusableNodes[0].focus();
          event.preventDefault();
        }
      }
    }
  };
  const handleDocumentMouseDown = event => {
    // We keep the `event.target` to check later in the click event if
    // the target is the same, otherwise, we are assuming that the element
    // has been removed from the DOM.

    mouseEventTargetRef.current = event.target;
  };
  const handleDocumentMouseUp = event => {
    if (event.defaultPrevented) {
      mouseEventTargetRef.current = null;
      return;
    }
    if (event.target === modalElementRef.current && mouseEventTargetRef.current === event.target) {
      mouseEventTargetRef.current = null;
      onClick();
    }
    mouseEventTargetRef.current = null;
  };

  /**
   * Just listen for keyup, keydown, and click when
   * changeAttachEvent is true.
   */
  (0, _react.useEffect)(() => {
    document.addEventListener('keydown', handleKeydown);
    document.addEventListener('mousedown', handleDocumentMouseDown);
    document.addEventListener('mouseup', handleDocumentMouseUp);
    return () => {
      document.removeEventListener('keydown', handleKeydown);
      document.removeEventListener('mousedown', handleDocumentMouseDown);
      document.removeEventListener('mouseup', handleDocumentMouseUp);
    };
  }, [show, content]);
};
exports.useUserInteractions = useUserInteractions;