"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _shared = require("@clayui/shared");
var _ariaHidden = require("aria-hidden");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _warning = _interopRequireDefault(require("warning"));
var _Body = _interopRequireDefault(require("./Body"));
var _Context = _interopRequireDefault(require("./Context"));
var _Footer = _interopRequireDefault(require("./Footer"));
var _Header = _interopRequireWildcard(require("./Header"));
var _Hook = require("./Hook");
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
const warningMessage = `You need to pass the 'observer' prop to ClayModal for everything to work fine, use the 'useModal' hook that exposes the observer.

> const {observer} = useModal({...});
>
> return (
> 	<ClayModal observer={observer}>
> 		...
> 	</ClayModal>
> );
`;
let counter = 0;
const Modal = _ref => {
  let {
    center,
    children,
    className,
    containerElementRef,
    containerProps = {},
    disableAutoClose = false,
    observer,
    role = 'dialog',
    size,
    spritemap,
    status,
    zIndex,
    ...otherProps
  } = _ref;
  const modalElementRef = (0, _react.useRef)(null);
  const modalBodyElementRef = (0, _react.useRef)(null);
  const [show, content] = observer && observer.mutation ? observer.mutation : [false, false];
  "production" !== "production" ? (0, _warning.default)(observer !== undefined, warningMessage) : void 0;
  (0, _Hook.useUserInteractions)(modalElementRef, modalBodyElementRef, () => !disableAutoClose && observer.dispatch(_types.ObserverType.Close), show, content);
  (0, _react.useEffect)(() => {
    observer.dispatch(_types.ObserverType.RestoreFocus, document.activeElement);
    observer.dispatch(_types.ObserverType.Open);
  }, []);
  (0, _react.useEffect)(() => {
    if (modalBodyElementRef.current && show && content) {
      const focusedElement = modalBodyElementRef.current.querySelector('h1');
      if (focusedElement) {
        focusedElement.focus();
      } else {
        modalBodyElementRef.current.focus();
      }
    }
  }, [show, content]);
  const ariaLabelledby = (0, _react.useMemo)(() => {
    counter++;
    return `clay-modal-label-${counter}`;
  }, []);
  (0, _react.useEffect)(() => {
    if (show && content) {
      _shared.stack.push(modalElementRef);
    }
    return () => {
      const index = _shared.stack.indexOf(modalElementRef);
      if (index >= 0) {
        _shared.stack.splice(index, 1);
      }
    };
  }, [show, modalElementRef, content]);
  (0, _react.useEffect)(() => {
    if (modalElementRef.current && show && _shared.stack[_shared.stack.length - 1] === modalElementRef) {
      // Hide everything from ARIA except the Modal Body
      return (0, _ariaHidden.suppressOthers)(modalElementRef.current);
    }
  }, [show]);
  return /*#__PURE__*/_react.default.createElement(_shared.ClayPortal, _extends({}, containerProps, {
    containerRef: containerElementRef,
    subPortalRef: modalElementRef
  }), /*#__PURE__*/_react.default.createElement("div", {
    "aria-hidden": "true",
    className: (0, _classnames.default)('modal-backdrop fade', {
      show
    }),
    style: {
      zIndex
    }
  }), /*#__PURE__*/_react.default.createElement("div", _extends({}, otherProps, {
    className: (0, _classnames.default)('fade modal d-block', className, {
      show
    }),
    ref: modalElementRef,
    style: {
      zIndex: zIndex && zIndex + 10
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('modal-dialog', {
      [`modal-${size}`]: size,
      [`modal-${status}`]: status,
      'modal-dialog-centered': center
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    "aria-labelledby": ariaLabelledby,
    "aria-modal": "true",
    className: "modal-content",
    ref: modalBodyElementRef,
    role: role,
    tabIndex: -1
  }, /*#__PURE__*/_react.default.createElement(_Context.default.Provider, {
    value: {
      ariaLabelledby,
      onClose: () => observer.dispatch(_types.ObserverType.Close),
      spritemap,
      status
    }
  }, content && children)))));
};
Modal.Body = _Body.default;
Modal.Footer = _Footer.default;
Modal.Header = _Header.default;
Modal.Item = _Header.Item;
Modal.ItemGroup = _Header.ItemGroup;
Modal.Subtitle = _Header.Subtitle;
Modal.SubtitleSection = _Header.SubtitleSection;
Modal.Title = _Header.Title;
Modal.TitleIndicator = _Header.TitleIndicator;
Modal.TitleSection = _Header.TitleSection;
var _default = exports.default = Modal;