"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Context = void 0;
var _react = _interopRequireDefault(require("react"));
var _Modal = _interopRequireDefault(require("./Modal"));
var _useModal = require("./useModal");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
var Action;
(function (Action) {
  Action["Close"] = "CLOSE";
  Action["Open"] = "OPEN";
})(Action || (Action = {}));
const initialState = {
  body: /*#__PURE__*/_react.default.createElement("div", null),
  footer: [],
  onClose: () => {},
  visible: false
};
const reducer = (_state, action) => {
  switch (action.type) {
    case 1:
    case Action.Open:
      return {
        ...action.payload,
        visible: true
      };
    case 0:
    case Action.Close:
      return initialState;
    default:
      throw new TypeError();
  }
};
const Context = exports.Context = /*#__PURE__*/_react.default.createContext([initialState, () => {}]);
const ModalProvider = _ref => {
  let {
    children,
    spritemap
  } = _ref;
  const [{
    visible,
    ...otherState
  }, dispatch] = _react.default.useReducer(reducer, initialState);
  const {
    observer,
    onClose
  } = (0, _useModal.useModal)({
    onClose: () => dispatch({
      type: Action.Close
    })
  });
  const {
    body,
    center,
    footer = [],
    header,
    size,
    status,
    url
  } = otherState;
  const [first, middle, last] = footer;
  const state = {
    ...otherState,
    onClose
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visible && /*#__PURE__*/_react.default.createElement(_Modal.default, {
    center: center,
    observer: observer,
    size: size,
    spritemap: spritemap,
    status: status
  }, header && /*#__PURE__*/_react.default.createElement(_Modal.default.Header, null, header), /*#__PURE__*/_react.default.createElement(_Modal.default.Body, {
    url: url
  }, body), !!footer.length && /*#__PURE__*/_react.default.createElement(_Modal.default.Footer, {
    first: first,
    last: last,
    middle: middle
  })), /*#__PURE__*/_react.default.createElement(Context.Provider, {
    value: [state, dispatch]
  }, children));
};
var _default = exports.default = ModalProvider;