"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useModal = void 0;
var _react = require("react");
var _types = require("./types");
/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */

const delay = fn => {
  return setTimeout(() => {
    fn();
  }, 100);
};
const modalOpenClassName = 'modal-open';
const useModal = function () {
  let {
    defaultOpen = false,
    onClose
  } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const [open, setOpen] = (0, _react.useState)(defaultOpen);
  const [visible, setVisible] = (0, _react.useState)([false, false]);
  const timerIdRef = (0, _react.useRef)(null);
  const restoreTriggerRef = (0, _react.useRef)(null);

  /**
   * Control the close of the modal to create the component's "unmount"
   * animation and call the onClose prop with delay.
   */
  const handleCloseModal = () => {
    document.body.classList.remove(modalOpenClassName);
    setVisible([false, true]);
    timerIdRef.current = delay(() => {
      if (onClose) {
        onClose();
      }
      if (restoreTriggerRef.current) {
        restoreTriggerRef.current.focus();
        restoreTriggerRef.current = null;
      }
      setOpen(false);
      setVisible([false, false]);
    });
  };
  const handleOpenModal = () => {
    document.body.classList.add(modalOpenClassName);
    setOpen(true);
    timerIdRef.current = delay(() => setVisible([true, true]));
  };
  const handleObserverDispatch = (type, payload) => {
    switch (type) {
      case _types.ObserverType.Close:
        handleCloseModal();
        break;
      case _types.ObserverType.Open:
        handleOpenModal();
        break;
      case _types.ObserverType.RestoreFocus:
        restoreTriggerRef.current = payload;
        break;
      default:
        break;
    }
  };
  const onOpenChange = (0, _react.useCallback)(value => {
    if (value) {
      handleOpenModal();
    } else {
      handleCloseModal();
    }
  }, []);
  (0, _react.useEffect)(() => {
    return () => {
      document.body.classList.remove(modalOpenClassName);
      if (timerIdRef.current) {
        clearTimeout(timerIdRef.current);
      }
    };
  }, []);
  return {
    observer: {
      dispatch: handleObserverDispatch,
      mutation: visible
    },
    onClose: handleCloseModal,
    onOpenChange,
    open
  };
};
exports.useModal = useModal;