function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */

import classNames from 'classnames';
import React, { useEffect, useRef } from 'react';
const Body = _ref => {
  let {
    children,
    className,
    iFrameProps = {},
    scrollable,
    url,
    ...otherProps
  } = _ref;
  const elementRef = useRef(null);
  useEffect(() => {
    const onKeyDown = event => {
      if (elementRef.current && (event.key === 'ArrowUp' || event.key === 'ArrowDown') && !elementRef.current.contains(document.activeElement)) {
        if (event.defaultPrevented) {
          return;
        }
        elementRef.current.focus();
      }
    };
    document.addEventListener('keydown', onKeyDown);
    return () => {
      document.removeEventListener('keydown', onKeyDown);
    };
  }, [elementRef]);
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classNames('modal-body', className, {
      'inline-scroller': scrollable,
      'modal-body-iframe': url
    }),
    ref: elementRef,
    tabIndex: scrollable ? -1 : undefined
  }, otherProps), url ? /*#__PURE__*/React.createElement("iframe", _extends({}, iFrameProps, {
    src: url,
    title: url
  })) : children);
};
export default Body;