function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */

import ClayButton from '@clayui/button';
import ClayIcon from '@clayui/icon';
import classNames from 'classnames';
import React from 'react';
import Context from "./Context.js";
export const ItemGroup = _ref => {
  let {
    children,
    className,
    ...otherProps
  } = _ref;
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classNames('modal-item-group', className)
  }, otherProps), children);
};
export const Item = _ref2 => {
  let {
    children,
    className,
    shrink,
    ...otherProps
  } = _ref2;
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classNames('modal-item', className, {
      'modal-item-shrink': shrink
    })
  }, otherProps), children);
};
export const TitleSection = _ref3 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref3;
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classNames('modal-title-section', className)
  }, otherProps), children);
};
export const Title = _ref4 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref4;
  const {
    ariaLabelledby
  } = React.useContext(Context);
  return /*#__PURE__*/React.createElement("h1", _extends({
    className: classNames('modal-title', className),
    tabIndex: -1
  }, otherProps, {
    id: ariaLabelledby
  }), children);
};
export const TitleIndicator = _ref5 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref5;
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classNames('modal-title-indicator', className)
  }, otherProps), children);
};
export const SubtitleSection = _ref6 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref6;
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classNames('modal-subtitle-section', className)
  }, otherProps), children);
};
export const Subtitle = _ref7 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref7;
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classNames('modal-subtitle', className)
  }, otherProps), children);
};
const ICON_MAP = {
  danger: 'exclamation-full',
  info: 'info-circle',
  success: 'check-circle-full',
  warning: 'warning-full'
};
const HighLevel = _ref8 => {
  let {
    children,
    closeButtonAriaLabel = 'Close',
    onClose,
    spritemap,
    status
  } = _ref8;
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Title, null, status && /*#__PURE__*/React.createElement(TitleIndicator, null, /*#__PURE__*/React.createElement(ClayIcon, {
    spritemap: spritemap,
    symbol: ICON_MAP[status]
  })), children), /*#__PURE__*/React.createElement(ClayButton, {
    "aria-label": closeButtonAriaLabel,
    className: "close",
    displayType: "unstyled",
    onClick: onClose
  }, /*#__PURE__*/React.createElement(ClayIcon, {
    spritemap: spritemap,
    symbol: "times"
  })));
};
const ClayModalHeader = _ref9 => {
  let {
    children,
    className,
    ...otherProps
  } = _ref9;
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classNames('modal-header', className)
  }, otherProps), children);
};
const Header = _ref10 => {
  let {
    children,
    closeButtonAriaLabel,
    withTitle = true,
    ...otherProps
  } = _ref10;
  const {
    onClose,
    spritemap,
    status
  } = React.useContext(Context);
  return /*#__PURE__*/React.createElement(ClayModalHeader, otherProps, withTitle && /*#__PURE__*/React.createElement(HighLevel, {
    closeButtonAriaLabel: closeButtonAriaLabel,
    onClose: onClose,
    spritemap: spritemap,
    status: status
  }, children), !withTitle && children);
};
export default Header;