function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */

import { ClayPortal, stack } from '@clayui/shared';
import { suppressOthers } from 'aria-hidden';
import classNames from 'classnames';
import React, { useEffect, useMemo, useRef } from 'react';
import warning from 'warning';
import Body from "./Body.js";
import Context from "./Context.js";
import Footer from "./Footer.js";
import Header, { Item, ItemGroup, Subtitle, SubtitleSection, Title, TitleIndicator, TitleSection } from "./Header.js";
import { useUserInteractions } from "./Hook.js";
import { ObserverType } from "./types.js";
const warningMessage = `You need to pass the 'observer' prop to ClayModal for everything to work fine, use the 'useModal' hook that exposes the observer.

> const {observer} = useModal({...});
>
> return (
> 	<ClayModal observer={observer}>
> 		...
> 	</ClayModal>
> );
`;
let counter = 0;
const Modal = _ref => {
  let {
    center,
    children,
    className,
    containerElementRef,
    containerProps = {},
    disableAutoClose = false,
    observer,
    role = 'dialog',
    size,
    spritemap,
    status,
    zIndex,
    ...otherProps
  } = _ref;
  const modalElementRef = useRef(null);
  const modalBodyElementRef = useRef(null);
  const [show, content] = observer && observer.mutation ? observer.mutation : [false, false];
  "production" !== "production" ? warning(observer !== undefined, warningMessage) : void 0;
  useUserInteractions(modalElementRef, modalBodyElementRef, () => !disableAutoClose && observer.dispatch(ObserverType.Close), show, content);
  useEffect(() => {
    observer.dispatch(ObserverType.RestoreFocus, document.activeElement);
    observer.dispatch(ObserverType.Open);
  }, []);
  useEffect(() => {
    if (modalBodyElementRef.current && show && content) {
      const focusedElement = modalBodyElementRef.current.querySelector('h1');
      if (focusedElement) {
        focusedElement.focus();
      } else {
        modalBodyElementRef.current.focus();
      }
    }
  }, [show, content]);
  const ariaLabelledby = useMemo(() => {
    counter++;
    return `clay-modal-label-${counter}`;
  }, []);
  useEffect(() => {
    if (show && content) {
      stack.push(modalElementRef);
    }
    return () => {
      const index = stack.indexOf(modalElementRef);
      if (index >= 0) {
        stack.splice(index, 1);
      }
    };
  }, [show, modalElementRef, content]);
  useEffect(() => {
    if (modalElementRef.current && show && stack[stack.length - 1] === modalElementRef) {
      // Hide everything from ARIA except the Modal Body
      return suppressOthers(modalElementRef.current);
    }
  }, [show]);
  return /*#__PURE__*/React.createElement(ClayPortal, _extends({}, containerProps, {
    containerRef: containerElementRef,
    subPortalRef: modalElementRef
  }), /*#__PURE__*/React.createElement("div", {
    "aria-hidden": "true",
    className: classNames('modal-backdrop fade', {
      show
    }),
    style: {
      zIndex
    }
  }), /*#__PURE__*/React.createElement("div", _extends({}, otherProps, {
    className: classNames('fade modal d-block', className, {
      show
    }),
    ref: modalElementRef,
    style: {
      zIndex: zIndex && zIndex + 10
    }
  }), /*#__PURE__*/React.createElement("div", {
    className: classNames('modal-dialog', {
      [`modal-${size}`]: size,
      [`modal-${status}`]: status,
      'modal-dialog-centered': center
    })
  }, /*#__PURE__*/React.createElement("div", {
    "aria-labelledby": ariaLabelledby,
    "aria-modal": "true",
    className: "modal-content",
    ref: modalBodyElementRef,
    role: role,
    tabIndex: -1
  }, /*#__PURE__*/React.createElement(Context.Provider, {
    value: {
      ariaLabelledby,
      onClose: () => observer.dispatch(ObserverType.Close),
      spritemap,
      status
    }
  }, content && children)))));
};
Modal.Body = Body;
Modal.Footer = Footer;
Modal.Header = Header;
Modal.Item = Item;
Modal.ItemGroup = ItemGroup;
Modal.Subtitle = Subtitle;
Modal.SubtitleSection = SubtitleSection;
Modal.Title = Title;
Modal.TitleIndicator = TitleIndicator;
Modal.TitleSection = TitleSection;
export default Modal;