/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */

import React from 'react';
import ClayModal from "./Modal.js";
import { useModal } from "./useModal.js";
var Action;
(function (Action) {
  Action["Close"] = "CLOSE";
  Action["Open"] = "OPEN";
})(Action || (Action = {}));
const initialState = {
  body: /*#__PURE__*/React.createElement("div", null),
  footer: [],
  onClose: () => {},
  visible: false
};
const reducer = (_state, action) => {
  switch (action.type) {
    case 1:
    case Action.Open:
      return {
        ...action.payload,
        visible: true
      };
    case 0:
    case Action.Close:
      return initialState;
    default:
      throw new TypeError();
  }
};
const Context = /*#__PURE__*/React.createContext([initialState, () => {}]);
const ModalProvider = _ref => {
  let {
    children,
    spritemap
  } = _ref;
  const [{
    visible,
    ...otherState
  }, dispatch] = React.useReducer(reducer, initialState);
  const {
    observer,
    onClose
  } = useModal({
    onClose: () => dispatch({
      type: Action.Close
    })
  });
  const {
    body,
    center,
    footer = [],
    header,
    size,
    status,
    url
  } = otherState;
  const [first, middle, last] = footer;
  const state = {
    ...otherState,
    onClose
  };
  return /*#__PURE__*/React.createElement(React.Fragment, null, visible && /*#__PURE__*/React.createElement(ClayModal, {
    center: center,
    observer: observer,
    size: size,
    spritemap: spritemap,
    status: status
  }, header && /*#__PURE__*/React.createElement(ClayModal.Header, null, header), /*#__PURE__*/React.createElement(ClayModal.Body, {
    url: url
  }, body), !!footer.length && /*#__PURE__*/React.createElement(ClayModal.Footer, {
    first: first,
    last: last,
    middle: middle
  })), /*#__PURE__*/React.createElement(Context.Provider, {
    value: [state, dispatch]
  }, children));
};
export { Context };
export default ModalProvider;