/**
 * SPDX-FileCopyrightText: © 2019 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */
import { Observer } from './types';
declare type Props = {
    /**
     * Set the default value of the state of the modal dialog.
     */
    defaultOpen?: boolean;
    /**
     * Callback called to close the modal.
     * @deprecated since v3.52.0 - use the `open` and `onOpenChange` properties
     * of the hook return and remove its state.
     */
    onClose?: () => void;
};
declare type Return = {
    /**
     * Observer is an internal property that must be connected to the <ClayModal /> component.
     */
    observer: Observer;
    /**
     * Callback to close the modal, aliased to `onOpenChange` callback.
     */
    onClose: () => void;
    /**
     * Callback to change open state.
     */
    onOpenChange: (value: boolean) => void;
    /**
     * Sets the open state of the modal.
     */
    open: boolean;
};
export declare const useModal: ({ defaultOpen, onClose, }?: Props) => Return;
export {};
