module.exports = function(karma) {
    karma.set({
        plugins: ['karma-browserify', 'karma-chai', 'karma-mocha', 'karma-coverage', 'karma-phantomjs-launcher'],

        frameworks: ['browserify', 'chai', 'mocha'],

        files: [
            'src/**/*.js',
            'test/**/*.js'
        ],

        preprocessors: {
            'src/**/*.js' : ['browserify', 'coverage'],
            'test/**/*.js': ['browserify', 'coverage']
        },

        reporters: ['progress', 'coverage'],

        browserify: {
            debug: true,
            transform: ['babelify', 'browserify-istanbul']
        },

        browsers: ['PhantomJS']
    });
}
