var fs = require('graceful-fs');
var log = require('npmlog');

var config = require('./config');


/**
 * Configurable log level.
 */
log.level = config.get('log_level');


/**
 * Read the build configuration file.
 * @param {string} configPath Path to config file.
 * @param {function(Error, Object)} callback Callback.
 */
exports.readConfig = function(configPath, callback) {
  fs.readFile(configPath, function(err, data) {
    if (err) {
      if (err.code === 'ENOENT') {
        err = new Error('Unable to find config file: ' + configPath);
      }
      callback(err);
      return;
    }
    var config;
    try {
      config = JSON.parse(String(data));
    } catch (err2) {
      callback(new Error('Trouble parsing config as JSON: ' +
          err2.message));
      return;
    }
    callback(null, config);
  });
};
