(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./projects/icons/src/clr-icons-element.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./projects/icons/src/clr-icons-api.ts":
/*!*********************************************!*\
  !*** ./projects/icons/src/clr-icons-api.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 * Copyright (c) 2016-2021 VMware, Inc. All Rights Reserved.
 * This software is released under MIT license.
 * The full license information can be found in LICENSE in the root directory of this project.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClarityIconsApi = void 0;
var shape_template_observer_1 = __webpack_require__(/*! ./utils/shape-template-observer */ "./projects/icons/src/utils/shape-template-observer.ts");
var iconShapeSources = {};
var ClarityIconsApi = /** @class */ (function () {
    function ClarityIconsApi() {
    }
    Object.defineProperty(ClarityIconsApi, "instance", {
        get: function () {
            if (!ClarityIconsApi.singleInstance) {
                ClarityIconsApi.singleInstance = new ClarityIconsApi();
            }
            return ClarityIconsApi.singleInstance;
        },
        enumerable: false,
        configurable: true
    });
    ClarityIconsApi.prototype.validateName = function (name) {
        if (name.length === 0) {
            throw new Error('Shape name or alias must be a non-empty string!');
        }
        if (/\s/.test(name)) {
            throw new Error('Shape name or alias must not contain any whitespace characters!');
        }
        return true;
    };
    ClarityIconsApi.prototype.normalizeShapeName = function (shapeName) {
        return shapeName.toLowerCase();
    };
    ClarityIconsApi.prototype.setIconTemplate = function (shapeName, shapeTemplate) {
        var trimmedShapeTemplate = shapeTemplate.trim();
        if (this.validateName(shapeName)) {
            // Make sure the shapeName don't contain uppercase characters
            // when registering it
            shapeName = this.normalizeShapeName(shapeName);
            // if the shape name exists, delete it.
            if (iconShapeSources[shapeName]) {
                delete iconShapeSources[shapeName];
            }
            iconShapeSources[shapeName] = trimmedShapeTemplate;
            shape_template_observer_1.ShapeTemplateObserver.instance.emitChanges(shapeName, trimmedShapeTemplate);
        }
    };
    ClarityIconsApi.prototype.setIconAliases = function (templates, shapeName, aliasNames) {
        for (var _i = 0, aliasNames_1 = aliasNames; _i < aliasNames_1.length; _i++) {
            var aliasName = aliasNames_1[_i];
            if (this.validateName(aliasName)) {
                Object.defineProperty(templates, aliasName, {
                    get: function () {
                        return templates[shapeName];
                    },
                    enumerable: true,
                    configurable: true,
                });
            }
        }
    };
    ClarityIconsApi.prototype.add = function (icons) {
        if (typeof icons !== 'object') {
            throw new Error("The argument must be an object literal passed in the following pattern:\n                { \"shape-name\": \"shape-template\" }");
        }
        for (var shapeName in icons) {
            if (icons.hasOwnProperty(shapeName)) {
                this.setIconTemplate(shapeName, icons[shapeName]);
            }
        }
    };
    ClarityIconsApi.prototype.has = function (shapeName) {
        return !!iconShapeSources[this.normalizeShapeName(shapeName)];
    };
    ClarityIconsApi.prototype.get = function (shapeName) {
        // if shapeName is not given, return all icon templates.
        if (!shapeName) {
            return iconShapeSources;
        }
        if (typeof shapeName !== 'string') {
            throw new TypeError('Only string argument is allowed in this method.');
        }
        return iconShapeSources[this.normalizeShapeName(shapeName)];
    };
    ClarityIconsApi.prototype.alias = function (aliases) {
        if (typeof aliases !== 'object') {
            throw new Error("The argument must be an object literal passed in the following pattern:\n                { \"shape-name\": [\"alias-name\", ...] }");
        }
        for (var shapeName in aliases) {
            if (aliases.hasOwnProperty(shapeName)) {
                if (iconShapeSources.hasOwnProperty(shapeName)) {
                    // set an alias to the icon if it exists in iconShapeSources.
                    this.setIconAliases(iconShapeSources, shapeName, aliases[shapeName]);
                }
                else {
                    throw new Error("An icon \"" + shapeName + "\" you are trying to set aliases to doesn't exist in the Clarity Icons sets!");
                }
            }
        }
    };
    return ClarityIconsApi;
}());
exports.ClarityIconsApi = ClarityIconsApi;


/***/ }),

/***/ "./projects/icons/src/clr-icons-element.ts":
/*!*************************************************!*\
  !*** ./projects/icons/src/clr-icons-element.ts ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ClarityIconElement = void 0;
/*
 * Copyright (c) 2016-2021 VMware, Inc. All Rights Reserved.
 * This software is released under MIT license.
 * The full license information can be found in LICENSE in the root directory of this project.
 */
var clr_icons_api_1 = __webpack_require__(/*! ./clr-icons-api */ "./projects/icons/src/clr-icons-api.ts");
var shape_template_observer_1 = __webpack_require__(/*! ./utils/shape-template-observer */ "./projects/icons/src/utils/shape-template-observer.ts");
/* CLR-ICON CUSTOM ELEMENT */
var clrIconId = 0;
var offScreenSpan = document.createElement('span');
offScreenSpan.className = 'is-off-screen';
var parentConstructor = function () {
    // eslint-disable-next-line prefer-rest-params
    return HTMLElement.apply(this, arguments);
};
if (typeof Reflect === 'object') {
    parentConstructor = function () {
        // eslint-disable-next-line prefer-rest-params
        return Reflect.construct(HTMLElement, arguments, this.constructor);
    };
}
function ClarityIconElement() {
    'use strict';
    // eslint-disable-next-line prefer-rest-params
    var _instance = parentConstructor.apply(this, arguments);
    _instance.clrIconUniqId = '_clr_icon_' + clrIconId;
    clrIconId++;
    return _instance;
}
exports.ClarityIconElement = ClarityIconElement;
ClarityIconElement.observedAttributes = ['shape', 'size', 'title'];
ClarityIconElement.prototype = Object.create(HTMLElement.prototype, {
    constructor: { configurable: true, writable: true, value: ClarityIconElement },
});
ClarityIconElement.prototype.constructor = ClarityIconElement;
ClarityIconElement.prototype._appendCustomTitle = function () {
    var cloneOffScreenSpan = offScreenSpan.cloneNode(false);
    cloneOffScreenSpan.id = this.clrIconUniqId;
    cloneOffScreenSpan.textContent = this.currentTitleAttrVal;
    this.appendChild(cloneOffScreenSpan);
};
ClarityIconElement.prototype._setIconSize = function (size) {
    if (!Number(size) || Number(size) < 0) {
        this.style.width = null; // fallback to the original stylesheet value
        this.style.height = null; // fallback to the original stylesheet value
    }
    else {
        this.style.width = size + 'px';
        this.style.height = size + 'px';
    }
};
ClarityIconElement.prototype._normalizeShape = function (value) {
    return value.split(/\s/)[0].toLowerCase();
};
ClarityIconElement.prototype.connectedCallback = function () {
    // One thing to note here is that the attributeChangedCallback method is called for every attribute first
    // before this connectedCallback method called only once when the custom element is inserted into the DOM.
    // So we could check whether the attribute values really changed or not.
    // If not, we don't need to execute the same codes again.
    var _this = this;
    // We want to hide the custom element from screen readers but allow the svg/img content to still be read inline
    // Adding role=none allows the screen reader to skip the custom element as if it were a div or span.
    // https://www.scottohara.me/blog/2018/05/05/hidden-vs-none.html
    if (!this.getAttribute('role')) {
        this.setAttribute('role', 'none');
    }
    if (this.hasAttribute('size')) {
        var sizeAttrValue = this.getAttribute('size');
        if (this.currentSizeAttrVal !== sizeAttrValue) {
            this.currentSizeAttrVal = sizeAttrValue;
            this._setIconSize(sizeAttrValue);
        }
    }
    // Note: the size attribute is irrelevant from the shape template;
    // That's why the size checking placed before detecting changes in shape and title attributes.
    // This means even if the shape is not found, the injected shape will have the user-given size.
    if (this.hasAttribute('shape')) {
        var shapeAttrValue = this._normalizeShape(this.getAttribute('shape'));
        this._shapeTemplateSubscription = shape_template_observer_1.ShapeTemplateObserver.instance.subscribeTo(shapeAttrValue, function (updatedTemplate) {
            _this._injectTemplate(updatedTemplate);
        });
        this.currentShapeAttrVal = shapeAttrValue;
        if (clr_icons_api_1.ClarityIconsApi.instance.has(this.currentShapeAttrVal)) {
            var currentShapeTemplate = clr_icons_api_1.ClarityIconsApi.instance.get(this.currentShapeAttrVal);
            if (currentShapeTemplate === this.currentShapeTemplate) {
                return;
            }
            else {
                this.currentShapeTemplate = currentShapeTemplate;
            }
        }
        else {
            this._injectErrorTemplate();
            return;
        }
    }
    if (this.hasAttribute('title')) {
        var titleAttrValue = this.getAttribute('title');
        if (this.currentTitleAttrVal !== titleAttrValue) {
            this.currentTitleAttrVal = titleAttrValue;
        }
        if (!this.currentShapeAttrVal) {
            return;
        }
    }
    this._injectTemplate();
};
ClarityIconElement.prototype.attributeChangedCallback = function (attributeName, _oldValue, newValue) {
    var _this = this;
    if (attributeName === 'size') {
        this._setIconSize(newValue);
    }
    // Note: the size attribute is irrelevant from the shape template;
    // That's why the size checking placed before detecting changes in shape and title attributes.
    // This means even if the shape is not found, the injected shape will have the user-given size.
    if (attributeName === 'shape') {
        this.currentShapeAttrVal = this._normalizeShape(newValue);
        // transfer change handler callback to new shape name
        if (this._shapeTemplateSubscription) {
            // remove the existing change handler callback on the old shape name
            this._shapeTemplateSubscription();
            // create a new subscription on the new shape name
            this._shapeTemplateSubscription = shape_template_observer_1.ShapeTemplateObserver.instance.subscribeTo(this.currentShapeAttrVal, function (updatedTemplate) {
                _this._injectTemplate(updatedTemplate);
            });
        }
        if (clr_icons_api_1.ClarityIconsApi.instance.has(this.currentShapeAttrVal)) {
            this.currentShapeTemplate = clr_icons_api_1.ClarityIconsApi.instance.get(this.currentShapeAttrVal);
        }
        else {
            this._injectErrorTemplate();
            return;
        }
    }
    if (attributeName === 'title') {
        this.currentTitleAttrVal = newValue;
        if (!this.currentShapeAttrVal) {
            return;
        }
    }
    this._injectTemplate();
};
ClarityIconElement.prototype.disconnectedCallback = function () {
    // as the icon element is removed from the DOM,
    // remove its listener callback function as well.
    if (this._shapeTemplateSubscription) {
        this._shapeTemplateSubscription();
    }
};
ClarityIconElement.prototype._setAriaLabelledBy = function () {
    var existingAriaLabelledBy = this.getAttribute('aria-labelledby');
    var svgElement = this.querySelector('svg');
    var elementToSet = svgElement ? svgElement : this;
    if (!existingAriaLabelledBy) {
        elementToSet.setAttribute('aria-labelledby', this.clrIconUniqId);
    }
    else if (existingAriaLabelledBy && existingAriaLabelledBy.indexOf(this.clrIconUniqId) < 0) {
        elementToSet.setAttribute('aria-labelledby', existingAriaLabelledBy + ' ' + this.clrIconUniqId);
    }
};
ClarityIconElement.prototype._injectTemplate = function (shapeTemplate) {
    // Accepting the argument, shapeTemplate, will help us to update the shape template
    // right before the injection.
    if (shapeTemplate && shapeTemplate !== this.currentShapeTemplate) {
        this.currentShapeTemplate = shapeTemplate;
    }
    this.innerHTML = this.currentShapeTemplate;
    if (this.currentTitleAttrVal) {
        this._setAriaLabelledBy();
        this._appendCustomTitle();
    }
};
ClarityIconElement.prototype._injectErrorTemplate = function () {
    this.currentShapeTemplate = clr_icons_api_1.ClarityIconsApi.instance.get('error');
    this._injectTemplate();
};


/***/ }),

/***/ "./projects/icons/src/utils/shape-template-observer.ts":
/*!*************************************************************!*\
  !*** ./projects/icons/src/utils/shape-template-observer.ts ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ShapeTemplateObserver = exports.changeHandlerCallbacks = void 0;
exports.changeHandlerCallbacks = {};
var ShapeTemplateObserver = /** @class */ (function () {
    function ShapeTemplateObserver() {
        this.callbacks = exports.changeHandlerCallbacks;
    }
    Object.defineProperty(ShapeTemplateObserver, "instance", {
        get: function () {
            if (!ShapeTemplateObserver.singleInstance) {
                ShapeTemplateObserver.singleInstance = new ShapeTemplateObserver();
            }
            return ShapeTemplateObserver.singleInstance;
        },
        enumerable: false,
        configurable: true
    });
    ShapeTemplateObserver.prototype.subscribeTo = function (shapeName, changeHandlerCallback) {
        var _this = this;
        if (!this.callbacks[shapeName]) {
            this.callbacks[shapeName] = [changeHandlerCallback];
        }
        else {
            if (this.callbacks[shapeName].indexOf(changeHandlerCallback) === -1) {
                this.callbacks[shapeName].push(changeHandlerCallback);
            }
        }
        // this returned function give users an ability to remove the subscription
        return function () {
            var removeAt = _this.callbacks[shapeName].indexOf(changeHandlerCallback);
            _this.callbacks[shapeName].splice(removeAt, 1);
            // if the array is empty, remove the property from the callbacks
            if (_this.callbacks[shapeName].length === 0) {
                delete _this.callbacks[shapeName];
            }
        };
    };
    ShapeTemplateObserver.prototype.emitChanges = function (shapeName, template) {
        if (this.callbacks[shapeName]) {
            // this will emit changes to all observers
            // by calling their callback functions on template changes
            this.callbacks[shapeName].map(function (changeHandlerCallback) {
                changeHandlerCallback(template);
            });
        }
    };
    return ShapeTemplateObserver;
}());
exports.ShapeTemplateObserver = ShapeTemplateObserver;


/***/ })

/******/ });
});
//# sourceMappingURL=clr-icons-element.js.map