# Accordion

## CSS Custom Properties

| CSS Custom Property                              | Description                                                          |
| ------------------------------------------------ | -------------------------------------------------------------------- |
| --clr-accordion-text-color                       | Text color of the accordion component.                               |
| --clr-accordion-text-color-hover                 | Text color of the accordion header when hovered.                     |
| --clr-accordion-text-color-active                | Text color of the accordion header when active.                      |
| --clr-accordion-text-color-selected              | Text color of the accordion header when selected.                    |
| --clr-accordion-active-background-color          | Background color of the active accordion panel.                      |
| --clr-accordion-content-background-color         | Background color of the accordion content area.                      |
| --clr-accordion-content-color                    | Color of the text in the accordion content area.                     |
| --clr-accordion-content-font-size                | Font size of the text in the accordion content area.                 |
| --clr-accordion-header-background-color          | Background color of the accordion header.                            |
| --clr-accordion-header-disabled-background-color | Background color of the accordion header when disabled.              |
| --clr-accordion-header-hover-background-color    | Background color of the accordion header on hover.                   |
| --clr-accordion-header-active-background-color   | Background color of the accordion header when active.                |
| --clr-accordion-header-font-size                 | Font size of the accordion header                                    |
| --clr-accordion-header-button-font-size          | Font size of the accordion header button                             |
| --clr-accordion-header-button-padding            | Padding surrounded button used for the header.                       |
| --clr-accordion-title-font-weight                | Font weight of the accordion title                                   |
| --clr-accordion-title-font-size                  | Font size of the accordion title                                     |
| --clr-accordion-error-color                      | Color representing an error state in the accordion.                  |
| --clr-accordion-complete-color                   | Color representing a completed state in the accordion.               |
| --clr-accordion-border-color                     | Color of the accordion border.                                       |
| --clr-accordion-border-radius                    | Border radius of the accordion.                                      |
| --clr-accordion-border-left-color                | Color of the left border in the accordion.                           |
| --clr-accordion-border-left-width                | Width of the left border in the accordion.                           |
| --clr-accordion-border-left-color-complete       | Color of the left border in the accordion for the complete state.    |
| --clr-accordion-border-left-color-error          | Color of the left border in the accordion for the error state.       |
| --clr-accordion-header-left-indicator            | Left indicator style for the accordion header.                       |
| --clr-accordion-header-left-current-indicator    | Left indicator style for the accordion header when on current step.  |
| --clr-accordion-header-left-complete-indicator   | Left indicator style for the accordion header in the complete state. |
| --clr-accordion-header-left-error-indicator      | Left indicator style for the accordion header in the error state.    |
| --clr-accordion-header-button-line-height        | Line height of the button used for the header.                       |
| --clr-accordion-header-gap                       | Gap between the icon and title text in the accordion header.         |
| --clr-accordion-status-icon-width                | Width of the icon used for the accordion arrow.                      |
| --clr-accordion-number-padding                   | Padding for the step number.                                         |
| --clr-accordion-step-title-min-width             | Sets the min-width for the step title.                               |
| --clr-accordion-step-title-font-weight           | Font weight for the step title and number.                           |
| --clr-accordion-header-font-size                 | Header font size.                                                    |
| --clr-accordion-step-status-margin-left          | Left margin of the status container                                  |
| --clr-accordion-step-title-margin-left           | Left margin of the title container                                   |

## CSS Classes

| Class Name                           | Description                                           |
| ------------------------------------ | ----------------------------------------------------- |
| clr-accordion                        | Accordion component.                                  |
| clr-accordion-panel                  | Panel within the accordion.                           |
| clr-accordion-header                 | Header section of an accordion panel.                 |
| clr-accordion-number                 | Number or step indicator within the accordion.        |
| clr-accordion-header-button          | Clickable button within the accordion header.         |
| clr-accordion-status                 | Status indicator within the accordion header.         |
| clr-accordion-title                  | Title text within the accordion header.               |
| clr-accordion-header-has-description | Accordion header with a description.                  |
| clr-accordion-description            | Description text within the accordion header.         |
| clr-accordion-content                | Content section of an accordion panel.                |
| clr-accordion-content-region         | Content region section of an accordion panel.         |
| clr-accordion-inner-content          | Inner content section within the accordion content.   |
| clr-accordion-angle                  | Angle or arrow indicator within the accordion header. |
| clr-accordion-error-icon             | Error icon within the accordion header.               |
| clr-accordion-complete-icon          | Complete icon within the accordion header.            |
| clr-accordion-panel-open             | Open or expanded accordion panel.                     |
| clr-accordion-panel-complete         | Complete state of an accordion panel.                 |
| clr-accordion-panel-error            | Error state of an accordion panel.                    |
| clr-accordion-panel-disabled         | Disabled state of an accordion panel.                 |
| clr-stepper-forms                    | Stepper forms mode for the accordion.                 |
| clr-step-button                      | Step button within the accordion.                     |

# Alert

## CSS Custom Properties

| CSS Custom Property                              | Description                                                       |
| ------------------------------------------------ | ----------------------------------------------------------------- |
| --clr-alert-action-color                         | Alerts action default font color                                  |
| --clr-alert-action-active-color                  | Alerts action default font color on focus, hover, active          |
| --clr-alert-close-icon-color                     | Close icon default color                                          |
| --clr-alert-close-icon-hover-color               | Close icon default color on hover                                 |
| --clr-alert-close-icon-opacity                   | Close icon default opacity                                        |
| --clr-alert-close-icon-hover-opacity             | Close icon default opacity on hover                               |
| --clr-app-level-alert-color                      | Default font color for app level alerts                           |
| --clr-app-alert-close-icon-color                 | Close icon default color for app level alerts                     |
| --clr-app-alert-close-icon-opacity               | Close icon default opacity for app level alerts                   |
| --clr-app-alert-close-icon-hover-opacity         | Close icon default opacity on hover for app level alerts          |
| --clr-alert-borderradius                         | Border radius                                                     |
| --clr-alert-info-bg-color                        | Info alert background color                                       |
| --clr-alert-info-font-color                      | Info alert font color                                             |
| --clr-alert-info-border-color                    | Info alert border color                                           |
| --clr-alert-info-icon-color                      | Info alert icon color                                             |
| --clr-alert-info-action-color                    | Info alert action font color                                      |
| --clr-alert-info-action-active-color             | Info alert action font color on focus, hover, active              |
| --clr-alert-info-close-icon-color                | Info alert close icon color                                       |
| --clr-alert-info-close-icon-opacity              | Info alert close icon opacity                                     |
| --clr-alert-info-close-icon-hover-color          | Info alert close icon color on hover                              |
| --clr-alert-info-close-icon-hover-opacity        | Info alert close icon opacity on hover                            |
| --clr-alert-success-bg-color                     | Info alert background color                                       |
| --clr-alert-success-font-color                   | Info alert font color                                             |
| --clr-alert-success-border-color                 | Info alert border color                                           |
| --clr-alert-success-icon-color                   | Info alert icon color                                             |
| --clr-alert-success-action-color                 | Success alert action font color                                   |
| --clr-alert-success-action-active-color          | Success alert action font color on focus, hover, active           |
| --clr-alert-success-close-icon-color             | Success alert close icon color                                    |
| --clr-alert-success-close-icon-opacity           | Success alert close icon opacity                                  |
| --clr-alert-success-close-icon-hover-color       | Success alert close icon color on hover                           |
| --clr-alert-success-close-icon-hover-opacity     | Success alert close icon opacity on hover                         |
| --clr-alert-warning-bg-color                     | Info alert background color                                       |
| --clr-alert-warning-font-color                   | Info alert font color                                             |
| --clr-alert-warning-border-color                 | Info alert border color                                           |
| --clr-alert-warning-icon-color                   | Info alert icon color                                             |
| --clr-alert-warning-action-color                 | Warning alert action font color                                   |
| --clr-alert-warning-action-active-color          | Warning alert action font color on focus, hover, active           |
| --clr-alert-warning-close-icon-color             | Warning alert close icon color                                    |
| --clr-alert-warning-close-icon-opacity           | Warning alert close icon opacity                                  |
| --clr-alert-warning-close-icon-hover-color       | Warning alert close icon color on hover                           |
| --clr-alert-warning-close-icon-hover-opacity     | Warning alert close icon opacity on hover                         |
| --clr-alert-danger-bg-color                      | Info alert background color                                       |
| --clr-alert-danger-font-color                    | Info alert font color                                             |
| --clr-alert-danger-border-color                  | Info alert border color                                           |
| --clr-alert-danger-icon-color                    | Info alert icon color                                             |
| --clr-alert-danger-action-color                  | Danger alert action font color                                    |
| --clr-alert-danger-action-active-color           | Danger alert action font color on focus, hover, active            |
| --clr-alert-danger-close-icon-color              | Danger alert close icon color                                     |
| --clr-alert-danger-close-icon-opacity            | Danger alert close icon opacity                                   |
| --clr-alert-danger-close-icon-hover-color        | Danger alert close icon color on hover                            |
| --clr-alert-danger-close-icon-hover-opacity      | Danger alert close icon opacity on hover                          |
| --clr-app-alert-info-bg-color                    | App level info alert background color                             |
| --clr-app-alert-info-font-color                  | App level info alert font color                                   |
| --clr-app-alert-info-border-color                | App level info alert border color                                 |
| --clr-app-alert-info-icon-color                  | App level info alert icon color                                   |
| --clr-app-alert-info-action-color                | App level info alert action font color                            |
| --clr-app-alert-info-action-active-color         | App level info alert action font color on focus, hover, active    |
| --clr-app-alert-info-close-icon-color            | App level info alert close icon color                             |
| --clr-app-alert-info-close-icon-opacity          | App level info alert close icon opacity                           |
| --clr-app-alert-info-close-icon-hover-color      | App level info alert close icon color on hover                    |
| --clr-app-alert-info-close-icon-hover-opacity    | App level info alert close icon opacity on hover                  |
| --clr-app-alert-warning-bg-color                 | App level warning alert background color                          |
| --clr-app-alert-warning-border-color             | App level warning alert border color                              |
| --clr-app-alert-warning-icon-color               | App level warning alert icon color                                |
| --clr-app-alert-warning-font-color               | App level warning alert font color                                |
| --clr-app-alert-warning-action-color             | App level warning alert action font color                         |
| --clr-app-alert-warning-action-active-color      | App level warning alert action font color on focus, hover, active |
| --clr-app-alert-warning-close-icon-color         | App level info alert close icon color                             |
| --clr-app-alert-warning-close-icon-opacity       | App level info alert close icon opacity                           |
| --clr-app-alert-warning-close-icon-hover-color   | App level info alert close icon color on hover                    |
| --clr-app-alert-warning-close-icon-hover-opacity | App level info alert close icon opacity on hover                  |
| --clr-app-alert-danger-bg-color                  | App level danger alert background color                           |
| --clr-app-alert-danger-border-color              | App level danger alert border color                               |
| --clr-app-alert-danger-icon-color                | App level danger alert icon color                                 |
| --clr-app-alert-danger-font-color                | App level danger alert font color                                 |
| --clr-app-alert-danger-action-color              | App level danger alert action font color                          |
| --clr-app-alert-danger-action-active-color       | App level danger alert action font color on focus, hover, active  |
| --clr-app-alert-danger-close-icon-color          | App level info alert close icon color                             |
| --clr-app-alert-danger-close-icon-opacity        | App level info alert close icon opacity                           |
| --clr-app-alert-danger-close-icon-hover-color    | App level info alert close icon color on hover                    |
| --clr-app-alert-danger-close-icon-hover-opacity  | App level info alert close icon opacity on hover                  |
| --clr-app-alert-success-border-color             | App level success alert border color                              |
| --clr-app-alert-success-bg-color                 | App level success alert background color                          |
| --clr-app-alert-success-icon-color               | App level success alert icon color                                |
| --clr-app-alert-success-font-color               | App level success alert font color                                |
| --clr-app-alert-success-action-color             | App level success alert action font color                         |
| --clr-app-alert-success-action-active-color      | App level success alert action font color on focus, hover, active |
| --clr-app-alert-success-close-icon-color         | App level info alert close icon color                             |
| --clr-app-alert-success-close-icon-opacity       | App level info alert close icon opacity                           |
| --clr-app-alert-success-close-icon-hover-color   | App level info alert close icon color on hover                    |
| --clr-app-alert-success-close-icon-hover-opacity | App level info alert close icon opacity on hover                  |
| --clr-app-alert-pager-text-color                 | Alert pager default font color                                    |
| --clr-app-alert-info-pager-bg-color              | Info alert pager font color                                       |
| --clr-app-alert-warning-pager-bg-color           | Warning alert pager font color                                    |
| --clr-app-alert-danger-pager-bg-color            | Danger alert pager font color                                     |
| --clr-app-alert-success-pager-bg-color           | Danger success pager font color                                   |
| --clr-alert-padding                              | Padding of the alert                                              |
| --clr-alert-borderradius                         | Alert border radius                                               |
| --clr-alert-actions-spacing                      | Alert actions spacing                                             |
| --clr-alert-item-margin-bottom                   | Alert item margin bottom                                          |
| --clr-alert-line-height                          | Alert line height                                                 |
| --clr-alert-sm-line-height                       | Alert small line height                                           |
| --clr-alert-app-padding                          | App level alert padding                                           |
| --clr-alert-items-gap                            | Gap between items in the alert                                    |
| --clr-alert-sm-line-height                       | Small alert line height                                           |
| --clr-alert-sm-font-size                         | Small alert font size                                             |
| --clr-alert-sm-letter-spacing                    | Small alert letter spacing                                        |
| --clr-alert-sm-font-weight                       | Small alert font weight                                           |
| --clr-alert-sm-icon-size                         | Small alert icon size                                             |
| --clr-lightweight-alert-info-icon-color          | Lightweight alert info icon color                                 |
| --clr-lightweight-alert-info-font-color          | Lightweight alert info font color                                 |
| --clr-lightweight-alert-warning-icon-color       | Lightweight alert warning icon color                              |
| --clr-lightweight-alert-warning-font-color       | Lightweight alert warning font color                              |
| --clr-lightweight-alert-danger-icon-color        | Lightweight alert danger icon color                               |
| --clr-lightweight-alert-danger-font-color        | Lightweight alert danger font color                               |
| --clr-lightweight-alert-success-icon-color       | Lightweight alert success icon color                              |
| --clr-lightweight-alert-success-font-color       | Lightweight alert success font color                              |
| --clr-alert-font-size                            | Font size for alert                                               |
| --clr-alert-lightweight-font-size                | Font size for lightweight alerts                                  |
| --clr-alert-lightweight-line-height              | Line height for lightweight alerts                                |
| --clr-alert-lightweight-sm-font-size             | Font size for small lightweight alerts                            |
| --clr-alert-lightweight-sm-line-height           | Line height for small lightweight alerts                          |

## CSS Classes

| Class name           | Description                                                                |
| -------------------- | -------------------------------------------------------------------------- |
| alert                | Main alert element                                                         |
| alert-info           | Addition to `alert` class to present it as info alert                      |
| alert-success        | Addition to `alert` class to present it as success alert                   |
| alert-warning        | Addition to `alert` class to present it as warning alert                   |
| alert-danger         | Addition to `alert` class to present it as danger alert                    |
| alert-app-level      | Addition to `alert` class to present it as app-level alert                 |
| alert-items          | Wrapper for elements with class `alert-item`                               |
| alert-item           | Element for messages in alert                                              |
| alert-text           | Text inside alert items                                                    |
| alert-actions        | Wrapper for actions                                                        |
| alert-action         | Action element                                                             |
| close                | Close element `X`                                                          |
| alert-icon           | Icon used in alert items                                                   |
| alert-icon-wrapper   | Wrapper for icons                                                          |
| alert-sm             | Alert with a smaller size                                                  |
| alert-hidden         | Hide alert                                                                 |
| alerts               | Main alerts element \*should be used with `alert-info` or equivalent class |
| alerts-pager         | Alerts pager element                                                       |
| alerts-pager-button  | Pager button                                                               |
| alerts-pager-control | Pager controls wrapper                                                     |
| alerts-page-down     | Page down wrapper                                                          |
| alerts-page-up       | Page up wrapper                                                            |
| alerts-pager-text    | Page identifier in pager                                                   |

# Badge

## CSS Custom Properties

| CSS Custom Property             | Description                       |
| ------------------------------- | --------------------------------- |
| --clr-badge-background-color    | Background color                  |
| --clr-badge-color               | Font color                        |
| --clr-badge-info-bg-color       | Info badge background color       |
| --clr-badge-info-color          | Info badge text color             |
| --clr-badge-success-bg-color    | Success badge background color    |
| --clr-badge-success-color       | Success badge text color          |
| --clr-badge-warning-bg-color    | Warning badge background color    |
| --clr-badge-warning-color       | Warning badge text color          |
| --clr-badge-danger-bg-color     | Danger badge background color     |
| --clr-badge-danger-color        | Danger badge text color           |
| --clr-badge-gray-bg-color       | Gray badge background color       |
| --clr-badge-gray-color          | Gray badge text color             |
| --clr-badge-purple-bg-color     | Purple badge background color     |
| --clr-badge-purple-color        | Purple badge text color           |
| --clr-badge-blue-bg-color       | Blue badge background color       |
| --clr-badge-blue-color          | Blue badge text color             |
| --clr-badge-orange-bg-color     | Orange badge background color     |
| --clr-badge-orange-color        | Orange badge text color           |
| --clr-badge-light-blue-bg-color | Light-blue badge background color |
| --clr-badge-light-blue-color    | Light-blue badge text color       |
| --clr-badge-padding             | Padding                           |
| --clr-badge-height              | Height                            |
| --clr-badge-min-width           | Min width                         |
| --clr-badge-border-radius       | Border radius                     |
| --clr-badge-font-size           | Font size                         |
| --clr-badge-font-weight         | Font weight                       |
| --clr-badge-letter-spacing      | Letter spacing                    |
| --clr-badge-line-height         | Line height                       |
| --clr-badge-font-family         | Font family                       |

## CSS Classes

| Class name       | Description                                                         |
| ---------------- | ------------------------------------------------------------------- |
| badge            | Main badge element. All of the following require this class as well |
| badge-info       | Info badge                                                          |
| badge-success    | Success badge                                                       |
| badge-danger     | Danger badge                                                        |
| badge-warning    | Warning badge                                                       |
| badge-gray       | Gray badge                                                          |
| badge-purple     | Purple badge                                                        |
| badge-blue       | Blue badge                                                          |
| badge-orange     | Orange badge                                                        |
| badge-light-blue | Light-blue badge                                                    |

# Button

## CSS Custom Properties

| CSS Custom Property                             | Description                                                                |
| ----------------------------------------------- | -------------------------------------------------------------------------- |
| --clr-btn-vertical-margin                       | Button top and bottom margin                                               |
| --clr-btn-horizontal-margin                     | Button left and right margin                                               |
| --clr-btn-vertical-padding                      | Button top and bottom padding                                              |
| --clr-btn-horizontal-padding                    | Button left and right padding                                              |
| --clr-btn-padding                               | Button padding                                                             |
| --clr-btn-height                                | Button height                                                              |
| --clr-btn-height-sm                             | Small button height                                                        |
| --clr-btn-font-weight                           | Button text font weight                                                    |
| --clr-btn-border-radius                         | Button border radius                                                       |
| --clr-btn-border-width                          | Button border width                                                        |
| --clr-btn-outline-bg-color                      | Default outline button background color                                    |
| --clr-btn-default-color                         | Default button text color                                                  |
| --clr-btn-default-bg-color                      | Default button background color                                            |
| --clr-btn-default-border-color                  | Default button border color                                                |
| --clr-btn-default-hover-color                   | Default button `:hover` text color                                         |
| --clr-btn-default-hover-bg-color                | Default button `:hover` background color                                   |
| --clr-btn-default-active-color                  | Default button `:active` text color                                        |
| --clr-btn-default-active-bg-color               | Default button `:active` background color                                  |
| --clr-btn-default-disabled-color                | Default button `disabled` text color                                       |
| --clr-btn-default-disabled-bg-color             | Default button `disabled` background color                                 |
| --clr-btn-default-disabled-border-color         | Default button `disabled` border color                                     |
| --clr-btn-default-outline-color                 | Default outline button text color                                          |
| --clr-btn-default-outline-bg-color              | Default outline button background color                                    |
| --clr-btn-default-outline-border-color          | Default outline button border color                                        |
| --clr-btn-default-outline-hover-color           | Default outline button `:hover` text color                                 |
| --clr-btn-default-outline-hover-bg-color        | Default outline button `:hover` background color                           |
| --clr-btn-default-outline-active-color          | Default outline button `:active` text color                                |
| --clr-btn-default-outline-active-bg-color       | Default outline button `:active` background color                          |
| --clr-btn-default-outline-disabled-color        | Default outline button `disabled` text color                               |
| --clr-btn-default-outline-disabled-bg-color     | Default outline button `disabled` background color                         |
| --clr-btn-default-outline-disabled-border-color | Default outline button `disabled` border color                             |
| --clr-btn-primary-color                         | Primary button text color                                                  |
| --clr-btn-primary-bg-color                      | Primary button background color                                            |
| --clr-btn-primary-border-color                  | Primary button border color                                                |
| --clr-btn-primary-hover-color                   | Primary button `:hover` text color                                         |
| --clr-btn-primary-hover-bg-color                | Primary button `:hover` background color                                   |
| --clr-btn-primary-active-color                  | Primary button `:active` text color                                        |
| --clr-btn-primary-active-bg-color               | Primary button `:active` background color                                  |
| --clr-btn-primary-disabled-color                | Primary button `disabled` text color                                       |
| --clr-btn-primary-disabled-bg-color             | Primary button `disabled` background color                                 |
| --clr-btn-primary-disabled-border-color         | Primary button `disabled` border color                                     |
| --clr-btn-primary-outline-color                 | Primary outline button text color                                          |
| --clr-btn-primary-outline-bg-color              | Primary outline button background color                                    |
| --clr-btn-primary-outline-border-color          | Primary outline button border color                                        |
| --clr-btn-primary-outline-hover-color           | Primary outline button `:hover` text color                                 |
| --clr-btn-primary-outline-hover-bg-color        | Primary outline button `:hover` background color                           |
| --clr-btn-primary-outline-active-color          | Primary outline button `:active` text color                                |
| --clr-btn-primary-outline-active-bg-color       | Primary outline button `:active` background color                          |
| --clr-btn-primary-outline-disabled-color        | Primary outline button `disabled` text color                               |
| --clr-btn-primary-outline-disabled-bg-color     | Primary outline button `disabled` background color                         |
| --clr-btn-primary-outline-disabled-border-color | Primary outline button `disabled` border color                             |
| --clr-btn-success-color                         | Success button text color                                                  |
| --clr-btn-success-bg-color                      | Success button background color                                            |
| --clr-btn-success-border-color                  | Success button border color                                                |
| --clr-btn-success-hover-color                   | Success button `:hover` text color                                         |
| --clr-btn-success-hover-bg-color                | Success button `:hover` background color                                   |
| --clr-btn-success-active-color                  | Success button `:active` text color                                        |
| --clr-btn-success-active-bg-color               | Success button `:active` background color                                  |
| --clr-btn-success-disabled-color                | Success button `disabled` text color                                       |
| --clr-btn-success-disabled-bg-color             | Success button `disabled` background color                                 |
| --clr-btn-success-disabled-border-color         | Success button `disabled` border color                                     |
| --clr-btn-success-outline-color                 | Success outline button text color                                          |
| --clr-btn-success-outline-bg-color              | Success outline button background color                                    |
| --clr-btn-success-outline-border-color          | Success outline button border color                                        |
| --clr-btn-success-outline-hover-color           | Success outline button `:hover` text color                                 |
| --clr-btn-success-outline-hover-bg-color        | Success outline button `:hover` background color                           |
| --clr-btn-success-outline-active-color          | Success outline button `:active` text color                                |
| --clr-btn-success-outline-active-bg-color       | Success outline button `:active` background color                          |
| --clr-btn-success-outline-disabled-color        | Success outline button `disabled` text color                               |
| --clr-btn-success-outline-disabled-bg-color     | Success outline button `disabled` background color                         |
| --clr-btn-success-outline-disabled-border-color | Success outline button `disabled` border color                             |
| --clr-btn-danger-color                          | Danger button text color                                                   |
| --clr-btn-danger-bg-color                       | Danger button background color                                             |
| --clr-btn-danger-border-color                   | Danger button border color                                                 |
| --clr-btn-danger-hover-color                    | Danger button `:hover` text color                                          |
| --clr-btn-danger-hover-bg-color                 | Danger button `:hover` background color                                    |
| --clr-btn-danger-active-color                   | Danger button `:active` text color                                         |
| --clr-btn-danger-active-bg-color                | Danger button `:active` background color                                   |
| --clr-btn-danger-disabled-color                 | Danger button `disabled` text color                                        |
| --clr-btn-danger-disabled-bg-color              | Danger button `disabled` background color                                  |
| --clr-btn-danger-disabled-border-color          | Danger button `disabled` border color                                      |
| --clr-btn-danger-outline-color                  | Danger outline button text color                                           |
| --clr-btn-danger-outline-bg-color               | Danger outline button background color                                     |
| --clr-btn-danger-outline-border-color           | Danger outline button border color                                         |
| --clr-btn-danger-outline-hover-color            | Danger outline button `:hover` text color                                  |
| --clr-btn-danger-outline-hover-bg-color         | Danger outline button `:hover` background color                            |
| --clr-btn-danger-outline-active-color           | Danger outline button `:active` text color                                 |
| --clr-btn-danger-outline-active-bg-color        | Danger outline button `:active` background color                           |
| --clr-btn-danger-outline-disabled-color         | Danger outline button `disabled` text color                                |
| --clr-btn-danger-outline-disabled-bg-color      | Danger outline button `disabled` background color                          |
| --clr-btn-danger-outline-disabled-border-color  | Danger outline button `disabled` border color                              |
| --clr-btn-warning-color                         | Warning button text color                                                  |
| --clr-btn-warning-bg-color                      | Warning button background color                                            |
| --clr-btn-warning-border-color                  | Warning button border color                                                |
| --clr-btn-warning-hover-color                   | Warning button `:hover` text color                                         |
| --clr-btn-warning-hover-bg-color                | Warning button `:hover` background color                                   |
| --clr-btn-warning-active-color                  | Warning button `:active` text color                                        |
| --clr-btn-warning-active-bg-color               | Warning button `:active` background color                                  |
| --clr-btn-warning-disabled-color                | Warning button `disabled` text color                                       |
| --clr-btn-warning-disabled-bg-color             | Warning button `disabled` background color                                 |
| --clr-btn-warning-disabled-border-color         | Warning button `disabled` border color                                     |
| --clr-btn-warning-outline-color                 | Warning outline button text color                                          |
| --clr-btn-warning-outline-bg-color              | Warning outline button background color                                    |
| --clr-btn-warning-outline-border-color          | Warning outline button border color                                        |
| --clr-btn-warning-outline-hover-color           | Warning outline button `:hover` text color                                 |
| --clr-btn-warning-outline-hover-bg-color        | Warning outline button `:hover` background color                           |
| --clr-btn-warning-outline-active-color          | Warning outline button `:active` text color                                |
| --clr-btn-warning-outline-active-bg-color       | Warning outline button `:active` background color                          |
| --clr-btn-warning-outline-disabled-color        | Warning outline button `disabled` text color                               |
| --clr-btn-warning-outline-disabled-bg-color     | Warning outline button `disabled` background color                         |
| --clr-btn-warning-outline-disabled-border-color | Warning outline button `disabled` border color                             |
| --clr-btn-neutral-color                         | Neutral button text color                                                  |
| --clr-btn-neutral-bg-color                      | Neutral button background color                                            |
| --clr-btn-neutral-border-color                  | Neutral button border color                                                |
| --clr-btn-neutral-hover-color                   | Neutral button `:hover` text color                                         |
| --clr-btn-neutral-hover-bg-color                | Neutral button `:hover` background color                                   |
| --clr-btn-neutral-active-color                  | Neutral button `:active` text color                                        |
| --clr-btn-neutral-active-bg-color               | Neutral button `:active` background color                                  |
| --clr-btn-neutral-disabled-color                | Neutral button `disabled` text color                                       |
| --clr-btn-neutral-disabled-bg-color             | Neutral button `disabled` background color                                 |
| --clr-btn-neutral-disabled-border-color         | Neutral button `disabled` border color                                     |
| --clr-btn-neutral-outline-color                 | Neutral outline button text color                                          |
| --clr-btn-neutral-outline-bg-color              | Neutral outline button background color                                    |
| --clr-btn-neutral-outline-border-color          | Neutral outline button border color                                        |
| --clr-btn-neutral-outline-hover-color           | Neutral outline button `:hover` text color                                 |
| --clr-btn-neutral-outline-hover-bg-color        | Neutral outline button `:hover` background color                           |
| --clr-btn-neutral-outline-active-color          | Neutral outline button `:active` text color                                |
| --clr-btn-neutral-outline-active-bg-color       | Neutral outline button `:active` background color                          |
| --clr-btn-neutral-outline-disabled-color        | Neutral outline button `disabled` text color                               |
| --clr-btn-neutral-outline-disabled-bg-color     | Neutral outline button `disabled` background color                         |
| --clr-btn-neutral-outline-disabled-border-color | Neutral outline button `disabled` border color                             |
| --clr-btn-link-color                            | Link button text color                                                     |
| --clr-btn-link-bg-color                         | Link button background color                                               |
| --clr-btn-link-border-color                     | Link button border color                                                   |
| --clr-btn-link-hover-color                      | Link button `:hover` text color                                            |
| --clr-btn-link-hover-bg-color                   | Link button `:hover` background color                                      |
| --clr-btn-link-active-color                     | Link button `:active` text color                                           |
| --clr-btn-link-active-bg-color                  | Link button `:active` background color                                     |
| --clr-btn-link-disabled-color                   | Link button `disabled` text color                                          |
| --clr-btn-link-disabled-bg-color                | Link button `disabled` background color                                    |
| --clr-btn-link-disabled-border-color            | Link button `disabled` border color                                        |
| --clr-btn-link-primary-color                    | Primary link button text color                                             |
| --clr-btn-link-primary-bg-color                 | Primary link button background color                                       |
| --clr-btn-link-primary-border-color             | Primary link button border color                                           |
| --clr-btn-link-primary-hover-color              | Primary link button `:hover` text color                                    |
| --clr-btn-link-primary-hover-bg-color           | Primary link button `:hover` background color                              |
| --clr-btn-link-primary-active-color             | Primary link button `:active` text color                                   |
| --clr-btn-link-primary-active-bg-color          | Primary link button `:active` background color                             |
| --clr-btn-link-primary-disabled-color           | Primary link button `disabled` text color                                  |
| --clr-btn-link-primary-disabled-bg-color        | Primary link button `disabled` background color                            |
| --clr-btn-link-primary-disabled-border-color    | Primary link button `disabled` border color                                |
| --clr-btn-link-success-color                    | Success link button text color                                             |
| --clr-btn-link-success-bg-color                 | Success link button background color                                       |
| --clr-btn-link-success-border-color             | Success link button border color                                           |
| --clr-btn-link-success-hover-color              | Success link button `:hover` text color                                    |
| --clr-btn-link-success-hover-bg-color           | Success link button `:hover` background color                              |
| --clr-btn-link-success-active-color             | Success link button `:active` text color                                   |
| --clr-btn-link-success-active-bg-color          | Success link button `:active` background color                             |
| --clr-btn-link-success-disabled-color           | Success link button `disabled` text color                                  |
| --clr-btn-link-success-disabled-bg-color        | Success link button `disabled` background color                            |
| --clr-btn-link-success-disabled-border-color    | Success link button `disabled` border color                                |
| --clr-btn-link-warning-color                    | Warning link button text color                                             |
| --clr-btn-link-warning-bg-color                 | Warning link button background color                                       |
| --clr-btn-link-warning-border-color             | Warning link button border color                                           |
| --clr-btn-link-warning-hover-color              | Warning link button `:hover` text color                                    |
| --clr-btn-link-warning-hover-bg-color           | Warning link button `:hover` background color                              |
| --clr-btn-link-warning-active-color             | Warning link button `:active` text color                                   |
| --clr-btn-link-warning-active-bg-color          | Warning link button `:active` background color                             |
| --clr-btn-link-warning-disabled-color           | Warning link button `disabled` text color                                  |
| --clr-btn-link-warning-disabled-bg-color        | Warning link button `disabled` background color                            |
| --clr-btn-link-warning-disabled-border-color    | Warning link button `disabled` border color                                |
| --clr-btn-link-danger-color                     | Danger link button text color                                              |
| --clr-btn-link-danger-bg-color                  | Danger link button background color                                        |
| --clr-btn-link-danger-border-color              | Danger link button border color                                            |
| --clr-btn-link-danger-hover-color               | Danger link button `:hover` text color                                     |
| --clr-btn-link-danger-hover-bg-color            | Danger link button `:hover` background color                               |
| --clr-btn-link-danger-active-color              | Danger link button `:active` text color                                    |
| --clr-btn-link-danger-active-bg-color           | Danger link button `:active` background color                              |
| --clr-btn-link-danger-disabled-color            | Danger link button `disabled` text color                                   |
| --clr-btn-link-danger-disabled-bg-color         | Danger link button `disabled` background color                             |
| --clr-btn-link-danger-disabled-border-color     | Danger link button `disabled` border color                                 |
| --clr-btn-inverse-color                         | Inverse button text color                                                  |
| --clr-btn-inverse-bg-color                      | Inverse button background color                                            |
| --clr-btn-inverse-border-color                  | Inverse button border color                                                |
| --clr-btn-inverse-hover-color                   | Inverse button `:hover` text color                                         |
| --clr-btn-inverse-hover-bg-color                | Inverse button `:hover` background color                                   |
| --clr-btn-inverse-active-color                  | Inverse button `:active` text color                                        |
| --clr-btn-inverse-active-bg-color               | Inverse button `:active` background color                                  |
| --clr-btn-inverse-disabled-color                | Inverse button `disabled` text color                                       |
| --clr-btn-inverse-disabled-bg-color             | Inverse button `disabled` background color                                 |
| --clr-btn-inverse-disabled-border-color         | Inverse button `disabled` border color                                     |
| --clr-btn-icon-disabled-color                   | Icon button `disabled` text color                                          |
| --clr-btn-group-focus-outline                   | `:focus` outline color of a checkbox or radio inside a button group button |
| --clr-btn-default-checked-color                 | Checked checkbox default button text color                                 |
| --clr-btn-default-checked-bg-color              | Checked checkbox default button background color                           |
| --clr-btn-default-outline-checked-color         | Checked checkbox default outline button text color                         |
| --clr-btn-default-outline-checked-bg-color      | Checked checkbox default outline button background color                   |
| --clr-btn-primary-checked-color                 | Checked checkbox primary button text color                                 |
| --clr-btn-primary-checked-bg-color              | Checked checkbox primary button background color                           |
| --clr-btn-success-checked-color                 | Checked checkbox success button text color                                 |
| --clr-btn-success-checked-bg-color              | Checked checkbox success button background color                           |
| --clr-btn-success-outline-checked-color         | Checked checkbox success outline button text color                         |
| --clr-btn-success-outline-checked-bg-color      | Checked checkbox success outline button background color                   |
| --clr-btn-danger-checked-color                  | Checked checkbox danger button text color                                  |
| --clr-btn-danger-checked-bg-color               | Checked checkbox danger button background color                            |
| --clr-btn-danger-outline-checked-color          | Checked checkbox danger outline button text color                          |
| --clr-btn-danger-outline-checked-bg-color       | Checked checkbox danger outline button background color                    |
| --clr-btn-warning-checked-color                 | Checked checkbox warning button text color                                 |
| --clr-btn-warning-checked-bg-color              | Checked checkbox warning button background color                           |
| --clr-btn-warning-outline-checked-color         | Checked checkbox warning outline button text color                         |
| --clr-btn-warning-outline-checked-bg-color      | Checked checkbox warning outline button background color                   |
| --clr-btn-link-checked-color                    | Checked checkbox link button text color                                    |
| --clr-btn-link-checked-bg-color                 | Checked checkbox link button background color                              |
| --clr-btn-inverse-checked-color                 | Checked checkbox inverse button text color                                 |
| --clr-btn-inverse-checked-bg-color              | Checked checkbox inverse button background color                           |

## CSS Classes

| Class name          | Description                                            |
| ------------------- | ------------------------------------------------------ |
| btn                 | Button All of the following require this class as well |
| btn-info            | Info button                                            |
| btn-primary         | Primary button                                         |
| btn-success         | Success button                                         |
| btn-warning         | Warning button                                         |
| btn-danger          | Danger button                                          |
| btn-neutral         | Neutral button                                         |
| btn-outline         | Outline button                                         |
| btn-info-outline    | Outline info button                                    |
| btn-success-outline | Outline success button                                 |
| btn-warning-outline | Outline warning button                                 |
| btn-danger-outline  | Outline danger button                                  |
| btn-neutral-outline | Outline neutral button                                 |
| btn-sm              | Small button                                           |
| btn-block           | Block, full-width button                               |
| btn-inverse         | Inverse button                                         |
| btn-icon            | Icon button                                            |
| btn-link            | Link button                                            |
| btn-link-primary    | Link primary button                                    |
| btn-link-success    | Link success button                                    |
| btn-link-warning    | Link warning button                                    |
| btn-link-danger     | Link danger button                                     |

# Button group

## CSS Classes

| Class name            | Description                                                                                                |
| --------------------- | ---------------------------------------------------------------------------------------------------------- |
| btn-group             | Button group element class.                                                                                |
| btn-group-overflow    | Overflow class for button group element.                                                                   |
| btn-link              | Used with `btn-group` for flat buttons group.                                                              |
| btn-icon-link         | Used with `btn-group` and `btn-link` for flat icon buttons group.                                          |
| clr-icon-title        | Button icon title. Visible inside a menu and hidden outside for a11y so it can be read from screen reader. |
| clr-button-group-menu | Internal class for button group menu content.                                                              |

# Card

## CSS Custom Properties

| CSS Custom Property                   | Description                      |
| ------------------------------------- | -------------------------------- |
| --clr-card-bg-color                   | Card background color            |
| --clr-card-divider-color              | Card divider color               |
| --clr-card-title-color                | Card text color header           |
| --clr-card-title-font-weight          | Card thickness title             |
| --clr-card-border-width               | Card border width                |
| --clr-card-border-radius              | Card border radius               |
| --clr-card-border-color               | Card border color                |
| --clr-card-box-shadow-color           | Card background shadow color     |
| --clr-card-clickable-border-color     | Clickable cards background color |
| --clr-card-clickable-box-shadow-color | Clickable cards shadow color     |

## CSS Classes

| Class                  | Description                                                                                                                   |
| ---------------------- | ----------------------------------------------------------------------------------------------------------------------------- |
| card                   | A card presents high-level information and can guide the user toward related actions and details                              |
| clickable              | Adding the `.clickable` to a card class makes the entire card clickable, initiating a single action                           |
| card-img               | A `.card-img` can be placed anywhere in the card, or it can occupy the entire card                                            |
| card-header            | The card's heading element                                                                                                    |
| card-block             | The card's main content                                                                                                       |
| card-title             | A card block's heading element                                                                                                |
| card-text              | A card block's text content                                                                                                   |
| list                   | An ordered (`ol`) or unordered (`ul`) list within a card block                                                                |
| list-unstyled          | List with no markers within a card block                                                                                      |
| list-group             | Full-width list with dividers for each item within a card block                                                               |
| list-group-item        | Item within a list group                                                                                                      |
| card-divider           | Divider within card block                                                                                                     |
| card-media-block       | A card media block contains and image and description                                                                         |
| wrap                   | Adding the `wrap` class to a `.card-media-block` element causes the description to be below the image instead of to the right |
| card-media-image       | An `img` within a card media block                                                                                            |
| card-media-description | The description within a card media block. It can contain a title and text                                                    |
| card-media-title       | The title of a card media block description                                                                                   |
| card-media-text        | Text within a card media block description                                                                                    |
| card-footer            | The footer can contain two actions in form of a button or link. For more actions, use a dropdown                              |
| card-link              | A link within a card footer                                                                                                   |

# Checkbox

## CSS Custom Properties

| CSS Custom Property                             | Description                                |
| ----------------------------------------------- | ------------------------------------------ |
| --clr-forms-checkbox-label-color                | Font color of checkbox label               |
| --clr-forms-checkbox-background-color           | Background color of checkbox               |
| --clr-forms-checkbox-indeterminate-border-color | Border color of indeterminate checkbox     |
| --clr-forms-checkbox-mark-color                 | Color of checkbox mark                     |
| --clr-forms-checkbox-disabled-background-color  | Background color of disabled checkbox      |
| --clr-forms-checkbox-disabled-mark-color        | Color of disabled checkbox mark            |
| --clr-forms-checkbox-border-radius              | Border radius of checkbox                  |
| --clr-forms-checkbox-line-height                | Line height of the checkbox button wrapper |
| --clr-forms-checkbox-padding-left               | Left padding for checkbox label element    |
| --clr-forms-checkbox-label-height               | Height of the checkbox label element       |

## CSS Classes

| Class name           | Description                              |
| -------------------- | ---------------------------------------- |
| clr-checkbox-wrapper | Wrapper class for the checkbox component |

# Combobox

## CSS Custom Properties

| CSS Custom Property                    | Description                                                            |
| -------------------------------------- | ---------------------------------------------------------------------- |
| --clr-combobox-trigger-color           | Combobox trigger color                                                 |
| --clr-combobox-font-size               | Combobox font size                                                     |
| --clr-combobox-border-color            | Combobox border color                                                  |
| --clr-combobox-border-radius           | Combobox corners radius                                                |
| --clr-combobox-input-background-color  | Combobox input background color                                        |
| --clr-combobox-pill-background-color   | Background color of the selected items pills in a multiselect combobox |
| --clr-combobox-pill-border-color       | Border color of the selected items pills in a multiselect combobox     |
| --clr-combobox-pill-border-radius      | Border radius of the selected items pills in a multiselect combobox    |
| --clr-combobox-pill-font-color         | Text color of the selected items pills in a multiselect combobox       |
| --clr-combobox-filter-highlight        | Combobox filter highlight color                                        |
| --clr-combobox-min-height              | Minimal height of the combobox                                         |
| --clr-combobox-font-size               | Combobox input font size                                               |
| --clr-combobox-font-weight             | Combobox input font weight                                             |
| --clr-combobox-line-height             | Combobox input line height                                             |
| --clr-combobox-text-color              | Text color for the combobox input                                      |
| --clr-combobox-border-radius           | Combobox border radius                                                 |
| --clr-combobox-padding-left            | Combobox input left padding                                            |
| --clr-combobox-trigger-padding-left    | Combobox trigger/caret left padding                                    |
| --clr-combobox-trigger-padding-right   | Combobox trigger/caret right padding                                   |
| --clr-combobox-trigger-gap             | Gap between the input and caret                                        |
| --clr-combobox-trigger-font-color      | Combobox trigger/caret font color                                      |
| --clr-combobox-hover-background-color  | Background color when hovered or focused                               |
| --clr-combobox-active-background-color | Background color of the element selected by keyboard                   |
| --clr-combobox-pill-padding            | Combobox multiselect pills padding                                     |
| --clr-combobox-pill-margin             | Margin for the combobox multiselection pill element                    |
| --clr-combobox-pill-height             | Height of the combobox pill element                                    |
| --clr-combobox-pill-remove-icon-color  | Color of the remove pill icon                                          |
| --clr-combobox-caret-icon-size         | Size of the combobox caret icon icon                                   |

## CSS Classes

| Class name                 | Description                                           |
| -------------------------- | ----------------------------------------------------- |
| clr-combobox               | Combobox element class                                |
| clr-combobox-container     | Container class for the combobox                      |
| clr-combobox-input         | Combobox input element                                |
| clr-combobox-options       | List of combobox options                              |
| clr-combobox-option        | An option form the combobox suggestion list           |
| clr-combobox-trigger       | Combobox trigger/caret button                         |
| label-combobox-pill        | Combobox selection pill element                       |
| clr-combobox-remove-btn    | Item remove button for multiselect combobox           |
| clr-combobox-pill-content  | Content of the combobox selection pill element        |
| clr-combobox-disabled      | Disabled combobox indicator                           |
| clr-combobox-wrapper       | Internal wrapper class                                |
| clr-combobox-input-wrapper | Internal input wrapper class                          |
| clr-combobox-form-control  | Internal class used for label positioning calculation |

# Datagrid

## CSS Properties

| Property Name                                        | Description                                                              |
| ---------------------------------------------------- | ------------------------------------------------------------------------ |
| --clr-datagrid-font-color                            | Not used.                                                                |
| --clr-datagrid-default-border-color                  | Default border color for datagrid detail pane.                           |
| --clr-datagrid-icon-color                            | Default color for expandable, detail caret icons and action toggle icon. |
| --clr-datagrid-row-hover-color                       | Background color for datagrid row on hover and active action items.      |
| --clr-datagrid-row-hover-font-color                  | Font color for active action items.                                      |
| --clr-datagrid-action-toggle-color                   | Datagrid action toggle icon color when active.                           |
| --clr-datagrid-pagination-btn-color                  | Color for pagination buttons.                                            |
| --clr-datagrid-pagination-btn-disabled-color         | Color for disabled pagination buttons.                                   |
| --clr-datagrid-pagination-btn-disabled-opacity       | Opacity for disabled pagination buttons.                                 |
| --clr-datagrid-pagination-input-border-color         | Border color for the pagination input field.                             |
| --clr-datagrid-pagination-input-border-focus-color   | Border color for the pagination input field when focused.                |
| --clr-datagrid-popover-bg-color                      | Background color for popovers within the datagrid.                       |
| --clr-datagrid-popover-border-color                  | Border color for popovers within the datagrid.                           |
| --clr-datagrid-action-popover-hover-color            | Background color of action items on hover and focus.                     |
| --clr-datagrid-row-selected                          | Font color for selected rows.                                            |
| --clr-datagrid-column-switch-header-font-color       | Font color for column switch header button icons.                        |
| --clr-datagrid-column-switch-header-font-hover-color | Font color for column switch button icons on hover.                      |
| --clr-datagrid-detail-caret-icon-open-bg-color       | Background color for opened detail caret button.                         |
| --clr-datagrid-detail-caret-icon-open-icon-color     | Color of opened detail caret icon.                                       |
| --clr-datagrid-placeholder-color                     | Font color for empty datagrid placeholder.                               |
| --clr-datagrid-placeholder-font-size                 | Font size for empty datagrid placeholder.                                |
| --clr-datagrid-loading-background                    | Background color for the loading state of the datagrid.                  |
| --clr-datagrid-column-toggle-border-color            | Border color for column toggle buttons.                                  |
| --clr-datagrid-column-toggle-fill-color              | Background color for column toggle buttons.                              |
| --clr-datagrid-column-toggle-text-color              | Text color for column toggle buttons.                                    |
| --clr-datagrid-column-toggle-border-hover-color      | Border color for column toggle buttons when hovered.                     |
| --clr-datagrid-column-toggle-fill-hover-color        | Background color for column toggle buttons when hovered.                 |
| --clr-datagrid-column-toggle-text-hover-color        | Text color for column toggle buttons when hovered.                       |
| --clr-datagrid-column-toggle-border-active-color     | Border color for active column toggle buttons.                           |
| --clr-datagrid-column-toggle-fill-active-color       | Background color for active column toggle buttons.                       |
| --clr-datagrid-column-toggle-text-active-color       | Text color for active column toggle buttons.                             |
| --clr-datagrid-popovers-box-shadow-color             | Not used.                                                                |
| --clr-datagrid-popover-padding                       | Padding for popovers                                                     |
| --clr-datagrid-popover-font-color                    | Font color for popovers.                                                 |
| --clr-datagrid-pagination-input-size                 | Width and Height for pagination input                                    |
| --clr-datagrid-detail-header-padding                 | Padding for detail header                                                |
| --clr-datagrid-detail-header-title-padding           | Padding for detail header title                                          |
| --clr-datagrid-detail-pane-close-btn-margin          | Margin for detail close button                                           |
| --clr-datagrid-detail-pane-close-padding             | Padding for detail heade close wrapper                                   |
| --clr-datagrid-detail-body-padding                   | Padding for detail content body                                          |
| --clr-datagrid-detail-pane-close-btn-min-width       | Minimal width for detail close button                                    |
| --clr-datagrid-detail-pane-content-padding           | Padding for detail panel content                                         |
| --clr-datagrid-detail-pane-close-icon-size           | Width and Height for detail close icon                                   |
| --clr-datagrid-detail-body-text-color                | Font color for detail body                                               |
| --clr-datagrid-detail-header-title-color             | Font color for detail header title                                       |
| --clr-datagrid-detail-pane-bg-color                  | Background color for detail panel                                        |
| --clr-datagrid-detail-pane-border-color              | Border color for detail panel                                            |
| --clr-datagrid-footer-padding                        | Footer padding                                                           |
| --clr-datagrid-placeholder-padding                   | Placeholder padding                                                      |
| --clr-datagrid-placeholder-gap                       | Gap size for placeholder elements                                        |
| --clr-datagrid-placeholder-font-weight               | Font weight for placeholder                                              |
| --clr-datagrid-placeholder-line-height               | Line height for placeholder                                              |
| --clr-datagrid-placeholder-letter-spacing            | Letter spacing for placeholder                                           |
| --clr-datagrid-placeholder-background-color          | Background color for placeholder                                         |
| --clr-datagrid-column-separator-height               | Height for column separator                                              |
| --clr-datagrid-filter-toggle-size                    | Width and Height for filter toggle button                                |
| --clr-datagrid-row-active-color                      | Background color for active state on rows                                |
| --clr-datagrid-footer-line-height                    | Line height for footer                                                   |
| --clr-datagrid-fixed-column-size                     | Size for fixed columns inside datagrid                                   |

## CSS Classes

| Class Name                       | Description                                                                                    |
| -------------------------------- | ---------------------------------------------------------------------------------------------- |
| action-item                      | Action item within the datagrid's overflow container.                                          |
| clr-col-null                     | Prevents clr-col-\* classes inside clrForm wrapper.                                            |
| datagrid-action-overflow         | Overflow container for action items.                                                           |
| datagrid-cell                    | Single cell within a row of the datagrid.                                                      |
| datagrid-column                  | Main datagrid column element.                                                                  |
| datagrid-column-flex             | Flex container for the column content.                                                         |
| datagrid-column-handle           | Button for resizing the column.                                                                |
| datagrid-column-resize-tracker   | Visual indicator for column resizing.                                                          |
| datagrid-column-separator        | Separator between columns.                                                                     |
| datagrid-container               | Internal class set if there are no datagrid cells inside row detail.                           |
| datagrid-detail-body             | Main datagrid detail body element.                                                             |
| datagrid-detail-header           | Main datagrid detail header element.                                                           |
| datagrid-empty                   | Internal class set on datagrid placeholder if datagrid is empty.                               |
| datagrid-expandable-caret        | Container for the expandable rows caret button and for datagrid column header for carets.      |
| datagrid-expandable-caret-button | Expandable caret button within the expandable cell.                                            |
| datagrid-filter                  | Container for the filter popover.                                                              |
| datagrid-filter-close-wrapper    | Wrapper for the close button in the filter popover.                                            |
| datagrid-filter-open             | Applied to the filter toggle button when open.                                                 |
| datagrid-filter-toggle           | Toggle button for opening/closing the filter popover.                                          |
| datagrid-filtered                | Applied to the filter toggle button when active.                                               |
| datagrid-fixed-column            | Fixed column.                                                                                  |
| datagrid-footer                  | Main datagrid footer element.                                                                  |
| datagrid-footer-description      | Wrapper for datagrid footer content.                                                           |
| datagrid-footer-select           | Select checkbox in the footer.                                                                 |
| datagrid-header                  | Header section of the datagrid.                                                                |
| datagrid-calculate-mode          | Internal class used while datagrid is in calculation mode.                                     |
| datagrid-placeholder             | Container for the datagrid placeholder image and content.                                      |
| datagrid-placeholder-container   | Main datagrid placholder element.                                                              |
| datagrid-placeholder-content     | Wrapper for datagrid placeholder content.                                                      |
| datagrid-placeholder-image       | Image in the placeholder.                                                                      |
| datagrid-row                     | Main datagrid row element.                                                                     |
| datagrid-row-actions             | Container for the row actions.                                                                 |
| datagrid-row-clickable           | Internal class used for calculation mode and on wrapper element for the row in selection mode. |
| datagrid-row-detail              | Main datagrid row detail element.                                                              |
| datagrid-row-flex                | Internal class for adding flex layout to a row.                                                |
| datagrid-row-master              | Internal class used for calculcation mode and wrapper element for row content.                 |
| datagrid-row-scrollable          | Scrollable container for the row.                                                              |
| datagrid-scrolling-cells         | Container for the scrolling cells within the row.                                              |
| datagrid-select                  | Container for the selection checkbox/radio buttons.                                            |
| datagrid-signpost-trigger        | Internal class for datagrid cells if there are signposts in it.                                |
| is-open                          | Applied to the detail caret button when detail row open.                                       |
| is-replaced                      | Applied to the scrollable container when row replaced.                                         |
| pagination                       | Pagination element.                                                                            |
| pagination-current               | Current page input.                                                                            |
| pagination-description           | Pagination description.                                                                        |
| pagination-description-compact   | The compact description when detail view is opened.                                            |
| pagination-first                 | First page button.                                                                             |
| pagination-last                  | Last page button.                                                                              |
| pagination-list                  | Pagination buttons.                                                                            |
| pagination-next                  | Next page button.                                                                              |
| pagination-previous              | Previous page button.                                                                          |
| pagination-size                  | Wrapper for datagrid page size element.                                                        |
| sort-icon                        | Sort icon for sortable columns.                                                                |

# Datepicker

## CSS Custom Properties

| CSS Custom Property                               | Description                                                         |
| ------------------------------------------------- | ------------------------------------------------------------------- |
| --clr-calendar-background-color                   | Background color of the calendar                                    |
| --clr-calendar-border-color                       | Border color of the calendar                                        |
| --clr-datepicker-trigger-color                    | Used in legacy layout which was removed                             |
| --clr-datepicker-trigger-hover-color              | Used in legacy layout which was removed                             |
| --clr-calendar-btn-color                          | Calendar Buttons color                                              |
| --clr-calendar-btn-hover-focus-color              | Calendar Buttons hover and focus color                              |
| --clr-calendar-picker-btn-font-size               | Font size for calendar month and year buttons                       |
| --clr-calendar-picker-btn-font-weight             | Font weight for calendar month and year buttons                     |
| --clr-calendar-today-date-cell-color              | Font color for today date                                           |
| --clr-calendar-today-date-cell-font-weight        | Font weight for today date                                          |
| --clr-calendar-active-cell-background-color       | Active cell background color                                        |
| --clr-calendar-active-cell-color                  | Active cell font color                                              |
| --clr-calendar-active-focus-cell-background-color | Focused cell background color                                       |
| --clr-day-font-size                               | Week day font size. Depricated use `clr-calendar-weekday-font-size` |
| --clr-calendar-container-border-width             | Calendar container border width                                     |
| --clr-calendar-container-border-radius            | Calendar container border radius                                    |
| --clr-calendar-container-padding                  | Calendar container padding                                          |
| --clr-calendar-container-margin-top               | Calendar container margin top                                       |
| --clr-calendar-container-width                    | Calendar container width                                            |
| --clr-calendar-container-height                   | Calendar container height                                           |
| --clr-calendar-cell-border-radius                 | Calendar cell border radius                                         |
| --clr-calendar-cell-width-height                  | Calendar cell width and height                                      |
| --clr-calendar-month-year-button-width            | Calendar month and year button width                                |
| --clr-calendar-month-year-cell-height             | Calendar month and year cell height                                 |
| --clr-calendar-month-year-cell-width              | Calendar month and year cell width                                  |
| --clr-calendar-year-picker-gap                    | Calendar year picker gap                                            |
| --clr-calendar-weekday-font-size                  | Calendar week day font size                                         |
| --clr-calendar-weekday-font-weight                | Calendar week day font weight                                       |
| --clr-calendar-weekday-line-height                | Calendar week day line height                                       |
| --clr-calendar-weekday-letter-spacing             | Calendar week day letter spacing                                    |
| --clr-calendar-day-font-size                      | Calendar day font size                                              |
| --clr-calendar-day-font-weight                    | Calendar day font weight                                            |
| --clr-calendar-day-line-height                    | Calendar day line height                                            |
| --clr-calendar-day-letter-spacing                 | Calendar day letter spacing                                         |
| --clr-calendar-today-date-cell-font-weight        | Calendar toady font weight                                          |
| --clr-calendar-month-year-font-size-              | Calendar month year font size                                       |
| --clr-calendar-month-year-font-weight             | Calendar month year font weight                                     |
| --clr-calendar-month-year-line-height             | Calendar month year line height                                     |
| --clr-calendar-month-year-letter-spacing          | Calendar month year letter spacing                                  |
| --clr-calendar-picker-btn-font-size               | Calendar picker button font size                                    |
| --clr-calendar-picker-btn-font-weight             | Calendar picker button font weight                                  |
| --clr-calendar-picker-btn-line-height             | Calendar picker button line height                                  |
| --clr-calendar-picker-btn-letter-spacing          | Calendar picker button letter spacing                               |

## CSS Classes

| Class name              | Description                                      |
| ----------------------- | ------------------------------------------------ |
| datepicker              | Main date picker element                         |
| date-container          | Not used                                         |
| datepicker-trigger      | Not used. Marked as legacy and to be removed     |
| datepicker-trigger-icon | Not used. Marked as legacy and to be removed     |
| date-input              | Not used                                         |
| calendar-header         | Calendar header                                  |
| calendar-table          | Calendar table                                   |
| calendar-row            | Calendar row                                     |
| calendar-cell           | Calendar cell                                    |
| calendar-btn            | Calendar button                                  |
| calendar-pickers        | Month and year picker buttons wrapper            |
| calendar-switchers      | Month change and today buttons wrapper           |
| daypicker               | Main day picker element                          |
| day                     | Main element for day button                      |
| day-btn                 | Day button inside calendar                       |
| weekday                 | Weekday table heading                            |
| weekdays                | Weekdays table row wrapper                       |
| month                   | Month buttons inside month picker                |
| monthpicker             | Main month picker element                        |
| monthpicker-trigger     | Month picker button trigger                      |
| year                    | Year buttons inside year picker                  |
| years                   | Wrapper for year buttons inside year picker      |
| yearpicker              | Main year picker element                         |
| yearpicker-trigger      | Year picker button trigger                       |
| is-today                | Set on day button which is equal to current date |
| is-excluded             | Set on day button if the date is excluded        |
| is-selected             | Selected day button                              |
| is-disabled             | Disabled day button                              |
| switcher                | Switcher button                                  |
| year-switchers          | Wrapper for switcher buttons inside year picker  |

# Dropdown

## CSS Custom Properties

| CSS Custom Property                    | Description                                        |
| -------------------------------------- | -------------------------------------------------- |
| --clr-dropdown-active-text-color       | The text color of the active dropdown item.        |
| --clr-dropdown-active-background-color | The background color of the active dropdown item.  |
| --clr-dropdown-bg-color                | The background color of the dropdown.              |
| --clr-dropdown-border-color            | The border color of the dropdown.                  |
| --clr-dropdown-divider-color           | The color of the divider between dropdown items.   |
| --clr-dropdown-divider-border-width    | Width of the dropdown items separator.             |
| --clr-dropdown-divider-margin          | Margin of the dropdown divider.                    |
| --clr-dropdown-child-border-color      | The border color of child dropdown items.          |
| --clr-dropdown-bg-hover-color          | The background color of the hovered dropdown item. |
| --clr-dropdown-selection-color         | The color of the selected dropdown item.           |
| --clr-dropdown-box-shadow              | The box shadow of the dropdown.                    |
| --clr-dropdown-text-color              | The text color of the dropdown.                    |
| --clr-dropdown-header-color            | The color of the dropdown menu header.             |
| --clr-dropdown-header-font-weight      | Font weight of the dropdown menu header.           |
| --clr-dropdown-header-font-size        | Font size of the dropdown menu header.             |
| --clr-dropdown-header-line-height      | Line height of the dropdown menu header.           |
| --clr-dropdown-header-padding          | Padding of the dropdown menu header.               |
| --clr-dropdown-header-letter-spacing   | Letter spacing of the dropdown menu header.        |
| --clr-dropdown-item-color              | The color of the dropdown item.                    |
| --clr-dropdown-item-font-weight        | Font weight of the dropdown item.                  |
| --clr-dropdown-item-padding            | Single menu item padding                           |
| --clr-dropdown-items-padding           | Menu items list overall padding                    |
| --clr-dropdown-border-radius           | Menu items list border radius                      |
| --clr-dropdown-caret-icon-size         | Size of the dropdown menu expander caret.          |
| --clr-dropdown-subsection-offset       | Offset of elements in menu with header.            |

## CSS Classes

| Class            | Description                                       |
| ---------------- | ------------------------------------------------- |
| dropdown         | The overall dropdown component.                   |
| dropdown-toggle  | The toggle element inside the dropdown component. |
| dropdown-menu    | The dropdown menu container.                      |
| dropdown-header  | The header element inside the dropdown menu.      |
| dropdown-item    | The individual items in the dropdown menu.        |
| expandable       | The expandable dropdown item.                     |
| dropdown-divider | The divider element in the dropdown menu.         |
| disabled         | Applies the disabled state to the dropdown item.  |

# Grid layout

## CSS Classes

| Class name                              | Description                                                                                                                                          |
| --------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------- |
| clr-row                                 | Styles a flex row of columns                                                                                                                         |
| clr-justify-content-#{POSITION}         | Sets justify-content property to #{POSITION}, POSITION is one of 'start', 'center', 'end'                                                            |
| clr-justify-content-between             | Sets justify-content property to 'space-between'                                                                                                     |
| clr-justify-content-around              | Sets justify-content property to 'space-around'                                                                                                      |
| clr-align-items-start                   | Horizontally aligns items in a row towards the beginning                                                                                             |
| clr-align-items-center                  | Centers items horizontally in a row                                                                                                                  |
| clr-align-items-end                     | Aligns items in a row to the right end                                                                                                               |
| clr-align-items-baseline                | Aligns items in a row based on their baselines                                                                                                       |
| clr-align-items-stretch                 | Expands and evenly distributes items in a row                                                                                                        |
| clr-align-content-#{POSITION}           | Aligns content of multiline flex rows to #{POSITION}, POSITION is any of 'start', 'center', 'end'                                                    |
| clr-align-content-between               | Evenly distributes the space between the flex columns in a multiline container, leaving no space at the beginning or end of the container            |
| clr-align-content-around                | Evenly distributes the space around the flex columns in a multiline container, creating equal spacing between and around the lines                   |
| clr-align-content-stretch               | Stretches the flex columns in a multiline flex container, causing them to expand vertically and fill the available space                             |
| clr-break-row                           | Breaks the columns in a row with a new line                                                                                                          |
| clr-clearfix                            | Clears floated content within a container                                                                                                            |
| clr-no-gutters                          | Removes gaps between column content in a row                                                                                                         |
| clr-col                                 | Styles a column within a row                                                                                                                         |
| clr-col-#{SIZE}                         | Styles a column that spans to #{SIZE}/12 of the row's width, SIZE is an integer in the [1,12] interval                                               |
| clr-col-#{BREAKPOINT}                   | Styles a column within a screen with width >= than #{BREAKPOINT}, BREAKPOINT is anything among 'sm', 'md', 'lg', 'xl'                                |
| clr-col-#{BREAKPOINT}-#{SIZE}           | Styles a column that spans to SIZE/12 of the row's width for a row with width >= BREAKPOINT                                                          |
| clr-col-auto                            | Styles a column within a row to have auto width                                                                                                      |
| clr-col-#{BREAKPOINT}-auto              | Styles a column within a row to have auto width for a small, medium, large and extra large screen                                                    |
| clr-offset-#{OFFSET_SIZE}               | Sets left offset to #{OFFSET_SIZE}/12 of the row's width, OFFSET_SIZE is an integer in the [1,11] interval                                           |
| clr-offset-#{BREAKPOINT}-#{OFFSET_SIZE} | Sets the left offset of the column to #{OFFSET_SIZE}/12 for a screen larger than #{BREAKPOINT}                                                       |
| clr-order-first                         | Sets the order of the column as first                                                                                                                |
| clr-order-last                          | Sets the order of the column as last                                                                                                                 |
| clr-order-#{ORDER}                      | Sets the order of the column, ORDER is an integer in the interval [1,12]                                                                             |
| clr-order-#{BREAKPOINT}-#{ORDER}        | Sets the order of the column                                                                                                                         |
| clr-align-self-auto                     | Sets align-self property of a column to #{POSITION}, POSITION is one of 'auto', 'start', 'end', 'center', 'baseline', 'stretch'                      |
| clr-invisible                           | Sets the visibility of element to hidden                                                                                                             |
| clr-display-#{DISPLAY_VALUE}            | Sets the display property of an element to #{DISPLAY_VALUE}, DISPLAY_VALUE is one of 'block', 'inline-block', 'inline'                               |
| clr-align-#{POSITION}                   | Sets vertical-align to #{POSITION}, POSITION is one of 'baseline', 'top', 'middle', 'bottom', 'text-bottom', 'text-top'                              |
| clr-flex-#{DIRECTION}                   | Sets the flex-direction to #{DIRECTION} ('row', 'column', 'row-reverse' or 'column-reverse')                                                         |
| clr-flex-#{FLEX_WRAP_VALUE}             | Sets the flex-wrap to #{FLEX_WRAP_VALUE} ('wrap', 'nowrap', 'wrap-reverse')                                                                          |
| clr-flex-fill                           | Makes a flex item expand to fill any remaining space within a flex container, distributing the available space evenly among the flex items           |
| clr-#{FLEXIBILITY}-#{SIZE}              | Sets the flexibility (flex-grow or flex-shrink) to #{SIZE} (0 or 1)                                                                                  |
| clr-float-#{BREAKPOINT}-#{DIRECTION}    | Sets the float property to #{DIRECTION}('left', 'right' or 'none') for screens with width bigger than the #{BREAKPOINT} value for 'sm', 'md' or 'lg' |

## Screen width breakpoints

| Breakpoint | Description |
| ---------- | ----------- |
| sm         | >= 576px    |
| md         | >= 768px    |
| lg         | >= 992px    |
| xl         | >= 1200px   |

# Headers

## CSS Custom Properties

| CSS Custom Property                         | Description                                            |
| ------------------------------------------- | ------------------------------------------------------ |
| --clr-header-height                         | Header overall height                                  |
| --clr-header-bg-color                       | Header background color                                |
| --clr-header-divider-opacity                | Opacity of the header divider                          |
| --clr-header-divider-width                  | Width of the header divider                            |
| --clr-header-divider-height                 | Height of the header divider                           |
| --clr-header-nav-opacity                    | Header nav item opacity                                |
| --clr-header-nav-hover-opacity              | Header nav item opacity on hover                       |
| --clr-header-2-bg-color                     | Second version of header background color              |
| --clr-header-3-bg-color                     | Third version of header background color               |
| --clr-header-4-bg-color                     | Fourth version of header background color              |
| --clr-header-5-bg-color                     | Fifth version of header background color               |
| --clr-header-6-bg-color                     | Sixth version of header background color               |
| --clr-header-7-bg-color                     | Seventh version of header background color             |
| --clr-header-8-bg-color                     | Eighth version of header background color              |
| --clr-header-font-color                     | Header text color                                      |
| --clr-header-font-color-hover               | Header hovered item color                              |
| --clr-header-title-color                    | Header branding title text color                       |
| --clr-header-title-font-weight              | Header branding title text fort weight                 |
| --clr-header-title-font-family              | Header branding title font family                      |
| --clr-header-title-font-size                | Header branding title font size                        |
| --clr-header-title-line-height              | Header branding title line height                      |
| --clr-header-title-letter-spacing           | Header branding title letter spacing                   |
| --clr-header-branding-min-width             | Header branding minimal width                          |
| --clr-header-branding-padding               | Header branding padding                                |
| --clr-header-branding-icon-gap              | Gap between icon and text in header branding section   |
| --clr-header-branding-logo-size             | Size of the logo image in header branding section      |
| --clr-header-nav-link-padding               | Header navigation buttons padding                      |
| --clr-header-nav-link-line-height           | Header navigation buttons line-height                  |
| --clr-header-nav-link-font-size             | Header navigation buttons font size                    |
| --clr-header-nav-text-font-weight           | Header navigation buttons font weight                  |
| --clr-header-nav-text-font-weight-active    | Active header navigation buttons font weight           |
| --clr-header-action-caret-right             | Right margin of the header nav action caret            |
| --clr-header-search-height                  | Header search input height                             |
| --clr-header-search-icon-size               | Header search icon size                                |
| --clr-header-search-margin-left             | Header search field left margin                        |
| --clr-header-search-margin-right            | Header search field right margin                       |
| --clr-header-search-gap                     | Gap between the subelements of the header search field |
| --clr-header-search-input-font-size         | Header search field font size                          |
| --clr-header-search-input-font-color        | Header search field text color                         |
| --clr-header-search-border-active           | Border of active/focused search field                  |
| --clr-header-search-border-hover            | Border of hovered search field                         |
| --clr-header-search-placeholder-font-weight | Font weight of the header search placeholder           |
| --clr-header-search-placeholder-text-color  | Text color of the header search placeholder            |

## CSS Classes

| Class name               | Description                          |
| ------------------------ | ------------------------------------ |
| clr-header               | Application header element           |
| header-hamburger-trigger | Hamburger icon for responsive header |
| header-actions           | Responsive header actions            |

# Input

## CSS Custom properties

| Class name                       | Description    |
| -------------------------------- | -------------- |
| --clr-forms-input-padding        | Input padding  |
| --clr-forms-input-wrapper-height | Wrapper height |

## CSS Classes

| Class name                  | Description                                                   |
| --------------------------- | ------------------------------------------------------------- |
| clr-input-wrapper           | Wrapper for input element                                     |
| clr-input                   | Main input element                                            |
| clr-input-group             | Wrapper for multiple form elements                            |
| clr-input-group-addon       | Input group addon (icon,text)                                 |
| clr-input-group-icon-action | Input group action. Used on button to add action on the input |

# Label

## CSS Properties

| CSS Property Name                    | Description                            |
| ------------------------------------ | -------------------------------------- |
| --clr-label-font-color-light         | Font color for light labels            |
| --clr-label-font-color-dark          | Font color for dark labels             |
| --clr-label-default-border-color     | Default border color for labels        |
| --clr-label-bg-hover-color           | Background color on hover for labels   |
| --clr-label-gray-bg-color            | Not used                               |
| --clr-label-gray-color               | Not used                               |
| --clr-label-purple-bg-color          | Background color for purple labels     |
| --clr-label-purple-color             | Font color for purple labels           |
| --clr-label-blue-bg-color            | Background color for blue labels       |
| --clr-label-blue-color               | Font color for blue labels             |
| --clr-label-orange-bg-color          | Background color for orange labels     |
| --clr-label-orange-color             | Font color for orange labels           |
| --clr-label-light-blue-bg-color      | Background color for light blue labels |
| --clr-label-light-blue-color         | Font color for light blue labels       |
| --clr-label-info-bg-color            | Background color for info labels       |
| --clr-label-info-font-color          | Font color for info labels             |
| --clr-label-info-border-color        | Border color for info labels           |
| --clr-label-success-bg-color         | Background color for success labels    |
| --clr-label-success-font-color       | Font color for success labels          |
| --clr-label-success-border-color     | Border color for success labels        |
| --clr-label-warning-bg-color         | Background color for warning labels    |
| --clr-label-warning-font-color       | Font color for warning labels          |
| --clr-label-warning-border-color     | Border color for warning labels        |
| --clr-label-danger-bg-color          | Background color for danger labels     |
| --clr-label-danger-font-color        | Font color for danger labels           |
| --clr-label-danger-border-color      | Border color for danger labels         |
| --clr-label-font-size                | Font size for labels                   |
| --clr-label-font-weight              | Font weight for label                  |
| --clr-label-letter-spacing           | Letter spacing for label               |
| --clr-label-border-radius            | Border radius for label                |
| --clr-label-padding                  | Padding for labels                     |
| --clr-label-gap-size                 | Gap size for labels                    |
| --clr-label-line-height              | Line height for labels                 |
| --clr-label-clickable-font-size      | Font size for clickable labels         |
| --clr-label-clickable-font-weight    | Font weight for clickable labels       |
| --clr-label-clickable-letter-spacing | Letter spacing for clickable labels    |
| --clr-label-clickable-line-height    | Line Height for clickable labels       |

## Classes

| Class Name    | Description                     |
| ------------- | ------------------------------- |
| label         | Default label class             |
| label-<color> | Label class with specific color |
| clickable     | Clickable label class           |
| text          | Inner text class for the label  |

# Layout

## CSS Custom Properties

| CSS Custom Property         | Description                         |
| --------------------------- | ----------------------------------- |
| --clr-global-app-background | Global application background color |

## CSS Classes

| Class name        | Description                        |
| ----------------- | ---------------------------------- |
| main-container    | Main application container element |
| alert-app-level   | Application level alert slot       |
| header            | Application header                 |
| subnav, sub-nav   | Secondary top navigation container |
| content-container | Main content and nav container     |
| clr-vertical-nav  | Left navigation container          |
| content-area      | Pag content container              |

# Lists

## CSS Classes

| Class name    | Description                                           |
| ------------- | ----------------------------------------------------- |
| list          | Sets default sizes to list                            |
| compact       | Makes a list to use less space, used with .list       |
| list-unstyled | Removes default bullet styling of list items          |
| list-spacer   | Sets space before the list contents                   |
| list-group    | Removes bullets and reduces spacing used inside .card |

# Login

## CSS Custom Properties

| CSS Custom Property                  | Description                             |
| ------------------------------------ | --------------------------------------- |
| --clr-login-title-color              | Color of the title                      |
| --clr-login-title-font-weight        | Font weight of the title                |
| --clr-login-title-font-family        | Font family of the title                |
| --clr-login-background-color         | Background color                        |
| --clr-login-background               | Background image                        |
| --clr-login-error-background-color   | Error message background color          |
| --clr-login-error-border-radius      | Error message border radius             |
| --clr-login-panel-line-color         | Color of the divider line               |
| --clr-login-panel-line-opacity       | Opacity to the divider line             |
| --clr-login-title-font-size          | Font size of the title                  |
| --clr-login-title-line-height        | Line height of the title                |
| --clr-login-title-font-weight        | Font weight of the title                |
| --clr-login-title-letter-spacing     | Letter spacing of the title             |
| --clr-login-hint-font-size           | Font size of the hint                   |
| --clr-login-hint-font-weight         | Font weight of the hint                 |
| --clr-login-hint-line-height         | Line height of the hint                 |
| --clr-login-hint-letter-spacing      | Letter spacing of the hint              |
| --clr-login-hint-color               | Font color of the hint                  |
| --clr-login-group-signup-font-weight | Font weight of the sign up link         |
| --clr-login-group-signup-line-height | Line height of the sign up link         |
| --clr-login-group-signup-font-size   | Font size for the sign up link          |
| --clr-login-footer-gap               | Gap size for the footer                 |
| --clr-login-footer-font-size         | Font size for footer content            |
| --clr-login-footer-line-height       | Line height for footer content          |
| --clr-login-footer-font-weight       | Font weight for footer content          |
| --clr-login-copyright-color          | Font color for the copyright thumbnail  |
| --clr-login-copyright-font-size      | Font size for the copyright thumbnail   |
| --clr-login-copyright-font-weight    | Font weight for the copyright thumbnail |
| --clr-login-copyright-line-height    | Line height for the copyright thumbnail |
| --clr-login-welcome-color            | Font color for welcome                  |
| --clr-login-error-icon-color         | Color for error icon                    |
| --clr-login-logo-color               | Color of VMware logo                    |

## CSS Classes

| Class         | Description                                                                      |
| ------------- | -------------------------------------------------------------------------------- | --- |
| login         | The login form is a predefined form for applications that require authentication |
| login-body    | Wrapper for login content                                                        |
| login-header  | Wrapper for login header elements                                                |
| login-footer  | Wrapper for login footer elements                                                |
| logo          | VMware logo                                                                      |
| actions       | Wrapper for header actions                                                       |
| copyright     | Copyright label                                                                  |
| login-wrapper | Wrapper element                                                                  |     |
| title         | The title `section` of the login form                                            |
| welcome       | The heading of the login form                                                    |
| hint          | Hint/helper text within the title of the login form                              |
| login-group   | Contains the login form controls                                                 |
| error         | Error messageThe error message is hidden by default                              |
| active        | Adding the `active` class to the `.error` element makes the error message appear |

# Modal

## CSS Custom Properties

| CSS Custom Property                  | Description                              |
| ------------------------------------ | ---------------------------------------- |
| --clr-modal-close-color              | Fill color of modal close icon           |
| --clr-modal-bg-color                 | Background color of modal                |
| --clr-modal-content-box-shadow-color | Shadow color of modal content            |
| --clr-modal-backdrop-color           | Color of modal backdrop                  |
| --clr-modal-backdrop-opacity         | Opacity of modal backdrop                |
| --clr-modal-border-radius            | Border radius of a modal                 |
| --clr-modal-title-color              | Font color of modal title                |
| --clr-modal-title-font-family        | Font family of modal title               |
| --clr-modal-title-font-weight        | Font weight of modal title               |
| --clr-modal-sm-width                 | Width of the modal on small layout       |
| --clr-modal-md-width                 | Width of the modal on medium layout      |
| --clr-modal-lg-width                 | Width of the modal on large layout       |
| --clr-modal-xl-width                 | Width of the modal on extra large layout |
| --clr-modal-text-color               | Font color for modal content             |
| --clr-modal-content-box-shadow       | Shadow of modal content                  |
| --clr-modal-content-border-style     | Border style of modal content            |
| --clr-modal-content-border-color     | Border color of modal content            |
| --clr-modal-content-border-width     | Border width of modal content            |
| --clr-modal-content-border-radius    | Border radius of modal content           |
| --clr-modal-title-font-size          | Font size for modal title                |
| --clr-modal-title-line-height        | Line height for modal title              |
| --clr-modal-footer-gap               | Gap size for footer content              |
| --clr-modal-close-icon-size          | Size for modal close icon                |

## CSS Classes

| Class name          | Description                                        |
| ------------------- | -------------------------------------------------- |
| modal               | Modal element class (positioning focused)          |
| modal-dialog        | Modal dialog box class                             |
| modal-sm            | Sets `modal-dialog` to use small width             |
| modal-lg            | Sets `modal-dialog` to use large width             |
| modal-xl            | Sets `modal-dialog` to use extra-large width       |
| modal-content       | Content class \*should be used in `modal-dialog`   |
| modal-header        | Header class                                       |
| modal-title         | Title class \*should be used inside `modal-header` |
| modal-title-wrapper | Title wrapper                                      |
| modal-body-wrapper  | Body wrapper                                       |
| modal-footer        | Footer wrapper                                     |
| modal-backdrop      | Backdrop class                                     |
| modal-nav           | Modal nav class used only in wizards               |

# Password

## CSS Custom Properties

| CSS Custom Property                          | Description                          |
| -------------------------------------------- | ------------------------------------ |
| --clr-forms-password-eye-icon-color          | Color of show/hide eye icon          |
| --clr-forms-password-disabled-eye-icon-color | Color of disabled show/hide eye icon |

# Progress bar

## CSS Custom Properties

| CSS Custom Property          | Description      |
| ---------------------------- | ---------------- |
| --clr-progress-default-color | Default color    |
| --clr-progress-alt-color-1   | Success color    |
| --clr-progress-alt-color-2   | Danger color     |
| --clr-progress-alt-color-3   | Warning color    |
| --clr-progress-bg-color      | Background color |

## CSS Classes

| Class name      | Description                                                              |
| --------------- | ------------------------------------------------------------------------ |
| progress        | Main progress bar element                                                |
| progress-static | Main static progress bar element                                         |
| progress-fade   | Fade out animation for progress bar                                      |
| progress-meter  | The bar element in a static progress bar                                 |
| progress-group  | Layout element for multiple progress bars                                |
| progress-block  | Layout element for progress bar groups                                   |
| flash           | Sets the bar color to success once value of 100 is reached               |
| flash-danger    | Sets the bar color to danger once value of 100 is reached                |
| labeled         | Used with `progress` to show display value next to the bar               |
| loop            | Loop animation for non-static progress bars                              |
| danger          | Combined with `progress loop` or `progress-static` to set progress color |
| warning         | Combined with `progress loop` or `progress-static` to set progress color |
| success         | Combined with `progress loop` or `progress-static` to set progress color |
| compact         | Used with `progress` or `progress-static` to minify the bar              |

# Radio

## CSS Custom Properties

| CSS Custom Properties                       | Description                                              |
| ------------------------------------------- | -------------------------------------------------------- |
| --clr-forms-radio-label-color               | Color of the label for radio buttons                     |
| --clr-forms-radio-disabled-background-color | Background color of disabled radio buttons               |
| --clr-forms-radio-disabled-mark-color       | Color of the mark (indicator) for disabled radio buttons |
| --clr-forms-radio-line-height               | Line height of the radio button wrapper                  |
| --clr-forms-radio-padding-left              | Left padding for radio label element                     |
| --clr-forms-radio-label-height              | Height of the radio label element                        |

## CSS Classes

| Class             | Description                                              |
| ----------------- | -------------------------------------------------------- |
| clr-radio-wrapper | The wrapper container for the radio button and its label |
| clr-control-label | The label element of the radio button                    |

# Range

## CSS Custom Properties

| CSS Custom Property                            | Description                                   |
| ---------------------------------------------- | --------------------------------------------- |
| --clr-forms-range-progress-fill-color          | The color of the range fill progress.         |
| --clr-forms-range-track-color                  | The background color of the range track.      |
| --clr-forms-range-track-border-color           | The border color of the range track.          |
| --clr-forms-range-thumb-height                 | The height and width of the range thumb.      |
| --clr-forms-range-track-height                 | The height of the range track.                |
| --clr-forms-range-track-border-radius          | The border radius of the range track.         |
| --clr-forms-range-progress-fill-color-disabled | The color of disabled range fill progress.    |
| --clr-forms-range-track-color-disabled         | The background color of disabled range track. |
| --clr-forms-range-track-border-color-disabled  | The border color of disabled range.           |

## CSS Classes

| Class Name        | Description                                                 |
| ----------------- | ----------------------------------------------------------- |
| clr-range-wrapper | Represents the wrapper element for the range input.         |
| fill-input        | Represents the progress bar element inside the range input. |
| clr-range         | Represents the range input element.                         |

# Select

## CSS Custom Properties

| CSS Custom Property                          | Description                                       |
| -------------------------------------------- | ------------------------------------------------- |
| --clr-forms-select-option-color              | Text color used in the options of a single select |
| --clr-forms-select-multiple-background-color | Background color used in a multiple select        |
| --clr-forms-select-multiple-border-color     | Border color used by multiple select options      |
| --clr-forms-select-multiple-option-color     | Text color used by the multiple select options    |
| --clr-forms-select-hover-background          | Background color used when select is hovered.     |
| --clr-forms-select-hover-border-color        | Border color used when select is hovered.         |
| --clr-forms-select-disabled-border-color     | Border color used when select is disabled.        |

## CSS Classes

| Class name              | Description                                    |
| ----------------------- | ---------------------------------------------- |
| clr-select              | Select element class                           |
| clr-multiselect-wrapper | Internal class that wraps the single selects   |
| clr-select-wrapper      | Internal class that wraps the multiple selects |

# Signpost

## CSS Custom Properties

| CSS Custom Property                     | Description                        |
| --------------------------------------- | ---------------------------------- |
| --clr-signpost-content-bg-color         | Signpost content background color. |
| --clr-signpost-content-border-color     | Signpost content border color.     |
| --clr-signpost-border-color             | Signpost border color.             |
| --clr-signpost-action-color             | Signpost action color.             |
| --clr-signpost-action-hover-color       | Signpost action hover color.       |
| --clr-signpost-pointer-border           | Signpost pointer border.           |
| --clr-signpost-pointer-invisible-border | Signpost pointer invisible border. |
| --clr-signpost-pointer-psuedo-border    | Signpost pointer pseudo border.    |
| --clr-signpost-content-color            | Signpost content color.            |
| --clr-signpost-content-header-position  | Signpost content header position.  |

## CSS Classes

| Class name              | Description                                                   |
| ----------------------- | ------------------------------------------------------------- |
| signpost                | Signpost element class.                                       |
| signpost-content        | Content class for the signpost.                               |
| signpost-content-header | Content header class for the signpost.                        |
| signpost-content-body   | Content body class for the signpost.                          |
| signpost-trigger        | Internal class for opening the signpost.                      |
| signpost-wrap           | Internal wrapper class.                                       |
| signpost-action         | Internal action class. Used with content close action button. |

# Spinner

## CSS Custom Properties

| CSS Custom Property                 | Description                                  |
| ----------------------------------- | -------------------------------------------- |
| --clr-spinner-default-size          | Size (diameter) of large spinner             |
| --clr-spinner-medium-size           | Size of medium spinner                       |
| --clr-spinner-small-size            | Size of small spinner                        |
| --clr-spinner-margin-right          | Spacing between spinner and text next to it  |
| --clr-spinner-default-stroke-width  | Width (thickness) of stroke of large spinner |
| --clr-spinner-medium-stroke-width   | Width of medium spinner                      |
| --clr-spinner-small-stroke-width    | Width of small spinner                       |
| --clr-spinner-fill-bg-color         | Spinner background color                     |
| --clr-spinner-fill-inverse-bg-color | Spinner background color for dark background |
| --clr-spinner-fill-color            | Color of rotating part of spinner            |
| --clr-spinner-fill-inverse-color    | Spinner background color for dark background |
| --clr-spinner-border-radius         | Spinner border radius                        |

## CSS Classes

| Class Name      | Description                           |
| --------------- | ------------------------------------- |
| spinner         | Default class for all spinners.       |
| spinner-inline  | Display the spinner inline.           |
| spinner-inverse | Display the spinner in inverse mode.  |
| spinner-sm      | Display the spinner with small size.  |
| spinner-md      | Display the spinner with medium size. |
| spinner-check   | Display a checkmark icon spinner.     |

# Stack view

## CSS Custom Properties

| CSS Custom Property                                                    | Description                                                           |
| ---------------------------------------------------------------------- | --------------------------------------------------------------------- |
| --clr-stack-view-border-radius                                         | Border radius of stack view                                           |
| --clr-stack-view-border-color                                          | Border color of stack view                                            |
| --clr-stack-view-bg-color                                              | Background color of stack view                                        |
| --clr-stack-view-color                                                 | Font color of stack view                                              |
| --clr-stack-view-stack-block-border-bottom                             | Bottom border color of stack block                                    |
| --clr-stack-view-stack-block-label-text-color                          | Font color of stack block label                                       |
| --clr-stack-view-border-box-color                                      | Last stack block element shadow color                                 |
| --clr-stack-block-changed-border-top-color                             | Changed stack block border top color                                  |
| --clr-stack-view-stack-block-label-and-content-bg-color                | Background color of stack block label and content                     |
| --clr-stack-view-stack-children-stack-block-border-bottom-color        | Bottom border color of stack block children                           |
| --clr-stack-view-stack-children-stack-block-label-and-content-bg-color | Background color of stack block children's label and content          |
| --clr-stack-view-stack-block-expanded-bg-color                         | Background color of expanded stack block label and content            |
| --clr-stack-view-stack-block-expandable-hover                          | Background color of expandable stack block label and content on hover |
| --clr-stack-view-stack-block-content-text-color                        | Font color of stack block content                                     |
| --clr-stack-view-stack-block-expanded-text-color                       | Font color of expanded stack block label and content                  |
| --clr-stack-view-stack-block-caret-color                               | Color of stack block caret                                            |
| --clr-stack-view-title-color                                           | Stack view title color                                                |
| --clr-stack-view-stack-block-expandable-bg-hover                       | Stack view stack block expandable background color                    |
| --clr-stack-view-stack-block-expandable-active                         | Stack view stack block expandable active (opened) color               |
| --clr-stack-view-stack-block-expandable-bg-active                      | Stack view stack-block expandable active background color             |
| --clr-stack-view-border-width                                          | Stack view border width                                               |
| --clr-stack-view-stack-block-label-padding                             | Stack view stack block label padding                                  |
| --clr-stack-view-key-margin                                            | Stack view key block margin                                           |
| --clr-stack-view-border-radius                                         | Stack view border radius                                              |
| --clr-stack-view-stack-block-caret-dimension                           | Stack view stack block caret dimension                                |
| --clr-stack-view-stack-children-block-label-padding-left               | Stack view stack children block label padding                         |
| --clr-stack-view-stack-title-padding                                   | Stack view stack title padding                                        |
| --clr-stack-view-stack-block-label-font-size                           | Font size for stack view block label                                  |
| --clr-stack-view-stack-block-label-font-weight                         | Font weight for stack view block label                                |
| --clr-stack-view-stack-block-label-line-height                         | Line height for stack view block label                                |
| --clr-stack-view-stack-block-label-letter-spacing                      | Letter spacing for stack view block label                             |
| --clr-stack-view-font-size                                             | General font size for stack view                                      |
| --clr-stack-view-font-weight                                           | General font weight for stack view                                    |
| --clr-stack-view-line-height                                           | Genral line height for stack view                                     |
| --clr-stack-view-letter-spacing                                        | Generla letter spacing for stack view                                 |

## CSS Classes

| Class name             | Description                                          |
| ---------------------- | ---------------------------------------------------- |
| stack-view             | Main stack view element                              |
| stack-header           | Main stack header element                            |
| stack-title            | Stack view header title                              |
| stack-actions          | Wrapper for stack view header actions                |
| stack-action           | Main header stack action class                       |
| stack-block            | Main stack block element                             |
| stack-block-changed    | Marks a stack block as changed                       |
| stack-block-label      | Wrapper for stack block label and content            |
| stack-view-key         | Stack block view key element                         |
| stack-block-content    | Stack block content element                          |
| stack-block-caret      | Stack block caret icon element                       |
| stack-children         | Wrapper for stack block child blocks                 |
| stack-block-expandable | Used with `stack-block` to add expandable caret icon |
| stack-block-expanded   | Stack block caret icon in expanded state             |

# Table

## CSS Custom Properties

| CSS Custom Property                    | Description                                               |
| -------------------------------------- | --------------------------------------------------------- |
| --clr-table-bgcolor                    | Background color of a table                               |
| --clr-table-margin                     | Margin of a table                                         |
| --clr-thead-bgcolor                    | Background color of table header                          |
| --clr-table-header-border-bottom-color | Not used                                                  |
| --clr-table-footer-border-top-color    | Not used in tables. Used for datagrid footer border color |
| --clr-table-border-color               | Border color of a table                                   |
| --clr-tablerow-bordercolor             | Border color for table rows                               |
| --clr-table-border-radius              | Border radius for а table                                 |
| --clr-table-borderwidth                | Border width for а table                                  |
| --clr-table-cornercellradius           | Border radius for corner cells                            |
| --clr-table-font-color                 | Font color for table rows                                 |
| --clr-thead-color                      | Font color for table header                               |

## CSS Classes

All other table classes like `table, thead, tbody, th, td` are not specific to Clarity so they are not included.

| Class name     | Description              |
| -------------- | ------------------------ |
| table-vertical | Vertical table           |
| table-noborder | Table with no borders    |
| table-compact  | Table with less paddings |

# Tabs

## CSS Custom Properties

| CSS Custom Property                       | Description                                 |
| ----------------------------------------- | ------------------------------------------- |
| --clr-nav-link-active-font-weight         | Tabs nav link active font weight            |
| --clr-nav-link-font-weight                | Tabs nav link font weight                   |
| --clr-nav-link-color                      | Tabs nav link color                         |
| --clr-nav-link-active-color               | Tabs nav link active color                  |
| --clr-nav-hover-bg-color                  | Tabs nav hover background color             |
| --clr-nav-active-bg-color                 | Tabs nav active background color            |
| --clr-nav-selected-bg-color               | Tabs nav selected background color          |
| --clr-nav-box-shadow-color                | Tabs nav box shadow color                   |
| --clr-nav-active-box-shadow-color         | Tabs nav active box shadow color            |
| --clr-nav-active-border-color             | Tabs nav active border color                |
| --clr-nav-active-border-width             | Tabs nav active border width                |
| --clr-nav-selected-hover-background-color | Tabs nav selected background color on hover |
| --clr-nav-horizontal-gap-size             | Tabs nav horizontal gap size                |
| --clr-nav-vertical-gap-size               | Tabs nav vertical gap size                  |
| --clr-nav-link-dropdown-toggle-padding    | Tabs nav dropdown toggle padding            |
| --clr-nav-horizontal-link-padding         | Tabs nav horizontal link padding            |
| --clr-nav-vertical-link-padding           | Tabs nav vertical link padding              |
| --clr-nav-link-font-size                  | Tabs nav link font size                     |
| --clr-nav-link-line-height                | Tabs nav link line height                   |

## Class names

| Class name    | Description                                   |
| ------------- | --------------------------------------------- |
| tabs-overflow | Used to grouping tabs in overflow tab.        |
| tabs-vertical | Used to display tabs in vertical orientation. |
| tab-content   | Inner class for the content of the tab.       |

# Textarea

## CSS Custom Properties

| CSS Custom Property                      | Description                               |
| ---------------------------------------- | ----------------------------------------- |
| --clr-forms-textarea-background-color    | Background color for textarea.            |
| --clr-forms-textarea-border-radius       | Border radius for textarea.               |
| --clr-forms-textarea-padding             | Textarea padding all sides.               |
| --clr-forms-textarea-wrapper-margin-top  | Parent container of text area margin top. |
| --clr-forms-textarea-disabled-background | Background color of disabled textarea.    |

## CSS Classes

| Class Name           | Description                    |
| -------------------- | ------------------------------ |
| clr-textarea-wrapper | Wrapper class for the textarea |
| clr-textarea         | Class for the textarea element |

# Timeline

## CSS Custom Properties

| CSS Custom Property                         | Description                           |
| ------------------------------------------- | ------------------------------------- |
| --clr-timeline-line-color                   | Timeline line color                   |
| --clr-timeline-step-header-color            | Timeline step header text color       |
| --clr-timeline-step-title-color             | Timeline step title text color        |
| --clr-timeline-step-description-color       | Timeline step description text color  |
| --clr-timeline-incomplete-step-color        | Incomplete timeline step circle color |
| --clr-timeline-current-step-color           | Current timeline step circle color    |
| --clr-timeline-success-step-color           | Successful timeline step circle color |
| --clr-timeline-error-step-color             | Failed timeline step circle color     |
| --clr-timeline-step-title-font-weight       | Timeline step title font weight       |
| --clr-timeline-step-title-font-size         | Timeline step title font size         |
| --clr-timeline-step-title-line-height       | Timeline step title line height       |
| --clr-timeline-step-header-font-weight      | Timeline step header font weight      |
| --clr-timeline-step-header-font-size        | Timeline step header font size        |
| --clr-timeline-step-header-line-height      | Timeline step header line height      |
| --clr-timeline-step-description-font-weight | Timeline step description font weight |
| --clr-timeline-step-description-font-size   | Timeline step description font size   |
| --clr-timeline-step-description-line-height | Timeline step description line height |
| --clr-timeline-horizontal-line-length       | Timeline horizontal line length       |
| --clr-timeline-vertical-line-position       | Timeline vertical line position       |
| --clr-timeline-vertical-line-length         | Timeline vertical line length         |
| --clr-timeline-vertical-step-body-margin    | Timeline vertical step body margin    |
| --clr-timeline-icon-size                    | Timeline icon size                    |
| --clr-timeline-spinner-size                 | Timeline spinner size                 |
| --clr-timeline-line-width                   | Timeline line width                   |
| --clr-timeline-step-margin                  | Timeline step outer margin            |

## CSS Classes

| Class name                    | Description                     |
| ----------------------------- | ------------------------------- |
| clr-timeline                  | Main Timeline element           |
| clr-timeline-step             | Timeline step element           |
| clr-timeline-step-header      | Timeline step header            |
| clr-timeline-step-body        | Timeline step body              |
| clr-timeline-step-title       | Timeline step title             |
| clr-timeline-step-description | Timeline step description       |
| clr-timeline-vertical         | Switches timeline vertical mode |

# Toggle

## CSS Custom Properties

| CSS Custom Property                           | Description                                           |
| --------------------------------------------- | ----------------------------------------------------- |
| --clr-toggle-bg-color-off                     | Background color for toggle that is off               |
| --clr-toggle-bg-color-on                      | Background color for toggle that is on                |
| --clr-toggle-handle-bg-color                  | Background color of the handle of the toggle          |
| --clr-toggle-disabled-default-border-color    | Border color for a disabled toggle                    |
| --clr-toggle-disabled-off-border-color        | Border color for disabled toggle that is off          |
| --clr-toggle-disabled-off-bg-color            | Background color for a disabled toggle that is off    |
| --clr-toggle-disabled-off-handle-border-color | Handle border color for a disabled toggle that is off |
| --clr-toggle-disabled-on-border-color         | Border color for disabled toggle that is on           |
| --clr-toggle-disabled-on-bg-color             | Background color for disabled toggle that is on       |
| --clr-toggle-disabled-on-handle-border-color  | Handle border color for disabled toggle that is on    |

## CSS Classes

| Class name         | Description                                                       |
| ------------------ | ----------------------------------------------------------------- |
| clr-toggle-wrapper | Wrapper class for the toggle switch component                     |
| clr-toggle-right   | Class that aligns the toggle switch to the right in the container |

# Tooltip

## CSS Custom Properties

| CSS Custom Property                 | Description                     |
| ----------------------------------- | ------------------------------- |
| --clr-tooltip-background-color      | Tooltip background color        |
| --clr-tooltip-border-radius         | Tooltip element corner radius   |
| --clr-tooltip-color                 | Color of the tooltip text       |
| --clr-tooltip-font-weight           | Font weight of the tooltip text |
| --clr-tooltip-content-padding       | Padding of tooltip content      |
| --clr-tooltip-content-line-height   | Tooltip content line height     |
| --clr-tooltip-content-margin        | Tooltip content margin          |
| --clr-tooltip-arrow-width           | Tooltip arrow width             |
| --clr-tooltip-arrow-height          | Tooltip arrow height            |
| --clr-tooltip-arrow-horizontal-size | Tooltip arrow horizontal size   |
| --clr-tooltip-arrow-vertical-size   | Tooltip arrow vertical size     |

## CSS Classes

| Class name          | Description                                                            |
| ------------------- | ---------------------------------------------------------------------- |
| tooltip             | Main tooltip component element                                         |
| tooltip-content     | Tooltip content container                                              |
| tooltip-trigger     | Tooltip trigger element                                                |
| tooltip-#{POSITION} | Tooltip position identifier (top, bottom, left, right, top-left, etc.) |
| tooltip-#{SIZE}     | Tooltip size identifier (sizes: xs, sm, md, lg)                        |

# Tree view

## CSS Custom Properties

| CSS Custom Property                    | Description                     |
| -------------------------------------- | ------------------------------- |
| --clr-tree-border-radius               | Tree node content border radius |
| --clr-tree-node-caret-link-hover-color | Caret hover color               |
| --clr-tree-link-hover-color            | Tree link hover color           |
| --clr-tree-link-selection-color        | Selected link background color  |
| --clr-tree-link-text-color             | Tree link default font color    |
| --clr-tree-node-caret-color            | Tree link caret color           |
| --clr-tree-node-font-size              | Font size of the text           |
| --clr-tree-node-font-weight            | Font weight of the text         |
| --clr-tree-node-line-height            | Node line height                |
| --clr-tree-node-letter-spacing         | Letter spacing of the text      |

## CSS Classes

| Class name                      | Description                                 |
| ------------------------------- | ------------------------------------------- |
| clr-tree-node                   | Main tree node element                      |
| clr-tree-node-content-container | Wrapper for tree content and caret elements |
| clr-treenode-content            | Content wrapper for tree node               |
| clr-treenode-caret              | Tree node caret button                      |
| clr-tree-node-caret-icon        | Tree node caret icon                        |
| clr-treenode-spinner-container  | Wrapper for tree node spinner               |
| clr-treenode-spinner            | Tree node spinner                           |
| clr-treenode-children           | Wrapper for nested child tree nodes         |
| clr-treenode-link               | Tree node link                              |

# Vertical Nav

## CSS Custom Properties

| CSS Custom Property                             | Description                               |
| ----------------------------------------------- | ----------------------------------------- |
| --clr-vertical-nav-icon-active-color            | Vertical nav active icon color            |
| --clr-vertical-nav-toggle-icon-color            | Vertical nav toggle icon color            |
| --clr-vertical-nav-item-color                   | Vertical nav item font color              |
| --clr-vertical-nav-item-active-color            | Vertical nav item active font color       |
| --clr-vertical-nav-bg-color                     | Vertical nav background color             |
| --clr-vertical-nav-selected-bg-color            | Vertical nav selected background color    |
| --clr-vertical-nav-hover-bg-color               | Vertical nav hover background color       |
| --clr-vertical-nav-trigger-divider-border-width | Vertical nav trigger divider border width |
| --clr-vertical-nav-trigger-divider-border-color | Vertical nav trigger divider border color |
| --clr-vertical-nav-header-font-weight           | Vertical nav header font weight           |
| --clr-vertical-nav-active-bg-color              | Vertical nav active background color      |
| --clr-vertical-nav-active-color                 | Vertical nav active color                 |
| --clr-vertical-nav-toggle-icon-hover-color      | Vertical nav trigger icon hover color     |
| --clr-vertical-nav-toggle-icon-active-color     | Vertical nav trigger icon active color    |
| --clr-vertical-nav-toggle-icon-disabled-color   | Vertical nav trigger icon disabled color  |
| --clr-vertical-nav-item-padding                 | Vertical nav item padding                 |
| --clr-vertical-nav-item-child-padding           | Vertical nav sub items padding            |
| --clr-vertical-nav-item-height                  | Vertical nav item height                  |
| --clr-vertical-nav-item-line-height             | Vertical nav item line height             |
| --clr-vertical-nav-item-font-size               | Vertical nav item font size               |
| --clr-vertical-nav-item-font-weight             | Vertical nav item font weight             |
| --clr-vertical-nav-content-gap                  | Vertical nav content gap                  |
| --clr-vertical-nav-toggle-button-size           | Vertical nav toggle buton size            |
| --clr-vertical-nav-header-padding               | Vertical nav header padding               |
| --clr-vertical-nav-header-font-size             | Vertical nav header font size             |
| --clr-vertical-nav-header-line-height           | Vertical nav header line height           |
| --clr-vertical-nav-item-active-font-weight      | Vertical nav item active font weight      |

## CSS Classes

| Class name             | Description                                                     |
| ---------------------- | --------------------------------------------------------------- |
| clr-vertical-nav       | Vertical nav element                                            |
| nav-content            | Navigation content                                              |
| nav-divider            | Navigation content separator                                    |
| nav-trigger            | Navigation trigger button for collapse/expand state             |
| nav-trigger-icon       | Navigation trigger icon                                         |
| nav-trigger--bottom    | Move navigation trigger at the bottom                           |
| nav-group              | main vertical navigation group element                          |
| nav-group-content      | Wrapper for navigation group content                            |
| nav-group-text         | Navigation group content wrapper text                           |
| nav-group-children     | Wrapper for navigation group children elements                  |
| nav-group-trigger      | Navigation group trigger button for open/close group            |
| nav-group-trigger-icon | Navigation group trigger button icon                            |
| nav-btn                | Button to expand vertical nav when collapsed                    |
| has-icons              | Internal class showing if vertical nav has icons                |
| has-nav-groups         | Internal class showing if vertical nav has at least 1 nav group |

# Wizard

## CSS Custom Properties

| CSS Custom Property                            | Description                                                         |
| ---------------------------------------------- | ------------------------------------------------------------------- |
| --clr-wizard-main-bgcolor                      | Wizard background color                                             |
| --clr-wizard-stepnav-bgcolor                   | Wizard navigation background color                                  |
| --clr-wizard-main-text-color                   | Wizard text color                                                   |
| --clr-wizard-stepnav-text                      | Wizard navigation text color                                        |
| --clr-wizard-stepnav-text--active              | Wizard navigation text color of the currently active element        |
| --clr-wizard-title-text                        | Wizard title text color                                             |
| --clr-wizard-stepnav-border-size               | Wizard navigation border size                                       |
| --clr-wizard-stepnav-item-border-color         | Wizard navigation border color                                      |
| --clr-wizard-stepnav-item-border-color--active | Wizard navigation border color for the currently active element     |
| --clr-wizard-stepnav-active-bgcolor            | Wizard navigation background color for the currently active element |
| --clr-wizard-header-action-color               | Wizard header actions color                                         |
| --clr-wizard-header-action-color--hovered      | Wizard header actions color on hover                                |
| --clr-wizard-border-radius                     | Wizard border radius                                                |
| --clr-wizard-stepnav-active-border-radius      | Wizard active navigation element border radius                      |
| --clr-wizard-stepnav-border-color              | Wizard navigation border color                                      |
| --clr-wizard-box-shadow                        | Wizard highlight indication                                         |
| --clr-wizard-stepnav-link-font-size            | Wizard navigation item font size                                    |
| --clr-wizard-stepnav-link-line-height          | Wizard navigation item line height                                  |
| --clr-wizard-stepnav-item-padding              | Wizard navigation item padding                                      |
| --clr-wizard-stepnav-padding                   | Wizard navigation padding                                           |
| --clr-wizard-stepnav-link-padding              | Wizard navigation item button padding                               |
| --clr-wizard-stepnav-link-suffix-padding       | Wizard navigation item button suffix padding                        |
| --clr-wizard-stepnav-link-error-icon-color     | Wizard navigation item button error icon color                      |
| --clr-wizard-stepnav-item-error-border-color   | Wizard navigation item error border color                           |
| --clr-wizard-page-padding                      | Wizard page content padding                                         |
| --clr-wizard-footer-padding                    | Wizard page footer padding                                          |
| --clr-wizard-footer-height                     | Wizard page footer height                                           |
| --clr-wizard-stepnav-link-hover-bg-color       | Wizard navigation item button background color on hover             |
| --clr-wizard-title-padding                     | Wizard title padding                                                |
| --clr-wizard-title-font-size                   | Wizard title font size                                              |
| --clr-wizard-title-line-height                 | Wizard title line height                                            |
| --clr-wizard-content-background-color          | Wizard content background color                                     |
| --clr-wizard-header-padding                    | Wizard page header padding                                          |
| --clr-wizard-footer-buttons-wrapper-gap        | Wizard page footer gap size between buttons                         |

## CSS Classes

| Class name                         | Description                                    |
| ---------------------------------- | ---------------------------------------------- |
| clr-wizard                         | Main wizard element                            |
| clr-wizard-content                 | Wizard content container                       |
| clr-wizard-page                    | Wizard page container                          |
| wizard-#{SIZE}                     | Wizard size; sizes: [md, lg, xl]               |
| clr-wizard-btn                     | Wizard control button                          |
| clr-wizard-title                   | Wizard title elelment                          |
| clr-wizard-header-action           | Wizard header action                           |
| clr-wizard-stepnav                 | Wizard navigation container                    |
| clr-wizard-stepnav-list            | Wizard navigation list                         |
| clr-wizard-stepnav-item            | Wizard navigation item                         |
| clr-wizard-stepnav-link            | Wizard navigation item link indicator          |
| clr-wizard-stepnav-link-suffix     | Wizard navigation item link state indicator    |
| clr-wizard-stepnav-item-error-icon | Wizard navigation item error icon              |
| clr-wizard-footer                  | Wizard footer                                  |
| clr-wizard-footer-buttons          | Wizard footer buttons container                |
| clr-wizard--no-title               | Remove wizard dialog title                     |
| clr-wizard--no-shadow              | Remove wizard dialog shadow                    |
| clr-wizard-stepnav-wrapper         | Internal wrapper for the wizard navigation     |
| clr-wizard-footer-buttons-wrapper  | Internal wrapper for the wizard footer buttons |
| clr-wizard-btn-wrapper             | Internal wrapper for wizard control buttons    |
