/*!
 * cmmn-js - cmmn-modeler v0.20.0
 *
 * Copyright (c) 2014-present, camunda Services GmbH
 *
 * Released under the bpmn.io license
 * http://bpmn.io/license
 *
 * Source Code: https://github.com/bpmn-io/cmmn-js
 *
 * Date: 2020-05-02
 */
(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.CmmnJS = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var Ids = _dereq_(252);

var Viewer = _dereq_(3);

var NavigatedViewer = _dereq_(2);

var initialDiagram = '<?xml version="1.0" encoding="UTF-8"?>' + '<cmmn:definitions xmlns:dc="http://www.omg.org/spec/CMMN/20151109/DC" ' + 'xmlns:di="http://www.omg.org/spec/CMMN/20151109/DI" ' + 'xmlns:cmmndi="http://www.omg.org/spec/CMMN/20151109/CMMNDI" ' + 'xmlns:cmmn="http://www.omg.org/spec/CMMN/20151109/MODEL" ' + 'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" id="Test" ' + 'targetNamespace="http://bpmn.io/schema/cmmn">' + '<cmmn:case id="Case_1">' + '<cmmn:casePlanModel id="CasePlanModel_1" name="A CasePlanModel">' + '<cmmn:planItem id="PlanItem_1" definitionRef="Task_1" />' + '<cmmn:task id="Task_1" />' + '</cmmn:casePlanModel>' + '</cmmn:case>' + '<cmmndi:CMMNDI>' + '<cmmndi:CMMNDiagram id="CMMNDiagram_1">' + '<cmmndi:Size width="500" height="500" />' + '<cmmndi:CMMNShape id="DI_CasePlanModel_1" cmmnElementRef="CasePlanModel_1">' + '<dc:Bounds x="114" y="63" width="534" height="389" />' + '<cmmndi:CMMNLabel />' + '</cmmndi:CMMNShape>' + '<cmmndi:CMMNShape id="PlanItem_1_di" cmmnElementRef="PlanItem_1">' + '<dc:Bounds x="150" y="96" width="100" height="80" />' + '<cmmndi:CMMNLabel />' + '</cmmndi:CMMNShape>' + '</cmmndi:CMMNDiagram>' + '</cmmndi:CMMNDI>' + '</cmmn:definitions>';

/**
 * A modeler for CMMN 1.1 diagrams.
 *
 * Have a look at {@link NavigatedViewer} or {@link Modeler} for bundles that include
 * additional features.

 *
 * ## Extending the Modeler
 *
 * In order to extend the viewer pass extension modules to bootstrap via the
 * `additionalModules` option. An extension module is an object that exposes
 * named services.
 *
 * The following example depicts the integration of a simple
 * logging component that integrates with interaction events:
 *
 *
 * ```javascript
 *
 * // logging component
 * function InteractionLogger(eventBus) {
 *   eventBus.on('element.hover', function(event) {
 *     console.log()
 *   })
 * }
 *
 * InteractionLogger.$inject = [ 'eventBus' ]; // minification save
 *
 * // extension module
 * var extensionModule = {
 *   __init__: [ 'interactionLogger' ],
 *   interactionLogger: [ 'type', InteractionLogger ]
 * };
 *
 * // extend the viewer
 * var cmmnModeler = new Modeler({ additionalModules: [ extensionModule ] });
 * cmmnModeler.importXML(...);
 * ```
 *
 *
 * ## Customizing / Replacing Components
 *
 * You can replace individual diagram components by redefining them in override modules.
 * This works for all components, including those defined in the core.
 *
 * Pass in override modules via the `options.additionalModules` flag like this:
 *
 * ```javascript
 * function CustomContextPadProvider(contextPad) {
 *
 *   contextPad.registerProvider(this);
 *
 *   this.getContextPadEntries = function(element) {
 *     // no entries, effectively disable the context pad
 *     return {};
 *   };
 * }
 *
 * CustomContextPadProvider.$inject = [ 'contextPad' ];
 *
 * var overrideModule = {
 *   contextPadProvider: [ 'type', CustomContextPadProvider ]
 * };
 *
 * var cmmnModeler = new Modeler({ additionalModules: [ overrideModule ]});
 * ```
 *
 * @param {Object} [options] configuration options to pass to the viewer
 * @param {DOMElement} [options.container] the container to attach to
 * @param {String|Number} [options.width] the width of the viewer
 * @param {String|Number} [options.height] the height of the viewer
 * @param {Object} [options.moddleExtensions] extension packages to provide
 * @param {Array<didi.Module>} [options.modules] a list of modules to override the default modules
 * @param {Array<didi.Module>} [options.additionalModules] a list of modules to use with the default modules
 */
function Modeler(options) {
  Viewer.call(this, options);

  // hook ID collection into the modeler
  this.on('import.parse.complete', function (event) {
    if (!event.error) {
      this._collectIds(event.definitions, event.context);
    }
  }, this);

  this.on('diagram.destroy', function () {
    this.get('moddle').ids.clear();
  }, this);
}

inherits(Modeler, Viewer);

module.exports = Modeler;

module.exports.Viewer = Viewer;

module.exports.NavigatedViewer = NavigatedViewer;

/**
 * Create a new diagram to start modeling.
 *
 * @param {Function} [done]
 */
Modeler.prototype.createDiagram = function (done) {
  return this.importXML(initialDiagram, done);
};

/**
 * Create a moddle instance, attaching ids to it.
 *
 * @param {Object} options
 */
Modeler.prototype._createModdle = function (options) {
  var moddle = Viewer.prototype._createModdle.call(this, options);

  // attach ids to moddle to be able to track
  // and validated ids in the CMMN 1.1 XML document
  // tree
  moddle.ids = new Ids([32, 36, 1]);

  return moddle;
};

/**
 * Collect ids processed during parsing of the
 * definitions object.
 *
 * @param {ModdleElement} definitions
 * @param {Context} context
 */
Modeler.prototype._collectIds = function (definitions, context) {

  var moddle = definitions.$model,
      ids = moddle.ids,
      id;

  // remove references from previous import
  ids.clear();

  for (id in context.elementsById) {
    ids.claim(id, context.elementsById[id]);
  }
};

Modeler.prototype._interactionModules = [
// non-modeling components
_dereq_(110).default, _dereq_(225).default, _dereq_(227).default, _dereq_(230).default, _dereq_(50)];

Modeler.prototype._modelingModules = [
// modeling components
_dereq_(117).default, _dereq_(141).default, _dereq_(179).default, _dereq_(197).default, _dereq_(124).default, _dereq_(10), _dereq_(12), _dereq_(14), _dereq_(16), _dereq_(20), _dereq_(44), _dereq_(52), _dereq_(68), _dereq_(63), _dereq_(56)];

// modules the modeler is composed of
//
// - viewer modules
// - interaction modules
// - modeling modules

Modeler.prototype._modules = [].concat(Modeler.prototype._modules, Modeler.prototype._interactionModules, Modeler.prototype._modelingModules);

},{"10":10,"110":110,"117":117,"12":12,"124":124,"14":14,"141":141,"16":16,"179":179,"197":197,"2":2,"20":20,"225":225,"227":227,"230":230,"252":252,"253":253,"3":3,"44":44,"50":50,"52":52,"56":56,"63":63,"68":68}],2:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var Viewer = _dereq_(3);

/**
 * A viewer that includes mouse navigation facilities
 *
 * @param {Object} options
 */
function NavigatedViewer(options) {
  Viewer.call(this, options);
}

inherits(NavigatedViewer, Viewer);

module.exports = NavigatedViewer;

NavigatedViewer.prototype._navigationModules = [_dereq_(230).default, _dereq_(227).default];

NavigatedViewer.prototype._modules = [].concat(NavigatedViewer.prototype._modules, NavigatedViewer.prototype._navigationModules);

},{"227":227,"230":230,"253":253,"3":3}],3:[function(_dereq_,module,exports){
/**
 * The code in the <project-logo></project-logo> area
 * must not be changed.
 *
 * @see http://bpmn.io/license for more information.
 */
'use strict';

var assign = _dereq_(254).assign,
    omit = _dereq_(254).omit,
    isNumber = _dereq_(254).isNumber;

var inherits = _dereq_(253);

var domify = _dereq_(255).domify,
    domQuery = _dereq_(255).query,
    domRemove = _dereq_(255).remove;

var innerSVG = _dereq_(275).innerSVG;

var Diagram = _dereq_(89).default,
    CmmnModdle = _dereq_(78).default;

var Importer = _dereq_(71);

function checkValidationError(err) {

  // check if we can help the user by indicating wrong CMMN 1.1 xml
  // (in case he or the exporting tool did not get that right)

  var pattern = /unparsable content <([^>]+)> detected([\s\S]*)$/;
  var match = pattern.exec(err.message);

  if (match) {
    err.message = 'unparsable content <' + match[1] + '> detected; ' + 'this may indicate an invalid CMMN 1.1 diagram file' + match[2];
  }

  return err;
}

var DEFAULT_OPTIONS = {
  width: '100%',
  height: '100%',
  position: 'relative'
};

/**
 * Ensure the passed argument is a proper unit (defaulting to px)
 */
function ensureUnit(val) {
  return val + (isNumber(val) ? 'px' : '');
}

/**
 * A viewer for CMMN 1.1 diagrams.
 *
 * Have a look at {@link NavigatedViewer} or {@link Modeler} for bundles that include
 * additional features.
 *
 *
 * ## Extending the Viewer
 *
 * In order to extend the viewer pass extension modules to bootstrap via the
 * `additionalModules` option. An extension module is an object that exposes
 * named services.
 *
 * The following example depicts the integration of a simple
 * logging component that integrates with interaction events:
 *
 *
 * ```javascript
 *
 * // logging component
 * function InteractionLogger(eventBus) {
 *   eventBus.on('element.hover', function(event) {
 *     console.log()
 *   })
 * }
 *
 * InteractionLogger.$inject = [ 'eventBus' ]; // minification save
 *
 * // extension module
 * var extensionModule = {
 *   __init__: [ 'interactionLogger' ],
 *   interactionLogger: [ 'type', InteractionLogger ]
 * };
 *
 * // extend the viewer
 * var cmmnViewer = new Viewer({ additionalModules: [ extensionModule ] });
 * cmmnViewer.importXML(...);
 * ```
 *
 * @param {Object} [options] configuration options to pass to the viewer
 * @param {DOMElement} [options.container] the container to attach to
 * @param {String|Number} [options.width] the width of the viewer
 * @param {String|Number} [options.height] the height of the viewer
 * @param {Object} [options.moddleExtensions] extension packages to provide
 * @param {Array<didi.Module>} [options.modules] a list of modules to override the default modules
 * @param {Array<didi.Module>} [options.additionalModules] a list of modules to use with the default modules
 */
function Viewer(options) {

  options = assign({}, DEFAULT_OPTIONS, options);

  this._moddle = this._createModdle(options);

  this._container = this._createContainer(options);

  /* <project-logo> */

  addProjectLogo(this._container);

  /* </project-logo> */

  this._init(this._container, this._moddle, options);
}

inherits(Viewer, Diagram);

module.exports = Viewer;

/**
 * Parse and render a CMMN 1.1 diagram.
 *
 * Once finished the viewer reports back the result to the
 * provided callback function with (err, warnings).
 *
 * ## Life-Cycle Events
 *
 * During import the viewer will fire life-cycle events:
 *
 *   * import.parse.start (about to read model from xml)
 *   * import.parse.complete (model read; may have worked or not)
 *   * import.render.start (graphical import start)
 *   * import.render.complete (graphical import finished)
 *   * import.done (everything done)
 *
 * You can use these events to hook into the life-cycle.
 *
 * @param {String} xml the CMMN 1.1 xml
 * @param {Function} [done] invoked with (err, warnings=[])
 */
Viewer.prototype.importXML = function (xml, done) {

  // done is optional
  done = done || function () {};

  var self = this;

  // hook in pre-parse listeners +
  // allow xml manipulation
  xml = this._emit('import.parse.start', { xml: xml }) || xml;

  this._moddle.fromXML(xml, 'cmmn:Definitions', function (err, definitions, context) {

    // hook in post parse listeners +
    // allow definitions manipulation
    definitions = self._emit('import.parse.complete', {
      error: err,
      definitions: definitions,
      context: context
    }) || definitions;

    var parseWarnings = context.warnings;

    if (err) {
      err = checkValidationError(err);

      self._emit('import.done', { error: err, warnings: parseWarnings });

      return done(err, parseWarnings);
    }

    self.importDefinitions(definitions, function (err, importWarnings) {
      var allWarnings = [].concat(parseWarnings, importWarnings || []);

      self._emit('import.done', { error: err, warnings: allWarnings });

      done(err, allWarnings);
    });
  });
};

/**
 * Export the currently displayed CMMN 1.1 diagram as
 * a CMMN 1.1 XML document.
 *
 * ## Life-Cycle Events
 *
 * During XML saving the viewer will fire life-cycle events:
 *
 *   * saveXML.start (before serialization)
 *   * saveXML.serialized (after xml generation)
 *   * saveXML.done (everything done)
 *
 * You can use these events to hook into the life-cycle.
 *
 * @param {Object} [options] export options
 * @param {Boolean} [options.format=false] output formated XML
 * @param {Boolean} [options.preamble=true] output preamble
 *
 * @param {Function} done invoked with (err, xml)
 */
Viewer.prototype.saveXML = function (options, done) {

  if (!done) {
    done = options;
    options = {};
  }

  var self = this;

  var definitions = this._definitions;

  if (!definitions) {
    return done(new Error('no definitions loaded'));
  }

  // allow to fiddle around with definitions
  definitions = this._emit('saveXML.start', {
    definitions: definitions
  }) || definitions;

  this._moddle.toXML(definitions, options, function (err, xml) {

    try {
      xml = self._emit('saveXML.serialized', {
        error: err,
        xml: xml
      }) || xml;

      self._emit('saveXML.done', {
        error: err,
        xml: xml
      });
    } catch (e) {
      console.error('error in saveXML life-cycle listener', e);
    }

    done(err, xml);
  });
};

Viewer.prototype.saveSVG = function (options, done) {

  if (!done) {
    done = options;
    options = {};
  }

  var canvas = this.get('canvas');

  var contentNode = canvas.getDefaultLayer(),
      defsNode = domQuery('defs', canvas._svg);

  var contents = innerSVG(contentNode),
      defs = defsNode && defsNode.outerHTML || '';

  var bbox = contentNode.getBBox();

  var svg = '<?xml version="1.0" encoding="utf-8"?>\n' + '<!-- created with cmmn-js / http://bpmn.io -->\n' + '<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n' + '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" ' + 'width="' + bbox.width + '" height="' + bbox.height + '" ' + 'viewBox="' + bbox.x + ' ' + bbox.y + ' ' + bbox.width + ' ' + bbox.height + '" version="1.1">' + defs + contents + '</svg>';

  done(null, svg);
};

Viewer.prototype.importDefinitions = function (definitions, done) {

  // use try/catch to not swallow synchronous exceptions
  // that may be raised during model parsing
  try {

    if (this._definitions) {
      // clear existing rendered diagram
      this.clear();
    }

    // update definitions
    this._definitions = definitions;

    // perform graphical import
    Importer.importCmmnDiagram(this, definitions, done);
  } catch (e) {

    // handle synchronous errors
    done(e);
  }
};

Viewer.prototype.attachTo = function (parentNode) {

  if (!parentNode) {
    throw new Error('parentNode required');
  }

  // ensure we detach from the
  // previous, old parent
  this.detach();

  // unwrap jQuery if provided
  if (parentNode.get && parentNode.constructor.prototype.jquery) {
    parentNode = parentNode.get(0);
  }

  if (typeof parentNode === 'string') {
    parentNode = domQuery(parentNode);
  }

  parentNode.appendChild(this._container);

  this._emit('attach', {});

  this.get('canvas').resized();
};

Viewer.prototype.getDefinitions = function () {
  return this._definitions;
};

Viewer.prototype.detach = function () {

  var container = this._container,
      parentNode = container.parentNode;

  if (!parentNode) {
    return;
  }

  this._emit('detach', {});

  parentNode.removeChild(container);
};

Viewer.prototype.getModules = function () {
  return this._modules;
};

/**
 * Destroy the viewer instance and remove all its
 * remainders from the document tree.
 */
Viewer.prototype.destroy = function () {

  // diagram destroy
  Diagram.prototype.destroy.call(this);

  // dom detach
  domRemove(this._container);
};

/**
 * Register an event listener
 *
 * Remove a previously added listener via {@link #off(event, callback)}.
 *
 * @param {String} event
 * @param {Number} [priority]
 * @param {Function} callback
 * @param {Object} [that]
 */
Viewer.prototype.on = function (event, priority, callback, target) {
  return this.get('eventBus').on(event, priority, callback, target);
};

/**
 * De-register an event listener
 *
 * @param {String} event
 * @param {Function} callback
 */
Viewer.prototype.off = function (event, callback) {
  this.get('eventBus').off(event, callback);
};

Viewer.prototype._init = function (container, moddle, options) {

  var baseModules = options.modules || this.getModules(),
      additionalModules = options.additionalModules || [],
      staticModules = [{
    cmmnjs: ['value', this],
    moddle: ['value', moddle]
  }];

  var diagramModules = [].concat(staticModules, baseModules, additionalModules);

  var diagramOptions = assign(omit(options, 'additionalModules'), {
    canvas: assign({}, options.canvas, { container: container }),
    modules: diagramModules
  });

  // invoke diagram constructor
  Diagram.call(this, diagramOptions);

  if (options && options.container) {
    this.attachTo(options.container);
  }
};

/**
 * Emit an event on the underlying {@link EventBus}
 *
 * @param  {String} type
 * @param  {Object} event
 *
 * @return {Object} event processing result (if any)
 */
Viewer.prototype._emit = function (type, event) {
  return this.get('eventBus').fire(type, event);
};

Viewer.prototype._createContainer = function (options) {

  var container = domify('<div class="cjs-container"></div>');

  assign(container.style, {
    width: ensureUnit(options.width),
    height: ensureUnit(options.height),
    position: options.position
  });

  return container;
};

Viewer.prototype._createModdle = function (options) {
  var moddleOptions = assign({}, this._moddleExtensions, options.moddleExtensions);

  return new CmmnModdle(moddleOptions);
};

// modules the viewer is composed of
Viewer.prototype._modules = [_dereq_(5), _dereq_(206).default, _dereq_(184).default];

/* <project-logo> */

var PoweredBy = _dereq_(77),
    domEvent = _dereq_(255).event;

/**
 * Adds the project logo to the diagram container as
 * required by the bpmn.io license.
 *
 * @see http://bpmn.io/license
 *
 * @param {Element} container
 */
function addProjectLogo(container) {

  var linkMarkup = '<a href="http://bpmn.io" ' + 'target="_blank" ' + 'class="bjs-powered-by" ' + 'title="Powered by bpmn.io" ' + 'style="position: absolute; bottom: 15px; right: 15px; z-index: 100; ' + PoweredBy.LINK_STYLES + '">' + PoweredBy.BPMNIO_IMG + '</a>';

  var linkElement = domify(linkMarkup);

  container.appendChild(linkElement);

  domEvent.bind(linkElement, 'click', function (event) {
    PoweredBy.open();

    event.preventDefault();
  });
}

/* </project-logo> */

},{"184":184,"206":206,"253":253,"254":254,"255":255,"275":275,"5":5,"71":71,"77":77,"78":78,"89":89}],4:[function(_dereq_,module,exports){
'use strict';

var ModelUtil = _dereq_(76),
    getDefinition = ModelUtil.getDefinition,
    getSentry = ModelUtil.getSentry;

var isAny = _dereq_(45).isAny;

var forEach = _dereq_(254).forEach,
    isArray = _dereq_(254).isArray;

/**
 * @class
 *
 * A registry that keeps track of all items in the model.
 */
function ItemRegistry(elementRegistry, eventBus) {
  this._items = {};
  this._referencedBy = {};

  this._elementRegistry = elementRegistry;
  this._eventBus = eventBus;

  this._init();
}

ItemRegistry.$inject = ['elementRegistry', 'eventBus'];

module.exports = ItemRegistry;

ItemRegistry.prototype._init = function (config) {

  var eventBus = this._eventBus;

  eventBus.on('diagram.destroy', 500, this._clear, this);
  eventBus.on('diagram.clear', 500, this._clear, this);
};

ItemRegistry.prototype._clear = function () {
  this._items = {};
  this._referencedBy = {};
};

/**
 * Register a given item.
 *
 * @param {ModdleElement} item
 */
ItemRegistry.prototype.add = function (item) {

  var items = this._items,
      id = item.id,
      definitions = this._referencedBy,
      definition = getReference(item),
      definitionId = definition && definition.id;

  items[id] = item;

  if (definition) {
    definitions[definitionId] = definitions[definitionId] || [];

    if (definitions[definitionId].indexOf(item) === -1) {
      definitions[definitionId].push(item);
    }
  }
};

/**
 * Removes an item from the registry.
 *
 * @param {ModdleElement} item
 */
ItemRegistry.prototype.remove = function (item) {

  var items = this._items,
      id = item.id,
      definitions = this._referencedBy,
      definition = getReference(item),
      definitionId = definition && definition.id;

  delete items[id];

  if (definition) {

    var referencingItems = definitions[definitionId] || [],
        idx = referencingItems.indexOf(item);

    if (idx !== -1) {
      referencingItems.splice(idx, 1);
    }

    if (!referencingItems.length) {
      delete definitions[definitionId];
    }
  }
};

/**
 * Update the registration with the new id.
 *
 * @param {ModdleElement} item
 * @param {String} newId
 */
ItemRegistry.prototype.updateId = function (element, newId) {

  var items, item;

  if (typeof element === 'string') {
    element = this.get(element);
  }

  if (isDefinition(element)) {
    items = this._referencedBy;
  } else {
    items = this._items;
  }

  if (element) {

    item = items[element.id];

    delete items[element.id];

    items[newId] = item;
  }
};

/**
 * Update the registration.
 *
 * @param {ModdleElement} item
 * @param {ModdleElement} newReference
 */
ItemRegistry.prototype.updateReference = function (item, newReference) {

  var definitions = this._referencedBy,
      oldDefinition = getReference(item),
      oldDefinitionId = oldDefinition && oldDefinition.id;

  if (oldDefinition) {

    var referencingItems = definitions[oldDefinitionId] || [],
        idx = referencingItems.indexOf(item);

    if (idx !== -1) {
      referencingItems.splice(idx, 1);
    }

    if (!referencingItems.length) {
      delete definitions[oldDefinitionId];
    }
  }

  if (newReference) {

    var newReferenceId = newReference.id;
    if (newReferenceId) {

      definitions[newReferenceId] = definitions[newReferenceId] || [];

      if (definitions[newReferenceId].indexOf(item) === -1) {
        definitions[newReferenceId].push(item);
      }
    }
  }
};

/**
 * Return the item for a given id.
 *
 * @param {String} id for selecting the item
 *
 * @return {ModdleElement}
 */
ItemRegistry.prototype.get = function (id) {
  return this._items[id];
};

/**
 * Return all items that match a given filter function.
 *
 * @param {Function} fn
 *
 * @return {Array<ModdleElement>}
 */
ItemRegistry.prototype.filter = function (fn) {

  var filtered = [];

  this.forEach(function (element, definition) {
    if (fn(element, definition)) {
      filtered.push(element);
    }
  });

  return filtered;
};

/**
 * Return all items.
 *
 * @return {Array<ModdleElement>}
 */
ItemRegistry.prototype.getAll = function () {
  return this.filter(function (e) {
    return e;
  });
};

/**
 * Iterate over all items.
 *
 * @param {Function} fn
 */
ItemRegistry.prototype.forEach = function (fn) {

  var items = this._items;

  forEach(items, function (item) {
    return fn(item, getReference(item));
  });
};

/**
 * Return for given definition all referenced items.
 *
 * @param {String|ModdleElement} filter
 */
ItemRegistry.prototype.getReferences = function (filter) {
  var id = filter.id || filter;
  return (this._referencedBy[id] || []).slice();
};

/**
 * Return for a given item id the shape element.
 *
 * @param {String|ModdleElement} filter
 */
ItemRegistry.prototype.getShape = function (filter) {
  var id = filter.id || filter;
  return this._elementRegistry && this._elementRegistry.get(id);
};

/**
 * Return for a given filter all shapes.
 *
 * @param {Array<String>|String|ModdleElement} filter
 */
ItemRegistry.prototype.getShapes = function (filter) {

  var shapes = [],
      self = this;

  function add(shape) {
    shape && shapes.push(shape);
  }

  if (isArray(filter)) {

    forEach(filter, function (f) {
      add(self.getShape(f));
    });
  } else if (isDefinition(filter)) {

    var referencedBy = self.getReferences(filter);
    forEach(referencedBy, function (reference) {
      add(self.getShape(reference));
    });
  } else {
    add(self.getShape(filter));
  }

  return shapes;
};

function getReference(item) {
  return getDefinition(item) || getSentry(item);
}

function isDefinition(item) {
  return isAny(item, ['cmmn:PlanItemDefinition', 'cmmn:Sentry', 'cmmn:CaseFileItemDefinition']);
}

},{"254":254,"45":45,"76":76}],5:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [_dereq_(8), _dereq_(73)],
  itemRegistry: ['type', _dereq_(4)]
};

},{"4":4,"73":73,"8":8}],6:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253),
    isArray = _dereq_(254).isArray,
    isObject = _dereq_(254).isObject,
    assign = _dereq_(254).assign;

var BaseRenderer = _dereq_(100).default,
    TextUtil = _dereq_(249).default,
    DiUtil = _dereq_(74),
    ModelUtil = _dereq_(76);

var isStandardEventVisible = DiUtil.isStandardEventVisible;
var isPlanningTableCollapsed = DiUtil.isPlanningTableCollapsed;
var isCollapsed = DiUtil.isCollapsed;

var isCasePlanModel = ModelUtil.isCasePlanModel;
var getBusinessObject = ModelUtil.getBusinessObject;
var getDefinition = ModelUtil.getDefinition;
var isRequired = ModelUtil.isRequired;
var isRepeatable = ModelUtil.isRepeatable;
var isManualActivation = ModelUtil.isManualActivation;
var isAutoComplete = ModelUtil.isAutoComplete;
var hasPlanningTable = ModelUtil.hasPlanningTable;
var getName = ModelUtil.getName;
var is = ModelUtil.is;
var getStandardEvent = ModelUtil.getStandardEvent;

var domQuery = _dereq_(255).query;

var svgAppend = _dereq_(275).append,
    svgAttr = _dereq_(275).attr,
    svgClasses = _dereq_(275).classes,
    svgCreate = _dereq_(275).create;

var translate = _dereq_(248).translate;

var createLine = _dereq_(247).createLine;

function CmmnRenderer(eventBus, styles, pathMap) {

  BaseRenderer.call(this, eventBus);

  var TASK_BORDER_RADIUS = 10;
  var MILESTONE_BORDER_RADIUS = 24;
  var STAGE_EDGE_OFFSET = 20;

  var LABEL_STYLE = {
    fontFamily: 'Arial, sans-serif',
    fontSize: '12px'
  };

  var textUtil = new TextUtil({
    style: LABEL_STYLE,
    size: { width: 100 }
  });

  var markers = {};

  function addMarker(id, element) {
    markers[id] = element;
  }

  function marker(id) {
    return markers[id];
  }

  function initMarkers(svg) {

    function createMarker(id, options) {
      var attrs = assign({
        fill: 'black',
        strokeWidth: 1,
        strokeLinecap: 'round',
        strokeDasharray: 'none'
      }, options.attrs);

      var ref = options.ref || { x: 0, y: 0 };

      var scale = options.scale || 1;

      // fix for safari / chrome / firefox bug not correctly
      // resetting stroke dash array
      if (attrs.strokeDasharray === 'none') {
        attrs.strokeDasharray = [10000, 1];
      }

      var marker = svgCreate('marker');

      svgAttr(options.element, attrs);

      svgAppend(marker, options.element);

      svgAttr(marker, {
        id: id,
        viewBox: '0 0 20 20',
        refX: ref.x,
        refY: ref.y,
        markerWidth: 20 * scale,
        markerHeight: 20 * scale,
        orient: 'auto'
      });

      var defs = domQuery('defs', svg);

      if (!defs) {
        defs = svgCreate('defs');

        svgAppend(svg, defs);
      }

      svgAppend(defs, marker);

      return addMarker(id, marker);
    }

    var associationStart = svgCreate('path');
    svgAttr(associationStart, { d: 'M 11 5 L 1 10 L 11 15' });

    createMarker('association-start', {
      element: associationStart,
      attrs: {
        fill: 'none',
        stroke: 'black',
        strokeWidth: 1.5
      },
      ref: { x: 1, y: 10 },
      scale: 0.5
    });

    var associationEnd = svgCreate('path');
    svgAttr(associationEnd, { d: 'M 1 5 L 11 10 L 1 15' });

    createMarker('association-end', {
      element: associationEnd,
      attrs: {
        fill: 'none',
        stroke: 'black',
        strokeWidth: 1.5
      },
      ref: { x: 12, y: 10 },
      scale: 0.5
    });
  }

  // draw shape //////////////////////////////////////////////////////////////

  function computeStyle(custom, traits, defaultStyles) {
    if (!isArray(traits)) {
      defaultStyles = traits;
      traits = [];
    }

    return styles.style(traits || [], assign(defaultStyles, custom || {}));
  }

  function drawCircle(parentGfx, width, height, offset, attrs) {

    if (isObject(offset)) {
      attrs = offset;
      offset = 0;
    }

    offset = offset || 0;

    attrs = computeStyle(attrs, {
      stroke: 'black',
      strokeWidth: 2,
      fill: 'white'
    });

    var cx = width / 2,
        cy = height / 2;

    var circle = svgCreate('circle');
    svgAttr(circle, {
      cx: cx,
      cy: cy,
      r: Math.round((width + height) / 4 - offset)
    });
    svgAttr(circle, attrs);

    svgAppend(parentGfx, circle);

    return circle;
  }

  function drawRect(parentGfx, width, height, r, offset, attrs) {

    if (isObject(offset)) {
      attrs = offset;
      offset = 0;
    }

    offset = offset || 0;

    attrs = computeStyle(attrs, {
      stroke: 'black',
      strokeWidth: 2,
      fill: 'white'
    });

    var rect = svgCreate('rect');
    svgAttr(rect, {
      x: offset,
      y: offset,
      width: width - offset * 2,
      height: height - offset * 2,
      rx: r,
      ry: r
    });
    svgAttr(rect, attrs);

    svgAppend(parentGfx, rect);

    return rect;
  }

  function drawDiamond(parentGfx, width, height, attrs) {

    var x_2 = width / 2;
    var y_2 = height / 2;

    var points = [{ x: x_2, y: 0 }, { x: width, y: y_2 }, { x: x_2, y: height }, { x: 0, y: y_2 }];

    var pointsString = points.map(function (point) {
      return point.x + ',' + point.y;
    }).join(' ');

    attrs = computeStyle(attrs, {
      stroke: 'black',
      strokeWidth: 2,
      fill: 'white'
    });

    var polygon = svgCreate('polygon');
    svgAttr(polygon, {
      points: pointsString
    });
    svgAttr(polygon, attrs);

    svgAppend(parentGfx, polygon);

    return polygon;
  }

  function drawPath(parentGfx, d, attrs) {

    attrs = computeStyle(attrs, ['no-fill'], {
      strokeWidth: 2,
      stroke: 'black'
    });

    var path = svgCreate('path');
    svgAttr(path, { d: d });
    svgAttr(path, attrs);

    svgAppend(parentGfx, path);

    return path;
  }

  function drawOctagon(parentGfx, width, height, offset, attrs) {
    offset = offset || 20;

    var x1 = offset;
    var y1 = height;

    var x2 = 0;
    var y2 = height - offset;

    var x3 = 0;
    var y3 = offset;

    var x4 = offset;
    var y4 = 0;

    var x5 = width - offset;
    var y5 = 0;

    var x6 = width;
    var y6 = offset;

    var x7 = width;
    var y7 = height - offset;

    var x8 = width - offset;
    var y8 = height;

    var points = [{ x: x1, y: y1 }, { x: x2, y: y2 }, { x: x3, y: y3 }, { x: x4, y: y4 }, { x: x5, y: y5 }, { x: x6, y: y6 }, { x: x7, y: y7 }, { x: x8, y: y8 }];

    attrs = attrs || {};
    attrs.fill = 'white';
    attrs.stroke = 'black';
    attrs.strokeWidth = 2;

    return drawPolygon(parentGfx, points, attrs);
  }

  function drawPolygon(parentGfx, points, attrs) {
    var pointsString = points.map(function (point) {
      return point.x + ',' + point.y;
    }).join(' ');

    var polygon = svgCreate('polygon');

    svgAttr(polygon, {
      points: pointsString
    });
    svgAttr(polygon, attrs);

    svgAppend(parentGfx, polygon);

    return polygon;
  }

  // draw connection ////////////////////////////////////////////

  function drawLine(parentGfx, waypoints, attrs) {
    attrs = computeStyle(attrs, ['no-fill'], {
      stroke: 'black',
      strokeWidth: 2,
      fill: 'none'
    });

    var line = createLine(waypoints, attrs);

    svgAppend(parentGfx, line);

    return line;
  }

  function createPathFromConnection(connection) {
    var waypoints = connection.waypoints;

    var pathData = 'm  ' + waypoints[0].x + ',' + waypoints[0].y;
    for (var i = 1; i < waypoints.length; i++) {
      pathData += 'L' + waypoints[i].x + ',' + waypoints[i].y + ' ';
    }
    return pathData;
  }

  // render label //////////////////////////////////////////////

  function renderLabel(parentGfx, label, options) {
    var text = textUtil.createText(label || '', options);
    svgClasses(text).add('djs-label');
    svgAppend(parentGfx, text);

    return text;
  }

  function renderEmbeddedLabel(p, element, align) {
    var name = getName(element);
    return renderLabel(p, name, {
      box: element,
      align: align,
      padding: 5
    });
  }

  function renderExpandedStageLabel(p, element, align) {
    var name = getName(element);
    var textbox = renderLabel(p, name, { box: element, align: align, padding: 5 });

    // reset the position of the text box
    translate(textbox, STAGE_EDGE_OFFSET, 0);

    return textbox;
  }

  function renderCasePlanModelLabel(p, element) {
    var bo = getBusinessObject(element);

    // default maximum textbox dimensions
    var height = 18;
    var width = element.width / 2 - 60;

    var label = bo.name;

    // create text box
    var textBox = renderLabel(p, label, {
      box: { height: height, width: width },
      align: 'left-top'
    });

    var minWidth = 60,
        padding = 40,
        textBoxWidth = textBox.getBBox().width;

    // set polygon width based on actual textbox size
    var polygonWidth = textBoxWidth + padding;

    if (textBoxWidth < minWidth) {
      polygonWidth = minWidth + padding;
    }

    var polygonPoints = [{ x: 10, y: 0 }, { x: 20, y: -height }, { x: polygonWidth, y: -height }, { x: polygonWidth + 10, y: 0 }];

    // The pointer-events attribute is needed to allow clicks on the polygon
    // which otherwise would be prevented by the parent node ('djs-visual').
    var polygon = drawPolygon(p, polygonPoints, {
      fill: 'white',
      stroke: 'black',
      strokeWidth: 2,
      fillOpacity: 0.95,
      'pointer-events': 'all'
    });

    // make sure the textbox is visually on top of the polygon
    textBox.parentNode.insertBefore(polygon, textBox);

    // reset the position of the text box
    translate(textBox, 25, -height + 5);

    return textBox;
  }

  function renderExternalLabel(parentGfx, element) {
    var name = getName(element),
        hide = false;

    var standardEvent = getStandardEvent(element);

    if (standardEvent) {

      var standardEventVisible = isStandardEventVisible(element);
      standardEvent = '[' + standardEvent + ']';

      if (!name) {
        name = standardEvent;
        element.hidden = hide = !standardEventVisible;
      } else {
        if (standardEventVisible) {
          name = name + ' ' + standardEvent;
        }
      }
    }

    var box = {
      width: 90,
      height: 30,
      x: element.width / 2 + element.x,
      y: element.height / 2 + element.y
    };

    element.hidden = element.labelTarget.hidden || hide || !name;

    return renderLabel(parentGfx, name, { box: box, style: { fontSize: '11px' } });
  }

  // render elements //////////////////////////////////////////

  function renderer(type) {
    return handlers[type];
  }

  var handlers = {
    'cmmn:PlanItem': function cmmnPlanItem(p, element) {
      var definition = getDefinition(element);
      return renderer(definition.$type)(p, element);
    },

    'cmmn:DiscretionaryItem': function cmmnDiscretionaryItem(p, element) {
      var definition = getDefinition(element);

      var attrs = {
        strokeDasharray: '10, 12'
      };

      if (is(definition, 'cmmn:Task')) {
        assign(attrs, {
          strokeDasharray: '12, 12.4',
          strokeDashoffset: 13.6
        });
      }

      return renderer(definition.$type)(p, element, attrs);
    },

    // STAGE
    'cmmn:Stage': function cmmnStage(p, element, attrs) {

      attrs = assign({ fillOpacity: 0.95 }, attrs);

      var rect;
      if (isCasePlanModel(element)) {
        return handlers['cmmn:CasePlanModel'](p, element);
      }

      rect = drawOctagon(p, element.width, element.height, STAGE_EDGE_OFFSET, attrs);

      if (!isCollapsed(element)) {
        renderExpandedStageLabel(p, element, 'left-top');
      } else {
        renderEmbeddedLabel(p, element, 'center-middle');
      }

      attachPlanningTableMarker(p, element);
      attachStageMarkers(p, element);
      return rect;
    },

    // STAGE
    'cmmn:PlanFragment': function cmmnPlanFragment(p, element, attrs) {

      var rect = drawRect(p, element.width, element.height, TASK_BORDER_RADIUS, {
        strokeDasharray: '10, 12',
        fillOpacity: 0.95
      });

      renderEmbeddedLabel(p, element, isCollapsed(element) ? 'center-middle' : 'left-top');

      attachStageMarkers(p, element);
      return rect;
    },

    'cmmn:CasePlanModel': function cmmnCasePlanModel(p, element) {
      var rect = drawRect(p, element.width, element.height, 0, {
        fillOpacity: 0.95
      });
      renderCasePlanModelLabel(p, element);
      attachPlanningTableMarker(p, element);
      attachCasePlanModelMarkers(p, element);
      return rect;
    },

    // MILESTONE
    'cmmn:Milestone': function cmmnMilestone(p, element, attrs) {
      var rect = drawRect(p, element.width, element.height, MILESTONE_BORDER_RADIUS, attrs);
      renderEmbeddedLabel(p, element, 'center-middle');
      attachTaskMarkers(p, element);
      return rect;
    },

    // EVENT LISTENER
    'cmmn:EventListener': function cmmnEventListener(p, element, attrs) {
      var outerCircle = drawCircle(p, element.width, element.height, attrs);

      attrs = attrs || {};
      attrs.strokeWidth = 2;

      drawCircle(p, element.width, element.height, 0.1 * element.height, attrs);
      return outerCircle;
    },

    'cmmn:TimerEventListener': function cmmnTimerEventListener(p, element, attrs) {
      var circle = renderer('cmmn:EventListener')(p, element, attrs);

      var pathData = pathMap.getScaledPath('EVENT_TIMER_WH', {
        xScaleFactor: 0.75,
        yScaleFactor: 0.75,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: 0.5,
          my: 0.5
        }
      });

      drawPath(p, pathData, {
        strokeWidth: 2,
        strokeLinecap: 'square'
      });

      for (var i = 0; i < 12; i++) {

        var linePathData = pathMap.getScaledPath('EVENT_TIMER_LINE', {
          xScaleFactor: 0.75,
          yScaleFactor: 0.75,
          containerWidth: element.width,
          containerHeight: element.height,
          position: {
            mx: 0.5,
            my: 0.5
          }
        });

        var width = element.width / 2;
        var height = element.height / 2;

        drawPath(p, linePathData, {
          strokeWidth: 1,
          strokeLinecap: 'square',
          transform: 'rotate(' + i * 30 + ',' + height + ',' + width + ')'
        });
      }

      return circle;
    },

    'cmmn:UserEventListener': function cmmnUserEventListener(p, element, attrs) {
      var circle = renderer('cmmn:EventListener')(p, element, attrs);

      // TODO: The user event decorator has to be
      // scaled correctly!
      var x = 20;
      var y = 15;

      var pathData = pathMap.getScaledPath('TASK_TYPE_USER_1', {
        abspos: {
          x: x,
          y: y
        }
      });

      /* user path */drawPath(p, pathData, {
        strokeWidth: 0.5,
        fill: 'none'
      });

      var pathData2 = pathMap.getScaledPath('TASK_TYPE_USER_2', {
        abspos: {
          x: x,
          y: y
        }
      });

      /* user2 path */drawPath(p, pathData2, {
        strokeWidth: 0.5,
        fill: 'none'
      });

      var pathData3 = pathMap.getScaledPath('TASK_TYPE_USER_3', {
        abspos: {
          x: x,
          y: y
        }
      });

      /* user3 path */drawPath(p, pathData3, {
        strokeWidth: 0.5,
        fill: 'black'
      });

      return circle;
    },

    // TASK
    'cmmn:Task': function cmmnTask(p, element, attrs) {
      var rect = drawRect(p, element.width, element.height, TASK_BORDER_RADIUS, attrs);
      renderEmbeddedLabel(p, element, 'center-middle');
      attachTaskMarkers(p, element);
      return rect;
    },

    'cmmn:HumanTask': function cmmnHumanTask(p, element, attrs) {
      var task = renderer('cmmn:Task')(p, element, attrs);

      var bo = element.businessObject;
      var definition = bo.definitionRef;

      if (definition.isBlocking) {
        var x = 15;
        var y = 12;

        var pathData1 = pathMap.getScaledPath('TASK_TYPE_USER_1', {
          abspos: {
            x: x,
            y: y
          }
        });

        /* user path */drawPath(p, pathData1, {
          strokeWidth: 0.5,
          fill: 'none'
        });

        var pathData2 = pathMap.getScaledPath('TASK_TYPE_USER_2', {
          abspos: {
            x: x,
            y: y
          }
        });

        /* user2 path */drawPath(p, pathData2, {
          strokeWidth: 0.5,
          fill: 'none'
        });

        var pathData3 = pathMap.getScaledPath('TASK_TYPE_USER_3', {
          abspos: {
            x: x,
            y: y
          }
        });

        /* user3 path */drawPath(p, pathData3, {
          strokeWidth: 0.5,
          fill: 'black'
        });
      } else {
        var pathData = pathMap.getScaledPath('TASK_TYPE_MANUAL', {
          abspos: {
            x: 17,
            y: 15
          }
        });

        /* manual path */drawPath(p, pathData, {
          strokeWidth: 1.25,
          fill: 'white',
          stroke: 'black'
        });
      }

      attachPlanningTableMarker(p, element);

      return task;
    },

    'cmmn:CaseTask': function cmmnCaseTask(p, element, attrs) {
      var task = renderer('cmmn:Task')(p, element, attrs);

      var pathData = pathMap.getScaledPath('TASK_TYPE_FOLDER', {
        abspos: {
          x: 7,
          y: 7
        }
      });

      /* manual path */drawPath(p, pathData, {
        strokeWidth: 1.25,
        fill: 'white',
        stroke: 'black'
      });

      return task;
    },

    'cmmn:ProcessTask': function cmmnProcessTask(p, element, attrs) {
      var task = renderer('cmmn:Task')(p, element, attrs);

      var pathData = pathMap.getScaledPath('TASK_TYPE_CHEVRON', {
        abspos: {
          x: 5,
          y: 5
        }
      });

      /* manual path */drawPath(p, pathData, {
        strokeWidth: 1.25,
        fill: 'white',
        stroke: 'black'
      });

      return task;
    },

    'cmmn:DecisionTask': function cmmnDecisionTask(p, element, attrs) {
      var task = renderer('cmmn:Task')(p, element, attrs);

      var headerPathData = pathMap.getScaledPath('TASK_TYPE_BUSINESS_RULE_HEADER', {
        abspos: {
          x: 8,
          y: 8
        }
      });

      drawPath(p, headerPathData, {
        strokeWidth: 1,
        fill: '000'
      });

      var headerData = pathMap.getScaledPath('TASK_TYPE_BUSINESS_RULE_MAIN', {
        abspos: {
          x: 8,
          y: 8
        }
      });

      drawPath(p, headerData, {
        strokeWidth: 1
      });

      return task;
    },

    'cmmn:CaseFileItem': function cmmnCaseFileItem(p, element, attrs) {
      var pathData = pathMap.getScaledPath('DATA_OBJECT_PATH', {
        xScaleFactor: 1,
        yScaleFactor: 1,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: 0.474,
          my: 0.296
        }
      });

      return drawPath(p, pathData, { fill: 'white' });
    },

    // ARTIFACTS
    'cmmn:TextAnnotation': function cmmnTextAnnotation(p, element) {
      var style = {
        'fill': 'none',
        'stroke': 'none'
      };
      var textElement = drawRect(p, element.width, element.height, 0, 0, style);
      var textPathData = pathMap.getScaledPath('TEXT_ANNOTATION', {
        xScaleFactor: 1,
        yScaleFactor: 1,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: 0.0,
          my: 0.0
        }
      });
      drawPath(p, textPathData);

      var text = getBusinessObject(element).text || '';
      renderLabel(p, text, { box: element, align: 'left-middle', padding: 5 });

      return textElement;
    },

    'cmmn:Association': function cmmnAssociation(p, element, attrs) {

      var semantic = getBusinessObject(element);

      attrs = assign({
        strokeDasharray: '0.5, 5',
        strokeLinecap: 'round',
        strokeLinejoin: 'round'
      }, attrs || {});

      if (semantic.associationDirection === 'One' || semantic.associationDirection === 'Both') {
        attrs.markerEnd = marker('association-end');
      }

      if (semantic.associationDirection === 'Both') {
        attrs.markerStart = marker('association-start');
      }

      return drawLine(p, element.waypoints, attrs);
    },

    // MARKERS
    'StageMarker': function StageMarker(p, element) {
      var markerRect = drawRect(p, 14, 14, 0, {
        strokeWidth: 1,
        stroke: 'black'
      });

      translate(markerRect, element.width / 2 - 7, element.height - 17);

      var path = isCollapsed(element) ? 'MARKER_STAGE_COLLAPSED' : 'MARKER_STAGE_EXPANDED';

      var stagePath = pathMap.getScaledPath(path, {
        xScaleFactor: 1.5,
        yScaleFactor: 1.5,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: (element.width / 2 - 7) / element.width,
          my: (element.height - 17) / element.height
        }
      });

      drawPath(p, stagePath);
    },

    'RequiredMarker': function RequiredMarker(p, element, position) {
      var path = pathMap.getScaledPath('MARKER_REQUIRED', {
        xScaleFactor: 1,
        yScaleFactor: 1,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: (element.width / 2 + position) / element.width,
          my: (element.height - 17) / element.height
        }
      });

      drawPath(p, path, { strokeWidth: 3 });
    },

    'AutoCompleteMarker': function AutoCompleteMarker(p, element, position) {
      var markerRect = drawRect(p, 11, 14, 0, {
        strokeWidth: 1,
        stroke: 'black',
        fill: 'black'
      });

      translate(markerRect, element.width / 2 + position + 2, element.height - 17);
    },

    'ManualActivationMarker': function ManualActivationMarker(p, element, position) {
      var path = pathMap.getScaledPath('MARKER_MANUAL_ACTIVATION', {
        xScaleFactor: 1,
        yScaleFactor: 1,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: (element.width / 2 + position) / element.width,
          my: (element.height - 17) / element.height
        }
      });

      drawPath(p, path, { strokeWidth: 1 });
    },

    'RepetitionMarker': function RepetitionMarker(p, element, position) {
      var path = pathMap.getScaledPath('MARKER_REPEATABLE', {
        xScaleFactor: 1,
        yScaleFactor: 1,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: (element.width / 2 + position) / element.width,
          my: (element.height - 17) / element.height
        }
      });

      drawPath(p, path);
    },

    'PlanningTableMarker': function PlanningTableMarker(p, element, position) {
      var planningTableRect = drawRect(p, 30, 24, 0, {
        strokeWidth: 1.5,
        stroke: 'black'
      });

      translate(planningTableRect, element.width / 2 - 15, -17);

      var isCollapsed = isPlanningTableCollapsed(element);

      var marker = isCollapsed ? 'MARKER_PLANNING_TABLE_COLLAPSED' : 'MARKER_PLANNING_TABLE_EXPANDED';

      var stagePath = pathMap.getScaledPath(marker, {
        xScaleFactor: 1.5,
        yScaleFactor: 1.5,
        containerWidth: element.width,
        containerHeight: element.height,
        position: {
          mx: (element.width / 2 - 15) / element.width,
          my: -17 / element.height
        }
      });

      drawPath(p, stagePath, {
        strokeWidth: 1.5
      });
    },

    'cmmn:OnPart': function cmmnOnPart(p, element) {
      var pathData = createPathFromConnection(element);

      var path = drawPath(p, pathData, {
        strokeDasharray: '10, 5, 2, 5, 2, 5',
        strokeWidth: 1.5
      });

      return path;
    },
    'cmmn:PlanItemOnPart': function cmmnPlanItemOnPart(p, element) {
      return renderer('cmmn:OnPart')(p, element);
    },
    'cmmn:CaseFileItemOnPart': function cmmnCaseFileItemOnPart(p, element) {
      return renderer('cmmn:OnPart')(p, element);
    },
    'cmmn:EntryCriterion': function cmmnEntryCriterion(p, element) {
      return drawDiamond(p, element.width, element.height, {
        fill: 'white'
      });
    },
    'cmmn:ExitCriterion': function cmmnExitCriterion(p, element) {
      return drawDiamond(p, element.width, element.height, {
        fill: 'black'
      });
    },

    'cmmndi:CMMNEdge': function cmmndiCMMNEdge(p, element) {

      var bo = getBusinessObject(element);

      if (bo.cmmnElementRef) {
        return renderer(bo.cmmnElementRef.$type)(p, element);
      }

      var pathData = createPathFromConnection(element);

      var path = drawPath(p, pathData, {
        strokeDasharray: '3, 5',
        strokeWidth: 1
      });

      return path;
    },

    'label': function label(parentGfx, element) {
      // Update external label size and bounds during rendering when
      // we have the actual rendered bounds anyway.

      var textElement = renderExternalLabel(parentGfx, element);

      var textBBox;

      try {
        textBBox = textElement.getBBox();
      } catch (e) {
        textBBox = { width: 0, height: 0, x: 0 };
      }

      // update element.x so that the layouted text is still
      // center alligned (newX = oldMidX - newWidth / 2)
      element.x = Math.ceil(element.x + element.width / 2) - Math.ceil(textBBox.width / 2);

      // take element width, height from actual bounds
      element.width = Math.ceil(textBBox.width);
      element.height = Math.ceil(textBBox.height);

      // compensate bounding box x
      svgAttr(textElement, {
        transform: 'translate(' + -1 * textBBox.x + ',0)'
      });

      return textElement;
    }
  };

  // attach markers /////////////////////////

  function attachTaskMarkers(p, element) {
    var obj = getBusinessObject(element);
    var padding = 6;

    var markers = [];

    if (isRequired(obj)) {
      markers.push({ marker: 'RequiredMarker', width: 1 });
    }

    if (isManualActivation(obj)) {
      markers.push({ marker: 'ManualActivationMarker', width: 14 });
    }

    if (isRepeatable(obj)) {
      markers.push({ marker: 'RepetitionMarker', width: 14 });
    }

    if (markers.length) {

      if (markers.length === 1) {
        // align marker in the middle of the element
        drawMarker(markers[0].marker, p, element, markers[0].width / 2 * -1);
      } else if (markers.length === 2) {
        /* align marker:
         *
         *      |             |
         *      +-------------+
         *             ^
         *             |
         *         +-+   +-+
         *         |0|   |1| <-- markers
         *         +-+   +-+
         * (leftMarker)  (rightMarker)
         */
        drawMarker(markers[0].marker, p, element, markers[0].width * -1 - padding / 2);
        drawMarker(markers[1].marker, p, element, padding / 2);
      } else if (markers.length === 3) {
        /* align marker:
         *
         *      |             |
         *      +-------------+
         *             ^
         *             |
         *      +-+   +-+   +-+
         *      |0|   |1|   |2| <-- markers
         *      +-+   +-+   +-+
         */

        /* 1 */drawMarker(markers[1].marker, p, element, markers[1].width / 2 * -1);
        /* 0 */drawMarker(markers[0].marker, p, element, markers[1].width / 2 * -1 - padding - markers[0].width);
        /* 2 */drawMarker(markers[2].marker, p, element, markers[1].width / 2 + padding);
      }
    }
  }

  function attachCasePlanModelMarkers(p, element) {
    var obj = getBusinessObject(element);

    if (isAutoComplete(obj)) {
      drawMarker('AutoCompleteMarker', p, element, -7);
    }
  }

  function attachStageMarkers(p, element, stage) {
    var obj = getBusinessObject(element);
    var padding = 6;

    drawMarker('StageMarker', p, element, -7);

    var leftMarkers = [];

    if (isRequired(obj)) {
      leftMarkers.push({ marker: 'RequiredMarker', width: 1 });
    }

    if (isAutoComplete(obj)) {
      leftMarkers.push({ marker: 'AutoCompleteMarker', width: 14 });
    }

    if (leftMarkers.length) {

      if (leftMarkers.length === 1) {
        drawMarker(leftMarkers[0].marker, p, element, leftMarkers[0].width * -1 - 7 - padding);
      } else if (leftMarkers.length === 2) {
        drawMarker(leftMarkers[0].marker, p, element, leftMarkers[1].width * -1 - 7 - padding - leftMarkers[0].width * -1 - padding);

        drawMarker(leftMarkers[1].marker, p, element, leftMarkers[1].width * -1 - 7 - padding);
      }
    }

    var rightMarkers = [];

    if (isManualActivation(obj)) {
      rightMarkers.push({ marker: 'ManualActivationMarker', width: 14 });
    }

    if (isRepeatable(obj)) {
      rightMarkers.push({ marker: 'RepetitionMarker', width: 14 });
    }

    if (rightMarkers.length) {

      if (rightMarkers.length === 1) {
        drawMarker(rightMarkers[0].marker, p, element, 7 + padding);
      } else if (rightMarkers.length === 2) {
        drawMarker(rightMarkers[0].marker, p, element, 7 + padding);
        drawMarker(rightMarkers[1].marker, p, element, 7 + padding + rightMarkers[0].width + padding);
      }
    }
  }

  function attachPlanningTableMarker(p, element) {
    if (hasPlanningTable(element)) {
      drawMarker('PlanningTableMarker', p, element);
    }
  }

  function drawMarker(marker, parent, element, position) {
    renderer(marker)(parent, element, position);
  }

  // draw shape and connection ////////////////////////////////////

  function drawShape(parent, element) {
    var h = handlers[element.type];

    /* jshint -W040 */
    if (!h) {
      return BaseRenderer.prototype.drawShape.apply(this, [parent, element]);
    } else {
      return h(parent, element);
    }
  }

  function drawConnection(parent, element) {
    var type = element.type;
    var h = handlers[type];

    /* jshint -W040 */
    if (!h) {
      return BaseRenderer.prototype.drawConnection.apply(this, [parent, element]);
    } else {
      return h(parent, element);
    }
  }

  this.canRender = function (element) {
    return is(element, 'cmmn:CMMNElement') || is(element, 'cmmndi:CMMNEdge');
  };

  this.drawShape = drawShape;
  this.drawConnection = drawConnection;

  // hook onto canvas init event to initialize
  // connection start/end markers on svg
  eventBus.on('canvas.init', function (event) {
    initMarkers(event.svg);
  });
}

inherits(CmmnRenderer, BaseRenderer);

CmmnRenderer.$inject = ['eventBus', 'styles', 'pathMap'];

module.exports = CmmnRenderer;

},{"100":100,"247":247,"248":248,"249":249,"253":253,"254":254,"255":255,"275":275,"74":74,"76":76}],7:[function(_dereq_,module,exports){
'use strict';

/**
 * Map containing SVG paths needed by CmmnRenderer.
 */

function PathMap() {

  var PATH_USER_TYPE_1 = 'm {mx},{my} c 0.909,-0.845 1.594,-2.049 1.594,-3.385 0,-2.554 -1.805,-4.62199999 ' + '-4.357,-4.62199999 -2.55199998,0 -4.28799998,2.06799999 -4.28799998,4.62199999 0,1.348 ' + '0.974,2.562 1.89599998,3.405 -0.52899998,0.187 -5.669,2.097 -5.794,4.7560005 v 6.718 ' + 'h 17 v -6.718 c 0,-2.2980005 -5.5279996,-4.5950005 -6.0509996,-4.7760005 z' + 'm -8,6 l 0,5.5 m 11,0 l 0,-5';

  var PATH_USER_TYPE_2 = 'm {mx},{my} m 2.162,1.009 c 0,2.4470005 -2.158,4.4310005 -4.821,4.4310005 ' + '-2.66499998,0 -4.822,-1.981 -4.822,-4.4310005';

  var PATH_USER_TYPE_3 = 'm {mx},{my} m -6.9,-3.80 c 0,0 2.25099998,-2.358 4.27399998,-1.177 2.024,1.181 4.221,1.537 ' + '4.124,0.965 -0.098,-0.57 -0.117,-3.79099999 -4.191,-4.13599999 -3.57499998,0.001 ' + '-4.20799998,3.36699999 -4.20699998,4.34799999 z';

  /**
   * Contains a map of path elements
   *
   * <h1>Path definition</h1>
   * A parameterized path is defined like this:
   * <pre>
   * 'EVENT_TIMER_WH': {
   *   d: 'M {mx},{my} l {e.x0},-{e.y0} m -{e.x0},{e.y0} l {e.x1},{e.y1} ',
   *   height: 17.5,
   *   width:  17.5,
   *   heightElements: [2.5, 7.5],
   *   widthElements: [2.5, 7.5]
   * }
   * </pre>
   * <p>It's important to specify a correct <b>height and width</b> for the path as the scaling
   * is based on the ratio between the specified height and width in this object and the
   * height and width that is set as scale target (Note x,y coordinates will be scaled with
   * individual ratios).</p>
   * <p>The '<b>heightElements</b>' and '<b>widthElements</b>' array must contain the values that will be scaled.
   * The scaling is based on the computed ratios.
   * Coordinates on the y axis should be in the <b>heightElement</b>'s array, they will be scaled using
   * the computed ratio coefficient.
   * In the parameterized path the scaled values can be accessed through the 'e' object in {} brackets.
   *   <ul>
   *    <li>The values for the y axis can be accessed in the path string using {e.y0}, {e.y1}, ....</li>
   *    <li>The values for the x axis can be accessed in the path string using {e.x0}, {e.x1}, ....</li>
   *   </ul>
   *   The numbers x0, x1 respectively y0, y1, ... map to the corresponding array index.
   * </p>
   */
  this.pathMap = {

    // TASK DECORATOR

    'TASK_TYPE_FOLDER': {
      d: 'm {mx},{my} l18,0 l0,12 l-18,0 l0,-12 m 2,0 l3,-4 l5,0 l3,4'
    },
    'TASK_TYPE_CHEVRON': {
      d: 'm {mx},{my} l15,0 l6,6 l-6,6 l-15,0 l6,-6 l-6,-6'
    },
    'TASK_TYPE_USER_1': {
      d: PATH_USER_TYPE_1
    },
    'TASK_TYPE_USER_2': {
      d: PATH_USER_TYPE_2
    },
    'TASK_TYPE_USER_3': {
      d: PATH_USER_TYPE_3
    },
    'TASK_TYPE_MANUAL': {
      d: 'm {mx},{my} c 0.234,-0.01 5.604,0.008 8.029,0.004 0.808,0 1.271,-0.172 1.417,-0.752 0.227,-0.898 ' + '-0.334,-1.314 -1.338,-1.316 -2.467,-0.01 -7.886,-0.004 -8.108,-0.004 -0.014,-0.079 0.016,-0.533 0,-0.61 ' + '0.195,-0.042 8.507,0.006 9.616,0.002 0.877,-0.007 1.35,-0.438 1.353,-1.208 0.003,-0.768 -0.479,-1.09 ' + '-1.35,-1.091 -2.968,-0.002 -9.619,-0.013 -9.619,-0.013 v -0.591 c 0,0 5.052,-0.016 7.225,-0.016 ' + '0.888,-0.002 1.354,-0.416 1.351,-1.193 -0.006,-0.761 -0.492,-1.196 -1.361,-1.196 -3.473,-0.005 ' + '-10.86,-0.003 -11.0829995,-0.003 -0.022,-0.047 -0.045,-0.094 -0.069,-0.139 0.3939995,-0.319 ' + '2.0409995,-1.626 2.4149995,-2.017 0.469,-0.4870005 0.519,-1.1650005 0.162,-1.6040005 -0.414,-0.511 ' + '-0.973,-0.5 -1.48,-0.236 -1.4609995,0.764 -6.5999995,3.6430005 -7.7329995,4.2710005 -0.9,0.499 ' + '-1.516,1.253 -1.882,2.19 -0.37000002,0.95 -0.17,2.01 -0.166,2.979 0.004,0.718 -0.27300002,1.345 ' + '-0.055,2.063 0.629,2.087 2.425,3.312 4.859,3.318 4.6179995,0.014 9.2379995,-0.139 13.8569995,-0.158 ' + '0.755,-0.004 1.171,-0.301 1.182,-1.033 0.012,-0.754 -0.423,-0.969 -1.183,-0.973 -1.778,-0.01 ' + '-5.824,-0.004 -6.04,-0.004 10e-4,-0.084 0.003,-0.586 10e-4,-0.67 z'
    },

    'TASK_TYPE_BUSINESS_RULE_HEADER': {
      d: 'm {mx},{my} 0,4 20,0 0,-4 z'
    },
    'TASK_TYPE_BUSINESS_RULE_MAIN': {
      d: 'm {mx},{my} 0,12 20,0 0,-12 z' + 'm 0,8 l 20,0 ' + 'm -13,-4 l 0,8'
    },

    // EVENT LISTENER DECORATOR

    'EVENT_TIMER_WH': {
      d: 'M {mx},{my} l {e.x0},-{e.y0} m -{e.x0},{e.y0} l {e.x1},{e.y1} ',
      height: 36,
      width: 36,
      heightElements: [10, 2],
      widthElements: [3, 7]
    },
    'EVENT_TIMER_LINE': {
      d: 'M {mx},{my} ' + 'm {e.x0},{e.y0} l -{e.x1},{e.y1} ',
      height: 36,
      width: 36,
      heightElements: [10, 3],
      widthElements: [0, 0]
    },

    'EVENT_USER_1': {
      d: PATH_USER_TYPE_1,
      height: 36,
      width: 36,
      heightElements: [],
      widthElements: []

    },
    'EVENT_USER_2': {
      d: PATH_USER_TYPE_2,
      height: 36,
      width: 36,
      heightElements: [],
      widthElements: []
    },
    'EVENT_USER_3': {
      d: PATH_USER_TYPE_3,
      height: 36,
      width: 36,
      heightElements: [],
      widthElements: []
    },

    // MARKERS

    'MARKER_STAGE_EXPANDED': {
      d: 'm{mx},{my} m 2,7 l 10,0',
      height: 10,
      width: 10,
      heightElements: [],
      widthElements: []
    },
    'MARKER_STAGE_COLLAPSED': {
      d: 'm{mx},{my} m 2,7 l 10,0 m -5,-5 l 0,10',
      height: 10,
      width: 10,
      heightElements: [],
      widthElements: []
    },
    'MARKER_REQUIRED': {
      d: 'm{mx},{my} l 0,9 m 0,2 l0,3',
      height: 14,
      width: 3,
      heightElements: [],
      widthElements: []
    },

    'MARKER_MANUAL_ACTIVATION': {
      d: 'm{mx}, {my} l 14,7 l -14,7 l 0,-14 z',
      height: 14,
      width: 14,
      heightElements: [],
      widthElements: []
    },

    'MARKER_REPEATABLE': {
      d: 'm{mx},{my} m 3,0 l 0,14 m 6,-14 l 0,14 m -10,-10 l 14,0 m -14,6 l 14,0',
      height: 14,
      width: 14,
      heightElements: [],
      widthElements: []
    },

    'MARKER_PLANNING_TABLE_EXPANDED': {
      d: 'm{mx},{my} m 0,12 l 30,0 m -20,-12 l 0, 24 m 10, -24 l 0, 24 m -10, -6 l 10,0',
      height: 24,
      width: 30,
      heightElements: [],
      widthElements: []
    },
    'MARKER_PLANNING_TABLE_COLLAPSED': {
      d: 'm{mx},{my} m 0,12 l 30,0 m -20,-12 l 0, 24 m 10, -24 l 0, 24 m -10, -6 l 10,0 m -5, -6 l 0,12',
      height: 10,
      width: 10,
      heightElements: [],
      widthElements: []
    },

    'DATA_OBJECT_PATH': {
      d: 'm 0,0 {e.x1},0 {e.x0},{e.y0} 0,{e.y1} -{e.x2},0 0,-{e.y2} {e.x1},0 0,{e.y0} {e.x0},0',
      height: 61,
      width: 51,
      heightElements: [10, 50, 60],
      widthElements: [10, 40, 50, 60]
    },

    'TEXT_ANNOTATION': {
      d: 'm {mx}, {my} m 10,0 l -10,0 l 0,{e.y0} l 10,0',
      height: 30,
      width: 10,
      heightElements: [30],
      widthElements: [10]
    }
  };

  this.getRawPath = function getRawPath(pathId) {
    return this.pathMap[pathId].d;
  };

  /**
   * Scales the path to the given height and width.
   * <h1>Use case</h1>
   * <p>Use case is to scale the content of elements (event) based
   * on the element bounding box's size.
   * </p>
   * <h1>Why not transform</h1>
   * <p>Scaling a path with transform() will also scale the stroke and IE does not support
   * the option 'non-scaling-stroke' to prevent this.
   * Also there are use cases where only some parts of a path should be
   * scaled.</p>
   *
   * @param {String} pathId The ID of the path.
   * @param {Object} param <p>
   *   Example param object scales the path to 60% size of the container (data.width, data.height).
   *   <pre>
   *   {
   *     xScaleFactor: 0.6,
   *     yScaleFactor:0.6,
   *     containerWidth: data.width,
   *     containerHeight: data.height,
   *     position: {
   *       mx: 0.46,
   *       my: 0.2,
   *     }
   *   }
   *   </pre>
   *   <ul>
   *    <li>targetpathwidth = xScaleFactor * containerWidth</li>
   *    <li>targetpathheight = yScaleFactor * containerHeight</li>
   *    <li>Position is used to set the starting coordinate of the path. M is computed:
    *    <ul>
    *      <li>position.x * containerWidth</li>
    *      <li>position.y * containerHeight</li>
    *    </ul>
    *    Center of the container <pre> position: {
   *       mx: 0.5,
   *       my: 0.5,
   *     }</pre>
   *     Upper left corner of the container
   *     <pre> position: {
   *       mx: 0.0,
   *       my: 0.0,
   *     }</pre>
   *    </li>
   *   </ul>
   * </p>
   *
   */
  this.getScaledPath = function getScaledPath(pathId, param) {
    var rawPath = this.pathMap[pathId];

    // positioning
    // compute the start point of the path
    var mx, my;

    if (param.abspos) {
      mx = param.abspos.x;
      my = param.abspos.y;
    } else {
      mx = param.containerWidth * param.position.mx;
      my = param.containerHeight * param.position.my;
    }

    var coordinates = {}; // map for the scaled coordinates
    if (param.position) {

      // path
      var heightRatio = param.containerHeight / rawPath.height * param.yScaleFactor;
      var widthRatio = param.containerWidth / rawPath.width * param.xScaleFactor;

      // Apply height ratio
      for (var heightIndex = 0; heightIndex < rawPath.heightElements.length; heightIndex++) {
        coordinates['y' + heightIndex] = rawPath.heightElements[heightIndex] * heightRatio;
      }

      // Apply width ratio
      for (var widthIndex = 0; widthIndex < rawPath.widthElements.length; widthIndex++) {
        coordinates['x' + widthIndex] = rawPath.widthElements[widthIndex] * widthRatio;
      }
    }

    // Apply value to raw path
    var path = format(rawPath.d, {
      mx: mx,
      my: my,
      e: coordinates
    });
    return path;
  };
}

module.exports = PathMap;

// helpers /////////////////

// copied from https://github.com/adobe-webplatform/Snap.svg/blob/master/src/svg.js
var tokenRegex = /\{([^}]+)\}/g,
    objNotationRegex = /(?:(?:^|\.)(.+?)(?=\[|\.|$|\()|\[('|")(.+?)\2\])(\(\))?/g; // matches .xxxxx or ["xxxxx"] to run over object properties

function replacer(all, key, obj) {
  var res = obj;
  key.replace(objNotationRegex, function (all, name, quote, quotedName, isFunc) {
    name = name || quotedName;
    if (res) {
      if (name in res) {
        res = res[name];
      }
      typeof res == 'function' && isFunc && (res = res());
    }
  });
  res = (res == null || res == obj ? all : res) + '';

  return res;
}

function format(str, obj) {
  return String(str).replace(tokenRegex, function (all, key) {
    return replacer(all, key, obj);
  });
}

},{}],8:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: ['cmmnRenderer'],
  cmmnRenderer: ['type', _dereq_(6)],
  pathMap: ['type', _dereq_(7)]
};

},{"6":6,"7":7}],9:[function(_dereq_,module,exports){
'use strict';

var is = _dereq_(76).is,
    getDefinition = _dereq_(76).getDefinition;

var inherits = _dereq_(253);

var forEach = _dereq_(254).forEach;

var AutoResizeProvider = _dereq_(107).default;

/**
 * This module provides a CMMN specific check if an element
 * can be resized.
 */
function CmmnAutoResizeProvider(eventBus) {
  AutoResizeProvider.call(this, eventBus);
}

inherits(CmmnAutoResizeProvider, AutoResizeProvider);

CmmnAutoResizeProvider.$inject = ['eventBus'];

module.exports = CmmnAutoResizeProvider;

/**
 * Check if the given shape can be expanded
 *
 * @param  {Array<djs.model.Shape>} elements
 * @param  {djs.model.Shape} target
 *
 * @return {boolean}
 */
CmmnAutoResizeProvider.prototype.canResize = function (elements, target) {

  if (!is(target, 'cmmn:CMMNElement')) {
    return;
  }

  var criterionsOnly = true;

  forEach(elements, function (element) {
    if (!is(element, 'cmmn:Criterion')) {
      criterionsOnly = false;
      return;
    }
  });

  // prevent auto expand if the selected elements are exclusively criterions
  if (criterionsOnly) {
    return;
  }

  var definition = getDefinition(target);

  return is(definition, 'cmmn:PlanFragment');
};

},{"107":107,"253":253,"254":254,"76":76}],10:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: ['cmmnAutoResizeProvider'],
  __depends__: [_dereq_(108).default],
  cmmnAutoResizeProvider: ['type', _dereq_(9)]
};

},{"108":108,"9":9}],11:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(254).assign,
    isArray = _dereq_(254).isArray;

var isAny = _dereq_(45).isAny;

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition;

/**
 * A provider for CMMN 1.1 elements context pad
 */
function ContextPadProvider(contextPad, connect, create, elementFactory, modeling, rules, popupMenu, canvas) {

  contextPad.registerProvider(this);

  this._contextPad = contextPad;
  this._connect = connect;
  this._create = create;
  this._elementFactory = elementFactory;
  this._modeling = modeling;
  this._rules = rules;
  this._popupMenu = popupMenu;
  this._canvas = canvas;
}

ContextPadProvider.$inject = ['contextPad', 'connect', 'create', 'elementFactory', 'modeling', 'rules', 'popupMenu', 'canvas'];

module.exports = ContextPadProvider;

ContextPadProvider.prototype.getContextPadEntries = function (element) {

  var contextPad = this._contextPad,
      connect = this._connect,
      create = this._create,
      elementFactory = this._elementFactory,
      modeling = this._modeling,
      canvas = this._canvas,
      rules = this._rules,
      popupMenu = this._popupMenu;

  var actions = {};

  if (element.type === 'label') {
    return actions;
  }

  function removeElement(e) {
    modeling.removeElements([element]);
  }

  function getReplaceMenuPosition(element) {

    var Y_OFFSET = 5;

    var diagramContainer = canvas.getContainer(),
        pad = contextPad.getPad(element).html;

    var diagramRect = diagramContainer.getBoundingClientRect(),
        padRect = pad.getBoundingClientRect();

    var top = padRect.top - diagramRect.top;
    var left = padRect.left - diagramRect.left;

    var pos = {
      x: left,
      y: top + padRect.height + Y_OFFSET
    };

    return pos;
  }

  function startConnect(event, element, autoActivate) {
    connect.start(event, element, autoActivate);
  }

  function appendCriterionAction(className, title, options) {

    function appendListener(event, element) {
      var shape = elementFactory.createCriterionShape('cmmn:EntryCriterion');
      create.start(event, shape, element);
    }

    return appendAction('cmmn:EntryCriterion', className, title, options, appendListener);
  }

  function appendDiscretionaryItemAction(className, title, options) {

    function appendListener(event, element) {
      var shape = elementFactory.createDiscretionaryItemShape('cmmn:Task');
      create.start(event, shape, element);
    }

    return appendAction('cmmn:DiscretionaryItem', className, title, options, appendListener);
  }

  function appendAction(type, className, title, options, listener) {

    if (typeof title !== 'string') {
      options = title;
      title = 'Append ' + type.replace(/^cmmn:/, '');
    }

    function appendListener(event, element) {
      var shape = elementFactory.createShape(assign({ type: type }, options));
      create.start(event, shape, element);
    }

    return {
      group: 'model',
      className: className,
      title: title,
      action: {
        dragstart: listener || appendListener,
        click: listener || appendListener
      }
    };
  }

  if (isAny(element, ['cmmn:PlanItem', 'cmmn:CaseFileItem'])) {
    assign(actions, {
      'append.entryCriterion': appendCriterionAction('cmmn-icon-entry-criterion', 'Append Criterion')
    });
  }

  if (isBlockingHumanTask(element)) {
    assign(actions, {
      'append.discretionaryItem': appendDiscretionaryItemAction('cmmn-icon-task-discretionary', 'Append DiscretionaryItem')
    });
  }

  if (!popupMenu.isEmpty(element, 'cmmn-replace')) {

    // Replace menu entry
    assign(actions, {
      'replace': {
        group: 'edit',
        className: 'cmmn-icon-screw-wrench',
        title: 'Change type',
        action: {
          click: function click(event, element) {

            var position = assign(getReplaceMenuPosition(element), {
              cursor: { x: event.x, y: event.y }
            });

            popupMenu.open(element, 'cmmn-replace', position);
          }
        }
      }
    });
  }

  if (!isAny(element, ['cmmndi:CMMNEdge', 'cmmn:TextAnnotation'])) {
    assign(actions, {
      'append.text-annotation': appendAction('cmmn:TextAnnotation', 'cmmn-icon-text-annotation')
    });
  }

  if (isAny(element, ['cmmn:PlanItem', 'cmmn:DiscretionaryItem', 'cmmn:CaseFileItem', 'cmmn:Criterion'])) {

    assign(actions, {

      'connect': {
        group: 'connect',
        className: 'cmmn-icon-connection',
        title: 'Connect using Discretionary/OnPart or Association',
        action: {
          click: startConnect,
          dragstart: startConnect
        }
      }
    });
  }

  // delete element entry, only show if allowed by rules
  var deleteAllowed = rules.allowed('elements.delete', { elements: [element] });

  if (isArray(deleteAllowed)) {
    // was the element returned as a deletion candidate?
    deleteAllowed = deleteAllowed[0] === element;
  }

  if (deleteAllowed) {
    assign(actions, {
      'delete': {
        group: 'edit',
        className: 'cmmn-icon-trash',
        title: 'Remove',
        action: {
          click: removeElement
        }
      }
    });
  }

  return actions;
};

function isBlockingHumanTask(element) {
  var definition = getDefinition(element);
  return is(definition, 'cmmn:HumanTask') && definition.isBlocking;
}

},{"254":254,"45":45,"76":76}],12:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [_dereq_(122).default, _dereq_(126).default, _dereq_(128).default, _dereq_(206).default, _dereq_(54)],
  __init__: ['contextPadProvider'],
  contextPadProvider: ['type', _dereq_(11)]
};

},{"11":11,"122":122,"126":126,"128":128,"206":206,"54":54}],13:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var EditorActions = _dereq_(132).default;

/**
 * Registers and executes CMMN specific editor actions.
 *
 * @param {Injector} injector
 */
function CmmnEditorActions(injector) {
  injector.invoke(EditorActions, this);
}

inherits(CmmnEditorActions, EditorActions);

CmmnEditorActions.$inject = ['injector'];

module.exports = CmmnEditorActions;

/**
 * Register default actions.
 *
 * @param {Injector} injector
 */
CmmnEditorActions.prototype._registerDefaultActions = function (injector) {

  // (0) invoke super method

  EditorActions.prototype._registerDefaultActions.call(this, injector);

  // (1) retrieve optional components to integrate with

  var canvas = injector.get('canvas', false);
  var elementRegistry = injector.get('elementRegistry', false);
  var selection = injector.get('selection', false);
  var spaceTool = injector.get('spaceTool', false);
  var lassoTool = injector.get('lassoTool', false);
  var handTool = injector.get('handTool', false);
  var globalConnect = injector.get('globalConnect', false);
  var directEditing = injector.get('directEditing', false);
  var searchPad = injector.get('searchPad', false);

  // (2) check components and register actions

  if (canvas && elementRegistry && selection) {
    this._registerAction('selectElements', function () {
      // select all elements except for the invisible
      // root element
      var rootElement = canvas.getRootElement();

      var elements = elementRegistry.filter(function (element) {
        return element !== rootElement;
      });

      selection.select(elements);

      return elements;
    });
  }

  if (spaceTool) {
    this._registerAction('spaceTool', function () {
      spaceTool.toggle();
    });
  }

  if (lassoTool) {
    this._registerAction('lassoTool', function () {
      lassoTool.toggle();
    });
  }

  if (handTool) {
    this._registerAction('handTool', function () {
      handTool.toggle();
    });
  }

  if (globalConnect) {
    this._registerAction('globalConnectTool', function () {
      globalConnect.toggle();
    });
  }

  if (selection && directEditing) {
    this._registerAction('directEditing', function () {
      var currentSelection = selection.get();

      if (currentSelection.length) {
        directEditing.activate(currentSelection[0]);
      }
    });
  }

  if (searchPad) {
    this._registerAction('find', function () {
      searchPad.toggle();
    });
  }
};

},{"132":132,"253":253}],14:[function(_dereq_,module,exports){
'use strict';

var EditorActionsModule = _dereq_(133).default;

var CmmnEditorActions = _dereq_(13);

module.exports = {
  __depends__: [EditorActionsModule],
  editorActions: ['type', CmmnEditorActions]
};

},{"13":13,"133":133}],15:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var KeyboardBindings = _dereq_(143).default;

/**
 * CMMN specific keyboard bindings.
 *
 * @param {Injector} injector
 */
function CmmnKeyboardBindings(injector) {
  injector.invoke(KeyboardBindings, this);
}

inherits(CmmnKeyboardBindings, KeyboardBindings);

CmmnKeyboardBindings.$inject = ['injector'];

module.exports = CmmnKeyboardBindings;

/**
 * Register available keyboard bindings.
 *
 * @param {Keyboard} keyboard
 * @param {EditorActions} editorActions
 */
CmmnKeyboardBindings.prototype.registerBindings = function (keyboard, editorActions) {

  // inherit default bindings
  KeyboardBindings.prototype.registerBindings.call(this, keyboard, editorActions);

  /**
   * Add keyboard binding if respective editor action
   * is registered.
   *
   * @param {String} action name
   * @param {Function} fn that implements the key binding
   */
  function addListener(action, fn) {

    if (editorActions.isRegistered(action)) {
      keyboard.addListener(fn);
    }
  }

  // select all elements
  // CTRL + A
  addListener('selectElements', function (context) {

    var event = context.keyEvent;

    if (keyboard.isKey(['a', 'A'], event) && keyboard.isCmd(event)) {
      editorActions.trigger('selectElements');

      return true;
    }
  });

  // search labels
  // CTRL + F
  addListener('find', function (context) {

    var event = context.keyEvent;

    if (keyboard.isKey(['f', 'F'], event) && keyboard.isCmd(event)) {
      editorActions.trigger('find');

      return true;
    }
  });

  // activate space tool
  // S
  addListener('spaceTool', function (context) {

    var event = context.keyEvent;

    if (keyboard.hasModifier(event)) {
      return;
    }

    if (keyboard.isKey(['s', 'S'], event)) {
      editorActions.trigger('spaceTool');

      return true;
    }
  });

  // activate lasso tool
  // L
  addListener('lassoTool', function (context) {

    var event = context.keyEvent;

    if (keyboard.hasModifier(event)) {
      return;
    }

    if (keyboard.isKey(['l', 'L'], event)) {
      editorActions.trigger('lassoTool');

      return true;
    }
  });

  // activate hand tool
  // H
  addListener('handTool', function (context) {

    var event = context.keyEvent;

    if (keyboard.hasModifier(event)) {
      return;
    }

    if (keyboard.isKey(['h', 'H'], event)) {
      editorActions.trigger('handTool');

      return true;
    }
  });

  // activate global connect tool
  // C
  addListener('globalConnectTool', function (context) {

    var event = context.keyEvent;

    if (keyboard.hasModifier(event)) {
      return;
    }

    if (keyboard.isKey(['c', 'C'], event)) {
      editorActions.trigger('globalConnectTool');

      return true;
    }
  });

  // activate direct editing
  // E
  addListener('directEditing', function (context) {

    var event = context.keyEvent;

    if (keyboard.hasModifier(event)) {
      return;
    }

    if (keyboard.isKey(['e', 'E'], event)) {
      editorActions.trigger('directEditing');

      return true;
    }
  });
};

},{"143":143,"253":253}],16:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [_dereq_(145).default],
  __init__: ['keyboardBindings'],
  keyboardBindings: ['type', _dereq_(15)]
};

},{"145":145,"15":15}],17:[function(_dereq_,module,exports){
'use strict';

var UpdateLabelHandler = _dereq_(19);

var LabelUtil = _dereq_(18);

var isCasePlanModel = _dereq_(76).isCasePlanModel,
    is = _dereq_(76).is,
    getDefinition = _dereq_(76).getDefinition;

var assign = _dereq_(254).assign;

var LINE_HEIGHT = 14,
    PADDING = 6;

function LabelEditingProvider(eventBus, canvas, directEditing, commandStack) {

  this._canvas = canvas;
  this._commandStack = commandStack;

  directEditing.registerProvider(this);

  commandStack.registerHandler('element.updateLabel', UpdateLabelHandler);

  // listen to dblclick on non-root elements
  eventBus.on('element.dblclick', function (event) {
    directEditing.activate(event.element);
  });

  // complete on followup canvas operation
  eventBus.on(['element.mousedown', 'drag.init', 'canvas.viewbox.changed'], function (event) {
    directEditing.complete();
  });

  // cancel on command stack changes
  eventBus.on(['commandStack.changed'], function () {
    directEditing.cancel();
  });

  eventBus.on('create.end', 500, function (event) {

    var element = event.shape,
        canExecute = event.context.canExecute,
        isTouch = event.isTouch;

    // TODO(nikku): we need to find a way to support the
    // direct editing on mobile devices; right now this will
    // break for desworkflowediting on mobile devices
    // as it breaks the user interaction workflow

    // TODO(nre): we should temporarily focus the edited element
    // here and release the focused viewport after the direct edit
    // operation is finished
    if (isTouch) {
      return;
    }

    if (!canExecute) {
      return;
    }

    directEditing.activate(element);
  });
}

LabelEditingProvider.$inject = ['eventBus', 'canvas', 'directEditing', 'commandStack'];

module.exports = LabelEditingProvider;

/**
 * Activate direct editing.
 *
 * @param  {djs.model.Base} element
 *
 * @return {Object} an object with properties bounds (position and size) and text
 */
LabelEditingProvider.prototype.activate = function (element) {

  var text = LabelUtil.getLabel(element);

  if (text === undefined) {
    return;
  }

  // don't activate for root element
  if (!element.parent) {
    return;
  }

  var target = element.label || element;

  var props = this.getEditingBBox(element);

  var definition = getDefinition(element);

  var options = {};

  if (is(definition, 'cmmn:Task') || is(definition, 'cmmn:Milestone')) {
    options.centerVertically = true;
  }

  if (is(element, 'cmmn:TextAnnotation')) {
    options.autoResize = true;
    options.resizable = true;
  }

  // external labels for event listener, case file items and connections
  if (target.labelTarget) {
    options.autoResize = true;
  }

  return assign({ text: text, options: options }, props);
};

/**
 * Get the editing bounding box based on the element's size and position
 *
 * @param  {djs.model.Base} element
 *
 * @return {Object} an object containing information about position and size (fixed or minimum and/or maximum)
 */
LabelEditingProvider.prototype.getEditingBBox = function (element, maxBounds) {

  var canvas = this._canvas;

  var definition = getDefinition(element);

  var target = element.label || element;

  var bbox = this._canvas.getAbsoluteBBox(target);

  var mid = {
    x: bbox.x + bbox.width / 2,
    y: bbox.y + bbox.height / 2
  };

  // default position
  var bounds = { x: bbox.x, y: bbox.y };

  var style = {};

  var zoom = canvas.zoom();

  // internal labels for case plan models
  if (isCasePlanModel(element)) {
    bounds.height = 50;
    bounds.width = 200;
    bounds.y -= 30;

    style.textAlign = 'left';
  }

  // internal labels for stages and plan fragments (excluding case plan models)
  if (is(definition, 'cmmn:PlanFragment') && !isCasePlanModel(element)) {
    bounds.width = element.width;
    bounds.maxHeight = 3 * LINE_HEIGHT + PADDING; // maximum 3 lines
    bounds.y += 5;

    style.textAlign = 'left';
  }

  // internal labels for tasks
  if (is(definition, 'cmmn:Task') || is(definition, 'cmmn:Milestone')) {

    // fixed size for internal labels:
    // on high zoom levels: text box size === bbox size
    // on low zoom levels: text box size === bbox size at 100% zoom
    // This ensures minimum bounds at low zoom levels
    if (zoom > 1) {
      bounds.width = bbox.width;
      bounds.height = bbox.height;
    } else {
      bounds.width = bbox.width / zoom;
      bounds.height = bbox.height / zoom;
    }

    // centering overlapping text box size at low zoom levels
    if (zoom < 1) {
      bounds.x = bbox.x - (bounds.width / 2 - bbox.width / 2);
      bounds.y = bbox.y - (bounds.height / 2 - bbox.height / 2);
    }
  }

  if (is(element, 'cmmn:TextAnnotation')) {
    bounds.width = bbox.width;
    bounds.height = bbox.height;
    bounds.minWidth = 30 * zoom;
    bounds.minHeight = 10 * zoom;

    style.textAlign = 'left';
  }

  // external labels for event listener, case file items and connections
  if (target.labelTarget) {

    bounds.width = 150;
    bounds.minHeight = LINE_HEIGHT + PADDING; // 1 line
    bounds.x = mid.x - bounds.width / 2;
  }

  return {
    bounds: bounds,
    style: style
  };
};

LabelEditingProvider.prototype.update = function (element, newLabel) {
  this._commandStack.execute('element.updateLabel', {
    element: element,
    newLabel: newLabel
  });
};

},{"18":18,"19":19,"254":254,"76":76}],18:[function(_dereq_,module,exports){
'use strict';

var is = _dereq_(76).is;
var isAny = _dereq_(45).isAny;

var getBusinessObject = _dereq_(76).getBusinessObject;

function getLabelAttr(element) {
  if (is(element, 'cmmn:TextAnnotation')) {
    return 'text';
  }

  return 'name';
}

function getSemantic(element) {
  var bo = getBusinessObject(element);

  if (is(bo, 'cmmndi:CMMNEdge') && bo.cmmnElementRef) {
    bo = bo.cmmnElementRef;
  }

  return bo;
}

/**
 * Check if the given element is of a type which has a reference to a definition.
 * This could be either plan items or discretionary items or case file items.
 *
 * @param {djs.model.Base} element
 *
 * @return {Boolean}
 */
var isReferencing = function isReferencing(element) {
  return isAny(element, ['cmmn:PlanItem', 'cmmn:DiscretionaryItem', 'cmmn:CaseFileItem']);
};

function hasEditableLabel(element) {
  return !isAny(element, ['cmmn:Association', 'cmmn:Criterion', 'cmmndi:CMMNEdge']);
}

var getLabel = function getLabel(element) {

  var semantic = getSemantic(element),
      attr = getLabelAttr(semantic);

  if (!hasEditableLabel(semantic)) {
    return;
  }

  // Get definition as semantic if
  // * the element has no name property set
  // * the element type has a reference to a definition
  if (!semantic[attr] && isReferencing(element)) {
    semantic = semantic.definitionRef;
  }

  return semantic[attr] || '';
};

module.exports.getLabel = getLabel;

var setLabel = function setLabel(element, text, isExternal, isExclusiveRef) {

  var semantic = getSemantic(element),
      attr = getLabelAttr(semantic);

  // Get definition as semantic if
  // * the element has no name property set
  // * the element type has a reference to a definition
  // * the element is the only reference to a defition
  if (!semantic[attr] && isReferencing(element) && isExclusiveRef) {
    semantic = semantic.definitionRef;
  }

  semantic[attr] = text;

  // show external label if not empty
  if (isExternal) {
    element.hidden = !text;
  }

  return element;
};

module.exports.setLabel = setLabel;

},{"45":45,"76":76}],19:[function(_dereq_,module,exports){
'use strict';

var LabelUtil = _dereq_(18);

var getDefinition = _dereq_(76).getDefinition;

/**
 * A handler that updates the text of a CMMN element.
 */
function UpdateLabelHandler(itemRegistry) {

  /**
   * Set the label and return the changed elements.
   *
   * Element parameter can be label itself or connection (i.e. sequence flow).
   *
   * @param {djs.model.Base} element
   * @param {String} text
   */
  function setText(element, text) {

    // external label if present
    var label = element.label || element;

    var labelTarget = element.labelTarget || element;

    LabelUtil.setLabel(label, text, labelTarget !== label, isExclusiveRef(element));

    return [label, labelTarget];
  }

  /**
   * Return a function which checks if the element is the only reference to a definition
   *
   * @param  {djs.model.Base} element
   *
   * @return {Function}
   */
  function isExclusiveRef(element) {
    var definition = getDefinition(element);
    return definition ? itemRegistry.getReferences(definition).length === 1 : true;
  }

  function execute(ctx) {
    ctx.oldLabel = LabelUtil.getLabel(ctx.element);
    return setText(ctx.element, ctx.newLabel);
  }

  function revert(ctx) {
    return setText(ctx.element, ctx.oldLabel);
  }

  // API

  this.execute = execute;
  this.revert = revert;
}

UpdateLabelHandler.$inject = ['itemRegistry'];

module.exports = UpdateLabelHandler;

},{"18":18,"76":76}],20:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [_dereq_(93).default, _dereq_(119).default, _dereq_(86).default],
  __init__: ['labelEditingProvider'],
  labelEditingProvider: ['type', _dereq_(17)]
};

},{"119":119,"17":17,"86":86,"93":93}],21:[function(_dereq_,module,exports){
'use strict';

var map = _dereq_(254).map,
    assign = _dereq_(254).assign,
    pick = _dereq_(254).pick;

var isAny = _dereq_(45).isAny;

function CmmnFactory(moddle) {
  this._model = moddle;
}

CmmnFactory.$inject = ['moddle'];

CmmnFactory.prototype._needsId = function (element) {
  return isAny(element, ['cmmn:CMMNElement', 'cmmndi:CMMNShape', 'cmmndi:CMMNEdge', 'cmmndi:CMMNStyle', 'cmmndi:CMMNDiagram']);
};

CmmnFactory.prototype._ensureId = function (element) {
  // generate semantic ids for elements
  var prefix = (element.$type || '').replace(/^[^:]*:/g, '') + '_';

  if (!element.id && this._needsId(element)) {
    element.id = this._model.ids.nextPrefixed(prefix, element);
  }
};

CmmnFactory.prototype.create = function (type, attrs) {
  var element = this._model.create(type, attrs || {});

  this._ensureId(element);

  return element;
};

CmmnFactory.prototype.createDiLabel = function () {
  return this.create('cmmndi:CMMNLabel');
};

CmmnFactory.prototype.createDiShape = function (semantic, bounds, attrs) {
  return this.create('cmmndi:CMMNShape', assign({
    cmmnElementRef: semantic,
    bounds: this.createDiBounds(bounds),
    label: this.createDiLabel()
  }, attrs));
};

CmmnFactory.prototype.createDiEdge = function (semantic, waypoints, attrs) {
  return this.create('cmmndi:CMMNEdge', assign({
    cmmnElementRef: semantic,
    label: this.createDiLabel()
  }, attrs));
};

CmmnFactory.prototype.createDiBounds = function (bounds) {
  return this.create('dc:Bounds', bounds);
};

CmmnFactory.prototype.createDiWaypoints = function (waypoints) {

  var self = this;

  return map(waypoints, function (pos) {
    return self.createDiWaypoint(pos);
  });
};

CmmnFactory.prototype.createDiWaypoint = function (point) {
  return this.create('dc:Point', pick(point, ['x', 'y']));
};

CmmnFactory.prototype.createItem = function (itemType, definitionType) {

  var definition = this.create(definitionType);

  return this.create(itemType, {
    definitionRef: definition
  });
};

CmmnFactory.prototype.createCriterion = function (criterionType, attrs) {

  attrs = attrs || {};

  if (!attrs.sentryRef) {
    attrs = assign({
      sentryRef: this.createSentry()
    }, attrs);
  }

  return this.create(criterionType, attrs);
};

CmmnFactory.prototype.createSentry = function (attrs) {
  return this.create('cmmn:Sentry', attrs);
};

CmmnFactory.prototype.createCasePlanModel = function () {

  var casePlanModel = this.create('cmmn:Stage');

  // overwrite generated id to 'CasePlanModel_...'
  this._model.ids.unclaim(casePlanModel.id);
  casePlanModel.id = this._model.ids.nextPrefixed('CasePlanModel_', casePlanModel);

  var _case = this.create('cmmn:Case', {
    casePlanModel: casePlanModel
  });

  casePlanModel.$parent = _case;

  return casePlanModel;
};

CmmnFactory.prototype.createCaseFileModel = function (_case) {

  var caseFileModel = this.create('cmmn:CaseFile');

  // overwrite generated id to 'CaseFileModel_...'
  this._model.ids.unclaim(caseFileModel.id);
  caseFileModel.id = this._model.ids.nextPrefixed('CaseFileModel_', caseFileModel);

  caseFileModel.$parent = _case;

  return caseFileModel;
};

CmmnFactory.prototype.createCaseFileItem = function (attrs) {

  attrs = attrs || {};

  if (!attrs.definitionRef) {

    attrs = assign({
      definitionRef: this.create('cmmn:CaseFileItemDefinition')
    }, attrs);
  }

  return this.create('cmmn:CaseFileItem', attrs);
};

module.exports = CmmnFactory;

},{"254":254,"45":45}],22:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var BaseLayouter = _dereq_(219).default,
    ManhattanLayout = _dereq_(222);

var getMid = _dereq_(221).getMid;

function CmmnLayouter() {}

inherits(CmmnLayouter, BaseLayouter);

module.exports = CmmnLayouter;

CmmnLayouter.prototype.layoutConnection = function (connection, hints) {

  hints = hints || {};

  var source = hints.source || connection.source,
      target = hints.target || connection.target,
      waypoints = connection.waypoints,
      start = hints.connectionStart,
      end = hints.connectionEnd;

  if (!start) {
    start = getConnectionDocking(waypoints && waypoints[0], source);
  }

  if (!end) {
    end = getConnectionDocking(waypoints && waypoints[waypoints.length - 1], target);
  }

  var updatedWaypoints = ManhattanLayout.repairConnection(source, target, start, end, waypoints, hints);

  return updatedWaypoints || [start, end];
};

function getConnectionDocking(point, shape) {
  return point ? point.original || point : getMid(shape);
}

},{"219":219,"221":221,"222":222,"253":253}],23:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(254).assign,
    inherits = _dereq_(253);

var CommandInterceptor = _dereq_(91).default;

var Collections = _dereq_(233);

var getBusinessObject = _dereq_(76).getBusinessObject,
    is = _dereq_(76).is,
    isCasePlanModel = _dereq_(76).isCasePlanModel;

var getParent = _dereq_(45).getParent,
    isLabel = _dereq_(45).isLabel;

var isAny = _dereq_(45).isAny;

/**
 * A handler responsible for updating the underlying CMMN 1.1 XML + DI
 * once changes on the diagram happen
 */
function CmmnUpdater(eventBus, cmmnFactory, itemRegistry, connectionDocking) {

  CommandInterceptor.call(this, eventBus);

  this._cmmnFactory = cmmnFactory;
  this._itemRegistry = itemRegistry;

  var self = this;

  // connection cropping /////////////////

  // crop connection ends during create/update
  function cropConnection(e) {
    var context = e.context,
        connection;

    if (!context.cropped) {
      connection = context.connection;
      connection.waypoints = connectionDocking.getCroppedWaypoints(connection);
      context.cropped = true;
    }
  }

  this.executed(['connection.layout', 'connection.create', 'connection.reconnectEnd', 'connection.reconnectStart'], cropConnection);

  this.reverted(['connection.layout', 'connection.create', 'connection.reconnectEnd', 'connection.reconnectStart'], function (e) {
    delete e.context.cropped;
  });

  // CMMN + DI update /////////////////

  function updateParent(e) {
    var context = e.context;

    self.updateParent(context.shape || context.connection, context.oldParent);
  }

  function reverseUpdateParent(e) {

    var context = e.context;

    var element = context.shape || context.connection,

    // oldParent is the (old) new parent, because we are undoing
    oldParent = context.parent || context.newParent;

    self.updateParent(element, oldParent);
  }

  this.executed(['shape.create', 'shape.move', 'shape.delete', 'connection.delete', 'connection.create'], ifCmmn(updateParent));
  this.reverted(['shape.create', 'shape.move', 'shape.delete', 'connection.delete', 'connection.create'], ifCmmn(reverseUpdateParent));

  // update bounds
  function updateBounds(e) {
    var shape = e.context.shape;
    self.updateBounds(shape);
  }

  this.executed(['shape.create', 'shape.move', 'shape.resize'], ifCmmn(function (event) {

    // exclude labels because they're handled separately during shape.changed
    if (event.context.shape.type === 'label') {
      return;
    }

    updateBounds(event);
  }));

  this.reverted(['shape.create', 'shape.move', 'shape.resize'], ifCmmn(function (event) {

    // exclude labels because they're handled separately during shape.changed
    if (event.context.shape.type === 'label') {
      return;
    }

    updateBounds(event);
  }));

  // Handle labels separately. This is necessary, because the label bounds have to be updated
  // every time its shape changes, not only on move, create and resize.
  eventBus.on('shape.changed', function (event) {
    if (event.element.type === 'label') {
      updateBounds({ context: { shape: event.element } });
    }
  });

  // attach / detach connection
  function updateConnection(e) {
    self.updateConnection(e.context);
  }

  this.executed(['connection.create', 'connection.move', 'connection.delete', 'connection.reconnectEnd', 'connection.reconnectStart'], ifCmmn(updateConnection));

  this.reverted(['connection.create', 'connection.move', 'connection.delete', 'connection.reconnectEnd', 'connection.reconnectStart'], ifCmmn(updateConnection));

  // update waypoints
  function updateConnectionWaypoints(e) {
    self.updateConnectionWaypoints(e.context.connection);
  }

  this.executed(['connection.create', 'connection.layout', 'connection.move', 'connection.reconnectStart', 'connection.reconnectEnd', 'connection.updateWaypoints'], ifCmmn(updateConnectionWaypoints));

  this.reverted(['connection.create', 'connection.layout', 'connection.move', 'connection.reconnectStart', 'connection.reconnectEnd', 'connection.updateWaypoints'], ifCmmn(updateConnectionWaypoints));

  // update attachments
  function updateAttachment(e) {
    self.updateAttachment(e.context);
  }

  this.executed(['element.updateAttachment'], ifCmmn(updateAttachment));
  this.reverted(['element.updateAttachment'], ifCmmn(updateAttachment));

  // update item registry

  function addItem(e) {
    var context = e.context,
        shape = context.shape,
        bo = getBusinessObject(shape);

    itemRegistry.add(bo);
  }

  function removeItem(e) {

    var context = e.context,
        shape = context.shape;

    if (isLabel(shape)) {
      return;
    }

    var bo = getBusinessObject(shape);
    itemRegistry.remove(bo);
  }

  this.executed('shape.create', ifCmmn(addItem));
  this.reverted('shape.create', ifCmmn(removeItem));

  this.executed('shape.delete', ifCmmn(removeItem));
  this.reverted('shape.delete', ifCmmn(addItem));
}

inherits(CmmnUpdater, CommandInterceptor);

module.exports = CmmnUpdater;

CmmnUpdater.$inject = ['eventBus', 'cmmnFactory', 'itemRegistry', 'connectionDocking'];

// implementation /////////////////


CmmnUpdater.prototype.updateAttachment = function (context) {
  var shape = context.shape,
      businessObject = getBusinessObject(shape),
      host = shape.host,
      businessObjectHost = host && getBusinessObject(host);

  this.updateSemanticParent(businessObject, businessObjectHost);
};

CmmnUpdater.prototype.updateParent = function (element, oldParent) {
  // do not update CMMN 1.1 label parent
  if (isLabel(element)) {
    return;
  }

  var businessObject = getBusinessObject(element),
      parentBusinessObject = getBusinessObject(element.parent),
      businessObjectDi = businessObject.di || businessObject,
      parentDi = parentBusinessObject && parentBusinessObject.di;

  if (isAssociation(businessObject)) {
    businessObject = businessObject.cmmnElementRef;
  }

  if (shouldUpdateSemanticParent(businessObject)) {
    this.updateSemanticParent(businessObject, parentBusinessObject);
  }

  if (is(parentBusinessObject, 'cmmndi:CMMNDiagram')) {
    parentDi = parentBusinessObject;
  }

  this.updateDiParent(businessObjectDi, parentDi);
};

/**
 * Update the semantic parent
 *
 * - add/remove the business object to/from the parent's containment(s)
 * - set/unset the $parent property of the business object
 *
 * @param  {ModdleElement} businessObject
 * @param  {ModdleElement} newParent
 */
CmmnUpdater.prototype.updateSemanticParent = function (businessObject, newParent) {

  var containment;

  if (businessObject.$parent === newParent) {
    return;
  }

  if (is(businessObject, 'cmmn:PlanItem')) {
    containment = 'planItems';

    if (newParent && !isCasePlanModel(newParent)) {
      newParent = newParent.definitionRef;
    }
  } else if (isCasePlanModel(businessObject)) {
    containment = 'cases';
    businessObject = businessObject.$parent;
    newParent = newParent && getDefinitions(newParent);
  } else if (is(businessObject, 'cmmn:EntryCriterion')) {

    if (isCasePlanModel(newParent)) {
      newParent = null;
    }

    containment = 'entryCriteria';
  } else if (is(businessObject, 'cmmn:ExitCriterion')) {
    containment = 'exitCriteria';
  } else if (is(businessObject, 'cmmn:Artifact')) {
    newParent = newParent && getDefinitions(newParent);
    containment = 'artifacts';
  }

  if (!containment) {
    throw new Error('no parent for ', businessObject, newParent);
  }

  var children;

  if (businessObject.$parent) {
    // remove from old parent
    children = businessObject.$parent.get(containment);
    Collections.remove(children, businessObject);
  }

  if (newParent) {
    // add to new parent
    children = newParent.get(containment);
    children.push(businessObject);
    businessObject.$parent = newParent;
  } else {
    businessObject.$parent = null;
  }
};

/**
 * Upate the parent of an DI element
 *
 * - Add/remove DI element to the root element's diagramElements conainment
 * - Set/unset the $parent property of the DI element
 *
 * @param  {ModdleElement} di
 * @param  {ModdleElement} parentDi
 */
CmmnUpdater.prototype.updateDiParent = function (di, parentDi) {
  if (parentDi && !is(parentDi, 'cmmndi:CMMNDiagram')) {
    parentDi = parentDi.$parent;
  }

  if (di.$parent === parentDi) {
    return;
  }

  var diagramElements = (parentDi || di.$parent).get('diagramElements');

  if (parentDi) {
    diagramElements.push(di);
    di.$parent = parentDi;
  } else {
    Collections.remove(diagramElements, di);
    di.$parent = null;
  }
};

CmmnUpdater.prototype.updateBounds = function (shape) {
  var di = shape.businessObject.di || shape.businessObject;

  var bounds = isLabel(shape) ? this._getLabel(di).bounds : di.bounds;

  assign(bounds, {
    x: shape.x,
    y: shape.y,
    width: shape.width,
    height: shape.height
  });
};

CmmnUpdater.prototype.updateConnectionWaypoints = function (connection) {
  var di = connection.businessObject;
  di.set('waypoint', this._cmmnFactory.createDiWaypoints(connection.waypoints));
};

CmmnUpdater.prototype.updateConnection = function (context) {

  var connection = context.connection,
      businessObject = getBusinessObject(connection),
      newSource = getBusinessObject(connection.source),
      newTarget = getBusinessObject(connection.target),
      cmmnElement = businessObject.cmmnElementRef,
      sourceElem,
      targetElem,
      sourceAttr,
      targetAttr;

  if (is(cmmnElement, 'cmmn:Association')) {
    sourceElem = cmmnElement;
    targetElem = cmmnElement;

    sourceAttr = 'sourceRef';
    targetAttr = 'targetRef';
  } else {
    targetElem = businessObject;
    targetAttr = 'targetCMMNElementRef';

    if (is(cmmnElement, 'cmmn:OnPart')) {

      sourceElem = cmmnElement;
      sourceAttr = 'sourceRef';

      var newExitCriterionRef;
      if (is(newSource, 'cmmn:ExitCriterion')) {
        newExitCriterionRef = newSource;
        newSource = getParent(newExitCriterionRef);
      }

      if (cmmnElement.exitCriterionRef !== newExitCriterionRef) {
        cmmnElement.exitCriterionRef = newExitCriterionRef;
      }
    } else {
      sourceElem = businessObject;
      sourceAttr = 'sourceCMMNElementRef';
    }
  }

  if (sourceAttr && sourceElem[sourceAttr] !== newSource) {
    sourceElem[sourceAttr] = newSource;
  }

  if (targetAttr && targetElem[targetAttr] !== newTarget) {
    targetElem[targetAttr] = newTarget;
  }

  this.updateConnectionWaypoints(connection);
};

// helpers /////////////////

CmmnUpdater.prototype._getLabel = function (di) {

  if (!di.label) {
    di.label = this._cmmnFactory.createDiLabel();
  }

  if (!di.label.bounds) {
    di.label.bounds = this._cmmnFactory.createDiBounds();
  }

  return di.label;
};

/**
 * Make sure the event listener is only called
 * if the touched element is a CMMN element.
 *
 * @param  {Function} fn
 * @return {Function} guarded function
 */
function ifCmmn(fn) {

  return function (event) {

    var context = event.context,
        element = context.shape || context.connection;

    if (is(element, 'cmmn:CMMNElement') || is(element, 'cmmndi:CMMNDiagramElement')) {
      fn(event);
    }
  };
}

/**
 * Returns the cmmn:Definitions element for a given element.
 */
function getDefinitions(element) {
  return getParent(element, 'cmmn:Definitions');
}

function shouldUpdateSemanticParent(element) {
  return !isAny(element, ['cmmn:CaseFileItem', 'cmmn:Criterion', 'cmmn:DiscretionaryItem', 'cmmn:OnPart', 'cmmndi:CMMNEdge']);
}

function isAssociation(connection) {
  connection = connection.businessObject || connection;
  return !!(connection.cmmnElementRef && is(connection.cmmnElementRef, 'cmmn:Association'));
}

},{"233":233,"253":253,"254":254,"45":45,"76":76,"91":91}],24:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(254).assign,
    inherits = _dereq_(253);

var BaseElementFactory = _dereq_(95).default,
    LabelUtil = _dereq_(75);

var is = _dereq_(76).is,
    getDefinition = _dereq_(76).getDefinition,
    isCasePlanModel = _dereq_(76).isCasePlanModel;

var isCollapsed = _dereq_(74).isCollapsed;

/**
 * A cmmn-aware factory for diagram-js shapes
 */
function ElementFactory(cmmnFactory, moddle) {
  BaseElementFactory.call(this);

  this._cmmnFactory = cmmnFactory;
  this._moddle = moddle;
}

inherits(ElementFactory, BaseElementFactory);

ElementFactory.$inject = ['cmmnFactory', 'moddle'];

module.exports = ElementFactory;

ElementFactory.prototype.baseCreate = BaseElementFactory.prototype.create;

ElementFactory.prototype.create = function (elementType, attrs) {
  // no special magic for labels,
  // we assume their businessObjects have already been created
  // and wired via attrs
  if (elementType === 'label') {
    return this.baseCreate(elementType, assign({ type: 'label' }, LabelUtil.DEFAULT_LABEL_SIZE, attrs));
  }

  if (elementType === 'root') {
    return this.baseCreate(elementType, attrs);
  }

  return this.createCmmnElement(elementType, attrs);
};

ElementFactory.prototype.createCmmnElement = function (elementType, attrs) {

  attrs = assign({}, attrs || {});

  var size;

  var businessObject = attrs.businessObject;

  if (!businessObject) {
    if (!attrs.type) {
      throw new Error('no shape type specified');
    }

    var props = {};

    if (attrs.name) {
      assign(props, {
        name: attrs.name
      });
    }

    businessObject = this._cmmnFactory.create(attrs.type, props);
  }

  if (elementType === 'connection') {

    if (!is(businessObject, 'cmmndi:CMMNEdge')) {
      businessObject = this._cmmnFactory.createDiEdge(businessObject, [], {
        id: businessObject.id + '_di'
      });
    }

    if (!businessObject.label) {
      businessObject.label = this._cmmnFactory.createDiLabel();
    }

    attrs.type = 'cmmndi:CMMNEdge';
  }

  if (attrs.definitionType) {
    var definition = this._cmmnFactory.create(attrs.definitionType);
    businessObject.definitionRef = definition;
  }

  if (attrs.sentryRef) {
    businessObject.sentryRef = attrs.sentryRef;
  }

  if (elementType === 'shape' && !businessObject.di) {
    businessObject.di = this._cmmnFactory.createDiShape(businessObject, {}, {
      id: businessObject.id + '_di'
    });
  }

  if (attrs.isCollapsed) {
    businessObject.di.isCollapsed = attrs.isCollapsed;
  }

  if (attrs.isPlanningTableCollapsed) {
    businessObject.di.isPlanningTableCollapsed = attrs.isPlanningTableCollapsed;
  }

  if (attrs.isStandardEventVisible) {
    businessObject.isStandardEventVisible = attrs.isStandardEventVisible;
  }

  if (attrs.isBlocking !== undefined) {
    businessObject.definitionRef.isBlocking = attrs.isBlocking;
  }

  if (attrs.autoComplete) {
    businessObject.definitionRef.autoComplete = true;
  }

  size = this._getDefaultSize(businessObject);

  attrs = assign({
    businessObject: businessObject,
    id: businessObject.id
  }, size, attrs);

  return this.baseCreate(elementType, attrs);
};

ElementFactory.prototype._getDefaultSize = function (semantic) {

  var definition = getDefinition(semantic);

  // CasePlanModel (type of semantic is 'cmmn:Stage')
  if (isCasePlanModel(semantic)) {
    return { width: 400, height: 250 };
  }

  if (is(definition, 'cmmn:PlanFragment')) {
    if (isCollapsed(semantic)) {
      return { width: 100, height: 80 };
    } else {
      return { width: 350, height: 200 };
    }
  }

  if (is(definition, 'cmmn:Milestone')) {
    return { width: 100, height: 40 };
  }

  if (is(definition, 'cmmn:EventListener')) {
    return { width: 36, height: 36 };
  }

  if (is(semantic, 'cmmn:Criterion')) {
    return { width: 20, height: 28 };
  }

  if (is(semantic, 'cmmn:TextAnnotation')) {
    return { width: 100, height: 30 };
  }

  if (is(semantic, 'cmmn:CaseFileItem')) {
    return { width: 36, height: 50 };
  }

  return { width: 100, height: 80 };
};

ElementFactory.prototype.createPlanItemShape = function (type) {
  return this.createShape({
    type: 'cmmn:PlanItem',
    businessObject: this._cmmnFactory.createItem('cmmn:PlanItem', type)
  });
};

ElementFactory.prototype.createDiscretionaryItemShape = function (type) {
  return this.createShape({
    type: 'cmmn:DiscretionaryItem',
    businessObject: this._cmmnFactory.createItem('cmmn:DiscretionaryItem', type)
  });
};

ElementFactory.prototype.createCasePlanModelShape = function () {
  return this.createShape({
    type: 'cmmn:Stage',
    businessObject: this._cmmnFactory.createCasePlanModel()
  });
};

ElementFactory.prototype.createCriterionShape = function (type) {
  return this.createShape({
    type: type,
    businessObject: this._cmmnFactory.createCriterion(type)
  });
};

ElementFactory.prototype.createCaseFileItemShape = function () {
  return this.createShape({
    type: 'cmmn:CaseFileItem',
    businessObject: this._cmmnFactory.createCaseFileItem()
  });
};

},{"253":253,"254":254,"74":74,"75":75,"76":76,"95":95}],25:[function(_dereq_,module,exports){
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var inherits = _dereq_(253);

var assign = _dereq_(254).assign;

var BaseModeling = _dereq_(150).default;

var AppendShapeHandler = _dereq_(37);
var ReconnectConnectionHandler = _dereq_(39);
var ReplaceShapeHandler = _dereq_(40);

var UpdatePropertiesHandler = _dereq_(42);
var UpdateSemanticParentHandler = _dereq_(43);
var UpdateControlsHandler = _dereq_(41);

var IdClaimHandler = _dereq_(38);

/**
 * CMMN 1.1 modeling features activator
 *
 * @param {EventBus} eventBus
 * @param {ElementFactory} elementFactory
 * @param {CommandStack} commandStack
 */
function Modeling(eventBus, elementFactory, commandStack, cmmnRules, rules) {
  BaseModeling.call(this, eventBus, elementFactory, commandStack);

  this._cmmnRules = cmmnRules;
  this._rules = rules;
}

inherits(Modeling, BaseModeling);

Modeling.$inject = ['eventBus', 'elementFactory', 'commandStack', 'cmmnRules', 'rules'];

module.exports = Modeling;

Modeling.prototype.getHandlers = function () {
  var handlers = BaseModeling.prototype.getHandlers.call(this);

  handlers['shape.append'] = AppendShapeHandler;
  handlers['shape.replace'] = ReplaceShapeHandler;
  handlers['connection.reconnectStart'] = ReconnectConnectionHandler;
  handlers['connection.reconnectEnd'] = ReconnectConnectionHandler;

  handlers['element.updateProperties'] = UpdatePropertiesHandler;
  handlers['element.updateSemanticParent'] = UpdateSemanticParentHandler;

  handlers['element.updateControls'] = UpdateControlsHandler;

  handlers['id.updateClaim'] = IdClaimHandler;

  return handlers;
};

Modeling.prototype.connect = function (source, target, attrs, hints) {

  var rules = this._rules;

  if (!attrs) {
    attrs = rules.allowed('connection.create', {
      source: source,
      target: target
    }) || { type: 'cmmn:Association' };
  }

  if (attrs.reverse) {

    if (hints) {
      hints = {
        connectionStart: hints.connectionEnd,
        connectionEnd: hints.connectionStart
      };
    }

    return this.createConnection(target, source, attrs, target.parent, hints);
  }

  return this.createConnection(source, target, attrs, source.parent, hints);
};

Modeling.prototype.createConnection = function (source, target, targetIndex, connection, parent, hints) {

  // Overwrite existing createConnection() method to provide additional
  // information in the context. This must be done to enable the replacement
  // of the target element, if necessary.

  if ((typeof targetIndex === 'undefined' ? 'undefined' : _typeof(targetIndex)) === 'object') {
    hints = parent;
    parent = connection;
    connection = targetIndex;
    targetIndex = undefined;
  }

  var context = {
    source: source,
    target: target,
    parent: parent,
    parentIndex: targetIndex,
    canExecute: connection,
    hints: hints
  };

  connection = this._create('connection', connection);

  assign(context, {
    connection: connection
  });

  this._commandStack.execute('connection.create', context);

  return context.connection;
};

Modeling.prototype.reconnectStart = function (connection, newSource, dockingOrPoints, hints) {
  var context = {
    connection: connection,
    newSource: newSource,
    dockingOrPoints: dockingOrPoints,
    hints: hints || {}
  };

  this._commandStack.execute('connection.reconnectStart', context);
};

Modeling.prototype.reconnectEnd = function (connection, newTarget, dockingOrPoints, hints) {
  var context = {
    connection: connection,
    newTarget: newTarget,
    dockingOrPoints: dockingOrPoints,
    hints: hints || {}
  };

  this._commandStack.execute('connection.reconnectEnd', context);
};

Modeling.prototype.updateProperties = function (element, properties, shape) {
  this._commandStack.execute('element.updateProperties', {
    element: element,
    properties: properties,
    shape: shape
  });
};

Modeling.prototype.updateSemanticParent = function (element, newParent, containment, shape) {
  this._commandStack.execute('element.updateSemanticParent', {
    element: element,
    newParent: newParent,
    containment: containment,
    shape: shape
  });
};

Modeling.prototype.updateControls = function (element, values) {
  this._commandStack.execute('element.updateControls', {
    element: element,
    values: values
  });
};

Modeling.prototype.claimId = function (id, moddleElement) {
  this._commandStack.execute('id.updateClaim', {
    id: id,
    element: moddleElement,
    claiming: true
  });
};

Modeling.prototype.unclaimId = function (id, moddleElement) {
  this._commandStack.execute('id.updateClaim', {
    id: id,
    element: moddleElement
  });
};

},{"150":150,"253":253,"254":254,"37":37,"38":38,"39":39,"40":40,"41":41,"42":42,"43":43}],26:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var CommandInterceptor = _dereq_(91).default;

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    isCasePlanModel = ModelUtil.isCasePlanModel;

/*
 * If a criterion is (re-)attached to a case plan model,
 * then the (visual) parent must be the case plan model itself,
 * and not the root element.
 */
function AttachCriterionBehavior(eventBus) {

  CommandInterceptor.call(this, eventBus);

  this.preExecute(['shape.create', 'elements.move'], function (context) {

    var shape = context.shape,
        shapes = context.shapes,
        parent = context.parent || context.newParent,
        host = context.host || context.newHost;

    if (!parent) {
      return;
    }

    if (!host || !isCasePlanModel(host)) {
      return;
    }

    if (shapes && shapes.length > 1) {
      return;
    }

    shape = shape || shapes[0];

    if (!is(shape, 'cmmn:Criterion')) {
      return;
    }

    context.parent = context.parent && host;
    context.newParent = context.newParent && host;
  }, true);
}

AttachCriterionBehavior.$inject = ['eventBus'];

inherits(AttachCriterionBehavior, CommandInterceptor);

module.exports = AttachCriterionBehavior;

},{"253":253,"76":76,"91":91}],27:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var CommandInterceptor = _dereq_(91).default;

var forEach = _dereq_(254).forEach;
var filter = _dereq_(254).filter;
var reduce = _dereq_(254).reduce;

var ModelUtil = _dereq_(76),
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject,
    is = ModelUtil.is;

var ModelingUtil = _dereq_(45),
    getCase = ModelingUtil.getCase,
    getParent = ModelingUtil.getParent,
    isSameCase = ModelingUtil.isSameCase,
    isLabel = ModelingUtil.isLabel;

function CaseFileItemUpdater(eventBus, itemRegistry, cmmnFactory, modeling) {

  this._cmmnFactory = cmmnFactory;
  this._modeling = modeling;

  CommandInterceptor.call(this, eventBus);

  var containment = 'caseFileItems';

  this.preExecuted('shape.create', function (context) {

    var shape = context.shape,
        parent = context.parent,
        parentBusinessObject = getBusinessObject(parent),
        definitions,
        caseFileItemDefinition,
        caseFileModel;

    if (!isCaseFileItem(shape)) {
      return;
    }

    caseFileItemDefinition = getDefinition(shape);

    if (caseFileItemDefinition) {
      definitions = getDefinitions(parentBusinessObject);
      modeling.updateSemanticParent(caseFileItemDefinition, definitions, 'caseFileItemDefinitions');
    }

    caseFileModel = createCaseFileModel(parent);

    modeling.updateSemanticParent(shape, caseFileModel, containment);
  }, true);

  this.preExecuted('elements.move', function (context) {

    var newParent = context.newParent,
        hints = context.hints,
        oldParent = hints && hints.primaryShape && hints.primaryShape.parent,
        closure = context.closure || {},
        shapes = closure.allShapes,
        caseFileModel;

    if (!newParent || oldParent === newParent) {
      return;
    }

    shapes = filter(shapes, function (shape) {
      return isCaseFileItem(shape) && !isLabel(shape) && !isSameCase(shape.parent, newParent);
    });

    if (shapes && shapes.length) {

      caseFileModel = createCaseFileModel(newParent);

      shapes = toMap(shapes);

      forEach(shapes, function (shape) {

        var caseFileItem = getBusinessObject(shape),
            oldCaseFileModel = getParentCaseFile(caseFileItem),
            oldSemanticParent = getParent(caseFileItem);

        if (isCaseFileModel(oldSemanticParent)) {

          modeling.updateSemanticParent(shape, caseFileModel, containment);
        } else {

          var parentCaseFileItem = getParent(caseFileItem, 'cmmn:CaseFileItem');
          if (!shapes[parentCaseFileItem.id]) {
            modeling.updateSemanticParent(shape, caseFileModel, containment);
          }
        }

        var source = caseFileItem.sourceRef;
        if (source && !shapes[source.id]) {
          clearSourceRef(caseFileItem);
        }

        clearTargetRefs(caseFileItem, function (target) {
          return !shapes[target.id];
        });

        moveChildren(caseFileItem, oldCaseFileModel, function (child) {
          return !shapes[child.id];
        });

        clearCaseFileItemContainer(oldSemanticParent);
      });
    }
  }, true);

  this.postExecuted('shape.delete', function (context) {

    var shape = context.shape,
        bo = getBusinessObject(shape),
        caseFileItemDefinition;

    if (!isCaseFileItem(shape) || isLabel(shape)) {
      return;
    }

    var oldSemanticParent = getParent(bo),
        caseFileModel = getParentCaseFile(bo);

    modeling.updateSemanticParent(shape, null, containment);

    clearSourceRef(shape);
    clearTargetRefs(shape);
    moveChildren(bo, caseFileModel);

    clearCaseFileItemContainer(oldSemanticParent);

    if (isExlusiveRef(shape)) {
      caseFileItemDefinition = getDefinition(shape);
      modeling.updateSemanticParent(caseFileItemDefinition, null, 'caseFileItemDefinitions');
    }
  }, true);

  function createCaseFileModel(element) {
    var _case = getCase(element),
        caseFileModel = _case.caseFileModel;

    if (!caseFileModel) {
      caseFileModel = cmmnFactory.createCaseFileModel(_case);
      modeling.updateProperties(_case, { caseFileModel: caseFileModel });
    }

    return caseFileModel;
  }

  function clearCaseFileItemContainer(container) {
    var items = container && container.get(containment);

    if (items && !items.length) {

      var prop = 'caseFileModel',
          parent = container.$parent;

      if (!isCaseFileModel(container)) {
        prop = 'children';
      }

      var update = {};
      update[prop] = undefined;

      modeling.updateProperties(parent, update);
      modeling.updateSemanticParent(container);
    }
  }

  function clearSourceRef(target) {
    target = getBusinessObject(target);

    var source = target.sourceRef;

    if (source) {
      clearTargetRefs(source, function (elem) {
        return target === elem;
      });

      modeling.updateProperties(target, { sourceRef: undefined });
    }
  }

  function clearTargetRefs(source, canRemoveFilter) {
    source = getBusinessObject(source);

    var targets = source && source.get('targetRefs'),
        copy;

    if (targets && targets.length) {

      copy = targets.slice();

      forEach(targets, function (target) {

        var canRemove = !canRemoveFilter || canRemoveFilter(target);

        if (canRemove) {

          if (target.sourceRef === source) {
            modeling.updateProperties(target, { sourceRef: undefined });
          }

          var idx = copy.indexOf(target);
          if (idx !== -1) {
            copy.splice(idx, 1);
          }
        }
      });

      if (targets.length !== copy.length) {
        modeling.updateProperties(source, { targetRefs: copy });
      }
    }
  }

  function moveChildren(caseFileItem, newParent, canMoveFilter) {
    caseFileItem = getBusinessObject(caseFileItem);

    var childrenElement = caseFileItem.children,
        children = childrenElement && childrenElement.get(containment);

    if (children && children.length) {

      forEach(children, function (child) {

        var canMove = !canMoveFilter || canMoveFilter(child);

        if (canMove) {
          modeling.updateSemanticParent(child, newParent, containment);
        }
      });

      clearCaseFileItemContainer(childrenElement);
    }
  }

  function isExlusiveRef(element) {
    var definition = getDefinition(element);
    return definition && itemRegistry.getReferences(definition).length === 1;
  }
}

CaseFileItemUpdater.$inject = ['eventBus', 'itemRegistry', 'cmmnFactory', 'modeling'];

inherits(CaseFileItemUpdater, CommandInterceptor);

module.exports = CaseFileItemUpdater;

function getDefinitions(element) {
  return getParent(element, 'cmmn:Definitions');
}

function isCaseFileItem(element) {
  return is(element, 'cmmn:CaseFileItem');
}

function isCaseFileModel(element) {
  return is(element, 'cmmn:CaseFile');
}

function toMap(elements) {
  return reduce(elements, function (result, value) {
    result[value.id] = value;
    return result;
  }, {});
}

function getParentCaseFile(element) {
  return getParent(getBusinessObject(element), 'cmmn:CaseFile');
}

},{"253":253,"254":254,"45":45,"76":76,"91":91}],28:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(254).assign,
    inherits = _dereq_(253);

var LabelUtil = _dereq_(75),
    ModelUtil = _dereq_(76),
    DiUtil = _dereq_(74),
    ModelingUtil = _dereq_(45);

var getBusinessObject = ModelUtil.getBusinessObject,
    getName = ModelUtil.getName;

var hasExternalLabel = LabelUtil.hasExternalLabel,
    getExternalLabelMid = LabelUtil.getExternalLabelMid;

var isStandardEventVisible = DiUtil.isStandardEventVisible;

var isAny = ModelingUtil.isAny;

var CommandInterceptor = _dereq_(91).default;

/**
 * A component that makes sure that external labels are added
 * together with respective elements and properly updated (DI wise)
 * during move.
 *
 * @param {EventBus} eventBus
 * @param {Modeling} modeling
 * @param {cmmnFactory} cmmnFactory
 */
function LabelBehavior(eventBus, modeling, cmmnFactory) {

  CommandInterceptor.call(this, eventBus);

  // create external labels on shape creation

  this.postExecuted(['shape.create', 'connection.create'], 200, function (e) {
    var context = e.context;

    var element = context.shape || context.connection,
        businessObject = element.businessObject;

    var position;

    if (hasExternalLabel(businessObject)) {
      position = getExternalLabelMid(element);

      modeling.createLabel(element, position, {
        id: businessObject.id + '_label',
        hidden: !getName(element) && !isStandardEventVisible(businessObject),
        businessObject: businessObject
      });
    }
  });

  // update label position on waypoints change if still hidden
  this.postExecute(['connection.updateWaypoints'], function (e) {
    var context = e.context,
        connection = context.connection,
        label = connection.label;

    if (!label) {
      return;
    }

    if (label.hidden) {
      var position = getExternalLabelMid(connection);

      var delta = {
        x: position.x - label.x - label.width / 2,
        y: position.y - label.y - label.height / 2
      };

      modeling.moveShape(label, delta);
    }
  });

  this.postExecute(['shape.replace'], function (e) {
    var context = e.context,
        newShape = context.newShape,
        oldShape = context.oldShape;

    var businessObject = getBusinessObject(newShape);

    if (businessObject && hasExternalLabel(businessObject)) {
      newShape.label.x = oldShape.label.x;
      newShape.label.y = oldShape.label.y;
    }
  });

  // update di information on label creation
  this.executed(['label.create'], function (e) {

    var element = e.context.shape,
        businessObject,
        di;

    // we want to trigger on real labels only
    if (!element.labelTarget) {
      return;
    }

    // we want to trigger on CMMN elements only
    if (!isAny(element.labelTarget || element, ['cmmn:CMMNElement', 'cmmndi:CMMNDiagramElement'])) {
      return;
    }

    businessObject = element.businessObject, di = businessObject.di || businessObject;

    if (!di.label) {
      di.label = cmmnFactory.createDiLabel();
    }

    if (!di.label.bounds) {
      di.label.bounds = cmmnFactory.createDiBounds();
    }

    assign(di.label.bounds, {
      x: element.x,
      y: element.y,
      width: element.width,
      height: element.height
    });
  });
}

inherits(LabelBehavior, CommandInterceptor);

LabelBehavior.$inject = ['eventBus', 'modeling', 'cmmnFactory'];

module.exports = LabelBehavior;

},{"253":253,"254":254,"45":45,"74":74,"75":75,"76":76,"91":91}],29:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var forEach = _dereq_(254).forEach,
    unionBy = _dereq_(254).unionBy,
    filter = _dereq_(254).filter;

var CommandInterceptor = _dereq_(91).default;

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject;

var ModelingUtil = _dereq_(45),
    getParents = ModelingUtil.getParents,
    getParent = ModelingUtil.getParent,
    getCase = ModelingUtil.getCase,
    isLabel = ModelingUtil.isLabel;

var PlanItemDefinitionUtil = _dereq_(46),
    getAllDiscretionaryItems = PlanItemDefinitionUtil.getAllDiscretionaryItems,
    getDirectItemCapables = PlanItemDefinitionUtil.getDirectItemCapables,
    isItemCapable = PlanItemDefinitionUtil.isItemCapable,
    isHumanTask = PlanItemDefinitionUtil.isHumanTask;

var LOW_PRIORITY = 400;

/**
 * A handler responsible for updating the parent relation of a plan item definition
 * to the underlying CMMN 1.1 XML once changes on the diagram happen.
 */
function PlanItemDefinitionUpdater(eventBus, modeling, cmmnReplace, itemRegistry) {

  this._modeling = modeling;
  this._cmmnReplace = cmmnReplace;
  this._itemRegistry = itemRegistry;

  var self = this;

  CommandInterceptor.call(this, eventBus);

  var containment = 'planItemDefinitions';

  // CREATION //////////////////////////////////////////////////////////

  this.postExecuted('shape.create', function (context) {

    var shape = context.shape;

    if (!isItemCapable(shape)) {
      return;
    }

    var item = getBusinessObject(shape),
        definition = getDefinition(item),
        parent = getParentStage(item);

    if (!getParent(definition)) {
      modeling.updateSemanticParent(definition, parent, containment);
    }
  }, true);

  this.postExecuted('shape.replace', function (context) {

    var newShape = context.newShape;

    if (!isItemCapable(newShape)) {
      return;
    }

    self.updatePlanItemDefinitions([newShape]);
  }, true);

  // DELETION //////////////////////////////////////////////////////////

  this.postExecuted('shape.delete', function (context) {

    var shape = context.shape,
        definition,
        update = {};

    if (!isItemCapable(shape) || isLabel(shape)) {
      return;
    }

    definition = getDefinition(shape);
    update[definition.id] = definition;
    self.deletePlanItemDefinitions(update);
  }, true);

  this.preExecuted('shape.delete', function (context) {

    var shape = context.shape,
        definition = getDefinition(shape);

    if (!isHumanTask(definition) || definition.$parent) {
      return;
    }

    // get remaining discretionary items
    context.discretionaryItems = context.discretionaryItems || getAllDiscretionaryItems(definition);
  }, true);

  this.postExecuted('shape.delete', LOW_PRIORITY, function (context) {

    var discretionaryItems = context.discretionaryItems,
        shapes = [];

    forEach(discretionaryItems, function (item) {
      var shapeItem = itemRegistry.getShape(item.id);

      if (shapeItem) {
        shapes.push(shapeItem);
      }
    });

    if (shapes && shapes.length) {
      self.updatePlanItemDefinitions(shapes);
    }
  }, true);

  // MOVING //////////////////////////////////////////////////////////////

  this.preExecuted('elements.move', function (context) {

    var allShapes = context.closure.allShapes,
        newParent = context.newParent,
        hints = context.hints,
        oldParent = hints && hints.primaryShape && hints.primaryShape.parent,
        replacements = {},
        shapes,
        // array of moved item capables
    movedItemCapables = {},
        // grouped by definition
    newTargetCase;

    if (!newParent || oldParent === newParent) {
      return;
    }

    newTargetCase = getCase(newParent);

    shapes = filter(allShapes, function (shape) {

      if (isItemCapable(shape) && !isLabel(shape) && getCase(shape) !== newTargetCase) {

        var definition = getDefinition(shape);
        movedItemCapables[definition.id] = movedItemCapables[definition.id] || [];
        movedItemCapables[definition.id].push(shape);

        return true;
      }

      return false;
    });

    forEach(shapes, function (shape) {

      var definition = getDefinition(shape),
          referencedBy,
          movedShapes,
          newDefinition;

      if (replacements[definition.id]) {
        newDefinition = replacements[definition.id];
      } else {

        referencedBy = itemRegistry.getReferences(definition.id);
        movedShapes = movedItemCapables[definition.id];

        if (referencedBy.length > movedShapes.length) {
          newDefinition = replacements[definition.id] = cmmnReplace.replacePlanItemDefinition(definition);
        }
      }

      if (newDefinition && newDefinition !== definition) {
        modeling.updateProperties(shape, {
          definitionRef: newDefinition
        });
      }
    });

    // remember replacement of definitions
    context.definitionReplacements = replacements;
  }, true);

  this.postExecuted('elements.move', LOW_PRIORITY, function (context) {

    var shapes = context.shapes,
        newParent = context.newParent,
        oldParent = context.hints && context.hints.oldParent;

    if (!newParent || oldParent === newParent) {
      return;
    }

    shapes = filter(shapes, function (shape) {
      return isItemCapable(shape) && !isLabel(shape);
    });

    if (shapes && shapes.length) {
      self.updatePlanItemDefinitions(shapes);
    }
  }, true);

  // CONNECTIONS //////////////////////////////////////////////////////////////

  this.postExecuted(['connection.create', 'connection.delete', 'connection.reconnectEnd', 'connection.reconnectStart'], LOW_PRIORITY, function (context) {

    var connection = context.connection,
        source = context.newSource || context.source || connection.source,
        target = context.newTarget || context.target || connection.target,
        shapes = [];

    if (!isDiscretionaryConnection(connection, source, target)) {
      return;
    }

    if (connection.target) {
      shapes.push(connection.target);
    }

    if (!connection.target && context.target) {
      shapes.push(context.target);
    }

    if (context.oldTarget) {
      shapes.push(context.oldTarget);
    }

    if (shapes && shapes.length) {
      self.updatePlanItemDefinitions(shapes);
    }
  }, true);

  // API ////////////////////////////////////////////////////////

  /**
   * Deletes the given plan item definitions.
   *
   * A plan item definition is deleted when it is not
   * referenced by a plan item or a discretionary item.
   *
   * @param {Array<ModdleElement>} definitions to delete
   */
  this.deletePlanItemDefinitions = function (definitions) {
    var references;

    forEach(definitions, function (definition) {
      references = itemRegistry.getReferences(definition);
      if (!references.length) {
        modeling.updateSemanticParent(definition, null, containment);
      }
    });
  };

  /**
   * Rearrange the plan item definitions of the given shapes.
   *
   * @param {Array<djs.model.Base>} shapes
   */
  this.updatePlanItemDefinitions = function (shapes) {

    handleEachItemCapable(shapes, function (shape) {

      var item = getBusinessObject(shape),
          definition = getDefinition(item),
          references = itemRegistry.getReferences(definition),
          sharedParent = getSharedParent(references);

      if (!sharedParent) {
        sharedParent = getCasePlanModel(item);
      }

      if (sharedParent && sharedParent !== definition.$parent) {
        modeling.updateSemanticParent(definition, sharedParent, containment);
      }

      var itemCapables = getDirectItemCapables(definition),
          children = [];

      if (is(definition, 'cmmn:PlanFragment') && shape.children && shape.children.length) {
        forEach(shape.children, function (child) {
          var bo = getBusinessObject(child);
          if (isItemCapable(bo) && !isLabel(bo) && itemCapables.indexOf(bo) === -1) {
            children.push(bo);
          }
        });
      }

      return unionBy('id', itemCapables, children);
    });
  };

  // UTILITIES ///////////////////////////////////////////////////////////////


  function handleEachItemCapable(elements, fn) {

    var handledElements = {};

    function handled(element) {
      handledElements[element.id] = element;
    }

    function isHandled(element) {
      return !!handledElements[element.id];
    }

    function eachElement(elements, isRoot) {
      forEach(elements, function (element) {

        if (!isHandled(element)) {
          handled(element);

          element = itemRegistry.getShape(element.id) || element;
          var children = fn(element);

          if (children && children.length) {
            eachElement(children);
          }
        }

        if (isRoot) {
          handledElements = {};
        }
      });
    }

    eachElement(elements, true);
  }
}

PlanItemDefinitionUpdater.$inject = ['eventBus', 'modeling', 'cmmnReplace', 'itemRegistry'];

inherits(PlanItemDefinitionUpdater, CommandInterceptor);

module.exports = PlanItemDefinitionUpdater;

/**
 * Utilities
 */

function getSharedParent(elements) {

  var sharedParent, first;

  if (elements.length) {

    first = elements.splice(0, 1)[0];

    if (!elements.length) {
      sharedParent = getParentStage(first);
    } else {
      var candidates = getParentStages(first);
      forEach(elements, function (e) {
        candidates = intersection(candidates, getParentStages(e));
      });

      sharedParent = candidates[0];
    }
  }

  return sharedParent;
}

function getParentStage(element) {
  element = getBusinessObject(element);
  return getParent(element, 'cmmn:Stage');
}

function getParentStages(element) {
  element = getBusinessObject(element);
  return getParents(element, 'cmmn:Stage');
}

function getCasePlanModel(element) {
  var _case = getParent(element, 'cmmn:Case');
  return _case && _case.casePlanModel;
}

function isDiscretionaryConnection(connection, source, target) {
  return !connection.businessObject.cmmnElementRef;
}

// helpers /////////////////

function intersection(a, b) {

  return filter(a, function (e) {
    return b.indexOf(e) !== -1;
  });
}

},{"253":253,"254":254,"45":45,"46":46,"76":76,"91":91}],30:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var CommandInterceptor = _dereq_(91).default;

var some = _dereq_(254).some,
    forEach = _dereq_(254).forEach;

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    isCasePlanModel = ModelUtil.isCasePlanModel,
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject;

var getParent = _dereq_(45).getParent,
    isLabel = _dereq_(45).isLabel,
    getParents = _dereq_(45).getParents;

var PlanItemDefinitionUtil = _dereq_(46),
    isDiscretionaryToHumanTask = PlanItemDefinitionUtil.isDiscretionaryToHumanTask,
    isDiscretionaryItem = PlanItemDefinitionUtil.isDiscretionaryItem,
    isPlanFragment = PlanItemDefinitionUtil.isPlanFragment,
    getAllDiscretionaryItems = PlanItemDefinitionUtil.getAllDiscretionaryItems,
    isHumanTask = PlanItemDefinitionUtil.isHumanTask;

/**
 * A handler responsible for adding, moving and deleting discretionary items
 * and adding them to planning table. These changes are reflected to
 * the underlying CMMN 1.1 XML.
 */
function PlanningTableUpdater(eventBus, cmmnFactory, modeling, itemRegistry) {

  this._cmmnFactory = cmmnFactory;
  this._modeling = modeling;
  this._itemRegistry = itemRegistry;

  var self = this;

  CommandInterceptor.call(this, eventBus);

  var containment = 'tableItems';

  // CONNECTION /////////////////////////////////////////////


  // delete + reconnectEnd //////////////////////////////////


  this.preExecuted(['connection.delete', 'connection.reconnectEnd', 'connection.reconnectStart'], function (event) {

    var context = event.context,
        isReconnectStart = event.command === 'connection.reconnectStart',
        connection = context.connection,
        target = connection.target;

    if (!isDiscretionaryConnection(connection)) {
      return;
    }

    if (isReconnectStart) {

      if (context.newSource && context.newTarget) {
        target = context.newSource;
        context.oldPlanningTable = getParentPlanningTable(target);
      } else {
        return;
      }
    }

    // (1) remember current
    context.planningTable = getParentPlanningTable(target);

    // (2) if the target did not change, then do nothing (in case of reconnectEnd)
    if (target === context.newTarget) {
      return;
    }

    // (3) is there at least another discretionary connection referencing
    // this target.
    // note: there could be multiple plan items (with the same definition -
    // human task) referencing the same discretionary item. in such case
    // the deletion/reconnection of a discretionary connection does not trigger
    // the deletion of the other discretionary connections. As a result, the
    // the discretionary item remains in its current planning table.
    if (isReferencedByAnotherDiscretionaryConnection(target, connection)) {
      return;
    }

    // (4) get new target definition of discretionary item
    var definition = getTargetDefinition(target.parent);

    // (5) create a planning table if necessary
    var planningTable = self.createPlanningTable(definition);

    // (6) move (current target) discretionary item from current planning table
    // to the new planning table
    modeling.updateSemanticParent(target, planningTable, containment);
  });

  this.postExecuted('connection.delete', function (context) {

    if (!isDiscretionaryConnection(context.connection)) {
      return;
    }

    // triggers deletion of planning table if it is empty
    self.deletePlanningTable(context.planningTable);
  }, true);

  this.postExecuted('connection.reconnectEnd', function (context) {

    var connection = context.connection,
        target = connection.target;

    if (!isDiscretionaryConnection(connection)) {
      return;
    }

    // (1) remember old planning table of new target
    var oldPlanningTable = getParentPlanningTable(target);

    // (2) add new target as discretionary item into the planning table of the source element
    modeling.updateSemanticParent(target, context.planningTable, containment);

    // (3) remove old planning table if its empty
    self.deletePlanningTable(oldPlanningTable);
  }, true);

  this.postExecuted('connection.reconnectStart', function (context) {

    var connection = context.connection;

    if (!isDiscretionaryConnection(connection)) {
      return;
    }

    if (!context.newSource || !context.newTarget) {
      return;
    }

    self.deletePlanningTable(context.oldPlanningTable);
  }, true);

  // create + reconnectStart ////////////////////////////////////////

  this.preExecuted(['connection.create', 'connection.reconnectStart'], function (context) {

    var connection = context.connection,
        source = context.newSource || context.source,
        target = context.target || context.newTarget || connection.target;

    if (!isDiscretionaryConnection(connection)) {
      return;
    }

    // (1) remember planning table of target discretionary item
    context.planningTable = getParentPlanningTable(target);

    var definition = getDefinition(source);

    if (connection.source) {
      var oldDefinition = getDefinition(connection.source);
      if (oldDefinition === definition) {
        return;
      }
    }

    // (2) create a planning table if necessary
    var planningTable = self.createPlanningTable(definition);

    // (3) add target discretionary item to planning table
    modeling.updateSemanticParent(target, planningTable, containment);
  }, true);

  this.postExecuted(['connection.create', 'connection.reconnectStart'], function (context) {

    var connection = context.connection;
    if (!isDiscretionaryConnection(connection)) {
      return;
    }

    // remove planning table if its empty
    self.deletePlanningTable(context.planningTable);
  }, true);

  // SHAPE /////////////////////////////////////////////////////////////////////////////

  this.preExecuted('elements.move', 500, function (context) {

    var allShapes = context.closure.allShapes,
        newParent = context.newParent,
        hints = context.hints,
        oldParent = hints && hints.primaryShape && hints.primaryShape.parent,
        replacements = context.definitionReplacements,
        replacedPlanningTableArray = [],
        planningTableReplacedBy = {};

    function clonePlanningTable(planningTable) {
      var newPlanningTable = cmmnFactory.create('cmmn:PlanningTable', {
        applicabilityRules: planningTable.applicabilityRules
      });
      var idx = replacedPlanningTableArray.push(planningTable);
      planningTableReplacedBy[idx - 1] = newPlanningTable;

      return newPlanningTable;
    }

    if (!newParent || oldParent === newParent) {
      return;
    }

    forEach(allShapes, function (shape) {

      var bo = getBusinessObject(shape),
          newPlanningTables = [],
          discretionaryTo,
          replacedBy,
          items,
          planningTables,
          previousPlanningTable;

      if (!isDiscretionaryItem(shape) || isLabel(shape)) {
        return;
      }

      discretionaryTo = getParent(bo, 'cmmn:PlanItemDefinition');
      if (!is(discretionaryTo, 'cmmn:HumanTask')) {
        return;
      }

      replacedBy = replacements[discretionaryTo.id];
      if (!replacedBy) {
        return;
      }

      // discretionary item is already contained by replacement
      if ((getAllDiscretionaryItems(replacedBy) || []).indexOf(bo) !== -1) {
        return;
      }

      // have been all contained discretionary items moved?
      items = getAllDiscretionaryItems(discretionaryTo);
      var allMoved = !some(items, function (item) {
        return !allShapes[item.id];
      });

      if (allMoved) {

        // if yes, then just move planning table to replacement

        var planningTable = discretionaryTo.planningTable;

        modeling.updateProperties(replacedBy, {
          planningTable: planningTable
        }, itemRegistry.getShapes(replacedBy));

        modeling.updateSemanticParent(planningTable, replacedBy);

        modeling.updateProperties(discretionaryTo, {
          planningTable: undefined
        }, itemRegistry.getShapes(discretionaryTo));

        return;
      }

      planningTables = getParents(bo, 'cmmn:PlanningTable');

      if (planningTables && planningTables.length) {

        forEach(planningTables, function (planningTable) {

          var idx = replacedPlanningTableArray.indexOf(planningTable),
              newPlanningTable;

          if (idx === -1) {
            newPlanningTable = clonePlanningTable(planningTable);
          } else {
            newPlanningTable = planningTableReplacedBy[idx];
          }

          if (previousPlanningTable && !previousPlanningTable.$parent) {
            modeling.updateSemanticParent(previousPlanningTable, newPlanningTable, 'tableItems');
          }

          previousPlanningTable = newPlanningTable;
          newPlanningTables.push(newPlanningTable);
        });

        if (!replacedBy.planningTable) {

          modeling.updateProperties(replacedBy, {
            planningTable: previousPlanningTable
          }, itemRegistry.getShapes(replacedBy));
          modeling.updateSemanticParent(previousPlanningTable, replacedBy);
        }

        var first = newPlanningTables.splice(0, 1)[0],
            oldPlanningTable = getParentPlanningTable(bo);

        modeling.updateSemanticParent(bo, first, 'tableItems');

        self.deletePlanningTable(oldPlanningTable);
      }
    });
  }, true);

  this.preExecuted(['shape.create', 'shape.move'], function (context) {

    var shape = context.shape;

    if (!isDiscretionaryItem(shape) || isLabel(shape)) {
      return;
    }

    // (1) if is discretionary to human task, then there is nothing to do
    // in case of 'shape.move'
    if (isDiscretionaryToHumanTask(shape)) {
      return;
    }

    // remember old planning table
    context.planningTable = getParentPlanningTable(shape);

    var newParent = context.parent || context.newParent;

    if (newParent) {

      // (2) parent changed

      var definition = getTargetDefinition(newParent);

      // (3) create new planning table if necessary
      var planningTable = self.createPlanningTable(definition);

      // (4) add discretionary item to planning table
      modeling.updateSemanticParent(shape, planningTable, containment);
    }
  }, true);

  this.postExecuted('shape.move', function (context) {

    var shape = context.shape;

    if (!isDiscretionaryItem(shape) || isLabel(shape)) {
      return;
    }

    // if an item which is discretionary to a human task is moved,
    // then no update is necessary
    if (isDiscretionaryToHumanTask(shape)) {
      return;
    }

    self.deletePlanningTable(context.planningTable);
  }, true);

  this.preExecuted('shape.delete', function (context) {

    var shape = context.shape;

    if (!isDiscretionaryItem(shape) || isLabel(shape)) {
      return;
    }

    // remember old planning table
    context.planningTable = getParentPlanningTable(shape);

    // remove discretionary item from planning table
    modeling.updateSemanticParent(shape, null, containment);
  }, true);

  this.postExecuted('shape.delete', function (context) {

    var shape = context.shape;

    if (!isDiscretionaryItem(shape) || isLabel(shape)) {
      return;
    }

    self.deletePlanningTable(context.planningTable);
  }, true);

  this.postExecuted('shape.delete', 500, function (context) {

    var shape = context.shape;

    var definition = getDefinition(shape);

    if (!isHumanTask(definition) || definition.$parent) {
      return;
    }

    var discretionaryItems = getAllDiscretionaryItems(definition);

    // repair the model
    forEach(discretionaryItems, function (item) {
      var shapeItem = itemRegistry.getShape(item.id);

      if (shapeItem) {
        // get new target definition of discretionary item
        var definition = getTargetDefinition(shapeItem.parent);

        // create a planning table if necessary
        var planningTable = self.createPlanningTable(definition);

        // move (current target) discretionary item from current planning table
        // to the new planning table
        modeling.updateSemanticParent(shapeItem, planningTable, containment);
      }
    });

    if (definition.planningTable) {
      self.deletePlanningTable(definition.planningTable);
    }
  }, true);

  // API ////////////////////////////////////////////////////////

  /**
   * Creates a new planning table for the given definition, if necessary.
   *
   * If the given definition already contains a planning table, this
   * planning table is returned.
   *
   * @param {ModdleElement} definition where the planning table is added
   *
   * @return {ModdleElement} the create planning table
   */
  this.createPlanningTable = function (definition) {

    var planningTable = definition.planningTable;

    if (!planningTable) {

      // (1) create new planning table
      planningTable = self._cmmnFactory.create('cmmn:PlanningTable');

      // (2) filter all items which are affected by adding a planning
      // table to its definition
      var shapes = itemRegistry.getShapes(definition);

      // (3) set planning table
      modeling.updateProperties(definition, {
        planningTable: planningTable
      }, shapes);

      // (4) set parent of planning table to definition
      modeling.updateSemanticParent(planningTable, definition);
    }

    return planningTable;
  };

  /**
   * Deletes a given planning table from the definition. If the planning
   * table is nested inside other planning tables, then the plannings tables
   * are also deleted, if they do not contain any element.
   *
   * @param {ModdleElement} planningTable to delete
   *
   */
  this.deletePlanningTable = function (planningTable) {

    // According to spec: a planning table must contain at least one element.
    // if it does not contain any element, then the planning table is deleted.

    // (1) cannot delete planning table if contains at least one element
    if (planningTable.get(containment).length > 0) {
      return;
    }

    // (2) if planning table does not contain any element, then remove it
    var oldParent = planningTable.$parent;
    while (is(oldParent, 'cmmn:PlanningTable') && !planningTable.get(containment).length) {
      modeling.updateSemanticParent(planningTable, null, containment);
      planningTable = oldParent;
      oldParent = oldParent.$parent;
    }

    if (is(oldParent, 'cmmn:PlanItemDefinition')) {

      if (planningTable && !planningTable.get(containment).length) {

        // (3) get definition containing this planning table
        var definition = getParent(planningTable, 'cmmn:PlanItemDefinition');

        // (4) filter all items which are affected by removing this planning
        // table from its definition
        var shapes = itemRegistry.getShapes(definition);

        // (5) set planning table attribute to undefined
        modeling.updateProperties(definition, {
          planningTable: undefined
        }, shapes);

        // (6) set planning tables parent to null
        modeling.updateSemanticParent(planningTable, null, null);
      }
    }
  };

  /**
   * Returns true, if there is another incoming discretionary connection
   * apart the given connection.
   *
   * @param {djs.mode.Base} shape
   * @param {djs.mode.Base} connection
   *
   * @return {boolean} if there is another incoming discretionary connection
   */
  function isReferencedByAnotherDiscretionaryConnection(shape, connection) {
    return some(shape.incoming, function (con) {
      return con !== connection && isDiscretionaryConnection(con);
    });
  }

  function isDiscretionaryConnection(connection) {
    return !connection.businessObject.cmmnElementRef;
  }
}

PlanningTableUpdater.$inject = ['eventBus', 'cmmnFactory', 'modeling', 'itemRegistry'];

inherits(PlanningTableUpdater, CommandInterceptor);

module.exports = PlanningTableUpdater;

function getTargetDefinition(shape) {
  var target = fixTarget(shape);
  return getDefinition(target) || getBusinessObject(target);
}

/**
 * Fixes the target.
 * A discretionary item cannot be added to plan fragment,
 * in that case the discretionary item is added to the visual
 * surrounding stage.
 *
 * @param {djs.model.Base} target
 *
 * @return {djs.model.Base} the fixed target
 */
function fixTarget(target) {
  if (target && !isCasePlanModel(target)) {

    var definition = getDefinition(target);

    if (isPlanFragment(definition)) {
      target = getParent(target, ['cmmn:Stage', 'cmmn:PlanItem', 'cmmn:DiscretionaryItem']);
      target = fixTarget(target);
    }
  }

  return target;
}

/**
 * Returns parent planning table of the given element.
 *
 * @param {ModdleElement} element
 *
 * @param {ModdleElement} the parent planning table
 */
function getParentPlanningTable(element) {
  element = getBusinessObject(element);
  return getParent(element, 'cmmn:PlanningTable');
}

},{"253":253,"254":254,"45":45,"46":46,"76":76,"91":91}],31:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(254).forEach,
    inherits = _dereq_(253),
    assign = _dereq_(254).assign;

var isArray = _dereq_(254).isArray;

var CommandInterceptor = _dereq_(91).default;

var is = _dereq_(76).is;

var LOW_PRIORITY = 200,
    HIGH_PRIORITY = 5000;

function ReplaceConnectionBehavior(eventBus, modeling, cmmnRules, selection, rules) {

  CommandInterceptor.call(this, eventBus);

  function canConnectPlanItemOnPartConnection(source, target) {
    return cmmnRules.canConnectPlanItemOnPartConnection(source, target);
  }

  function canConnectCaseFileItemOnPartConnection(source, target) {
    return cmmnRules.canConnectCaseFileItemOnPartConnection(source, target);
  }

  function canConnectDiscretionaryConnection(source, target, connection) {
    return cmmnRules.canConnectDiscretionaryConnection(source, target, connection);
  }

  function canConnectAssociation(source, target) {
    return cmmnRules.canConnectAssociation(source, target);
  }

  function canReconnect(type, attrs) {
    return rules.allowed(type, attrs);
  }

  function fixConnection(connection, source, target, hints) {

    var parent = connection.parent;

    hints = hints || {};
    source = source || connection.source;
    target = target || connection.target;

    if (!parent) {
      return;
    }

    var remove,
        replacement,
        cmmnElement = getCmmnElement(connection);

    /**
     * Check if incoming or outgoing connections can stay and/or replaced.
     */

    if (cmmnElement) {

      if (is(cmmnElement, 'cmmn:PlanItemOnPart')) {

        if (!canConnectPlanItemOnPartConnection(source, target)) {
          remove = true;
        }

        if (canConnectCaseFileItemOnPartConnection(source, target)) {
          replacement = {
            type: 'cmmn:CaseFileItemOnPart',
            name: cmmnElement.name,
            isStandardEventVisible: isStandardEventVisible(connection)
          };
        }

        if (canConnectDiscretionaryConnection(source, target, connection)) {
          replacement = {
            type: 'cmmndi:CMMNEdge'
          };
        }
      }

      if (is(cmmnElement, 'cmmn:CaseFileItemOnPart')) {

        if (!canConnectCaseFileItemOnPartConnection(source, target)) {
          remove = true;
        }

        if (canConnectPlanItemOnPartConnection(source, target)) {
          replacement = {
            type: 'cmmn:PlanItemOnPart',
            name: cmmnElement.name,
            isStandardEventVisible: isStandardEventVisible(connection)
          };
        }
      }

      if (is(cmmnElement, 'cmmn:Association') && !canConnectAssociation(source, target)) {
        remove = true;
      }
    } else {

      if (!canConnectDiscretionaryConnection(source, target, connection)) {
        remove = true;
      }

      if (canConnectPlanItemOnPartConnection(source, target)) {
        replacement = {
          type: 'cmmn:PlanItemOnPart',
          isStandardEventVisible: true
        };
      }
    }

    if (remove) {

      if (!replacement && (isTextAnnotation(source) || isTextAnnotation(target))) {

        replacement = {
          type: 'cmmn:Association'
        };
      }

      modeling.removeConnection(connection);
    }

    if (replacement) {

      var attrs = assign({
        waypoints: connection.waypoints.slice()
      }, replacement);

      var newConnection = modeling.connect(source, target, attrs);

      if (hints.select !== false) {
        selection.select(newConnection);
      }

      return newConnection;
    }
  }

  this.postExecuted('elements.move', LOW_PRIORITY, function (context) {

    var closure = context.closure,
        allConnections = closure.allConnections;

    forEach(allConnections, function (connection) {
      fixConnection(connection, null, null, {
        select: false
      });
    });
  }, true);

  this.preExecute(['connection.reconnectEnd', 'connection.reconnectStart'], HIGH_PRIORITY + LOW_PRIORITY, function (event) {

    var type = event.command,
        isReconnectStart = type === 'connection.reconnectStart',
        context = event.context,
        connection = context.connection,
        source = context.newSource || connection.source,
        target = context.newTarget || connection.target,
        dockingOrPoints = context.dockingOrPoints,
        canExecute = context.canExecute;

    if (context.hints && context.hints.nested) {
      return;
    }

    if (canExecute === undefined) {

      var attrs = {
        connection: connection
      };

      attrs[isReconnectStart ? 'hover' : 'source'] = source;
      attrs[!isReconnectStart ? 'hover' : 'target'] = target;

      canExecute = canReconnect(type, attrs);
    }

    if (canExecute && canExecute.reverse) {

      if (!isArray(dockingOrPoints)) {
        var waypoints = connection.waypoints.slice();
        waypoints.splice(isReconnectStart ? 0 : -1, 1, dockingOrPoints);
        dockingOrPoints = waypoints;
      }

      context.newSource = target;
      context.newTarget = source;
      context.dockingOrPoints = dockingOrPoints.reverse();
    }
  });

  this.preExecute(['connection.reconnectStart', 'connection.reconnectEnd'], HIGH_PRIORITY, function (context) {

    var connection = context.connection,
        source = context.newSource || connection.source,
        target = context.newTarget || connection.target,
        hints = context.hints || {};

    context.connection = fixConnection(connection, source, target, {
      select: !hints.nested
    }) || connection;
  }, true);

  this.postExecuted('shape.replace', function (context) {

    var shape = context.newShape,
        bo = shape.businessObject,
        connections = getAttachersOutgoingConnections(shape);

    forEach(connections, function (connection) {

      var source = connection.source,
          target = connection.target,
          cmmnElement = getCmmnElement(connection);

      if (is(cmmnElement, 'cmmn:PlanItemOnPart')) {

        if (canConnectPlanItemOnPartConnection(source, target)) {
          modeling.updateProperties(cmmnElement, { sourceRef: bo }, connection);
        } else {
          modeling.removeConnection(connection);
        }
      }
    });
  }, true);

  this.postExecuted('element.updateProperties', function (context) {

    var properties = context.properties,
        changed = context.changed;

    if (properties && properties.isBlocking === false) {

      forEach(changed, function (shape) {

        var connections = shape.outgoing;

        forEach(connections, function (connection) {
          fixConnection(connection, null, null, {
            select: false
          });
        });
      });
    }
  }, true);
}

inherits(ReplaceConnectionBehavior, CommandInterceptor);

ReplaceConnectionBehavior.$inject = ['eventBus', 'modeling', 'cmmnRules', 'selection', 'rules'];

module.exports = ReplaceConnectionBehavior;

function isStandardEventVisible(connection) {
  return connection.businessObject.isStandardEventVisible;
}

function getCmmnElement(connection) {
  return connection.businessObject && connection.businessObject.cmmnElementRef;
}

function getAttachersOutgoingConnections(shape) {

  var attachers = shape.attachers,
      connections = [];

  forEach(attachers, function (attacher) {
    forEach(attacher.outgoing, function (connection) {
      connections.push(connection);
    });
  });

  return connections;
}

function isTextAnnotation(element) {
  return is(element, 'cmmn:TextAnnotation');
}

},{"253":253,"254":254,"76":76,"91":91}],32:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var CommandInterceptor = _dereq_(91).default;

var saveClear = _dereq_(246).saveClear;

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition,
    getSentry = ModelUtil.getSentry;

var forEach = _dereq_(254).forEach,
    filter = _dereq_(254).filter,
    assign = _dereq_(254).assign;

var HIGH_PRIORITY = 6000,
    LOW_PRIORITY = 500,
    VERY_LOW_PRIORITY = 100;

function ReplaceElementBehavior(cmmnReplace, cmmnRules, elementFactory, elementRegistry, eventBus, modeling, selection, rules) {

  CommandInterceptor.call(this, eventBus);

  this._cmmnReplace = cmmnReplace;
  this._cmmnRules = cmmnRules;
  this._elementFactory = elementFactory;
  this._elementRegistry = elementRegistry;
  this._modeling = modeling;
  this._selection = selection;
  this._rules = rules;

  var self = this;

  function canConnect(source, target) {

    return rules.allowed('connection.create', {
      source: source,
      target: target
    });
  }

  function canReconnect(type, attrs) {
    return rules.allowed(type, attrs);
  }

  // SHAPES //////////////////////////////////////////////////////////////////

  this.preExecute(['shape.create', 'shape.append'], HIGH_PRIORITY, function (context) {

    var shape = context.shape,
        source = context.source,
        target = context.parent || context.target || source && source.parent,
        host = context.host,
        position = context.position,
        hints = context.hints || {};

    if (hints.nested) {
      return;
    }

    if (host && isCriterion(shape)) {
      target = host;
    }

    if (!cmmnRules.canCreate(shape, target, source, position)) {

      var canReplace = cmmnRules.canReplace([shape], target, position, source);

      if (canReplace && canReplace.replacements) {

        var replacement = canReplace.replacements[0],
            definition = getDefinition(shape),
            sentry = getSentry(shape),
            elementType = replacement.newElementType,
            definitionType = replacement.newDefinitionType || definition && definition.$type;

        var attrs = assign({}, {
          type: elementType
        });

        if (definitionType) {
          assign(attrs, {
            definitionType: definitionType
          });
        }

        if (sentry) {
          assign(attrs, {
            sentryRef: sentry
          });
        }

        context.shape = elementFactory.createShape(attrs);
      }
    }
  }, true);

  this.postExecuted('elements.move', LOW_PRIORITY, function (context) {

    var target = context.newParent,
        newHost = context.newHost,
        elements = context.shapes.slice();

    if (elements.length === 1 && newHost) {
      target = newHost;
    } else {
      elements = filter(elements, function (elem) {
        return !isCriterion(elem);
      });
    }

    if (target && !cmmnRules.canMove(elements, target)) {

      var canReplace = cmmnRules.canReplace(elements, target);

      if (canReplace && canReplace.replacements) {
        self.replaceElements(elements, canReplace.replacements);
      }
    }
  }, true);

  this.postExecuted(['shape.replace'], 1500, function (e) {
    var context = e.context,
        oldShape = context.oldShape,
        newShape = context.newShape;

    modeling.unclaimId(oldShape.businessObject.id, oldShape.businessObject);
    modeling.updateProperties(newShape, { id: oldShape.id });
  });

  // CONNECTIONS /////////////////////////////////////////////////////////////////////

  this.preExecute('connection.create', HIGH_PRIORITY, function (context) {

    var source = context.source,
        target = context.target,
        canReplace = context.canExecute || canConnect(source, target);

    if (canReplace && canReplace.replacements) {

      var replacements = self.replaceElements([source, target], canReplace.replacements, {
        select: false
      });

      context.source = replacements[source.id] || context.source;
      context.target = replacements[target.id] || context.target;

      // remember replaced by element in canReplace object (see 'connect.end')
      assign(canReplace, {
        replacedBy: !canReplace.reverse ? context.target : context.source
      });
    }
  }, true);

  eventBus.on('connect.end', LOW_PRIORITY + VERY_LOW_PRIORITY, function (e) {

    var canExecute = e.context.canExecute,
        replacedBy = canExecute && canExecute.replacedBy;

    // if target shape has been replaced, then select the
    // new element and not the old target.
    if (replacedBy) {
      e.context.target = replacedBy;
    }
  });

  this.preExecute(['connection.reconnectStart', 'connection.reconnectEnd'], HIGH_PRIORITY, function (event) {

    var type = event.command,
        isReconnectStart = type === 'connection.reconnectStart',
        context = event.context,
        connection = context.connection,
        source = context.newSource || connection.source,
        target = context.newTarget || connection.target,
        attrs = { connection: connection },
        canReplace;

    if (context.hints && context.hints.nested) {
      return;
    }

    attrs[isReconnectStart ? 'hover' : 'source'] = source;
    attrs[!isReconnectStart ? 'hover' : 'target'] = target;

    canReplace = canReconnect(type, attrs);

    if (canReplace && canReplace.replacements) {
      var replacements = self.replaceElements([source, target], canReplace.replacements, {
        select: false
      });

      context.newSource = replacements[source.id] || context.newSource;
      context.newTarget = replacements[target.id] || context.newTarget;
    }

    // remember result in context, so that this can be re-used
    context.canExecute = canReplace;
  });

  this.preExecute('shape.delete', HIGH_PRIORITY, function (context) {

    var shape = context.shape,
        parent = isCriterion(shape) ? shape.host : shape.parent,
        definition = getDefinition(parent);

    // if the shape to delete is contained by a plan fragment (and not stage)
    // then remove incoming connections. Thereby an additional hint is provided
    // to the context, so that shape delete is not replaced when the connection
    // is deleted.

    if (is(definition, 'cmmn:Stage')) {
      return;
    }

    saveClear(shape.incoming, function (connection) {
      modeling.removeConnection(connection, { nested: true, endChanged: true });
    });
  }, true);

  this.postExecuted(['connection.delete', 'connection.reconnectEnd'], LOW_PRIORITY, function (context) {

    var shape = context.target || context.oldTarget,
        elements = [shape],
        target = isCriterion(shape) ? shape.host : shape.parent,
        hints = context.hints || {};

    if (hints.endChanged) {
      return;
    }

    if (target && !cmmnRules.canMove(elements, target)) {

      var canReplace = cmmnRules.canReplace(elements, target);

      if (canReplace && canReplace.replacements) {
        self.replaceElements(elements, canReplace.replacements, { select: false });
      }
    }
  }, true);

  // PROPERTIES /////////////////////////////////////////////////////////////////////

  this.postExecuted('element.updateProperties', function (context) {

    var properties = context.properties,
        changed = context.changed;

    if (properties && properties.isBlocking === false) {

      forEach(changed, function (shape) {

        var attachers = shape.attachers,
            canReplace = cmmnRules.canReplace(attachers, shape);

        if (canReplace) {
          self.replaceElements(attachers, canReplace.replacements, { select: false });
        }
      });
    }
  }, true);

  // API ///////////////////////////////////////////////////////////////////////////

  this.replaceElements = function (elements, newElements, hints) {

    var self = this;

    var elementRegistry = this._elementRegistry,
        selection = this._selection;

    var executedReplacements = {};

    hints = hints || {};

    forEach(newElements, function (replacement) {

      var oldElement = elementRegistry.get(replacement.oldElementId),
          idx = elements.indexOf(oldElement),
          replacedBy;

      if (!oldElement) {
        return;
      }

      replacedBy = self.replaceElement(oldElement, replacement);

      if (idx !== -1) {
        elements[idx] = replacedBy;
      }

      executedReplacements[oldElement.id] = replacedBy;
    });

    if (newElements && hints.select !== false) {
      selection.select(elements);
    }

    return executedReplacements;
  };

  this.replaceElement = function (element, replacement) {

    var cmmnReplace = this._cmmnReplace;

    var definition = getDefinition(element),
        definitionType = replacement.newDefinitionType || definition && definition.$type;

    if (!element) {
      return;
    }

    var newElement = {
      type: replacement.newElementType
    };

    if (definitionType) {
      assign(newElement, {
        definitionType: definitionType
      });
    }

    return cmmnReplace.replaceElement(element, newElement, { select: false });
  };
}

ReplaceElementBehavior.$inject = ['cmmnReplace', 'cmmnRules', 'elementFactory', 'elementRegistry', 'eventBus', 'modeling', 'selection', 'rules'];

inherits(ReplaceElementBehavior, CommandInterceptor);

module.exports = ReplaceElementBehavior;

function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

},{"246":246,"253":253,"254":254,"76":76,"91":91}],33:[function(_dereq_,module,exports){
'use strict';

var ModelUtil = _dereq_(76);

var is = ModelUtil.is,
    getBusinessObject = ModelUtil.getBusinessObject,
    isCasePlanModel = ModelUtil.isCasePlanModel;

var filter = _dereq_(254).filter;
var ResizeUtil = _dereq_(196);
var getBBox = _dereq_(235).getBBox;

var SLIGHTLY_HIGHER_PRIORITY = 1001;

var DEFAULT_MIN_WIDTH = 10;

/**
 * Computes the minimum resize box.
 *
 * Note: it is slightly different than
 * diagram-js/lib/features/resize/Resize#computeMinResizeBox
 */
function computeMinResizeBox(context) {
  var shape = context.shape,
      direction = context.direction,
      minDimensions,
      childrenBounds;

  minDimensions = context.minDimensions || {
    width: DEFAULT_MIN_WIDTH,
    height: DEFAULT_MIN_WIDTH
  };

  // get children bounds
  childrenBounds = computeChildrenBBox(shape, context.childrenBoxPadding);

  // get correct minimum bounds from given resize direction
  // basically ensures that the minBounds is max(childrenBounds, minDimensions)
  return ResizeUtil.getMinResizeBounds(direction, shape, minDimensions, childrenBounds);
}

/**
 * Computes the bbox of the children.
 *
 * It first determine all relevant children,
 * then it computes the size of the bbox.
 */
function computeChildrenBBox(shape, padding) {
  // grab all the children that are part of the
  // parents children box
  var elements = filter(shape.children, function (element) {
    return isBBoxChild(shape, element);
  });

  if (elements.length) {
    return ResizeUtil.addPadding(getBBox(elements), padding);
  }
}

/**
 * Returns true, if the given element does
 * have any waypoints, is not a label or an
 * exit criterian attached to the given shape.
 */
function isBBoxChild(shape, element) {

  // exclude connections
  if (element.waypoints) {
    return false;
  }

  // exclude labels
  if (element.type === 'label') {
    return false;
  }

  if (is(element, 'cmmn:ExitCriterion')) {
    var bo = getBusinessObject(shape);
    var exitCriteria = bo.get('exitCriteria');
    var exitCriterion = getBusinessObject(element);
    if (exitCriteria.indexOf(exitCriterion) >= 0) {
      return false;
    }
  }

  return true;
}

/**
 * Computes the minimum resize box by excluding
 * attached exit criteria to the case plan model.
 */
function ResizeCasePlanModelBehavior(eventBus, modeling) {

  eventBus.on('resize.start', SLIGHTLY_HIGHER_PRIORITY, function (event) {
    var context = event.context,
        shape = context.shape;

    if (isCasePlanModel(shape)) {
      context.minBounds = computeMinResizeBox(context);
    }
  });
}

ResizeCasePlanModelBehavior.$inject = ['eventBus', 'modeling'];

module.exports = ResizeCasePlanModelBehavior;

},{"196":196,"235":235,"254":254,"76":76}],34:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var CommandInterceptor = _dereq_(91).default;

var forEach = _dereq_(254).forEach,
    flatten = _dereq_(254).flatten,
    groupBy = _dereq_(254).groupBy,
    map = _dereq_(254).map,
    some = _dereq_(254).some;

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    isCasePlanModel = ModelUtil.isCasePlanModel,
    getSentry = ModelUtil.getSentry,
    getBusinessObject = ModelUtil.getBusinessObject,
    getDefinition = ModelUtil.getDefinition,
    getStandardEvents = ModelUtil.getStandardEvents;

var getParent = _dereq_(45).getParent;

var PlanItemDefinitionUtil = _dereq_(46),
    isItemCapable = PlanItemDefinitionUtil.isItemCapable,
    getAllDiscretionaryItems = PlanItemDefinitionUtil.getAllDiscretionaryItems,
    getDirectItemCapables = PlanItemDefinitionUtil.getDirectItemCapables,
    isHumanTask = PlanItemDefinitionUtil.isHumanTask;

var VERY_LOW_PRIORITY = 300;

/**
 * A handler responsible for adding, moving and deleting sentries.
 * These changes are reflected to the underlying CMMN 1.1 XML.
 */
function SentryUpdater(eventBus, modeling, itemRegistry, cmmnReplace, cmmnFactory) {

  var self = this;

  CommandInterceptor.call(this, eventBus);

  var containment = 'sentries';

  // CONNECTIONS ////////////////////////////////////////////////////////////

  this.postExecuted('connection.create', function (context) {

    var connection = context.connection;

    if (!isOnPartConnection(connection)) {
      return;
    }

    var onPart = getOnPart(connection),
        criterion = connection.target,
        host = criterion.host,
        sentry = getSentry(criterion);

    if (!sentry) {
      sentry = createSentry(criterion);
      modeling.updateSemanticParent(sentry, getSentryParent(host), 'sentries');
    }

    modeling.updateSemanticParent(onPart, sentry, 'onParts', connection);
  }, true);

  this.preExecuted('connection.delete', function (context) {

    var connection = context.connection;

    if (!isOnPartConnection(connection)) {
      return;
    }

    var source = connection.source,
        onPart = getOnPart(connection);

    if (existsAnotherConnection(source, connection)) {
      onPart = cloneOnPart(onPart);
      setCmmnElementRef(connection, onPart);
    }

    modeling.updateSemanticParent(onPart, null, 'onParts', connection);
  }, true);

  this.preExecuted('connection.reconnectStart', function (context) {

    var connection = context.connection,
        source = connection.source;

    if (!isOnPartConnection(connection)) {
      return;
    }

    var onPart = getOnPart(connection),
        criterion = connection.target,
        sentry = getSentry(criterion);

    if (existsAnotherConnection(source, connection)) {
      onPart = cloneOnPart(onPart);
      setCmmnElementRef(connection, onPart);
      modeling.updateSemanticParent(onPart, sentry, 'onParts', connection);
    }
  }, true);

  this.preExecuted('connection.reconnectEnd', function (context) {

    var connection = context.connection,
        source = connection.source;

    if (!isOnPartConnection(connection)) {
      return;
    }

    var onPart = getOnPart(connection),
        oldCriterion = connection.target,
        oldSentry = getSentry(oldCriterion),
        newCriterion = context.newTarget,
        newSentry = getSentry(newCriterion);

    if (oldSentry === newSentry) {
      return;
    }

    if (!newSentry) {
      newSentry = createSentry(newCriterion);
      modeling.updateSemanticParent(newSentry, getSentryParent(newCriterion.host), 'sentries');
    }

    if (existsAnotherConnection(source, connection)) {
      onPart = cloneOnPart(onPart);
      setCmmnElementRef(connection, onPart);
    }

    modeling.updateSemanticParent(onPart, newSentry, 'onParts', connection);
  }, true);

  this.postExecuted(['connection.create', 'connection.reconnectStart'], function (context) {

    var connection = context.connection;

    if (!isOnPartConnection(connection)) {
      return;
    }

    var onPart = getOnPart(connection),
        standardEvent;

    if (!isValidStandardEvent(connection)) {
      standardEvent = getDefaultStandardEvent(connection);
      modeling.updateProperties(onPart, {
        standardEvent: standardEvent
      }, connection);
    }
  }, true);

  // CREATE //////////////////////////////////////////////////////////////////

  this.postExecuted('element.updateAttachment', function (context) {

    var shape = context.shape;

    if (!isCriterion(shape)) {
      return;
    }

    if (shape.host) {
      self.updateSentriesSemanticParent([shape]);
    } else {
      self.deleteSentry(shape);
    }
  }, true);

  // DELETE /////////////////////////////////////////////////////////////

  this.preExecuted('shape.delete', function (context) {

    var definition = getDefinition(context.shape);

    if (!isHumanTask(definition)) {
      return;
    }

    // get remaining discretionary items
    context.discretionaryItems = context.discretionaryItems || getAllDiscretionaryItems(definition);
  }, true);

  this.postExecuted('shape.delete', VERY_LOW_PRIORITY, function (context) {

    var discretionaryItems = context.discretionaryItems,
        attachers;

    attachers = getAttachersRecurse(discretionaryItems);

    if (attachers && attachers.length) {
      self.updateSentriesSemanticParent(attachers);
    }
  }, true);

  // MOVING /////////////////////////////////////////////////////////////

  this.postExecuted(['connection.create', 'connection.delete', 'connection.reconnectEnd', 'connection.reconnectStart'], VERY_LOW_PRIORITY, function (context) {

    var connection = context.connection,
        source = context.newSource || context.source || connection.source,
        target = context.newTarget || context.target || connection.target,
        shapes = [],
        attachers;

    if (!isDiscretionaryConnection(connection, source, target)) {
      return;
    }

    if (connection.target) {
      shapes.push(connection.target);
    }

    if (!connection.target && context.target) {
      shapes.push(context.target);
    }

    if (context.oldTarget) {
      shapes.push(context.oldTarget);
    }

    attachers = getAttachersRecurse(shapes);

    if (attachers && attachers.length) {
      self.updateSentriesSemanticParent(attachers);
    }
  }, true);

  this.postExecuted('elements.move', VERY_LOW_PRIORITY, function (context) {

    var shapes = context.shapes,
        newParent = context.newParent,
        oldParent = context.hints && context.hints.oldParent,
        attachers;

    if (oldParent === newParent) {
      return;
    }

    attachers = getAttachersRecurse(shapes);

    if (attachers && attachers.length) {
      self.updateSentriesSemanticParent(attachers);
    }
  }, true);

  // API //////////////////////////////////////////////////////


  /**
   * Deletes by given criteria referenced sentries, if the
   * the sentry is not referenced by any other criterion.
   *
   * @param {Object} criteria deleted criteria
   */
  this.deleteSentry = function (criterion) {

    var sentry = getSentry(criterion),
        references;

    if (sentry) {
      references = itemRegistry.getReferences(sentry);

      if (references.length <= 1) {
        modeling.updateSemanticParent(sentry, null, containment);
      }
    }
  };

  /**
   * Updates the parent of by given criteria referenced sentries.
   *
   * If the sentry is referenced by multiple criteria and only
   * a part of them has been moved, then the sentry is duplicated.
   *
   * @param {Object} criteria updated criteria
   */
  this.updateSentriesSemanticParent = function (criteria) {

    var groupedCriteria = groupBySentry(criteria),
        replacements = {};

    /**
     * Returns true if the given element is replaced
     */
    function isReplaced(elem) {
      return !!replacements[elem.id];
    }

    /**
     * Set the given old element as replaced
     * with the given new element.
     */
    function replace(oldElem, newElem) {
      replacements[oldElem.id] = newElem;
    }

    /**
     * Returns the replacement of the given element.
     * If no replacement is available the given element
     * itself is returned.
     */
    function getReplacement(elem) {
      return replacements[elem.id] || elem;
    }

    /**
     * Returns true if the sentry should be replaced.
     */
    function shouldReplace(sentry, newParent) {
      var references = itemRegistry.getReferences(sentry),
          criteria = groupedCriteria[sentry.id] || [],
          referencesLength = itemRegistry.getReferences(sentry).length,
          criteriaLength = criteria.length;

      if (referencesLength > criteriaLength) {

        if (!newParent) {
          return true;
        }

        return some(references, function (criterion) {
          var criterionShape = itemRegistry.getShape(criterion);
          return criterionShape && newParent !== getSentryParent(criterionShape.host);
        });
      }

      return false;
    }

    handleEachElement(criteria, function (criterion) {

      var sentry = getSentry(criterion);

      if (sentry) {

        var newParent = getSentryParent(criterion.host);

        if (!newParent) {
          var parent = getParent(getBusinessObject(criterion));
          newParent = parent && getSentryParent(parent);
        }

        if (sentry.$parent === newParent) {
          return;
        }

        if (!isReplaced(sentry) && shouldReplace(sentry, newParent)) {
          var newSentry = cmmnReplace.replaceSentry(sentry);
          replace(sentry, newSentry);

          forEach(criterion.incoming, function (con) {

            var cmmnElement = con.businessObject.cmmnElementRef;
            if (cmmnElement && is(cmmnElement, 'cmmn:OnPart')) {
              replace(cmmnElement, cloneOnPart(cmmnElement));
            }
          });
        }

        sentry = getReplacement(sentry);

        if (getSentry(criterion) !== sentry) {
          setSentryRef(criterion, sentry);
        }

        forEach(criterion.incoming, function (con) {

          var cmmnElement = con.businessObject.cmmnElementRef;
          if (cmmnElement && is(cmmnElement, 'cmmn:OnPart')) {

            var replaceBy = getReplacement(cmmnElement);

            if (replaceBy && cmmnElement !== replaceBy) {
              setCmmnElementRef(con, replaceBy);
              modeling.updateSemanticParent(replaceBy, sentry, 'onParts');
            }
          }
        });

        modeling.updateSemanticParent(sentry, newParent, containment);
      }
    });
  };

  // UTILITIES /////////////////////////////////////////////////////////////////


  function getAttachersRecurse(shapes) {

    var attachers = getAttachers(shapes);

    handleEachElement(shapes, function (shape) {

      var definition = getDefinition(shape);

      if (isHumanTask(definition)) {

        var items = getAllDiscretionaryItems(shape);

        if (items && items.length) {
          attachers = attachers.concat(getAttachers(items));
        }

        return items;
      }

      return getDirectItemCapables(shape);
    });

    return flatten(attachers);
  }

  function handleEachElement(shapes, fn) {

    var handledElements = {};

    function handled(element) {
      handledElements[element.id] = element;
    }

    function isHandled(element) {
      return !!handledElements[element.id];
    }

    function eachElement(elements, isRoot) {
      forEach(elements, function (element) {

        if (!isHandled(element)) {
          handled(element);

          element = itemRegistry.getShape(element.id) || element;

          var children = fn(element);

          if (children && children.length) {
            eachElement(children);
          }
        }

        if (isRoot) {
          handledElements = {};
        }
      });
    }

    eachElement(shapes, true);
  }

  function createSentry(criterion) {
    var sentry = cmmnFactory.createSentry();
    setSentryRef(criterion, sentry);
    return sentry;
  }

  function setSentryRef(criterion, sentry) {
    modeling.updateProperties(criterion, {
      sentryRef: sentry
    });
  }

  function setCmmnElementRef(connection, ref) {
    modeling.updateProperties(connection, {
      cmmnElementRef: ref
    });
  }

  function cloneOnPart(onPart) {
    var attrs = {
      name: onPart.name,
      sourceRef: onPart.sourceRef,
      standardEvent: onPart.standardEvent
    };

    if (is(onPart, 'cmmn:PlanItemOnPart')) {
      attrs.exitCriterionRef = onPart.exitCriterionRef;
    }

    return cmmnFactory.create(onPart.$type, attrs);
  }

  function isOnPartConnection(connection) {
    var cmmnElement = connection.businessObject.cmmnElementRef;
    return is(cmmnElement, 'cmmn:OnPart');
  }

  function isDiscretionaryConnection(connection, source, target) {
    return !connection.businessObject.cmmnElementRef;
  }
}

SentryUpdater.$inject = ['eventBus', 'modeling', 'itemRegistry', 'cmmnReplace', 'cmmnFactory'];

inherits(SentryUpdater, CommandInterceptor);

module.exports = SentryUpdater;

/**
 * Returns based on the given host the parent
 * for a sentry.
 *
 * @param {djs.model.Base} host
 *
 * @result {ModdleElement} parent
 */
function getSentryParent(host) {

  if (isCasePlanModel(host)) {
    return getBusinessObject(host);
  }

  if (isItemCapable(host)) {
    var bo = getBusinessObject(host);
    return getParent(bo, 'cmmn:PlanFragment');
  }
}

/**
 * Returns all attachers for the given shapes.
 *
 * @param {Array<djs.model.Base>} shapes
 *
 * @result {Array<djs.model.Base>} attachers
 */
function getAttachers(shapes) {
  return flatten(map(shapes, function (s) {
    var attachers = [];

    if (s.attachers) {
      attachers = s.attachers;
    } else {
      var bo = getBusinessObject(s);

      var exitCriteria = bo.get('exitCriteria');
      forEach(exitCriteria, function (criterion) {
        attachers.push(criterion);
      });

      var entryCriteria = bo.get('entryCriteria');
      forEach(entryCriteria, function (criterion) {
        attachers.push(criterion);
      });
    }

    return attachers || [];
  }));
}

/**
 * Groups given criteria by sentry.
 *
 * @param {Object} criteria group by id
 *
 * @result {Object} criteria grouped by sentry
 */
function groupBySentry(criteria) {
  return groupBy(criteria, function (criterion) {
    var sentry = getSentry(criterion);
    return sentry && sentry.id;
  });
}

/**
 * Returns true if the given element is a criterion.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean}
 */
function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

function existsAnotherConnection(source, connection) {
  var onPart = getOnPart(connection);
  return some(source.outgoing, function (con) {
    return connection !== con && onPart === getOnPart(con);
  });
}

function getOnPart(connection) {
  connection = getBusinessObject(connection);
  return connection.cmmnElementRef;
}

function isValidStandardEvent(connection) {

  var onPart = getOnPart(connection),
      standardEvent = onPart.standardEvent,
      possibleStandardEvents = getStandardEvents(onPart);

  return standardEvent && possibleStandardEvents.indexOf(standardEvent) !== -1;
}

function getDefaultStandardEvent(element) {

  element = getOnPart(element);

  if (is(element.sourceRef, 'cmmn:CaseFileItem')) {
    return 'update';
  }

  if (is(element.exitCriterionRef, 'cmmn:ExitCriterion')) {
    return 'exit';
  }

  if (is(element.sourceRef, 'cmmn:PlanItem')) {

    var definition = getDefinition(element.sourceRef);
    if (is(definition, 'cmmn:EventListener') || is(definition, 'cmmn:Milestone')) {
      return 'occur';
    } else {
      return 'complete';
    }
  }
}

},{"253":253,"254":254,"45":45,"46":46,"76":76,"91":91}],35:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(254).forEach;

var inherits = _dereq_(253);

var CommandInterceptor = _dereq_(91).default;

function UnclaimIdBehavior(eventBus, modeling) {

  CommandInterceptor.call(this, eventBus);

  this.preExecute('elements.delete', function (event) {
    var context = event.context,
        elements = context.elements;

    forEach(elements, function (element) {
      modeling.unclaimId(element.businessObject.id, element.businessObject);
    });
  });
}

inherits(UnclaimIdBehavior, CommandInterceptor);

UnclaimIdBehavior.$inject = ['eventBus', 'modeling'];

module.exports = UnclaimIdBehavior;

},{"253":253,"254":254,"91":91}],36:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: ['attachCriterionBehavior', 'caseFileItemUpdater', 'labelBehavior', 'planItemDefinitionUpdater', 'planningTableUpdater', 'replaceConnectionBehavior', 'replaceElementBehavior', 'resizeCasePlanModelBehavior', 'sentryUpdater', 'unclaimIdBehavior'],
  attachCriterionBehavior: ['type', _dereq_(26)],
  caseFileItemUpdater: ['type', _dereq_(27)],
  labelBehavior: ['type', _dereq_(28)],
  planItemDefinitionUpdater: ['type', _dereq_(29)],
  planningTableUpdater: ['type', _dereq_(30)],
  replaceConnectionBehavior: ['type', _dereq_(31)],
  replaceElementBehavior: ['type', _dereq_(32)],
  resizeCasePlanModelBehavior: ['type', _dereq_(33)],
  sentryUpdater: ['type', _dereq_(34)],
  unclaimIdBehavior: ['type', _dereq_(35)]
};

},{"26":26,"27":27,"28":28,"29":29,"30":30,"31":31,"32":32,"33":33,"34":34,"35":35}],37:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var is = _dereq_(76).is;

var BaseHandler = _dereq_(152).default;

function AppendShapeHandler(modeling, cmmnRules) {
  this._modeling = modeling;
  this._cmmnRules = cmmnRules;
}

inherits(AppendShapeHandler, BaseHandler);

AppendShapeHandler.$inject = ['modeling', 'cmmnRules'];

module.exports = AppendShapeHandler;

// api /////////////////

AppendShapeHandler.prototype.preExecute = function (context) {

  if (!context.source) {
    throw new Error('source required');
  }

  var cmmnRules = this._cmmnRules;

  var shape = context.shape,
      source = context.source,
      parent = context.target || context.source.parent,
      position = context.position,
      isAttach = context.attach;

  if (isCriterion(shape)) {
    isAttach = cmmnRules.canAttach(shape, parent, source, position) === 'attach';
  }

  context.shape = this._modeling.createShape(shape, position, parent, {
    attach: isAttach,
    nested: true
  });
};

function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

},{"152":152,"253":253,"76":76}],38:[function(_dereq_,module,exports){
'use strict';

function IdClaimHandler(moddle) {
  this._moddle = moddle;
}

IdClaimHandler.$inject = ['moddle'];

module.exports = IdClaimHandler;

IdClaimHandler.prototype.execute = function (context) {
  var ids = this._moddle.ids,
      id = context.id,
      element = context.element,
      claiming = context.claiming;

  if (claiming) {
    ids.claim(id, element);
  } else {
    ids.unclaim(id);
  }
};

IdClaimHandler.prototype.revert = function (context) {
  var ids = this._moddle.ids,
      id = context.id,
      element = context.element,
      claiming = context.claiming;

  if (claiming) {
    ids.unclaim(id);
  } else {
    ids.claim(id, element);
  }
};

},{}],39:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var isArray = _dereq_(254).isArray;

var BaseHandler = _dereq_(165).default;

/**
 * Overwrites the behavior of diagram-js/ReconnectConnectionHandler to enable
 * a switch between source and target of a connection on reconnect.
 */
function ReconnectConnectionHandler(injector) {
  injector.invoke(BaseHandler, this);
}

inherits(ReconnectConnectionHandler, BaseHandler);

ReconnectConnectionHandler.$inject = ['injector'];

module.exports = ReconnectConnectionHandler;

ReconnectConnectionHandler.prototype.execute = function (context) {

  var newSource = context.newSource,
      newTarget = context.newTarget,
      connection = context.connection,
      dockingOrPoints = context.dockingOrPoints;

  if (!newSource && !newTarget) {
    throw new Error('newSource or newTarget are required');
  }

  // removed from corresponding method in diagram-js@3.3.0

  // if (newSource && newTarget) {
  //   throw new Error('must specify either newSource or newTarget');
  // }

  if (isArray(dockingOrPoints)) {
    context.oldWaypoints = connection.waypoints;
    connection.waypoints = dockingOrPoints;
  }

  if (newSource) {
    context.oldSource = connection.source;
    connection.source = newSource;
  }

  if (newTarget) {
    context.oldTarget = connection.target;
    connection.target = newTarget;
  }

  return connection;
};

},{"165":165,"253":253,"254":254}],40:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var BaseHandler = _dereq_(166).default;

function ReplaceShapeHandler(modeling, rules) {
  this._modeling = modeling;
  this._rules = rules;
}

inherits(ReplaceShapeHandler, BaseHandler);

ReplaceShapeHandler.$inject = ['modeling', 'rules'];

module.exports = ReplaceShapeHandler;

// api /////////////////


ReplaceShapeHandler.prototype.createShape = function (shape, position, target) {
  var modeling = this._modeling;
  return modeling.createShape(shape, position, target, {
    nested: true
  });
};

ReplaceShapeHandler.prototype.reconnectStart = function (connection, newSource, dockingPoint) {
  var modeling = this._modeling;
  modeling.reconnectStart(connection, newSource, dockingPoint, {
    nested: true,
    startChanged: true
  });
};

ReplaceShapeHandler.prototype.reconnectEnd = function (connection, newTarget, dockingPoint) {
  var modeling = this._modeling;
  modeling.reconnectEnd(connection, newTarget, dockingPoint, {
    nested: true,
    endChanged: true
  });
};

},{"166":166,"253":253}],41:[function(_dereq_,module,exports){
'use strict';

var filter = _dereq_(254).filter,
    forEach = _dereq_(254).forEach;

var getBusinessObject = _dereq_(76).getBusinessObject,
    getItemControl = _dereq_(76).getItemControl,
    getDefaultControl = _dereq_(76).getDefaultControl,
    getDefinition = _dereq_(76).getDefinition,
    hasPlanningTable = _dereq_(76).hasPlanningTable;

var isPlanningTableCapable = _dereq_(46).isPlanningTableCapable;

function UpdateControlsHandler(itemRegistry, modeling, cmmnReplace, cmmnFactory) {
  this._itemRegistry = itemRegistry;
  this._modeling = modeling;
  this._cmmnReplace = cmmnReplace;
  this._cmmnFactory = cmmnFactory;
}

UpdateControlsHandler.$inject = ['itemRegistry', 'modeling', 'cmmnReplace', 'cmmnFactory'];

module.exports = UpdateControlsHandler;

var PLAN_ITEM_CONTROL_PROPS = ['requiredRule', 'repetitionRule', 'manualActivationRule'];

function getUpdate(key, value) {
  var update = {};
  update[key] = value;
  return update;
}

UpdateControlsHandler.prototype.preExecute = function (context) {

  var self = this;

  var element = context.element,
      values = context.values;

  if (!element) {
    throw new Error('element required');
  }

  forEach(values, function (value, key) {

    if (PLAN_ITEM_CONTROL_PROPS.indexOf(key) !== -1) {
      self._updateRule(element, key, value);
    } else {
      self._updateDecorator(element, key, value);
    }
  });
};

UpdateControlsHandler.prototype.execute = function () {};

UpdateControlsHandler.prototype.revert = function () {};

// API ////////////////////////////////////////////////


UpdateControlsHandler.prototype._updateDecorator = function (element, key, value) {

  var self = this,
      modeling = self._modeling;

  var definition = getDefinition(element),
      update = getUpdate(key, value),
      changed = [];

  if (definition[key] !== value) {

    changed = self._getReferencingShapes(definition);

    if (changed.length > 1 && canReplaceDefinition(definition)) {
      definition = self._replaceDefinition(element);
      changed = element;
    }

    modeling.updateProperties(definition, update, changed);
  }
};

UpdateControlsHandler.prototype._updateRule = function (element, rule, value) {

  var self = this,
      modeling = self._modeling,
      cmmnFactory = self._cmmnFactory;

  var itemControl = getItemControl(element),
      defaultControl = getDefaultControl(element),
      definition = getDefinition(element),
      update = getUpdate(rule, value);

  !value ? deleteRule() : setRule();

  function deleteRule() {

    var oldValue;

    if (isRulePresent(itemControl, rule)) {
      oldValue = itemControl[rule];
      modeling.updateProperties(itemControl, update, element);
      modeling.updateSemanticParent(oldValue);

      if (canDeletePlanItemControl(itemControl)) {
        modeling.updateProperties(element, { itemControl: undefined });
        modeling.updateSemanticParent(itemControl);
      }
    }

    if (isRulePresent(defaultControl, rule)) {
      oldValue = defaultControl[rule];

      var changed = self._getReferencingShapes(definition);

      if (changed.length > 1 && canReplaceDefinition(definition)) {

        changed = filter(changed, function (elem) {
          var localItemControl = getItemControl(elem),
              localDefaultControl = getDefaultControl(elem);

          return !isRulePresent(localItemControl, rule) && isRulePresent(localDefaultControl, rule);
        });

        if (changed.length > 1) {
          self._replaceDefinition(element);
          defaultControl = getDefaultControl(element);
          changed = element;
        }
      }

      modeling.updateProperties(defaultControl, update, changed);
      modeling.updateSemanticParent(oldValue);

      if (canDeletePlanItemControl(defaultControl)) {
        modeling.updateProperties(definition, { defaultControl: undefined }, changed);
        modeling.updateSemanticParent(defaultControl);
      }
    }
  }

  function setRule() {

    if (!itemControl) {
      itemControl = createPlanItemControl();
      modeling.updateProperties(element, { itemControl: itemControl });
      modeling.updateSemanticParent(itemControl, getBusinessObject(element));
    }

    modeling.updateProperties(itemControl, update, element);
    modeling.updateSemanticParent(value, itemControl);
  }

  function isRulePresent(control, rule) {
    return control && control[rule];
  }

  function createPlanItemControl() {
    return cmmnFactory.create('cmmn:PlanItemControl');
  }

  function canDeletePlanItemControl(control) {
    return !!(control && !control.repetitionRule && !control.requiredRule && !control.manualActivationRule);
  }
};

UpdateControlsHandler.prototype._replaceDefinition = function (element) {

  var self = this,
      modeling = self._modeling,
      cmmnReplace = self._cmmnReplace;

  var definition = getDefinition(element);

  var newDefinition = cmmnReplace.replacePlanItemDefinition(definition);
  modeling.updateProperties(element, { definitionRef: newDefinition });

  modeling.updateSemanticParent(newDefinition, definition.$parent, 'planItemDefinitions');

  return newDefinition;
};

UpdateControlsHandler.prototype._getReferencingShapes = function (definition) {

  var self = this,
      itemRegistry = self._itemRegistry;

  return itemRegistry.getShapes(definition);
};

function canReplaceDefinition(definition) {
  return !(isPlanningTableCapable(definition) && hasPlanningTable(definition));
}

},{"254":254,"46":46,"76":76}],42:[function(_dereq_,module,exports){
'use strict';

var reduce = _dereq_(254).reduce,
    keys = _dereq_(254).keys,
    forEach = _dereq_(254).forEach,
    assign = _dereq_(254).assign;

var getBusinessObject = _dereq_(76).getBusinessObject;

var NAME = 'name',
    STANDARD_EVENT = 'standardEvent',
    ID = 'id',
    DEFINITION_REF = 'definitionRef',
    SENTRY_REF = 'sentryRef',
    IS_STANDARD_EVENT_VISIBLE = 'isStandardEventVisible';

var flatten = _dereq_(254).flatten;

/**
 * A handler that implements a CMMN 1.1 property update.
 *
 * This should be used to set simple properties on elements with
 * an underlying CMMN business object.
 *
 * Use respective diagram-js provided handlers if you would
 * like to perform automated modeling.
 */
function UpdatePropertiesHandler(elementRegistry, itemRegistry, moddle) {
  this._elementRegistry = elementRegistry;
  this._itemRegistry = itemRegistry;
  this._moddle = moddle;
}

UpdatePropertiesHandler.$inject = ['elementRegistry', 'itemRegistry', 'moddle'];

module.exports = UpdatePropertiesHandler;

// api /////////////////

UpdatePropertiesHandler.prototype.preExecute = function (context) {

  var element = context.element,
      shape = context.shape;

  if (!element) {
    throw new Error('element required');
  }

  var bo = element.businessObject || element;

  context.businessObject = bo;

  var changed = [];

  if (element.businessObject) {
    changed.push(element);
  }

  if (shape) {
    changed.push(shape);
  }

  context.changed = flatten(changed);
};

/**
 * Updates a CMMN element with a list of new properties
 *
 * @param {Object} context
 * @param {djs.model.Base} context.element the element to update
 * @param {Object} context.properties a list of properties to set on the element's
 *                                    businessObject (the CMMN model element)
 *
 * @return {Array<djs.mode.Base>} the updated element
 */
UpdatePropertiesHandler.prototype.execute = function (context) {

  var elementRegistry = this._elementRegistry,
      itemRegistry = this._itemRegistry,
      ids = this._moddle.ids;

  var changed = context.changed;

  var element = context.element,
      businessObject = context.businessObject,
      properties = unwrapBusinessObjects(context.properties),
      oldProperties = context.oldProperties || getProperties(businessObject, keys(properties));

  if (isIdChange(properties, businessObject)) {
    ids.unclaim(businessObject[ID]);

    itemRegistry.updateId(businessObject, properties[ID]);

    var shape = elementRegistry.get(element.id);

    if (shape) {
      elementRegistry.updateId(shape, properties[ID]);
    }

    ids.claim(properties[ID], businessObject);
  }

  if (isDefinitionRefChange(properties, businessObject)) {
    itemRegistry.updateReference(businessObject, properties[DEFINITION_REF]);
  }

  if (isSentryRefChange(properties, businessObject)) {
    itemRegistry.updateReference(businessObject, properties[SENTRY_REF]);
  }

  if (NAME in properties) {

    forEach(changed, function (changedShape) {
      if (changedShape.label) {
        changed.push(changedShape.label);
      }
    });
  }

  if (STANDARD_EVENT in properties || IS_STANDARD_EVENT_VISIBLE in properties) {

    forEach(changed, function (changedShape) {
      if (changedShape.label) {
        changed.push(changedShape.label);
      }
    });
  }

  // update properties
  setProperties(businessObject, properties);

  // store old values
  context.oldProperties = oldProperties;

  // indicate changed on objects affected by the update
  return changed;
};

/**
 * Reverts the update on a CMMN elements properties.
 *
 * @param  {Object} context
 *
 * @return {djs.mode.Base} the updated element
 */
UpdatePropertiesHandler.prototype.revert = function (context) {

  var properties = context.properties,
      oldProperties = context.oldProperties,
      businessObject = context.businessObject,
      elementRegistry = this._elementRegistry,
      itemRegistry = this._itemRegistry,
      ids = this._moddle.ids;

  if (isIdChange(oldProperties, businessObject)) {
    itemRegistry.updateId(businessObject, oldProperties[ID]);
  }

  if (isDefinitionRefChange(oldProperties, businessObject)) {
    itemRegistry.updateReference(businessObject, oldProperties[DEFINITION_REF]);
  }

  if (isSentryRefChange(oldProperties, businessObject)) {
    itemRegistry.updateReference(businessObject, oldProperties[SENTRY_REF]);
  }

  // update properties
  setProperties(businessObject, oldProperties);

  if (isIdChange(properties, businessObject)) {
    ids.unclaim(properties[ID]);

    var shape = elementRegistry.get(properties[ID]);

    if (shape) {
      elementRegistry.updateId(shape, oldProperties[ID]);
    }

    ids.claim(oldProperties[ID], businessObject);
  }

  return context.changed;
};

function isIdChange(properties, businessObject) {
  return ID in properties && properties[ID] !== businessObject[ID];
}

function isDefinitionRefChange(properties, businessObject) {
  return DEFINITION_REF in properties && properties[DEFINITION_REF] !== businessObject[DEFINITION_REF];
}

function isSentryRefChange(properties, businessObject) {
  return SENTRY_REF in properties && properties[SENTRY_REF] !== businessObject[SENTRY_REF];
}

function getProperties(businessObject, propertyNames) {
  return reduce(propertyNames, function (result, key) {
    result[key] = businessObject.get(key);
    return result;
  }, {});
}

function setProperties(businessObject, properties) {
  forEach(properties, function (value, key) {
    businessObject.set(key, value);
  });
}

var referencePropertyNames = ['default'];

/**
 * Make sure we unwrap the actual business object
 * behind diagram element that may have been
 * passed as arguments.
 *
 * @param  {Object} properties
 *
 * @return {Object} unwrappedProps
 */
function unwrapBusinessObjects(properties) {

  var unwrappedProps = assign({}, properties);

  referencePropertyNames.forEach(function (name) {
    if (name in properties) {
      unwrappedProps[name] = getBusinessObject(unwrappedProps[name]);
    }
  });

  return unwrappedProps;
}

},{"254":254,"76":76}],43:[function(_dereq_,module,exports){
'use strict';

var flatten = _dereq_(254).flatten;

var Collections = _dereq_(233);

function UpdateSemanticParentHandler() {}

module.exports = UpdateSemanticParentHandler;

// api /////////////////

UpdateSemanticParentHandler.prototype.preExecute = function (context) {
  var element = context.element,
      shape = context.shape;

  if (!element) {
    throw new Error('element required');
  }

  var bo = element.businessObject || element;

  context.businessObject = bo;
  context.oldParent = bo.$parent;

  var changed = [];

  if (element.businessObject) {
    changed.push(element);
  }

  if (shape) {
    changed.push(shape);
  }

  context.changed = flatten(changed);
};

UpdateSemanticParentHandler.prototype.execute = function (context) {

  var businessObject = context.businessObject,
      newParent = context.newParent,
      containment = context.containment;

  this.updateSemanticParent(businessObject, newParent, containment);

  // indicate changed on objects affected by the update
  return context.changed;
};

UpdateSemanticParentHandler.prototype.revert = function (context) {

  var businessObject = context.businessObject,
      newParent = context.oldParent,
      containment = context.containment;

  this.updateSemanticParent(businessObject, newParent, containment);

  return context.changed;
};

UpdateSemanticParentHandler.prototype.updateSemanticParent = function (element, newParent, containment) {

  if (element.$parent === newParent) {
    return;
  }

  var children;

  if (element.$parent && containment) {
    // remove from old parent
    children = element.$parent.get(containment);
    Collections.remove(children, element);
  }

  element.$parent = null;

  if (newParent) {

    if (containment) {
      // add to new parent
      children = newParent.get(containment);
      children.push(element);
    }

    element.$parent = newParent;
  }
};

},{"233":233,"254":254}],44:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: ['modeling', 'cmmnUpdater'],
  __depends__: [_dereq_(36), _dereq_(48), _dereq_(59), _dereq_(61), _dereq_(93).default, _dereq_(206).default, _dereq_(147).default, _dereq_(105).default, _dereq_(119).default],
  cmmnFactory: ['type', _dereq_(21)],
  cmmnUpdater: ['type', _dereq_(23)],
  elementFactory: ['type', _dereq_(24)],
  modeling: ['type', _dereq_(25)],
  layouter: ['type', _dereq_(22)],
  connectionDocking: ['type', _dereq_(220).default]
};

},{"105":105,"119":119,"147":147,"206":206,"21":21,"22":22,"220":220,"23":23,"24":24,"25":25,"36":36,"48":48,"59":59,"61":61,"93":93}],45:[function(_dereq_,module,exports){
'use strict';

var some = _dereq_(254).some;

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    getBusinessObject = ModelUtil.getBusinessObject;

var Model = _dereq_(223);

/**
 * Return true if given elements are the same.
 *
 * @param {Object} a
 * @param {Object} b
 *
 * @return {boolean}
 */
function isSame(a, b) {
  return a === b;
}

module.exports.isSame = isSame;

/**
 * Return true if given cases are the same.
 *
 * @param {ModdleElement} a
 * @param {ModdleElement} b
 *
 * @return {boolean}
 */
function isSameCase(a, b) {
  return isSame(getCase(a), getCase(b));
}

module.exports.isSameCase = isSameCase;

function getCase(element) {
  return getParent(getBusinessObject(element), 'cmmn:Case');
}

module.exports.getCase = getCase;

/**
 * Return the parents of the element with any of the given types.
 *
 * @param {ModdleElement} element
 * @param {String|Array<String>} anyType
 *
 * @return {Array<ModdleElement>}
 */
function getParents(element, anyType) {

  var parents = [];

  if (typeof anyType === 'string') {
    anyType = [anyType];
  }

  while (element) {
    element = element.$parent || element.parent;

    if (element) {

      if (anyType) {
        if (isAny(element, anyType)) {
          parents.push(element);
        }
      } else {
        parents.push(element);
      }
    }
  }

  return parents;
}

module.exports.getParents = getParents;

/**
 * Return the parent of the element with any of the given types.
 *
 * @param {ModdleElement} element
 * @param {String|Array<String>} anyType
 *
 * @return {ModdleElement}
 */
function getParent(element, anyType) {

  if (typeof anyType === 'string') {
    anyType = [anyType];
  }

  while (element = element.$parent || element.parent) {
    if (anyType) {
      if (isAny(element, anyType)) {
        return element;
      }
    } else {
      return element;
    }
  }

  return null;
}

module.exports.getParent = getParent;

/**
 * Return true if element has any of the given types.
 *
 * @param {djs.model.Base} element
 * @param {Array<String>} types
 *
 * @return {Boolean}
 */
function isAny(element, types) {
  return some(types, function (t) {
    return is(element, t);
  });
}

module.exports.isAny = isAny;

function isLabel(element) {
  return element instanceof Model.Label;
}

module.exports.isLabel = isLabel;

},{"223":223,"254":254,"76":76}],46:[function(_dereq_,module,exports){
'use strict';

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject;

var isAny = _dereq_(45).isAny,
    getParent = _dereq_(45).getParent;

var eachElement = _dereq_(235).eachElement;

/**
 * Returns all contained discretionary items.
 *
 * @param {ModdleElement} element
 *
 * @return {Array<ModdleElement>} all discretionary items
 */
function getAllDiscretionaryItems(element) {

  element = getBusinessObject(element);

  if (isItemCapable(element)) {
    element = getDefinition(element);
  }

  var result = [];

  if (isPlanningTableCapable(element)) {
    element = element.planningTable;

    if (element) {

      var items = element.get('tableItems');
      eachElement(items, function (item) {
        if (isDiscretionaryItem(item)) {
          result.push(item);
        } else {
          return item.get('tableItems');
        }
      });
    }
  }

  return result;
}

module.exports.getAllDiscretionaryItems = getAllDiscretionaryItems;

/**
 * Returns all directed item capables elements of the given element.
 *
 * @param {ModdleElement} element
 *
 * @return {Array<ModdleElement>} all direct item capables
 */
function getDirectItemCapables(element) {

  element = getBusinessObject(element);

  if (isItemCapable(element)) {
    element = getDefinition(element);
  }

  var result = [];

  function add(item) {
    result.push(item);
  }

  if (element) {

    var items;

    if (is(element, 'cmmn:PlanFragment')) {
      items = element.get('planItems');
      eachElement(items, add);
    }

    if (isPlanningTableCapable(element)) {
      items = getAllDiscretionaryItems(element);
      eachElement(items, add);
    }
  }

  return result;
}

module.exports.getDirectItemCapables = getDirectItemCapables;

/**
 * Returns true if the given element is either a discretionary item
 * or a plan item
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is a discretionary item or a plan item
 */
function isItemCapable(element) {
  return isAny(element, ['cmmn:DiscretionaryItem', 'cmmn:PlanItem']);
}

module.exports.isItemCapable = isItemCapable;

/**
 * Returns true if the given element is either a human task or
 * a stage.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is a human task or stage
 */
function isPlanningTableCapable(element) {
  return isAny(element, ['cmmn:HumanTask', 'cmmn:Stage']);
}

module.exports.isPlanningTableCapable = isPlanningTableCapable;

/**
 * Returns true if the given element is a discretionary item.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is a discretionary item
 */
function isDiscretionaryItem(element) {
  return is(element, 'cmmn:DiscretionaryItem');
}

module.exports.isDiscretionaryItem = isDiscretionaryItem;

/**
 * Returns true if the given element is a discretionary to a human task.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is discretionary to a human task
 */
function isDiscretionaryToHumanTask(element) {
  var bo = getBusinessObject(element);
  var parent = getParent(bo, 'cmmn:PlanItemDefinition');
  return is(parent, 'cmmn:HumanTask');
}

module.exports.isDiscretionaryToHumanTask = isDiscretionaryToHumanTask;

/**
 * Returns true if the given element is a human task.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is a human task
 */
function isHumanTask(element) {
  return is(element, 'cmmn:HumanTask');
}

module.exports.isHumanTask = isHumanTask;

/**
 * Returns true if the given element is a plan fragment and not
 * a stage.
 *
 * @param {djs.model.Base} element
 *
 * @return {boolean} when it is a plan fragment
 */
function isPlanFragment(element) {
  return is(element, 'cmmn:PlanFragment') && !is(element, 'cmmn:Stage');
}

module.exports.isPlanFragment = isPlanFragment;

},{"235":235,"45":45,"76":76}],47:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var OrderingProvider = _dereq_(180).default;
var findIndex = _dereq_(254).findIndex;
var find = _dereq_(254).find;
var is = _dereq_(76).is;
var isAny = _dereq_(45).isAny;

function CmmnOrderingProvider(eventBus) {

  OrderingProvider.call(this, eventBus);

  var orders = [{ type: 'label', order: { level: 10 } }, { type: 'cmmn:Criterion', order: { level: 6 } }, {
    type: 'cmmn:OnPart',
    order: {
      level: 9,
      containers: ['cmmn:Stage']
    }
  }, {
    type: 'cmmn:Association',
    order: {
      level: 9,
      containers: ['cmmndi:CMMNDiagram']
    }
  }, {
    type: 'cmmndi:CMMNEdge',
    order: {
      level: 9,
      containers: ['cmmn:PlanItem', 'cmmn:DiscretionaryItem', 'cmmn:Stage']
    }
  }];

  function computeOrder(element) {

    if (isCMMNEdge(element)) {
      element = element.businessObject.cmmnElementRef || element;
    }

    var entry = find(orders, function (o) {
      return is(element, o.type);
    });

    return entry && entry.order || { level: 1 };
  }

  function getOrder(element) {

    var order = element.order;

    if (!order) {
      element.order = order = computeOrder(element);
    }

    return order;
  }

  function findActualParent(element, newParent, containers) {

    var actualParent = newParent;

    if (isCMMNEdge(element) && element.source) {
      actualParent = element.source.parent;
    }

    while (actualParent) {

      if (isAny(actualParent, containers)) {
        break;
      }

      actualParent = actualParent.parent;
    }

    if (!actualParent) {
      throw new Error('no parent for ' + element.id + ' in ' + newParent.id);
    }

    return actualParent;
  }

  this.getOrdering = function (element, newParent) {

    var elementOrder = getOrder(element);

    if (elementOrder.containers) {
      newParent = findActualParent(element, newParent, elementOrder.containers);
    }

    var currentIndex = newParent.children.indexOf(element);

    var insertIndex = findIndex(newParent.children, function (child) {

      // do not compare with labels, they are created
      // in the wrong order (right after elements) during import and
      // mess up the positioning.
      if (!element.labelTarget && child.labelTarget) {
        return false;
      }

      return elementOrder.level < getOrder(child).level;
    });

    // if the element is already in the child list at
    // a smaller index, we need to adjust the insert index.
    // this takes into account that the element is being removed
    // before being re-inserted
    if (insertIndex !== -1) {
      if (currentIndex !== -1 && currentIndex < insertIndex) {
        insertIndex -= 1;
      }
    }

    return {
      index: insertIndex,
      parent: newParent
    };
  };
}

CmmnOrderingProvider.$inject = ['eventBus'];

inherits(CmmnOrderingProvider, OrderingProvider);

module.exports = CmmnOrderingProvider;

function isCMMNEdge(element) {
  return is(element, 'cmmndi:CMMNEdge');
}

},{"180":180,"253":253,"254":254,"45":45,"76":76}],48:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: ['cmmnOrderingProvider'],
  cmmnOrderingProvider: ['type', _dereq_(47)]
};

},{"47":47}],49:[function(_dereq_,module,exports){
'use strict';

var BaseOutline = _dereq_(181).default;

var inherits = _dereq_(253);

var isCasePlanModel = _dereq_(76).isCasePlanModel;

var svgAttr = _dereq_(275).attr;

/**
 * This is a subclass of the Outline module from diagram-js.
 * It defines outlines which differ from the element size basis.
 *
 * @param {EventBus} eventBus
 * @param {Styles} styles
 * @param {ElementRegistry} elementRegistry
 */
function Outline(eventBus, styles, elementRegistry) {
  BaseOutline.call(this, eventBus, styles, elementRegistry);
}

inherits(Outline, BaseOutline);

Outline.$inject = ['eventBus', 'styles', 'elementRegistry'];

Outline.prototype.baseUpdateShapeOutline = BaseOutline.prototype.updateShapeOutline;

Outline.prototype.updateShapeOutline = function (outline, element) {

  if (!isCasePlanModel(element)) {

    this.baseUpdateShapeOutline(outline, element);
  } else {

    // update outlines for casePlanModels
    svgAttr(outline, {
      x: -this.offset,
      y: -this.offset - 18,
      width: element.width + this.offset * 2,
      height: element.height + 18 + this.offset * 2
    });
  }
};

module.exports = Outline;

},{"181":181,"253":253,"275":275,"76":76}],50:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: ['outline'],
  outline: ['type', _dereq_(49)]
};

},{"49":49}],51:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(254).assign;

/**
 * A palette provider for CMMN 1.1 elements.
 */
function PaletteProvider(create, elementFactory, globalConnect, handTool, lassoTool, palette, spaceTool) {

  this._create = create;
  this._elementFactory = elementFactory;
  this._globalConnect = globalConnect;
  this._handTool = handTool;
  this._palette = palette;
  this._lassoTool = lassoTool;
  this._spaceTool = spaceTool;

  palette.registerProvider(this);
}

module.exports = PaletteProvider;

PaletteProvider.$inject = ['create', 'elementFactory', 'globalConnect', 'handTool', 'lassoTool', 'palette', 'spaceTool'];

PaletteProvider.prototype.getPaletteEntries = function (element) {

  var actions = {},
      create = this._create,
      elementFactory = this._elementFactory,
      spaceTool = this._spaceTool,
      lassoTool = this._lassoTool,
      globalConnect = this._globalConnect,
      handTool = this._handTool;

  function createPlanItem(type, group, className, title) {

    function createListener(event) {
      create.start(event, elementFactory.createPlanItemShape(type));
    }

    var shortType = type.replace(/^cmmn:/, '');

    return {
      group: group,
      className: className,
      title: title || 'Create ' + shortType,
      action: {
        dragstart: createListener,
        click: createListener
      }
    };
  }

  function createCasePlanModel(event) {
    create.start(event, elementFactory.createCasePlanModelShape());
  }

  function createCriterion(event) {
    create.start(event, elementFactory.createCriterionShape('cmmn:EntryCriterion'));
  }

  function createCaseFileItem(event) {
    create.start(event, elementFactory.createCaseFileItemShape());
  }

  assign(actions, {
    'hand-tool': {
      group: 'tools',
      className: 'cmmn-icon-hand-tool',
      title: 'Activate the hand tool',
      action: {
        click: function click(event) {
          handTool.activateHand(event);
        }
      }
    },
    'lasso-tool': {
      group: 'tools',
      className: 'cmmn-icon-lasso-tool',
      title: 'Activate the lasso tool',
      action: {
        click: function click(event) {
          lassoTool.activateSelection(event);
        }
      }
    },
    'space-tool': {
      group: 'tools',
      className: 'cmmn-icon-space-tool',
      title: 'Activate the create/remove space tool',
      action: {
        click: function click(event) {
          spaceTool.activateSelection(event);
        }
      }
    },
    'global-connect-tool': {
      group: 'tools',
      className: 'cmmn-icon-connection',
      title: 'Activate the global connect tool',
      action: {
        click: function click(event) {
          globalConnect.toggle(event);
        }
      }
    },
    'tool-separator': {
      group: 'tools',
      separator: true
    },
    'create.task': createPlanItem('cmmn:Task', 'planItem', 'cmmn-icon-task'),
    'create.stage': createPlanItem('cmmn:Stage', 'planItem', 'cmmn-icon-stage-expanded', 'Create expanded Stage'),
    'create.milestone': createPlanItem('cmmn:Milestone', 'planItem', 'cmmn-icon-milestone'),
    'create.eventListener': createPlanItem('cmmn:EventListener', 'planItem', 'cmmn-icon-event-listener'),
    'create.criterion': {
      group: 'criterion',
      className: 'cmmn-icon-entry-criterion',
      title: 'Create Criterion',
      action: {
        dragstart: createCriterion,
        click: createCriterion
      }
    },
    'create.casePlanModel': {
      group: 'casePlanModel',
      className: 'cmmn-icon-case-plan-model',
      title: 'Create CasePlanModel',
      action: {
        dragstart: createCasePlanModel,
        click: createCasePlanModel
      }
    },
    'create.caseFileItem': {
      group: 'caseFileItem',
      className: 'cmmn-icon-case-file-item',
      title: 'Create Case File Item',
      action: {
        dragstart: createCaseFileItem,
        click: createCaseFileItem
      }
    }

  });

  return actions;
};

},{"254":254}],52:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [_dereq_(186).default, _dereq_(128).default, _dereq_(216).default, _dereq_(149).default, _dereq_(137).default, _dereq_(135).default],
  __init__: ['paletteProvider'],
  paletteProvider: ['type', _dereq_(51)]
};

},{"128":128,"135":135,"137":137,"149":149,"186":186,"216":216,"51":51}],53:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(254).forEach,
    filter = _dereq_(254).filter;

var replaceOptions = _dereq_(58);

var isItemCapable = _dereq_(46).isItemCapable;

var isAny = _dereq_(45).isAny;

var ModelUtil = _dereq_(76),
    getBusinessObject = ModelUtil.getBusinessObject,
    getDefinition = ModelUtil.getDefinition,
    isCasePlanModel = ModelUtil.isCasePlanModel,
    isRequired = ModelUtil.isRequired,
    isRepeatable = ModelUtil.isRepeatable,
    isManualActivation = ModelUtil.isManualActivation,
    is = ModelUtil.is;

var isCollapsed = _dereq_(74).isCollapsed;

/**
 * Returns true, if an element is from a different type.
 * discretionary / non discretionary
 *
 * @param {djs.model.Base} element
 * @param {Object} entry
 *
 * @return {Boolean}
 */
function isDifferentType(element, entry) {

  var businessObject = getBusinessObject(element);

  return businessObject.$type !== entry.target.type;
}

/**
 * Returns true if the definition type is different.
 * e.g. process task / human task
 *
 * @param {djs.model.Base} element
 * @param {Object} entry
 *
 * @return {Boolean}
 */
function isDifferentDefinitionType(element, entry) {

  return getDefinition(element).$type !== entry.target.definitionType;
}

function canReplaceElementByTarget(element, target) {

  var type = target.type,
      definitionType = target.definitionType,
      parent = element.parent,
      definition = getDefinition(element);

  if (isPlanItem(element)) {
    if (type === 'cmmn:DiscretionaryItem' && !isStage(parent)) {
      return false;
    }
  }

  if (definitionType === 'cmmn:HumanTask') {

    if (isPlanFragment(element) && !target.isBlocking) {
      return false;
    }

    if (isTask(element) && definition.isBlocking !== target.isBlocking) {
      return false;
    }
  }

  return true;
}

/**
 * This module is an element agnostic replace menu provider for the popup menu.
 */
function ReplaceMenuProvider(popupMenu, cmmnReplace, cmmnFactory, modeling, rules) {

  this._popupMenu = popupMenu;
  this._cmmnReplace = cmmnReplace;
  this._cmmnFactory = cmmnFactory;
  this._modeling = modeling;
  this._rules = rules;

  this.register();
}

ReplaceMenuProvider.$inject = ['popupMenu', 'cmmnReplace', 'cmmnFactory', 'modeling', 'rules'];

/**
 * Register replace menu provider in the popup menu
 */
ReplaceMenuProvider.prototype.register = function () {
  this._popupMenu.registerProvider('cmmn-replace', this);
};

/**
 * Get all entries from replaceOptions for the given element and apply filters
 * on them. Get for example only elements, which are different from the current one.
 *
 * @param {djs.model.Base} element
 *
 * @return {Array<Object>} a list of menu entry items
 */
ReplaceMenuProvider.prototype.getEntries = function (element) {

  var rules = this._rules;

  var entries,
      definition = getDefinition(element);

  if (!rules.allowed('shape.replace', { element: element })) {
    return [];
  }

  if (isItemCapable(element)) {

    if (isTask(element)) {

      entries = filter(replaceOptions.TASK, function (entry) {

        var target = entry.target;

        if (canReplaceElementByTarget(element, target)) {

          // ^ === XOR
          // returns true if and only of EITHER the type OR the definition type is different
          return isDifferentType(element, entry) ^ isDifferentDefinitionType(element, entry);
        }
      });

      return this._createEntries(element, entries);
    }

    if (isPlanFragment(element)) {

      if (!isCollapsed(element)) {

        entries = filter(replaceOptions.PLAN_FRAGMENT_EXPANDED, function (entry) {

          var target = entry.target;

          if (canReplaceElementByTarget(element, target)) {

            // returns true if the type or the definition type is different (or both)
            return isDifferentType(element, entry) || isDifferentDefinitionType(element, entry);
          }
        });

        return this._createEntries(element, entries);
      }

      if (isCollapsed(element)) {

        entries = filter(replaceOptions.TASK, function (entry) {

          var target = entry.target,
              definitionType = target.definitionType;

          if (!canReplaceElementByTarget(element, target)) {
            return false;
          }

          if (definitionType === definition.$type && !target.isCollapsed) {
            return true;
          }

          // ^ === XOR
          // returns true if and only of EITHER the type OR the definition type is different
          return isDifferentType(element, entry) ^ isDifferentDefinitionType(element, entry);
        });

        return this._createEntries(element, entries);
      }
    }

    if (isEventListener(element)) {

      entries = filter(replaceOptions.EVENT_LISTENER, function (entry) {
        return isDifferentDefinitionType(element, entry);
      });

      return this._createEntries(element, entries);
    }
  }

  if (isCriterion(element)) {

    entries = filter(replaceOptions.CRITERION, function (entry) {
      return isDifferentType(element, entry);
    });

    return this._createEntries(element, entries);
  }

  return [];
};

ReplaceMenuProvider.prototype.getHeaderEntries = function (element) {

  var headerEntries = [];

  if (isTask(element)) {
    headerEntries = headerEntries.concat(this._getBlockingEntry(element));
  }

  if (isStage(element)) {
    headerEntries = headerEntries.concat(this._getAutoCompleteEntry(element));
  }

  if (ensureSupportRules(element)) {
    headerEntries = headerEntries.concat(this._getRuleEntries(element));
  }

  return headerEntries;
};

/**
 * Creates an array of menu entry objects for a given element and filters the replaceOptions
 * according to a filter function.
 *
 * @param  {djs.model.Base} element
 * @param  {Object} replaceOptions
 *
 * @return {Array<Object>} a list of menu items
 */
ReplaceMenuProvider.prototype._createEntries = function (element, replaceOptions) {
  var menuEntries = [];

  var self = this;

  forEach(replaceOptions, function (definition) {
    var entry = self._createMenuEntry(definition, element);

    menuEntries.push(entry);
  });

  return menuEntries;
};

/**
 * Creates and returns a single menu entry item.
 *
 * @param  {Object} definition a single replace options definition object
 * @param  {djs.model.Base} element
 * @param  {Function} [action] an action callback function which gets called when
 *                             the menu entry is being triggered.
 *
 * @return {Object} menu entry item
 */
ReplaceMenuProvider.prototype._createMenuEntry = function (definition, element, action) {

  var replaceElement = this._cmmnReplace.replaceElement;

  var replaceAction = function replaceAction() {
    return replaceElement(element, definition.target);
  };

  action = action || replaceAction;

  var menuEntry = {
    label: definition.label,
    className: definition.className,
    id: definition.actionName,
    action: action
  };

  return menuEntry;
};

ReplaceMenuProvider.prototype._getBlockingEntry = function (element) {

  var self = this;

  var definition = getDefinition(element);

  function toggleBlockingEntry(event, entry) {
    var blocking = !entry.active;
    self._modeling.updateControls(element, { isBlocking: blocking });
  }

  var isBlocking = definition.isBlocking;
  var entries = [{
    id: 'toggle-is-blocking',
    className: 'cmmn-icon-blocking',
    title: 'Blocking',
    active: isBlocking,
    action: toggleBlockingEntry
  }];

  return entries;
};

ReplaceMenuProvider.prototype._getAutoCompleteEntry = function (element) {

  var self = this;

  var definition = getDefinition(element);

  function toggleAutoCompleteEntry(event, entry) {
    var autoComplete = !entry.active;
    self._modeling.updateControls(element, { autoComplete: autoComplete });
  }

  var isAutoComplete = definition.autoComplete;
  var entries = [{
    id: 'toggle-auto-complete',
    className: 'cmmn-icon-auto-complete-marker',
    title: 'Auto Complete',
    active: isAutoComplete,
    action: toggleAutoCompleteEntry
  }];

  return entries;
};

ReplaceMenuProvider.prototype._getRuleEntries = function (element) {

  var self = this;

  function toggleControlEntry(control, type) {

    return function (event, entry) {

      var value = {};

      if (entry.active) {
        value[control] = undefined;
      } else {
        value[control] = self._cmmnFactory.create(type);
      }

      self._modeling.updateControls(element, value);
    };
  }

  var repeatable = isRepeatable(element),
      required = isRequired(element),
      manualActivation = isManualActivation(element);

  var entries = [{
    id: 'toggle-required-rule',
    className: 'cmmn-icon-required-marker',
    title: 'Required Rule',
    active: required,
    action: toggleControlEntry('requiredRule', 'cmmn:RequiredRule')
  }];

  if (!isMilestone(element)) {

    entries.push({
      id: 'toggle-manual-activation-rule',
      className: 'cmmn-icon-manual-activation-marker',
      title: 'Manual Activation Rule',
      active: manualActivation,
      action: toggleControlEntry('manualActivationRule', 'cmmn:ManualActivationRule')
    });
  }

  entries.push({
    id: 'toggle-repetition-rule',
    className: 'cmmn-icon-repetition-marker',
    title: 'Repetition Rule',
    active: repeatable,
    action: toggleControlEntry('repetitionRule', 'cmmn:RepetitionRule')
  });

  return entries;
};

module.exports = ReplaceMenuProvider;

function ensureSupportRules(element) {

  var definition = getDefinition(element);

  return !isCasePlanModel(element) && isAny(definition, ['cmmn:Stage', 'cmmn:Milestone', 'cmmn:Task']);
}

function isPlanFragment(element) {
  return is(getDefinition(element), 'cmmn:PlanFragment');
}

function isStage(element) {
  return is(getDefinition(element), 'cmmn:Stage');
}

function isEventListener(element) {
  return is(getDefinition(element), 'cmmn:EventListener');
}

function isMilestone(element) {
  return is(getDefinition(element), 'cmmn:Milestone');
}

function isTask(element) {
  return is(getDefinition(element), 'cmmn:Task');
}

function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

function isPlanItem(element) {
  return is(element, 'cmmn:PlanItem');
}

},{"254":254,"45":45,"46":46,"58":58,"74":74,"76":76}],54:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __init__: ['replaceMenuProvider'],
  replaceMenuProvider: ['type', _dereq_(53)]
};

},{"53":53}],55:[function(_dereq_,module,exports){
'use strict';

var CommandInterceptor = _dereq_(91).default;

var cssEscape = _dereq_(85);

var inherits = _dereq_(253);

var assign = _dereq_(254).assign,
    forEach = _dereq_(254).forEach;

var getVisual = _dereq_(239).getVisual;

var isItemCapable = _dereq_(46).isItemCapable;

var ModelUtil = _dereq_(76),
    getBusinessObject = ModelUtil.getBusinessObject,
    getDefinition = ModelUtil.getDefinition;

var domQuery = _dereq_(255).query;

var svgAppend = _dereq_(275).append,
    svgClasses = _dereq_(275).classes,
    svgCreate = _dereq_(275).create,
    svgRemove = _dereq_(275).remove;

var LOW_PRIORITY = 250;

function CmmnReplacePreview(cmmnReplace, cmmnRules, elementFactory, elementRegistry, eventBus, graphicsFactory) {

  CommandInterceptor.call(this, eventBus);

  function createShape(element, replacement) {

    var newElement = {
      type: replacement.newElementType,
      x: element.x,
      y: element.y,
      width: element.width,
      height: element.height
    };

    if (isItemCapable(element)) {

      var bo = getBusinessObject(element),
          definition = getDefinition(element),
          newElementType = replacement.newElementType,
          newDefinitionType = replacement.newDefinitionType,
          replaceCandidate;

      if (newDefinitionType) {
        definition = cmmnReplace.replacePlanItemDefinition(definition, newDefinitionType);
      }

      replaceCandidate = cmmnReplace.replaceItemCapable(bo, newElementType, definition);

      assign(newElement, {
        businessObject: replaceCandidate
      });
    }

    return elementFactory.createShape(newElement);
  }

  function initVisualReplacements(context) {
    if (!context.visualReplacements) {
      context.visualReplacements = {};
    }
    return context.visualReplacements;
  }

  function canReplace(event) {
    var context = event.context,
        canExecute = context.canExecute || context.allowed;

    if (canExecute === 'attach') {
      var position = context.position || { x: event.x, y: event.y },
          shapes = context.shapes || [context.shape],
          target = context.target;

      canExecute = cmmnRules.canReplace(shapes, target, position, context.source);
    }

    return canExecute;
  }

  /**
   * Replace the visuals to the given shape
   */
  function replaceVisualGraphics(gfx, shape) {

    var visual = gfx && getVisual(gfx);

    if (visual) {
      svgRemove(visual);

      visual = svgCreate('g');
      svgClasses(visual).add('djs-visual');

      svgAppend(gfx, visual);

      graphicsFactory.drawShape(visual, shape);
    }
  }

  function replaceVisual(context, replacements, gfxSelector) {

    forEach(replacements, function (replacement) {

      var id = replacement.oldElementId,
          shape = elementRegistry.get(id) || context.shape;

      // if the visual of the element is already replaced
      if (context.visualReplacements[id]) {
        return;
      }

      // create a temporary shape
      var tempShape = createShape(shape, replacement);

      // select the original SVG element related to the element and hide it
      var gfx = gfxSelector(shape);

      replaceVisualGraphics(gfx, tempShape);
      context.visualReplacements[id] = shape;
    });
  }

  function restoreVisual(context, gfxSelector) {

    var visualReplacements = context.visualReplacements;

    forEach(visualReplacements, function (shape, id) {

      var gfx = gfxSelector(shape);
      replaceVisualGraphics(gfx, shape);

      delete visualReplacements[id];
    });
  }

  eventBus.on(['shape.move.move', 'create.move'], LOW_PRIORITY, function (event) {

    var context = event.context,
        dragGroup = context.dragGroup,
        visual = context.visual,
        canExecute = canReplace(event),
        replacements = canExecute && canExecute.replacements;

    initVisualReplacements(context);

    var getGfx = function getGfx(shape) {
      var selector, gfx;

      if (dragGroup) {
        selector = '[data-element-id="' + cssEscape(shape.id) + '"]';
        gfx = dragGroup;
      } else if (visual) {
        selector = '.djs-dragger';
        gfx = visual;
      }

      return gfx && domQuery(selector, gfx);
    };

    if (replacements && replacements.length) {
      replaceVisual(context, replacements, getGfx);
    } else {
      restoreVisual(context, getGfx);
    }
  });

  eventBus.on(['bendpoint.move.move', 'connect.move'], LOW_PRIORITY, function (event) {

    var context = event.context,
        canExecute = canReplace(event),
        replacements = canExecute && canExecute.replacements;

    initVisualReplacements(context);

    if (replacements && replacements.length) {
      replaceVisual(context, replacements, function (shape) {
        return elementRegistry.getGraphics(shape);
      });
    }
  });

  eventBus.on(['bendpoint.move.cancel', 'bendpoint.move.cleanup', 'bendpoint.move.end', 'bendpoint.move.out', 'connect.cleanup', 'connect.end', 'connect.out'], LOW_PRIORITY, function (event) {

    var context = event.context;

    restoreVisual(context, function (shape) {
      return elementRegistry.getGraphics(shape);
    });
  });
}

CmmnReplacePreview.$inject = ['cmmnReplace', 'cmmnRules', 'elementFactory', 'elementRegistry', 'eventBus', 'graphicsFactory'];

inherits(CmmnReplacePreview, CommandInterceptor);

module.exports = CmmnReplacePreview;

},{"239":239,"253":253,"254":254,"255":255,"275":275,"46":46,"76":76,"85":85,"91":91}],56:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [_dereq_(179).default],
  __init__: ['cmmnReplacePreview'],
  cmmnReplacePreview: ['type', _dereq_(55)]
};

},{"179":179,"55":55}],57:[function(_dereq_,module,exports){
'use strict';

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition,
    isAutoComplete = ModelUtil.isAutoComplete;

var isCollapsed = _dereq_(74).isCollapsed,
    isPlanningTableCollapsed = _dereq_(74).isPlanningTableCollapsed;

var isPlanningTableCapable = _dereq_(46).isPlanningTableCapable;
var isItemCapable = _dereq_(46).isItemCapable;

/**
 * This module takes care of replacing CMMN elements
 */
function CmmnReplace(cmmnFactory, replace, selection, cmmnRules) {

  /**
   * Prepares a new business object for the replacement element
   * and triggers the replace operation.
   *
   * @param  {djs.model.Base} element
   * @param  {Object} target
   * @param  {Object} [hints]
   *
   * @return {djs.model.Base} the newly created element
   */
  function replaceElement(element, target, hints) {

    hints = hints || {};

    var type = target.type,
        oldBusinessObject = element.businessObject,
        newBusinessObject;

    // TODO: need also to respect min/max Size
    var newElement = {
      type: type
    };

    if (isCriterion(oldBusinessObject)) {
      newBusinessObject = replaceCriterion(oldBusinessObject, type);
    }

    if (isItemCapable(oldBusinessObject)) {

      var oldDefinition = getDefinition(oldBusinessObject),
          definitionType = target.definitionType,
          newDefinition = oldDefinition;

      // replace plan item definition if necessary
      if (oldDefinition.$type !== definitionType) {
        newDefinition = replacePlanItemDefinition(oldDefinition, definitionType);
      }

      // replace plan/discretionary item
      newBusinessObject = replaceItemCapable(oldBusinessObject, type, newDefinition);

      // handle isCollapsed property
      if (isPlanFragment(oldDefinition) && isPlanFragment(newDefinition) && target.isCollapsed !== false) {
        newElement.isCollapsed = isCollapsed(oldBusinessObject);
      }

      // switch collapsed/expanded plan fragment
      if (isTask(oldDefinition) && target.isCollapsed === true) {
        newElement.isCollapsed = true;
      }

      if (isTask(newDefinition) && target.isBlocking === false) {
        newElement.isBlocking = false;
      }

      // handle isPlanningTableCollapsed property
      if (isPlanningTableCapable(oldDefinition) && isPlanningTableCapable(newDefinition)) {
        newElement.isPlanningTableCollapsed = isPlanningTableCollapsed(oldBusinessObject);
      }

      // handle autoComplete property
      if (isStage(oldDefinition) && isStage(newDefinition)) {
        newElement.autoComplete = isAutoComplete(oldBusinessObject);
      }

      // TODO: need also to respect min/max Size
      // copy size, from an expanded plan fragment to an expanded alternative plan fragment
      // except cmmn:Task, because Task is always expanded
      if (!isCollapsed(oldBusinessObject) && !target.isCollapsed && !isTask(oldDefinition)) {
        newElement.width = element.width;
        newElement.height = element.height;
      }
    }

    // create new business object if necessary
    newElement.businessObject = newBusinessObject || cmmnFactory.create(type);

    // trigger replacement
    newElement = replace.replaceElement(element, newElement, hints);

    if (hints.select !== false) {
      selection.select(newElement);
    }

    return newElement;
  }

  this.replaceElement = replaceElement;

  function replaceCriterion(criterion, type) {

    var newCriterion;

    if (criterion) {

      type = type || criterion.$type;

      newCriterion = cmmnFactory.createCriterion(type, {
        sentryRef: criterion.sentryRef,
        name: criterion.name
      });
    }

    return newCriterion;
  }

  this.replaceCriterion = replaceCriterion;

  function replaceSentry(sentry) {

    var newSentry;

    if (sentry) {

      newSentry = cmmnFactory.createSentry({
        name: sentry.name
      });

      if (sentry.ifPart) {

        var newIfPart = cmmnFactory.create('cmmn:IfPart');
        setParent(newIfPart, newSentry);
        newSentry.ifPart = newIfPart;

        var condition = replaceCondition(sentry.ifPart.condition);
        setParent(condition, newIfPart);
        newIfPart.condition = condition;
      }
    }

    return newSentry;
  }

  this.replaceSentry = replaceSentry;

  function replacePlanItemDefinition(definition, type) {

    type = type || definition.$type;

    var newDefinition = cmmnFactory.create(type, {
      name: definition.name
    });

    if (isPlanItemControlCapable(newDefinition) && definition.defaultControl) {

      var defaultControl = replacePlanItemControl(definition.defaultControl, newDefinition);

      setParent(defaultControl, newDefinition);
      newDefinition.defaultControl = defaultControl;
    }

    if (isStage(newDefinition) && definition.autoComplete) {
      newDefinition.autoComplete = definition.autoComplete;
    }

    if (isTask(definition) && isTask(newDefinition)) {
      newDefinition.isBlocking = definition.isBlocking;
    }

    return newDefinition;
  }

  this.replacePlanItemDefinition = replacePlanItemDefinition;

  function replaceItemCapable(item, type, definition) {

    type = type || item.$type;
    definition = definition || getDefinition(item);

    var newItem = cmmnFactory.create(type, {
      name: item.name,
      definitionRef: definition
    });

    if (isPlanItemControlCapable(newItem) && item.itemControl) {

      var itemControl = replacePlanItemControl(item.itemControl, newItem);

      setParent(itemControl, newItem);
      newItem.itemControl = itemControl;
    }

    return newItem;
  }

  this.replaceItemCapable = replaceItemCapable;

  function replacePlanItemControl(control, element) {

    var newControl;

    if (control) {

      newControl = cmmnFactory.create('cmmn:PlanItemControl');

      var repetitionRule = control.repetitionRule;
      if (repetitionRule && (!element || cmmnRules.canSetRepetitionRule(element))) {

        repetitionRule = replaceRule(repetitionRule);

        setParent(repetitionRule, newControl);
        newControl.repetitionRule = repetitionRule;
      }

      var requiredRule = control.requiredRule;
      if (requiredRule && (!element || cmmnRules.canSetRequiredRule(element))) {

        requiredRule = replaceRule(requiredRule);

        setParent(requiredRule, newControl);
        newControl.requiredRule = requiredRule;
      }

      var manualActivationRule = control.manualActivationRule;
      if (manualActivationRule && (!element || cmmnRules.canSetManualActivationRule(element))) {

        manualActivationRule = replaceRule(manualActivationRule);

        setParent(manualActivationRule, newControl);
        newControl.manualActivationRule = manualActivationRule;
      }
    }

    return newControl;
  }

  this.replacePlanItemControl = replacePlanItemControl;

  function replaceRule(rule) {

    var newRule;

    if (rule) {

      var type = rule.$type;

      var condition = replaceCondition(rule.condition);
      newRule = cmmnFactory.create(type, {
        condition: condition
      });

      setParent(condition, newRule);
    }

    return newRule;
  }

  this.replaceRule = replaceRule;

  function replaceCondition(condition) {
    var newCondition;

    if (condition) {
      newCondition = cmmnFactory.create('cmmn:Expression', {
        language: condition.language,
        body: condition.body
      });
    }

    return newCondition;
  }

  this.replaceCondition = replaceCondition;

  function setParent(element, parent) {
    if (element) {
      element.$parent = parent;
    }
  }
}

CmmnReplace.$inject = ['cmmnFactory', 'replace', 'selection', 'cmmnRules'];

module.exports = CmmnReplace;

function isInstanceOf(element, type) {
  element = getDefinition(element);
  return is(element, type);
}

function isTask(element) {
  return isInstanceOf(element, 'cmmn:Task');
}

function isMilestone(element) {
  return isInstanceOf(element, 'cmmn:Milestone');
}

function isPlanFragment(element) {
  return isInstanceOf(element, 'cmmn:PlanFragment');
}

function isStage(element) {
  return isInstanceOf(element, 'cmmn:Stage');
}

function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

function isPlanItemControlCapable(element) {
  return isTask(element) || isStage(element) || isMilestone(element);
}

},{"46":46,"74":74,"76":76}],58:[function(_dereq_,module,exports){
'use strict';

module.exports.TASK = [{
  label: 'Task',
  actionName: 'replace-with-task-plan-item',
  className: 'cmmn-icon-task-none',
  target: {
    definitionType: 'cmmn:Task',
    type: 'cmmn:PlanItem'
  }
}, {
  label: 'Human Task',
  actionName: 'replace-with-blocking-human-task-plan-item',
  className: 'cmmn-icon-human-blocking-task',
  target: {
    definitionType: 'cmmn:HumanTask',
    type: 'cmmn:PlanItem',
    isBlocking: true
  }
}, {
  label: 'Human Task',
  actionName: 'replace-with-non-blocking-human-task-plan-item',
  className: 'cmmn-icon-human-non-blocking-task',
  target: {
    definitionType: 'cmmn:HumanTask',
    type: 'cmmn:PlanItem',
    isBlocking: false
  }
}, {
  label: 'Decision Task',
  actionName: 'replace-with-decision-task-plan-item',
  className: 'cmmn-icon-decision-task',
  target: {
    definitionType: 'cmmn:DecisionTask',
    type: 'cmmn:PlanItem'
  }
}, {
  label: 'Process Task',
  actionName: 'replace-with-process-task-plan-item',
  className: 'cmmn-icon-process-task',
  target: {
    definitionType: 'cmmn:ProcessTask',
    type: 'cmmn:PlanItem'
  }
}, {
  label: 'Case Task',
  actionName: 'replace-with-case-task-plan-item',
  className: 'cmmn-icon-case-task',
  target: {
    definitionType: 'cmmn:CaseTask',
    type: 'cmmn:PlanItem'
  }
}, {
  label: 'Stage (collapsed)',
  actionName: 'replace-with-collapsed-stage-plan-item',
  className: 'cmmn-icon-stage-collapsed',
  target: {
    definitionType: 'cmmn:Stage',
    type: 'cmmn:PlanItem',
    isCollapsed: true
  }
}, {
  label: 'Stage (expanded)',
  actionName: 'replace-with-expanded-stage-plan-item',
  className: 'cmmn-icon-stage-expanded',
  target: {
    definitionType: 'cmmn:Stage',
    type: 'cmmn:PlanItem',
    isCollapsed: false
  }
}, {
  label: 'Discretionary Task',
  actionName: 'replace-with-task-discretionary-item',
  className: 'cmmn-icon-task-discretionary',
  target: {
    definitionType: 'cmmn:Task',
    type: 'cmmn:DiscretionaryItem'
  }
}, {
  label: 'Discretionary Human Task',
  actionName: 'replace-with-blocking-human-task-discretionary-item',
  className: 'cmmn-icon-human-blocking-task-discretionary',
  target: {
    definitionType: 'cmmn:HumanTask',
    type: 'cmmn:DiscretionaryItem',
    isBlocking: true
  }
}, {
  label: 'Discretionary Human Task',
  actionName: 'replace-with-non-blocking-human-task-discretionary-item',
  className: 'cmmn-icon-human-non-blocking-task-discretionary',
  target: {
    definitionType: 'cmmn:HumanTask',
    type: 'cmmn:DiscretionaryItem',
    isBlocking: false
  }
}, {
  label: 'Discretionary Decision Task',
  actionName: 'replace-with-decision-task-discretionary-item',
  className: 'cmmn-icon-decision-task-discretionary',
  target: {
    definitionType: 'cmmn:DecisionTask',
    type: 'cmmn:DiscretionaryItem'
  }
}, {
  label: 'Discretionary Process Task',
  actionName: 'replace-with-process-task-discretionary-item',
  className: 'cmmn-icon-process-task-discretionary',
  target: {
    definitionType: 'cmmn:ProcessTask',
    type: 'cmmn:DiscretionaryItem'
  }
}, {
  label: 'Discretionary Case Task',
  actionName: 'replace-with-case-task-discretionary-item',
  className: 'cmmn-icon-case-task-discretionary',
  target: {
    definitionType: 'cmmn:CaseTask',
    type: 'cmmn:DiscretionaryItem'
  }
}, {
  label: 'Discretionary Stage (collapsed)',
  actionName: 'replace-with-collapsed-stage-discretionary-item',
  className: 'cmmn-icon-stage-collapsed-discretionary',
  target: {
    definitionType: 'cmmn:Stage',
    type: 'cmmn:DiscretionaryItem',
    isCollapsed: true
  }
}, {
  label: 'Discretionary Stage (expanded)',
  actionName: 'replace-with-expanded-stage-discretionary-item',
  className: 'cmmn-icon-stage-expanded-discretionary',
  target: {
    definitionType: 'cmmn:Stage',
    type: 'cmmn:DiscretionaryItem',
    isCollapsed: false
  }
}];

module.exports.PLAN_FRAGMENT_EXPANDED = [{
  label: 'Stage',
  actionName: 'replace-with-stage-plan-item',
  className: 'cmmn-icon-stage-expanded',
  target: {
    definitionType: 'cmmn:Stage',
    type: 'cmmn:PlanItem',
    isCollapsed: false
  }
}, {
  label: 'Discretionary Stage',
  actionName: 'replace-with-stage-discretionary-item',
  className: 'cmmn-icon-stage-expanded-discretionary',
  target: {
    definitionType: 'cmmn:Stage',
    type: 'cmmn:DiscretionaryItem',
    isCollapsed: false
  }
}, {
  label: 'Discretionary Plan Fragment',
  actionName: 'replace-with-plan-fragment-discretionary-item',
  className: 'cmmn-icon-plan-fragment-expanded-discretionary',
  target: {
    definitionType: 'cmmn:PlanFragment',
    type: 'cmmn:DiscretionaryItem',
    isCollapsed: false
  }
}];

module.exports.EVENT_LISTENER = [{
  label: 'Event Listener',
  actionName: 'replace-with-event-listener-plan-item',
  className: 'cmmn-icon-event-listener',
  target: {
    definitionType: 'cmmn:EventListener',
    type: 'cmmn:PlanItem'
  }
}, {
  label: 'Timer Event Listener',
  actionName: 'replace-with-timer-event-listener-plan-item',
  className: 'cmmn-icon-timer-event-listener',
  target: {
    definitionType: 'cmmn:TimerEventListener',
    type: 'cmmn:PlanItem'
  }
}, {
  label: 'User Event Listener',
  actionName: 'replace-with-user-event-listener-plan-item',
  className: 'cmmn-icon-user-event-listener',
  target: {
    definitionType: 'cmmn:UserEventListener',
    type: 'cmmn:PlanItem'
  }
}];

module.exports.CRITERION = [{
  label: 'Entry Criterion',
  actionName: 'replace-with-entry-criterion',
  className: 'cmmn-icon-entry-criterion',
  target: {
    type: 'cmmn:EntryCriterion'
  }
}, {
  label: 'Exit Criterion',
  actionName: 'replace-with-exit-criterion',
  className: 'cmmn-icon-exit-criterion',
  target: {
    type: 'cmmn:ExitCriterion'
  }
}];

},{}],59:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [_dereq_(188).default, _dereq_(192).default, _dereq_(206).default],
  cmmnReplace: ['type', _dereq_(57)]
};

},{"188":188,"192":192,"206":206,"57":57}],60:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var some = _dereq_(254).some,
    forEach = _dereq_(254).forEach,
    assign = _dereq_(254).assign,
    filter = _dereq_(254).filter;

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    isCasePlanModel = ModelUtil.isCasePlanModel,
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject;

var isCollapsed = _dereq_(74).isCollapsed;

var ModelingUtil = _dereq_(45),
    isAny = ModelingUtil.isAny,
    isSame = ModelingUtil.isSame,
    isSameCase = ModelingUtil.isSameCase,
    getParent = ModelingUtil.getParent,
    getParents = ModelingUtil.getParents;

var PlanItemDefinitionUtil = _dereq_(46),
    isDiscretionaryToHumanTask = PlanItemDefinitionUtil.isDiscretionaryToHumanTask,
    isHumanTask = PlanItemDefinitionUtil.isHumanTask,
    isDiscretionaryItem = PlanItemDefinitionUtil.isDiscretionaryItem;

var isCriterionAttachment = _dereq_(67).getCriterionAttachment;

var RuleProvider = _dereq_(198).default;

/**
 * CMMN specific modeling rule
 */
function CmmnRules(eventBus) {
  RuleProvider.call(this, eventBus);
}

inherits(CmmnRules, RuleProvider);

CmmnRules.$inject = ['eventBus'];

module.exports = CmmnRules;

CmmnRules.prototype.init = function () {

  var self = this;

  this.addRule('connection.start', function (context) {
    var source = context.source;

    return canStartConnection(source);
  });

  this.addRule('connection.create', function (context) {

    var source = context.source,
        target = context.target,
        allowed = false,
        hints = context.hints || {},
        targetParent = hints.targetParent,
        targetAttach = hints.targetAttach;

    // don't allow incoming connections on
    // attach from context-pad
    if (targetAttach) {
      return false;
    }

    // temporarily set target parent for scoping
    // checks to work
    if (targetParent) {
      target.parent = targetParent;
    }

    try {
      allowed = self.canConnect(source, target) || self.canReplaceConnectionEnd(source, target, 'target');

      if (!allowed) {

        allowed = self.canConnect(target, source) || self.canReplaceConnectionEnd(target, source, 'source');

        if (allowed) {
          assign(allowed, {
            reverse: true
          });
        }
      }
    } finally {
      // unset temporary target parent
      if (targetParent) {
        target.parent = null;
      }
    }

    return allowed;
  });

  this.addRule('connection.reconnectStart', function (context) {

    var connection = context.connection,
        hover = context.hover,
        source = hover || context.source,
        target = connection.target,
        allowed = false;

    allowed = self.canConnect(source, target, connection);

    if (!allowed && hover) {

      allowed = self.canReplaceConnectionEnd(hover, target, 'source');

      if (!allowed) {

        allowed = self.canConnect(target, hover, connection) || self.canReplaceConnectionEnd(target, hover, 'target');

        if (allowed) {
          assign(allowed, {
            reverse: true
          });
        }
      }
    }

    return allowed;
  });

  this.addRule('connection.reconnectEnd', function (context) {

    var connection = context.connection,
        source = connection.source,
        hover = context.hover,
        target = hover || context.target,
        allowed = false;

    allowed = self.canConnect(source, target, connection);

    if (!allowed && hover) {

      allowed = self.canReplaceConnectionEnd(source, hover, 'target');

      if (!allowed) {

        allowed = self.canConnect(hover, source, connection) || self.canReplaceConnectionEnd(hover, source, 'source');

        if (allowed) {
          assign(allowed, {
            reverse: true
          });
        }
      }
    }

    return allowed;
  });

  this.addRule('connection.updateWaypoints', function (context) {
    var connection = context.connection;

    return {
      type: connection.type,
      businessObject: connection.businessObject
    };
  });

  this.addRule('shape.attach', function (context) {

    return self.canAttach(context.shape, context.target, null, context.position);
  });

  this.addRule('shape.create', function (context) {

    var target = context.target,
        shape = context.shape,
        source = context.source,
        position = context.position,
        shapes = [shape];

    return self.canCreate(shape, target, source, position) || self.canReplace(shapes, target, position, source);
  });

  this.addRule('shape.resize', function (context) {

    var shape = context.shape,
        newBounds = context.newBounds;

    return self.canResize(shape, newBounds);
  });

  this.addRule('elements.move', function (context) {
    var target = context.target,
        shapes = context.shapes,
        position = context.position;

    return self.canAttach(shapes, target, null, position) || self.canMove(shapes, target, position) || self.canReplace(shapes, target, position);
  });

  this.addRule('shape.replace', function (context) {

    var element = context.element,
        host;

    if (isCriterion(element)) {

      host = element.host;

      if (isCasePlanModel(host)) {
        return false;
      }

      if (isTask(host) && !isBlocking(host)) {
        return false;
      }

      if (isMilestone(host) || isEventListener(host)) {
        return false;
      }
    }
  });

  this.addRule(['elements.delete'], function (context) {
    return self.canRemove(context.elements);
  });
};

CmmnRules.prototype.canRemove = function (elements) {

  // do not allow deletion of labels
  return filter(elements, function (e) {
    return !isLabel(e);
  });
};

CmmnRules.prototype.canMove = function (elements, target) {

  var self = this;

  // allow default move check to start move operation
  if (!target) {
    return true;
  }

  return elements.every(function (element) {

    if (isDiscretionaryItem(element)) {
      if (!self.canMoveDiscretionaryItem(element, elements, target)) {
        return false;
      }
    }

    return self.canDrop(element, target);
  });
};

CmmnRules.prototype.canMoveDiscretionaryItem = function (element, elements, target) {

  return !isPlanFragment(target) || some(element.incoming, function (connection) {
    var source = connection.source;
    if (isDiscretionaryConnection(connection)) {
      return isParent(target, source) || elements.indexOf(source) !== -1;
    }
  });
};

CmmnRules.prototype.canCreate = function (shape, target, source, position) {

  var self = this;

  if (!target) {
    return false;
  }

  if (isLabel(target)) {
    return null;
  }

  if (isSame(source, target)) {
    return false;
  }

  // ensure we do not drop the element
  // into source
  if (source && isParent(source, target)) {
    return false;
  }

  if (isDiscretionaryItem(shape)) {
    if (!self.canCreateDiscretionaryItem(shape, target, source)) {
      return false;
    }
  }

  return self.canDrop(shape, target, position);
};

CmmnRules.prototype.canCreateDiscretionaryItem = function (shape, target, source) {
  return !isPlanFragment(target) || isParent(target, source);
};

CmmnRules.prototype.canDrop = function (element, target) {

  // can move labels everywhere
  if (isLabel(element) && !isConnection(target)) {
    return true;
  }

  if (isArtifact(element)) {

    return is(target, 'cmmndi:CMMNDiagram') || isPlanFragment(target, true);
  }

  if (isCriterion(element)) {
    return false;
  }

  if (isCasePlanModel(element)) {
    // allow casePlanModels to drop only on root (CMMNDiagram)
    return is(target, 'cmmndi:CMMNDiagram');
  }

  // allow any other element to drop on a case plan model or on an expanded stage
  if (!isPlanFragment(target, true)) {
    return false;
  }

  return !isCollapsed(target);
};

CmmnRules.prototype.canResize = function (shape, newBounds) {
  if (isPlanFragment(shape, true)) {
    return !isCollapsed(shape) && (!newBounds || newBounds.width >= 100 && newBounds.height >= 80);
  }

  if (isTextAnnotation(shape)) {
    return true;
  }

  return false;
};

CmmnRules.prototype.canConnect = function (source, target, connection) {

  if (nonExistingOrLabel(source) || nonExistingOrLabel(target)) {
    return null;
  }

  // Disallow connections with same target and source element.
  if (isSame(source, target)) {
    return false;
  }

  if (this.canConnectPlanItemOnPartConnection(source, target)) {
    return {
      type: 'cmmn:PlanItemOnPart',
      isStandardEventVisible: true
    };
  }

  if (this.canConnectCaseFileItemOnPartConnection(source, target)) {
    return {
      type: 'cmmn:CaseFileItemOnPart',
      isStandardEventVisible: true
    };
  }

  if (this.canConnectDiscretionaryConnection(source, target, connection)) {
    return {
      type: 'cmmndi:CMMNEdge'
    };
  }

  if (connection && is(connection.businessObject.cmmnElementRef, 'cmmn:Association') && this.canConnectAssociation(source, target)) {

    return {
      type: 'cmmn:Association'
    };
  }

  if (isTextAnnotation(source) || isTextAnnotation(target)) {

    return {
      type: 'cmmn:Association'
    };
  }

  return false;
};

CmmnRules.prototype.canConnectDiscretionaryConnection = function (source, target, connection) {

  if (!isHumanTask(getDefinition(source))) {
    return false;
  }

  if (!isBlocking(source)) {
    return false;
  }

  if (!isDiscretionaryItem(target)) {
    return false;
  }

  // A HumanTask MUST NOT be discretionary to itself.
  var sourceDefinition = getDefinition(source);
  var targetDefinition = getDefinition(target);

  if (isSame(sourceDefinition, targetDefinition)) {
    return false;
  }

  var sourceParent = getParent(source);
  var targetParent = getParent(target);

  if (!isSame(sourceParent, targetParent)) {
    return false;
  }

  // if the target discretionary item is already
  // part of a human task, then it should not be
  // possible to create a connection to it in some
  // cases.
  if (isDiscretionaryToHumanTask(target)) {

    if (!isUniqueDiscretionaryConnection(source, target, connection)) {
      return false;
    }

    var parent = getParent(getBusinessObject(target), 'cmmn:HumanTask');

    if (!isSame(getDefinition(source), parent)) {
      if (hasIncomingDiscretionaryConnections(target, connection)) {
        return false;
      }
    }
  }

  return true;
};

CmmnRules.prototype.canConnectPlanItemOnPartConnection = function (source, target) {

  if (!isSameCase(source, target)) {
    return false;
  }

  if (isExitCriterion(source)) {
    source = source.host;
  }

  if (isSame(source, target.host)) {
    return false;
  }

  if (isParent(source, target.host)) {
    return false;
  }

  if (isEntryCriterion(target) && isParent(target.host, source)) {
    return false;
  }

  return isPlanItem(source) && isCriterion(target);
};

CmmnRules.prototype.canConnectCaseFileItemOnPartConnection = function (source, target) {
  return !!(isSameCase(source, target) && isCaseFileItem(source) && isCriterion(target));
};

CmmnRules.prototype.canConnectAssociation = function (source, target) {

  // do not connect connections
  if (isConnection(source) || isConnection(target)) {
    return false;
  }

  // connect if different parent
  return !isParent(target, source) && !isParent(source, target);
};

CmmnRules.prototype.canAttach = function (elements, target, source, position) {

  if (isSame(source, target)) {
    return false;
  }

  if (!Array.isArray(elements)) {
    elements = [elements];
  }

  // only (re-)attach one element at a time
  if (elements.length !== 1) {
    return false;
  }

  var element = elements[0];

  // do not attach labels
  if (isLabel(element)) {
    return false;
  }

  // only handle entry/exit criterion
  if (!isCriterion(element)) {
    return false;
  }

  // allow default move operation
  if (!target) {
    return true;
  }

  if (!this.canAttachCriterion(element, target, position, source)) {
    return false;
  }

  return 'attach';
};

CmmnRules.prototype.canAttachEntryCriterion = function (element, target, position, source) {

  if (!this.canAttachCriterion(element, target, position, source)) {
    return false;
  }

  if (source && isParent(target, source)) {
    return false;
  }

  // disallow drop entry criterion...

  // ... on case plan model
  if (isCasePlanModel(target)) {
    return false;
  }

  if (isPlanFragment(target, true)) {

    // ... when element has an incoming connection which source
    // is a child of the target
    return !some(element.incoming, function (connection) {
      if (is(connection.businessObject.cmmnElementRef, 'cmmn:PlanItemOnPart')) {
        return isParent(target, connection.source);
      }
    });
  }

  return true;
};

CmmnRules.prototype.canAttachExitCriterion = function (element, target, position, source) {

  if (!this.canAttachCriterion(element, target, position, source)) {
    return false;
  }

  // disallow drop exit criterion...

  // ... on milestone
  if (isMilestone(target)) {
    return false;
  }

  // ... on non blocking task
  if (isTask(target) && !isBlocking(target)) {
    return false;
  }

  return true;
};

CmmnRules.prototype.canAttachCriterion = function (element, target, position, source) {

  if (source && isParent(source, target)) {
    return false;
  }

  // disallow drop criterion...

  // ... on another criterion
  if (isCriterion(target)) {
    return false;
  }

  // ... on event listener
  if (isEventListener(target)) {
    return false;
  }

  // a plan fragment does not have any execution semantic,
  // that why it should not be possible to attach an criterion
  if (isPlanFragment(target)) {
    return false;
  }

  // ... on a text annotation
  if (isTextAnnotation(target)) {
    return false;
  }

  // ... on a case file item
  if (isCaseFileItem(target)) {
    return false;
  }

  // only attach to border
  if (position && !isCriterionAttachment(position, target)) {
    return false;
  }

  return true;
};

CmmnRules.prototype.canReplace = function (elements, target, position, source) {

  if (!target) {
    return false;
  }

  if (isSame(source, target)) {
    return false;
  }

  var canExecute = {
    replacements: []
  };

  var self = this;

  forEach(elements, function (element) {

    if (isEntryCriterion(element) && !self.canAttachEntryCriterion(element, target, position, source)) {
      if (self.canAttachExitCriterion(element, target, position, source)) {
        canExecute.replacements.push({
          oldElementId: element.id,
          newElementType: 'cmmn:ExitCriterion'
        });
      }
    }

    if (isExitCriterion(element) && !self.canAttachExitCriterion(element, target, position, source)) {
      if (self.canAttachEntryCriterion(element, target, position, source)) {
        canExecute.replacements.push({
          oldElementId: element.id,
          newElementType: 'cmmn:EntryCriterion'
        });
      }
    }

    if (isPlanFragment(target) && isDiscretionaryItem(element) && self.canDrop(element, target) && !self.canMoveDiscretionaryItem(element, elements, target)) {

      var replacement = {
        oldElementId: element.id,
        newElementType: 'cmmn:PlanItem'
      };

      if (isPlanFragment(element)) {
        assign(replacement, {
          newDefinitionType: 'cmmn:Stage'
        });
      }

      canExecute.replacements.push(replacement);
    }
  });

  return canExecute.replacements.length ? canExecute : false;
};

CmmnRules.prototype.canReplaceConnectionEnd = function (source, target, side) {

  if (!source || !target) {
    return false;
  }

  if (isSame(source, target)) {
    return false;
  }

  if (!isSameCase(source, target)) {
    return false;
  }

  return side === 'source' ? this.canReplaceSource(source, target) : this.canReplaceTarget(source, target);
};

CmmnRules.prototype.canReplaceSource = function (source, target) {

  if (isDiscretionaryItem(source) && isCriterion(target)) {

    if (isSame(source, target.host)) {
      return false;
    }

    if (isPlanFragment(source)) {
      return false;
    }

    if (isParent(source, target.host)) {
      return false;
    }

    if (isEntryCriterion(target) && isParent(target.host, source)) {
      return false;
    }

    return {
      type: 'cmmn:PlanItemOnPart',
      isStandardEventVisible: true,
      replacements: [{
        oldElementId: source.id,
        newElementType: 'cmmn:PlanItem'
      }]
    };
  }

  if (isEntryCriterion(source) && isEntryCriterion(target)) {

    if (isSame(source.host, target.host)) {
      return false;
    }

    if (isParent(target.host, source.host) || isParent(source.host, target.host)) {
      return false;
    }

    if (hasIncomingOnPartConnections(source)) {
      return false;
    }

    if (!this.canAttachExitCriterion(source, source.host)) {
      return false;
    }

    return {
      type: 'cmmn:PlanItemOnPart',
      isStandardEventVisible: true,
      replacements: [{
        oldElementId: source.id,
        newElementType: 'cmmn:ExitCriterion'
      }]
    };
  }

  return false;
};

CmmnRules.prototype.canReplaceTarget = function (source, target) {

  if (isHumanTask(getDefinition(source)) && isPlanItem(target)) {

    if (!isBlocking(source)) {
      return false;
    }

    if (isEventListener(target) || isMilestone(target)) {
      return false;
    }

    if (isSameDefinition(source, target)) {
      return false;
    }

    if (!isSameParent(source, target)) {
      return false;
    }

    return {
      type: 'cmmndi:CMMNEdge',
      replacements: [{
        oldElementId: target.id,
        newElementType: 'cmmn:DiscretionaryItem'
      }]
    };
  }

  if ((isPlanItem(source) || isExitCriterion(source)) && isEntryCriterion(target)) {

    if (isSame(source.host || source, target.host)) {
      return false;
    }

    if (!isParent(target.host, source.host || source)) {
      return false;
    }

    if (hasIncomingOnPartConnections(target)) {
      return false;
    }

    if (!this.canAttachExitCriterion(target, target.host)) {
      return false;
    }

    return {
      type: 'cmmn:PlanItemOnPart',
      isStandardEventVisible: true,
      replacements: [{
        oldElementId: target.id,
        newElementType: 'cmmn:ExitCriterion'
      }]
    };
  }

  return false;
};

CmmnRules.prototype.canSetRepetitionRule = function (element) {
  return isPlanItemControlCapable(element);
};

CmmnRules.prototype.canSetRequiredRule = function (element) {
  return isPlanItemControlCapable(element);
};

CmmnRules.prototype.canSetManualActivationRule = function (element) {
  if (isMilestone(element)) {
    return false;
  }
  return isPlanItemControlCapable(element);
};

/**
 * Utility functions for rule checking
 */

/**
 * Checks if given element can be used for starting connection.
 *
 * @param  {Element} source
 * @return {Boolean}
 */
function canStartConnection(element) {
  if (nonExistingOrLabel(element)) {
    return null;
  }

  return isAny(element, ['cmmn:CaseFileItem', 'cmmn:Criterion', 'cmmn:DiscretionaryItem', 'cmmn:PlanItem']);
}

function isParent(possibleParent, element) {
  var allParents = getParents(element);
  return allParents.indexOf(possibleParent) !== -1;
}

function isPlanItemControlCapable(element) {
  return isTask(element) || isMilestone(element) || is(getDefinition(element), 'cmmn:Stage');
}

function nonExistingOrLabel(element) {
  return !element || isLabel(element);
}

function isLabel(element) {
  return element.labelTarget;
}

function isConnection(element) {
  return element.waypoints;
}

function isUniqueDiscretionaryConnection(source, target, connection) {
  return !some(target.incoming, function (con) {
    return con !== connection && isDiscretionaryConnection(con) && con.source === source && con.target === target;
  });
}

function hasIncomingDiscretionaryConnections(target, connection) {
  return some(target.incoming, function (con) {
    return con !== connection && isDiscretionaryConnection(con);
  });
}

function isDiscretionaryConnection(connection) {
  return !connection.businessObject.cmmnElementRef;
}

function hasIncomingOnPartConnections(target) {
  return some(target.incoming, function (con) {
    return isOnPartConnection(con);
  });
}

function isOnPartConnection(connection) {
  return is(connection.businessObject.cmmnElementRef, 'cmmn:OnPart');
}

function isPlanFragment(element, isStage) {
  var definition = getDefinition(element) || element;

  if (!is(definition, 'cmmn:PlanFragment')) {
    return false;
  }

  if (!isStage && is(definition, 'cmmn:Stage')) {
    return false;
  }

  return true;
}

function isEventListener(element) {
  return is(getDefinition(element), 'cmmn:EventListener');
}

function isMilestone(element) {
  return is(getDefinition(element), 'cmmn:Milestone');
}

function isTask(element) {
  return is(getDefinition(element), 'cmmn:Task');
}

function isBlocking(element) {
  element = getDefinition(element);
  return !!(element && element.isBlocking);
}

function isCriterion(element) {
  return is(element, 'cmmn:Criterion');
}

function isEntryCriterion(element) {
  return is(element, 'cmmn:EntryCriterion');
}

function isExitCriterion(element) {
  return is(element, 'cmmn:ExitCriterion');
}

function isArtifact(element) {
  if (isConnection(element)) {
    element = element.businessObject.cmmnElementRef;
  }
  return is(element, 'cmmn:Artifact');
}

function isTextAnnotation(element) {
  return is(element, 'cmmn:TextAnnotation');
}

function isCaseFileItem(element) {
  return is(element, 'cmmn:CaseFileItem');
}

function isPlanItem(element) {
  return is(element, 'cmmn:PlanItem');
}

function isSameParent(a, b) {
  return isSame(getParent(a), getParent(b));
}

function isSameDefinition(a, b) {
  return isSame(getDefinition(a), getDefinition(b));
}

},{"198":198,"253":253,"254":254,"45":45,"46":46,"67":67,"74":74,"76":76}],61:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [_dereq_(200).default],
  __init__: ['cmmnRules'],
  cmmnRules: ['type', _dereq_(60)]
};

},{"200":200,"60":60}],62:[function(_dereq_,module,exports){
'use strict';

var map = _dereq_(254).map,
    filter = _dereq_(254).filter,
    sortBy = _dereq_(254).sortBy;

var labelUtil = _dereq_(18);

/**
 * Provides ability to search through CMMN elements
 */
function CmmnSearchProvider(elementRegistry, searchPad, canvas) {

  this._elementRegistry = elementRegistry;
  this._canvas = canvas;

  searchPad.registerProvider(this);
}

module.exports = CmmnSearchProvider;

CmmnSearchProvider.$inject = ['elementRegistry', 'searchPad', 'canvas'];

/**
 * Finds all elements that match given pattern
 *
 * <Result> :
 *  {
 *    primaryTokens: <Array<Token>>,
 *    secondaryTokens: <Array<Token>>,
 *    element: <Element>
 *  }
 *
 * <Token> :
 *  {
 *    normal|matched: <String>
 *  }
 *
 * @param  {String} pattern
 * @return {Array<Result>}
 */
CmmnSearchProvider.prototype.find = function (pattern) {
  var rootElement = this._canvas.getRootElement();

  var elements = this._elementRegistry.filter(function (element) {
    if (element.labelTarget) {
      return false;
    }
    return true;
  });

  // do not include root element
  elements = filter(elements, function (element) {
    return element !== rootElement;
  });

  elements = map(elements, function (element) {
    return {
      primaryTokens: matchAndSplit(labelUtil.getLabel(element), pattern),
      secondaryTokens: matchAndSplit(element.id, pattern),
      element: element
    };
  });

  // exclude non-matched elements
  elements = filter(elements, function (element) {
    return hasMatched(element.primaryTokens) || hasMatched(element.secondaryTokens);
  });

  elements = sortBy(elements, function (element) {
    return labelUtil.getLabel(element.element) + element.element.id;
  });

  return elements;
};

function hasMatched(tokens) {
  var matched = filter(tokens, function (t) {
    return !!t.matched;
  });

  return matched.length > 0;
}

function matchAndSplit(text, pattern) {
  var tokens = [],
      originalText = text;

  if (!text) {
    return tokens;
  }

  text = text.toLowerCase();
  pattern = pattern.toLowerCase();

  var i = text.indexOf(pattern);

  if (i > -1) {
    if (i !== 0) {
      tokens.push({
        normal: originalText.substr(0, i)
      });
    }

    tokens.push({
      matched: originalText.substr(i, pattern.length)
    });

    if (pattern.length + i < text.length) {
      tokens.push({
        normal: originalText.substr(pattern.length + i, text.length)
      });
    }
  } else {
    tokens.push({
      normal: originalText
    });
  }

  return tokens;
}

},{"18":18,"254":254}],63:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  __depends__: [_dereq_(202).default],
  __init__: ['cmmnSearch'],
  cmmnSearch: ['type', _dereq_(62)]
};

},{"202":202,"62":62}],64:[function(_dereq_,module,exports){
'use strict';

var SnapUtil = _dereq_(210),
    mid = SnapUtil.mid,
    setSnapped = SnapUtil.setSnapped;

var isCmd = _dereq_(144).isCmd;

var ModelUtil = _dereq_(76),
    is = ModelUtil.is,
    getDefinition = ModelUtil.getDefinition,
    getBusinessObject = ModelUtil.getBusinessObject;

var HIGHER_PRIORITY = 1250;

/**
   * Snap during connect.
   *
   * @param {EventBus} eventBus
   * @param {Rules} rules
   */
function CmmnConnectSnapping(eventBus, rules) {
  eventBus.on(['connect.hover', 'connect.move', 'connect.end'], HIGHER_PRIORITY, function (event) {
    var context = event.context,
        source = context.source,
        target = context.target,
        canExecute = context.canExecute;

    if (!canExecute) {
      return;
    }

    if (event.originalEvent && isCmd(event.originalEvent)) {
      return;
    }

    if (!context.initialSourcePosition) {
      context.initialSourcePosition = context.sourcePosition;
    }

    var connectionAttrs = rules.allowed('connection.create', {
      source: source,
      target: target
    });

    if (connectionAttrs && isCenterSnapTarget(source)) {
      // snap source
      context.sourcePosition = mid(source);
    }

    if (connectionAttrs && isCenterSnapTarget(target)) {

      // snap target
      snapToPosition(event, mid(target));
    }
  });
}

CmmnConnectSnapping.$inject = ['eventBus', 'rules'];

module.exports = CmmnConnectSnapping;

// helpers //////////

function snapToPosition(event, position) {
  setSnapped(event, 'x', position.x);
  setSnapped(event, 'y', position.y);
}

/**
 * Returns true if element should be center snapped when
 * creating a connection.
 *
 * This applies to all collapsed and non container elements.
 *
 * @param {djs.model.Base} element
 *
 * @return {Boolean}
 */
function isCenterSnapTarget(element) {

  if (!element) {
    return false;
  }

  if (is(element, 'cmmn:Stage')) {
    return false;
  }

  var bo = getBusinessObject(element);
  var definition = getDefinition(element) || element;

  if (!is(definition, 'cmmn:PlanFragment')) {
    return true;
  }

  var di = bo.di;

  if (di && di.isCollapsed === true) {
    return true;
  }

  return false;
}

},{"144":144,"210":210,"76":76}],65:[function(_dereq_,module,exports){
'use strict';

var inherits = _dereq_(253);

var SnapUtil = _dereq_(210);

var CreateMoveSnapping = _dereq_(207).default;

var isSnapped = SnapUtil.isSnapped,
    setSnapped = SnapUtil.setSnapped;

var asTRBL = _dereq_(221).asTRBL,
    getMid = _dereq_(221).getMid;

var getCriterionAttachment = _dereq_(67).getCriterionAttachment;

var forEach = _dereq_(254).forEach;

/**
 * Cmmn specific create move snapping functionality
 *
 * @param {EventBus} eventBus
 * @param {CmmnRules} cmmnRules
 */
function CmmnCreateMoveSnapping(eventBus, cmmnRules, injector) {

  injector.invoke(CreateMoveSnapping, this);

  function canAttach(shape, target, position) {
    return cmmnRules.canAttach([shape], target, null, position) === 'attach';
  }

  eventBus.on(['create.move', 'create.end', 'shape.move.move', 'shape.move.end'], 1500, function (event) {

    var context = event.context,
        target = context.target,
        shape = context.shape;

    if (target && !isSnapped(event) && canAttach(shape, target, event)) {
      snapCriterion(event, shape, target);
    }
  });

  function snapCriterion(event, shape, target) {
    var targetTRBL = asTRBL(target);

    var direction = getCriterionAttachment(event, target);

    if (/top/.test(direction)) {
      setSnapped(event, 'y', targetTRBL.top);
    } else if (/bottom/.test(direction)) {
      setSnapped(event, 'y', targetTRBL.bottom);
    }

    if (/left/.test(direction)) {
      setSnapped(event, 'x', targetTRBL.left);
    } else if (/right/.test(direction)) {
      setSnapped(event, 'x', targetTRBL.right);
    }
  }
}

inherits(CmmnCreateMoveSnapping, CreateMoveSnapping);

CmmnCreateMoveSnapping.$inject = ['eventBus', 'cmmnRules', 'injector'];

module.exports = CmmnCreateMoveSnapping;

CmmnCreateMoveSnapping.prototype.initSnap = function (event) {
  var snapContext = CreateMoveSnapping.prototype.initSnap.call(this, event);

  var shape = event.shape;

  // snap to docking points
  forEach(shape.outgoing, function (connection) {
    var docking = connection.waypoints[0];

    docking = docking.original || docking;

    snapContext.setSnapOrigin(connection.id + '-docking', {
      x: docking.x - event.x,
      y: docking.y - event.y
    });
  });

  forEach(shape.incoming, function (connection) {
    var docking = connection.waypoints[connection.waypoints.length - 1];

    docking = docking.original || docking;

    snapContext.setSnapOrigin(connection.id + '-docking', {
      x: docking.x - event.x,
      y: docking.y - event.y
    });
  });

  return snapContext;
};

CmmnCreateMoveSnapping.prototype.addSnapTargetPoints = function (snapPoints, shape, target) {
  CreateMoveSnapping.prototype.addSnapTargetPoints.call(this, snapPoints, shape, target);

  var snapTargets = this.getSnapTargets(shape, target);

  // snap to docking points
  forEach(shape.incoming, function (connection) {

    if (!includes(snapTargets, connection.source)) {
      snapPoints.add('mid', getMid(connection.source));
    }

    var docking = connection.waypoints[0];

    snapPoints.add(connection.id + '-docking', docking.original || docking);
  });

  forEach(shape.outgoing, function (connection) {

    if (!includes(snapTargets, connection.target)) {
      snapPoints.add('mid', getMid(connection.target));
    }

    var docking = connection.waypoints[connection.waypoints.length - 1];

    snapPoints.add(connection.id + '-docking', docking.original || docking);
  });

  return snapPoints;
};

// helpers ////////////////////

function includes(array, value) {
  return array.indexOf(value) !== -1;
}

},{"207":207,"210":210,"221":221,"253":253,"254":254,"67":67}],66:[function(_dereq_,module,exports){
'use strict';

var is = _dereq_(76).is,
    getDefinition = _dereq_(76).getDefinition,
    isCollapsed = _dereq_(74).isCollapsed;

var SLIGHTLY_HIGHER_PRIORITY = 1001;

/**
 * Cmmn specific resize snapping functionality
 *
 * @param {EventBus} eventBus
 * @param {CmmnRules} cmmnRules
 */
function CmmnResizeSnapping(eventBus) {

  eventBus.on('resize.start', SLIGHTLY_HIGHER_PRIORITY + 500, function (event) {
    var context = event.context,
        shape = context.shape;

    if (isStage(shape) && !isCollapsed(shape)) {
      context.minDimensions = { width: 140, height: 120 };
    }

    if (is(shape, 'cmmn:TextAnnotation')) {
      context.minDimensions = { width: 50, height: 30 };
    }
  });
}

CmmnResizeSnapping.$inject = ['eventBus', 'cmmnRules', 'injector'];

module.exports = CmmnResizeSnapping;

// helpers //////////

function isStage(element) {
  return is(getDefinition(element), 'cmmn:PlanFragment');
}

},{"74":74,"76":76}],67:[function(_dereq_,module,exports){
'use strict';

var getOrientation = _dereq_(221).getOrientation;

var is = _dereq_(76).is,
    getDefinition = _dereq_(76).getDefinition;

/**
 * Get orientation of the given position rectangle in relation to the
 * given target rectangle. When the position is near a corner (respecting
 * the given offet) the string 'corner' is returned.
 *
 * A padding (positive or negative) may be passed to influence
 * horizontal / vertical orientation and intersection.
 *
 * @param {Bounds} position
 * @param {Bounds} target
 * @param {Point|Number} padding
 * @param {Number} offset
 */
function getCornerlessOrientation(position, target, padding, offset) {

  // don't snap to top left corner
  if (position.x - offset < target.x && position.y - offset < target.y) {
    return 'corner';
  }

  // don't snap to top right corner
  if (position.x + offset > target.x + target.width && position.y - offset < target.y) {
    return 'corner';
  }

  // don't snap to bottom left corner
  if (position.x - offset < target.x && position.y + offset > target.y + target.height) {
    return 'corner';
  }

  // don't snap to bottom right corner
  if (position.x + offset > target.x + target.width && position.y + offset > target.y + target.height) {
    return 'corner';
  }

  return getOrientation(position, target, padding);
}

function getCriterionAttachment(position, target) {

  var orientation;

  var definition = getDefinition(target);

  if (is(target, 'cmmn:PlanItem') && is(definition, 'cmmn:Stage')) {
    orientation = getCornerlessOrientation(position, target, -15, 20);
  } else if (is(definition, 'cmmn:Milestone')) {
    orientation = getCornerlessOrientation(position, target, -3, 7);
  } else {
    orientation = getOrientation(position, target, -15);
  }

  if (orientation !== 'intersect') {
    return orientation;
  } else {
    return null;
  }
}

module.exports.getCriterionAttachment = getCriterionAttachment;

},{"221":221,"76":76}],68:[function(_dereq_,module,exports){
'use strict';

var CmmnConnectSnapping = _dereq_(64);
var CmmnCreateMoveSnapping = _dereq_(65);
var CmmnResizeSnapping = _dereq_(66);
var SnappingModule = _dereq_(212).default;

module.exports = {
  __depends__: [SnappingModule],
  __init__: ['connectSnapping', 'createMoveSnapping', 'resizeSnapping'],
  connectSnapping: ['type', CmmnConnectSnapping],
  createMoveSnapping: ['type', CmmnCreateMoveSnapping],
  resizeSnapping: ['type', CmmnResizeSnapping]
};

},{"212":212,"64":64,"65":65,"66":66}],69:[function(_dereq_,module,exports){
'use strict';

var assign = _dereq_(254).assign,
    map = _dereq_(254).map;

var LabelUtil = _dereq_(75);

var is = _dereq_(76).is;

var hasExternalLabel = LabelUtil.hasExternalLabel,
    getExternalLabelBounds = LabelUtil.getExternalLabelBounds,
    isCollapsed = _dereq_(74).isCollapsed,
    elementToString = _dereq_(72).elementToString;

function elementData(semantic, attrs) {
  return assign({
    id: semantic.id,
    type: semantic.$type,
    businessObject: semantic
  }, attrs);
}

function collectWaypoints(waypoints) {
  return map(waypoints, function (p) {
    return { x: p.x, y: p.y };
  });
}

function notYetDrawn(semantic, refSemantic, property) {
  return new Error('element ' + elementToString(refSemantic) + ' referenced by ' + elementToString(semantic) + '#' + property + ' not yet drawn');
}

/**
 * An importer that adds cmmn elements to the canvas
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {ElementFactory} elementFactory
 * @param {ElementRegistry} elementRegistry
 */
function CmmnImporter(eventBus, canvas, elementFactory, elementRegistry) {
  this._eventBus = eventBus;
  this._canvas = canvas;

  this._elementFactory = elementFactory;
  this._elementRegistry = elementRegistry;
}

CmmnImporter.$inject = ['eventBus', 'canvas', 'elementFactory', 'elementRegistry'];

module.exports = CmmnImporter;

/**
 * Set the diagram as root element
 */
CmmnImporter.prototype.root = function (diagram) {
  var element = this._elementFactory.createRoot(elementData(diagram));

  this._canvas.setRootElement(element);

  return element;
};

/**
 * Add cmmn element (semantic) to the canvas onto the
 * specified parent shape.
 */
CmmnImporter.prototype.add = function (semantic, parentElement) {

  var di = semantic.di,
      element,
      hidden;

  // SHAPE
  if (di && is(di, 'cmmndi:CMMNShape') && !this._getElement(semantic)) {

    var collapsed = isCollapsed(semantic);

    hidden = parentElement && (parentElement.hidden || parentElement.collapsed);

    var bounds = semantic.di.bounds;

    element = this._elementFactory.createShape(elementData(semantic, {
      collapsed: collapsed,
      hidden: hidden,
      x: Math.round(bounds.x),
      y: Math.round(bounds.y),
      width: Math.round(bounds.width),
      height: Math.round(bounds.height)
    }));

    if (is(semantic, 'cmmn:Criterion')) {
      this._attachCriterion(semantic, element);
    }

    this._canvas.addShape(element, parentElement);
  }

  // CONNECTION
  else if (di && is(di, 'cmmndi:CMMNEdge') || is(semantic, 'cmmndi:CMMNEdge')) {

      var source = this._getSource(semantic),
          target = this._getTarget(semantic);

      hidden = parentElement && (parentElement.hidden || parentElement.collapsed) || source && source.hidden || target && target.hidden;

      var waypoint = (semantic.di || {}).waypoint || semantic.waypoint;

      element = this._elementFactory.createConnection(elementData(semantic, {
        hidden: hidden,
        source: source,
        target: target,
        waypoints: collectWaypoints(waypoint)
      }));

      this._canvas.addConnection(element, parentElement);
    } else {
      throw new Error('unknown di ' + elementToString(di) + ' for element ' + elementToString(semantic));
    }

  // (optional) LABEL
  if (hasExternalLabel(semantic)) {
    this.addLabel(semantic, element);
  }

  this._eventBus.fire('cmmnElement.added', { element: element });

  return element;
};

/**
 * Attach the criterion element to the given host
 *
 * @param {ModdleElement} criterionSemantic
 * @param {djs.model.Base} criterionElement
 */
CmmnImporter.prototype._attachCriterion = function (criterionSemantic, criterionElement) {
  var hostSemantic = criterionSemantic.$parent;

  if (!hostSemantic) {
    throw new Error('missing ' + elementToString(criterionSemantic) + '$parent');
  }

  var host = this._elementRegistry.get(hostSemantic.id),
      attachers = host && host.attachers;

  if (!host) {
    throw notYetDrawn(criterionSemantic, hostSemantic, 'criterion');
  }

  // wire element.host <> host.attachers
  criterionElement.host = host;

  if (!attachers) {
    host.attachers = attachers = [];
  }

  if (attachers.indexOf(criterionElement) === -1) {
    attachers.push(criterionElement);
  }
};

/**
 * add label for an element
 */
CmmnImporter.prototype.addLabel = function (semantic, element) {
  var bounds = getExternalLabelBounds(semantic, element);

  var label = this._elementFactory.createLabel(elementData(semantic, {
    id: semantic.id + '_label',
    labelTarget: element,
    type: 'label',
    hidden: element.hidden,
    x: Math.round(bounds.x),
    y: Math.round(bounds.y),
    width: Math.round(bounds.width),
    height: Math.round(bounds.height)
  }));

  return this._canvas.addShape(label, element.parent);
};

CmmnImporter.prototype._getSource = function (semantic) {
  var cmmnElement = semantic.cmmnElementRef;

  if (cmmnElement) {

    if (is(cmmnElement, 'cmmn:OnPart')) {

      if (cmmnElement.exitCriterionRef) {
        return this._getEnd(cmmnElement, 'exitCriterionRef');
      }

      return this._getEnd(cmmnElement, 'sourceRef');
    }

    if (is(cmmnElement, 'cmmn:Association')) {
      return this._getEnd(cmmnElement, 'sourceRef');
    }
  }

  if (is(semantic, 'cmmndi:CMMNEdge')) {
    return this._getEnd(semantic, 'sourceCMMNElementRef');
  }
};

CmmnImporter.prototype._getTarget = function (semantic) {
  var cmmnElement = semantic.cmmnElementRef;

  if (cmmnElement) {

    if (is(cmmnElement, 'cmmn:Association')) {
      return this._getEnd(cmmnElement, 'targetRef');
    }
  }

  return this._getEnd(semantic, 'targetCMMNElementRef');
};

CmmnImporter.prototype._getEnd = function (semantic, side) {
  var refSemantic = semantic[side];
  var element = refSemantic && this._getElement(refSemantic);

  if (element) {
    return element;
  }

  if (refSemantic) {
    throw notYetDrawn(semantic, refSemantic, side);
  } else {
    throw new Error(elementToString(semantic) + '#' + side + 'Ref not specified');
  }
};

CmmnImporter.prototype._getElement = function (semantic) {
  return this._elementRegistry.get(semantic.id);
};

},{"254":254,"72":72,"74":74,"75":75,"76":76}],70:[function(_dereq_,module,exports){
'use strict';

var forEach = _dereq_(254).forEach,
    filter = _dereq_(254).filter;

var Refs = _dereq_(269);

var elementToString = _dereq_(72).elementToString;
var is = _dereq_(76).is;

var Collections = _dereq_(233);

var diRefs = new Refs({ name: 'cmmnElement', enumerable: true }, { name: 'di' });

function CmmnTreeWalker(handler) {

  // list of elements to handle deferred to ensure
  // prerequisites are drawn
  var deferred = [];

  // list of CMMNEdges which cmmnElementRef is equals null:
  // - it is a connection which does not have a representation
  //   in case plan model
  // - it is a connection between a human (plan item) task and a
  //   discretionary item
  var connections = [];

  var discretionaryConnections = {};

  // list of cases to draw
  var cases = [];

  var handledDiscretionaryItems = {};

  // list of elements (textAnnotations and caseFileItems)
  var elementsWithoutParent = [];

  var associations = [];

  // Helpers /////////////////

  function isDiscretionaryItemHandled(item) {
    return !!handledDiscretionaryItems[item.id];
  }

  function handledDiscretionaryItem(item) {
    handledDiscretionaryItems[item.id] = item;
  }

  /**
   * Returns the surrounding 'cmmn:Case' element
   *
   * @param {ModdleElement} element
   *
   * @return {ModdleElement} the surrounding case
   */
  function getCase(element) {
    while (element && !is(element, 'cmmn:Case')) {
      element = element.$parent;
    }
    return element;
  }

  function visit(element, ctx) {
    // call handler
    return handler.element(element, ctx);
  }

  function visitRoot(element, diagram) {
    return handler.root(element, diagram);
  }

  function visitIfDi(element, ctx) {
    try {
      handler.addItem(element);
      return element.di && visit(element, ctx);
    } catch (e) {
      logError(e.message, { element: element, error: e });

      console.error('failed to import ' + elementToString(element));
      console.error(e);
    }
  }

  function logError(message, context) {
    handler.error(message, context);
  }

  function contextual(fn, ctx) {
    return function (e) {
      fn(e, ctx);
    };
  }

  // DI handling /////////////////

  function registerDi(di) {

    var cmmnElement = di.cmmnElementRef;

    if (cmmnElement && !is(di, 'cmmndi:CMMNEdge')) {

      if (cmmnElement.di) {
        logError('multiple DI elements defined for ' + elementToString(cmmnElement), { element: cmmnElement });
      } else {

        var _case = getCase(cmmnElement);
        if (_case && cases.indexOf(_case) === -1) {
          // add _case to the list of cases
          // that should be drawn
          cases.push(_case);
        }

        if (is(cmmnElement, 'cmmn:TextAnnotation') || is(cmmnElement, 'cmmn:CaseFileItem')) {
          elementsWithoutParent.push(cmmnElement);
        }

        diRefs.bind(cmmnElement, 'di');
        cmmnElement.di = di;
      }
    } else if (is(di, 'cmmndi:CMMNEdge')) {
      var shouldHandle = true;

      if (!isReferencingTarget(di)) {
        shouldHandle = false;
        logError('no target referenced in ' + elementToString(di), { element: di });
      }

      if (!isReferencingSource(di)) {
        shouldHandle = false;
        logError('no source referenced in ' + elementToString(di), { element: di });
      }

      if (shouldHandle) {

        if (is(cmmnElement, 'cmmn:Association')) {
          associations.push(di);
        } else if (!cmmnElement) {
          var source = di.sourceCMMNElementRef;
          discretionaryConnections[source.id] = discretionaryConnections[source.id] || [];
          discretionaryConnections[source.id].push(di);
        } else {
          connections.push(function (ctx) {
            handleConnection(di, ctx);
          });
        }
      }
    } else {
      logError('no cmmnElement referenced in ' + elementToString(di), { element: di });
    }
  }

  function isReferencingTarget(edge) {
    if (is(edge.cmmnElementRef, 'cmmn:Association')) {
      return !!edge.cmmnElementRef.targetRef;
    }

    return !!edge.targetCMMNElementRef;
  }

  function isReferencingSource(edge) {
    if (is(edge.cmmnElementRef, 'cmmn:OnPart')) {
      return !!(edge.cmmnElementRef.exitCriterionRef || edge.cmmnElementRef.sourceRef);
    }

    if (is(edge.cmmnElementRef, 'cmmn:Association')) {
      return !!edge.cmmnElementRef.sourceRef;
    }

    return !!edge.sourceCMMNElementRef;
  }

  function handleConnection(connection, context) {
    visit(connection, context);
  }

  function handleDiagram(diagram) {
    handleDiagramElements(diagram.diagramElements);
  }

  function handleDiagramElements(diagramElements) {
    forEach(diagramElements, handleDiagramElement);
  }

  function handleDiagramElement(diagramElement) {
    registerDi(diagramElement);
  }

  // Semantic handling /////////////////

  function handleDefinitions(definitions, diagram) {
    // make sure we walk the correct cmmnElement

    var cmmndi = definitions.CMMNDI;

    // no di -> nothing to import
    if (!cmmndi) {
      return;
    }

    var diagrams = cmmndi.diagrams;

    if (diagram && diagrams.indexOf(diagram) === -1) {
      throw new Error('diagram not part of cmmn:Definitions');
    }

    if (!diagram && diagrams && diagrams.length) {
      diagram = diagrams[0];
    }

    // handle only the first diagram and ignore others
    handleDiagram(diagram);

    var context = visitRoot(diagram, diagram);

    handleCases(cases, context);

    forEach(elementsWithoutParent, contextual(handleElementWithoutParent));
    forEach(associations, contextual(handleAssociation));
  }

  function handleCases(cases, context) {
    forEach(cases, function (_case) {
      handleCase(_case, context);

      // clear collections for the next iteration
      deferred = [];
      connections = [];
    });
  }

  function handleCase(_case, context) {
    var casePlanModel = _case.casePlanModel;

    var casePlanModelContext;
    if (casePlanModel) {
      casePlanModelContext = handleCasePlanModel(casePlanModel, context);
    }

    handleDeferred(deferred);

    forEach(connections, function (d) {
      d(casePlanModelContext);
    });
  }

  function handleCasePlanModel(casePlanModel, context) {
    var newCtx = visitIfDi(casePlanModel, context);

    forEach(casePlanModel.exitCriteria, contextual(handleCriterion, newCtx));

    handlePlanFragment(casePlanModel, newCtx);
    handleElementsWithoutParent(casePlanModel, newCtx);

    return newCtx;
  }

  function handleDeferred(deferred) {
    forEach(deferred, function (d) {
      d();
    });
  }

  function handlePlanFragment(planFragment, context) {
    handlePlanItems(planFragment.planItems, context);

    if (is(planFragment, 'cmmn:Stage')) {
      handleStage(planFragment, context);
    }
  }

  function handleStage(stage, context) {
    handlePlanningTable(stage.planningTable, context);
  }

  function handlePlanningTable(planningTable, context) {
    if (planningTable) {
      forEach(planningTable.tableItems, function (tableItem) {
        if (is(tableItem, 'cmmn:DiscretionaryItem')) {
          handleDiscretionaryItem(tableItem, context);
        } else if (is(tableItem, 'cmmn:PlanningTable')) {
          handlePlanningTable(tableItem, context);
        }
      });
    }
  }

  function handleDiscretionaryItem(discretionayItem, context) {
    if (isDiscretionaryItemHandled(discretionayItem)) {
      return;
    }

    handledDiscretionaryItem(discretionayItem);
    handleItem(discretionayItem, context);
  }

  function handlePlanItems(planItems, context) {
    forEach(planItems, contextual(handleItem, context));
  }

  function handleItem(item, context) {
    var newCtx = visitIfDi(item, context);

    forEach(item.exitCriteria, contextual(handleCriterion, context));
    forEach(item.entryCriteria, contextual(handleCriterion, context));

    var definitionRef = item.definitionRef;
    if (is(definitionRef, 'cmmn:PlanFragment')) {
      handlePlanFragment(definitionRef, newCtx);
      handleElementsWithoutParent(item, newCtx);
    } else if (is(definitionRef, 'cmmn:HumanTask')) {
      handlePlanningTable(definitionRef.planningTable, context);

      var edges = discretionaryConnections[item.id];
      forEach(edges, contextual(handleDiscretionaryConnection, context));
      delete discretionaryConnections[item.id];
    }
  }

  function handleCriterion(criterion, context) {
    deferred.unshift(function () {
      visitIfDi(criterion, context);
    });
  }

  function handleElementsWithoutParent(container, context) {

    if (container.di && container.di.bounds) {
      var elements = getEnclosedElements(elementsWithoutParent, container);

      forEach(elements, function (e) {
        Collections.remove(elementsWithoutParent, e);
        handleElementWithoutParent(e, context);
      });
    }
  }

  function handleElementWithoutParent(element, context) {
    if (is(element, 'cmmn:TextAnnotation')) {
      handleTextAnnotation(element, context);
    } else if (is(element, 'cmmn:CaseFileItem')) {
      handleCaseFileItem(element, context);
    }
  }

  function handleCaseFileItem(caseFileItem, context) {
    visitIfDi(caseFileItem, context);
  }

  function handleTextAnnotation(annotation, context) {
    visitIfDi(annotation, context);
  }

  function handleAssociation(association, context) {
    visit(association, context);
  }

  function handleDiscretionaryConnection(connection, context) {
    deferred.push(function () {
      visit(connection, context);
    });
  }

  function getEnclosedElements(elements, container) {
    var bounds = container.di.bounds;
    return filter(elements, function (e) {
      return e.di.bounds.x > bounds.x && e.di.bounds.x < bounds.x + bounds.width && e.di.bounds.y > bounds.y && e.di.bounds.y < bounds.y + bounds.height;
    });
  }

  // API /////////////////

  return {
    handleDefinitions: handleDefinitions
  };
}

module.exports = CmmnTreeWalker;

},{"233":233,"254":254,"269":269,"72":72,"76":76}],71:[function(_dereq_,module,exports){
'use strict';

var CmmnTreeWalker = _dereq_(70);

/**
 * Import the definitions into a diagram.
 *
 * Errors and warnings are reported through the specified callback.
 *
 * @param  {Diagram} diagram
 * @param  {ModdleElement} definitions
 * @param  {Function} done the callback, invoked with (err, [ warning ]) once the import is done
 */
function importCmmnDiagram(diagram, definitions, done) {

  var importer = diagram.get('cmmnImporter'),
      eventBus = diagram.get('eventBus'),
      itemRegistry = diagram.get('itemRegistry');

  var error,
      warnings = [];

  /**
   * Walk the diagram semantically, importing (=drawing)
   * all elements you encounter.
   *
   * @param {ModdleElement} definitions
   */
  function render(definitions) {

    var visitor = {

      root: function root(element) {
        return importer.root(element);
      },

      element: function element(_element, parentShape) {
        return importer.add(_element, parentShape);
      },

      error: function error(message, context) {
        warnings.push({ message: message, context: context });
      },

      addItem: function addItem(item) {
        itemRegistry.add(item);
      }
    };

    var walker = new CmmnTreeWalker(visitor);

    // import
    walker.handleDefinitions(definitions);
  }

  eventBus.fire('import.render.start', { definitions: definitions });

  try {
    render(definitions);
  } catch (e) {
    error = e;
  }

  eventBus.fire('import.render.complete', {
    error: error,
    warnings: warnings
  });

  done(error, warnings);
}

module.exports.importCmmnDiagram = importCmmnDiagram;

},{"70":70}],72:[function(_dereq_,module,exports){
'use strict';

module.exports.elementToString = function (e) {
  if (!e) {
    return '<null>';
  }

  return '<' + e.$type + (e.id ? ' id="' + e.id : '') + '" />';
};

},{}],73:[function(_dereq_,module,exports){
'use strict';

module.exports = {
  cmmnImporter: ['type', _dereq_(69)]
};

},{"69":69}],74:[function(_dereq_,module,exports){
'use strict';

var is = _dereq_(76).is,
    getBusinessObject = _dereq_(76).getBusinessObject,
    isCasePlanModel = _dereq_(76).isCasePlanModel;

module.exports.isCollapsed = function (element) {

  if (!isCasePlanModel(element)) {

    element = getBusinessObject(element);

    var definition = element.definitionRef;
    if (is(definition, 'cmmn:PlanFragment')) {
      return !!(element && element.di && element.di.isCollapsed);
    }
  }

  return false;
};

module.exports.isPlanningTableCollapsed = function (element) {

  element = getBusinessObject(element);

  if (is(element, 'cmmn:Stage') || element.definitionRef && (is(element.definitionRef, 'cmmn:Stage') || is(element.definitionRef, 'cmmn:HumanTask'))) {
    return element.di && element.di.isPlanningTableCollapsed;
  }

  return false;
};

module.exports.isStandardEventVisible = function (element) {
  element = getBusinessObject(element);
  var cmmnElement = element.cmmnElementRef;
  return !!(is(cmmnElement, 'cmmn:OnPart') && element.isStandardEventVisible);
};

},{"76":76}],75:[function(_dereq_,module,exports){
'use strict';

var is = _dereq_(76).is;
var assign = _dereq_(254).assign;

var DEFAULT_LABEL_SIZE = module.exports.DEFAULT_LABEL_SIZE = {
  width: 90,
  height: 20
};

/**
 * Returns true if the given semantic has an external label
 *
 * @param {CmmnElement} semantic
 * @return {Boolean} true if has label
 */
module.exports.hasExternalLabel = function (semantic) {

  if (is(semantic, 'cmmn:PlanItem') || is(semantic, 'cmmn:DiscretionaryItem')) {
    semantic = semantic.definitionRef;
  }

  if (is(semantic, 'cmmndi:CMMNEdge') && semantic.cmmnElementRef) {

    if (is(semantic.cmmnElementRef, 'cmmn:OnPart')) {
      semantic = semantic.cmmnElementRef;
    }
  }

  return is(semantic, 'cmmn:EventListener') || is(semantic, 'cmmn:OnPart') || is(semantic, 'cmmn:CaseFileItem');
};

/**
 * Get the middle of a number of waypoints
 *
 * @param  {Array<Point>} waypoints
 * @return {Point} the mid point
 */
var getWaypointsMid = module.exports.getWaypointsMid = function (waypoints) {

  var mid = waypoints.length / 2 - 1;

  var first = waypoints[Math.floor(mid)];
  var second = waypoints[Math.ceil(mid + 0.01)];

  return {
    x: first.x + (second.x - first.x) / 2,
    y: first.y + (second.y - first.y) / 2
  };
};

var getExternalLabelMid = module.exports.getExternalLabelMid = function (element) {

  var bo = element.businessObject,
      di = bo.di;

  if (!di && is(bo, 'cmmndi:CMMNEdge') && bo.cmmnElementRef) {
    di = bo;
  }

  if (bo && di && di.waypoint) {
    return getWaypointsMid(di.waypoint);
  } else {
    return {
      x: element.x + element.width / 2,
      y: element.y + element.height + DEFAULT_LABEL_SIZE.height / 2
    };
  }
};

/**
 * Returns the bounds of an elements label, parsed from the elements DI or
 * generated from its bounds.
 *
 * @param {CmmnElement} semantic
 * @param {djs.model.Base} element
 */
module.exports.getExternalLabelBounds = function (semantic, element) {

  var mid,
      size,
      bounds,
      di = semantic.di || semantic,
      label = di.label;

  if (label && label.bounds) {
    bounds = label.bounds;

    size = {
      width: Math.max(DEFAULT_LABEL_SIZE.width, bounds.width),
      height: bounds.height
    };

    mid = {
      x: bounds.x + bounds.width / 2,
      y: bounds.y + bounds.height / 2
    };
  } else {

    mid = getExternalLabelMid(element);

    size = DEFAULT_LABEL_SIZE;
  }

  return assign({
    x: mid.x - size.width / 2,
    y: mid.y - size.height / 2
  }, size);
};

var hasLabelBounds = module.exports.hasLabelBounds = function (semantic) {
  return semantic && semantic.di && semantic.di.label && semantic.di.label.bounds;
};

module.exports.getLabelBounds = function (semantic) {
  if (hasLabelBounds(semantic)) {
    return semantic.di.label.bounds;
  }
};

},{"254":254,"76":76}],76:[function(_dereq_,module,exports){
'use strict';

function isInstanceOf(bo, type) {
  return !!(bo && typeof bo.$instanceOf === 'function' && bo.$instanceOf(type));
}

/**
 * Is an element of the given CMMN type?
 *
 * @param  {djs.model.Base|ModdleElement} element
 * @param  {String} type
 *
 * @return {Boolean}
 */
function is(element, type) {
  return isInstanceOf(getBusinessObject(element), type);
}

module.exports.is = is;

/**
 * Return the business object for a given element.
 *
 * @param  {djs.model.Base|ModdleElement} element
 *
 * @return {ModdleElement}
 */
function getBusinessObject(element) {
  return element && element.businessObject ? element.businessObject : element;
}

module.exports.getBusinessObject = getBusinessObject;

function isCasePlanModel(element) {
  element = getBusinessObject(element);
  return is(element, 'cmmn:Stage') && element.$parent && is(element.$parent, 'cmmn:Case');
}

module.exports.isCasePlanModel = isCasePlanModel;

function getDefinition(element) {
  var bo = getBusinessObject(element);

  if (is(element, 'cmmn:PlanItemDefinition') || is(element, 'cmmn:CaseFileItemDefinition')) {
    return bo;
  }

  return bo && bo.definitionRef;
}

module.exports.getDefinition = getDefinition;

function getDefaultControl(element) {
  var definition = getDefinition(element);
  return definition && definition.defaultControl;
}

module.exports.getDefaultControl = getDefaultControl;

function getItemControl(element) {
  element = getBusinessObject(element);
  return element && element.itemControl;
}

module.exports.getItemControl = getItemControl;

function getRule(element, rule) {
  var itemControl = getItemControl(element),
      defaultControl = getDefaultControl(element);

  if (itemControl && itemControl[rule]) {
    return itemControl[rule];
  }

  return defaultControl && defaultControl[rule];
}

function isRequired(element) {
  return !!getRule(element, 'requiredRule');
}

module.exports.isRequired = isRequired;

function isRepeatable(element) {
  return !!getRule(element, 'repetitionRule');
}

module.exports.isRepeatable = isRepeatable;

function isManualActivation(element) {
  return !!getRule(element, 'manualActivationRule');
}

module.exports.isManualActivation = isManualActivation;

function isAutoComplete(element) {
  element = getBusinessObject(element);
  var definition = getDefinition(element);
  return element.autoComplete || definition && definition.autoComplete;
}

module.exports.isAutoComplete = isAutoComplete;

function hasPlanningTable(element) {
  element = getBusinessObject(element);
  return element.planningTable || getDefinition(element) && getDefinition(element).planningTable;
}

module.exports.hasPlanningTable = hasPlanningTable;

function getName(element) {
  element = getBusinessObject(element);

  if (is(element, 'cmmndi:CMMNEdge') && element.cmmnElementRef) {
    element = element.cmmnElementRef;
  }

  var name = element.name;
  if (!name) {

    if (element.definitionRef) {
      name = element.definitionRef.name;
    }
  }

  return name;
}

module.exports.getName = getName;

/**
 * Returns the referenced sentry, if present.
 *
 * @param {djs.model.Base} criterion
 *
 * @result {ModdleElement} referenced sentry
 */
function getSentry(element) {
  var bo = getBusinessObject(element);

  if (is(bo, 'cmmn:Sentry')) {
    return bo;
  }

  return bo && bo.sentryRef;
}

module.exports.getSentry = getSentry;

function getStandardEvent(element) {
  element = getBusinessObject(element);
  return element.cmmnElementRef && element.cmmnElementRef.standardEvent;
}

module.exports.getStandardEvent = getStandardEvent;

function getStandardEvents(element) {

  if (is(element, 'cmmndi:CMMNEdge')) {
    element = getBusinessObject(element).cmmnElementRef;
  }

  if (is(element, 'cmmn:OnPart')) {

    if (is(element.exitCriterionRef, 'cmmn:ExitCriterion')) {
      return ['exit'];
    }

    return getTransitions(element.sourceRef);
  }

  return [];
}

module.exports.getStandardEvents = getStandardEvents;

function getTransitions(element) {

  element = getBusinessObject(element);

  if (is(element, 'cmmn:CaseFileItem')) {

    return ['addChild', 'addReference', 'create', 'delete', 'removeChild', 'removeReference', 'replace', 'update'];
  }

  if (is(element, 'cmmn:PlanItem') || is(element, 'cmmn:DiscretionaryItem')) {

    var definition = getDefinition(element);

    if (is(definition, 'cmmn:EventListener') || is(definition, 'cmmn:Milestone')) {

      return ['create', 'occur', 'resume', 'suspend', 'terminate'];
    }

    return ['complete', 'create', 'disable', 'enable', 'exit', 'fault', 'manualStart', 'parentResume', 'parentSuspend', 'reactivate', 'reenable', 'resume', 'start', 'suspend', 'terminate'];
  }

  if (isCasePlanModel(element)) {

    return ['close', 'complete', 'create', 'fault', 'reactivate', 'suspend', 'terminate'];
  }

  return [];
}

module.exports.getTransitions = getTransitions;

},{}],77:[function(_dereq_,module,exports){
/**
 * This file must not be changed or exchanged.
 *
 * @see http://bpmn.io/license for more information.
 */

'use strict';

var domify = _dereq_(255).domify;

var domDelegate = _dereq_(255).delegate;

// inlined ../../resources/logo.svg
var BPMNIO_LOGO_SVG = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 14.02 5.57" width="53" height="21" style="vertical-align:middle"><path fill="currentColor" d="M1.88.92v.14c0 .41-.13.68-.4.8.33.14.46.44.46.86v.33c0 .61-.33.95-.95.95H0V0h.95c.65 0 .93.3.93.92zM.63.57v1.06h.24c.24 0 .38-.1.38-.43V.98c0-.28-.1-.4-.32-.4zm0 1.63v1.22h.36c.2 0 .32-.1.32-.39v-.35c0-.37-.12-.48-.4-.48H.63zM4.18.99v.52c0 .64-.31.98-.94.98h-.3V4h-.62V0h.92c.63 0 .94.35.94.99zM2.94.57v1.35h.3c.2 0 .3-.09.3-.37v-.6c0-.29-.1-.38-.3-.38h-.3zm2.89 2.27L6.25 0h.88v4h-.6V1.12L6.1 3.99h-.6l-.46-2.82v2.82h-.55V0h.87zM8.14 1.1V4h-.56V0h.79L9 2.4V0h.56v4h-.64zm2.49 2.29v.6h-.6v-.6zM12.12 1c0-.63.33-1 .95-1 .61 0 .95.37.95 1v2.04c0 .64-.34 1-.95 1-.62 0-.95-.37-.95-1zm.62 2.08c0 .28.13.39.33.39s.32-.1.32-.4V.98c0-.29-.12-.4-.32-.4s-.33.11-.33.4z"/><path fill="currentColor" d="M0 4.53h14.02v1.04H0zM11.08 0h.63v.62h-.63zm.63 4V1h-.63v2.98z"/></svg>';

var BPMNIO_IMG = BPMNIO_LOGO_SVG;

function css(attrs) {
  return attrs.join(';');
}

var LINK_STYLES = css(['color: #404040']);

var LIGHTBOX_STYLES = css(['z-index: 1001', 'position: fixed', 'top: 0', 'left: 0', 'right: 0', 'bottom: 0']);

var BACKDROP_STYLES = css(['width: 100%', 'height: 100%', 'background: rgba(40,40,40,0.2)']);

var NOTICE_STYLES = css(['position: absolute', 'left: 50%', 'top: 40%', 'transform: translate(-50%)', 'width: 260px', 'padding: 10px', 'background: white', 'box-shadow: 0 1px 4px rgba(0,0,0,0.3)', 'font-family: Helvetica, Arial, sans-serif', 'font-size: 14px', 'display: flex', 'line-height: 1.3']);

var LIGHTBOX_MARKUP = '<div class="bjs-powered-by-lightbox" style="' + LIGHTBOX_STYLES + '">' + '<div class="backdrop" style="' + BACKDROP_STYLES + '"></div>' + '<div class="notice" style="' + NOTICE_STYLES + '">' + '<a href="https://bpmn.io" target="_blank" rel="noopener" style="margin: 15px 20px 15px 10px; align-self: center;' + LINK_STYLES + '">' + BPMNIO_IMG + '</a>' + '<span>' + 'Web-based tooling for BPMN, DMN and CMMN diagrams ' + 'powered by <a href="https://bpmn.io" target="_blank" rel="noopener">bpmn.io</a>.' + '</span>' + '</div>' + '</div>';

var lightbox;

function open() {

  if (!lightbox) {
    lightbox = domify(LIGHTBOX_MARKUP);

    domDelegate.bind(lightbox, '.backdrop', 'click', function (event) {
      document.body.removeChild(lightbox);
    });
  }

  document.body.appendChild(lightbox);
}

module.exports.open = open;

module.exports.BPMNIO_IMG = BPMNIO_IMG;

module.exports.LINK_STYLES = LINK_STYLES;

},{"255":255}],78:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _simple = _dereq_(80);

Object.defineProperty(exports, 'default', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_simple).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"80":80}],79:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CmmnModdle;

var _minDash = _dereq_(254);

var _moddle = _dereq_(260);

var _moddle2 = _interopRequireDefault(_moddle);

var _moddleXml = _dereq_(256);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A sub class of {@link Moddle} with support for import and export of CMMN 1.1 xml files.
 *
 * @class CmmnModdle
 * @extends Moddle
 *
 * @param {Object|Array} packages to use for instantiating the model
 * @param {Object} [options] additional options to pass over
 */
function CmmnModdle(packages, options) {
  _moddle2.default.call(this, packages, options);
}

CmmnModdle.prototype = Object.create(_moddle2.default.prototype);

/**
 * Instantiates a CMMN model tree from a given xml string.
 *
 * @param {String}   xmlStr
 * @param {String}   [typeName='cmmn:Definitions'] name of the root element
 * @param {Object}   [options]  options to pass to the underlying reader
 * @param {Function} done       callback that is invoked with (err, result, parseContext)
 *                              once the import completes
 */
CmmnModdle.prototype.fromXML = function (xmlStr, typeName, options, done) {

  if (!(0, _minDash.isString)(typeName)) {
    done = options;
    options = typeName;
    typeName = 'cmmn:Definitions';
  }

  if ((0, _minDash.isFunction)(options)) {
    done = options;
    options = {};
  }

  var reader = new _moddleXml.Reader((0, _minDash.assign)({ model: this, lax: true }, options));
  var rootHandler = reader.handler(typeName);

  reader.fromXML(xmlStr, rootHandler, done);
};

/**
 * Serializes a CMMN 1.1 object tree to XML.
 *
 * @param {String}   element    the root element, typically an instance of `cmmn:Definitions`
 * @param {Object}   [options]  to pass to the underlying writer
 * @param {Function} done       callback invoked with (err, xmlStr) once the import completes
 */
CmmnModdle.prototype.toXML = function (element, options, done) {

  if ((0, _minDash.isFunction)(options)) {
    done = options;
    options = {};
  }

  var writer = new _moddleXml.Writer(options);

  var result;
  var err;

  try {
    result = writer.toXML(element);
  } catch (e) {
    err = e;
  }

  return done(err, result);
};

},{"254":254,"256":256,"260":260}],80:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (additionalPackages, options) {
  var pks = (0, _minDash.assign)({}, packages, additionalPackages);

  return new _cmmnModdle2.default(pks, options);
};

var _minDash = _dereq_(254);

var _cmmnModdle = _dereq_(79);

var _cmmnModdle2 = _interopRequireDefault(_cmmnModdle);

var _cmmn = _dereq_(81);

var _cmmn2 = _interopRequireDefault(_cmmn);

var _cmmndi = _dereq_(82);

var _cmmndi2 = _interopRequireDefault(_cmmndi);

var _dc = _dereq_(83);

var _dc2 = _interopRequireDefault(_dc);

var _di = _dereq_(84);

var _di2 = _interopRequireDefault(_di);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var packages = {
  cmmn: _cmmn2.default,
  cmmndi: _cmmndi2.default,
  dc: _dc2.default,
  di: _di2.default
};

},{"254":254,"79":79,"81":81,"82":82,"83":83,"84":84}],81:[function(_dereq_,module,exports){
module.exports={
  "name": "CMMN",
  "uri": "http://www.omg.org/spec/CMMN/20151109/MODEL",
  "types": [
    {
      "name": "ApplicabilityRule",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "condition",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "contextRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "Artifact",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ]
    },
    {
      "name": "Association",
      "superClass": [
        "Artifact"
      ],
      "properties": [
        {
          "name": "associationDirection",
          "type": "AssociationDirection",
          "isAttr": true
        },
        {
          "name": "sourceRef",
          "type": "CMMNElement",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "targetRef",
          "type": "CMMNElement",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "TextAnnotation",
      "superClass": [
        "Artifact"
      ],
      "properties": [
        {
          "name": "text",
          "type": "String"
        },
        {
          "name": "textFormat",
          "default": "text/plain",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "ManualActivationRule",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "condition",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "contextRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "Case",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "caseFileModel",
          "type": "CaseFile",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "casePlanModel",
          "type": "Stage",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "caseRoles",
          "type": "CaseRoles"
        },
        {
          "name": "input",
          "type": "CaseParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "output",
          "type": "CaseParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "CaseFile",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "caseFileItems",
          "type": "CaseFileItem",
          "isMany": true
        }
      ]
    },
    {
      "name": "CaseFileItem",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "multiplicity",
          "type": "String",
          "isAttr": true,
          "default": "Unspecified"
        },
        {
          "name": "definitionRef",
          "type": "CaseFileItemDefinition",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "sourceRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "targetRefs",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true,
          "isMany": true
        },
        {
          "name": "children",
          "type": "Children",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "CaseFileItemDefinition",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "definitionType",
          "type": "String",
          "default": "http://www.omg.org/spec/CMMN/DefinitionType/Unspecified",
          "isAttr": true
        },
        {
          "name": "properties",
          "type": "Property",
          "isMany": true
        },
        {
          "name": "structureRef",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "importRef",
          "type": "Import",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "CaseFileItemOnPart",
      "superClass": [
        "OnPart"
      ],
      "properties": [
        {
          "name": "standardEvent",
          "type": "String"
        },
        {
          "name": "sourceRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "CaseParameter",
      "superClass": [
        "Parameter"
      ],
      "properties": [
        {
          "name": "bindingRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "bindingRefinement",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "CaseRoles",
      "superClass": [
        "Parameter"
      ],
      "properties": [
        {
          "name": "role",
          "type": "Role",
          "isMany": true
        }
      ]
    },
    {
      "name": "CaseTask",
      "superClass": [
        "Task"
      ],
      "properties": [
        {
          "name": "parameterMapping",
          "type": "ParameterMapping",
          "isMany": true
        },
        {
          "name": "caseRefExpression",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "caseRef",
          "type": "String",
          "isAttr": true
        }
      ]
    },
    {
      "name": "Children",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "caseFileItems",
          "type": "CaseFileItem",
          "isMany": true
        }
      ]
    },
    {
      "name": "CMMNElement",
      "isAbstract": true,
      "properties": [
        {
          "name": "id",
          "isAttr": true,
          "type": "String",
          "isId": true
        },
        {
          "name": "documentation",
          "type": "Documentation",
          "isMany": true
        },
        {
          "name": "extensionElements",
          "type": "ExtensionElements"
        },
        {
          "name": "extensionDefinitions",
          "type": "ExtensionDefinition",
          "isReference": true,
          "isMany": true
        }
      ]
    },
    {
      "name": "Definitions",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "targetNamespace",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "expressionLanguage",
          "type": "String",
          "isAttr": true,
          "default": "http://www.w3.org/1999/XPath"
        },
        {
          "name": "exporter",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "exporterVersion",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "author",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "creationDate",
          "type": "DateTime",
          "isAttr": true
        },
        {
          "name": "imports",
          "type": "Import",
          "isMany": true
        },
        {
          "name": "caseFileItemDefinitions",
          "type": "CaseFileItemDefinition",
          "isMany": true
        },
        {
          "name": "cases",
          "type": "Case",
          "isMany": true
        },
        {
          "name": "processes",
          "type": "Process",
          "isMany": true
        },
        {
          "name": "decisions",
          "type": "Decision",
          "isMany": true
        },
        {
          "name": "extensions",
          "type": "Extension",
          "isMany": true
        },
        {
          "name": "relationships",
          "type": "Relationship",
          "isMany": true
        },
        {
          "name": "artifacts",
          "type": "Artifact",
          "isMany": true
        },
        {
          "name": "CMMNDI",
          "type": "cmmndi:CMMNDI"
        }
      ]
    },
    {
      "name": "DiscretionaryItem",
      "superClass": [
        "TableItem"
      ],
      "properties": [
        {
          "name": "itemControl",
          "type": "PlanItemControl",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "definitionRef",
          "type": "PlanItemDefinition",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "entryCriteria",
          "type": "EntryCriterion",
          "isMany": true
        },
        {
          "name": "exitCriteria",
          "type": "ExitCriterion",
          "isMany": true
        }
      ]
    },
    {
      "name": "EventListener",
      "superClass": [
        "PlanItemDefinition"
      ]
    },
    {
      "name": "Expression",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "language",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "body",
          "isBody": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "HumanTask",
      "superClass": [
        "Task"
      ],
      "properties": [
        {
          "name": "planningTable",
          "type": "PlanningTable"
        },
        {
          "name": "performerRef",
          "type": "Role",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "IfPart",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "contextRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "condition",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "Import",
      "properties": [
        {
          "name": "location",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "namespace",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "importType",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "Milestone",
      "superClass": [
        "PlanItemDefinition"
      ]
    },
    {
      "name": "On",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ]
    },
    {
      "name": "OnPart",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "Parameter",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "ParameterMapping",
      "properties": [
        {
          "name": "sourceRef",
          "type": "Parameter",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "targetRef",
          "type": "Parameter",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "transformation",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "PlanFragment",
      "superClass": [
        "PlanItemDefinition"
      ],
      "properties": [
        {
          "name": "planItems",
          "type": "PlanItem",
          "isMany": true
        },
        {
          "name": "sentries",
          "type": "Sentry",
          "isMany": true
        }
      ]
    },
    {
      "name": "PlanItem",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "definitionRef",
          "type": "PlanItemDefinition",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "itemControl",
          "type": "PlanItemControl",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "entryCriteria",
          "type": "EntryCriterion",
          "isMany": true
        },
        {
          "name": "exitCriteria",
          "type": "ExitCriterion",
          "isMany": true
        }
      ]
    },
    {
      "name": "PlanItemControl",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "repetitionRule",
          "type": "RepetitionRule"
        },
        {
          "name": "requiredRule",
          "type": "RequiredRule"
        },
        {
          "name": "manualActivationRule",
          "type": "ManualActivationRule"
        }
      ]
    },
    {
      "name": "PlanItemDefinition",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "defaultControl",
          "type": "PlanItemControl",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "PlanItemOnPart",
      "superClass": [
        "OnPart"
      ],
      "properties": [
        {
          "name": "standardEvent",
          "type": "String"
        },
        {
          "name": "sourceRef",
          "type": "PlanItem",
          "isAttr": true,
          "isReference": true
        },
        {
          "name": "exitCriterionRef",
          "type": "ExitCriterion",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "PlanningTable",
      "superClass": [
        "TableItem"
      ],
      "properties": [
        {
          "name": "tableItems",
          "type": "TableItem",
          "isMany": true
        },
        {
          "name": "applicabilityRules",
          "type": "ApplicabilityRule",
          "isMany": true
        }
      ]
    },
    {
      "name": "Process",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "implementationType",
          "type": "String",
          "isAttr": true,
          "default": "http://www.omg.org/spec/CMMN/ProcessType/Unspecified"
        },
        {
          "name": "externalRef",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "input",
          "type": "ProcessParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "output",
          "type": "ProcessParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "ProcessParameter",
      "superClass": [
        "Parameter"
      ]
    },
    {
      "name": "ProcessTask",
      "superClass": [
        "Task"
      ],
      "properties": [
        {
          "name": "parameterMapping",
          "type": "ParameterMapping",
          "isMany": true
        },
        {
          "name": "processRefExpression",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "processRef",
          "type": "String",
          "isAttr": true
        }
      ]
    },
    {
      "name": "Property",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "type",
          "type": "String",
          "isAttr": true,
          "default": "http://www.omg.org/spec/CMMN/PropertyType/Unspecified"
        }
      ]
    },
    {
      "name": "RepetitionRule",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "condition",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "contextRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "RequiredRule",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "condition",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "contextRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "Role",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "Sentry",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "onParts",
          "type": "OnPart",
          "isMany": true
        },
        {
          "name": "ifPart",
          "type": "IfPart"
        },
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "Stage",
      "superClass": [
        "PlanFragment"
      ],
      "properties": [
        {
          "name": "planningTable",
          "type": "PlanningTable"
        },
        {
          "name": "planItemDefinitions",
          "type": "PlanItemDefinition",
          "isMany": true
        },
        {
          "name": "autoComplete",
          "isAttr": true,
          "type": "Boolean"
        },
        {
          "name": "exitCriteria",
          "type": "ExitCriterion",
          "isMany": true
        }
      ]
    },
    {
      "name": "TableItem",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "authorizedRoleRefs",
          "type": "Role",
          "isAttr": true,
          "isReference": true,
          "isMany": true
        },
        {
          "name": "applicabilityRuleRefs",
          "type": "ApplicabilityRule",
          "isAttr": true,
          "isReference": true,
          "isMany": true
        }
      ]
    },
    {
      "name": "Task",
      "superClass": [
        "PlanItemDefinition"
      ],
      "properties": [
        {
          "name": "input",
          "type": "CaseParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "output",
          "type": "CaseParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "isBlocking",
          "isAttr": true,
          "default": true,
          "type": "Boolean"
        }
      ]
    },
    {
      "name": "TimerEventListener",
      "superClass": [
        "EventListener"
      ],
      "properties": [
        {
          "name": "timerExpression",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "timerStart",
          "type": "StartTrigger"
        }
      ]
    },
    {
      "name": "UserEventListener",
      "superClass": [
        "EventListener"
      ],
      "properties": [
        {
          "name": "authorizedRoleRefs",
          "type": "Role",
          "isMany": true,
          "isAttr": true
        }
      ]
    },
    {
      "name": "DateTime",
      "superClass": []
    },
    {
      "name": "StartTrigger",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ]
    },
    {
      "name": "PlanItemStartTrigger",
      "superClass": [
        "StartTrigger"
      ],
      "properties": [
        {
          "name": "standardEvent",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "sourceRef",
          "type": "PlanItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "CaseFileItemStartTrigger",
      "superClass": [
        "StartTrigger"
      ],
      "properties": [
        {
          "name": "standardEvent",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "sourceRef",
          "type": "CaseFileItem",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "Extension",
      "properties": [
        {
          "name": "mustUnderstand",
          "default": false,
          "isAttr": true,
          "type": "Boolean"
        },
        {
          "name": "definition",
          "type": "ExtensionDefinition"
        }
      ]
    },
    {
      "name": "ExtensionDefinition",
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "extensionAttributeDefinitions",
          "type": "ExtensionAttributeDefinition",
          "isMany": true
        }
      ]
    },
    {
      "name": "ExtensionAttributeDefinition",
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "type",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "isReference",
          "isAttr": true,
          "default": false,
          "type": "Boolean"
        }
      ]
    },
    {
      "name": "ExtensionElements",
      "properties": [
        {
          "name": "valueRef",
          "isAttr": true,
          "isReference": true,
          "type": "Element"
        },
        {
          "name": "values",
          "type": "Element",
          "isMany": true
        },
        {
          "name": "extensionAttributeDefinition",
          "type": "ExtensionAttributeDefinition",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "Relationship",
      "properties": [
        {
          "name": "type",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "direction",
          "type": "RelationshipDirection",
          "isAttr": true
        },
        {
          "name": "source",
          "isMany": true,
          "type": "Element"
        },
        {
          "name": "target",
          "isMany": true,
          "type": "Element"
        }
      ]
    },
    {
      "name": "Documentation",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "text",
          "type": "String",
          "isBody": true
        },
        {
          "name": "textFormat",
          "default": "text/plain",
          "isAttr": true,
          "type": "String"
        }
      ]
    },
    {
      "name": "DecisionTask",
      "superClass": [
        "Task"
      ],
      "properties": [
        {
          "name": "mappings",
          "type": "ParameterMapping",
          "isMany": true
        },
        {
          "name": "decisionRef",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "decisionRefExpression",
          "type": "Expression",
          "xml": {
            "serialize": "property"
          }
        }
      ]
    },
    {
      "name": "Decision",
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "implementationType",
          "type": "String",
          "isAttr": true,
          "default": "http://www.omg.org/spec/CMMN/DecisionType/Unspecified"
        },
        {
          "name": "input",
          "type": "DecisionParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "output",
          "type": "DecisionParameter",
          "isMany": true,
          "xml": {
            "serialize": "property"
          }
        },
        {
          "name": "externalRef",
          "type": "String",
          "isAttr": true
        }
      ]
    },
    {
      "name": "DecisionParameter",
      "superClass": [
        "Parameter"
      ]
    },
    {
      "name": "Criterion",
      "isAbstract": true,
      "superClass": [
        "CMMNElement"
      ],
      "properties": [
        {
          "name": "name",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "sentryRef",
          "type": "Sentry",
          "isAttr": true,
          "isReference": true
        }
      ]
    },
    {
      "name": "EntryCriterion",
      "superClass": [
        "Criterion"
      ]
    },
    {
      "name": "ExitCriterion",
      "superClass": [
        "Criterion"
      ]
    }
  ],
  "emumerations": [
    {
      "name": "AssociationDirection",
      "literalValues": [
        {
          "name": "None"
        },
        {
          "name": "One"
        },
        {
          "name": "Both"
        }
      ]
    },
    {
      "name": "CaseFileItemTransition",
      "literalValues": [
        {
          "name": "addChild"
        },
        {
          "name": "addReference"
        },
        {
          "name": "create"
        },
        {
          "name": "delete"
        },
        {
          "name": "removeChild"
        },
        {
          "name": "removeReference"
        },
        {
          "name": "replace"
        },
        {
          "name": "update"
        }
      ]
    },
    {
      "name": "MultiplicityEnum",
      "literalValues": [
        {
          "name": "ZeroOrOne"
        },
        {
          "name": "ZeroOrMore"
        },
        {
          "name": "ExactlyOne"
        },
        {
          "name": "OneOrMore"
        },
        {
          "name": "Unspecified"
        },
        {
          "name": "Unknown"
        }
      ]
    },
    {
      "name": "PlanItemTransition",
      "literalValues": [
        {
          "name": "close"
        },
        {
          "name": "complete"
        },
        {
          "name": "create"
        },
        {
          "name": "disable"
        },
        {
          "name": "enable"
        },
        {
          "name": "exit"
        },
        {
          "name": "fault"
        },
        {
          "name": "manualStart"
        },
        {
          "name": "occur"
        },
        {
          "name": "parentResume"
        },
        {
          "name": "parentSuspend"
        },
        {
          "name": "reactivate"
        },
        {
          "name": "reenable"
        },
        {
          "name": "resume"
        },
        {
          "name": "start"
        },
        {
          "name": "suspend"
        },
        {
          "name": "terminate"
        }
      ]
    },
    {
      "name": "RelationshipDirection",
      "literalValues": [
        {
          "name": "None"
        },
        {
          "name": "Forward"
        },
        {
          "name": "Backward"
        },
        {
          "name": "Both"
        }
      ]
    }
  ],
  "associations": [],
  "xml": {
    "tagAlias": "lowerCase",
    "typePrefix": "t"
  },
  "prefix": "cmmn"
}
},{}],82:[function(_dereq_,module,exports){
module.exports={
  "name": "CMMNDI",
  "uri": "http://www.omg.org/spec/CMMN/20151109/CMMNDI",
  "types": [
  	{
  	  "name": "CMMNDI",
  	  "properties": [
  	    {
  	      "name": "diagrams",
  	      "type": "CMMNDiagram",
  	      "isMany": true
  	    },
  	  	{
  	  	  "name": "styles",
  	  	  "type": "CMMNStyle",
  	  	  "isMany": true
  	  	}
  	  ]
  	},

    {
      "name": "CMMNDiagram",
      "properties": [
        {
          "name": "cmmnElementRef",
          "isAttr": true,
          "type": "cmmn:CMMNElement",
          "isReference": true
        },
        {
          "name": "Size",
          "type": "dc:Dimension",
          "xml": {
            "serialize": "xsi:type"
          }
        },
        {
          "name": "diagramElements",
          "type": "CMMNDiagramElement",
          "isMany": true
        }
      ],
      "superClass": [
        "di:Diagram"
      ]
    },

    {
      "name": "CMMNDiagramElement",
      "superClass": [
        "di:DiagramElement"
      ]
    },

    {
      "name": "CMMNShape",
      "properties": [
        {
          "name": "cmmnElementRef",
          "isAttr": true,
          "isReference": true,
          "type": "cmmn:CMMNElement"
        },
        {
          "name": "label",
          "type": "CMMNLabel"
        },
        {
          "name": "isCollapsed",
          "isAttr": true,
          "type": "Boolean"
        },
        {
          "name": "isPlanningTableCollapsed",
          "isAttr": true,
          "type": "Boolean"
        }
      ],
      "superClass": [
        "CMMNDiagramElement", "di:Shape"
      ]
    },
    {
      "name": "CMMNEdge",
      "properties": [
        {
          "name": "label",
          "type": "CMMNLabel"
        },
        {
          "name": "cmmnElementRef",
          "isAttr": true,
          "isReference": true,
          "type": "cmmn:CMMNElement"
        },
        {
          "name": "sourceCMMNElementRef",
          "isAttr": true,
          "isReference": true,
          "type": "cmmn:CMMNElement"
        },
        {
          "name": "targetCMMNElementRef",
          "isAttr": true,
          "isReference": true,
          "type": "cmmn:CMMNElement"
        },
        {
          "name": "isStandardEventVisible",
          "type": "Boolean",
          "isAttr": true
        }
      ],
      "superClass": [
        "CMMNDiagramElement", "di:Edge"
      ]
    },
    {
      "name": "CMMNLabel",
      "superClass": [
        "di:Shape"
      ]
    },
    {
      "name": "CMMNStyle",
      "properties": [
        {
          "name": "FillColor",
          "type": "dc:Color",
          "xml": {
            "serialize": "xsi:type"
          }
        },
        {
          "name": "StrokeColor",
          "type": "dc:Color",
          "xml": {
            "serialize": "xsi:type"
          }
        },
        {
          "name": "FontColor",
          "type": "dc:Color",
          "xml": {
            "serialize": "xsi:type"
          }
        },
        {
          "name": "fontFamily",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "fontSize",
          "type": "Real",
          "isAttr": true
        },
        {
          "name": "fontItalic",
          "type": "Boolean",
          "isAttr": true
        },
        {
          "name": "fontBold",
          "type": "Boolean",
          "isAttr": true
        },
        {
          "name": "fontUnderline",
          "type": "Boolean",
          "isAttr": true
        },
        {
          "name": "fontStrikeThrough",
          "type": "Boolean",
          "isAttr": true
        }
      ],
      "superClass": [
        "di:Style"
      ]
    }
  ],
  "associations": [],
  "prefix": "cmmndi"
}
},{}],83:[function(_dereq_,module,exports){
module.exports={
  "name": "DC",
  "uri": "http://www.omg.org/spec/CMMN/20151109/DC",
  "types": [
    {
      "name": "rgb"
    },
    {
      "name": "Real"
    },
  	{
  	  "name": "Color",
  	  "properties" : [
  	  	{
  	  	  "name": "red",
  	  	  "type": "rgb",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "green",
  	  	  "type": "rgb",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "blue",
  	  	  "type": "rgb",
  	  	  "isAttr": true
  	  	}
  	  ]
  	},
  	
  	{
  	  "name": "Point",
  	  "properties" : [
  	  	{
  	  	  "name": "x",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "y",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	}
  	  ]
  	},
  	
  	{
  	  "name": "Dimension",
  	  "properties" : [
  	  	{
  	  	  "name": "width",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "height",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	}
  	  ]
  	},
  	
  	{
  	  "name": "Bounds",
  	  "properties" : [
  	  	{
  	  	  "name": "x",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "y",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "width",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	},
  	  	{
  	  	  "name": "height",
  	  	  "type": "Real",
  	  	  "isAttr": true
  	  	}
  	  ]
  	}
  ],
  "prefix": "dc",
  "associations": []
}
},{}],84:[function(_dereq_,module,exports){
module.exports={
  "name": "DI",
  "uri": "http://www.omg.org/spec/CMMN/20151109/DI",
  "types": [
    {
      "name": "DiagramElement",
      "isAbstract": true,
      "properties": [
        {
          "name": "extension",
          "type": "Extension"
        },
        {
          "name": "style",
          "type": "Style"
        },
        {
          "name": "sharedStyle",
          "type": "Style",
          "isReference": true,
          "isAttr": true
        },
        {
          "name": "id",
          "type": "String",
          "isAttr": true,
          "isId": true
        }
      ]
    },

    {
      "name": "Edge",
      "isAbstract": true,
      "superClass": [
        "DiagramElement"
      ],
      "properties": [
        {
          "name": "waypoint",
          "isMany": true,
          "type": "dc:Point",
          "xml": {
            "serialize": "xsi:type"
          }
        }
      ]
    },
    {
      "name": "Diagram",
      "isAbstract": true,
      "superClass": [
        "DiagramElement"
      ],
      "properties": [
        {
          "name": "name",
          "type": "String",
          "isAttr": true
        },
        {
          "name": "documentation",
          "isAttr": true,
          "type": "String"
        },
        {
          "name": "resolution",
          "isAttr": true,
          "default": 300,
          "type": "double"
        }
      ]
    },
    {
      "name": "Shape",
      "isAbstract": true,
      "superClass": [
        "DiagramElement"
      ],
      "properties": [
        {
          "name": "bounds",
          "type": "dc:Bounds"
        }
      ]
    },

    {
      "name": "Style",
      "isAbstract": true,
      "properties": [
        {
          "name": "extension",
          "type": "Extension"
        },
        {
          "name": "id",
          "type": "String",
          "isAttr": true,
          "isId": true
        }
      ]
    },

    {
      "name": "Extension",
      "properties": [
        {
          "name": "values",
          "type": "Element",
          "isMany": true
        }
      ]
    }
  ],
  "associations": [],
  "prefix": "di",
  "xml": {
    "tagAlias": "lowerCase"
  }
}
},{}],85:[function(_dereq_,module,exports){
(function (global){
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/*! https://mths.be/cssescape v1.5.1 by @mathias | MIT license */
;(function (root, factory) {
	// https://github.com/umdjs/umd/blob/master/returnExports.js
	if ((typeof exports === 'undefined' ? 'undefined' : _typeof(exports)) == 'object') {
		// For Node.js.
		module.exports = factory(root);
	} else if (typeof define == 'function' && define.amd) {
		// For AMD. Register as an anonymous module.
		define([], factory.bind(root, root));
	} else {
		// For browser globals (not exposing the function separately).
		factory(root);
	}
})(typeof global != 'undefined' ? global : undefined, function (root) {

	if (root.CSS && root.CSS.escape) {
		return root.CSS.escape;
	}

	// https://drafts.csswg.org/cssom/#serialize-an-identifier
	var cssEscape = function cssEscape(value) {
		if (arguments.length == 0) {
			throw new TypeError('`CSS.escape` requires an argument.');
		}
		var string = String(value);
		var length = string.length;
		var index = -1;
		var codeUnit;
		var result = '';
		var firstCodeUnit = string.charCodeAt(0);
		while (++index < length) {
			codeUnit = string.charCodeAt(index);
			// Note: there’s no need to special-case astral symbols, surrogate
			// pairs, or lone surrogates.

			// If the character is NULL (U+0000), then the REPLACEMENT CHARACTER
			// (U+FFFD).
			if (codeUnit == 0x0000) {
				result += '\uFFFD';
				continue;
			}

			if (
			// If the character is in the range [\1-\1F] (U+0001 to U+001F) or is
			// U+007F, […]
			codeUnit >= 0x0001 && codeUnit <= 0x001F || codeUnit == 0x007F ||
			// If the character is the first character and is in the range [0-9]
			// (U+0030 to U+0039), […]
			index == 0 && codeUnit >= 0x0030 && codeUnit <= 0x0039 ||
			// If the character is the second character and is in the range [0-9]
			// (U+0030 to U+0039) and the first character is a `-` (U+002D), […]
			index == 1 && codeUnit >= 0x0030 && codeUnit <= 0x0039 && firstCodeUnit == 0x002D) {
				// https://drafts.csswg.org/cssom/#escape-a-character-as-code-point
				result += '\\' + codeUnit.toString(16) + ' ';
				continue;
			}

			if (
			// If the character is the first character and is a `-` (U+002D), and
			// there is no second character, […]
			index == 0 && length == 1 && codeUnit == 0x002D) {
				result += '\\' + string.charAt(index);
				continue;
			}

			// If the character is not handled by one of the above rules and is
			// greater than or equal to U+0080, is `-` (U+002D) or `_` (U+005F), or
			// is in one of the ranges [0-9] (U+0030 to U+0039), [A-Z] (U+0041 to
			// U+005A), or [a-z] (U+0061 to U+007A), […]
			if (codeUnit >= 0x0080 || codeUnit == 0x002D || codeUnit == 0x005F || codeUnit >= 0x0030 && codeUnit <= 0x0039 || codeUnit >= 0x0041 && codeUnit <= 0x005A || codeUnit >= 0x0061 && codeUnit <= 0x007A) {
				// the character itself
				result += string.charAt(index);
				continue;
			}

			// Otherwise, the escaped character.
			// https://drafts.csswg.org/cssom/#escape-a-character
			result += '\\' + string.charAt(index);
		}
		return result;
	};

	if (!root.CSS) {
		root.CSS = {};
	}

	root.CSS.escape = cssEscape;
	return cssEscape;
});

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{}],86:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _interactionEvents = _dereq_(139);

var _interactionEvents2 = _interopRequireDefault(_interactionEvents);

var _DirectEditing = _dereq_(87);

var _DirectEditing2 = _interopRequireDefault(_DirectEditing);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_interactionEvents2.default],
  __init__: ['directEditing'],
  directEditing: ['type', _DirectEditing2.default]
};

},{"139":139,"87":87}],87:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DirectEditing;

var _minDash = _dereq_(254);

var _TextBox = _dereq_(88);

var _TextBox2 = _interopRequireDefault(_TextBox);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A direct editing component that allows users
 * to edit an elements text directly in the diagram
 *
 * @param {EventBus} eventBus the event bus
 */
function DirectEditing(eventBus, canvas) {

  this._eventBus = eventBus;

  this._providers = [];
  this._textbox = new _TextBox2.default({
    container: canvas.getContainer(),
    keyHandler: (0, _minDash.bind)(this._handleKey, this),
    resizeHandler: (0, _minDash.bind)(this._handleResize, this)
  });
}

DirectEditing.$inject = ['eventBus', 'canvas'];

/**
 * Register a direct editing provider

 * @param {Object} provider the provider, must expose an #activate(element) method that returns
 *                          an activation context ({ bounds: {x, y, width, height }, text }) if
 *                          direct editing is available for the given element.
 *                          Additionally the provider must expose a #update(element, value) method
 *                          to receive direct editing updates.
 */
DirectEditing.prototype.registerProvider = function (provider) {
  this._providers.push(provider);
};

/**
 * Returns true if direct editing is currently active
 *
 * @return {Boolean}
 */
DirectEditing.prototype.isActive = function () {
  return !!this._active;
};

/**
 * Cancel direct editing, if it is currently active
 */
DirectEditing.prototype.cancel = function () {
  if (!this._active) {
    return;
  }

  this._fire('cancel');
  this.close();
};

DirectEditing.prototype._fire = function (event, context) {
  this._eventBus.fire('directEditing.' + event, context || { active: this._active });
};

DirectEditing.prototype.close = function () {
  this._textbox.destroy();

  this._fire('deactivate');

  this._active = null;

  this.resizable = undefined;
};

DirectEditing.prototype.complete = function () {

  var active = this._active;

  if (!active) {
    return;
  }

  var containerBounds,
      previousBounds = active.context.bounds,
      newBounds = this.$textbox.getBoundingClientRect(),
      newText = this.getValue(),
      previousText = active.context.text;

  if (newText !== previousText || newBounds.height !== previousBounds.height || newBounds.width !== previousBounds.width) {
    containerBounds = this._textbox.container.getBoundingClientRect();

    active.provider.update(active.element, newText, active.context.text, {
      x: newBounds.left - containerBounds.left,
      y: newBounds.top - containerBounds.top,
      width: newBounds.width,
      height: newBounds.height
    });
  }

  this._fire('complete');

  this.close();
};

DirectEditing.prototype.getValue = function () {
  return this._textbox.getValue();
};

DirectEditing.prototype._handleKey = function (e) {

  // stop bubble
  e.stopPropagation();

  var key = e.keyCode || e.charCode;

  // ESC
  if (key === 27) {
    e.preventDefault();
    return this.cancel();
  }

  // Enter
  if (key === 13 && !e.shiftKey) {
    e.preventDefault();
    return this.complete();
  }
};

DirectEditing.prototype._handleResize = function (event) {
  this._fire('resize', event);
};

/**
 * Activate direct editing on the given element
 *
 * @param {Object} ElementDescriptor the descriptor for a shape or connection
 * @return {Boolean} true if the activation was possible
 */
DirectEditing.prototype.activate = function (element) {
  if (this.isActive()) {
    this.cancel();
  }

  // the direct editing context
  var context;

  var provider = (0, _minDash.find)(this._providers, function (p) {
    return (context = p.activate(element)) ? p : null;
  });

  // check if activation took place
  if (context) {
    this.$textbox = this._textbox.create(context.bounds, context.style, context.text, context.options);

    this._active = {
      element: element,
      context: context,
      provider: provider
    };

    if (context.options && context.options.resizable) {
      this.resizable = true;
    }

    this._fire('activate');
  }

  return !!context;
};

},{"254":254,"88":88}],88:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TextBox;

var _minDash = _dereq_(254);

var _minDom = _dereq_(255);

var min = Math.min,
    max = Math.max;

function preventDefault(e) {
  e.preventDefault();
}

function stopPropagation(e) {
  e.stopPropagation();
}

function isTextNode(node) {
  return node.nodeType === Node.TEXT_NODE;
}

function toArray(nodeList) {
  return [].slice.call(nodeList);
}

/**
 * Initializes a container for a content editable div.
 *
 * Structure:
 *
 * container
 *   parent
 *     content
 *     resize-handle
 *
 * @param {object} options
 * @param {DOMElement} options.container The DOM element to append the contentContainer to
 * @param {Function} options.keyHandler Handler for key events
 * @param {Function} options.resizeHandler Handler for resize events
 */
function TextBox(options) {
  this.container = options.container;

  this.parent = (0, _minDom.domify)('<div class="djs-direct-editing-parent">' + '<div class="djs-direct-editing-content" contenteditable="true"></div>' + '</div>');

  this.content = (0, _minDom.query)('[contenteditable]', this.parent);

  this.keyHandler = options.keyHandler || function () {};
  this.resizeHandler = options.resizeHandler || function () {};

  this.autoResize = (0, _minDash.bind)(this.autoResize, this);
  this.handlePaste = (0, _minDash.bind)(this.handlePaste, this);
}

/**
 * Create a text box with the given position, size, style and text content
 *
 * @param {Object} bounds
 * @param {Number} bounds.x absolute x position
 * @param {Number} bounds.y absolute y position
 * @param {Number} [bounds.width] fixed width value
 * @param {Number} [bounds.height] fixed height value
 * @param {Number} [bounds.maxWidth] maximum width value
 * @param {Number} [bounds.maxHeight] maximum height value
 * @param {Number} [bounds.minWidth] minimum width value
 * @param {Number} [bounds.minHeight] minimum height value
 * @param {Object} [style]
 * @param {String} value text content
 *
 * @return {DOMElement} The created content DOM element
 */
TextBox.prototype.create = function (bounds, style, value, options) {
  var self = this;

  var parent = this.parent,
      content = this.content,
      container = this.container;

  options = this.options = options || {};

  style = this.style = style || {};

  var parentStyle = (0, _minDash.pick)(style, ['width', 'height', 'maxWidth', 'maxHeight', 'minWidth', 'minHeight', 'left', 'top', 'backgroundColor', 'position', 'overflow', 'border', 'wordWrap', 'textAlign', 'outline', 'transform']);

  (0, _minDash.assign)(parent.style, {
    width: bounds.width + 'px',
    height: bounds.height + 'px',
    maxWidth: bounds.maxWidth + 'px',
    maxHeight: bounds.maxHeight + 'px',
    minWidth: bounds.minWidth + 'px',
    minHeight: bounds.minHeight + 'px',
    left: bounds.x + 'px',
    top: bounds.y + 'px',
    backgroundColor: '#ffffff',
    position: 'absolute',
    overflow: 'visible',
    border: '1px solid #ccc',
    boxSizing: 'border-box',
    wordWrap: 'normal',
    textAlign: 'center',
    outline: 'none'
  }, parentStyle);

  var contentStyle = (0, _minDash.pick)(style, ['fontFamily', 'fontSize', 'fontWeight', 'lineHeight', 'padding', 'paddingTop', 'paddingRight', 'paddingBottom', 'paddingLeft']);

  (0, _minDash.assign)(content.style, {
    boxSizing: 'border-box',
    width: '100%',
    outline: 'none',
    wordWrap: 'break-word'
  }, contentStyle);

  if (options.centerVertically) {
    (0, _minDash.assign)(content.style, {
      position: 'absolute',
      top: '50%',
      transform: 'translate(0, -50%)'
    }, contentStyle);
  }

  content.innerText = value;

  _minDom.event.bind(content, 'keydown', this.keyHandler);
  _minDom.event.bind(content, 'mousedown', stopPropagation);
  _minDom.event.bind(content, 'paste', self.handlePaste);

  if (options.autoResize) {
    _minDom.event.bind(content, 'input', this.autoResize);
  }

  if (options.resizable) {
    this.resizable(style);
  }

  container.appendChild(parent);

  // set selection to end of text
  this.setSelection(content.lastChild, content.lastChild && content.lastChild.length);

  return parent;
};

/**
 * Intercept paste events to remove formatting from pasted text.
 */
TextBox.prototype.handlePaste = function (e) {
  var options = this.options,
      style = this.style;

  e.preventDefault();

  var text;

  if (e.clipboardData) {

    // Chrome, Firefox, Safari
    text = e.clipboardData.getData('text/plain');
  } else {

    // Internet Explorer
    text = window.clipboardData.getData('Text');
  }

  this.insertText(text);

  if (options.autoResize) {
    var hasResized = this.autoResize(style);

    if (hasResized) {
      this.resizeHandler(hasResized);
    }
  }
};

TextBox.prototype.insertText = function (text) {

  // insertText command not supported by Internet Explorer
  var success = document.execCommand('insertText', false, text);

  if (success) {
    return;
  }

  this._insertTextIE(text);
};

TextBox.prototype._insertTextIE = function (text) {

  // Internet Explorer
  var range = this.getSelection(),
      startContainer = range.startContainer,
      endContainer = range.endContainer,
      startOffset = range.startOffset,
      endOffset = range.endOffset,
      commonAncestorContainer = range.commonAncestorContainer;

  var childNodesArray = toArray(commonAncestorContainer.childNodes);

  var container, offset;

  if (isTextNode(commonAncestorContainer)) {
    var containerTextContent = startContainer.textContent;

    startContainer.textContent = containerTextContent.substring(0, startOffset) + text + containerTextContent.substring(endOffset);

    container = startContainer;
    offset = startOffset + text.length;
  } else if (startContainer === this.content && endContainer === this.content) {
    var textNode = document.createTextNode(text);

    this.content.insertBefore(textNode, childNodesArray[startOffset]);

    container = textNode;
    offset = textNode.textContent.length;
  } else {
    var startContainerChildIndex = childNodesArray.indexOf(startContainer),
        endContainerChildIndex = childNodesArray.indexOf(endContainer);

    childNodesArray.forEach(function (childNode, index) {

      if (index === startContainerChildIndex) {
        childNode.textContent = startContainer.textContent.substring(0, startOffset) + text + endContainer.textContent.substring(endOffset);
      } else if (index > startContainerChildIndex && index <= endContainerChildIndex) {
        (0, _minDom.remove)(childNode);
      }
    });

    container = startContainer;
    offset = startOffset + text.length;
  }

  if (container && offset !== undefined) {

    // is necessary in Internet Explorer
    setTimeout(function () {
      self.setSelection(container, offset);
    });
  }
};

/**
 * Automatically resize element vertically to fit its content.
 */
TextBox.prototype.autoResize = function () {
  var parent = this.parent,
      content = this.content;

  var fontSize = parseInt(this.style.fontSize) || 12;

  if (content.scrollHeight > parent.offsetHeight || content.scrollHeight < parent.offsetHeight - fontSize) {
    var bounds = parent.getBoundingClientRect();

    var height = content.scrollHeight;
    parent.style.height = height + 'px';

    this.resizeHandler({
      width: bounds.width,
      height: bounds.height,
      dx: 0,
      dy: height - bounds.height
    });
  }
};

/**
 * Make an element resizable by adding a resize handle.
 */
TextBox.prototype.resizable = function () {
  var self = this;

  var parent = this.parent,
      resizeHandle = this.resizeHandle;

  var minWidth = parseInt(this.style.minWidth) || 0,
      minHeight = parseInt(this.style.minHeight) || 0,
      maxWidth = parseInt(this.style.maxWidth) || Infinity,
      maxHeight = parseInt(this.style.maxHeight) || Infinity;

  if (!resizeHandle) {
    resizeHandle = this.resizeHandle = (0, _minDom.domify)('<div class="djs-direct-editing-resize-handle"></div>');

    var startX, startY, startWidth, startHeight;

    var onMouseDown = function onMouseDown(e) {
      preventDefault(e);
      stopPropagation(e);

      startX = e.clientX;
      startY = e.clientY;

      var bounds = parent.getBoundingClientRect();

      startWidth = bounds.width;
      startHeight = bounds.height;

      _minDom.event.bind(document, 'mousemove', onMouseMove);
      _minDom.event.bind(document, 'mouseup', onMouseUp);
    };

    var onMouseMove = function onMouseMove(e) {
      preventDefault(e);
      stopPropagation(e);

      var newWidth = min(max(startWidth + e.clientX - startX, minWidth), maxWidth);
      var newHeight = min(max(startHeight + e.clientY - startY, minHeight), maxHeight);

      parent.style.width = newWidth + 'px';
      parent.style.height = newHeight + 'px';

      self.resizeHandler({
        width: startWidth,
        height: startHeight,
        dx: e.clientX - startX,
        dy: e.clientY - startY
      });
    };

    var onMouseUp = function onMouseUp(e) {
      preventDefault(e);
      stopPropagation(e);

      _minDom.event.unbind(document, 'mousemove', onMouseMove, false);
      _minDom.event.unbind(document, 'mouseup', onMouseUp, false);
    };

    _minDom.event.bind(resizeHandle, 'mousedown', onMouseDown);
  }

  (0, _minDash.assign)(resizeHandle.style, {
    position: 'absolute',
    bottom: '0px',
    right: '0px',
    cursor: 'nwse-resize',
    width: '0',
    height: '0',
    borderTop: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid transparent',
    borderRight: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid #ccc',
    borderBottom: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid #ccc',
    borderLeft: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid transparent'
  });

  parent.appendChild(resizeHandle);
};

/**
 * Clear content and style of the textbox, unbind listeners and
 * reset CSS style.
 */
TextBox.prototype.destroy = function () {
  var parent = this.parent,
      content = this.content,
      resizeHandle = this.resizeHandle;

  // clear content
  content.innerText = '';

  // clear styles
  parent.removeAttribute('style');
  content.removeAttribute('style');

  _minDom.event.unbind(content, 'keydown', this.keyHandler);
  _minDom.event.unbind(content, 'mousedown', stopPropagation);
  _minDom.event.unbind(content, 'input', this.autoResize);
  _minDom.event.unbind(content, 'paste', this.handlePaste);

  if (resizeHandle) {
    resizeHandle.removeAttribute('style');

    (0, _minDom.remove)(resizeHandle);
  }

  (0, _minDom.remove)(parent);
};

TextBox.prototype.getValue = function () {
  return this.content.innerText.trim();
};

TextBox.prototype.getSelection = function () {
  var selection = window.getSelection(),
      range = selection.getRangeAt(0);

  return range;
};

TextBox.prototype.setSelection = function (container, offset) {
  var range = document.createRange();

  if (container === null) {
    range.selectNodeContents(this.content);
  } else {
    range.setStart(container, offset);
    range.setEnd(container, offset);
  }

  var selection = window.getSelection();

  selection.removeAllRanges();
  selection.addRange(range);
};

},{"254":254,"255":255}],89:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _Diagram = _dereq_(90);

Object.defineProperty(exports, 'default', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_Diagram).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"90":90}],90:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Diagram;

var _didi = _dereq_(250);

var _core = _dereq_(99);

var _core2 = _interopRequireDefault(_core);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Bootstrap an injector from a list of modules, instantiating a number of default components
 *
 * @ignore
 * @param {Array<didi.Module>} bootstrapModules
 *
 * @return {didi.Injector} a injector to use to access the components
 */
function bootstrap(bootstrapModules) {

  var modules = [],
      components = [];

  function hasModule(m) {
    return modules.indexOf(m) >= 0;
  }

  function addModule(m) {
    modules.push(m);
  }

  function visit(m) {
    if (hasModule(m)) {
      return;
    }

    (m.__depends__ || []).forEach(visit);

    if (hasModule(m)) {
      return;
    }

    addModule(m);

    (m.__init__ || []).forEach(function (c) {
      components.push(c);
    });
  }

  bootstrapModules.forEach(visit);

  var injector = new _didi.Injector(modules);

  components.forEach(function (c) {

    try {
      // eagerly resolve component (fn or string)
      injector[typeof c === 'string' ? 'get' : 'invoke'](c);
    } catch (e) {
      console.error('Failed to instantiate component');
      console.error(e.stack);

      throw e;
    }
  });

  return injector;
}

/**
 * Creates an injector from passed options.
 *
 * @ignore
 * @param  {Object} options
 * @return {didi.Injector}
 */
function createInjector(options) {

  options = options || {};

  var configModule = {
    'config': ['value', options]
  };

  var modules = [configModule, _core2.default].concat(options.modules || []);

  return bootstrap(modules);
}

/**
 * The main diagram-js entry point that bootstraps the diagram with the given
 * configuration.
 *
 * To register extensions with the diagram, pass them as Array<didi.Module> to the constructor.
 *
 * @class djs.Diagram
 * @memberOf djs
 * @constructor
 *
 * @example
 *
 * <caption>Creating a plug-in that logs whenever a shape is added to the canvas.</caption>
 *
 * // plug-in implemenentation
 * function MyLoggingPlugin(eventBus) {
 *   eventBus.on('shape.added', function(event) {
 *     console.log('shape ', event.shape, ' was added to the diagram');
 *   });
 * }
 *
 * // export as module
 * export default {
 *   __init__: [ 'myLoggingPlugin' ],
 *     myLoggingPlugin: [ 'type', MyLoggingPlugin ]
 * };
 *
 *
 * // instantiate the diagram with the new plug-in
 *
 * import MyLoggingModule from 'path-to-my-logging-plugin';
 *
 * var diagram = new Diagram({
 *   modules: [
 *     MyLoggingModule
 *   ]
 * });
 *
 * diagram.invoke([ 'canvas', function(canvas) {
 *   // add shape to drawing canvas
 *   canvas.addShape({ x: 10, y: 10 });
 * });
 *
 * // 'shape ... was added to the diagram' logged to console
 *
 * @param {Object} options
 * @param {Array<didi.Module>} [options.modules] external modules to instantiate with the diagram
 * @param {didi.Injector} [injector] an (optional) injector to bootstrap the diagram with
 */
function Diagram(options, injector) {

  // create injector unless explicitly specified
  this.injector = injector = injector || createInjector(options);

  // API

  /**
   * Resolves a diagram service
   *
   * @method Diagram#get
   *
   * @param {String} name the name of the diagram service to be retrieved
   * @param {Boolean} [strict=true] if false, resolve missing services to null
   */
  this.get = injector.get;

  /**
   * Executes a function into which diagram services are injected
   *
   * @method Diagram#invoke
   *
   * @param {Function|Object[]} fn the function to resolve
   * @param {Object} locals a number of locals to use to resolve certain dependencies
   */
  this.invoke = injector.invoke;

  // init

  // indicate via event


  /**
   * An event indicating that all plug-ins are loaded.
   *
   * Use this event to fire other events to interested plug-ins
   *
   * @memberOf Diagram
   *
   * @event diagram.init
   *
   * @example
   *
   * eventBus.on('diagram.init', function() {
   *   eventBus.fire('my-custom-event', { foo: 'BAR' });
   * });
   *
   * @type {Object}
   */
  this.get('eventBus').fire('diagram.init');
}

/**
 * Destroys the diagram
 *
 * @method  Diagram#destroy
 */
Diagram.prototype.destroy = function () {
  this.get('eventBus').fire('diagram.destroy');
};

/**
 * Clear the diagram, removing all contents.
 */
Diagram.prototype.clear = function () {
  this.get('eventBus').fire('diagram.clear');
};

},{"250":250,"99":99}],91:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CommandInterceptor;

var _minDash = _dereq_(254);

var DEFAULT_PRIORITY = 1000;

/**
 * A utility that can be used to plug-in into the command execution for
 * extension and/or validation.
 *
 * @param {EventBus} eventBus
 *
 * @example
 *
 * import inherits from 'inherits';
 *
 * import CommandInterceptor from 'diagram-js/lib/command/CommandInterceptor';
 *
 * function CommandLogger(eventBus) {
 *   CommandInterceptor.call(this, eventBus);
 *
 *   this.preExecute(function(event) {
 *     console.log('command pre-execute', event);
 *   });
 * }
 *
 * inherits(CommandLogger, CommandInterceptor);
 *
 */
function CommandInterceptor(eventBus) {
  this._eventBus = eventBus;
}

CommandInterceptor.$inject = ['eventBus'];

function unwrapEvent(fn, that) {
  return function (event) {
    return fn.call(that || null, event.context, event.command, event);
  };
}

/**
 * Register an interceptor for a command execution
 *
 * @param {String|Array<String>} [events] list of commands to register on
 * @param {String} [hook] command hook, i.e. preExecute, executed to listen on
 * @param {Number} [priority] the priority on which to hook into the execution
 * @param {Function} handlerFn interceptor to be invoked with (event)
 * @param {Boolean} unwrap if true, unwrap the event and pass (context, command, event) to the
 *                          listener instead
 * @param {Object} [that] Pass context (`this`) to the handler function
 */
CommandInterceptor.prototype.on = function (events, hook, priority, handlerFn, unwrap, that) {

  if ((0, _minDash.isFunction)(hook) || (0, _minDash.isNumber)(hook)) {
    that = unwrap;
    unwrap = handlerFn;
    handlerFn = priority;
    priority = hook;
    hook = null;
  }

  if ((0, _minDash.isFunction)(priority)) {
    that = unwrap;
    unwrap = handlerFn;
    handlerFn = priority;
    priority = DEFAULT_PRIORITY;
  }

  if ((0, _minDash.isObject)(unwrap)) {
    that = unwrap;
    unwrap = false;
  }

  if (!(0, _minDash.isFunction)(handlerFn)) {
    throw new Error('handlerFn must be a function');
  }

  if (!(0, _minDash.isArray)(events)) {
    events = [events];
  }

  var eventBus = this._eventBus;

  (0, _minDash.forEach)(events, function (event) {
    // concat commandStack(.event)?(.hook)?
    var fullEvent = ['commandStack', event, hook].filter(function (e) {
      return e;
    }).join('.');

    eventBus.on(fullEvent, priority, unwrap ? unwrapEvent(handlerFn, that) : handlerFn, that);
  });
};

var hooks = ['canExecute', 'preExecute', 'preExecuted', 'execute', 'executed', 'postExecute', 'postExecuted', 'revert', 'reverted'];

/*
 * Install hook shortcuts
 *
 * This will generate the CommandInterceptor#(preExecute|...|reverted) methods
 * which will in term forward to CommandInterceptor#on.
 */
(0, _minDash.forEach)(hooks, function (hook) {

  /**
   * {canExecute|preExecute|preExecuted|execute|executed|postExecute|postExecuted|revert|reverted}
   *
   * A named hook for plugging into the command execution
   *
   * @param {String|Array<String>} [events] list of commands to register on
   * @param {Number} [priority] the priority on which to hook into the execution
   * @param {Function} handlerFn interceptor to be invoked with (event)
   * @param {Boolean} [unwrap=false] if true, unwrap the event and pass (context, command, event) to the
   *                          listener instead
   * @param {Object} [that] Pass context (`this`) to the handler function
   */
  CommandInterceptor.prototype[hook] = function (events, priority, handlerFn, unwrap, that) {

    if ((0, _minDash.isFunction)(events) || (0, _minDash.isNumber)(events)) {
      that = unwrap;
      unwrap = handlerFn;
      handlerFn = priority;
      priority = events;
      events = null;
    }

    this.on(events, hook, priority, handlerFn, unwrap, that);
  };
});

},{"254":254}],92:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CommandStack;

var _minDash = _dereq_(254);

/**
 * A service that offers un- and redoable execution of commands.
 *
 * The command stack is responsible for executing modeling actions
 * in a un- and redoable manner. To do this it delegates the actual
 * command execution to {@link CommandHandler}s.
 *
 * Command handlers provide {@link CommandHandler#execute(ctx)} and
 * {@link CommandHandler#revert(ctx)} methods to un- and redo a command
 * identified by a command context.
 *
 *
 * ## Life-Cycle events
 *
 * In the process the command stack fires a number of life-cycle events
 * that other components to participate in the command execution.
 *
 *    * preExecute
 *    * preExecuted
 *    * execute
 *    * executed
 *    * postExecute
 *    * postExecuted
 *    * revert
 *    * reverted
 *
 * A special event is used for validating, whether a command can be
 * performed prior to its execution.
 *
 *    * canExecute
 *
 * Each of the events is fired as `commandStack.{eventName}` and
 * `commandStack.{commandName}.{eventName}`, respectively. This gives
 * components fine grained control on where to hook into.
 *
 * The event object fired transports `command`, the name of the
 * command and `context`, the command context.
 *
 *
 * ## Creating Command Handlers
 *
 * Command handlers should provide the {@link CommandHandler#execute(ctx)}
 * and {@link CommandHandler#revert(ctx)} methods to implement
 * redoing and undoing of a command.
 *
 * A command handler _must_ ensure undo is performed properly in order
 * not to break the undo chain. It must also return the shapes that
 * got changed during the `execute` and `revert` operations.
 *
 * Command handlers may execute other modeling operations (and thus
 * commands) in their `preExecute` and `postExecute` phases. The command
 * stack will properly group all commands together into a logical unit
 * that may be re- and undone atomically.
 *
 * Command handlers must not execute other commands from within their
 * core implementation (`execute`, `revert`).
 *
 *
 * ## Change Tracking
 *
 * During the execution of the CommandStack it will keep track of all
 * elements that have been touched during the command's execution.
 *
 * At the end of the CommandStack execution it will notify interested
 * components via an 'elements.changed' event with all the dirty
 * elements.
 *
 * The event can be picked up by components that are interested in the fact
 * that elements have been changed. One use case for this is updating
 * their graphical representation after moving / resizing or deletion.
 *
 * @see CommandHandler
 *
 * @param {EventBus} eventBus
 * @param {Injector} injector
 */
function CommandStack(eventBus, injector) {

  /**
   * A map of all registered command handlers.
   *
   * @type {Object}
   */
  this._handlerMap = {};

  /**
   * A stack containing all re/undoable actions on the diagram
   *
   * @type {Array<Object>}
   */
  this._stack = [];

  /**
   * The current index on the stack
   *
   * @type {Number}
   */
  this._stackIdx = -1;

  /**
   * Current active commandStack execution
   *
   * @type {Object}
   */
  this._currentExecution = {
    actions: [],
    dirty: []
  };

  this._injector = injector;
  this._eventBus = eventBus;

  this._uid = 1;

  eventBus.on(['diagram.destroy', 'diagram.clear'], function () {
    this.clear(false);
  }, this);
}

CommandStack.$inject = ['eventBus', 'injector'];

/**
 * Execute a command
 *
 * @param {String} command the command to execute
 * @param {Object} context the environment to execute the command in
 */
CommandStack.prototype.execute = function (command, context) {
  if (!command) {
    throw new Error('command required');
  }

  var action = { command: command, context: context };

  this._pushAction(action);
  this._internalExecute(action);
  this._popAction(action);
};

/**
 * Ask whether a given command can be executed.
 *
 * Implementors may hook into the mechanism on two ways:
 *
 *   * in event listeners:
 *
 *     Users may prevent the execution via an event listener.
 *     It must prevent the default action for `commandStack.(<command>.)canExecute` events.
 *
 *   * in command handlers:
 *
 *     If the method {@link CommandHandler#canExecute} is implemented in a handler
 *     it will be called to figure out whether the execution is allowed.
 *
 * @param  {String} command the command to execute
 * @param  {Object} context the environment to execute the command in
 *
 * @return {Boolean} true if the command can be executed
 */
CommandStack.prototype.canExecute = function (command, context) {

  var action = { command: command, context: context };

  var handler = this._getHandler(command);

  var result = this._fire(command, 'canExecute', action);

  // handler#canExecute will only be called if no listener
  // decided on a result already
  if (result === undefined) {
    if (!handler) {
      return false;
    }

    if (handler.canExecute) {
      result = handler.canExecute(context);
    }
  }

  return result;
};

/**
 * Clear the command stack, erasing all undo / redo history
 */
CommandStack.prototype.clear = function (emit) {
  this._stack.length = 0;
  this._stackIdx = -1;

  if (emit !== false) {
    this._fire('changed');
  }
};

/**
 * Undo last command(s)
 */
CommandStack.prototype.undo = function () {
  var action = this._getUndoAction(),
      next;

  if (action) {
    this._pushAction(action);

    while (action) {
      this._internalUndo(action);
      next = this._getUndoAction();

      if (!next || next.id !== action.id) {
        break;
      }

      action = next;
    }

    this._popAction();
  }
};

/**
 * Redo last command(s)
 */
CommandStack.prototype.redo = function () {
  var action = this._getRedoAction(),
      next;

  if (action) {
    this._pushAction(action);

    while (action) {
      this._internalExecute(action, true);
      next = this._getRedoAction();

      if (!next || next.id !== action.id) {
        break;
      }

      action = next;
    }

    this._popAction();
  }
};

/**
 * Register a handler instance with the command stack
 *
 * @param {String} command
 * @param {CommandHandler} handler
 */
CommandStack.prototype.register = function (command, handler) {
  this._setHandler(command, handler);
};

/**
 * Register a handler type with the command stack
 * by instantiating it and injecting its dependencies.
 *
 * @param {String} command
 * @param {Function} a constructor for a {@link CommandHandler}
 */
CommandStack.prototype.registerHandler = function (command, handlerCls) {

  if (!command || !handlerCls) {
    throw new Error('command and handlerCls must be defined');
  }

  var handler = this._injector.instantiate(handlerCls);
  this.register(command, handler);
};

CommandStack.prototype.canUndo = function () {
  return !!this._getUndoAction();
};

CommandStack.prototype.canRedo = function () {
  return !!this._getRedoAction();
};

// stack access  //////////////////////

CommandStack.prototype._getRedoAction = function () {
  return this._stack[this._stackIdx + 1];
};

CommandStack.prototype._getUndoAction = function () {
  return this._stack[this._stackIdx];
};

// internal functionality //////////////////////

CommandStack.prototype._internalUndo = function (action) {
  var self = this;

  var command = action.command,
      context = action.context;

  var handler = this._getHandler(command);

  // guard against illegal nested command stack invocations
  this._atomicDo(function () {
    self._fire(command, 'revert', action);

    if (handler.revert) {
      self._markDirty(handler.revert(context));
    }

    self._revertedAction(action);

    self._fire(command, 'reverted', action);
  });
};

CommandStack.prototype._fire = function (command, qualifier, event) {
  if (arguments.length < 3) {
    event = qualifier;
    qualifier = null;
  }

  var names = qualifier ? [command + '.' + qualifier, qualifier] : [command],
      i,
      name,
      result;

  event = this._eventBus.createEvent(event);

  for (i = 0; name = names[i]; i++) {
    result = this._eventBus.fire('commandStack.' + name, event);

    if (event.cancelBubble) {
      break;
    }
  }

  return result;
};

CommandStack.prototype._createId = function () {
  return this._uid++;
};

CommandStack.prototype._atomicDo = function (fn) {

  var execution = this._currentExecution;

  execution.atomic = true;

  try {
    fn();
  } finally {
    execution.atomic = false;
  }
};

CommandStack.prototype._internalExecute = function (action, redo) {
  var self = this;

  var command = action.command,
      context = action.context;

  var handler = this._getHandler(command);

  if (!handler) {
    throw new Error('no command handler registered for <' + command + '>');
  }

  this._pushAction(action);

  if (!redo) {
    this._fire(command, 'preExecute', action);

    if (handler.preExecute) {
      handler.preExecute(context);
    }

    this._fire(command, 'preExecuted', action);
  }

  // guard against illegal nested command stack invocations
  this._atomicDo(function () {

    self._fire(command, 'execute', action);

    if (handler.execute) {
      // actual execute + mark return results as dirty
      self._markDirty(handler.execute(context));
    }

    // log to stack
    self._executedAction(action, redo);

    self._fire(command, 'executed', action);
  });

  if (!redo) {
    this._fire(command, 'postExecute', action);

    if (handler.postExecute) {
      handler.postExecute(context);
    }

    this._fire(command, 'postExecuted', action);
  }

  this._popAction(action);
};

CommandStack.prototype._pushAction = function (action) {

  var execution = this._currentExecution,
      actions = execution.actions;

  var baseAction = actions[0];

  if (execution.atomic) {
    throw new Error('illegal invocation in <execute> or <revert> phase (action: ' + action.command + ')');
  }

  if (!action.id) {
    action.id = baseAction && baseAction.id || this._createId();
  }

  actions.push(action);
};

CommandStack.prototype._popAction = function () {
  var execution = this._currentExecution,
      actions = execution.actions,
      dirty = execution.dirty;

  actions.pop();

  if (!actions.length) {
    this._eventBus.fire('elements.changed', { elements: (0, _minDash.uniqueBy)('id', dirty) });

    dirty.length = 0;

    this._fire('changed');
  }
};

CommandStack.prototype._markDirty = function (elements) {
  var execution = this._currentExecution;

  if (!elements) {
    return;
  }

  elements = (0, _minDash.isArray)(elements) ? elements : [elements];

  execution.dirty = execution.dirty.concat(elements);
};

CommandStack.prototype._executedAction = function (action, redo) {
  var stackIdx = ++this._stackIdx;

  if (!redo) {
    this._stack.splice(stackIdx, this._stack.length, action);
  }
};

CommandStack.prototype._revertedAction = function (action) {
  this._stackIdx--;
};

CommandStack.prototype._getHandler = function (command) {
  return this._handlerMap[command];
};

CommandStack.prototype._setHandler = function (command, handler) {
  if (!command || !handler) {
    throw new Error('command and handler required');
  }

  if (this._handlerMap[command]) {
    throw new Error('overriding handler for command <' + command + '>');
  }

  this._handlerMap[command] = handler;
};

},{"254":254}],93:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _CommandStack = _dereq_(92);

var _CommandStack2 = _interopRequireDefault(_CommandStack);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  commandStack: ['type', _CommandStack2.default]
};

},{"92":92}],94:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = Canvas;

var _minDash = _dereq_(254);

var _Collections = _dereq_(233);

var _Elements = _dereq_(235);

var _tinySvg = _dereq_(275);

function round(number, resolution) {
  return Math.round(number * resolution) / resolution;
}

function ensurePx(number) {
  return (0, _minDash.isNumber)(number) ? number + 'px' : number;
}

/**
 * Creates a HTML container element for a SVG element with
 * the given configuration
 *
 * @param  {Object} options
 * @return {HTMLElement} the container element
 */
function createContainer(options) {

  options = (0, _minDash.assign)({}, { width: '100%', height: '100%' }, options);

  var container = options.container || document.body;

  // create a <div> around the svg element with the respective size
  // this way we can always get the correct container size
  // (this is impossible for <svg> elements at the moment)
  var parent = document.createElement('div');
  parent.setAttribute('class', 'djs-container');

  (0, _minDash.assign)(parent.style, {
    position: 'relative',
    overflow: 'hidden',
    width: ensurePx(options.width),
    height: ensurePx(options.height)
  });

  container.appendChild(parent);

  return parent;
}

function createGroup(parent, cls, childIndex) {
  var group = (0, _tinySvg.create)('g');
  (0, _tinySvg.classes)(group).add(cls);

  var index = childIndex !== undefined ? childIndex : parent.childNodes.length - 1;

  // must ensure second argument is node or _null_
  // cf. https://developer.mozilla.org/en-US/docs/Web/API/Node/insertBefore
  parent.insertBefore(group, parent.childNodes[index] || null);

  return group;
}

var BASE_LAYER = 'base';

var REQUIRED_MODEL_ATTRS = {
  shape: ['x', 'y', 'width', 'height'],
  connection: ['waypoints']
};

/**
 * The main drawing canvas.
 *
 * @class
 * @constructor
 *
 * @emits Canvas#canvas.init
 *
 * @param {Object} config
 * @param {EventBus} eventBus
 * @param {GraphicsFactory} graphicsFactory
 * @param {ElementRegistry} elementRegistry
 */
function Canvas(config, eventBus, graphicsFactory, elementRegistry) {

  this._eventBus = eventBus;
  this._elementRegistry = elementRegistry;
  this._graphicsFactory = graphicsFactory;

  this._init(config || {});
}

Canvas.$inject = ['config.canvas', 'eventBus', 'graphicsFactory', 'elementRegistry'];

Canvas.prototype._init = function (config) {

  var eventBus = this._eventBus;

  // Creates a <svg> element that is wrapped into a <div>.
  // This way we are always able to correctly figure out the size of the svg element
  // by querying the parent node.
  //
  // (It is not possible to get the size of a svg element cross browser @ 2014-04-01)
  //
  // <div class="djs-container" style="width: {desired-width}, height: {desired-height}">
  //   <svg width="100%" height="100%">
  //    ...
  //   </svg>
  // </div>

  // html container
  var container = this._container = createContainer(config);

  var svg = this._svg = (0, _tinySvg.create)('svg');
  (0, _tinySvg.attr)(svg, { width: '100%', height: '100%' });

  (0, _tinySvg.append)(container, svg);

  var viewport = this._viewport = createGroup(svg, 'viewport');

  this._layers = {};

  // debounce canvas.viewbox.changed events
  // for smoother diagram interaction
  if (config.deferUpdate !== false) {
    this._viewboxChanged = (0, _minDash.debounce)((0, _minDash.bind)(this._viewboxChanged, this), 300);
  }

  eventBus.on('diagram.init', function () {

    /**
     * An event indicating that the canvas is ready to be drawn on.
     *
     * @memberOf Canvas
     *
     * @event canvas.init
     *
     * @type {Object}
     * @property {SVGElement} svg the created svg element
     * @property {SVGElement} viewport the direct parent of diagram elements and shapes
     */
    eventBus.fire('canvas.init', {
      svg: svg,
      viewport: viewport
    });
  }, this);

  // reset viewbox on shape changes to
  // recompute the viewbox
  eventBus.on(['shape.added', 'connection.added', 'shape.removed', 'connection.removed', 'elements.changed'], function () {
    delete this._cachedViewbox;
  }, this);

  eventBus.on('diagram.destroy', 500, this._destroy, this);
  eventBus.on('diagram.clear', 500, this._clear, this);
};

Canvas.prototype._destroy = function (emit) {
  this._eventBus.fire('canvas.destroy', {
    svg: this._svg,
    viewport: this._viewport
  });

  var parent = this._container.parentNode;

  if (parent) {
    parent.removeChild(this._container);
  }

  delete this._svg;
  delete this._container;
  delete this._layers;
  delete this._rootElement;
  delete this._viewport;
};

Canvas.prototype._clear = function () {

  var self = this;

  var allElements = this._elementRegistry.getAll();

  // remove all elements
  allElements.forEach(function (element) {
    var type = (0, _Elements.getType)(element);

    if (type === 'root') {
      self.setRootElement(null, true);
    } else {
      self._removeElement(element, type);
    }
  });

  // force recomputation of view box
  delete this._cachedViewbox;
};

/**
 * Returns the default layer on which
 * all elements are drawn.
 *
 * @returns {SVGElement}
 */
Canvas.prototype.getDefaultLayer = function () {
  return this.getLayer(BASE_LAYER, 0);
};

/**
 * Returns a layer that is used to draw elements
 * or annotations on it.
 *
 * Non-existing layers retrieved through this method
 * will be created. During creation, the optional index
 * may be used to create layers below or above existing layers.
 * A layer with a certain index is always created above all
 * existing layers with the same index.
 *
 * @param {String} name
 * @param {Number} index
 *
 * @returns {SVGElement}
 */
Canvas.prototype.getLayer = function (name, index) {

  if (!name) {
    throw new Error('must specify a name');
  }

  var layer = this._layers[name];

  if (!layer) {
    layer = this._layers[name] = this._createLayer(name, index);
  }

  // throw an error if layer creation / retrival is
  // requested on different index
  if (typeof index !== 'undefined' && layer.index !== index) {
    throw new Error('layer <' + name + '> already created at index <' + index + '>');
  }

  return layer.group;
};

/**
 * Creates a given layer and returns it.
 *
 * @param {String} name
 * @param {Number} [index=0]
 *
 * @return {Object} layer descriptor with { index, group: SVGGroup }
 */
Canvas.prototype._createLayer = function (name, index) {

  if (!index) {
    index = 0;
  }

  var childIndex = (0, _minDash.reduce)(this._layers, function (childIndex, layer) {
    if (index >= layer.index) {
      childIndex++;
    }

    return childIndex;
  }, 0);

  return {
    group: createGroup(this._viewport, 'layer-' + name, childIndex),
    index: index
  };
};

/**
 * Returns the html element that encloses the
 * drawing canvas.
 *
 * @return {DOMNode}
 */
Canvas.prototype.getContainer = function () {
  return this._container;
};

// markers //////////////////////

Canvas.prototype._updateMarker = function (element, marker, add) {
  var container;

  if (!element.id) {
    element = this._elementRegistry.get(element);
  }

  // we need to access all
  container = this._elementRegistry._elements[element.id];

  if (!container) {
    return;
  }

  (0, _minDash.forEach)([container.gfx, container.secondaryGfx], function (gfx) {
    if (gfx) {
      // invoke either addClass or removeClass based on mode
      if (add) {
        (0, _tinySvg.classes)(gfx).add(marker);
      } else {
        (0, _tinySvg.classes)(gfx).remove(marker);
      }
    }
  });

  /**
   * An event indicating that a marker has been updated for an element
   *
   * @event element.marker.update
   * @type {Object}
   * @property {djs.model.Element} element the shape
   * @property {Object} gfx the graphical representation of the shape
   * @property {String} marker
   * @property {Boolean} add true if the marker was added, false if it got removed
   */
  this._eventBus.fire('element.marker.update', { element: element, gfx: container.gfx, marker: marker, add: !!add });
};

/**
 * Adds a marker to an element (basically a css class).
 *
 * Fires the element.marker.update event, making it possible to
 * integrate extension into the marker life-cycle, too.
 *
 * @example
 * canvas.addMarker('foo', 'some-marker');
 *
 * var fooGfx = canvas.getGraphics('foo');
 *
 * fooGfx; // <g class="... some-marker"> ... </g>
 *
 * @param {String|djs.model.Base} element
 * @param {String} marker
 */
Canvas.prototype.addMarker = function (element, marker) {
  this._updateMarker(element, marker, true);
};

/**
 * Remove a marker from an element.
 *
 * Fires the element.marker.update event, making it possible to
 * integrate extension into the marker life-cycle, too.
 *
 * @param  {String|djs.model.Base} element
 * @param  {String} marker
 */
Canvas.prototype.removeMarker = function (element, marker) {
  this._updateMarker(element, marker, false);
};

/**
 * Check the existence of a marker on element.
 *
 * @param  {String|djs.model.Base} element
 * @param  {String} marker
 */
Canvas.prototype.hasMarker = function (element, marker) {
  if (!element.id) {
    element = this._elementRegistry.get(element);
  }

  var gfx = this.getGraphics(element);

  return (0, _tinySvg.classes)(gfx).has(marker);
};

/**
 * Toggles a marker on an element.
 *
 * Fires the element.marker.update event, making it possible to
 * integrate extension into the marker life-cycle, too.
 *
 * @param  {String|djs.model.Base} element
 * @param  {String} marker
 */
Canvas.prototype.toggleMarker = function (element, marker) {
  if (this.hasMarker(element, marker)) {
    this.removeMarker(element, marker);
  } else {
    this.addMarker(element, marker);
  }
};

Canvas.prototype.getRootElement = function () {
  if (!this._rootElement) {
    this.setRootElement({ id: '__implicitroot', children: [] });
  }

  return this._rootElement;
};

// root element handling //////////////////////

/**
 * Sets a given element as the new root element for the canvas
 * and returns the new root element.
 *
 * @param {Object|djs.model.Root} element
 * @param {Boolean} [override] whether to override the current root element, if any
 *
 * @return {Object|djs.model.Root} new root element
 */
Canvas.prototype.setRootElement = function (element, override) {

  if (element) {
    this._ensureValid('root', element);
  }

  var currentRoot = this._rootElement,
      elementRegistry = this._elementRegistry,
      eventBus = this._eventBus;

  if (currentRoot) {
    if (!override) {
      throw new Error('rootElement already set, need to specify override');
    }

    // simulate element remove event sequence
    eventBus.fire('root.remove', { element: currentRoot });
    eventBus.fire('root.removed', { element: currentRoot });

    elementRegistry.remove(currentRoot);
  }

  if (element) {
    var gfx = this.getDefaultLayer();

    // resemble element add event sequence
    eventBus.fire('root.add', { element: element });

    elementRegistry.add(element, gfx, this._svg);

    eventBus.fire('root.added', { element: element, gfx: gfx });
  }

  this._rootElement = element;

  return element;
};

// add functionality //////////////////////

Canvas.prototype._ensureValid = function (type, element) {
  if (!element.id) {
    throw new Error('element must have an id');
  }

  if (this._elementRegistry.get(element.id)) {
    throw new Error('element with id ' + element.id + ' already exists');
  }

  var requiredAttrs = REQUIRED_MODEL_ATTRS[type];

  var valid = (0, _minDash.every)(requiredAttrs, function (attr) {
    return typeof element[attr] !== 'undefined';
  });

  if (!valid) {
    throw new Error('must supply { ' + requiredAttrs.join(', ') + ' } with ' + type);
  }
};

Canvas.prototype._setParent = function (element, parent, parentIndex) {
  (0, _Collections.add)(parent.children, element, parentIndex);
  element.parent = parent;
};

/**
 * Adds an element to the canvas.
 *
 * This wires the parent <-> child relationship between the element and
 * a explicitly specified parent or an implicit root element.
 *
 * During add it emits the events
 *
 *  * <{type}.add> (element, parent)
 *  * <{type}.added> (element, gfx)
 *
 * Extensions may hook into these events to perform their magic.
 *
 * @param {String} type
 * @param {Object|djs.model.Base} element
 * @param {Object|djs.model.Base} [parent]
 * @param {Number} [parentIndex]
 *
 * @return {Object|djs.model.Base} the added element
 */
Canvas.prototype._addElement = function (type, element, parent, parentIndex) {

  parent = parent || this.getRootElement();

  var eventBus = this._eventBus,
      graphicsFactory = this._graphicsFactory;

  this._ensureValid(type, element);

  eventBus.fire(type + '.add', { element: element, parent: parent });

  this._setParent(element, parent, parentIndex);

  // create graphics
  var gfx = graphicsFactory.create(type, element, parentIndex);

  this._elementRegistry.add(element, gfx);

  // update its visual
  graphicsFactory.update(type, element, gfx);

  eventBus.fire(type + '.added', { element: element, gfx: gfx });

  return element;
};

/**
 * Adds a shape to the canvas
 *
 * @param {Object|djs.model.Shape} shape to add to the diagram
 * @param {djs.model.Base} [parent]
 * @param {Number} [parentIndex]
 *
 * @return {djs.model.Shape} the added shape
 */
Canvas.prototype.addShape = function (shape, parent, parentIndex) {
  return this._addElement('shape', shape, parent, parentIndex);
};

/**
 * Adds a connection to the canvas
 *
 * @param {Object|djs.model.Connection} connection to add to the diagram
 * @param {djs.model.Base} [parent]
 * @param {Number} [parentIndex]
 *
 * @return {djs.model.Connection} the added connection
 */
Canvas.prototype.addConnection = function (connection, parent, parentIndex) {
  return this._addElement('connection', connection, parent, parentIndex);
};

/**
 * Internal remove element
 */
Canvas.prototype._removeElement = function (element, type) {

  var elementRegistry = this._elementRegistry,
      graphicsFactory = this._graphicsFactory,
      eventBus = this._eventBus;

  element = elementRegistry.get(element.id || element);

  if (!element) {
    // element was removed already
    return;
  }

  eventBus.fire(type + '.remove', { element: element });

  graphicsFactory.remove(element);

  // unset parent <-> child relationship
  (0, _Collections.remove)(element.parent && element.parent.children, element);
  element.parent = null;

  eventBus.fire(type + '.removed', { element: element });

  elementRegistry.remove(element);

  return element;
};

/**
 * Removes a shape from the canvas
 *
 * @param {String|djs.model.Shape} shape or shape id to be removed
 *
 * @return {djs.model.Shape} the removed shape
 */
Canvas.prototype.removeShape = function (shape) {

  /**
   * An event indicating that a shape is about to be removed from the canvas.
   *
   * @memberOf Canvas
   *
   * @event shape.remove
   * @type {Object}
   * @property {djs.model.Shape} element the shape descriptor
   * @property {Object} gfx the graphical representation of the shape
   */

  /**
   * An event indicating that a shape has been removed from the canvas.
   *
   * @memberOf Canvas
   *
   * @event shape.removed
   * @type {Object}
   * @property {djs.model.Shape} element the shape descriptor
   * @property {Object} gfx the graphical representation of the shape
   */
  return this._removeElement(shape, 'shape');
};

/**
 * Removes a connection from the canvas
 *
 * @param {String|djs.model.Connection} connection or connection id to be removed
 *
 * @return {djs.model.Connection} the removed connection
 */
Canvas.prototype.removeConnection = function (connection) {

  /**
   * An event indicating that a connection is about to be removed from the canvas.
   *
   * @memberOf Canvas
   *
   * @event connection.remove
   * @type {Object}
   * @property {djs.model.Connection} element the connection descriptor
   * @property {Object} gfx the graphical representation of the connection
   */

  /**
   * An event indicating that a connection has been removed from the canvas.
   *
   * @memberOf Canvas
   *
   * @event connection.removed
   * @type {Object}
   * @property {djs.model.Connection} element the connection descriptor
   * @property {Object} gfx the graphical representation of the connection
   */
  return this._removeElement(connection, 'connection');
};

/**
 * Return the graphical object underlaying a certain diagram element
 *
 * @param {String|djs.model.Base} element descriptor of the element
 * @param {Boolean} [secondary=false] whether to return the secondary connected element
 *
 * @return {SVGElement}
 */
Canvas.prototype.getGraphics = function (element, secondary) {
  return this._elementRegistry.getGraphics(element, secondary);
};

/**
 * Perform a viewbox update via a given change function.
 *
 * @param {Function} changeFn
 */
Canvas.prototype._changeViewbox = function (changeFn) {

  // notify others of the upcoming viewbox change
  this._eventBus.fire('canvas.viewbox.changing');

  // perform actual change
  changeFn.apply(this);

  // reset the cached viewbox so that
  // a new get operation on viewbox or zoom
  // triggers a viewbox re-computation
  this._cachedViewbox = null;

  // notify others of the change; this step
  // may or may not be debounced
  this._viewboxChanged();
};

Canvas.prototype._viewboxChanged = function () {
  this._eventBus.fire('canvas.viewbox.changed', { viewbox: this.viewbox() });
};

/**
 * Gets or sets the view box of the canvas, i.e. the
 * area that is currently displayed.
 *
 * The getter may return a cached viewbox (if it is currently
 * changing). To force a recomputation, pass `false` as the first argument.
 *
 * @example
 *
 * canvas.viewbox({ x: 100, y: 100, width: 500, height: 500 })
 *
 * // sets the visible area of the diagram to (100|100) -> (600|100)
 * // and and scales it according to the diagram width
 *
 * var viewbox = canvas.viewbox(); // pass `false` to force recomputing the box.
 *
 * console.log(viewbox);
 * // {
 * //   inner: Dimensions,
 * //   outer: Dimensions,
 * //   scale,
 * //   x, y,
 * //   width, height
 * // }
 *
 * // if the current diagram is zoomed and scrolled, you may reset it to the
 * // default zoom via this method, too:
 *
 * var zoomedAndScrolledViewbox = canvas.viewbox();
 *
 * canvas.viewbox({
 *   x: 0,
 *   y: 0,
 *   width: zoomedAndScrolledViewbox.outer.width,
 *   height: zoomedAndScrolledViewbox.outer.height
 * });
 *
 * @param  {Object} [box] the new view box to set
 * @param  {Number} box.x the top left X coordinate of the canvas visible in view box
 * @param  {Number} box.y the top left Y coordinate of the canvas visible in view box
 * @param  {Number} box.width the visible width
 * @param  {Number} box.height
 *
 * @return {Object} the current view box
 */
Canvas.prototype.viewbox = function (box) {

  if (box === undefined && this._cachedViewbox) {
    return this._cachedViewbox;
  }

  var viewport = this._viewport,
      innerBox,
      outerBox = this.getSize(),
      matrix,
      transform,
      scale,
      x,
      y;

  if (!box) {
    // compute the inner box based on the
    // diagrams default layer. This allows us to exclude
    // external components, such as overlays
    innerBox = this.getDefaultLayer().getBBox();

    transform = (0, _tinySvg.transform)(viewport);
    matrix = transform ? transform.matrix : (0, _tinySvg.createMatrix)();
    scale = round(matrix.a, 1000);

    x = round(-matrix.e || 0, 1000);
    y = round(-matrix.f || 0, 1000);

    box = this._cachedViewbox = {
      x: x ? x / scale : 0,
      y: y ? y / scale : 0,
      width: outerBox.width / scale,
      height: outerBox.height / scale,
      scale: scale,
      inner: {
        width: innerBox.width,
        height: innerBox.height,
        x: innerBox.x,
        y: innerBox.y
      },
      outer: outerBox
    };

    return box;
  } else {

    this._changeViewbox(function () {
      scale = Math.min(outerBox.width / box.width, outerBox.height / box.height);

      var matrix = this._svg.createSVGMatrix().scale(scale).translate(-box.x, -box.y);

      (0, _tinySvg.transform)(viewport, matrix);
    });
  }

  return box;
};

/**
 * Gets or sets the scroll of the canvas.
 *
 * @param {Object} [delta] the new scroll to apply.
 *
 * @param {Number} [delta.dx]
 * @param {Number} [delta.dy]
 */
Canvas.prototype.scroll = function (delta) {

  var node = this._viewport;
  var matrix = node.getCTM();

  if (delta) {
    this._changeViewbox(function () {
      delta = (0, _minDash.assign)({ dx: 0, dy: 0 }, delta || {});

      matrix = this._svg.createSVGMatrix().translate(delta.dx, delta.dy).multiply(matrix);

      setCTM(node, matrix);
    });
  }

  return { x: matrix.e, y: matrix.f };
};

/**
 * Gets or sets the current zoom of the canvas, optionally zooming
 * to the specified position.
 *
 * The getter may return a cached zoom level. Call it with `false` as
 * the first argument to force recomputation of the current level.
 *
 * @param {String|Number} [newScale] the new zoom level, either a number, i.e. 0.9,
 *                                   or `fit-viewport` to adjust the size to fit the current viewport
 * @param {String|Point} [center] the reference point { x: .., y: ..} to zoom to, 'auto' to zoom into mid or null
 *
 * @return {Number} the current scale
 */
Canvas.prototype.zoom = function (newScale, center) {

  if (!newScale) {
    return this.viewbox(newScale).scale;
  }

  if (newScale === 'fit-viewport') {
    return this._fitViewport(center);
  }

  var outer, matrix;

  this._changeViewbox(function () {

    if ((typeof center === 'undefined' ? 'undefined' : _typeof(center)) !== 'object') {
      outer = this.viewbox().outer;

      center = {
        x: outer.width / 2,
        y: outer.height / 2
      };
    }

    matrix = this._setZoom(newScale, center);
  });

  return round(matrix.a, 1000);
};

function setCTM(node, m) {
  var mstr = 'matrix(' + m.a + ',' + m.b + ',' + m.c + ',' + m.d + ',' + m.e + ',' + m.f + ')';
  node.setAttribute('transform', mstr);
}

Canvas.prototype._fitViewport = function (center) {

  var vbox = this.viewbox(),
      outer = vbox.outer,
      inner = vbox.inner,
      newScale,
      newViewbox;

  // display the complete diagram without zooming in.
  // instead of relying on internal zoom, we perform a
  // hard reset on the canvas viewbox to realize this
  //
  // if diagram does not need to be zoomed in, we focus it around
  // the diagram origin instead

  if (inner.x >= 0 && inner.y >= 0 && inner.x + inner.width <= outer.width && inner.y + inner.height <= outer.height && !center) {

    newViewbox = {
      x: 0,
      y: 0,
      width: Math.max(inner.width + inner.x, outer.width),
      height: Math.max(inner.height + inner.y, outer.height)
    };
  } else {

    newScale = Math.min(1, outer.width / inner.width, outer.height / inner.height);
    newViewbox = {
      x: inner.x + (center ? inner.width / 2 - outer.width / newScale / 2 : 0),
      y: inner.y + (center ? inner.height / 2 - outer.height / newScale / 2 : 0),
      width: outer.width / newScale,
      height: outer.height / newScale
    };
  }

  this.viewbox(newViewbox);

  return this.viewbox(false).scale;
};

Canvas.prototype._setZoom = function (scale, center) {

  var svg = this._svg,
      viewport = this._viewport;

  var matrix = svg.createSVGMatrix();
  var point = svg.createSVGPoint();

  var centerPoint, originalPoint, currentMatrix, scaleMatrix, newMatrix;

  currentMatrix = viewport.getCTM();

  var currentScale = currentMatrix.a;

  if (center) {
    centerPoint = (0, _minDash.assign)(point, center);

    // revert applied viewport transformations
    originalPoint = centerPoint.matrixTransform(currentMatrix.inverse());

    // create scale matrix
    scaleMatrix = matrix.translate(originalPoint.x, originalPoint.y).scale(1 / currentScale * scale).translate(-originalPoint.x, -originalPoint.y);

    newMatrix = currentMatrix.multiply(scaleMatrix);
  } else {
    newMatrix = matrix.scale(scale);
  }

  setCTM(this._viewport, newMatrix);

  return newMatrix;
};

/**
 * Returns the size of the canvas
 *
 * @return {Dimensions}
 */
Canvas.prototype.getSize = function () {
  return {
    width: this._container.clientWidth,
    height: this._container.clientHeight
  };
};

/**
 * Return the absolute bounding box for the given element
 *
 * The absolute bounding box may be used to display overlays in the
 * callers (browser) coordinate system rather than the zoomed in/out
 * canvas coordinates.
 *
 * @param  {ElementDescriptor} element
 * @return {Bounds} the absolute bounding box
 */
Canvas.prototype.getAbsoluteBBox = function (element) {
  var vbox = this.viewbox();
  var bbox;

  // connection
  // use svg bbox
  if (element.waypoints) {
    var gfx = this.getGraphics(element);

    bbox = gfx.getBBox();
  }
  // shapes
  // use data
  else {
      bbox = element;
    }

  var x = bbox.x * vbox.scale - vbox.x * vbox.scale;
  var y = bbox.y * vbox.scale - vbox.y * vbox.scale;

  var width = bbox.width * vbox.scale;
  var height = bbox.height * vbox.scale;

  return {
    x: x,
    y: y,
    width: width,
    height: height
  };
};

/**
 * Fires an event in order other modules can react to the
 * canvas resizing
 */
Canvas.prototype.resized = function () {

  // force recomputation of view box
  delete this._cachedViewbox;

  this._eventBus.fire('canvas.resized');
};

},{"233":233,"235":235,"254":254,"275":275}],95:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ElementFactory;

var _model = _dereq_(223);

var _minDash = _dereq_(254);

/**
 * A factory for diagram-js shapes
 */
function ElementFactory() {
  this._uid = 12;
}

ElementFactory.prototype.createRoot = function (attrs) {
  return this.create('root', attrs);
};

ElementFactory.prototype.createLabel = function (attrs) {
  return this.create('label', attrs);
};

ElementFactory.prototype.createShape = function (attrs) {
  return this.create('shape', attrs);
};

ElementFactory.prototype.createConnection = function (attrs) {
  return this.create('connection', attrs);
};

/**
 * Create a model element with the given type and
 * a number of pre-set attributes.
 *
 * @param  {String} type
 * @param  {Object} attrs
 * @return {djs.model.Base} the newly created model instance
 */
ElementFactory.prototype.create = function (type, attrs) {

  attrs = (0, _minDash.assign)({}, attrs || {});

  if (!attrs.id) {
    attrs.id = type + '_' + this._uid++;
  }

  return (0, _model.create)(type, attrs);
};

},{"223":223,"254":254}],96:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ElementRegistry;

var _tinySvg = _dereq_(275);

var ELEMENT_ID = 'data-element-id';

/**
 * @class
 *
 * A registry that keeps track of all shapes in the diagram.
 */
function ElementRegistry(eventBus) {
  this._elements = {};

  this._eventBus = eventBus;
}

ElementRegistry.$inject = ['eventBus'];

/**
 * Register a pair of (element, gfx, (secondaryGfx)).
 *
 * @param {djs.model.Base} element
 * @param {SVGElement} gfx
 * @param {SVGElement} [secondaryGfx] optional other element to register, too
 */
ElementRegistry.prototype.add = function (element, gfx, secondaryGfx) {

  var id = element.id;

  this._validateId(id);

  // associate dom node with element
  (0, _tinySvg.attr)(gfx, ELEMENT_ID, id);

  if (secondaryGfx) {
    (0, _tinySvg.attr)(secondaryGfx, ELEMENT_ID, id);
  }

  this._elements[id] = { element: element, gfx: gfx, secondaryGfx: secondaryGfx };
};

/**
 * Removes an element from the registry.
 *
 * @param {djs.model.Base} element
 */
ElementRegistry.prototype.remove = function (element) {
  var elements = this._elements,
      id = element.id || element,
      container = id && elements[id];

  if (container) {

    // unset element id on gfx
    (0, _tinySvg.attr)(container.gfx, ELEMENT_ID, '');

    if (container.secondaryGfx) {
      (0, _tinySvg.attr)(container.secondaryGfx, ELEMENT_ID, '');
    }

    delete elements[id];
  }
};

/**
 * Update the id of an element
 *
 * @param {djs.model.Base} element
 * @param {String} newId
 */
ElementRegistry.prototype.updateId = function (element, newId) {

  this._validateId(newId);

  if (typeof element === 'string') {
    element = this.get(element);
  }

  this._eventBus.fire('element.updateId', {
    element: element,
    newId: newId
  });

  var gfx = this.getGraphics(element),
      secondaryGfx = this.getGraphics(element, true);

  this.remove(element);

  element.id = newId;

  this.add(element, gfx, secondaryGfx);
};

/**
 * Return the model element for a given id or graphics.
 *
 * @example
 *
 * elementRegistry.get('SomeElementId_1');
 * elementRegistry.get(gfx);
 *
 *
 * @param {String|SVGElement} filter for selecting the element
 *
 * @return {djs.model.Base}
 */
ElementRegistry.prototype.get = function (filter) {
  var id;

  if (typeof filter === 'string') {
    id = filter;
  } else {
    id = filter && (0, _tinySvg.attr)(filter, ELEMENT_ID);
  }

  var container = this._elements[id];
  return container && container.element;
};

/**
 * Return all elements that match a given filter function.
 *
 * @param {Function} fn
 *
 * @return {Array<djs.model.Base>}
 */
ElementRegistry.prototype.filter = function (fn) {

  var filtered = [];

  this.forEach(function (element, gfx) {
    if (fn(element, gfx)) {
      filtered.push(element);
    }
  });

  return filtered;
};

/**
 * Return all rendered model elements.
 *
 * @return {Array<djs.model.Base>}
 */
ElementRegistry.prototype.getAll = function () {
  return this.filter(function (e) {
    return e;
  });
};

/**
 * Iterate over all diagram elements.
 *
 * @param {Function} fn
 */
ElementRegistry.prototype.forEach = function (fn) {

  var map = this._elements;

  Object.keys(map).forEach(function (id) {
    var container = map[id],
        element = container.element,
        gfx = container.gfx;

    return fn(element, gfx);
  });
};

/**
 * Return the graphical representation of an element or its id.
 *
 * @example
 * elementRegistry.getGraphics('SomeElementId_1');
 * elementRegistry.getGraphics(rootElement); // <g ...>
 *
 * elementRegistry.getGraphics(rootElement, true); // <svg ...>
 *
 *
 * @param {String|djs.model.Base} filter
 * @param {Boolean} [secondary=false] whether to return the secondary connected element
 *
 * @return {SVGElement}
 */
ElementRegistry.prototype.getGraphics = function (filter, secondary) {
  var id = filter.id || filter;

  var container = this._elements[id];
  return container && (secondary ? container.secondaryGfx : container.gfx);
};

/**
 * Validate the suitability of the given id and signals a problem
 * with an exception.
 *
 * @param {String} id
 *
 * @throws {Error} if id is empty or already assigned
 */
ElementRegistry.prototype._validateId = function (id) {
  if (!id) {
    throw new Error('element must have an id');
  }

  if (this._elements[id]) {
    throw new Error('element with id ' + id + ' already added');
  }
};

},{"275":275}],97:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = EventBus;

var _minDash = _dereq_(254);

var FN_REF = '__fn';

var DEFAULT_PRIORITY = 1000;

var slice = Array.prototype.slice;

/**
 * A general purpose event bus.
 *
 * This component is used to communicate across a diagram instance.
 * Other parts of a diagram can use it to listen to and broadcast events.
 *
 *
 * ## Registering for Events
 *
 * The event bus provides the {@link EventBus#on} and {@link EventBus#once}
 * methods to register for events. {@link EventBus#off} can be used to
 * remove event registrations. Listeners receive an instance of {@link Event}
 * as the first argument. It allows them to hook into the event execution.
 *
 * ```javascript
 *
 * // listen for event
 * eventBus.on('foo', function(event) {
 *
 *   // access event type
 *   event.type; // 'foo'
 *
 *   // stop propagation to other listeners
 *   event.stopPropagation();
 *
 *   // prevent event default
 *   event.preventDefault();
 * });
 *
 * // listen for event with custom payload
 * eventBus.on('bar', function(event, payload) {
 *   console.log(payload);
 * });
 *
 * // listen for event returning value
 * eventBus.on('foobar', function(event) {
 *
 *   // stop event propagation + prevent default
 *   return false;
 *
 *   // stop event propagation + return custom result
 *   return {
 *     complex: 'listening result'
 *   };
 * });
 *
 *
 * // listen with custom priority (default=1000, higher is better)
 * eventBus.on('priorityfoo', 1500, function(event) {
 *   console.log('invoked first!');
 * });
 *
 *
 * // listen for event and pass the context (`this`)
 * eventBus.on('foobar', function(event) {
 *   this.foo();
 * }, this);
 * ```
 *
 *
 * ## Emitting Events
 *
 * Events can be emitted via the event bus using {@link EventBus#fire}.
 *
 * ```javascript
 *
 * // false indicates that the default action
 * // was prevented by listeners
 * if (eventBus.fire('foo') === false) {
 *   console.log('default has been prevented!');
 * };
 *
 *
 * // custom args + return value listener
 * eventBus.on('sum', function(event, a, b) {
 *   return a + b;
 * });
 *
 * // you can pass custom arguments + retrieve result values.
 * var sum = eventBus.fire('sum', 1, 2);
 * console.log(sum); // 3
 * ```
 */
function EventBus() {
  this._listeners = {};

  // cleanup on destroy on lowest priority to allow
  // message passing until the bitter end
  this.on('diagram.destroy', 1, this._destroy, this);
}

/**
 * Register an event listener for events with the given name.
 *
 * The callback will be invoked with `event, ...additionalArguments`
 * that have been passed to {@link EventBus#fire}.
 *
 * Returning false from a listener will prevent the events default action
 * (if any is specified). To stop an event from being processed further in
 * other listeners execute {@link Event#stopPropagation}.
 *
 * Returning anything but `undefined` from a listener will stop the listener propagation.
 *
 * @param {String|Array<String>} events
 * @param {Number} [priority=1000] the priority in which this listener is called, larger is higher
 * @param {Function} callback
 * @param {Object} [that] Pass context (`this`) to the callback
 */
EventBus.prototype.on = function (events, priority, callback, that) {

  events = (0, _minDash.isArray)(events) ? events : [events];

  if ((0, _minDash.isFunction)(priority)) {
    that = callback;
    callback = priority;
    priority = DEFAULT_PRIORITY;
  }

  if (!(0, _minDash.isNumber)(priority)) {
    throw new Error('priority must be a number');
  }

  var actualCallback = callback;

  if (that) {
    actualCallback = (0, _minDash.bind)(callback, that);

    // make sure we remember and are able to remove
    // bound callbacks via {@link #off} using the original
    // callback
    actualCallback[FN_REF] = callback[FN_REF] || callback;
  }

  var self = this;

  events.forEach(function (e) {
    self._addListener(e, {
      priority: priority,
      callback: actualCallback,
      next: null
    });
  });
};

/**
 * Register an event listener that is executed only once.
 *
 * @param {String} event the event name to register for
 * @param {Number} [priority=1000] the priority in which this listener is called, larger is higher
 * @param {Function} callback the callback to execute
 * @param {Object} [that] Pass context (`this`) to the callback
 */
EventBus.prototype.once = function (event, priority, callback, that) {
  var self = this;

  if ((0, _minDash.isFunction)(priority)) {
    that = callback;
    callback = priority;
    priority = DEFAULT_PRIORITY;
  }

  if (!(0, _minDash.isNumber)(priority)) {
    throw new Error('priority must be a number');
  }

  function wrappedCallback() {
    var result = callback.apply(that, arguments);

    self.off(event, wrappedCallback);

    return result;
  }

  // make sure we remember and are able to remove
  // bound callbacks via {@link #off} using the original
  // callback
  wrappedCallback[FN_REF] = callback;

  this.on(event, priority, wrappedCallback);
};

/**
 * Removes event listeners by event and callback.
 *
 * If no callback is given, all listeners for a given event name are being removed.
 *
 * @param {String|Array<String>} events
 * @param {Function} [callback]
 */
EventBus.prototype.off = function (events, callback) {

  events = (0, _minDash.isArray)(events) ? events : [events];

  var self = this;

  events.forEach(function (event) {
    self._removeListener(event, callback);
  });
};

/**
 * Create an EventBus event.
 *
 * @param {Object} data
 *
 * @return {Object} event, recognized by the eventBus
 */
EventBus.prototype.createEvent = function (data) {
  var event = new InternalEvent();

  event.init(data);

  return event;
};

/**
 * Fires a named event.
 *
 * @example
 *
 * // fire event by name
 * events.fire('foo');
 *
 * // fire event object with nested type
 * var event = { type: 'foo' };
 * events.fire(event);
 *
 * // fire event with explicit type
 * var event = { x: 10, y: 20 };
 * events.fire('element.moved', event);
 *
 * // pass additional arguments to the event
 * events.on('foo', function(event, bar) {
 *   alert(bar);
 * });
 *
 * events.fire({ type: 'foo' }, 'I am bar!');
 *
 * @param {String} [name] the optional event name
 * @param {Object} [event] the event object
 * @param {...Object} additional arguments to be passed to the callback functions
 *
 * @return {Boolean} the events return value, if specified or false if the
 *                   default action was prevented by listeners
 */
EventBus.prototype.fire = function (type, data) {

  var event, firstListener, returnValue, args;

  args = slice.call(arguments);

  if ((typeof type === 'undefined' ? 'undefined' : _typeof(type)) === 'object') {
    event = type;
    type = event.type;
  }

  if (!type) {
    throw new Error('no event type specified');
  }

  firstListener = this._listeners[type];

  if (!firstListener) {
    return;
  }

  // we make sure we fire instances of our home made
  // events here. We wrap them only once, though
  if (data instanceof InternalEvent) {
    // we are fine, we alread have an event
    event = data;
  } else {
    event = this.createEvent(data);
  }

  // ensure we pass the event as the first parameter
  args[0] = event;

  // original event type (in case we delegate)
  var originalType = event.type;

  // update event type before delegation
  if (type !== originalType) {
    event.type = type;
  }

  try {
    returnValue = this._invokeListeners(event, args, firstListener);
  } finally {
    // reset event type after delegation
    if (type !== originalType) {
      event.type = originalType;
    }
  }

  // set the return value to false if the event default
  // got prevented and no other return value exists
  if (returnValue === undefined && event.defaultPrevented) {
    returnValue = false;
  }

  return returnValue;
};

EventBus.prototype.handleError = function (error) {
  return this.fire('error', { error: error }) === false;
};

EventBus.prototype._destroy = function () {
  this._listeners = {};
};

EventBus.prototype._invokeListeners = function (event, args, listener) {

  var returnValue;

  while (listener) {

    // handle stopped propagation
    if (event.cancelBubble) {
      break;
    }

    returnValue = this._invokeListener(event, args, listener);

    listener = listener.next;
  }

  return returnValue;
};

EventBus.prototype._invokeListener = function (event, args, listener) {

  var returnValue;

  try {
    // returning false prevents the default action
    returnValue = invokeFunction(listener.callback, args);

    // stop propagation on return value
    if (returnValue !== undefined) {
      event.returnValue = returnValue;
      event.stopPropagation();
    }

    // prevent default on return false
    if (returnValue === false) {
      event.preventDefault();
    }
  } catch (e) {
    if (!this.handleError(e)) {
      console.error('unhandled error in event listener');
      console.error(e.stack);

      throw e;
    }
  }

  return returnValue;
};

/*
 * Add new listener with a certain priority to the list
 * of listeners (for the given event).
 *
 * The semantics of listener registration / listener execution are
 * first register, first serve: New listeners will always be inserted
 * after existing listeners with the same priority.
 *
 * Example: Inserting two listeners with priority 1000 and 1300
 *
 *    * before: [ 1500, 1500, 1000, 1000 ]
 *    * after: [ 1500, 1500, (new=1300), 1000, 1000, (new=1000) ]
 *
 * @param {String} event
 * @param {Object} listener { priority, callback }
 */
EventBus.prototype._addListener = function (event, newListener) {

  var listener = this._getListeners(event),
      previousListener;

  // no prior listeners
  if (!listener) {
    this._setListeners(event, newListener);

    return;
  }

  // ensure we order listeners by priority from
  // 0 (high) to n > 0 (low)
  while (listener) {

    if (listener.priority < newListener.priority) {

      newListener.next = listener;

      if (previousListener) {
        previousListener.next = newListener;
      } else {
        this._setListeners(event, newListener);
      }

      return;
    }

    previousListener = listener;
    listener = listener.next;
  }

  // add new listener to back
  previousListener.next = newListener;
};

EventBus.prototype._getListeners = function (name) {
  return this._listeners[name];
};

EventBus.prototype._setListeners = function (name, listener) {
  this._listeners[name] = listener;
};

EventBus.prototype._removeListener = function (event, callback) {

  var listener = this._getListeners(event),
      nextListener,
      previousListener,
      listenerCallback;

  if (!callback) {
    // clear listeners
    this._setListeners(event, null);

    return;
  }

  while (listener) {

    nextListener = listener.next;

    listenerCallback = listener.callback;

    if (listenerCallback === callback || listenerCallback[FN_REF] === callback) {
      if (previousListener) {
        previousListener.next = nextListener;
      } else {
        // new first listener
        this._setListeners(event, nextListener);
      }
    }

    previousListener = listener;
    listener = nextListener;
  }
};

/**
 * A event that is emitted via the event bus.
 */
function InternalEvent() {}

InternalEvent.prototype.stopPropagation = function () {
  this.cancelBubble = true;
};

InternalEvent.prototype.preventDefault = function () {
  this.defaultPrevented = true;
};

InternalEvent.prototype.init = function (data) {
  (0, _minDash.assign)(this, data || {});
};

/**
 * Invoke function. Be fast...
 *
 * @param {Function} fn
 * @param {Array<Object>} args
 *
 * @return {Any}
 */
function invokeFunction(fn, args) {
  return fn.apply(null, args);
}

},{"254":254}],98:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = GraphicsFactory;

var _minDash = _dereq_(254);

var _GraphicsUtil = _dereq_(239);

var _SvgTransformUtil = _dereq_(248);

var _minDom = _dereq_(255);

var _tinySvg = _dereq_(275);

var _Elements = _dereq_(235);

/**
 * A factory that creates graphical elements
 *
 * @param {EventBus} eventBus
 * @param {ElementRegistry} elementRegistry
 */
function GraphicsFactory(eventBus, elementRegistry) {
  this._eventBus = eventBus;
  this._elementRegistry = elementRegistry;
}

GraphicsFactory.$inject = ['eventBus', 'elementRegistry'];

GraphicsFactory.prototype._getChildren = function (element) {

  var gfx = this._elementRegistry.getGraphics(element);

  var childrenGfx;

  // root element
  if (!element.parent) {
    childrenGfx = gfx;
  } else {
    childrenGfx = (0, _GraphicsUtil.getChildren)(gfx);
    if (!childrenGfx) {
      childrenGfx = (0, _tinySvg.create)('g');
      (0, _tinySvg.classes)(childrenGfx).add('djs-children');

      (0, _tinySvg.append)(gfx.parentNode, childrenGfx);
    }
  }

  return childrenGfx;
};

/**
 * Clears the graphical representation of the element and returns the
 * cleared visual (the <g class="djs-visual" /> element).
 */
GraphicsFactory.prototype._clear = function (gfx) {
  var visual = (0, _GraphicsUtil.getVisual)(gfx);

  (0, _minDom.clear)(visual);

  return visual;
};

/**
 * Creates a gfx container for shapes and connections
 *
 * The layout is as follows:
 *
 * <g class="djs-group">
 *
 *   <!-- the gfx -->
 *   <g class="djs-element djs-(shape|connection|frame)">
 *     <g class="djs-visual">
 *       <!-- the renderer draws in here -->
 *     </g>
 *
 *     <!-- extensions (overlays, click box, ...) goes here
 *   </g>
 *
 *   <!-- the gfx child nodes -->
 *   <g class="djs-children"></g>
 * </g>
 *
 * @param {String} type the type of the element, i.e. shape | connection
 * @param {Snap<SVGElement>} [childrenGfx]
 * @param {Number} [parentIndex] position to create container in parent
 * @param {Boolean} [isFrame] is frame element
 *
 * @return {SVGElement}
 */
GraphicsFactory.prototype._createContainer = function (type, childrenGfx, parentIndex, isFrame) {
  var outerGfx = (0, _tinySvg.create)('g');
  (0, _tinySvg.classes)(outerGfx).add('djs-group');

  // insert node at position
  if (typeof parentIndex !== 'undefined') {
    prependTo(outerGfx, childrenGfx, childrenGfx.childNodes[parentIndex]);
  } else {
    (0, _tinySvg.append)(childrenGfx, outerGfx);
  }

  var gfx = (0, _tinySvg.create)('g');
  (0, _tinySvg.classes)(gfx).add('djs-element');
  (0, _tinySvg.classes)(gfx).add('djs-' + type);

  if (isFrame) {
    (0, _tinySvg.classes)(gfx).add('djs-frame');
  }

  (0, _tinySvg.append)(outerGfx, gfx);

  // create visual
  var visual = (0, _tinySvg.create)('g');
  (0, _tinySvg.classes)(visual).add('djs-visual');

  (0, _tinySvg.append)(gfx, visual);

  return gfx;
};

GraphicsFactory.prototype.create = function (type, element, parentIndex) {
  var childrenGfx = this._getChildren(element.parent);
  return this._createContainer(type, childrenGfx, parentIndex, (0, _Elements.isFrameElement)(element));
};

GraphicsFactory.prototype.updateContainments = function (elements) {

  var self = this,
      elementRegistry = this._elementRegistry,
      parents;

  parents = (0, _minDash.reduce)(elements, function (map, e) {

    if (e.parent) {
      map[e.parent.id] = e.parent;
    }

    return map;
  }, {});

  // update all parents of changed and reorganized their children
  // in the correct order (as indicated in our model)
  (0, _minDash.forEach)(parents, function (parent) {

    var children = parent.children;

    // no need to update order if less than two children
    if (!children || children.length < 2) {
      return;
    }

    var childGfx = self._getChildren(parent);

    (0, _minDash.forEach)(children.slice().reverse(), function (c) {
      var gfx = elementRegistry.getGraphics(c);

      prependTo(gfx.parentNode, childGfx);
    });
  });
};

GraphicsFactory.prototype.drawShape = function (visual, element) {
  var eventBus = this._eventBus;

  return eventBus.fire('render.shape', { gfx: visual, element: element });
};

GraphicsFactory.prototype.getShapePath = function (element) {
  var eventBus = this._eventBus;

  return eventBus.fire('render.getShapePath', element);
};

GraphicsFactory.prototype.drawConnection = function (visual, element) {
  var eventBus = this._eventBus;

  return eventBus.fire('render.connection', { gfx: visual, element: element });
};

GraphicsFactory.prototype.getConnectionPath = function (waypoints) {
  var eventBus = this._eventBus;

  return eventBus.fire('render.getConnectionPath', waypoints);
};

GraphicsFactory.prototype.update = function (type, element, gfx) {
  // Do not update root element
  if (!element.parent) {
    return;
  }

  var visual = this._clear(gfx);

  // redraw
  if (type === 'shape') {
    this.drawShape(visual, element);

    // update positioning
    (0, _SvgTransformUtil.translate)(gfx, element.x, element.y);
  } else if (type === 'connection') {
    this.drawConnection(visual, element);
  } else {
    throw new Error('unknown type: ' + type);
  }

  if (element.hidden) {
    (0, _tinySvg.attr)(gfx, 'display', 'none');
  } else {
    (0, _tinySvg.attr)(gfx, 'display', 'block');
  }
};

GraphicsFactory.prototype.remove = function (element) {
  var gfx = this._elementRegistry.getGraphics(element);

  // remove
  (0, _tinySvg.remove)(gfx.parentNode);
};

// helpers //////////////////////

function prependTo(newNode, parentNode, siblingNode) {
  parentNode.insertBefore(newNode, siblingNode || parentNode.firstChild);
}

},{"235":235,"239":239,"248":248,"254":254,"255":255,"275":275}],99:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _draw = _dereq_(103);

var _draw2 = _interopRequireDefault(_draw);

var _Canvas = _dereq_(94);

var _Canvas2 = _interopRequireDefault(_Canvas);

var _ElementRegistry = _dereq_(96);

var _ElementRegistry2 = _interopRequireDefault(_ElementRegistry);

var _ElementFactory = _dereq_(95);

var _ElementFactory2 = _interopRequireDefault(_ElementFactory);

var _EventBus = _dereq_(97);

var _EventBus2 = _interopRequireDefault(_EventBus);

var _GraphicsFactory = _dereq_(98);

var _GraphicsFactory2 = _interopRequireDefault(_GraphicsFactory);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_draw2.default],
  __init__: ['canvas'],
  canvas: ['type', _Canvas2.default],
  elementRegistry: ['type', _ElementRegistry2.default],
  elementFactory: ['type', _ElementFactory2.default],
  eventBus: ['type', _EventBus2.default],
  graphicsFactory: ['type', _GraphicsFactory2.default]
};

},{"103":103,"94":94,"95":95,"96":96,"97":97,"98":98}],100:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BaseRenderer;
var DEFAULT_RENDER_PRIORITY = 1000;

/**
 * The base implementation of shape and connection renderers.
 *
 * @param {EventBus} eventBus
 * @param {Number} [renderPriority=1000]
 */
function BaseRenderer(eventBus, renderPriority) {
  var self = this;

  renderPriority = renderPriority || DEFAULT_RENDER_PRIORITY;

  eventBus.on(['render.shape', 'render.connection'], renderPriority, function (evt, context) {
    var type = evt.type,
        element = context.element,
        visuals = context.gfx;

    if (self.canRender(element)) {
      if (type === 'render.shape') {
        return self.drawShape(visuals, element);
      } else {
        return self.drawConnection(visuals, element);
      }
    }
  });

  eventBus.on(['render.getShapePath', 'render.getConnectionPath'], renderPriority, function (evt, element) {
    if (self.canRender(element)) {
      if (evt.type === 'render.getShapePath') {
        return self.getShapePath(element);
      } else {
        return self.getConnectionPath(element);
      }
    }
  });
}

/**
 * Should check whether *this* renderer can render
 * the element/connection.
 *
 * @param {element} element
 *
 * @returns {Boolean}
 */
BaseRenderer.prototype.canRender = function () {};

/**
 * Provides the shape's snap svg element to be drawn on the `canvas`.
 *
 * @param {djs.Graphics} visuals
 * @param {Shape} shape
 *
 * @returns {Snap.svg} [returns a Snap.svg paper element ]
 */
BaseRenderer.prototype.drawShape = function () {};

/**
 * Provides the shape's snap svg element to be drawn on the `canvas`.
 *
 * @param {djs.Graphics} visuals
 * @param {Connection} connection
 *
 * @returns {Snap.svg} [returns a Snap.svg paper element ]
 */
BaseRenderer.prototype.drawConnection = function () {};

/**
 * Gets the SVG path of a shape that represents it's visual bounds.
 *
 * @param {Shape} shape
 *
 * @return {string} svg path
 */
BaseRenderer.prototype.getShapePath = function () {};

/**
 * Gets the SVG path of a connection that represents it's visual bounds.
 *
 * @param {Connection} connection
 *
 * @return {string} svg path
 */
BaseRenderer.prototype.getConnectionPath = function () {};

},{}],101:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DefaultRenderer;

var _inherits = _dereq_(253);

var _inherits2 = _interopRequireDefault(_inherits);

var _BaseRenderer = _dereq_(100);

var _BaseRenderer2 = _interopRequireDefault(_BaseRenderer);

var _RenderUtil = _dereq_(247);

var _tinySvg = _dereq_(275);

var _Elements = _dereq_(235);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// apply default renderer with lowest possible priority
// so that it only kicks in if noone else could render
var DEFAULT_RENDER_PRIORITY = 1;

/**
 * The default renderer used for shapes and connections.
 *
 * @param {EventBus} eventBus
 * @param {Styles} styles
 */
function DefaultRenderer(eventBus, styles) {
  //
  _BaseRenderer2.default.call(this, eventBus, DEFAULT_RENDER_PRIORITY);

  this.CONNECTION_STYLE = styles.style(['no-fill'], { strokeWidth: 5, stroke: 'fuchsia' });
  this.SHAPE_STYLE = styles.style({ fill: 'white', stroke: 'fuchsia', strokeWidth: 2 });
  this.FRAME_STYLE = styles.style(['no-fill'], { stroke: 'fuchsia', strokeDasharray: 4, strokeWidth: 2 });
}

(0, _inherits2.default)(DefaultRenderer, _BaseRenderer2.default);

DefaultRenderer.prototype.canRender = function () {
  return true;
};

DefaultRenderer.prototype.drawShape = function drawShape(visuals, element) {
  var rect = (0, _tinySvg.create)('rect');

  (0, _tinySvg.attr)(rect, {
    x: 0,
    y: 0,
    width: element.width || 0,
    height: element.height || 0
  });

  if ((0, _Elements.isFrameElement)(element)) {
    (0, _tinySvg.attr)(rect, this.FRAME_STYLE);
  } else {
    (0, _tinySvg.attr)(rect, this.SHAPE_STYLE);
  }

  (0, _tinySvg.append)(visuals, rect);

  return rect;
};

DefaultRenderer.prototype.drawConnection = function drawConnection(visuals, connection) {

  var line = (0, _RenderUtil.createLine)(connection.waypoints, this.CONNECTION_STYLE);
  (0, _tinySvg.append)(visuals, line);

  return line;
};

DefaultRenderer.prototype.getShapePath = function getShapePath(shape) {

  var x = shape.x,
      y = shape.y,
      width = shape.width,
      height = shape.height;

  var shapePath = [['M', x, y], ['l', width, 0], ['l', 0, height], ['l', -width, 0], ['z']];

  return (0, _RenderUtil.componentsToPath)(shapePath);
};

DefaultRenderer.prototype.getConnectionPath = function getConnectionPath(connection) {
  var waypoints = connection.waypoints;

  var idx,
      point,
      connectionPath = [];

  for (idx = 0; point = waypoints[idx]; idx++) {

    // take invisible docking into account
    // when creating the path
    point = point.original || point;

    connectionPath.push([idx === 0 ? 'M' : 'L', point.x, point.y]);
  }

  return (0, _RenderUtil.componentsToPath)(connectionPath);
};

DefaultRenderer.$inject = ['eventBus', 'styles'];

},{"100":100,"235":235,"247":247,"253":253,"275":275}],102:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Styles;

var _minDash = _dereq_(254);

/**
 * A component that manages shape styles
 */
function Styles() {

  var defaultTraits = {

    'no-fill': {
      fill: 'none'
    },
    'no-border': {
      strokeOpacity: 0.0
    },
    'no-events': {
      pointerEvents: 'none'
    }
  };

  var self = this;

  /**
   * Builds a style definition from a className, a list of traits and an object of additional attributes.
   *
   * @param  {String} className
   * @param  {Array<String>} traits
   * @param  {Object} additionalAttrs
   *
   * @return {Object} the style defintion
   */
  this.cls = function (className, traits, additionalAttrs) {
    var attrs = this.style(traits, additionalAttrs);

    return (0, _minDash.assign)(attrs, { 'class': className });
  };

  /**
   * Builds a style definition from a list of traits and an object of additional attributes.
   *
   * @param  {Array<String>} traits
   * @param  {Object} additionalAttrs
   *
   * @return {Object} the style defintion
   */
  this.style = function (traits, additionalAttrs) {

    if (!(0, _minDash.isArray)(traits) && !additionalAttrs) {
      additionalAttrs = traits;
      traits = [];
    }

    var attrs = (0, _minDash.reduce)(traits, function (attrs, t) {
      return (0, _minDash.assign)(attrs, defaultTraits[t] || {});
    }, {});

    return additionalAttrs ? (0, _minDash.assign)(attrs, additionalAttrs) : attrs;
  };

  this.computeStyle = function (custom, traits, defaultStyles) {
    if (!(0, _minDash.isArray)(traits)) {
      defaultStyles = traits;
      traits = [];
    }

    return self.style(traits || [], (0, _minDash.assign)({}, defaultStyles, custom || {}));
  };
}

},{"254":254}],103:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _DefaultRenderer = _dereq_(101);

var _DefaultRenderer2 = _interopRequireDefault(_DefaultRenderer);

var _Styles = _dereq_(102);

var _Styles2 = _interopRequireDefault(_Styles);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['defaultRenderer'],
  defaultRenderer: ['type', _DefaultRenderer2.default],
  styles: ['type', _Styles2.default]
};

},{"101":101,"102":102}],104:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AttachSupport;

var _minDash = _dereq_(254);

var _Removal = _dereq_(246);

var _Collections = _dereq_(233);

var _AttachUtil = _dereq_(231);

var _inherits = _dereq_(253);

var _inherits2 = _interopRequireDefault(_inherits);

var _CommandInterceptor = _dereq_(91);

var _CommandInterceptor2 = _interopRequireDefault(_CommandInterceptor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LOW_PRIORITY = 251,
    HIGH_PRIORITY = 1401;

var MARKER_ATTACH = 'attach-ok';

/**
 * Adds the notion of attached elements to the modeler.
 *
 * Optionally depends on `diagram-js/lib/features/move` to render
 * the attached elements during move preview.
 *
 * Optionally depends on `diagram-js/lib/features/label-support`
 * to render attached labels during move preview.
 *
 * @param {didi.Injector} injector
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {Rules} rules
 * @param {Modeling} modeling
 */
function AttachSupport(injector, eventBus, canvas, rules, modeling) {

  _CommandInterceptor2.default.call(this, eventBus);

  var movePreview = injector.get('movePreview', false);

  // remove all the attached elements from the shapes to be validated
  // add all the attached shapes to the overall list of moved shapes
  eventBus.on('shape.move.start', HIGH_PRIORITY, function (e) {

    var context = e.context,
        shapes = context.shapes,
        validatedShapes = context.validatedShapes;

    context.shapes = addAttached(shapes);

    context.validatedShapes = removeAttached(validatedShapes);
  });

  // add attachers to the visual's group
  movePreview && eventBus.on('shape.move.start', LOW_PRIORITY, function (e) {

    var context = e.context,
        shapes = context.shapes,
        attachers = getAttachers(shapes);

    (0, _minDash.forEach)(attachers, function (attacher) {
      movePreview.makeDraggable(context, attacher, true);

      (0, _minDash.forEach)(attacher.labels, function (label) {
        movePreview.makeDraggable(context, label, true);
      });
    });
  });

  // add attach-ok marker to current host
  movePreview && eventBus.on('shape.move.start', function (event) {
    var context = event.context,
        shapes = context.shapes;

    if (shapes.length !== 1) {
      return;
    }

    var shape = shapes[0];

    var host = shape.host;

    if (host) {
      canvas.addMarker(host, MARKER_ATTACH);

      eventBus.once(['shape.move.out', 'shape.move.cleanup'], function () {
        canvas.removeMarker(host, MARKER_ATTACH);
      });
    }
  });

  // add all attachers to move closure
  this.preExecuted('elements.move', HIGH_PRIORITY, function (e) {
    var context = e.context,
        closure = context.closure,
        shapes = context.shapes,
        attachers = getAttachers(shapes);

    (0, _minDash.forEach)(attachers, function (attacher) {
      closure.add(attacher, closure.topLevel[attacher.host.id]);
    });
  });

  // perform the attaching after shapes are done moving
  this.postExecuted('elements.move', function (e) {

    var context = e.context,
        shapes = context.shapes,
        newHost = context.newHost,
        attachers;

    // we only support attachment / detachment of one element
    if (shapes.length !== 1) {
      return;
    }

    if (newHost) {

      attachers = shapes;
    } else {

      attachers = (0, _minDash.filter)(shapes, function (s) {
        return !!s.host;
      });
    }

    (0, _minDash.forEach)(attachers, function (attacher) {
      modeling.updateAttachment(attacher, newHost);
    });
  });

  // ensure invalid attachment connections are removed
  this.postExecuted('elements.move', function (e) {

    var shapes = e.context.shapes;

    (0, _minDash.forEach)(shapes, function (shape) {

      (0, _minDash.forEach)(shape.attachers, function (attacher) {

        // remove invalid outgoing connections
        (0, _minDash.forEach)(attacher.outgoing.slice(), function (connection) {
          var allowed = rules.allowed('connection.reconnectStart', {
            connection: connection,
            source: connection.source,
            target: connection.target
          });

          if (!allowed) {
            modeling.removeConnection(connection);
          }
        });

        // remove invalid incoming connections
        (0, _minDash.forEach)(attacher.incoming.slice(), function (connection) {
          var allowed = rules.allowed('connection.reconnectEnd', {
            connection: connection,
            source: connection.source,
            target: connection.target
          });

          if (!allowed) {
            modeling.removeConnection(connection);
          }
        });
      });
    });
  });

  this.postExecute('shape.create', function (e) {
    var context = e.context,
        shape = context.shape,
        host = context.host;

    if (host) {
      modeling.updateAttachment(shape, host);
    }
  });

  // update attachments if the host is replaced
  this.postExecute('shape.replace', function (e) {

    var context = e.context,
        oldShape = context.oldShape,
        newShape = context.newShape;

    // move the attachers to the new host
    (0, _Removal.saveClear)(oldShape.attachers, function (attacher) {
      var allowed = rules.allowed('elements.move', {
        target: newShape,
        shapes: [attacher]
      });

      if (allowed === 'attach') {
        modeling.updateAttachment(attacher, newShape);
      } else {
        modeling.removeShape(attacher);
      }
    });

    // move attachers if new host has different size
    if (newShape.attachers.length) {

      (0, _minDash.forEach)(newShape.attachers, function (attacher) {
        var delta = (0, _AttachUtil.getNewAttachShapeDelta)(attacher, oldShape, newShape);
        modeling.moveShape(attacher, delta, attacher.parent);
      });
    }
  });

  // move shape on host resize
  this.postExecute('shape.resize', function (event) {
    var context = event.context,
        shape = context.shape,
        oldBounds = context.oldBounds,
        newBounds = context.newBounds,
        attachers = shape.attachers;

    (0, _minDash.forEach)(attachers, function (attacher) {
      var delta = (0, _AttachUtil.getNewAttachShapeDelta)(attacher, oldBounds, newBounds);

      modeling.moveShape(attacher, delta, attacher.parent);

      (0, _minDash.forEach)(attacher.labels, function (label) {
        modeling.moveShape(label, delta, label.parent);
      });
    });
  });

  // remove attachments
  this.preExecute('shape.delete', function (event) {

    var shape = event.context.shape;

    (0, _Removal.saveClear)(shape.attachers, function (attacher) {
      modeling.removeShape(attacher);
    });

    if (shape.host) {
      modeling.updateAttachment(shape, null);
    }
  });

  // Prevent attachers and their labels from moving, when the space tool is performed.
  // Otherwise the attachers and their labels would be moved twice.
  eventBus.on('spaceTool.move', function (event) {

    var context = event.context,
        initialized = context.initialized,
        attachSupportInitialized = context.attachSupportInitialized;

    if (!initialized || attachSupportInitialized) {
      return;
    }

    var movingShapes = context.movingShapes;

    // collect attachers whose host is not being moved using the space tool
    var staticAttachers = (0, _minDash.filter)(movingShapes, function (shape) {
      var host = shape.host;

      return host && movingShapes.indexOf(host) === -1;
    });

    // remove attachers that are not going to be moved from moving shapes
    (0, _minDash.forEach)(staticAttachers, function (shape) {
      (0, _Collections.remove)(movingShapes, shape);

      (0, _minDash.forEach)(shape.labels, function (label) {
        (0, _Collections.remove)(movingShapes, shape.label);
      });
    });

    context.attachSupportInitialized = true;
  });
}

(0, _inherits2.default)(AttachSupport, _CommandInterceptor2.default);

AttachSupport.$inject = ['injector', 'eventBus', 'canvas', 'rules', 'modeling'];

/**
 * Return attachers of the given shapes
 *
 * @param {Array<djs.model.Base>} shapes
 * @return {Array<djs.model.Base>}
 */
function getAttachers(shapes) {
  return (0, _minDash.flatten)((0, _minDash.map)(shapes, function (s) {
    return s.attachers || [];
  }));
}

/**
 * Return a combined list of elements and
 * attachers.
 *
 * @param {Array<djs.model.Base>} elements
 * @return {Array<djs.model.Base>} filtered
 */
function addAttached(elements) {
  var attachers = getAttachers(elements);

  return (0, _minDash.unionBy)('id', elements, attachers);
}

/**
 * Return a filtered list of elements that do not
 * contain attached elements with hosts being part
 * of the selection.
 *
 * @param  {Array<djs.model.Base>} elements
 *
 * @return {Array<djs.model.Base>} filtered
 */
function removeAttached(elements) {

  var ids = (0, _minDash.groupBy)(elements, 'id');

  return (0, _minDash.filter)(elements, function (element) {
    while (element) {

      // host in selection
      if (element.host && ids[element.host.id]) {
        return false;
      }

      element = element.parent;
    }

    return true;
  });
}

},{"231":231,"233":233,"246":246,"253":253,"254":254,"91":91}],105:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _rules = _dereq_(200);

var _rules2 = _interopRequireDefault(_rules);

var _AttachSupport = _dereq_(104);

var _AttachSupport2 = _interopRequireDefault(_AttachSupport);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_rules2.default],
  __init__: ['attachSupport'],
  attachSupport: ['type', _AttachSupport2.default]
};

},{"104":104,"200":200}],106:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AutoResize;

var _inherits = _dereq_(253);

var _inherits2 = _interopRequireDefault(_inherits);

var _Elements = _dereq_(235);

var _LayoutUtil = _dereq_(221);

var _minDash = _dereq_(254);

var _CommandInterceptor = _dereq_(91);

var _CommandInterceptor2 = _interopRequireDefault(_CommandInterceptor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * An auto resize component that takes care of expanding a parent element
 * if child elements are created or moved close the parents edge.
 *
 * @param {EventBus} eventBus
 * @param {ElementRegistry} elementRegistry
 * @param {Modeling} modeling
 * @param {Rules} rules
 */
function AutoResize(eventBus, elementRegistry, modeling, rules) {

  _CommandInterceptor2.default.call(this, eventBus);

  this._elementRegistry = elementRegistry;
  this._modeling = modeling;
  this._rules = rules;

  var self = this;

  this.postExecuted(['shape.create'], function (event) {
    var context = event.context,
        hints = context.hints,
        shape = context.shape,
        parent = context.parent || context.newParent;

    if (hints && (hints.root === false || hints.autoResize === false)) {
      return;
    }

    self._expand([shape], parent);
  });

  this.postExecuted(['elements.move'], function (event) {
    var context = event.context,
        elements = (0, _minDash.flatten)((0, _minDash.values)(context.closure.topLevel)),
        hints = context.hints;

    var autoResize = hints ? hints.autoResize : true;

    if (autoResize === false) {
      return;
    }

    var expandings = (0, _minDash.groupBy)(elements, function (element) {
      return element.parent.id;
    });

    (0, _minDash.forEach)(expandings, function (elements, parentId) {

      // optionally filter elements to be considered when resizing
      if ((0, _minDash.isArray)(autoResize)) {
        elements = elements.filter(function (element) {
          return autoResize.indexOf(element) !== -1;
        });
      }

      self._expand(elements, parentId);
    });
  });

  this.postExecuted(['shape.toggleCollapse'], function (event) {
    var context = event.context,
        hints = context.hints,
        shape = context.shape;

    if (hints && (hints.root === false || hints.autoResize === false)) {
      return;
    }

    if (shape.collapsed) {
      return;
    }

    self._expand(shape.children || [], shape);
  });

  this.postExecuted(['shape.resize'], function (event) {
    var context = event.context,
        hints = context.hints,
        shape = context.shape,
        parent = shape.parent;

    if (hints && (hints.root === false || hints.autoResize === false)) {
      return;
    }

    if (parent) {
      self._expand([shape], parent);
    }
  });
}

AutoResize.$inject = ['eventBus', 'elementRegistry', 'modeling', 'rules'];

(0, _inherits2.default)(AutoResize, _CommandInterceptor2.default);

/**
 * Calculate the new bounds of the target shape, given
 * a number of elements have been moved or added into the parent.
 *
 * This method considers the current size, the added elements as well as
 * the provided padding for the new bounds.
 *
 * @param {Array<djs.model.Shape>} elements
 * @param {djs.model.Shape} target
 */
AutoResize.prototype._getOptimalBounds = function (elements, target) {

  var offset = this.getOffset(target),
      padding = this.getPadding(target);

  var elementsTrbl = (0, _LayoutUtil.asTRBL)((0, _Elements.getBBox)(elements)),
      targetTrbl = (0, _LayoutUtil.asTRBL)(target);

  var newTrbl = {};

  if (elementsTrbl.top - targetTrbl.top < padding.top) {
    newTrbl.top = elementsTrbl.top - offset.top;
  }

  if (elementsTrbl.left - targetTrbl.left < padding.left) {
    newTrbl.left = elementsTrbl.left - offset.left;
  }

  if (targetTrbl.right - elementsTrbl.right < padding.right) {
    newTrbl.right = elementsTrbl.right + offset.right;
  }

  if (targetTrbl.bottom - elementsTrbl.bottom < padding.bottom) {
    newTrbl.bottom = elementsTrbl.bottom + offset.bottom;
  }

  return (0, _LayoutUtil.asBounds)((0, _minDash.assign)({}, targetTrbl, newTrbl));
};

/**
 * Expand the target shape respecting rules, offset and padding
 *
 * @param {Array<djs.model.Shape>} elements
 * @param {djs.model.Shape|String} target|targetId
 */
AutoResize.prototype._expand = function (elements, target) {

  if (typeof target === 'string') {
    target = this._elementRegistry.get(target);
  }

  var allowed = this._rules.allowed('element.autoResize', {
    elements: elements,
    target: target
  });

  if (!allowed) {
    return;
  }

  // calculate the new bounds
  var newBounds = this._getOptimalBounds(elements, target);

  if (!boundsChanged(newBounds, target)) {
    return;
  }

  var resizeDirections = getResizeDirections((0, _minDash.pick)(target, ['x', 'y', 'width', 'height']), newBounds);

  // resize the parent shape
  this.resize(target, newBounds, {
    autoResize: resizeDirections
  });

  var parent = target.parent;

  // recursively expand parent elements
  if (parent) {
    this._expand([target], parent);
  }
};

/**
 * Get the amount to expand the given shape in each direction.
 *
 * @param {djs.model.Shape} shape
 *
 * @return {TRBL}
 */
AutoResize.prototype.getOffset = function (shape) {
  return { top: 60, bottom: 60, left: 100, right: 100 };
};

/**
 * Get the activation threshold for each side for which
 * resize triggers.
 *
 * @param {djs.model.Shape} shape
 *
 * @return {TRBL}
 */
AutoResize.prototype.getPadding = function (shape) {
  return { top: 2, bottom: 2, left: 15, right: 15 };
};

/**
 * Perform the actual resize operation.
 *
 * @param {djs.model.Shape} shape
 * @param {Bounds} newBounds
 * @param {Object} [hints]
 * @param {string} [hints.autoResize]
 */
AutoResize.prototype.resize = function (shape, newBounds, hints) {
  this._modeling.resizeShape(shape, newBounds, null, hints);
};

function boundsChanged(newBounds, oldBounds) {
  return newBounds.x !== oldBounds.x || newBounds.y !== oldBounds.y || newBounds.width !== oldBounds.width || newBounds.height !== oldBounds.height;
}

/**
 * Get directions of resize as {n|w|s|e} e.g. "nw".
 *
 * @param {Bounds} oldBounds
 * @param {Bounds} newBounds
 *
 * @returns {string} Resize directions as {n|w|s|e}.
 */
function getResizeDirections(oldBounds, newBounds) {
  var directions = '';

  oldBounds = (0, _LayoutUtil.asTRBL)(oldBounds);
  newBounds = (0, _LayoutUtil.asTRBL)(newBounds);

  if (oldBounds.top > newBounds.top) {
    directions = directions.concat('n');
  }

  if (oldBounds.right < newBounds.right) {
    directions = directions.concat('w');
  }

  if (oldBounds.bottom < newBounds.bottom) {
    directions = directions.concat('s');
  }

  if (oldBounds.left > newBounds.left) {
    directions = directions.concat('e');
  }

  return directions;
}

},{"221":221,"235":235,"253":253,"254":254,"91":91}],107:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AutoResizeProvider;

var _RuleProvider = _dereq_(198);

var _RuleProvider2 = _interopRequireDefault(_RuleProvider);

var _inherits = _dereq_(253);

var _inherits2 = _interopRequireDefault(_inherits);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This is a base rule provider for the element.autoResize rule.
 */
function AutoResizeProvider(eventBus) {

  _RuleProvider2.default.call(this, eventBus);

  var self = this;

  this.addRule('element.autoResize', function (context) {
    return self.canResize(context.elements, context.target);
  });
}

AutoResizeProvider.$inject = ['eventBus'];

(0, _inherits2.default)(AutoResizeProvider, _RuleProvider2.default);

/**
 * Needs to be implemented by sub classes to allow actual auto resize
 *
 * @param  {Array<djs.model.Shape>} elements
 * @param  {djs.model.Shape} target
 *
 * @return {Boolean}
 */
AutoResizeProvider.prototype.canResize = function (elements, target) {
  return false;
};

},{"198":198,"253":253}],108:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _AutoResize = _dereq_(106);

var _AutoResize2 = _interopRequireDefault(_AutoResize);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['autoResize'],
  autoResize: ['type', _AutoResize2.default]
};

},{"106":106}],109:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AutoScroll;

var _minDash = _dereq_(254);

var _Event = _dereq_(237);

/**
 * Initiates canvas scrolling if current cursor point is close to a border.
 * Cancelled when current point moves back inside the scrolling borders
 * or cancelled manually.
 *
 * Default options :
 *   scrollThresholdIn: [ 20, 20, 20, 20 ],
 *   scrollThresholdOut: [ 0, 0, 0, 0 ],
 *   scrollRepeatTimeout: 15,
 *   scrollStep: 10
 *
 * Threshold order:
 *   [ left, top, right, bottom ]
 */
function AutoScroll(config, eventBus, canvas, mouseTracking) {

  this._canvas = canvas;
  this._mouseTracking = mouseTracking;

  this._opts = (0, _minDash.assign)({
    scrollThresholdIn: [20, 20, 20, 20],
    scrollThresholdOut: [0, 0, 0, 0],
    scrollRepeatTimeout: 15,
    scrollStep: 10
  }, config);

  var self = this;

  eventBus.on('drag.move', function (e) {
    var point = self._toBorderPoint(e);

    self.startScroll(point);
  });

  eventBus.on(['drag.cleanup'], function () {
    self.stopScroll();
  });
}

AutoScroll.$inject = ['config.autoScroll', 'eventBus', 'canvas', 'mouseTracking'];

/**
 * Starts scrolling loop.
 * Point is given in global scale in canvas container box plane.
 *
 * @param  {Object} point { x: X, y: Y }
 */
AutoScroll.prototype.startScroll = function (point) {

  var canvas = this._canvas;
  var opts = this._opts;
  var self = this;

  var clientRect = canvas.getContainer().getBoundingClientRect();

  var diff = [point.x, point.y, clientRect.width - point.x, clientRect.height - point.y];

  this.stopScroll();

  var dx = 0,
      dy = 0;

  for (var i = 0; i < 4; i++) {
    if (between(diff[i], opts.scrollThresholdOut[i], opts.scrollThresholdIn[i])) {
      if (i === 0) {
        dx = opts.scrollStep;
      } else if (i == 1) {
        dy = opts.scrollStep;
      } else if (i == 2) {
        dx = -opts.scrollStep;
      } else if (i == 3) {
        dy = -opts.scrollStep;
      }
    }
  }

  if (dx !== 0 || dy !== 0) {
    canvas.scroll({ dx: dx, dy: dy });

    this._scrolling = setTimeout(function () {
      self.startScroll(point);
    }, opts.scrollRepeatTimeout);
  }
};

function between(val, start, end) {
  if (start < val && val < end) {
    return true;
  }

  return false;
}

/**
 * Stops scrolling loop.
 */
AutoScroll.prototype.stopScroll = function () {
  clearTimeout(this._scrolling);
};

/**
 * Overrides defaults options.
 *
 * @param  {Object} options
 */
AutoScroll.prototype.setOptions = function (options) {
  this._opts = (0, _minDash.assign)({}, this._opts, options);
};

/**
 * Converts event to a point in canvas container plane in global scale.
 *
 * @param  {Event} event
 * @return {Point}
 */
AutoScroll.prototype._toBorderPoint = function (event) {
  var clientRect = this._canvas._container.getBoundingClientRect();

  var globalPosition = (0, _Event.toPoint)(event.originalEvent);

  return {
    x: globalPosition.x - clientRect.left,
    y: globalPosition.y - clientRect.top
  };
};

},{"237":237,"254":254}],110:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _dragging = _dereq_(131);

var _dragging2 = _interopRequireDefault(_dragging);

var _mouseTracking = _dereq_(176);

var _mouseTracking2 = _interopRequireDefault(_mouseTracking);

var _AutoScroll = _dereq_(109);

var _AutoScroll2 = _interopRequireDefault(_AutoScroll);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_dragging2.default, _mouseTracking2.default],
  __init__: ['autoScroll'],
  autoScroll: ['type', _AutoScroll2.default]
};

},{"109":109,"131":131,"176":176}],111:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BendpointMove;

var _LayoutUtil = _dereq_(221);

var COMMAND_BENDPOINT_UPDATE = 'connection.updateWaypoints',
    COMMAND_RECONNECT_START = 'connection.reconnectStart',
    COMMAND_RECONNECT_END = 'connection.reconnectEnd';

var round = Math.round;

/**
 * A component that implements moving of bendpoints
 */
function BendpointMove(injector, eventBus, canvas, dragging, rules, modeling) {

  // optional connection docking integration
  var connectionDocking = injector.get('connectionDocking', false);

  // API
  this.start = function (event, connection, bendpointIndex, insert) {

    var type,
        context,
        waypoints = connection.waypoints,
        gfx = canvas.getGraphics(connection);

    if (!insert && bendpointIndex === 0) {
      type = COMMAND_RECONNECT_START;
    } else if (!insert && bendpointIndex === waypoints.length - 1) {
      type = COMMAND_RECONNECT_END;
    } else {
      type = COMMAND_BENDPOINT_UPDATE;
    }

    context = {
      connection: connection,
      bendpointIndex: bendpointIndex,
      insert: insert,
      type: type
    };

    var allowed = context.allowed = rules.allowed(context.type, context);

    if (allowed === false) {
      return;
    }

    dragging.init(event, 'bendpoint.move', {
      data: {
        connection: connection,
        connectionGfx: gfx,
        context: context
      }
    });
  };

  eventBus.on('bendpoint.move.hover', function (e) {
    var context = e.context;

    context.hover = e.hover;

    if (e.hover) {
      // asks whether reconnect / bendpoint move / bendpoint add
      // is allowed at the given position
      var allowed = context.allowed = rules.allowed(context.type, context);

      if (allowed) {
        context.target = context.hover;
      }
    }
  });

  eventBus.on(['bendpoint.move.out', 'bendpoint.move.cleanup'], function (event) {
    var context = event.context;

    context.target = null;
    context.allowed = false;
  });

  eventBus.on('bendpoint.move.end', function (e) {

    var context = e.context,
        connection = context.connection,
        originalWaypoints = connection.waypoints,
        newWaypoints = originalWaypoints.slice(),
        bendpointIndex = context.bendpointIndex,
        allowed = context.allowed,
        insert = context.insert,
        bendpoint,
        hints;

    // ensure we have actual pixel values bendpoint
    // coordinates (important when zoom level was > 1 during move)
    bendpoint = {
      x: round(e.x),
      y: round(e.y)
    };

    if (allowed && context.type === COMMAND_RECONNECT_START) {
      modeling.reconnectStart(context.connection, context.target, bendpoint);
    } else if (allowed && context.type === COMMAND_RECONNECT_END) {
      modeling.reconnectEnd(context.connection, context.target, bendpoint);
    } else if (allowed !== false && context.type === COMMAND_BENDPOINT_UPDATE) {
      if (insert) {
        // insert new bendpoint
        newWaypoints.splice(bendpointIndex, 0, bendpoint);
      } else {
        // swap previous waypoint with the moved one
        newWaypoints[bendpointIndex] = bendpoint;
      }

      // pass hints on the actual moved bendpoint
      // this is useful for connection and label layouting
      hints = {
        bendpointMove: {
          insert: insert,
          bendpointIndex: bendpointIndex
        }
      };

      if (connectionDocking) {
        // (0) temporarily assign new waypoints
        connection.waypoints = newWaypoints;

        // (1) crop connection with new waypoints and save them
        connection.waypoints = connectionDocking.getCroppedWaypoints(connection);
        newWaypoints = connection.waypoints;

        // (2) restore original waypoints to not mutate connection directly
        connection.waypoints = originalWaypoints;
      }

      modeling.updateWaypoints(context.connection, (0, _LayoutUtil.filterRedundantWaypoints)(newWaypoints), hints);
    } else {
      return false;
    }
  });
}

BendpointMove.$inject = ['injector', 'eventBus', 'canvas', 'dragging', 'rules', 'modeling'];

},{"221":221}],112:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BendpointMovePreview;

var _tinySvg = _dereq_(275);

var _BendpointUtil = _dereq_(114);

var _LayoutUtil = _dereq_(221);

var _SvgTransformUtil = _dereq_(248);

var MARKER_OK = 'connect-ok',
    MARKER_NOT_OK = 'connect-not-ok',
    MARKER_CONNECT_HOVER = 'connect-hover',
    MARKER_CONNECT_UPDATING = 'djs-updating',
    MARKER_ELEMENT_HIDDEN = 'djs-element-hidden';

var COMMAND_RECONNECT_START = 'connection.reconnectStart',
    COMMAND_RECONNECT_END = 'connection.reconnectEnd';

var HIGH_PRIORITY = 1100;

/**
 * A component that implements moving of bendpoints
 */
function BendpointMovePreview(injector, eventBus, canvas) {

  var connectionPreview = injector.get('connectionPreview', false),
      connectionDocking = injector.get('connectionDocking', false);

  // DRAGGING IMPLEMENTATION

  eventBus.on('bendpoint.move.start', function (e) {

    var context = e.context,
        connection = context.connection,
        originalWaypoints = connection.waypoints,
        waypoints = originalWaypoints.slice(),
        insert = context.insert,
        idx = context.bendpointIndex;

    // save waypoints to restore at the end
    context.originalWaypoints = originalWaypoints;

    if (insert) {
      // insert placeholder for bendpoint to-be-added
      waypoints.splice(idx, 0, { x: e.x, y: e.y });
    }

    connection.waypoints = waypoints;

    // add dragger gfx
    context.draggerGfx = (0, _BendpointUtil.addBendpoint)(canvas.getLayer('overlays'));
    (0, _tinySvg.classes)(context.draggerGfx).add('djs-dragging');

    canvas.addMarker(connection, MARKER_CONNECT_UPDATING);
    canvas.addMarker(connection, MARKER_ELEMENT_HIDDEN);
  });

  eventBus.on('bendpoint.move.hover', function (e) {
    var context = e.context,
        allowed = context.allowed,
        hover = context.hover;

    if (e.hover) {
      canvas.addMarker(hover, MARKER_CONNECT_HOVER);

      if (allowed) {
        canvas.removeMarker(hover, MARKER_NOT_OK);
        canvas.addMarker(hover, MARKER_OK);
      } else if (allowed === false) {
        canvas.removeMarker(hover, MARKER_OK);
        canvas.addMarker(hover, MARKER_NOT_OK);
      }
    }
  });

  eventBus.on(['bendpoint.move.out', 'bendpoint.move.cleanup'], HIGH_PRIORITY, function (e) {

    // remove connect marker
    // if it was added
    var hover = e.context.hover;

    if (hover) {
      canvas.removeMarker(hover, MARKER_CONNECT_HOVER);
      canvas.removeMarker(hover, e.context.target ? MARKER_OK : MARKER_NOT_OK);
    }
  });

  eventBus.on('bendpoint.move.move', function (e) {

    var context = e.context,
        moveType = context.type,
        connection = e.connection,
        originalWaypoints = connection.waypoints,
        waypoints = originalWaypoints.slice(),
        bendpoint = { x: e.x, y: e.y },
        hints;

    if (connectionPreview) {
      hints = {
        source: connection.source,
        target: connection.target
      };

      if (moveType === COMMAND_RECONNECT_START) {
        hints.source = context.target;
        hints.connectionStart = bendpoint;
      } else if (moveType === COMMAND_RECONNECT_END) {
        hints.target = context.target;
        hints.connectionEnd = bendpoint;
      } else {
        hints.noCropping = true;
        hints.noLayout = true;
        waypoints[context.bendpointIndex] = bendpoint;
      }

      if (connectionDocking) {
        // (0) temporarily assign new waypoints
        connection.waypoints = waypoints;

        // (1) crop connection with new waypoints and save them
        connection.waypoints = connectionDocking.getCroppedWaypoints(connection);
        waypoints = connection.waypoints;

        // (2) restore original waypoints to not mutate connection directly
        connection.waypoints = originalWaypoints;
      }

      // remove overlapping points
      hints.waypoints = (0, _LayoutUtil.filterRedundantWaypoints)(waypoints);

      connectionPreview.drawPreview(context, context.allowed, hints);
    }

    // add dragger gfx
    (0, _SvgTransformUtil.translate)(context.draggerGfx, e.x, e.y);
  });

  eventBus.on(['bendpoint.move.end', 'bendpoint.move.cancel'], HIGH_PRIORITY, function (e) {

    var context = e.context,
        hover = context.hover,
        connection = context.connection;

    // reassign original waypoints
    connection.waypoints = context.originalWaypoints;

    // remove dragger gfx
    (0, _tinySvg.remove)(context.draggerGfx);

    canvas.removeMarker(connection, MARKER_CONNECT_UPDATING);
    canvas.removeMarker(connection, MARKER_ELEMENT_HIDDEN);

    if (hover) {
      canvas.removeMarker(hover, MARKER_OK);
      canvas.removeMarker(hover, context.target ? MARKER_OK : MARKER_NOT_OK);
    }

    if (connectionPreview) {
      connectionPreview.cleanUp(context);
    }
  });
}

BendpointMovePreview.$inject = ['injector', 'eventBus', 'canvas'];

},{"114":114,"221":221,"248":248,"275":275}],113:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BendpointSnapping;

var _minDash = _dereq_(254);

var _SnapUtil = _dereq_(210);

var abs = Math.abs,
    round = Math.round;

var TOLERANCE = 10;

function BendpointSnapping(eventBus) {

  function snapTo(values, value) {

    if ((0, _minDash.isArray)(values)) {
      var i = values.length;

      while (i--) {
        if (abs(values[i] - value) <= TOLERANCE) {
          return values[i];
        }
      }
    } else {
      values = +values;
      var rem = value % values;

      if (rem < TOLERANCE) {
        return value - rem;
      }

      if (rem > values - TOLERANCE) {
        return value - rem + values;
      }
    }

    return value;
  }

  function mid(element) {
    if (element.width) {
      return {
        x: round(element.width / 2 + element.x),
        y: round(element.height / 2 + element.y)
      };
    }
  }

  // connection segment snapping //////////////////////

  function getConnectionSegmentSnaps(context) {

    var snapPoints = context.snapPoints,
        connection = context.connection,
        waypoints = connection.waypoints,
        segmentStart = context.segmentStart,
        segmentStartIndex = context.segmentStartIndex,
        segmentEnd = context.segmentEnd,
        segmentEndIndex = context.segmentEndIndex,
        axis = context.axis;

    if (snapPoints) {
      return snapPoints;
    }

    var referenceWaypoints = [waypoints[segmentStartIndex - 1], segmentStart, segmentEnd, waypoints[segmentEndIndex + 1]];

    if (segmentStartIndex < 2) {
      referenceWaypoints.unshift(mid(connection.source));
    }

    if (segmentEndIndex > waypoints.length - 3) {
      referenceWaypoints.unshift(mid(connection.target));
    }

    context.snapPoints = snapPoints = { horizontal: [], vertical: [] };

    (0, _minDash.forEach)(referenceWaypoints, function (p) {
      // we snap on existing bendpoints only,
      // not placeholders that are inserted during add
      if (p) {
        p = p.original || p;

        if (axis === 'y') {
          snapPoints.horizontal.push(p.y);
        }

        if (axis === 'x') {
          snapPoints.vertical.push(p.x);
        }
      }
    });

    return snapPoints;
  }

  eventBus.on('connectionSegment.move.move', 1500, function (event) {
    var context = event.context,
        snapPoints = getConnectionSegmentSnaps(context),
        x = event.x,
        y = event.y,
        sx,
        sy;

    if (!snapPoints) {
      return;
    }

    // snap
    sx = snapTo(snapPoints.vertical, x);
    sy = snapTo(snapPoints.horizontal, y);

    // correction x/y
    var cx = x - sx,
        cy = y - sy;

    // update delta
    (0, _minDash.assign)(event, {
      dx: event.dx - cx,
      dy: event.dy - cy,
      x: sx,
      y: sy
    });

    // only set snapped if actually snapped
    if (cx || snapPoints.vertical.indexOf(x) !== -1) {
      (0, _SnapUtil.setSnapped)(event, 'x', sx);
    }

    if (cy || snapPoints.horizontal.indexOf(y) !== -1) {
      (0, _SnapUtil.setSnapped)(event, 'y', sy);
    }
  });

  // bendpoint snapping //////////////////////

  function getBendpointSnaps(context) {

    var snapPoints = context.snapPoints,
        waypoints = context.connection.waypoints,
        bendpointIndex = context.bendpointIndex;

    if (snapPoints) {
      return snapPoints;
    }

    var referenceWaypoints = [waypoints[bendpointIndex - 1], waypoints[bendpointIndex + 1]];

    context.snapPoints = snapPoints = { horizontal: [], vertical: [] };

    (0, _minDash.forEach)(referenceWaypoints, function (p) {
      // we snap on existing bendpoints only,
      // not placeholders that are inserted during add
      if (p) {
        p = p.original || p;

        snapPoints.horizontal.push(p.y);
        snapPoints.vertical.push(p.x);
      }
    });

    return snapPoints;
  }

  eventBus.on(['bendpoint.move.move', 'bendpoint.move.end'], 1500, function (event) {

    var context = event.context,
        snapPoints = getBendpointSnaps(context),
        target = context.target,
        targetMid = target && mid(target),
        x = event.x,
        y = event.y,
        sx,
        sy;

    if (!snapPoints) {
      return;
    }

    // snap
    sx = snapTo(targetMid ? snapPoints.vertical.concat([targetMid.x]) : snapPoints.vertical, x);
    sy = snapTo(targetMid ? snapPoints.horizontal.concat([targetMid.y]) : snapPoints.horizontal, y);

    // correction x/y
    var cx = x - sx,
        cy = y - sy;

    // update delta
    (0, _minDash.assign)(event, {
      dx: event.dx - cx,
      dy: event.dy - cy,
      x: event.x - cx,
      y: event.y - cy
    });

    // only set snapped if actually snapped
    if (cx || snapPoints.vertical.indexOf(x) !== -1) {
      (0, _SnapUtil.setSnapped)(event, 'x', sx);
    }

    if (cy || snapPoints.horizontal.indexOf(y) !== -1) {
      (0, _SnapUtil.setSnapped)(event, 'y', sy);
    }
  });
}

BendpointSnapping.$inject = ['eventBus'];

},{"210":210,"254":254}],114:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEGMENT_DRAGGER_CLS = exports.BENDPOINT_CLS = undefined;
exports.toCanvasCoordinates = toCanvasCoordinates;
exports.getConnectionIntersection = getConnectionIntersection;
exports.addBendpoint = addBendpoint;
exports.addSegmentDragger = addSegmentDragger;
exports.calculateSegmentMoveRegion = calculateSegmentMoveRegion;

var _Event = _dereq_(237);

var _Geometry = _dereq_(238);

var _tinySvg = _dereq_(275);

var _SvgTransformUtil = _dereq_(248);

var _LineIntersection = _dereq_(241);

var BENDPOINT_CLS = exports.BENDPOINT_CLS = 'djs-bendpoint';
var SEGMENT_DRAGGER_CLS = exports.SEGMENT_DRAGGER_CLS = 'djs-segment-dragger';

function toCanvasCoordinates(canvas, event) {

  var position = (0, _Event.toPoint)(event),
      clientRect = canvas._container.getBoundingClientRect(),
      offset;

  // canvas relative position

  offset = {
    x: clientRect.left,
    y: clientRect.top
  };

  // update actual event payload with canvas relative measures

  var viewbox = canvas.viewbox();

  return {
    x: viewbox.x + (position.x - offset.x) / viewbox.scale,
    y: viewbox.y + (position.y - offset.y) / viewbox.scale
  };
}

function getConnectionIntersection(canvas, waypoints, event) {
  var localPosition = toCanvasCoordinates(canvas, event),
      intersection = (0, _LineIntersection.getApproxIntersection)(waypoints, localPosition);

  return intersection;
}

function addBendpoint(parentGfx, cls) {
  var groupGfx = (0, _tinySvg.create)('g');
  (0, _tinySvg.classes)(groupGfx).add(BENDPOINT_CLS);

  (0, _tinySvg.append)(parentGfx, groupGfx);

  var visual = (0, _tinySvg.create)('circle');
  (0, _tinySvg.attr)(visual, {
    cx: 0,
    cy: 0,
    r: 4
  });
  (0, _tinySvg.classes)(visual).add('djs-visual');

  (0, _tinySvg.append)(groupGfx, visual);

  var hit = (0, _tinySvg.create)('circle');
  (0, _tinySvg.attr)(hit, {
    cx: 0,
    cy: 0,
    r: 10
  });
  (0, _tinySvg.classes)(hit).add('djs-hit');

  (0, _tinySvg.append)(groupGfx, hit);

  if (cls) {
    (0, _tinySvg.classes)(groupGfx).add(cls);
  }

  return groupGfx;
}

function createParallelDragger(parentGfx, segmentStart, segmentEnd, alignment) {
  var draggerGfx = (0, _tinySvg.create)('g');

  (0, _tinySvg.append)(parentGfx, draggerGfx);

  var width = 14,
      height = 3,
      padding = 6,
      hitWidth = calculateHitWidth(segmentStart, segmentEnd, alignment, padding),
      hitHeight = height + padding;

  var visual = (0, _tinySvg.create)('rect');
  (0, _tinySvg.attr)(visual, {
    x: -width / 2,
    y: -height / 2,
    width: width,
    height: height
  });
  (0, _tinySvg.classes)(visual).add('djs-visual');

  (0, _tinySvg.append)(draggerGfx, visual);

  var hit = (0, _tinySvg.create)('rect');
  (0, _tinySvg.attr)(hit, {
    x: -hitWidth / 2,
    y: -hitHeight / 2,
    width: hitWidth,
    height: hitHeight
  });
  (0, _tinySvg.classes)(hit).add('djs-hit');

  (0, _tinySvg.append)(draggerGfx, hit);

  (0, _SvgTransformUtil.rotate)(draggerGfx, alignment === 'v' ? 90 : 0, 0, 0);

  return draggerGfx;
}

function addSegmentDragger(parentGfx, segmentStart, segmentEnd) {

  var groupGfx = (0, _tinySvg.create)('g'),
      mid = (0, _Geometry.getMidPoint)(segmentStart, segmentEnd),
      alignment = (0, _Geometry.pointsAligned)(segmentStart, segmentEnd);

  (0, _tinySvg.append)(parentGfx, groupGfx);

  createParallelDragger(groupGfx, segmentStart, segmentEnd, alignment);

  (0, _tinySvg.classes)(groupGfx).add(SEGMENT_DRAGGER_CLS);
  (0, _tinySvg.classes)(groupGfx).add(alignment === 'h' ? 'horizontal' : 'vertical');

  (0, _SvgTransformUtil.translate)(groupGfx, mid.x, mid.y);

  return groupGfx;
}

/**
 * Calculates region for segment move which is 2/3 of the full segment length
 * @param {Number} segmentLength
 *
 * @return {Number}
 */
function calculateSegmentMoveRegion(segmentLength) {
  return Math.abs(Math.round(segmentLength * 2 / 3));
}

// helper //////////

function calculateHitWidth(segmentStart, segmentEnd, alignment) {
  var segmentLengthXAxis = segmentEnd.x - segmentStart.x,
      segmentLengthYAxis = segmentEnd.y - segmentStart.y;

  return alignment === 'h' ? calculateSegmentMoveRegion(segmentLengthXAxis) : calculateSegmentMoveRegion(segmentLengthYAxis);
}

},{"237":237,"238":238,"241":241,"248":248,"275":275}],115:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Bendpoints;

var _minDash = _dereq_(254);

var _minDom = _dereq_(255);

var _BendpointUtil = _dereq_(114);

var _EscapeUtil = _dereq_(236);

var _GraphicsUtil = _dereq_(239);

var _Geometry = _dereq_(238);

var _tinySvg = _dereq_(275);

var _SvgTransformUtil = _dereq_(248);

/**
 * A service that adds editable bendpoints to connections.
 */
function Bendpoints(eventBus, canvas, interactionEvents, bendpointMove, connectionSegmentMove) {

  /**
   * Returns true if intersection point is inside middle region of segment, adjusted by
   * optional threshold
   */
  function isIntersectionMiddle(intersection, waypoints, treshold) {
    var idx = intersection.index,
        p = intersection.point,
        p0,
        p1,
        mid,
        aligned,
        xDelta,
        yDelta;

    if (idx <= 0 || intersection.bendpoint) {
      return false;
    }

    p0 = waypoints[idx - 1];
    p1 = waypoints[idx];
    mid = (0, _Geometry.getMidPoint)(p0, p1), aligned = (0, _Geometry.pointsAligned)(p0, p1);
    xDelta = Math.abs(p.x - mid.x);
    yDelta = Math.abs(p.y - mid.y);

    return aligned && xDelta <= treshold && yDelta <= treshold;
  }

  /**
   * Calculates the threshold from a connection's middle which fits the two-third-region
   */
  function calculateIntersectionThreshold(connection, intersection) {
    var waypoints = connection.waypoints,
        relevantSegment,
        alignment,
        segmentLength,
        threshold;

    if (intersection.index <= 0 || intersection.bendpoint) {
      return null;
    }

    // segment relative to connection intersection
    relevantSegment = {
      start: waypoints[intersection.index - 1],
      end: waypoints[intersection.index]
    };

    alignment = (0, _Geometry.pointsAligned)(relevantSegment.start, relevantSegment.end);

    if (!alignment) {
      return null;
    }

    if (alignment === 'h') {
      segmentLength = relevantSegment.end.x - relevantSegment.start.x;
    } else {
      segmentLength = relevantSegment.end.y - relevantSegment.start.y;
    }

    // calculate threshold relative to 2/3 of segment length
    threshold = (0, _BendpointUtil.calculateSegmentMoveRegion)(segmentLength) / 2;

    return threshold;
  }

  function activateBendpointMove(event, connection) {
    var waypoints = connection.waypoints,
        intersection = (0, _BendpointUtil.getConnectionIntersection)(canvas, waypoints, event),
        threshold;

    if (!intersection) {
      return;
    }

    threshold = calculateIntersectionThreshold(connection, intersection);

    if (isIntersectionMiddle(intersection, waypoints, threshold)) {
      connectionSegmentMove.start(event, connection, intersection.index);
    } else {
      bendpointMove.start(event, connection, intersection.index, !intersection.bendpoint);
    }

    // we've handled the event
    return true;
  }

  function bindInteractionEvents(node, eventName, element) {

    _minDom.event.bind(node, eventName, function (event) {
      interactionEvents.triggerMouseEvent(eventName, event, element);
      event.stopPropagation();
    });
  }

  function getBendpointsContainer(element, create) {

    var layer = canvas.getLayer('overlays'),
        gfx = (0, _minDom.query)('.djs-bendpoints[data-element-id="' + (0, _EscapeUtil.escapeCSS)(element.id) + '"]', layer);

    if (!gfx && create) {
      gfx = (0, _tinySvg.create)('g');
      (0, _tinySvg.attr)(gfx, { 'data-element-id': element.id });
      (0, _tinySvg.classes)(gfx).add('djs-bendpoints');

      (0, _tinySvg.append)(layer, gfx);

      bindInteractionEvents(gfx, 'mousedown', element);
      bindInteractionEvents(gfx, 'click', element);
      bindInteractionEvents(gfx, 'dblclick', element);
    }

    return gfx;
  }

  function getSegmentDragger(idx, parentGfx) {
    return (0, _minDom.query)('.djs-segment-dragger[data-segment-idx="' + idx + '"]', parentGfx);
  }

  function createBendpoints(gfx, connection) {
    connection.waypoints.forEach(function (p, idx) {
      var bendpoint = (0, _BendpointUtil.addBendpoint)(gfx);

      (0, _tinySvg.append)(gfx, bendpoint);

      (0, _SvgTransformUtil.translate)(bendpoint, p.x, p.y);
    });

    // add floating bendpoint
    (0, _BendpointUtil.addBendpoint)(gfx, 'floating');
  }

  function createSegmentDraggers(gfx, connection) {

    var waypoints = connection.waypoints;

    var segmentStart, segmentEnd, segmentDraggerGfx;

    for (var i = 1; i < waypoints.length; i++) {

      segmentStart = waypoints[i - 1];
      segmentEnd = waypoints[i];

      if ((0, _Geometry.pointsAligned)(segmentStart, segmentEnd)) {
        segmentDraggerGfx = (0, _BendpointUtil.addSegmentDragger)(gfx, segmentStart, segmentEnd);

        (0, _tinySvg.attr)(segmentDraggerGfx, { 'data-segment-idx': i });

        bindInteractionEvents(segmentDraggerGfx, 'mousemove', connection);
      }
    }
  }

  function clearBendpoints(gfx) {
    (0, _minDash.forEach)((0, _minDom.queryAll)('.' + _BendpointUtil.BENDPOINT_CLS, gfx), function (node) {
      (0, _tinySvg.remove)(node);
    });
  }

  function clearSegmentDraggers(gfx) {
    (0, _minDash.forEach)((0, _minDom.queryAll)('.' + _BendpointUtil.SEGMENT_DRAGGER_CLS, gfx), function (node) {
      (0, _tinySvg.remove)(node);
    });
  }

  function addHandles(connection) {

    var gfx = getBendpointsContainer(connection);

    if (!gfx) {
      gfx = getBendpointsContainer(connection, true);

      createBendpoints(gfx, connection);
      createSegmentDraggers(gfx, connection);
    }

    return gfx;
  }

  function updateHandles(connection) {

    var gfx = getBendpointsContainer(connection);

    if (gfx) {
      clearSegmentDraggers(gfx);
      clearBendpoints(gfx);
      createSegmentDraggers(gfx, connection);
      createBendpoints(gfx, connection);
    }
  }

  function updateFloatingBendpointPosition(parentGfx, intersection) {
    var floating = (0, _minDom.query)('.floating', parentGfx),
        point = intersection.point;

    if (!floating) {
      return;
    }

    (0, _SvgTransformUtil.translate)(floating, point.x, point.y);
  }

  function updateSegmentDraggerPosition(parentGfx, intersection, waypoints) {

    var draggerGfx = getSegmentDragger(intersection.index, parentGfx),
        segmentStart = waypoints[intersection.index - 1],
        segmentEnd = waypoints[intersection.index],
        point = intersection.point,
        mid = (0, _Geometry.getMidPoint)(segmentStart, segmentEnd),
        alignment = (0, _Geometry.pointsAligned)(segmentStart, segmentEnd),
        draggerVisual,
        relativePosition;

    if (!draggerGfx) {
      return;
    }

    draggerVisual = (0, _GraphicsUtil.getVisual)(draggerGfx);

    relativePosition = {
      x: point.x - mid.x,
      y: point.y - mid.y
    };

    if (alignment === 'v') {

      // rotate position
      relativePosition = {
        x: relativePosition.y,
        y: relativePosition.x
      };
    }

    (0, _SvgTransformUtil.translate)(draggerVisual, relativePosition.x, relativePosition.y);
  }

  eventBus.on('connection.changed', function (event) {
    updateHandles(event.element);
  });

  eventBus.on('connection.remove', function (event) {
    var gfx = getBendpointsContainer(event.element);

    if (gfx) {
      (0, _tinySvg.remove)(gfx);
    }
  });

  eventBus.on('element.marker.update', function (event) {

    var element = event.element,
        bendpointsGfx;

    if (!element.waypoints) {
      return;
    }

    bendpointsGfx = addHandles(element);

    if (event.add) {
      (0, _tinySvg.classes)(bendpointsGfx).add(event.marker);
    } else {
      (0, _tinySvg.classes)(bendpointsGfx).remove(event.marker);
    }
  });

  eventBus.on('element.mousemove', function (event) {

    var element = event.element,
        waypoints = element.waypoints,
        bendpointsGfx,
        intersection;

    if (waypoints) {
      bendpointsGfx = getBendpointsContainer(element, true);

      intersection = (0, _BendpointUtil.getConnectionIntersection)(canvas, waypoints, event.originalEvent);

      if (!intersection) {
        return;
      }

      updateFloatingBendpointPosition(bendpointsGfx, intersection);

      if (!intersection.bendpoint) {
        updateSegmentDraggerPosition(bendpointsGfx, intersection, waypoints);
      }
    }
  });

  eventBus.on('element.mousedown', function (event) {

    var originalEvent = event.originalEvent,
        element = event.element,
        waypoints = element.waypoints;

    if (!waypoints) {
      return;
    }

    return activateBendpointMove(originalEvent, element, waypoints);
  });

  eventBus.on('selection.changed', function (event) {
    var newSelection = event.newSelection,
        primary = newSelection[0];

    if (primary && primary.waypoints) {
      addHandles(primary);
    }
  });

  eventBus.on('element.hover', function (event) {
    var element = event.element;

    if (element.waypoints) {
      addHandles(element);
      interactionEvents.registerEvent(event.gfx, 'mousemove', 'element.mousemove');
    }
  });

  eventBus.on('element.out', function (event) {
    interactionEvents.unregisterEvent(event.gfx, 'mousemove', 'element.mousemove');
  });

  // update bendpoint container data attribute on element ID change
  eventBus.on('element.updateId', function (context) {
    var element = context.element,
        newId = context.newId;

    if (element.waypoints) {
      var bendpointContainer = getBendpointsContainer(element);

      if (bendpointContainer) {
        (0, _tinySvg.attr)(bendpointContainer, { 'data-element-id': newId });
      }
    }
  });

  // API

  this.addHandles = addHandles;
  this.updateHandles = updateHandles;
  this.getBendpointsContainer = getBendpointsContainer;
  this.getSegmentDragger = getSegmentDragger;
}

Bendpoints.$inject = ['eventBus', 'canvas', 'interactionEvents', 'bendpointMove', 'connectionSegmentMove'];

},{"114":114,"236":236,"238":238,"239":239,"248":248,"254":254,"255":255,"275":275}],116:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ConnectionSegmentMove;

var _Geometry = _dereq_(238);

var _BendpointUtil = _dereq_(114);

var _LayoutUtil = _dereq_(221);

var _tinySvg = _dereq_(275);

var _SvgTransformUtil = _dereq_(248);

var MARKER_CONNECT_HOVER = 'connect-hover',
    MARKER_CONNECT_UPDATING = 'djs-updating';

function axisAdd(point, axis, delta) {
  return axisSet(point, axis, point[axis] + delta);
}

function axisSet(point, axis, value) {
  return {
    x: axis === 'x' ? value : point.x,
    y: axis === 'y' ? value : point.y
  };
}

function axisFenced(position, segmentStart, segmentEnd, axis) {

  var maxValue = Math.max(segmentStart[axis], segmentEnd[axis]),
      minValue = Math.min(segmentStart[axis], segmentEnd[axis]);

  var padding = 20;

  var fencedValue = Math.min(Math.max(minValue + padding, position[axis]), maxValue - padding);

  return axisSet(segmentStart, axis, fencedValue);
}

function flipAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}

/**
 * Get the docking point on the given element.
 *
 * Compute a reasonable docking, if non exists.
 *
 * @param  {Point} point
 * @param  {djs.model.Shape} referenceElement
 * @param  {String} moveAxis (x|y)
 *
 * @return {Point}
 */
function getDocking(point, referenceElement, moveAxis) {

  var referenceMid, inverseAxis;

  if (point.original) {
    return point.original;
  } else {
    referenceMid = (0, _LayoutUtil.getMid)(referenceElement);
    inverseAxis = flipAxis(moveAxis);

    return axisSet(point, inverseAxis, referenceMid[inverseAxis]);
  }
}

/**
 * A component that implements moving of bendpoints
 */
function ConnectionSegmentMove(injector, eventBus, canvas, dragging, graphicsFactory, modeling) {

  // optional connection docking integration
  var connectionDocking = injector.get('connectionDocking', false);

  // API

  this.start = function (event, connection, idx) {

    var context,
        gfx = canvas.getGraphics(connection),
        segmentStartIndex = idx - 1,
        segmentEndIndex = idx,
        waypoints = connection.waypoints,
        segmentStart = waypoints[segmentStartIndex],
        segmentEnd = waypoints[segmentEndIndex],
        intersection = (0, _BendpointUtil.getConnectionIntersection)(canvas, waypoints, event),
        direction,
        axis,
        dragPosition;

    direction = (0, _Geometry.pointsAligned)(segmentStart, segmentEnd);

    // do not move diagonal connection
    if (!direction) {
      return;
    }

    // the axis where we are going to move things
    axis = direction === 'v' ? 'x' : 'y';

    if (segmentStartIndex === 0) {
      segmentStart = getDocking(segmentStart, connection.source, axis);
    }

    if (segmentEndIndex === waypoints.length - 1) {
      segmentEnd = getDocking(segmentEnd, connection.target, axis);
    }

    if (intersection) {
      dragPosition = intersection.point;
    } else {
      // set to segment center as default
      dragPosition = {
        x: (segmentStart.x + segmentEnd.x) / 2,
        y: (segmentStart.y + segmentEnd.y) / 2
      };
    }

    context = {
      connection: connection,
      segmentStartIndex: segmentStartIndex,
      segmentEndIndex: segmentEndIndex,
      segmentStart: segmentStart,
      segmentEnd: segmentEnd,
      axis: axis,
      dragPosition: dragPosition
    };

    dragging.init(event, dragPosition, 'connectionSegment.move', {
      cursor: axis === 'x' ? 'resize-ew' : 'resize-ns',
      data: {
        connection: connection,
        connectionGfx: gfx,
        context: context
      }
    });
  };

  /**
   * Crop connection if connection cropping is provided.
   *
   * @param {Connection} connection
   * @param {Array<Point>} newWaypoints
   *
   * @return {Array<Point>} cropped connection waypoints
   */
  function cropConnection(connection, newWaypoints) {

    // crop connection, if docking service is provided only
    if (!connectionDocking) {
      return newWaypoints;
    }

    var oldWaypoints = connection.waypoints,
        croppedWaypoints;

    // temporary set new waypoints
    connection.waypoints = newWaypoints;

    croppedWaypoints = connectionDocking.getCroppedWaypoints(connection);

    // restore old waypoints
    connection.waypoints = oldWaypoints;

    return croppedWaypoints;
  }

  // DRAGGING IMPLEMENTATION

  function redrawConnection(data) {
    graphicsFactory.update('connection', data.connection, data.connectionGfx);
  }

  function updateDragger(context, segmentOffset, event) {

    var newWaypoints = context.newWaypoints,
        segmentStartIndex = context.segmentStartIndex + segmentOffset,
        segmentStart = newWaypoints[segmentStartIndex],
        segmentEndIndex = context.segmentEndIndex + segmentOffset,
        segmentEnd = newWaypoints[segmentEndIndex],
        axis = flipAxis(context.axis);

    // make sure the dragger does not move
    // outside the connection
    var draggerPosition = axisFenced(event, segmentStart, segmentEnd, axis);

    // update dragger
    (0, _SvgTransformUtil.translate)(context.draggerGfx, draggerPosition.x, draggerPosition.y);
  }

  /**
   * Filter waypoints for redundant ones (i.e. on the same axis).
   * Returns the filtered waypoints and the offset related to the segment move.
   *
   * @param {Array<Point>} waypoints
   * @param {Integer} segmentStartIndex of moved segment start
   *
   * @return {Object} { filteredWaypoints, segmentOffset }
   */
  function filterRedundantWaypoints(waypoints, segmentStartIndex) {

    var segmentOffset = 0;

    var filteredWaypoints = waypoints.filter(function (r, idx) {
      if ((0, _Geometry.pointsOnLine)(waypoints[idx - 1], waypoints[idx + 1], r)) {

        // remove point and increment offset
        segmentOffset = idx <= segmentStartIndex ? segmentOffset - 1 : segmentOffset;
        return false;
      }

      // dont remove point
      return true;
    });

    return {
      waypoints: filteredWaypoints,
      segmentOffset: segmentOffset
    };
  }

  eventBus.on('connectionSegment.move.start', function (e) {

    var context = e.context,
        connection = e.connection,
        layer = canvas.getLayer('overlays');

    context.originalWaypoints = connection.waypoints.slice();

    // add dragger gfx
    context.draggerGfx = (0, _BendpointUtil.addSegmentDragger)(layer, context.segmentStart, context.segmentEnd);
    (0, _tinySvg.classes)(context.draggerGfx).add('djs-dragging');

    canvas.addMarker(connection, MARKER_CONNECT_UPDATING);
  });

  eventBus.on('connectionSegment.move.move', function (e) {

    var context = e.context,
        connection = context.connection,
        segmentStartIndex = context.segmentStartIndex,
        segmentEndIndex = context.segmentEndIndex,
        segmentStart = context.segmentStart,
        segmentEnd = context.segmentEnd,
        axis = context.axis;

    var newWaypoints = context.originalWaypoints.slice(),
        newSegmentStart = axisAdd(segmentStart, axis, e['d' + axis]),
        newSegmentEnd = axisAdd(segmentEnd, axis, e['d' + axis]);

    // original waypoint count and added / removed
    // from start waypoint delta. We use the later
    // to retrieve the updated segmentStartIndex / segmentEndIndex
    var waypointCount = newWaypoints.length,
        segmentOffset = 0;

    // move segment start / end by axis delta
    newWaypoints[segmentStartIndex] = newSegmentStart;
    newWaypoints[segmentEndIndex] = newSegmentEnd;

    var sourceToSegmentOrientation, targetToSegmentOrientation;

    // handle first segment
    if (segmentStartIndex < 2) {
      sourceToSegmentOrientation = (0, _LayoutUtil.getOrientation)(connection.source, newSegmentStart);

      // first bendpoint, remove first segment if intersecting
      if (segmentStartIndex === 1) {

        if (sourceToSegmentOrientation === 'intersect') {
          newWaypoints.shift();
          newWaypoints[0] = newSegmentStart;
          segmentOffset--;
        }
      }

      // docking point, add segment if not intersecting anymore
      else {
          if (sourceToSegmentOrientation !== 'intersect') {
            newWaypoints.unshift(segmentStart);
            segmentOffset++;
          }
        }
    }

    // handle last segment
    if (segmentEndIndex > waypointCount - 3) {
      targetToSegmentOrientation = (0, _LayoutUtil.getOrientation)(connection.target, newSegmentEnd);

      // last bendpoint, remove last segment if intersecting
      if (segmentEndIndex === waypointCount - 2) {

        if (targetToSegmentOrientation === 'intersect') {
          newWaypoints.pop();
          newWaypoints[newWaypoints.length - 1] = newSegmentEnd;
        }
      }

      // last bendpoint, remove last segment if intersecting
      else {
          if (targetToSegmentOrientation !== 'intersect') {
            newWaypoints.push(segmentEnd);
          }
        }
    }

    // update connection waypoints
    context.newWaypoints = connection.waypoints = cropConnection(connection, newWaypoints);

    // update dragger position
    updateDragger(context, segmentOffset, e);

    // save segmentOffset in context
    context.newSegmentStartIndex = segmentStartIndex + segmentOffset;

    // redraw connection
    redrawConnection(e);
  });

  eventBus.on('connectionSegment.move.hover', function (e) {

    e.context.hover = e.hover;
    canvas.addMarker(e.hover, MARKER_CONNECT_HOVER);
  });

  eventBus.on(['connectionSegment.move.out', 'connectionSegment.move.cleanup'], function (e) {

    // remove connect marker
    // if it was added
    var hover = e.context.hover;

    if (hover) {
      canvas.removeMarker(hover, MARKER_CONNECT_HOVER);
    }
  });

  eventBus.on('connectionSegment.move.cleanup', function (e) {

    var context = e.context,
        connection = context.connection;

    // remove dragger gfx
    if (context.draggerGfx) {
      (0, _tinySvg.remove)(context.draggerGfx);
    }

    canvas.removeMarker(connection, MARKER_CONNECT_UPDATING);
  });

  eventBus.on(['connectionSegment.move.cancel', 'connectionSegment.move.end'], function (e) {
    var context = e.context,
        connection = context.connection;

    connection.waypoints = context.originalWaypoints;

    redrawConnection(e);
  });

  eventBus.on('connectionSegment.move.end', function (e) {

    var context = e.context,
        connection = context.connection,
        newWaypoints = context.newWaypoints,
        newSegmentStartIndex = context.newSegmentStartIndex;

    // ensure we have actual pixel values bendpoint
    // coordinates (important when zoom level was > 1 during move)
    newWaypoints = newWaypoints.map(function (p) {
      return {
        original: p.original,
        x: Math.round(p.x),
        y: Math.round(p.y)
      };
    });

    // apply filter redunant waypoints
    var filtered = filterRedundantWaypoints(newWaypoints, newSegmentStartIndex);

    // get filtered waypoints
    var filteredWaypoints = filtered.waypoints,
        croppedWaypoints = cropConnection(connection, filteredWaypoints),
        segmentOffset = filtered.segmentOffset;

    var hints = {
      segmentMove: {
        segmentStartIndex: context.segmentStartIndex,
        newSegmentStartIndex: newSegmentStartIndex + segmentOffset
      }
    };

    modeling.updateWaypoints(connection, croppedWaypoints, hints);
  });
}

ConnectionSegmentMove.$inject = ['injector', 'eventBus', 'canvas', 'dragging', 'graphicsFactory', 'modeling'];

},{"114":114,"221":221,"238":238,"248":248,"275":275}],117:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _dragging = _dereq_(131);

var _dragging2 = _interopRequireDefault(_dragging);

var _rules = _dereq_(200);

var _rules2 = _interopRequireDefault(_rules);

var _Bendpoints = _dereq_(115);

var _Bendpoints2 = _interopRequireDefault(_Bendpoints);

var _BendpointMove = _dereq_(111);

var _BendpointMove2 = _interopRequireDefault(_BendpointMove);

var _BendpointMovePreview = _dereq_(112);

var _BendpointMovePreview2 = _interopRequireDefault(_BendpointMovePreview);

var _ConnectionSegmentMove = _dereq_(116);

var _ConnectionSegmentMove2 = _interopRequireDefault(_ConnectionSegmentMove);

var _BendpointSnapping = _dereq_(113);

var _BendpointSnapping2 = _interopRequireDefault(_BendpointSnapping);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_dragging2.default, _rules2.default],
  __init__: ['bendpoints', 'bendpointSnapping', 'bendpointMovePreview'],
  bendpoints: ['type', _Bendpoints2.default],
  bendpointMove: ['type', _BendpointMove2.default],
  bendpointMovePreview: ['type', _BendpointMovePreview2.default],
  connectionSegmentMove: ['type', _ConnectionSegmentMove2.default],
  bendpointSnapping: ['type', _BendpointSnapping2.default]
};

},{"111":111,"112":112,"113":113,"115":115,"116":116,"131":131,"200":200}],118:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ChangeSupport;

var _Elements = _dereq_(235);

/**
 * Adds change support to the diagram, including
 *
 * <ul>
 *   <li>redrawing shapes and connections on change</li>
 * </ul>
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {ElementRegistry} elementRegistry
 * @param {GraphicsFactory} graphicsFactory
 */
function ChangeSupport(eventBus, canvas, elementRegistry, graphicsFactory) {

  // redraw shapes / connections on change

  eventBus.on('element.changed', function (event) {

    var element = event.element;

    // element might have been deleted and replaced by new element with same ID
    // thus check for parent of element except for root element
    if (element.parent || element === canvas.getRootElement()) {
      event.gfx = elementRegistry.getGraphics(element);
    }

    // shape + gfx may have been deleted
    if (!event.gfx) {
      return;
    }

    eventBus.fire((0, _Elements.getType)(element) + '.changed', event);
  });

  eventBus.on('elements.changed', function (event) {

    var elements = event.elements;

    elements.forEach(function (e) {
      eventBus.fire('element.changed', { element: e });
    });

    graphicsFactory.updateContainments(elements);
  });

  eventBus.on('shape.changed', function (event) {
    graphicsFactory.update('shape', event.element, event.gfx);
  });

  eventBus.on('connection.changed', function (event) {
    graphicsFactory.update('connection', event.element, event.gfx);
  });
}

ChangeSupport.$inject = ['eventBus', 'canvas', 'elementRegistry', 'graphicsFactory'];

},{"235":235}],119:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ChangeSupport = _dereq_(118);

var _ChangeSupport2 = _interopRequireDefault(_ChangeSupport);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['changeSupport'],
  changeSupport: ['type', _ChangeSupport2.default]
};

},{"118":118}],120:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = Connect;

var _LayoutUtil = _dereq_(221);

function Connect(eventBus, dragging, modeling, rules) {

  // rules

  function canConnect(source, target) {
    return rules.allowed('connection.create', {
      source: source,
      target: target
    });
  }

  // event handlers

  eventBus.on('connect.hover', function (event) {
    var context = event.context,
        source = context.source,
        hover = event.hover,
        canExecute;

    canExecute = context.canExecute = canConnect(source, hover);

    // simply ignore hover
    if (canExecute === null) {
      return;
    }

    context.target = hover;
  });

  eventBus.on(['connect.out', 'connect.cleanup'], function (event) {
    var context = event.context;

    context.target = null;
    context.canExecute = false;
  });

  eventBus.on('connect.end', function (event) {

    var context = event.context,
        source = context.source,
        sourcePosition = context.sourcePosition,
        target = context.target,
        targetPosition = {
      x: event.x,
      y: event.y
    },
        canExecute = context.canExecute || canConnect(source, target);

    if (!canExecute) {
      return false;
    }

    var attrs = null,
        hints = {
      connectionStart: sourcePosition,
      connectionEnd: targetPosition
    };

    if ((typeof canExecute === 'undefined' ? 'undefined' : _typeof(canExecute)) === 'object') {
      attrs = canExecute;
    }

    modeling.connect(source, target, attrs, hints);
  });

  // API

  /**
   * Start connect operation.
   *
   * @param {DOMEvent} event
   * @param {djs.model.Base} source
   * @param {Point} [sourcePosition]
   * @param {Boolean} [autoActivate=false]
   */
  this.start = function (event, source, sourcePosition, autoActivate) {

    if ((typeof sourcePosition === 'undefined' ? 'undefined' : _typeof(sourcePosition)) !== 'object') {
      autoActivate = sourcePosition;
      sourcePosition = (0, _LayoutUtil.getMid)(source);
    }

    dragging.init(event, 'connect', {
      autoActivate: autoActivate,
      data: {
        shape: source,
        context: {
          source: source,
          sourcePosition: sourcePosition
        }
      }
    });
  };
}

Connect.$inject = ['eventBus', 'dragging', 'modeling', 'rules'];

},{"221":221}],121:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ConnectPreview;
var HIGH_PRIORITY = 1100,
    LOW_PRIORITY = 900;

var MARKER_OK = 'connect-ok',
    MARKER_NOT_OK = 'connect-not-ok';

/**
 * Shows connection preview during connect.
 *
 * @param {didi.Injector} injector
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 */
function ConnectPreview(injector, eventBus, canvas) {
  var connectionPreview = injector.get('connectionPreview', false);

  eventBus.on('connect.move', function (event) {
    var context = event.context,
        source = context.source,
        target = context.target,
        canConnect = context.canExecute;

    var endPosition = {
      x: event.x,
      y: event.y
    };

    if (connectionPreview) {
      connectionPreview.drawPreview(context, canConnect, {
        source: source,
        target: target,
        connectionEnd: endPosition
      });
    }
  });

  eventBus.on('connect.hover', LOW_PRIORITY, function (event) {
    var context = event.context,
        hover = event.hover,
        canExecute = context.canExecute;

    // ignore hover
    if (canExecute === null) {
      return;
    }

    canvas.addMarker(hover, canExecute ? MARKER_OK : MARKER_NOT_OK);
  });

  eventBus.on(['connect.out', 'connect.cleanup'], HIGH_PRIORITY, function (event) {
    var context = event.context;

    // remove marker before target is removed from context
    if (context.target) {
      canvas.removeMarker(context.target, context.canExecute ? MARKER_OK : MARKER_NOT_OK);
    }
  });

  eventBus.on('connect.cleanup', function (event) {
    if (connectionPreview) {
      connectionPreview.cleanUp(event.context);
    }
  });
}

ConnectPreview.$inject = ['injector', 'eventBus', 'canvas'];

},{}],122:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _selection = _dereq_(206);

var _selection2 = _interopRequireDefault(_selection);

var _rules = _dereq_(200);

var _rules2 = _interopRequireDefault(_rules);

var _dragging = _dereq_(131);

var _dragging2 = _interopRequireDefault(_dragging);

var _Connect = _dereq_(120);

var _Connect2 = _interopRequireDefault(_Connect);

var _ConnectPreview = _dereq_(121);

var _ConnectPreview2 = _interopRequireDefault(_ConnectPreview);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_selection2.default, _rules2.default, _dragging2.default],
  __init__: ['connectPreview'],
  connect: ['type', _Connect2.default],
  connectPreview: ['type', _ConnectPreview2.default]
};

},{"120":120,"121":121,"131":131,"200":200,"206":206}],123:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ConnectionPreview;

var _tinySvg = _dereq_(275);

var _minDash = _dereq_(254);

var _LayoutUtil = _dereq_(221);

var MARKER_CONNECTION_PREVIEW = 'djs-connection-preview';

/**
 * Draws connection preview. Optionally, this can use layouter and connection docking to draw
 * better looking previews.
 *
 * @param {didi.Injector} injector
 * @param {Canvas} canvas
 * @param {GraphicsFactory} graphicsFactory
 * @param {ElementFactory} elementFactory
 */
function ConnectionPreview(injector, canvas, graphicsFactory, elementFactory) {
  this._canvas = canvas;
  this._graphicsFactory = graphicsFactory;
  this._elementFactory = elementFactory;

  // optional components
  this._connectionDocking = injector.get('connectionDocking', false);
  this._layouter = injector.get('layouter', false);
}

ConnectionPreview.$inject = ['injector', 'canvas', 'graphicsFactory', 'elementFactory'];

/**
 * Draw connection preview.
 *
 * Provide at least one of <source, connectionStart> and <target, connectionEnd> to create a preview.
 * In the clean up stage, call `connectionPreview#cleanUp` with the context to remove preview.
 *
 * @param {Object} context
 * @param {Object|boolean} canConnect
 * @param {Object} hints
 * @param {djs.model.shape} [hints.source] source element
 * @param {djs.model.shape} [hints.target] target element
 * @param {Point} [hints.connectionStart] connection preview start
 * @param {Point} [hints.connectionEnd] connection preview end
 * @param {Array<Point>} [hints.waypoints] provided waypoints for preview
 * @param {boolean} [hints.noLayout] true if preview should not be laid out
 * @param {boolean} [hints.noCropping] true if preview should not be cropped
 * @param {boolean} [hints.noNoop] true if simple connection should not be drawn
 */
ConnectionPreview.prototype.drawPreview = function (context, canConnect, hints) {

  hints = hints || {};

  var connectionPreviewGfx = context.connectionPreviewGfx,
      getConnection = context.getConnection,
      source = hints.source,
      target = hints.target,
      waypoints = hints.waypoints,
      connectionStart = hints.connectionStart,
      connectionEnd = hints.connectionEnd,
      noLayout = hints.noLayout,
      noCropping = hints.noCropping,
      noNoop = hints.noNoop,
      connection;

  var self = this;

  if (!connectionPreviewGfx) {
    connectionPreviewGfx = context.connectionPreviewGfx = this.createConnectionPreviewGfx();
  }

  (0, _tinySvg.clear)(connectionPreviewGfx);

  if (!getConnection) {
    getConnection = context.getConnection = cacheReturnValues(function (canConnect, source, target) {
      return self.getConnection(canConnect, source, target);
    });
  }

  if (canConnect) {
    connection = getConnection(canConnect, source, target);
  }

  if (!connection) {
    !noNoop && this.drawNoopPreview(connectionPreviewGfx, hints);
    return;
  }

  connection.waypoints = waypoints || [];

  // optional layout
  if (this._layouter && !noLayout) {
    connection.waypoints = this._layouter.layoutConnection(connection, {
      source: source,
      target: target,
      connectionStart: connectionStart,
      connectionEnd: connectionEnd
    });
  }

  // fallback if no waypoints were provided nor created with layouter
  if (!connection.waypoints || !connection.waypoints.length) {
    connection.waypoints = [source ? (0, _LayoutUtil.getMid)(source) : connectionStart, target ? (0, _LayoutUtil.getMid)(target) : connectionEnd];
  }

  // optional cropping
  if (this._connectionDocking && (source || target) && !noCropping) {
    connection.waypoints = this._connectionDocking.getCroppedWaypoints(connection, source, target);
  }

  this._graphicsFactory.drawConnection(connectionPreviewGfx, connection);
};

/**
 * Draw simple connection between source and target or provided points.
 *
 * @param {SVGElement} connectionPreviewGfx container for the connection
 * @param {Object} hints
 * @param {djs.model.shape} [hints.source] source element
 * @param {djs.model.shape} [hints.target] target element
 * @param {Point} [hints.connectionStart] required if source is not provided
 * @param {Point} [hints.connectionEnd] required if target is not provided
 */
ConnectionPreview.prototype.drawNoopPreview = function (connectionPreviewGfx, hints) {
  var source = hints.source,
      target = hints.target,
      start = hints.connectionStart || (0, _LayoutUtil.getMid)(source),
      end = hints.connectionEnd || (0, _LayoutUtil.getMid)(target);

  var waypoints = this.cropWaypoints(start, end, source, target);

  var connection = this.createNoopConnection(waypoints[0], waypoints[1]);

  (0, _tinySvg.append)(connectionPreviewGfx, connection);
};

/**
 * Return cropped waypoints.
 *
 * @param {Point} start
 * @param {Point} end
 * @param {djs.model.shape} source
 * @param {djs.model.shape} target
 *
 * @returns {Array}
 */
ConnectionPreview.prototype.cropWaypoints = function (start, end, source, target) {
  var graphicsFactory = this._graphicsFactory,
      sourcePath = source && graphicsFactory.getShapePath(source),
      targetPath = target && graphicsFactory.getShapePath(target),
      connectionPath = graphicsFactory.getConnectionPath({ waypoints: [start, end] });

  start = source && (0, _LayoutUtil.getElementLineIntersection)(sourcePath, connectionPath, true) || start;
  end = target && (0, _LayoutUtil.getElementLineIntersection)(targetPath, connectionPath, false) || end;

  return [start, end];
};

/**
 * Remove connection preview container if it exists.
 *
 * @param {Object} [context]
 * @param {SVGElement} [context.connectionPreviewGfx] preview container
 */
ConnectionPreview.prototype.cleanUp = function (context) {
  if (context && context.connectionPreviewGfx) {
    (0, _tinySvg.remove)(context.connectionPreviewGfx);
  }
};

/**
 * Get connection that connects source and target.
 *
 * @param {Object|boolean} canConnect
 *
 * @returns {djs.model.connection}
 */
ConnectionPreview.prototype.getConnection = function (canConnect) {
  var attrs = ensureConnectionAttrs(canConnect);

  return this._elementFactory.createConnection(attrs);
};

/**
 * Add and return preview graphics.
 *
 * @returns {SVGElement}
 */
ConnectionPreview.prototype.createConnectionPreviewGfx = function () {
  var gfx = (0, _tinySvg.create)('g');

  (0, _tinySvg.attr)(gfx, {
    pointerEvents: 'none'
  });

  (0, _tinySvg.classes)(gfx).add(MARKER_CONNECTION_PREVIEW);

  (0, _tinySvg.append)(this._canvas.getDefaultLayer(), gfx);

  return gfx;
};

/**
 * Create and return simple connection.
 *
 * @param {Point} start
 * @param {Point} end
 *
 * @returns {SVGElement}
 */
ConnectionPreview.prototype.createNoopConnection = function (start, end) {
  var connection = (0, _tinySvg.create)('polyline');

  (0, _tinySvg.attr)(connection, {
    'stroke': '#333',
    'strokeDasharray': [1],
    'strokeWidth': 2,
    'pointer-events': 'none'
  });

  (0, _tinySvg.attr)(connection, { 'points': [start.x, start.y, end.x, end.y] });

  return connection;
};

// helpers //////////

/**
 * Returns function that returns cached return values referenced by stringified first argument.
 *
 * @param {Function} fn
 *
 * @return {Function}
 */
function cacheReturnValues(fn) {
  var returnValues = {};

  /**
   * Return cached return value referenced by stringified first argument.
   *
   * @returns {*}
   */
  return function (firstArgument) {
    var key = JSON.stringify(firstArgument);

    var returnValue = returnValues[key];

    if (!returnValue) {
      returnValue = returnValues[key] = fn.apply(null, arguments);
    }

    return returnValue;
  };
}

/**
 * Ensure connection attributes is object.
 *
 * @param {Object|boolean} canConnect
 *
 * @returns {Object}
 */
function ensureConnectionAttrs(canConnect) {
  if ((0, _minDash.isObject)(canConnect)) {
    return canConnect;
  } else {
    return {};
  }
}

},{"221":221,"254":254,"275":275}],124:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ConnectionPreview = _dereq_(123);

var _ConnectionPreview2 = _interopRequireDefault(_ConnectionPreview);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['connectionPreview'],
  connectionPreview: ['type', _ConnectionPreview2.default]
};

},{"123":123}],125:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ContextPad;

var _minDash = _dereq_(254);

var _minDom = _dereq_(255);

var entrySelector = '.entry';

/**
 * A context pad that displays element specific, contextual actions next
 * to a diagram element.
 *
 * @param {Object} config
 * @param {Boolean|Object} [config.scale={ min: 1.0, max: 1.5 }]
 * @param {Number} [config.scale.min]
 * @param {Number} [config.scale.max]
 * @param {EventBus} eventBus
 * @param {Overlays} overlays
 */
function ContextPad(config, eventBus, overlays) {

  this._providers = [];

  this._eventBus = eventBus;
  this._overlays = overlays;

  var scale = (0, _minDash.isDefined)(config && config.scale) ? config.scale : {
    min: 1,
    max: 1.5
  };

  this._overlaysConfig = {
    position: {
      right: -9,
      top: -6
    },
    scale: scale
  };

  this._current = null;

  this._init();
}

ContextPad.$inject = ['config.contextPad', 'eventBus', 'overlays'];

/**
 * Registers events needed for interaction with other components
 */
ContextPad.prototype._init = function () {

  var eventBus = this._eventBus;

  var self = this;

  eventBus.on('selection.changed', function (e) {

    var selection = e.newSelection;

    if (selection.length === 1) {
      self.open(selection[0]);
    } else {
      self.close();
    }
  });

  eventBus.on('elements.delete', function (event) {
    var elements = event.elements;

    (0, _minDash.forEach)(elements, function (e) {
      if (self.isOpen(e)) {
        self.close();
      }
    });
  });

  eventBus.on('element.changed', function (event) {
    var element = event.element,
        current = self._current;

    // force reopen if element for which we are currently opened changed
    if (current && current.element === element) {
      self.open(element, true);
    }
  });
};

/**
 * Register a provider with the context pad
 *
 * @param  {ContextPadProvider} provider
 */
ContextPad.prototype.registerProvider = function (provider) {
  this._providers.push(provider);
};

/**
 * Returns the context pad entries for a given element
 *
 * @param {djs.element.Base} element
 *
 * @return {Array<ContextPadEntryDescriptor>} list of entries
 */
ContextPad.prototype.getEntries = function (element) {
  var entries = {};

  // loop through all providers and their entries.
  // group entries by id so that overriding an entry is possible
  (0, _minDash.forEach)(this._providers, function (provider) {
    var e = provider.getContextPadEntries(element);

    (0, _minDash.forEach)(e, function (entry, id) {
      entries[id] = entry;
    });
  });

  return entries;
};

/**
 * Trigger an action available on the opened context pad
 *
 * @param  {String} action
 * @param  {Event} event
 * @param  {Boolean} [autoActivate=false]
 */
ContextPad.prototype.trigger = function (action, event, autoActivate) {

  var element = this._current.element,
      entries = this._current.entries,
      entry,
      handler,
      originalEvent,
      button = event.delegateTarget || event.target;

  if (!button) {
    return event.preventDefault();
  }

  entry = entries[(0, _minDom.attr)(button, 'data-action')];
  handler = entry.action;

  originalEvent = event.originalEvent || event;

  // simple action (via callback function)
  if ((0, _minDash.isFunction)(handler)) {
    if (action === 'click') {
      return handler(originalEvent, element, autoActivate);
    }
  } else {
    if (handler[action]) {
      return handler[action](originalEvent, element, autoActivate);
    }
  }

  // silence other actions
  event.preventDefault();
};

/**
 * Open the context pad for the given element
 *
 * @param {djs.model.Base} element
 * @param {Boolean} force if true, force reopening the context pad
 */
ContextPad.prototype.open = function (element, force) {
  if (!force && this.isOpen(element)) {
    return;
  }

  this.close();
  this._updateAndOpen(element);
};

ContextPad.prototype._updateAndOpen = function (element) {

  var entries = this.getEntries(element),
      pad = this.getPad(element),
      html = pad.html;

  (0, _minDash.forEach)(entries, function (entry, id) {
    var grouping = entry.group || 'default',
        control = (0, _minDom.domify)(entry.html || '<div class="entry" draggable="true"></div>'),
        container;

    (0, _minDom.attr)(control, 'data-action', id);

    container = (0, _minDom.query)('[data-group=' + grouping + ']', html);
    if (!container) {
      container = (0, _minDom.domify)('<div class="group" data-group="' + grouping + '"></div>');
      html.appendChild(container);
    }

    container.appendChild(control);

    if (entry.className) {
      addClasses(control, entry.className);
    }

    if (entry.title) {
      (0, _minDom.attr)(control, 'title', entry.title);
    }

    if (entry.imageUrl) {
      control.appendChild((0, _minDom.domify)('<img src="' + entry.imageUrl + '">'));
    }
  });

  (0, _minDom.classes)(html).add('open');

  this._current = {
    element: element,
    pad: pad,
    entries: entries
  };

  this._eventBus.fire('contextPad.open', { current: this._current });
};

ContextPad.prototype.getPad = function (element) {
  if (this.isOpen()) {
    return this._current.pad;
  }

  var self = this;

  var overlays = this._overlays;

  var html = (0, _minDom.domify)('<div class="djs-context-pad"></div>');

  var overlaysConfig = (0, _minDash.assign)({
    html: html
  }, this._overlaysConfig);

  _minDom.delegate.bind(html, entrySelector, 'click', function (event) {
    self.trigger('click', event);
  });

  _minDom.delegate.bind(html, entrySelector, 'dragstart', function (event) {
    self.trigger('dragstart', event);
  });

  // stop propagation of mouse events
  _minDom.event.bind(html, 'mousedown', function (event) {
    event.stopPropagation();
  });

  this._overlayId = overlays.add(element, 'context-pad', overlaysConfig);

  var pad = overlays.get(this._overlayId);

  this._eventBus.fire('contextPad.create', { element: element, pad: pad });

  return pad;
};

/**
 * Close the context pad
 */
ContextPad.prototype.close = function () {
  if (!this.isOpen()) {
    return;
  }

  this._overlays.remove(this._overlayId);

  this._overlayId = null;

  this._eventBus.fire('contextPad.close', { current: this._current });

  this._current = null;
};

/**
 * Check if pad is open. If element is given, will check
 * if pad is opened with given element.
 *
 * @param {Element} element
 * @return {Boolean}
 */
ContextPad.prototype.isOpen = function (element) {
  return !!this._current && (!element ? true : this._current.element === element);
};

// helpers //////////////////////

function addClasses(element, classNames) {

  var classes = (0, _minDom.classes)(element);

  var actualClassNames = (0, _minDash.isArray)(classNames) ? classNames : classNames.split(/\s+/g);
  actualClassNames.forEach(function (cls) {
    classes.add(cls);
  });
}

},{"254":254,"255":255}],126:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _interactionEvents = _dereq_(139);

var _interactionEvents2 = _interopRequireDefault(_interactionEvents);

var _overlays = _dereq_(184);

var _overlays2 = _interopRequireDefault(_overlays);

var _ContextPad = _dereq_(125);

var _ContextPad2 = _interopRequireDefault(_ContextPad);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_interactionEvents2.default, _overlays2.default],
  contextPad: ['type', _ContextPad2.default]
};

},{"125":125,"139":139,"184":184}],127:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Create;

var _tinySvg = _dereq_(275);

var _minDash = _dereq_(254);

var _SvgTransformUtil = _dereq_(248);

var _model = _dereq_(223);

var LOW_PRIORITY = 750;

var MARKER_OK = 'drop-ok',
    MARKER_NOT_OK = 'drop-not-ok',
    MARKER_ATTACH = 'attach-ok',
    MARKER_NEW_PARENT = 'new-parent';

/**
 * Adds the ability to create new shapes via drag and drop.
 *
 * Create must be activated via {@link Create#start}. From that
 * point on, create will invoke `shape.create` and `shape.attach`
 * rules to query whether or not creation or attachment on a certain
 * position is allowed.
 *
 * If create or attach is allowed and a source is given, Create it
 * will invoke `connection.create` rules to query whether a connection
 * can be drawn between source and new shape. During rule evaluation
 * the target is not attached yet, however
 *
 *   hints = { targetParent, targetAttach }
 *
 * are passed to the evaluating rules.
 *
 *
 * ## Rule Return Values
 *
 * Return values interpreted from  `shape.create`:
 *
 *   * `true`: create is allowed
 *   * `false`: create is disallowed
 *   * `null`: create is not allowed but should be ignored visually
 *
 * Return values interpreted from `shape.attach`:
 *
 *   * `true`: attach is allowed
 *   * `Any`: attach is allowed with the constraints
 *   * `false`: attach is disallowed
 *
 * Return values interpreted from `connection.create`:
 *
 *   * `true`: connection can be created
 *   * `Any`: connection with the given attributes can be created
 *   * `false`: connection can't be created
 *
 *
 * @param {EventBus} eventBus
 * @param {Dragging} dragging
 * @param {Rules} rules
 * @param {Modeling} modeling
 * @param {Canvas} canvas
 * @param {Styles} styles
 * @param {GraphicsFactory} graphicsFactory
 */
function Create(eventBus, dragging, rules, modeling, canvas, styles, graphicsFactory) {

  // rules

  function canCreate(shape, target, source, position) {

    if (!target) {
      return false;
    }

    var ctx = {
      source: source,
      shape: shape,
      target: target,
      position: position
    };

    var create, attach, connect;

    attach = rules.allowed('shape.attach', ctx);

    if (!attach) {
      create = rules.allowed('shape.create', ctx);
    }

    if (create || attach) {

      connect = source && rules.allowed('connection.create', {
        source: source,
        target: shape,
        hints: {
          targetParent: target,
          targetAttach: attach
        }
      });

      return {
        attach: attach,
        connect: connect
      };
    }

    // allow to ignore visually
    if (create === null || attach === null) {
      return null;
    }

    return false;
  }

  /** set drop marker on an element */
  function setMarker(element, marker) {

    [MARKER_ATTACH, MARKER_OK, MARKER_NOT_OK, MARKER_NEW_PARENT].forEach(function (m) {

      if (m === marker) {
        canvas.addMarker(element, m);
      } else {
        canvas.removeMarker(element, m);
      }
    });
  }

  // visual helpers

  function createVisual(shape) {
    var group, preview, visual;

    group = (0, _tinySvg.create)('g');
    (0, _tinySvg.attr)(group, styles.cls('djs-drag-group', ['no-events']));

    (0, _tinySvg.append)(canvas.getDefaultLayer(), group);

    preview = (0, _tinySvg.create)('g');
    (0, _tinySvg.classes)(preview).add('djs-dragger');

    (0, _tinySvg.append)(group, preview);

    (0, _SvgTransformUtil.translate)(preview, shape.width / -2, shape.height / -2);

    var visualGroup = (0, _tinySvg.create)('g');
    (0, _tinySvg.classes)(visualGroup).add('djs-visual');

    (0, _tinySvg.append)(preview, visualGroup);

    visual = visualGroup;

    // hijack renderer to draw preview
    graphicsFactory.drawShape(visual, shape);

    return group;
  }

  // event handlers

  eventBus.on('create.move', function (event) {
    var context = event.context,
        hover = event.hover,
        shape = context.shape,
        source = context.source,
        canExecute;

    ensureConstraints(event);

    var position = {
      x: event.x,
      y: event.y
    };

    canExecute = context.canExecute = hover && canCreate(shape, hover, source, position);

    // ignore hover visually if canExecute is null
    if (hover && canExecute !== null) {
      context.target = hover;

      if (canExecute && canExecute.attach) {
        setMarker(hover, MARKER_ATTACH);
      } else {
        setMarker(hover, canExecute ? MARKER_NEW_PARENT : MARKER_NOT_OK);
      }
    }
  });

  eventBus.on('create.move', LOW_PRIORITY, function (event) {

    var context = event.context,
        shape = context.shape,
        visual = context.visual;

    // lazy init drag visual once we received the first real
    // drag move event (this allows us to get the proper canvas local coordinates)
    if (!visual) {
      visual = context.visual = createVisual(shape);
    }

    (0, _SvgTransformUtil.translate)(visual, event.x, event.y);
  });

  eventBus.on(['create.end', 'create.out', 'create.cleanup'], function (event) {
    var context = event.context,
        target = context.target;

    if (target) {
      setMarker(target, null);
    }
  });

  eventBus.on('create.end', function (event) {
    var context = event.context,
        source = context.source,
        hints = context.hints,
        shape = context.shape,
        target = context.target,
        canExecute = context.canExecute,
        attach = canExecute && canExecute.attach,
        connect = canExecute && canExecute.connect;

    if (canExecute === false || !target) {
      return false;
    }

    ensureConstraints(event);

    var position = {
      x: event.x,
      y: event.y
    };

    if (connect) {
      // invoke append if connect is set via rules
      shape = modeling.appendShape(source, shape, position, target, {
        attach: attach,
        connection: connect === true ? {} : connect
      });
    } else {
      // invoke create, if connect is not set
      shape = modeling.createShape(shape, position, target, (0, _minDash.assign)({}, hints, {
        attach: attach
      }));
    }

    // make sure we provide the actual attached
    // shape with the context so that selection and
    // other components can use it right after the create
    // operation ends
    context.shape = shape;
  });

  eventBus.on('create.cleanup', function (event) {
    var context = event.context;

    if (context.visual) {
      (0, _tinySvg.remove)(context.visual);
    }
  });

  // API

  this.start = function (event, shape, sourceOrContext) {
    var context;

    if (!sourceOrContext || sourceOrContext instanceof _model.Shape) {
      context = {
        hints: {},
        shape: shape,
        source: sourceOrContext
      };
    } else {
      context = (0, _minDash.assign)({
        hints: {},
        shape: shape
      }, sourceOrContext);
    }

    dragging.init(event, 'create', {
      cursor: 'grabbing',
      autoActivate: true,
      data: {
        shape: shape,
        context: context
      }
    });
  };
}

Create.$inject = ['eventBus', 'dragging', 'rules', 'modeling', 'canvas', 'styles', 'graphicsFactory'];

// helpers //////////

function ensureConstraints(event) {
  var context = event.context,
      createConstraints = context.createConstraints;

  if (!createConstraints) {
    return;
  }

  if (createConstraints.left) {
    event.x = Math.max(event.x, createConstraints.left);
  }

  if (createConstraints.right) {
    event.x = Math.min(event.x, createConstraints.right);
  }

  if (createConstraints.top) {
    event.y = Math.max(event.y, createConstraints.top);
  }

  if (createConstraints.bottom) {
    event.y = Math.min(event.y, createConstraints.bottom);
  }
}

},{"223":223,"248":248,"254":254,"275":275}],128:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _dragging = _dereq_(131);

var _dragging2 = _interopRequireDefault(_dragging);

var _selection = _dereq_(206);

var _selection2 = _interopRequireDefault(_selection);

var _rules = _dereq_(200);

var _rules2 = _interopRequireDefault(_rules);

var _Create = _dereq_(127);

var _Create2 = _interopRequireDefault(_Create);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_dragging2.default, _selection2.default, _rules2.default],
  create: ['type', _Create2.default]
};

},{"127":127,"131":131,"200":200,"206":206}],129:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Dragging;

var _minDash = _dereq_(254);

var _minDom = _dereq_(255);

var _Event = _dereq_(237);

var _Cursor = _dereq_(234);

var _ClickTrap = _dereq_(232);

var _PositionUtil = _dereq_(245);

/* global TouchEvent */

var round = Math.round;

var DRAG_ACTIVE_CLS = 'djs-drag-active';

function preventDefault(event) {
  event.preventDefault();
}

function isTouchEvent(event) {
  // check for TouchEvent being available first
  // (i.e. not available on desktop Firefox)
  return typeof TouchEvent !== 'undefined' && event instanceof TouchEvent;
}

function getLength(point) {
  return Math.sqrt(Math.pow(point.x, 2) + Math.pow(point.y, 2));
}

/**
 * A helper that fires canvas localized drag events and realizes
 * the general "drag-and-drop" look and feel.
 *
 * Calling {@link Dragging#activate} activates dragging on a canvas.
 *
 * It provides the following:
 *
 *   * emits life cycle events, namespaced with a prefix assigned
 *     during dragging activation
 *   * sets and restores the cursor
 *   * sets and restores the selection
 *   * ensures there can be only one drag operation active at a time
 *
 * Dragging may be canceled manually by calling {@link Dragging#cancel}
 * or by pressing ESC.
 *
 *
 * ## Life-cycle events
 *
 * Dragging can be in three different states, off, initialized
 * and active.
 *
 * (1) off: no dragging operation is in progress
 * (2) initialized: a new drag operation got initialized but not yet
 *                  started (i.e. because of no initial move)
 * (3) started: dragging is in progress
 *
 * Eventually dragging will be off again after a drag operation has
 * been ended or canceled via user click or ESC key press.
 *
 * To indicate transitions between these states dragging emits generic
 * life-cycle events with the `drag.` prefix _and_ events namespaced
 * to a prefix choosen by a user during drag initialization.
 *
 * The following events are emitted (appropriately prefixed) via
 * the {@link EventBus}.
 *
 * * `init`
 * * `start`
 * * `move`
 * * `end`
 * * `ended` (dragging already in off state)
 * * `cancel` (only if previously started)
 * * `canceled` (dragging already in off state, only if previously started)
 * * `cleanup`
 *
 *
 * @example
 *
 * function MyDragComponent(eventBus, dragging) {
 *
 *   eventBus.on('mydrag.start', function(event) {
 *     console.log('yes, we start dragging');
 *   });
 *
 *   eventBus.on('mydrag.move', function(event) {
 *     console.log('canvas local coordinates', event.x, event.y, event.dx, event.dy);
 *
 *     // local drag data is passed with the event
 *     event.context.foo; // "BAR"
 *
 *     // the original mouse event, too
 *     event.originalEvent; // MouseEvent(...)
 *   });
 *
 *   eventBus.on('element.click', function(event) {
 *     dragging.init(event, 'mydrag', {
 *       cursor: 'grabbing',
 *       data: {
 *         context: {
 *           foo: "BAR"
 *         }
 *       }
 *     });
 *   });
 * }
 */
function Dragging(eventBus, canvas, selection) {

  var defaultOptions = {
    threshold: 5,
    trapClick: true
  };

  // the currently active drag operation
  // dragging is active as soon as this context exists.
  //
  // it is visually _active_ only when a context.active flag is set to true.
  var context;

  /* convert a global event into local coordinates */
  function toLocalPoint(globalPosition) {

    var viewbox = canvas.viewbox();

    var clientRect = canvas._container.getBoundingClientRect();

    return {
      x: viewbox.x + (globalPosition.x - clientRect.left) / viewbox.scale,
      y: viewbox.y + (globalPosition.y - clientRect.top) / viewbox.scale
    };
  }

  // helpers

  function fire(type, dragContext) {
    dragContext = dragContext || context;

    var event = eventBus.createEvent((0, _minDash.assign)({}, dragContext.payload, dragContext.data, { isTouch: dragContext.isTouch }));

    // default integration
    if (eventBus.fire('drag.' + type, event) === false) {
      return false;
    }

    return eventBus.fire(dragContext.prefix + '.' + type, event);
  }

  // event listeners

  function move(event, activate) {
    var payload = context.payload,
        displacement = context.displacement;

    var globalStart = context.globalStart,
        globalCurrent = (0, _Event.toPoint)(event),
        globalDelta = (0, _PositionUtil.delta)(globalCurrent, globalStart);

    var localStart = context.localStart,
        localCurrent = toLocalPoint(globalCurrent),
        localDelta = (0, _PositionUtil.delta)(localCurrent, localStart);

    // activate context explicitly or once threshold is reached
    if (!context.active && (activate || getLength(globalDelta) > context.threshold)) {

      // fire start event with original
      // starting coordinates

      (0, _minDash.assign)(payload, {
        x: round(localStart.x + displacement.x),
        y: round(localStart.y + displacement.y),
        dx: 0,
        dy: 0
      }, { originalEvent: event });

      if (false === fire('start')) {
        return cancel();
      }

      context.active = true;

      // unset selection and remember old selection
      // the previous (old) selection will always passed
      // with the event via the event.previousSelection property
      if (!context.keepSelection) {
        payload.previousSelection = selection.get();
        selection.select(null);
      }

      // allow custom cursor
      if (context.cursor) {
        (0, _Cursor.set)(context.cursor);
      }

      // indicate dragging via marker on root element
      canvas.addMarker(canvas.getRootElement(), DRAG_ACTIVE_CLS);
    }

    (0, _Event.stopPropagation)(event);

    if (context.active) {

      // update payload with actual coordinates
      (0, _minDash.assign)(payload, {
        x: round(localCurrent.x + displacement.x),
        y: round(localCurrent.y + displacement.y),
        dx: round(localDelta.x),
        dy: round(localDelta.y)
      }, { originalEvent: event });

      // emit move event
      fire('move');
    }
  }

  function end(event) {
    var previousContext,
        returnValue = true;

    if (context.active) {

      if (event) {
        context.payload.originalEvent = event;

        // suppress original event (click, ...)
        // because we just ended a drag operation
        (0, _Event.stopPropagation)(event);
      }

      // implementations may stop restoring the
      // original state (selections, ...) by preventing the
      // end events default action
      returnValue = fire('end');
    }

    if (returnValue === false) {
      fire('rejected');
    }

    previousContext = cleanup(returnValue !== true);

    // last event to be fired when all drag operations are done
    // at this point in time no drag operation is in progress anymore
    fire('ended', previousContext);
  }

  // cancel active drag operation if the user presses
  // the ESC key on the keyboard

  function checkCancel(event) {

    if (event.which === 27) {
      preventDefault(event);

      cancel();
    }
  }

  // prevent ghost click that might occur after a finished
  // drag and drop session

  function trapClickAndEnd(event) {

    var untrap;

    // trap the click in case we are part of an active
    // drag operation. This will effectively prevent
    // the ghost click that cannot be canceled otherwise.
    if (context.active) {

      untrap = (0, _ClickTrap.install)(eventBus);

      // remove trap after minimal delay
      setTimeout(untrap, 400);

      // prevent default action (click)
      preventDefault(event);
    }

    end(event);
  }

  function trapTouch(event) {
    move(event);
  }

  // update the drag events hover (djs.model.Base) and hoverGfx (Snap<SVGElement>)
  // properties during hover and out and fire {prefix}.hover and {prefix}.out properties
  // respectively

  function hover(event) {
    var payload = context.payload;

    payload.hoverGfx = event.gfx;
    payload.hover = event.element;

    fire('hover');
  }

  function out(event) {
    fire('out');

    var payload = context.payload;

    payload.hoverGfx = null;
    payload.hover = null;
  }

  // life-cycle methods

  function cancel(restore) {
    var previousContext;

    if (!context) {
      return;
    }

    var wasActive = context.active;

    if (wasActive) {
      fire('cancel');
    }

    previousContext = cleanup(restore);

    if (wasActive) {
      // last event to be fired when all drag operations are done
      // at this point in time no drag operation is in progress anymore
      fire('canceled', previousContext);
    }
  }

  function cleanup(restore) {
    var previousContext, endDrag;

    fire('cleanup');

    // reset cursor
    (0, _Cursor.unset)();

    if (context.trapClick) {
      endDrag = trapClickAndEnd;
    } else {
      endDrag = end;
    }

    // reset dom listeners
    _minDom.event.unbind(document, 'mousemove', move);

    _minDom.event.unbind(document, 'dragstart', preventDefault);
    _minDom.event.unbind(document, 'selectstart', preventDefault);

    _minDom.event.unbind(document, 'mousedown', endDrag, true);
    _minDom.event.unbind(document, 'mouseup', endDrag, true);

    _minDom.event.unbind(document, 'keyup', checkCancel);

    _minDom.event.unbind(document, 'touchstart', trapTouch, true);
    _minDom.event.unbind(document, 'touchcancel', cancel, true);
    _minDom.event.unbind(document, 'touchmove', move, true);
    _minDom.event.unbind(document, 'touchend', end, true);

    eventBus.off('element.hover', hover);
    eventBus.off('element.out', out);

    // remove drag marker on root element
    canvas.removeMarker(canvas.getRootElement(), DRAG_ACTIVE_CLS);

    // restore selection, unless it has changed
    var previousSelection = context.payload.previousSelection;

    if (restore !== false && previousSelection && !selection.get().length) {
      selection.select(previousSelection);
    }

    previousContext = context;

    context = null;

    return previousContext;
  }

  /**
   * Initialize a drag operation.
   *
   * If `localPosition` is given, drag events will be emitted
   * relative to it.
   *
   * @param {MouseEvent|TouchEvent} [event]
   * @param {Point} [localPosition] actual diagram local position this drag operation should start at
   * @param {String} prefix
   * @param {Object} [options]
   */
  function init(event, relativeTo, prefix, options) {

    // only one drag operation may be active, at a time
    if (context) {
      cancel(false);
    }

    if (typeof relativeTo === 'string') {
      options = prefix;
      prefix = relativeTo;
      relativeTo = null;
    }

    options = (0, _minDash.assign)({}, defaultOptions, options || {});

    var data = options.data || {},
        originalEvent,
        globalStart,
        localStart,
        endDrag,
        isTouch;

    if (options.trapClick) {
      endDrag = trapClickAndEnd;
    } else {
      endDrag = end;
    }

    if (event) {
      originalEvent = (0, _Event.getOriginal)(event) || event;
      globalStart = (0, _Event.toPoint)(event);

      (0, _Event.stopPropagation)(event);

      // prevent default browser dragging behavior
      if (originalEvent.type === 'dragstart') {
        preventDefault(originalEvent);
      }
    } else {
      originalEvent = null;
      globalStart = { x: 0, y: 0 };
    }

    localStart = toLocalPoint(globalStart);

    if (!relativeTo) {
      relativeTo = localStart;
    }

    isTouch = isTouchEvent(originalEvent);

    context = (0, _minDash.assign)({
      prefix: prefix,
      data: data,
      payload: {},
      globalStart: globalStart,
      displacement: (0, _PositionUtil.delta)(relativeTo, localStart),
      localStart: localStart,
      isTouch: isTouch
    }, options);

    // skip dom registration if trigger
    // is set to manual (during testing)
    if (!options.manual) {

      // add dom listeners

      if (isTouch) {
        _minDom.event.bind(document, 'touchstart', trapTouch, true);
        _minDom.event.bind(document, 'touchcancel', cancel, true);
        _minDom.event.bind(document, 'touchmove', move, true);
        _minDom.event.bind(document, 'touchend', end, true);
      } else {
        // assume we use the mouse to interact per default
        _minDom.event.bind(document, 'mousemove', move);

        // prevent default browser drag and text selection behavior
        _minDom.event.bind(document, 'dragstart', preventDefault);
        _minDom.event.bind(document, 'selectstart', preventDefault);

        _minDom.event.bind(document, 'mousedown', endDrag, true);
        _minDom.event.bind(document, 'mouseup', endDrag, true);
      }

      _minDom.event.bind(document, 'keyup', checkCancel);

      eventBus.on('element.hover', hover);
      eventBus.on('element.out', out);
    }

    fire('init');

    if (options.autoActivate) {
      move(event, true);
    }
  }

  // cancel on diagram destruction
  eventBus.on('diagram.destroy', cancel);

  // API

  this.init = init;
  this.move = move;
  this.hover = hover;
  this.out = out;
  this.end = end;

  this.cancel = cancel;

  // for introspection

  this.context = function () {
    return context;
  };

  this.setOptions = function (options) {
    (0, _minDash.assign)(defaultOptions, options);
  };
}

Dragging.$inject = ['eventBus', 'canvas', 'selection'];

},{"232":232,"234":234,"237":237,"245":245,"254":254,"255":255}],130:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = HoverFix;

var _minDom = _dereq_(255);

var _Event = _dereq_(237);

function getGfx(target) {
  var node = (0, _minDom.closest)(target, 'svg, .djs-element', true);
  return node;
}

/**
 * Browsers may swallow the hover event if users are to
 * fast with the mouse.
 *
 * @see http://stackoverflow.com/questions/7448468/why-cant-i-reliably-capture-a-mouseout-event
 *
 * The fix implemented in this component ensure that we
 * have a hover state after a successive drag.move event.
 *
 * @param {EventBus} eventBus
 * @param {Dragging} dragging
 * @param {ElementRegistry} elementRegistry
 */
function HoverFix(eventBus, dragging, elementRegistry) {

  var self = this;

  // we wait for a specific sequence of events before
  // emitting a fake drag.hover event.
  //
  // Event Sequence:
  //
  // drag.start
  // drag.move
  // drag.move >> ensure we are hovering
  //
  eventBus.on('drag.start', function (event) {

    eventBus.once('drag.move', function () {

      eventBus.once('drag.move', function (event) {

        self.ensureHover(event);
      });
    });
  });

  /**
   * Make sure we are god damn hovering!
   *
   * @param {Event} dragging event
   */
  this.ensureHover = function (event) {

    if (event.hover) {
      return;
    }

    var originalEvent = event.originalEvent,
        position,
        target,
        element,
        gfx;

    if (!(originalEvent instanceof MouseEvent)) {
      return;
    }

    position = (0, _Event.toPoint)(originalEvent);

    // damn expensive operation, ouch!
    target = document.elementFromPoint(position.x, position.y);

    gfx = getGfx(target);

    if (gfx) {
      element = elementRegistry.get(gfx);

      dragging.hover({ element: element, gfx: gfx });
    }
  };
}

HoverFix.$inject = ['eventBus', 'dragging', 'elementRegistry'];

},{"237":237,"255":255}],131:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _selection = _dereq_(206);

var _selection2 = _interopRequireDefault(_selection);

var _Dragging = _dereq_(129);

var _Dragging2 = _interopRequireDefault(_Dragging);

var _HoverFix = _dereq_(130);

var _HoverFix2 = _interopRequireDefault(_HoverFix);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['hoverFix'],
  __depends__: [_selection2.default],
  dragging: ['type', _Dragging2.default],
  hoverFix: ['type', _HoverFix2.default]
};

},{"129":129,"130":130,"206":206}],132:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = EditorActions;

var _minDash = _dereq_(254);

var NOT_REGISTERED_ERROR = 'is not a registered action',
    IS_REGISTERED_ERROR = 'is already registered';

/**
 * An interface that provides access to modeling actions by decoupling
 * the one who requests the action to be triggered and the trigger itself.
 *
 * It's possible to add new actions by registering them with ´registerAction´
 * and likewise unregister existing ones with ´unregisterAction´.
 *
 *
 * ## Life-Cycle and configuration
 *
 * The editor actions will wait for diagram initialization before
 * registering default actions _and_ firing an `editorActions.init` event.
 *
 * Interested parties may listen to the `editorActions.init` event with
 * low priority to check, which actions got registered. Other components
 * may use the event to register their own actions via `registerAction`.
 *
 * @param {EventBus} eventBus
 * @param {Injector} injector
 */
function EditorActions(eventBus, injector) {

  // initialize actions
  this._actions = {};

  var self = this;

  eventBus.on('diagram.init', function () {

    // all diagram modules got loaded; check which ones
    // are available and register the respective default actions
    self._registerDefaultActions(injector);

    // ask interested parties to register available editor
    // actions on diagram initialization
    eventBus.fire('editorActions.init', {
      editorActions: self
    });
  });
}

EditorActions.$inject = ['eventBus', 'injector'];

/**
 * Register default actions.
 *
 * @param {Injector} injector
 */
EditorActions.prototype._registerDefaultActions = function (injector) {

  // (1) retrieve optional components to integrate with

  var commandStack = injector.get('commandStack', false);
  var modeling = injector.get('modeling', false);
  var selection = injector.get('selection', false);
  var zoomScroll = injector.get('zoomScroll', false);
  var copyPaste = injector.get('copyPaste', false);
  var canvas = injector.get('canvas', false);
  var rules = injector.get('rules', false);
  var mouseTracking = injector.get('mouseTracking', false);
  var keyboardMove = injector.get('keyboardMove', false);
  var keyboardMoveSelection = injector.get('keyboardMoveSelection', false);

  // (2) check components and register actions

  if (commandStack) {
    this.register('undo', function () {
      commandStack.undo();
    });

    this.register('redo', function () {
      commandStack.redo();
    });
  }

  if (copyPaste && selection) {
    this.register('copy', function () {
      var selectedElements = selection.get();

      copyPaste.copy(selectedElements);
    });
  }

  if (mouseTracking && copyPaste) {
    this.register('paste', function () {
      var context = mouseTracking.getHoverContext();

      copyPaste.paste(context);
    });
  }

  if (zoomScroll) {
    this.register('stepZoom', function (opts) {
      zoomScroll.stepZoom(opts.value);
    });
  }

  if (canvas) {
    this.register('zoom', function (opts) {
      canvas.zoom(opts.value);
    });
  }

  if (modeling && selection && rules) {
    this.register('removeSelection', function () {

      var selectedElements = selection.get();

      if (!selectedElements.length) {
        return;
      }

      var allowed = rules.allowed('elements.delete', { elements: selectedElements }),
          removableElements;

      if (allowed === false) {
        return;
      } else if ((0, _minDash.isArray)(allowed)) {
        removableElements = allowed;
      } else {
        removableElements = selectedElements;
      }

      if (removableElements.length) {
        modeling.removeElements(removableElements.slice());
      }
    });
  }

  if (keyboardMove) {
    this.register('moveCanvas', function (opts) {
      keyboardMove.moveCanvas(opts);
    });
  }

  if (keyboardMoveSelection) {
    this.register('moveSelection', function (opts) {
      keyboardMoveSelection.moveSelection(opts.direction, opts.accelerated);
    });
  }
};

/**
 * Triggers a registered action
 *
 * @param  {String} action
 * @param  {Object} opts
 *
 * @return {Unknown} Returns what the registered listener returns
 */
EditorActions.prototype.trigger = function (action, opts) {
  if (!this._actions[action]) {
    throw error(action, NOT_REGISTERED_ERROR);
  }

  return this._actions[action](opts);
};

/**
 * Registers a collections of actions.
 * The key of the object will be the name of the action.
 *
 * @example
 * ´´´
 * var actions = {
 *   spaceTool: function() {
 *     spaceTool.activateSelection();
 *   },
 *   lassoTool: function() {
 *     lassoTool.activateSelection();
 *   }
 * ];
 *
 * editorActions.register(actions);
 *
 * editorActions.isRegistered('spaceTool'); // true
 * ´´´
 *
 * @param  {Object} actions
 */
EditorActions.prototype.register = function (actions, listener) {
  var self = this;

  if (typeof actions === 'string') {
    return this._registerAction(actions, listener);
  }

  (0, _minDash.forEach)(actions, function (listener, action) {
    self._registerAction(action, listener);
  });
};

/**
 * Registers a listener to an action key
 *
 * @param  {String} action
 * @param  {Function} listener
 */
EditorActions.prototype._registerAction = function (action, listener) {
  if (this.isRegistered(action)) {
    throw error(action, IS_REGISTERED_ERROR);
  }

  this._actions[action] = listener;
};

/**
 * Unregister an existing action
 *
 * @param {String} action
 */
EditorActions.prototype.unregister = function (action) {
  if (!this.isRegistered(action)) {
    throw error(action, NOT_REGISTERED_ERROR);
  }

  this._actions[action] = undefined;
};

/**
 * Returns the number of actions that are currently registered
 *
 * @return {Number}
 */
EditorActions.prototype.getActions = function () {
  return Object.keys(this._actions);
};

/**
 * Checks wether the given action is registered
 *
 * @param {String} action
 *
 * @return {Boolean}
 */
EditorActions.prototype.isRegistered = function (action) {
  return !!this._actions[action];
};

function error(action, message) {
  return new Error(action + ' ' + message);
}

},{"254":254}],133:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _EditorActions = _dereq_(132);

var _EditorActions2 = _interopRequireDefault(_EditorActions);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['editorActions'],
  editorActions: ['type', _EditorActions2.default]
};

},{"132":132}],134:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = GlobalConnect;
var MARKER_OK = 'connect-ok',
    MARKER_NOT_OK = 'connect-not-ok';

/**
 * @class
 * @constructor
 *
 * @param {EventBus} eventBus
 * @param {Dragging} dragging
 * @param {Connect} connect
 * @param {Canvas} canvas
 * @param {ToolManager} toolManager
 * @param {Rules} rules
 */
function GlobalConnect(eventBus, dragging, connect, canvas, toolManager, rules) {

  var self = this;

  this._dragging = dragging;
  this._rules = rules;

  toolManager.registerTool('global-connect', {
    tool: 'global-connect',
    dragging: 'global-connect.drag'
  });

  eventBus.on('global-connect.hover', function (event) {
    var context = event.context,
        startTarget = event.hover;

    var canStartConnect = context.canStartConnect = self.canStartConnect(startTarget);

    // simply ignore hover
    if (canStartConnect === null) {
      return;
    }

    context.startTarget = startTarget;

    canvas.addMarker(startTarget, canStartConnect ? MARKER_OK : MARKER_NOT_OK);
  });

  eventBus.on(['global-connect.out', 'global-connect.cleanup'], function (event) {
    var startTarget = event.context.startTarget,
        canStartConnect = event.context.canStartConnect;

    if (startTarget) {
      canvas.removeMarker(startTarget, canStartConnect ? MARKER_OK : MARKER_NOT_OK);
    }
  });

  eventBus.on(['global-connect.ended'], function (event) {
    var context = event.context,
        startTarget = context.startTarget,
        startPosition = {
      x: event.x,
      y: event.y
    };

    var canStartConnect = self.canStartConnect(startTarget);

    if (!canStartConnect) {
      return;
    }

    eventBus.once('element.out', function () {
      eventBus.once(['connect.ended', 'connect.canceled'], function () {
        eventBus.fire('global-connect.drag.ended');
      });

      connect.start(null, startTarget, startPosition);
    });

    return false;
  });
}

GlobalConnect.$inject = ['eventBus', 'dragging', 'connect', 'canvas', 'toolManager', 'rules'];

/**
 * Initiates tool activity.
 */
GlobalConnect.prototype.start = function (event) {
  this._dragging.init(event, 'global-connect', {
    trapClick: false,
    data: {
      context: {}
    }
  });
};

GlobalConnect.prototype.toggle = function () {
  if (this.isActive()) {
    this._dragging.cancel();
  } else {
    this.start();
  }
};

GlobalConnect.prototype.isActive = function () {
  var context = this._dragging.context();

  return context && /^global-connect/.test(context.prefix);
};

/**
 * Check if source shape can initiate connection.
 *
 * @param  {Shape} startTarget
 * @return {Boolean}
 */
GlobalConnect.prototype.canStartConnect = function (startTarget) {
  return this._rules.allowed('connection.start', { source: startTarget });
};

},{}],135:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _connect = _dereq_(122);

var _connect2 = _interopRequireDefault(_connect);

var _rules = _dereq_(200);

var _rules2 = _interopRequireDefault(_rules);

var _dragging = _dereq_(131);

var _dragging2 = _interopRequireDefault(_dragging);

var _toolManager = _dereq_(218);

var _toolManager2 = _interopRequireDefault(_toolManager);

var _GlobalConnect = _dereq_(134);

var _GlobalConnect2 = _interopRequireDefault(_GlobalConnect);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_connect2.default, _rules2.default, _dragging2.default, _toolManager2.default],
  globalConnect: ['type', _GlobalConnect2.default]
};

},{"122":122,"131":131,"134":134,"200":200,"218":218}],136:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = HandTool;

var _Mouse = _dereq_(243);

var _KeyboardUtil = _dereq_(144);

var HIGH_PRIORITY = 1500;
var HAND_CURSOR = 'grab';

function HandTool(eventBus, canvas, dragging, injector, toolManager) {
  this._dragging = dragging;

  var self = this,
      keyboard = injector.get('keyboard', false);

  toolManager.registerTool('hand', {
    tool: 'hand',
    dragging: 'hand.move'
  });

  eventBus.on('element.mousedown', HIGH_PRIORITY, function (event) {
    if ((0, _Mouse.hasPrimaryModifier)(event)) {
      this.activateMove(event.originalEvent);

      return false;
    }
  }, this);

  keyboard && keyboard.addListener(HIGH_PRIORITY, function (e) {
    if (!isSpace(e.keyEvent)) {
      return;
    }

    if (self.isActive()) {
      return;
    }

    function activateMove(event) {
      self.activateMove(event);

      window.removeEventListener('mousemove', activateMove);
    }

    window.addEventListener('mousemove', activateMove);

    function deactivateMove(e) {
      if (!isSpace(e.keyEvent)) {
        return;
      }

      window.removeEventListener('mousemove', activateMove);

      keyboard.removeListener(deactivateMove, 'keyboard.keyup');

      dragging.cancel();
    }

    keyboard.addListener(HIGH_PRIORITY, deactivateMove, 'keyboard.keyup');
  }, 'keyboard.keydown');

  eventBus.on('hand.end', function (event) {
    var target = event.originalEvent.target;

    // only reactive on diagram click
    // on some occasions, event.hover is not set and we have to check if the target is an svg
    if (!event.hover && !(target instanceof SVGElement)) {
      return false;
    }

    eventBus.once('hand.ended', function () {
      this.activateMove(event.originalEvent, { reactivate: true });
    }, this);
  }, this);

  eventBus.on('hand.move.move', function (event) {
    var scale = canvas.viewbox().scale;

    canvas.scroll({
      dx: event.dx * scale,
      dy: event.dy * scale
    });
  });

  eventBus.on('hand.move.end', function (event) {
    var context = event.context,
        reactivate = context.reactivate;

    // Don't reactivate if the user is using the keyboard keybinding
    if (!(0, _Mouse.hasPrimaryModifier)(event) && reactivate) {

      eventBus.once('hand.move.ended', function (event) {
        this.activateHand(event.originalEvent, true, true);
      }, this);
    }

    return false;
  }, this);
}

HandTool.$inject = ['eventBus', 'canvas', 'dragging', 'injector', 'toolManager'];

HandTool.prototype.activateMove = function (event, autoActivate, context) {
  if ((typeof autoActivate === 'undefined' ? 'undefined' : _typeof(autoActivate)) === 'object') {
    context = autoActivate;
    autoActivate = false;
  }

  this._dragging.init(event, 'hand.move', {
    autoActivate: autoActivate,
    cursor: HAND_CURSOR,
    data: {
      context: context || {}
    }
  });
};

HandTool.prototype.activateHand = function (event, autoActivate, reactivate) {
  this._dragging.init(event, 'hand', {
    trapClick: false,
    autoActivate: autoActivate,
    cursor: HAND_CURSOR,
    data: {
      context: {
        reactivate: reactivate
      }
    }
  });
};

HandTool.prototype.toggle = function () {
  if (this.isActive()) {
    this._dragging.cancel();
  } else {
    this.activateHand();
  }
};

HandTool.prototype.isActive = function () {
  var context = this._dragging.context();

  if (context) {
    return (/^(hand|hand\.move)$/.test(context.prefix)
    );
  }

  return false;
};

// helpers //////////

function isSpace(keyEvent) {
  return (0, _KeyboardUtil.isKey)(' ', keyEvent);
}

},{"144":144,"243":243}],137:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _toolManager = _dereq_(218);

var _toolManager2 = _interopRequireDefault(_toolManager);

var _HandTool = _dereq_(136);

var _HandTool2 = _interopRequireDefault(_HandTool);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_toolManager2.default],
  __init__: ['handTool'],
  handTool: ['type', _HandTool2.default]
};

},{"136":136,"218":218}],138:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = InteractionEvents;

var _minDash = _dereq_(254);

var _minDom = _dereq_(255);

var _Mouse = _dereq_(243);

var _tinySvg = _dereq_(275);

var _RenderUtil = _dereq_(247);

function allowAll(e) {
  return true;
}

var LOW_PRIORITY = 500;

/**
 * A plugin that provides interaction events for diagram elements.
 *
 * It emits the following events:
 *
 *   * element.hover
 *   * element.out
 *   * element.click
 *   * element.dblclick
 *   * element.mousedown
 *   * element.contextmenu
 *
 * Each event is a tuple { element, gfx, originalEvent }.
 *
 * Canceling the event via Event#preventDefault()
 * prevents the original DOM operation.
 *
 * @param {EventBus} eventBus
 */
function InteractionEvents(eventBus, elementRegistry, styles) {

  var HIT_STYLE = styles.cls('djs-hit', ['no-fill', 'no-border'], {
    stroke: 'white',
    strokeWidth: 15
  });

  /**
   * Fire an interaction event.
   *
   * @param {String} type local event name, e.g. element.click.
   * @param {DOMEvent} event native event
   * @param {djs.model.Base} [element] the diagram element to emit the event on;
   *                                   defaults to the event target
   */
  function fire(type, event, element) {

    if (isIgnored(type, event)) {
      return;
    }

    var target, gfx, returnValue;

    if (!element) {
      target = event.delegateTarget || event.target;

      if (target) {
        gfx = target;
        element = elementRegistry.get(gfx);
      }
    } else {
      gfx = elementRegistry.getGraphics(element);
    }

    if (!gfx || !element) {
      return;
    }

    returnValue = eventBus.fire(type, {
      element: element,
      gfx: gfx,
      originalEvent: event
    });

    if (returnValue === false) {
      event.stopPropagation();
      event.preventDefault();
    }
  }

  // TODO(nikku): document this
  var handlers = {};

  function mouseHandler(localEventName) {
    return handlers[localEventName];
  }

  function isIgnored(localEventName, event) {

    var filter = ignoredFilters[localEventName] || _Mouse.isPrimaryButton;

    // only react on left mouse button interactions
    // except for interaction events that are enabled
    // for secundary mouse button
    return !filter(event);
  }

  var bindings = {
    mouseover: 'element.hover',
    mouseout: 'element.out',
    click: 'element.click',
    dblclick: 'element.dblclick',
    mousedown: 'element.mousedown',
    mousemove: 'element.mousemove',
    mouseup: 'element.mouseup',
    contextmenu: 'element.contextmenu'
  };

  var ignoredFilters = {
    'element.contextmenu': allowAll
  };

  // manual event trigger

  /**
   * Trigger an interaction event (based on a native dom event)
   * on the target shape or connection.
   *
   * @param {String} eventName the name of the triggered DOM event
   * @param {MouseEvent} event
   * @param {djs.model.Base} targetElement
   */
  function triggerMouseEvent(eventName, event, targetElement) {

    // i.e. element.mousedown...
    var localEventName = bindings[eventName];

    if (!localEventName) {
      throw new Error('unmapped DOM event name <' + eventName + '>');
    }

    return fire(localEventName, event, targetElement);
  }

  var elementSelector = 'svg, .djs-element';

  // event registration

  function registerEvent(node, event, localEvent, ignoredFilter) {

    var handler = handlers[localEvent] = function (event) {
      fire(localEvent, event);
    };

    if (ignoredFilter) {
      ignoredFilters[localEvent] = ignoredFilter;
    }

    handler.$delegate = _minDom.delegate.bind(node, elementSelector, event, handler);
  }

  function unregisterEvent(node, event, localEvent) {

    var handler = mouseHandler(localEvent);

    if (!handler) {
      return;
    }

    _minDom.delegate.unbind(node, event, handler.$delegate);
  }

  function registerEvents(svg) {
    (0, _minDash.forEach)(bindings, function (val, key) {
      registerEvent(svg, key, val);
    });
  }

  function unregisterEvents(svg) {
    (0, _minDash.forEach)(bindings, function (val, key) {
      unregisterEvent(svg, key, val);
    });
  }

  eventBus.on('canvas.destroy', function (event) {
    unregisterEvents(event.svg);
  });

  eventBus.on('canvas.init', function (event) {
    registerEvents(event.svg);
  });

  eventBus.on(['shape.added', 'connection.added'], function (event) {
    var element = event.element,
        gfx = event.gfx,
        hit;

    if (element.waypoints) {
      hit = (0, _RenderUtil.createLine)(element.waypoints);
    } else {
      hit = (0, _tinySvg.create)('rect');
      (0, _tinySvg.attr)(hit, {
        x: 0,
        y: 0,
        width: element.width,
        height: element.height
      });
    }

    (0, _tinySvg.attr)(hit, HIT_STYLE);

    (0, _tinySvg.append)(gfx, hit);
  });

  // Update djs-hit on change.
  // A low priortity is necessary, because djs-hit of labels has to be updated
  // after the label bounds have been updated in the renderer.
  eventBus.on('shape.changed', LOW_PRIORITY, function (event) {

    var element = event.element,
        gfx = event.gfx,
        hit = (0, _minDom.query)('.djs-hit', gfx);

    (0, _tinySvg.attr)(hit, {
      width: element.width,
      height: element.height
    });
  });

  eventBus.on('connection.changed', function (event) {

    var element = event.element,
        gfx = event.gfx,
        hit = (0, _minDom.query)('.djs-hit', gfx);

    (0, _RenderUtil.updateLine)(hit, element.waypoints);
  });

  // API

  this.fire = fire;

  this.triggerMouseEvent = triggerMouseEvent;

  this.mouseHandler = mouseHandler;

  this.registerEvent = registerEvent;
  this.unregisterEvent = unregisterEvent;
}

InteractionEvents.$inject = ['eventBus', 'elementRegistry', 'styles'];

/**
 * An event indicating that the mouse hovered over an element
 *
 * @event element.hover
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {SVGElement} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the mouse has left an element
 *
 * @event element.out
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {SVGElement} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the mouse has clicked an element
 *
 * @event element.click
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {SVGElement} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the mouse has double clicked an element
 *
 * @event element.dblclick
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {SVGElement} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the mouse has gone down on an element.
 *
 * @event element.mousedown
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {SVGElement} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the mouse has gone up on an element.
 *
 * @event element.mouseup
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {SVGElement} gfx
 * @property {Event} originalEvent
 */

/**
 * An event indicating that the context menu action is triggered
 * via mouse or touch controls.
 *
 * @event element.contextmenu
 *
 * @type {Object}
 * @property {djs.model.Base} element
 * @property {SVGElement} gfx
 * @property {Event} originalEvent
 */

},{"243":243,"247":247,"254":254,"255":255,"275":275}],139:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _InteractionEvents = _dereq_(138);

var _InteractionEvents2 = _interopRequireDefault(_InteractionEvents);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['interactionEvents'],
  interactionEvents: ['type', _InteractionEvents2.default]
};

},{"138":138}],140:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = KeyboardMoveSelection;

var _minDash = _dereq_(254);

var DEFAULT_CONFIG = {
  moveSpeed: 1,
  moveSpeedAccelerated: 10
};

var HIGHER_PRIORITY = 1500;

var LEFT = 'left';
var UP = 'up';
var RIGHT = 'right';
var DOWN = 'down';

var KEY_TO_DIRECTION = {
  ArrowLeft: LEFT,
  Left: LEFT,
  ArrowUp: UP,
  Up: UP,
  ArrowRight: RIGHT,
  Right: RIGHT,
  ArrowDown: DOWN,
  Down: DOWN
};

var DIRECTIONS_DELTA = {
  left: function left(speed) {
    return {
      x: -speed,
      y: 0
    };
  },
  up: function up(speed) {
    return {
      x: 0,
      y: -speed
    };
  },
  right: function right(speed) {
    return {
      x: speed,
      y: 0
    };
  },
  down: function down(speed) {
    return {
      x: 0,
      y: speed
    };
  }
};

/**
 * Enables to move selection with keyboard arrows.
 * Use with Shift for modified speed (default=1, with Shift=10).
 * Pressed Cmd/Ctrl turns the feature off.
 *
 * @param {Object} config
 * @param {Number} [config.moveSpeed=1]
 * @param {Number} [config.moveSpeedAccelerated=10]
 * @param {Keyboard} keyboard
 * @param {Modeling} modeling
 * @param {Selection} selection
 */
function KeyboardMoveSelection(config, keyboard, modeling, selection) {

  var self = this;

  this._config = (0, _minDash.assign)({}, DEFAULT_CONFIG, config || {});

  keyboard.addListener(HIGHER_PRIORITY, function (event) {

    var keyEvent = event.keyEvent;

    var direction = KEY_TO_DIRECTION[keyEvent.key];

    if (!direction) {
      return;
    }

    if (keyboard.isCmd(keyEvent)) {
      return;
    }

    var accelerated = keyboard.isShift(keyEvent);

    self.moveSelection(direction, accelerated);

    return true;
  });

  /**
   * Move selected elements in the given direction,
   * optionally specifying accelerated movement.
   *
   * @param {String} direction
   * @param {Boolean} [accelerated=false]
   */
  this.moveSelection = function (direction, accelerated) {

    var selectedElements = selection.get();

    if (!selectedElements.length) {
      return;
    }

    var speed = this._config[accelerated ? 'moveSpeedAccelerated' : 'moveSpeed'];

    var delta = DIRECTIONS_DELTA[direction](speed);

    modeling.moveElements(selectedElements, delta);
  };
}

KeyboardMoveSelection.$inject = ['config.keyboardMoveSelection', 'keyboard', 'modeling', 'selection'];

},{"254":254}],141:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _keyboard = _dereq_(145);

var _keyboard2 = _interopRequireDefault(_keyboard);

var _selection = _dereq_(206);

var _selection2 = _interopRequireDefault(_selection);

var _KeyboardMoveSelection = _dereq_(140);

var _KeyboardMoveSelection2 = _interopRequireDefault(_KeyboardMoveSelection);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_keyboard2.default, _selection2.default],
  __init__: ['keyboardMoveSelection'],
  keyboardMoveSelection: ['type', _KeyboardMoveSelection2.default]
};

},{"140":140,"145":145,"206":206}],142:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Keyboard;

var _minDash = _dereq_(254);

var _minDom = _dereq_(255);

var _KeyboardUtil = _dereq_(144);

var KEYDOWN_EVENT = 'keyboard.keydown',
    KEYUP_EVENT = 'keyboard.keyup';

var DEFAULT_PRIORITY = 1000;

/**
 * A keyboard abstraction that may be activated and
 * deactivated by users at will, consuming key events
 * and triggering diagram actions.
 *
 * For keys pressed down, keyboard fires `keyboard.keydown` event.
 * The event context contains one field which is `KeyboardEvent` event.
 *
 * The implementation fires the following key events that allow
 * other components to hook into key handling:
 *
 *  - keyboard.bind
 *  - keyboard.unbind
 *  - keyboard.init
 *  - keyboard.destroy
 *
 * All events contain one field which is node.
 *
 * A default binding for the keyboard may be specified via the
 * `keyboard.bindTo` configuration option.
 *
 * @param {Config} config
 * @param {EventBus} eventBus
 */
function Keyboard(config, eventBus) {
  var self = this;

  this._config = config || {};
  this._eventBus = eventBus;

  this._keydownHandler = this._keydownHandler.bind(this);
  this._keyupHandler = this._keyupHandler.bind(this);

  // properly clean dom registrations
  eventBus.on('diagram.destroy', function () {
    self._fire('destroy');

    self.unbind();
  });

  eventBus.on('diagram.init', function () {
    self._fire('init');
  });

  eventBus.on('attach', function () {
    if (config && config.bindTo) {
      self.bind(config.bindTo);
    }
  });

  eventBus.on('detach', function () {
    self.unbind();
  });
}

Keyboard.$inject = ['config.keyboard', 'eventBus'];

Keyboard.prototype._keydownHandler = function (event) {
  this._keyHandler(event, KEYDOWN_EVENT);
};

Keyboard.prototype._keyupHandler = function (event) {
  this._keyHandler(event, KEYUP_EVENT);
};

Keyboard.prototype._keyHandler = function (event, type) {
  var target = event.target,
      eventBusResult;

  if (isInput(target)) {
    return;
  }

  var context = {
    keyEvent: event
  };

  eventBusResult = this._eventBus.fire(type || KEYDOWN_EVENT, context);

  if (eventBusResult) {
    event.preventDefault();
  }
};

Keyboard.prototype.bind = function (node) {

  // make sure that the keyboard is only bound once to the DOM
  this.unbind();

  this._node = node;

  // bind key events
  _minDom.event.bind(node, 'keydown', this._keydownHandler, true);
  _minDom.event.bind(node, 'keyup', this._keyupHandler, true);

  this._fire('bind');
};

Keyboard.prototype.getBinding = function () {
  return this._node;
};

Keyboard.prototype.unbind = function () {
  var node = this._node;

  if (node) {
    this._fire('unbind');

    // unbind key events
    _minDom.event.unbind(node, 'keydown', this._keydownHandler, true);
    _minDom.event.unbind(node, 'keyup', this._keyupHandler, true);
  }

  this._node = null;
};

Keyboard.prototype._fire = function (event) {
  this._eventBus.fire('keyboard.' + event, { node: this._node });
};

/**
 * Add a listener function that is notified with `KeyboardEvent` whenever
 * the keyboard is bound and the user presses a key. If no priority is
 * provided, the default value of 1000 is used.
 *
 * @param {Number} [priority]
 * @param {Function} listener
 * @param {string} type
 */
Keyboard.prototype.addListener = function (priority, listener, type) {
  if ((0, _minDash.isFunction)(priority)) {
    type = listener;
    listener = priority;
    priority = DEFAULT_PRIORITY;
  }

  this._eventBus.on(type || KEYDOWN_EVENT, priority, listener);
};

Keyboard.prototype.removeListener = function (listener, type) {
  this._eventBus.off(type || KEYDOWN_EVENT, listener);
};

Keyboard.prototype.hasModifier = _KeyboardUtil.hasModifier;
Keyboard.prototype.isCmd = _KeyboardUtil.isCmd;
Keyboard.prototype.isShift = _KeyboardUtil.isShift;
Keyboard.prototype.isKey = _KeyboardUtil.isKey;

// helpers ///////

function isInput(target) {
  return target && ((0, _minDom.matches)(target, 'input, textarea') || target.contentEditable === 'true');
}

},{"144":144,"254":254,"255":255}],143:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = KeyboardBindings;

var _KeyboardUtil = _dereq_(144);

var LOW_PRIORITY = 500;

/**
 * Adds default keyboard bindings.
 *
 * This does not pull in any features will bind only actions that
 * have previously been registered against the editorActions component.
 *
 * @param {EventBus} eventBus
 * @param {Keyboard} keyboard
 */
function KeyboardBindings(eventBus, keyboard) {

  var self = this;

  eventBus.on('editorActions.init', LOW_PRIORITY, function (event) {

    var editorActions = event.editorActions;

    self.registerBindings(keyboard, editorActions);
  });
}

KeyboardBindings.$inject = ['eventBus', 'keyboard'];

/**
 * Register available keyboard bindings.
 *
 * @param {Keyboard} keyboard
 * @param {EditorActions} editorActions
 */
KeyboardBindings.prototype.registerBindings = function (keyboard, editorActions) {

  /**
   * Add keyboard binding if respective editor action
   * is registered.
   *
   * @param {String} action name
   * @param {Function} fn that implements the key binding
   */
  function addListener(action, fn) {

    if (editorActions.isRegistered(action)) {
      keyboard.addListener(fn);
    }
  }

  // undo
  // (CTRL|CMD) + Z
  addListener('undo', function (context) {

    var event = context.keyEvent;

    if ((0, _KeyboardUtil.isCmd)(event) && !(0, _KeyboardUtil.isShift)(event) && (0, _KeyboardUtil.isKey)(['z', 'Z'], event)) {
      editorActions.trigger('undo');

      return true;
    }
  });

  // redo
  // CTRL + Y
  // CMD + SHIFT + Z
  addListener('redo', function (context) {

    var event = context.keyEvent;

    if ((0, _KeyboardUtil.isCmd)(event) && ((0, _KeyboardUtil.isKey)(['y', 'Y'], event) || (0, _KeyboardUtil.isKey)(['z', 'Z'], event) && (0, _KeyboardUtil.isShift)(event))) {
      editorActions.trigger('redo');

      return true;
    }
  });

  // copy
  // CTRL/CMD + C
  addListener('copy', function (context) {

    var event = context.keyEvent;

    if ((0, _KeyboardUtil.isCmd)(event) && (0, _KeyboardUtil.isKey)(['c', 'C'], event)) {
      editorActions.trigger('copy');

      return true;
    }
  });

  // paste
  // CTRL/CMD + V
  addListener('paste', function (context) {

    var event = context.keyEvent;

    if ((0, _KeyboardUtil.isCmd)(event) && (0, _KeyboardUtil.isKey)(['v', 'V'], event)) {
      editorActions.trigger('paste');

      return true;
    }
  });

  // zoom in one step
  // CTRL/CMD + +
  addListener('stepZoom', function (context) {

    var event = context.keyEvent;

    if ((0, _KeyboardUtil.isKey)(['+', 'Add'], event) && (0, _KeyboardUtil.isCmd)(event)) {
      editorActions.trigger('stepZoom', { value: 1 });

      return true;
    }
  });

  // zoom out one step
  // CTRL + -
  addListener('stepZoom', function (context) {

    var event = context.keyEvent;

    if ((0, _KeyboardUtil.isKey)(['-', 'Subtract'], event) && (0, _KeyboardUtil.isCmd)(event)) {
      editorActions.trigger('stepZoom', { value: -1 });

      return true;
    }
  });

  // zoom to the default level
  // CTRL + 0
  addListener('zoom', function (context) {

    var event = context.keyEvent;

    if ((0, _KeyboardUtil.isKey)('0', event) && (0, _KeyboardUtil.isCmd)(event)) {
      editorActions.trigger('zoom', { value: 1 });

      return true;
    }
  });

  // delete selected element
  // DEL
  addListener('removeSelection', function (context) {

    var event = context.keyEvent;

    if ((0, _KeyboardUtil.isKey)(['Delete', 'Del'], event)) {
      editorActions.trigger('removeSelection');

      return true;
    }
  });
};

},{"144":144}],144:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasModifier = hasModifier;
exports.isCmd = isCmd;
exports.isKey = isKey;
exports.isShift = isShift;

var _minDash = _dereq_(254);

/**
 * Returns true if event was triggered with any modifier
 * @param {KeyboardEvent} event
 */
function hasModifier(event) {
  return event.ctrlKey || event.metaKey || event.shiftKey || event.altKey;
}

/**
 * @param {KeyboardEvent} event
 */
function isCmd(event) {

  // ensure we don't react to AltGr
  // (mapped to CTRL + ALT)
  if (event.altKey) {
    return false;
  }

  return event.ctrlKey || event.metaKey;
}

/**
 * Checks if key pressed is one of provided keys.
 *
 * @param {String|String[]} keys
 * @param {KeyboardEvent} event
 */
function isKey(keys, event) {
  keys = (0, _minDash.isArray)(keys) ? keys : [keys];

  return keys.indexOf(event.key) > -1;
}

/**
 * @param {KeyboardEvent} event
 */
function isShift(event) {
  return event.shiftKey;
}

},{"254":254}],145:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _Keyboard = _dereq_(142);

var _Keyboard2 = _interopRequireDefault(_Keyboard);

var _KeyboardBindings = _dereq_(143);

var _KeyboardBindings2 = _interopRequireDefault(_KeyboardBindings);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['keyboard', 'keyboardBindings'],
  keyboard: ['type', _Keyboard2.default],
  keyboardBindings: ['type', _KeyboardBindings2.default]
};

},{"142":142,"143":143}],146:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = LabelSupport;

var _minDash = _dereq_(254);

var _inherits = _dereq_(253);

var _inherits2 = _interopRequireDefault(_inherits);

var _Collections = _dereq_(233);

var _Removal = _dereq_(246);

var _CommandInterceptor = _dereq_(91);

var _CommandInterceptor2 = _interopRequireDefault(_CommandInterceptor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LOW_PRIORITY = 250,
    HIGH_PRIORITY = 1400;

/**
 * A handler that makes sure labels are properly moved with
 * their label targets.
 *
 * @param {didi.Injector} injector
 * @param {EventBus} eventBus
 * @param {Modeling} modeling
 */
function LabelSupport(injector, eventBus, modeling) {

  _CommandInterceptor2.default.call(this, eventBus);

  var movePreview = injector.get('movePreview', false);

  // remove labels from the collection that are being
  // moved with other elements anyway
  eventBus.on('shape.move.start', HIGH_PRIORITY, function (e) {

    var context = e.context,
        shapes = context.shapes,
        validatedShapes = context.validatedShapes;

    context.shapes = removeLabels(shapes);
    context.validatedShapes = removeLabels(validatedShapes);
  });

  // add labels to visual's group
  movePreview && eventBus.on('shape.move.start', LOW_PRIORITY, function (e) {

    var context = e.context,
        shapes = context.shapes;

    var labels = [];

    (0, _minDash.forEach)(shapes, function (element) {

      (0, _minDash.forEach)(element.labels, function (label) {

        if (!label.hidden && context.shapes.indexOf(label) === -1) {
          labels.push(label);
        }

        if (element.labelTarget) {
          labels.push(element);
        }
      });
    });

    (0, _minDash.forEach)(labels, function (label) {
      movePreview.makeDraggable(context, label, true);
    });
  });

  // add all labels to move closure
  this.preExecuted('elements.move', HIGH_PRIORITY, function (e) {
    var context = e.context,
        closure = context.closure,
        enclosedElements = closure.enclosedElements;

    var enclosedLabels = [];

    // find labels that are not part of
    // move closure yet and add them
    (0, _minDash.forEach)(enclosedElements, function (element) {
      (0, _minDash.forEach)(element.labels, function (label) {

        if (!enclosedElements[label.id]) {
          enclosedLabels.push(label);
        }
      });
    });

    closure.addAll(enclosedLabels);
  });

  this.preExecute(['connection.delete', 'shape.delete'], function (e) {

    var context = e.context,
        element = context.connection || context.shape;

    (0, _Removal.saveClear)(element.labels, function (label) {
      modeling.removeShape(label, { nested: true });
    });
  });

  this.execute('shape.delete', function (e) {

    var context = e.context,
        shape = context.shape,
        labelTarget = shape.labelTarget;

    // unset labelTarget
    if (labelTarget) {
      context.labelTargetIndex = (0, _Collections.indexOf)(labelTarget.labels, shape);
      context.labelTarget = labelTarget;

      shape.labelTarget = null;
    }
  });

  this.revert('shape.delete', function (e) {

    var context = e.context,
        shape = context.shape,
        labelTarget = context.labelTarget,
        labelTargetIndex = context.labelTargetIndex;

    // restore labelTarget
    if (labelTarget) {
      (0, _Collections.add)(labelTarget.labels, shape, labelTargetIndex);

      shape.labelTarget = labelTarget;
    }
  });
}

(0, _inherits2.default)(LabelSupport, _CommandInterceptor2.default);

LabelSupport.$inject = ['injector', 'eventBus', 'modeling'];

/**
 * Return a filtered list of elements that do not
 * contain attached elements with hosts being part
 * of the selection.
 *
 * @param  {Array<djs.model.Base>} elements
 *
 * @return {Array<djs.model.Base>} filtered
 */
function removeLabels(elements) {

  return (0, _minDash.filter)(elements, function (element) {

    // filter out labels that are move together
    // with their label targets
    return elements.indexOf(element.labelTarget) === -1;
  });
}

},{"233":233,"246":246,"253":253,"254":254,"91":91}],147:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _LabelSupport = _dereq_(146);

var _LabelSupport2 = _interopRequireDefault(_LabelSupport);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['labelSupport'],
  labelSupport: ['type', _LabelSupport2.default]
};

},{"146":146}],148:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = LassoTool;

var _minDash = _dereq_(254);

var _Elements = _dereq_(235);

var _Mouse = _dereq_(243);

var _tinySvg = _dereq_(275);

var LASSO_TOOL_CURSOR = 'crosshair';

function LassoTool(eventBus, canvas, dragging, elementRegistry, selection, toolManager) {

  this._selection = selection;
  this._dragging = dragging;

  var self = this;

  // lasso visuals implementation

  /**
  * A helper that realizes the selection box visual
  */
  var visuals = {

    create: function create(context) {
      var container = canvas.getDefaultLayer(),
          frame;

      frame = context.frame = (0, _tinySvg.create)('rect');
      (0, _tinySvg.attr)(frame, {
        class: 'djs-lasso-overlay',
        width: 1,
        height: 1,
        x: 0,
        y: 0
      });

      (0, _tinySvg.append)(container, frame);
    },

    update: function update(context) {
      var frame = context.frame,
          bbox = context.bbox;

      (0, _tinySvg.attr)(frame, {
        x: bbox.x,
        y: bbox.y,
        width: bbox.width,
        height: bbox.height
      });
    },

    remove: function remove(context) {

      if (context.frame) {
        (0, _tinySvg.remove)(context.frame);
      }
    }
  };

  toolManager.registerTool('lasso', {
    tool: 'lasso.selection',
    dragging: 'lasso'
  });

  eventBus.on('lasso.selection.end', function (event) {
    var target = event.originalEvent.target;

    // only reactive on diagram click
    // on some occasions, event.hover is not set and we have to check if the target is an svg
    if (!event.hover && !(target instanceof SVGElement)) {
      return;
    }

    eventBus.once('lasso.selection.ended', function () {
      self.activateLasso(event.originalEvent, true);
    });
  });

  // lasso interaction implementation

  eventBus.on('lasso.end', function (event) {

    var bbox = toBBox(event);

    var elements = elementRegistry.filter(function (element) {
      return element;
    });

    self.select(elements, bbox);
  });

  eventBus.on('lasso.start', function (event) {

    var context = event.context;

    context.bbox = toBBox(event);
    visuals.create(context);
  });

  eventBus.on('lasso.move', function (event) {

    var context = event.context;

    context.bbox = toBBox(event);
    visuals.update(context);
  });

  eventBus.on('lasso.cleanup', function (event) {

    var context = event.context;

    visuals.remove(context);
  });

  // event integration

  eventBus.on('element.mousedown', 1500, function (event) {

    if ((0, _Mouse.hasSecondaryModifier)(event)) {
      self.activateLasso(event.originalEvent);

      // we've handled the event
      return true;
    }
  });
}

LassoTool.$inject = ['eventBus', 'canvas', 'dragging', 'elementRegistry', 'selection', 'toolManager'];

LassoTool.prototype.activateLasso = function (event, autoActivate) {

  this._dragging.init(event, 'lasso', {
    autoActivate: autoActivate,
    cursor: LASSO_TOOL_CURSOR,
    data: {
      context: {}
    }
  });
};

LassoTool.prototype.activateSelection = function (event) {

  this._dragging.init(event, 'lasso.selection', {
    trapClick: false,
    cursor: LASSO_TOOL_CURSOR,
    data: {
      context: {}
    }
  });
};

LassoTool.prototype.select = function (elements, bbox) {
  var selectedElements = (0, _Elements.getEnclosedElements)(elements, bbox);

  this._selection.select((0, _minDash.values)(selectedElements));
};

LassoTool.prototype.toggle = function () {
  if (this.isActive()) {
    this._dragging.cancel();
  } else {
    this.activateSelection();
  }
};

LassoTool.prototype.isActive = function () {
  var context = this._dragging.context();

  return context && /^lasso/.test(context.prefix);
};

function toBBox(event) {

  var start = {

    x: event.x - event.dx,
    y: event.y - event.dy
  };

  var end = {
    x: event.x,
    y: event.y
  };

  var bbox;

  if (start.x <= end.x && start.y < end.y || start.x < end.x && start.y <= end.y) {

    bbox = {
      x: start.x,
      y: start.y,
      width: end.x - start.x,
      height: end.y - start.y
    };
  } else if (start.x >= end.x && start.y < end.y || start.x > end.x && start.y <= end.y) {

    bbox = {
      x: end.x,
      y: start.y,
      width: start.x - end.x,
      height: end.y - start.y
    };
  } else if (start.x <= end.x && start.y > end.y || start.x < end.x && start.y >= end.y) {

    bbox = {
      x: start.x,
      y: end.y,
      width: end.x - start.x,
      height: start.y - end.y
    };
  } else if (start.x >= end.x && start.y > end.y || start.x > end.x && start.y >= end.y) {

    bbox = {
      x: end.x,
      y: end.y,
      width: start.x - end.x,
      height: start.y - end.y
    };
  } else {

    bbox = {
      x: end.x,
      y: end.y,
      width: 0,
      height: 0
    };
  }
  return bbox;
}

},{"235":235,"243":243,"254":254,"275":275}],149:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _toolManager = _dereq_(218);

var _toolManager2 = _interopRequireDefault(_toolManager);

var _LassoTool = _dereq_(148);

var _LassoTool2 = _interopRequireDefault(_LassoTool);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_toolManager2.default],
  __init__: ['lassoTool'],
  lassoTool: ['type', _LassoTool2.default]
};

},{"148":148,"218":218}],150:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = Modeling;

var _minDash = _dereq_(254);

var _model = _dereq_(223);

var _AppendShapeHandler = _dereq_(152);

var _AppendShapeHandler2 = _interopRequireDefault(_AppendShapeHandler);

var _CreateShapeHandler = _dereq_(155);

var _CreateShapeHandler2 = _interopRequireDefault(_CreateShapeHandler);

var _DeleteShapeHandler = _dereq_(158);

var _DeleteShapeHandler2 = _interopRequireDefault(_DeleteShapeHandler);

var _MoveShapeHandler = _dereq_(163);

var _MoveShapeHandler2 = _interopRequireDefault(_MoveShapeHandler);

var _ResizeShapeHandler = _dereq_(167);

var _ResizeShapeHandler2 = _interopRequireDefault(_ResizeShapeHandler);

var _ReplaceShapeHandler = _dereq_(166);

var _ReplaceShapeHandler2 = _interopRequireDefault(_ReplaceShapeHandler);

var _ToggleShapeCollapseHandler = _dereq_(169);

var _ToggleShapeCollapseHandler2 = _interopRequireDefault(_ToggleShapeCollapseHandler);

var _SpaceToolHandler = _dereq_(168);

var _SpaceToolHandler2 = _interopRequireDefault(_SpaceToolHandler);

var _CreateLabelHandler = _dereq_(154);

var _CreateLabelHandler2 = _interopRequireDefault(_CreateLabelHandler);

var _CreateConnectionHandler = _dereq_(153);

var _CreateConnectionHandler2 = _interopRequireDefault(_CreateConnectionHandler);

var _DeleteConnectionHandler = _dereq_(156);

var _DeleteConnectionHandler2 = _interopRequireDefault(_DeleteConnectionHandler);

var _MoveConnectionHandler = _dereq_(161);

var _MoveConnectionHandler2 = _interopRequireDefault(_MoveConnectionHandler);

var _LayoutConnectionHandler = _dereq_(160);

var _LayoutConnectionHandler2 = _interopRequireDefault(_LayoutConnectionHandler);

var _UpdateWaypointsHandler = _dereq_(171);

var _UpdateWaypointsHandler2 = _interopRequireDefault(_UpdateWaypointsHandler);

var _ReconnectConnectionHandler = _dereq_(165);

var _ReconnectConnectionHandler2 = _interopRequireDefault(_ReconnectConnectionHandler);

var _MoveElementsHandler = _dereq_(162);

var _MoveElementsHandler2 = _interopRequireDefault(_MoveElementsHandler);

var _DeleteElementsHandler = _dereq_(157);

var _DeleteElementsHandler2 = _interopRequireDefault(_DeleteElementsHandler);

var _DistributeElementsHandler = _dereq_(159);

var _DistributeElementsHandler2 = _interopRequireDefault(_DistributeElementsHandler);

var _AlignElementsHandler = _dereq_(151);

var _AlignElementsHandler2 = _interopRequireDefault(_AlignElementsHandler);

var _UpdateAttachmentHandler = _dereq_(170);

var _UpdateAttachmentHandler2 = _interopRequireDefault(_UpdateAttachmentHandler);

var _PasteHandler = _dereq_(164);

var _PasteHandler2 = _interopRequireDefault(_PasteHandler);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The basic modeling entry point.
 *
 * @param {EventBus} eventBus
 * @param {ElementFactory} elementFactory
 * @param {CommandStack} commandStack
 */
function Modeling(eventBus, elementFactory, commandStack) {
  this._eventBus = eventBus;
  this._elementFactory = elementFactory;
  this._commandStack = commandStack;

  var self = this;

  eventBus.on('diagram.init', function () {
    // register modeling handlers
    self.registerHandlers(commandStack);
  });
}

Modeling.$inject = ['eventBus', 'elementFactory', 'commandStack'];

Modeling.prototype.getHandlers = function () {
  return {
    'shape.append': _AppendShapeHandler2.default,
    'shape.create': _CreateShapeHandler2.default,
    'shape.delete': _DeleteShapeHandler2.default,
    'shape.move': _MoveShapeHandler2.default,
    'shape.resize': _ResizeShapeHandler2.default,
    'shape.replace': _ReplaceShapeHandler2.default,
    'shape.toggleCollapse': _ToggleShapeCollapseHandler2.default,

    'spaceTool': _SpaceToolHandler2.default,

    'label.create': _CreateLabelHandler2.default,

    'connection.create': _CreateConnectionHandler2.default,
    'connection.delete': _DeleteConnectionHandler2.default,
    'connection.move': _MoveConnectionHandler2.default,
    'connection.layout': _LayoutConnectionHandler2.default,

    'connection.updateWaypoints': _UpdateWaypointsHandler2.default,

    'connection.reconnectStart': _ReconnectConnectionHandler2.default,
    'connection.reconnectEnd': _ReconnectConnectionHandler2.default,

    'elements.move': _MoveElementsHandler2.default,
    'elements.delete': _DeleteElementsHandler2.default,

    'elements.distribute': _DistributeElementsHandler2.default,
    'elements.align': _AlignElementsHandler2.default,

    'element.updateAttachment': _UpdateAttachmentHandler2.default,

    'elements.paste': _PasteHandler2.default
  };
};

/**
 * Register handlers with the command stack
 *
 * @param {CommandStack} commandStack
 */
Modeling.prototype.registerHandlers = function (commandStack) {
  (0, _minDash.forEach)(this.getHandlers(), function (handler, id) {
    commandStack.registerHandler(id, handler);
  });
};

// modeling helpers //////////////////////

Modeling.prototype.moveShape = function (shape, delta, newParent, newParentIndex, hints) {

  if ((typeof newParentIndex === 'undefined' ? 'undefined' : _typeof(newParentIndex)) === 'object') {
    hints = newParentIndex;
    newParentIndex = null;
  }

  var context = {
    shape: shape,
    delta: delta,
    newParent: newParent,
    newParentIndex: newParentIndex,
    hints: hints || {}
  };

  this._commandStack.execute('shape.move', context);
};

/**
 * Update the attachment of the given shape.
 *
 * @param {djs.mode.Base} shape
 * @param {djs.model.Base} [newHost]
 */
Modeling.prototype.updateAttachment = function (shape, newHost) {
  var context = {
    shape: shape,
    newHost: newHost
  };

  this._commandStack.execute('element.updateAttachment', context);
};

/**
 * Move a number of shapes to a new target, either setting it as
 * the new parent or attaching it.
 *
 * @param {Array<djs.mode.Base>} shapes
 * @param {Point} delta
 * @param {djs.model.Base} [target]
 * @param {Object} [hints]
 * @param {Boolean} [hints.attach=false]
 */
Modeling.prototype.moveElements = function (shapes, delta, target, hints) {

  hints = hints || {};

  var attach = hints.attach;

  var newParent = target,
      newHost;

  if (attach === true) {
    newHost = target;
    newParent = target.parent;
  } else if (attach === false) {
    newHost = null;
  }

  var context = {
    shapes: shapes,
    delta: delta,
    newParent: newParent,
    newHost: newHost,
    hints: hints
  };

  this._commandStack.execute('elements.move', context);
};

Modeling.prototype.moveConnection = function (connection, delta, newParent, newParentIndex, hints) {

  if ((typeof newParentIndex === 'undefined' ? 'undefined' : _typeof(newParentIndex)) === 'object') {
    hints = newParentIndex;
    newParentIndex = undefined;
  }

  var context = {
    connection: connection,
    delta: delta,
    newParent: newParent,
    newParentIndex: newParentIndex,
    hints: hints || {}
  };

  this._commandStack.execute('connection.move', context);
};

Modeling.prototype.layoutConnection = function (connection, hints) {
  var context = {
    connection: connection,
    hints: hints || {}
  };

  this._commandStack.execute('connection.layout', context);
};

/**
 * Create connection.
 *
 * @param {djs.model.Base} source
 * @param {djs.model.Base} target
 * @param {Number} [targetIndex]
 * @param {Object|djs.model.Connection} connection
 * @param {djs.model.Base} parent
 * @param {Object} hints
 *
 * @return {djs.model.Connection} the created connection.
 */
Modeling.prototype.createConnection = function (source, target, parentIndex, connection, parent, hints) {

  if ((typeof parentIndex === 'undefined' ? 'undefined' : _typeof(parentIndex)) === 'object') {
    hints = parent;
    parent = connection;
    connection = parentIndex;
    parentIndex = undefined;
  }

  connection = this._create('connection', connection);

  var context = {
    source: source,
    target: target,
    parent: parent,
    parentIndex: parentIndex,
    connection: connection,
    hints: hints
  };

  this._commandStack.execute('connection.create', context);

  return context.connection;
};

/**
 * Create a shape at the specified position.
 *
 * @param {djs.model.Shape|Object} shape
 * @param {Point} position
 * @param {djs.model.Shape|djs.model.Root} target
 * @param {Number} [parentIndex] position in parents children list
 * @param {Object} [hints]
 * @param {Boolean} [hints.attach] whether to attach to target or become a child
 *
 * @return {djs.model.Shape} the created shape
 */
Modeling.prototype.createShape = function (shape, position, target, parentIndex, hints) {

  if (typeof parentIndex !== 'number') {
    hints = parentIndex;
    parentIndex = undefined;
  }

  hints = hints || {};

  var attach = hints.attach,
      parent,
      host;

  shape = this._create('shape', shape);

  if (attach) {
    parent = target.parent;
    host = target;
  } else {
    parent = target;
  }

  var context = {
    position: position,
    shape: shape,
    parent: parent,
    parentIndex: parentIndex,
    host: host,
    hints: hints
  };

  this._commandStack.execute('shape.create', context);

  return context.shape;
};

Modeling.prototype.createLabel = function (labelTarget, position, label, parent) {

  label = this._create('label', label);

  var context = {
    labelTarget: labelTarget,
    position: position,
    parent: parent || labelTarget.parent,
    shape: label
  };

  this._commandStack.execute('label.create', context);

  return context.shape;
};

/**
 * Append shape to given source, drawing a connection
 * between source and the newly created shape.
 *
 * @param {djs.model.Shape} source
 * @param {djs.model.Shape|Object} shape
 * @param {Point} position
 * @param {djs.model.Shape} target
 * @param {Object} [hints]
 * @param {Boolean} [hints.attach]
 * @param {djs.model.Connection|Object} [hints.connection]
 * @param {djs.model.Base} [hints.connectionParent]
 *
 * @return {djs.model.Shape} the newly created shape
 */
Modeling.prototype.appendShape = function (source, shape, position, target, hints) {

  hints = hints || {};

  shape = this._create('shape', shape);

  var context = {
    source: source,
    position: position,
    target: target,
    shape: shape,
    connection: hints.connection,
    connectionParent: hints.connectionParent,
    attach: hints.attach
  };

  this._commandStack.execute('shape.append', context);

  return context.shape;
};

Modeling.prototype.removeElements = function (elements) {
  var context = {
    elements: elements
  };

  this._commandStack.execute('elements.delete', context);
};

Modeling.prototype.distributeElements = function (groups, axis, dimension) {
  var context = {
    groups: groups,
    axis: axis,
    dimension: dimension
  };

  this._commandStack.execute('elements.distribute', context);
};

Modeling.prototype.removeShape = function (shape, hints) {
  var context = {
    shape: shape,
    hints: hints || {}
  };

  this._commandStack.execute('shape.delete', context);
};

Modeling.prototype.removeConnection = function (connection, hints) {
  var context = {
    connection: connection,
    hints: hints || {}
  };

  this._commandStack.execute('connection.delete', context);
};

Modeling.prototype.replaceShape = function (oldShape, newShape, hints) {
  var context = {
    oldShape: oldShape,
    newData: newShape,
    hints: hints || {}
  };

  this._commandStack.execute('shape.replace', context);

  return context.newShape;
};

Modeling.prototype.pasteElements = function (tree, topParent, position) {
  var context = {
    tree: tree,
    topParent: topParent,
    position: position
  };

  this._commandStack.execute('elements.paste', context);
};

Modeling.prototype.alignElements = function (elements, alignment) {
  var context = {
    elements: elements,
    alignment: alignment
  };

  this._commandStack.execute('elements.align', context);
};

Modeling.prototype.resizeShape = function (shape, newBounds, minBounds, hints) {
  var context = {
    shape: shape,
    newBounds: newBounds,
    minBounds: minBounds,
    hints: hints
  };

  this._commandStack.execute('shape.resize', context);
};

Modeling.prototype.createSpace = function (movingShapes, resizingShapes, delta, direction) {
  var context = {
    movingShapes: movingShapes,
    resizingShapes: resizingShapes,
    delta: delta,
    direction: direction
  };

  this._commandStack.execute('spaceTool', context);
};

Modeling.prototype.updateWaypoints = function (connection, newWaypoints, hints) {
  var context = {
    connection: connection,
    newWaypoints: newWaypoints,
    hints: hints || {}
  };

  this._commandStack.execute('connection.updateWaypoints', context);
};

Modeling.prototype.reconnectStart = function (connection, newSource, dockingOrPoints, hints) {
  var context = {
    connection: connection,
    newSource: newSource,
    dockingOrPoints: dockingOrPoints,
    hints: hints || {}
  };

  this._commandStack.execute('connection.reconnectStart', context);
};

Modeling.prototype.reconnectEnd = function (connection, newTarget, dockingOrPoints, hints) {
  var context = {
    connection: connection,
    newTarget: newTarget,
    dockingOrPoints: dockingOrPoints,
    hints: hints || {}
  };

  this._commandStack.execute('connection.reconnectEnd', context);
};

Modeling.prototype.connect = function (source, target, attrs, hints) {
  return this.createConnection(source, target, attrs || {}, source.parent, hints);
};

Modeling.prototype._create = function (type, attrs) {
  if (attrs instanceof _model.Base) {
    return attrs;
  } else {
    return this._elementFactory.create(type, attrs);
  }
};

Modeling.prototype.toggleCollapse = function (shape, hints) {
  var context = {
    shape: shape,
    hints: hints || {}
  };

  this._commandStack.execute('shape.toggleCollapse', context);
};

},{"151":151,"152":152,"153":153,"154":154,"155":155,"156":156,"157":157,"158":158,"159":159,"160":160,"161":161,"162":162,"163":163,"164":164,"165":165,"166":166,"167":167,"168":168,"169":169,"170":170,"171":171,"223":223,"254":254}],151:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AlignElements;

var _minDash = _dereq_(254);

/**
 * A handler that align elements in a certain way.
 *
 */
function AlignElements(modeling, canvas) {
  this._modeling = modeling;
  this._canvas = canvas;
}

AlignElements.$inject = ['modeling', 'canvas'];

AlignElements.prototype.preExecute = function (context) {
  var modeling = this._modeling;

  var elements = context.elements,
      alignment = context.alignment;

  (0, _minDash.forEach)(elements, function (element) {
    var delta = {
      x: 0,
      y: 0
    };

    if (alignment.left) {
      delta.x = alignment.left - element.x;
    } else if (alignment.right) {
      delta.x = alignment.right - element.width - element.x;
    } else if (alignment.center) {
      delta.x = alignment.center - Math.round(element.width / 2) - element.x;
    } else if (alignment.top) {
      delta.y = alignment.top - element.y;
    } else if (alignment.bottom) {
      delta.y = alignment.bottom - element.height - element.y;
    } else if (alignment.middle) {
      delta.y = alignment.middle - Math.round(element.height / 2) - element.y;
    }

    modeling.moveElements([element], delta, element.parent);
  });
};

AlignElements.prototype.postExecute = function (context) {};

},{"254":254}],152:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AppendShapeHandler;

var _minDash = _dereq_(254);

/**
 * A handler that implements reversible appending of shapes
 * to a source shape.
 *
 * @param {canvas} Canvas
 * @param {elementFactory} ElementFactory
 * @param {modeling} Modeling
 */
function AppendShapeHandler(modeling) {
  this._modeling = modeling;
}

AppendShapeHandler.$inject = ['modeling'];

// api //////////////////////


/**
 * Creates a new shape
 *
 * @param {Object} context
 * @param {ElementDescriptor} context.shape the new shape
 * @param {ElementDescriptor} context.source the source object
 * @param {ElementDescriptor} context.parent the parent object
 * @param {Point} context.position position of the new element
 */
AppendShapeHandler.prototype.preExecute = function (context) {

  var source = context.source;

  if (!source) {
    throw new Error('source required');
  }

  var target = context.target || source.parent,
      shape = context.shape;

  shape = context.shape = this._modeling.createShape(shape, context.position, target, { attach: context.attach });

  context.shape = shape;
};

AppendShapeHandler.prototype.postExecute = function (context) {
  var parent = context.connectionParent || context.shape.parent;

  if (!existsConnection(context.source, context.shape)) {

    // create connection
    this._modeling.connect(context.source, context.shape, context.connection, parent);
  }
};

function existsConnection(source, target) {
  return (0, _minDash.some)(source.outgoing, function (c) {
    return c.target === target;
  });
}

},{"254":254}],153:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CreateConnectionHandler;
function CreateConnectionHandler(canvas, layouter) {
  this._canvas = canvas;
  this._layouter = layouter;
}

CreateConnectionHandler.$inject = ['canvas', 'layouter'];

// api //////////////////////


/**
 * Appends a shape to a target shape
 *
 * @param {Object} context
 * @param {djs.element.Base} context.source the source object
 * @param {djs.element.Base} context.target the parent object
 * @param {Point} context.position position of the new element
 */
CreateConnectionHandler.prototype.execute = function (context) {

  var connection = context.connection,
      source = context.source,
      target = context.target,
      parent = context.parent,
      parentIndex = context.parentIndex,
      hints = context.hints;

  if (!source || !target) {
    throw new Error('source and target required');
  }

  if (!parent) {
    throw new Error('parent required');
  }

  connection.source = source;
  connection.target = target;

  if (!connection.waypoints) {
    connection.waypoints = this._layouter.layoutConnection(connection, hints);
  }

  // add connection
  this._canvas.addConnection(connection, parent, parentIndex);

  return connection;
};

CreateConnectionHandler.prototype.revert = function (context) {
  var connection = context.connection;

  this._canvas.removeConnection(connection);

  connection.source = null;
  connection.target = null;
};

},{}],154:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CreateLabelHandler;

var _inherits = _dereq_(253);

var _inherits2 = _interopRequireDefault(_inherits);

var _CreateShapeHandler = _dereq_(155);

var _CreateShapeHandler2 = _interopRequireDefault(_CreateShapeHandler);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A handler that attaches a label to a given target shape.
 *
 * @param {Canvas} canvas
 */
function CreateLabelHandler(canvas) {
  _CreateShapeHandler2.default.call(this, canvas);
}

(0, _inherits2.default)(CreateLabelHandler, _CreateShapeHandler2.default);

CreateLabelHandler.$inject = ['canvas'];

// api //////////////////////


var originalExecute = _CreateShapeHandler2.default.prototype.execute;

/**
 * Appends a label to a target shape.
 *
 * @method CreateLabelHandler#execute
 *
 * @param {Object} context
 * @param {ElementDescriptor} context.target the element the label is attached to
 * @param {ElementDescriptor} context.parent the parent object
 * @param {Point} context.position position of the new element
 */
CreateLabelHandler.prototype.execute = function (context) {

  var label = context.shape;

  ensureValidDimensions(label);

  label.labelTarget = context.labelTarget;

  return originalExecute.call(this, context);
};

var originalRevert = _CreateShapeHandler2.default.prototype.revert;

/**
 * Undo append by removing the shape
 */
CreateLabelHandler.prototype.revert = function (context) {
  context.shape.labelTarget = null;

  return originalRevert.call(this, context);
};

// helpers //////////////////////

function ensureValidDimensions(label) {
  // make sure a label has valid { width, height } dimensions
  ['width', 'height'].forEach(function (prop) {
    if (typeof label[prop] === 'undefined') {
      label[prop] = 0;
    }
  });
}

},{"155":155,"253":253}],155:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CreateShapeHandler;

var _minDash = _dereq_(254);

var round = Math.round;

/**
 * A handler that implements reversible addition of shapes.
 *
 * @param {canvas} Canvas
 */
function CreateShapeHandler(canvas) {
  this._canvas = canvas;
}

CreateShapeHandler.$inject = ['canvas'];

// api //////////////////////


/**
 * Appends a shape to a target shape
 *
 * @param {Object} context
 * @param {djs.model.Base} context.parent the parent object
 * @param {Point} context.position position of the new element
 */
CreateShapeHandler.prototype.execute = function (context) {

  var shape = context.shape,
      positionOrBounds = context.position,
      parent = context.parent,
      parentIndex = context.parentIndex;

  if (!parent) {
    throw new Error('parent required');
  }

  if (!positionOrBounds) {
    throw new Error('position required');
  }

  // (1) add at event center position _or_ at given bounds
  if (positionOrBounds.width !== undefined) {
    (0, _minDash.assign)(shape, positionOrBounds);
  } else {
    (0, _minDash.assign)(shape, {
      x: positionOrBounds.x - round(shape.width / 2),
      y: positionOrBounds.y - round(shape.height / 2)
    });
  }

  // (2) add to canvas
  this._canvas.addShape(shape, parent, parentIndex);

  return shape;
};

/**
 * Undo append by removing the shape
 */
CreateShapeHandler.prototype.revert = function (context) {

  // (3) remove form canvas
  this._canvas.removeShape(context.shape);
};

},{"254":254}],156:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DeleteConnectionHandler;

var _Collections = _dereq_(233);

/**
 * A handler that implements reversible deletion of Connections.
 */
function DeleteConnectionHandler(canvas, modeling) {
  this._canvas = canvas;
  this._modeling = modeling;
}

DeleteConnectionHandler.$inject = ['canvas', 'modeling'];

DeleteConnectionHandler.prototype.execute = function (context) {

  var connection = context.connection,
      parent = connection.parent;

  context.parent = parent;

  // remember containment
  context.parentIndex = (0, _Collections.indexOf)(parent.children, connection);

  context.source = connection.source;
  context.target = connection.target;

  this._canvas.removeConnection(connection);

  connection.source = null;
  connection.target = null;

  return connection;
};

/**
 * Command revert implementation.
 */
DeleteConnectionHandler.prototype.revert = function (context) {

  var connection = context.connection,
      parent = context.parent,
      parentIndex = context.parentIndex;

  connection.source = context.source;
  connection.target = context.target;

  // restore containment
  (0, _Collections.add)(parent.children, connection, parentIndex);

  this._canvas.addConnection(connection, parent);

  return connection;
};

},{"233":233}],157:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DeleteElementsHandler;

var _minDash = _dereq_(254);

function DeleteElementsHandler(modeling, elementRegistry) {
  this._modeling = modeling;
  this._elementRegistry = elementRegistry;
}

DeleteElementsHandler.$inject = ['modeling', 'elementRegistry'];

DeleteElementsHandler.prototype.postExecute = function (context) {

  var modeling = this._modeling,
      elementRegistry = this._elementRegistry,
      elements = context.elements;

  (0, _minDash.forEach)(elements, function (element) {

    // element may have been removed with previous
    // remove operations already (e.g. in case of nesting)
    if (!elementRegistry.get(element.id)) {
      return;
    }

    if (element.waypoints) {
      modeling.removeConnection(element);
    } else {
      modeling.removeShape(element);
    }
  });
};

},{"254":254}],158:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DeleteShapeHandler;

var _Collections = _dereq_(233);

var _Removal = _dereq_(246);

/**
 * A handler that implements reversible deletion of shapes.
 *
 */
function DeleteShapeHandler(canvas, modeling) {
  this._canvas = canvas;
  this._modeling = modeling;
}

DeleteShapeHandler.$inject = ['canvas', 'modeling'];

/**
 * - Remove connections
 * - Remove all direct children
 */
DeleteShapeHandler.prototype.preExecute = function (context) {

  var modeling = this._modeling;

  var shape = context.shape;

  // remove connections
  (0, _Removal.saveClear)(shape.incoming, function (connection) {
    // To make sure that the connection isn't removed twice
    // For example if a container is removed
    modeling.removeConnection(connection, { nested: true });
  });

  (0, _Removal.saveClear)(shape.outgoing, function (connection) {
    modeling.removeConnection(connection, { nested: true });
  });

  // remove child shapes and connections
  (0, _Removal.saveClear)(shape.children, function (child) {
    if (isConnection(child)) {
      modeling.removeConnection(child, { nested: true });
    } else {
      modeling.removeShape(child, { nested: true });
    }
  });
};

/**
 * Remove shape and remember the parent
 */
DeleteShapeHandler.prototype.execute = function (context) {
  var canvas = this._canvas;

  var shape = context.shape,
      oldParent = shape.parent;

  context.oldParent = oldParent;

  // remove containment
  context.oldParentIndex = (0, _Collections.indexOf)(oldParent.children, shape);

  // remove shape
  canvas.removeShape(shape);

  return shape;
};

/**
 * Command revert implementation
 */
DeleteShapeHandler.prototype.revert = function (context) {

  var canvas = this._canvas;

  var shape = context.shape,
      oldParent = context.oldParent,
      oldParentIndex = context.oldParentIndex;

  // restore containment
  (0, _Collections.add)(oldParent.children, shape, oldParentIndex);

  canvas.addShape(shape, oldParent);

  return shape;
};

function isConnection(element) {
  return element.waypoints;
}

},{"233":233,"246":246}],159:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DistributeElements;

var _minDash = _dereq_(254);

/**
 * A handler that distributes elements evenly.
 */
function DistributeElements(modeling) {
  this._modeling = modeling;
}

DistributeElements.$inject = ['modeling'];

var OFF_AXIS = {
  x: 'y',
  y: 'x'
};

DistributeElements.prototype.preExecute = function (context) {
  var modeling = this._modeling;

  var groups = context.groups,
      axis = context.axis,
      dimension = context.dimension;

  function updateRange(group, element) {
    group.range.min = Math.min(element[axis], group.range.min);
    group.range.max = Math.max(element[axis] + element[dimension], group.range.max);
  }

  function center(element) {
    return element[axis] + element[dimension] / 2;
  }

  function lastIdx(arr) {
    return arr.length - 1;
  }

  function rangeDiff(range) {
    return range.max - range.min;
  }

  function centerElement(refCenter, element) {
    var delta = { y: 0 };

    delta[axis] = refCenter - center(element);

    if (delta[axis]) {

      delta[OFF_AXIS[axis]] = 0;

      modeling.moveElements([element], delta, element.parent);
    }
  }

  var firstGroup = groups[0],
      lastGroupIdx = lastIdx(groups),
      lastGroup = groups[lastGroupIdx];

  var margin,
      spaceInBetween,
      groupsSize = 0; // the size of each range

  (0, _minDash.forEach)(groups, function (group, idx) {
    var sortedElements, refElem, refCenter;

    if (group.elements.length < 2) {
      if (idx && idx !== groups.length - 1) {
        updateRange(group, group.elements[0]);

        groupsSize += rangeDiff(group.range);
      }
      return;
    }

    sortedElements = (0, _minDash.sortBy)(group.elements, axis);

    refElem = sortedElements[0];

    if (idx === lastGroupIdx) {
      refElem = sortedElements[lastIdx(sortedElements)];
    }

    refCenter = center(refElem);

    // wanna update the ranges after the shapes have been centered
    group.range = null;

    (0, _minDash.forEach)(sortedElements, function (element) {

      centerElement(refCenter, element);

      if (group.range === null) {
        group.range = {
          min: element[axis],
          max: element[axis] + element[dimension]
        };

        return;
      }

      // update group's range after centering the range elements
      updateRange(group, element);
    });

    if (idx && idx !== groups.length - 1) {
      groupsSize += rangeDiff(group.range);
    }
  });

  spaceInBetween = Math.abs(lastGroup.range.min - firstGroup.range.max);

  margin = Math.round((spaceInBetween - groupsSize) / (groups.length - 1));

  if (margin < groups.length - 1) {
    return;
  }

  (0, _minDash.forEach)(groups, function (group, groupIdx) {
    var delta = {},
        prevGroup;

    if (group === firstGroup || group === lastGroup) {
      return;
    }

    prevGroup = groups[groupIdx - 1];

    group.range.max = 0;

    (0, _minDash.forEach)(group.elements, function (element, idx) {
      delta[OFF_AXIS[axis]] = 0;
      delta[axis] = prevGroup.range.max - element[axis] + margin;

      if (group.range.min !== element[axis]) {
        delta[axis] += element[axis] - group.range.min;
      }

      if (delta[axis]) {
        modeling.moveElements([element], delta, element.parent);
      }

      group.range.max = Math.max(element[axis] + element[dimension], idx ? group.range.max : 0);
    });
  });
};

DistributeElements.prototype.postExecute = function (context) {};

},{"254":254}],160:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = LayoutConnectionHandler;

var _minDash = _dereq_(254);

/**
 * A handler that implements reversible moving of shapes.
 */
function LayoutConnectionHandler(layouter, canvas) {
  this._layouter = layouter;
  this._canvas = canvas;
}

LayoutConnectionHandler.$inject = ['layouter', 'canvas'];

LayoutConnectionHandler.prototype.execute = function (context) {

  var connection = context.connection;

  var oldWaypoints = connection.waypoints;

  (0, _minDash.assign)(context, {
    oldWaypoints: oldWaypoints
  });

  connection.waypoints = this._layouter.layoutConnection(connection, context.hints);

  return connection;
};

LayoutConnectionHandler.prototype.revert = function (context) {

  var connection = context.connection;

  connection.waypoints = context.oldWaypoints;

  return connection;
};

},{"254":254}],161:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MoveConnectionHandler;

var _minDash = _dereq_(254);

var _Collections = _dereq_(233);

/**
 * A handler that implements reversible moving of connections.
 *
 * The handler differs from the layout connection handler in a sense
 * that it preserves the connection layout.
 */
function MoveConnectionHandler() {}

MoveConnectionHandler.prototype.execute = function (context) {

  var connection = context.connection,
      delta = context.delta;

  var newParent = context.newParent || connection.parent,
      newParentIndex = context.newParentIndex,
      oldParent = connection.parent;

  // save old parent in context
  context.oldParent = oldParent;
  context.oldParentIndex = (0, _Collections.remove)(oldParent.children, connection);

  // add to new parent at position
  (0, _Collections.add)(newParent.children, connection, newParentIndex);

  // update parent
  connection.parent = newParent;

  // update waypoint positions
  (0, _minDash.forEach)(connection.waypoints, function (p) {
    p.x += delta.x;
    p.y += delta.y;

    if (p.original) {
      p.original.x += delta.x;
      p.original.y += delta.y;
    }
  });

  return connection;
};

MoveConnectionHandler.prototype.revert = function (context) {

  var connection = context.connection,
      newParent = connection.parent,
      oldParent = context.oldParent,
      oldParentIndex = context.oldParentIndex,
      delta = context.delta;

  // remove from newParent
  (0, _Collections.remove)(newParent.children, connection);

  // restore previous location in old parent
  (0, _Collections.add)(oldParent.children, connection, oldParentIndex);

  // restore parent
  connection.parent = oldParent;

  // revert to old waypoint positions
  (0, _minDash.forEach)(connection.waypoints, function (p) {
    p.x -= delta.x;
    p.y -= delta.y;

    if (p.original) {
      p.original.x -= delta.x;
      p.original.y -= delta.y;
    }
  });

  return connection;
};

},{"233":233,"254":254}],162:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MoveElementsHandler;

var _MoveHelper = _dereq_(174);

var _MoveHelper2 = _interopRequireDefault(_MoveHelper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A handler that implements reversible moving of shapes.
 */
function MoveElementsHandler(modeling) {
  this._helper = new _MoveHelper2.default(modeling);
}

MoveElementsHandler.$inject = ['modeling'];

MoveElementsHandler.prototype.preExecute = function (context) {
  context.closure = this._helper.getClosure(context.shapes);
};

MoveElementsHandler.prototype.postExecute = function (context) {

  var hints = context.hints,
      primaryShape;

  if (hints && hints.primaryShape) {
    primaryShape = hints.primaryShape;
    hints.oldParent = primaryShape.parent;
  }

  this._helper.moveClosure(context.closure, context.delta, context.newParent, context.newHost, primaryShape);
};

},{"174":174}],163:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MoveShapeHandler;

var _minDash = _dereq_(254);

var _MoveHelper = _dereq_(174);

var _MoveHelper2 = _interopRequireDefault(_MoveHelper);

var _Collections = _dereq_(233);

var _AnchorsHelper = _dereq_(172);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A handler that implements reversible moving of shapes.
 */
function MoveShapeHandler(modeling) {
  this._modeling = modeling;

  this._helper = new _MoveHelper2.default(modeling);
}

MoveShapeHandler.$inject = ['modeling'];

MoveShapeHandler.prototype.execute = function (context) {

  var shape = context.shape,
      delta = context.delta,
      newParent = context.newParent || shape.parent,
      newParentIndex = context.newParentIndex,
      oldParent = shape.parent;

  context.oldBounds = (0, _minDash.pick)(shape, ['x', 'y', 'width', 'height']);

  // save old parent in context
  context.oldParent = oldParent;
  context.oldParentIndex = (0, _Collections.remove)(oldParent.children, shape);

  // add to new parent at position
  (0, _Collections.add)(newParent.children, shape, newParentIndex);

  // update shape parent + position
  (0, _minDash.assign)(shape, {
    parent: newParent,
    x: shape.x + delta.x,
    y: shape.y + delta.y
  });

  return shape;
};

MoveShapeHandler.prototype.postExecute = function (context) {

  var shape = context.shape,
      delta = context.delta,
      hints = context.hints;

  var modeling = this._modeling;

  if (hints.layout !== false) {

    (0, _minDash.forEach)(shape.incoming, function (c) {
      modeling.layoutConnection(c, {
        connectionEnd: (0, _AnchorsHelper.getMovedTargetAnchor)(c, shape, delta)
      });
    });

    (0, _minDash.forEach)(shape.outgoing, function (c) {
      modeling.layoutConnection(c, {
        connectionStart: (0, _AnchorsHelper.getMovedSourceAnchor)(c, shape, delta)
      });
    });
  }

  if (hints.recurse !== false) {
    this.moveChildren(context);
  }
};

MoveShapeHandler.prototype.revert = function (context) {

  var shape = context.shape,
      oldParent = context.oldParent,
      oldParentIndex = context.oldParentIndex,
      delta = context.delta;

  // restore previous location in old parent
  (0, _Collections.add)(oldParent.children, shape, oldParentIndex);

  // revert to old position and parent
  (0, _minDash.assign)(shape, {
    parent: oldParent,
    x: shape.x - delta.x,
    y: shape.y - delta.y
  });

  return shape;
};

MoveShapeHandler.prototype.moveChildren = function (context) {

  var delta = context.delta,
      shape = context.shape;

  this._helper.moveRecursive(shape.children, delta, null);
};

MoveShapeHandler.prototype.getNewParent = function (context) {
  return context.newParent || context.shape.parent;
};

},{"172":172,"174":174,"233":233,"254":254}],164:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PasteHandler;

var _minDash = _dereq_(254);

function removeProperties(element, properties) {
  (0, _minDash.forEach)(properties, function (prop) {
    if (element[prop]) {
      delete element[prop];
    }
  });
}

/**
 * A handler that implements pasting of elements onto the diagram.
 *
 * @param {eventBus} EventBus
 * @param {canvas} Canvas
 * @param {selection} Selection
 * @param {elementFactory} ElementFactory
 * @param {modeling} Modeling
 * @param {rules} Rules
 */
function PasteHandler(eventBus, canvas, selection, elementFactory, modeling, rules) {

  this._eventBus = eventBus;
  this._canvas = canvas;
  this._selection = selection;
  this._elementFactory = elementFactory;
  this._modeling = modeling;
  this._rules = rules;
}

PasteHandler.$inject = ['eventBus', 'canvas', 'selection', 'elementFactory', 'modeling', 'rules'];

// api //////////////////////

/**
 * Creates a new shape
 *
 * @param {Object} context
 * @param {Object} context.tree the new shape
 * @param {Element} context.topParent the paste target
 */
PasteHandler.prototype.preExecute = function (context) {
  var eventBus = this._eventBus,
      self = this;

  var tree = context.tree,
      topParent = context.topParent,
      position = context.position;

  tree.createdElements = {};

  tree.labels = [];

  (0, _minDash.forEach)(tree, function (elements, depthStr) {
    var depth = parseInt(depthStr, 10);

    if (isNaN(depth)) {
      return;
    }

    // set the parent on the top level elements
    if (!depth) {
      elements = (0, _minDash.map)(elements, function (descriptor) {
        descriptor.parent = topParent;

        return descriptor;
      });
    }

    // Order by priority for element creation
    elements = (0, _minDash.sortBy)(elements, 'priority');

    (0, _minDash.forEach)(elements, function (descriptor) {
      var id = descriptor.id,
          parent = descriptor.parent,
          hints = {},
          newPosition;

      var element = (0, _minDash.assign)({}, descriptor);

      if (depth) {
        element.parent = self._getCreatedElement(parent, tree);
      }

      // this happens when shapes have not been created due to rules
      if (!parent) {
        return;
      }

      eventBus.fire('element.paste', {
        createdElements: tree.createdElements,
        descriptor: element
      });

      // in case the parent changed during 'element.paste'
      parent = element.parent;

      if (element.waypoints) {
        element = self._createConnection(element, parent, position, tree);

        if (element) {
          tree.createdElements[id] = {
            element: element,
            descriptor: descriptor
          };
        }

        return;
      }

      // supply not-root information as hint
      if (element.parent !== topParent) {
        hints.root = false;
      }

      // set host
      if (element.host) {
        hints.attach = true;

        parent = self._getCreatedElement(element.host, tree);
      }

      // handle labels
      if (element.labelTarget) {
        return tree.labels.push(element);
      }

      newPosition = {
        x: Math.round(position.x + element.delta.x + element.width / 2),
        y: Math.round(position.y + element.delta.y + element.height / 2)
      };

      removeProperties(element, ['id', 'parent', 'delta', 'host', 'priority']);

      element = self._createShape(element, parent, newPosition, hints);

      if (element) {
        tree.createdElements[id] = {
          element: element,
          descriptor: descriptor
        };
      }
    });
  });
};

// move label's to their relative position
PasteHandler.prototype.postExecute = function (context) {
  var modeling = this._modeling,
      selection = this._selection,
      self = this;

  var tree = context.tree,
      labels = tree.labels,
      topLevelElements = [];

  (0, _minDash.forEach)(labels, function (labelDescriptor) {
    var labelTarget = self._getCreatedElement(labelDescriptor.labelTarget, tree),
        labels,
        labelTargetPos,
        newPosition;

    if (!labelTarget) {
      return;
    }

    labels = labelTarget.labels;

    if (!labels || !labels.length) {
      return;
    }

    labelTargetPos = {
      x: labelTarget.x,
      y: labelTarget.y
    };

    if (labelTarget.waypoints) {
      labelTargetPos = labelTarget.waypoints[0];
    }

    (0, _minDash.forEach)(labels, function (label) {
      newPosition = {
        x: Math.round(labelTargetPos.x - label.x + labelDescriptor.delta.x),
        y: Math.round(labelTargetPos.y - label.y + labelDescriptor.delta.y)
      };

      modeling.moveShape(label, newPosition, labelTarget.parent);
    });
  });

  (0, _minDash.forEach)(tree[0], function (descriptor) {
    var id = descriptor.id,
        toplevel = tree.createdElements[id];

    if (toplevel) {
      topLevelElements.push(toplevel.element);
    }
  });

  selection.select(topLevelElements);
};

PasteHandler.prototype._createConnection = function (element, parent, parentCenter, tree) {
  var modeling = this._modeling,
      rules = this._rules;

  var connection, source, target, canPaste;

  element.waypoints = (0, _minDash.map)(element.waypoints, function (waypoint, idx) {
    return {
      x: Math.round(parentCenter.x + element.delta[idx].x),
      y: Math.round(parentCenter.y + element.delta[idx].y)
    };
  });

  source = this._getCreatedElement(element.source, tree);
  target = this._getCreatedElement(element.target, tree);

  if (!source || !target) {
    return null;
  }

  canPaste = rules.allowed('element.paste', {
    source: source,
    target: target
  });

  if (!canPaste) {
    return null;
  }

  removeProperties(element, ['id', 'parent', 'delta', 'source', 'target', 'width', 'height', 'priority']);

  connection = modeling.createConnection(source, target, element, parent);

  return connection;
};

PasteHandler.prototype._createShape = function (element, parent, position, isAttach, hints) {
  var modeling = this._modeling,
      elementFactory = this._elementFactory,
      rules = this._rules;

  var canPaste = rules.allowed('element.paste', {
    element: element,
    position: position,
    parent: parent
  });

  if (!canPaste) {
    return null;
  }

  var shape = elementFactory.createShape(element);

  modeling.createShape(shape, position, parent, isAttach, hints);

  return shape;
};

PasteHandler.prototype._getCreatedElement = function (id, tree) {
  return tree.createdElements[id] && tree.createdElements[id].element;
};

},{"254":254}],165:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ReconnectConnectionHandler;

var _minDash = _dereq_(254);

/**
 * Reconnect connection handler
 */
function ReconnectConnectionHandler(modeling) {
  this._modeling = modeling;
}

ReconnectConnectionHandler.$inject = ['modeling'];

ReconnectConnectionHandler.prototype.execute = function (context) {

  var newSource = context.newSource,
      newTarget = context.newTarget,
      connection = context.connection,
      dockingOrPoints = context.dockingOrPoints;

  if (!newSource && !newTarget) {
    throw new Error('newSource or newTarget are required');
  }

  if (newSource && newTarget) {
    throw new Error('must specify either newSource or newTarget');
  }

  if ((0, _minDash.isArray)(dockingOrPoints)) {
    context.oldWaypoints = connection.waypoints;
    connection.waypoints = dockingOrPoints;
  }

  if (newSource) {
    context.oldSource = connection.source;
    connection.source = newSource;
  }

  if (newTarget) {
    context.oldTarget = connection.target;
    connection.target = newTarget;
  }

  return connection;
};

ReconnectConnectionHandler.prototype.postExecute = function (context) {
  var connection = context.connection,
      dockingOrPoints = context.dockingOrPoints,
      newSource = context.newSource,
      movedEnd = newSource ? 'connectionStart' : 'connectionEnd',
      newWaypoint,
      hints = context.hints,
      layoutHints = {};

  if (hints.layoutConnection === false) {
    return;
  }

  if ((0, _minDash.isArray)(dockingOrPoints)) {
    newWaypoint = newSource ? dockingOrPoints[0] : dockingOrPoints[dockingOrPoints.length - 1];
  } else {
    newWaypoint = dockingOrPoints;
  }

  layoutHints[movedEnd] = getDocking(newWaypoint);

  this._modeling.layoutConnection(connection, layoutHints);
};

ReconnectConnectionHandler.prototype.revert = function (context) {

  var oldSource = context.oldSource,
      oldTarget = context.oldTarget,
      oldWaypoints = context.oldWaypoints,
      connection = context.connection;

  if (oldSource) {
    connection.source = oldSource;
  }

  if (oldTarget) {
    connection.target = oldTarget;
  }

  if (oldWaypoints) {
    connection.waypoints = oldWaypoints;
  }

  return connection;
};

// helper ///////////////

function getDocking(point) {
  return point.original || point;
}

},{"254":254}],166:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ReplaceShapeHandler;

var _minDash = _dereq_(254);

/**
 * A handler that implements reversible replacing of shapes.
 * Internally the old shape will be removed and the new shape will be added.
 *
 *
 * @class
 * @constructor
 *
 * @param {canvas} Canvas
 */
function ReplaceShapeHandler(modeling, rules) {
  this._modeling = modeling;
  this._rules = rules;
}

ReplaceShapeHandler.$inject = ['modeling', 'rules'];

// api //////////////////////


/**
 * Replaces a shape with an replacement Element.
 *
 * The newData object should contain type, x, y.
 *
 * If possible also the incoming/outgoing connection
 * will be restored.
 *
 * @param {Object} context
 */
ReplaceShapeHandler.prototype.preExecute = function (context) {

  var self = this,
      modeling = this._modeling,
      rules = this._rules;

  var oldShape = context.oldShape,
      newData = context.newData,
      hints = context.hints,
      newShape;

  function canReconnect(type, source, target, connection) {
    return rules.allowed(type, {
      source: source,
      target: target,
      connection: connection
    });
  }

  // (1) place a new shape at the given position

  var position = {
    x: newData.x,
    y: newData.y
  };

  newShape = context.newShape = context.newShape || self.createShape(newData, position, oldShape.parent, hints);

  // (2) update the host

  if (oldShape.host) {
    modeling.updateAttachment(newShape, oldShape.host);
  }

  // (3) adopt all children from the old shape

  var children;

  if (hints.moveChildren !== false) {
    children = oldShape.children.slice();

    modeling.moveElements(children, { x: 0, y: 0 }, newShape);
  }

  // (4) reconnect connections to the new shape (where allowed)

  var incoming = oldShape.incoming.slice(),
      outgoing = oldShape.outgoing.slice();

  (0, _minDash.forEach)(incoming, function (connection) {
    var waypoints = connection.waypoints,
        docking = waypoints[waypoints.length - 1],
        source = connection.source,
        allowed = canReconnect('connection.reconnectEnd', source, newShape, connection);

    if (allowed) {
      self.reconnectEnd(connection, newShape, docking, { layoutConnection: hints.layoutConnection });
    }
  });

  (0, _minDash.forEach)(outgoing, function (connection) {
    var waypoints = connection.waypoints,
        docking = waypoints[0],
        target = connection.target,
        allowed = canReconnect('connection.reconnectStart', newShape, target, connection);

    if (allowed) {
      self.reconnectStart(connection, newShape, docking, { layoutConnection: hints.layoutConnection });
    }
  });
};

ReplaceShapeHandler.prototype.postExecute = function (context) {
  var modeling = this._modeling;

  var oldShape = context.oldShape,
      newShape = context.newShape,
      layoutConnection = context.hints.layoutConnection;

  // do not layout if explicitly excluded
  if (layoutConnection !== false) {
    (0, _minDash.forEach)(newShape.incoming, function (c) {
      modeling.layoutConnection(c, { endChanged: true });
    });

    (0, _minDash.forEach)(newShape.outgoing, function (c) {
      modeling.layoutConnection(c, { startChanged: true });
    });
  }

  modeling.removeShape(oldShape);
};

ReplaceShapeHandler.prototype.execute = function (context) {};

ReplaceShapeHandler.prototype.revert = function (context) {};

ReplaceShapeHandler.prototype.createShape = function (shape, position, target, hints) {
  return this._modeling.createShape(shape, position, target, hints);
};

ReplaceShapeHandler.prototype.reconnectStart = function (connection, newSource, dockingPoint, hints) {
  this._modeling.reconnectStart(connection, newSource, dockingPoint, hints);
};

ReplaceShapeHandler.prototype.reconnectEnd = function (connection, newTarget, dockingPoint, hints) {
  this._modeling.reconnectEnd(connection, newTarget, dockingPoint, hints);
};

},{"254":254}],167:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ResizeShapeHandler;

var _minDash = _dereq_(254);

var _AnchorsHelper = _dereq_(172);

/**
 * A handler that implements reversible resizing of shapes.
 *
 * @param {Modeling} modeling
 */
function ResizeShapeHandler(modeling) {
  this._modeling = modeling;
}

ResizeShapeHandler.$inject = ['modeling'];

/**
 * {
 *   shape: {....}
 *   newBounds: {
 *     width:  20,
 *     height: 40,
 *     x:       5,
 *     y:      10
 *   }
 *
 * }
 */
ResizeShapeHandler.prototype.execute = function (context) {
  var shape = context.shape,
      newBounds = context.newBounds,
      minBounds = context.minBounds;

  if (newBounds.x === undefined || newBounds.y === undefined || newBounds.width === undefined || newBounds.height === undefined) {
    throw new Error('newBounds must have {x, y, width, height} properties');
  }

  if (minBounds && (newBounds.width < minBounds.width || newBounds.height < minBounds.height)) {
    throw new Error('width and height cannot be less than minimum height and width');
  } else if (!minBounds && newBounds.width < 10 || newBounds.height < 10) {
    throw new Error('width and height cannot be less than 10px');
  }

  // save old bbox in context
  context.oldBounds = {
    width: shape.width,
    height: shape.height,
    x: shape.x,
    y: shape.y
  };

  // update shape
  (0, _minDash.assign)(shape, {
    width: newBounds.width,
    height: newBounds.height,
    x: newBounds.x,
    y: newBounds.y
  });

  return shape;
};

ResizeShapeHandler.prototype.postExecute = function (context) {

  var shape = context.shape,
      oldBounds = context.oldBounds;

  var modeling = this._modeling;

  (0, _minDash.forEach)(shape.incoming, function (c) {
    modeling.layoutConnection(c, {
      connectionEnd: (0, _AnchorsHelper.getResizedTargetAnchor)(c, shape, oldBounds)
    });
  });

  (0, _minDash.forEach)(shape.outgoing, function (c) {
    modeling.layoutConnection(c, {
      connectionStart: (0, _AnchorsHelper.getResizedSourceAnchor)(c, shape, oldBounds)
    });
  });
};

ResizeShapeHandler.prototype.revert = function (context) {

  var shape = context.shape,
      oldBounds = context.oldBounds;

  // restore previous bbox
  (0, _minDash.assign)(shape, {
    width: oldBounds.width,
    height: oldBounds.height,
    x: oldBounds.x,
    y: oldBounds.y
  });

  return shape;
};

},{"172":172,"254":254}],168:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SpaceToolHandler;

var _minDash = _dereq_(254);

var _SpaceUtil = _dereq_(215);

/**
 * A handler that implements reversible creating and removing of space.
 *
 * It executes in two phases:
 *
 *  (1) resize all affected resizeShapes
 *  (2) move all affected moveElements
 */
function SpaceToolHandler(modeling) {
  this._modeling = modeling;
}

SpaceToolHandler.$inject = ['modeling'];

SpaceToolHandler.prototype.preExecute = function (context) {

  // resize
  var modeling = this._modeling,
      resizingShapes = context.resizingShapes,
      delta = context.delta,
      direction = context.direction;

  (0, _minDash.forEach)(resizingShapes, function (shape) {
    var newBounds = (0, _SpaceUtil.resizeBounds)(shape, direction, delta);

    modeling.resizeShape(shape, newBounds);
  });
};

SpaceToolHandler.prototype.postExecute = function (context) {
  // move
  var modeling = this._modeling,
      movingShapes = context.movingShapes,
      delta = context.delta;

  modeling.moveElements(movingShapes, delta, undefined, { autoResize: false, attach: false });
};

SpaceToolHandler.prototype.execute = function (context) {};
SpaceToolHandler.prototype.revert = function (context) {};

},{"215":215,"254":254}],169:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ToggleShapeCollapseHandler;
/**
 * A handler that toggles the collapsed state of an element
 * and the visibility of all its children.
 *
 * @param {Modeling} modeling
 */
function ToggleShapeCollapseHandler(modeling) {
  this._modeling = modeling;
}

ToggleShapeCollapseHandler.$inject = ['modeling'];

ToggleShapeCollapseHandler.prototype.execute = function (context) {

  var shape = context.shape,
      children = shape.children;

  // remember previous visibility of children
  context.oldChildrenVisibility = getElementsVisibility(children);

  // toggle state
  shape.collapsed = !shape.collapsed;

  // hide/show children
  setHidden(children, shape.collapsed);

  return [shape].concat(children);
};

ToggleShapeCollapseHandler.prototype.revert = function (context) {

  var shape = context.shape,
      oldChildrenVisibility = context.oldChildrenVisibility;

  var children = shape.children;

  // set old visability of children
  restoreVisibility(children, oldChildrenVisibility);

  // retoggle state
  shape.collapsed = !shape.collapsed;

  return [shape].concat(children);
};

// helpers //////////////////////

/**
 * Return a map { elementId -> hiddenState}.
 *
 * @param {Array<djs.model.Shape>} elements
 *
 * @return {Object}
 */
function getElementsVisibility(elements) {

  var result = {};

  elements.forEach(function (e) {
    result[e.id] = e.hidden;
  });

  return result;
}

function setHidden(elements, newHidden) {
  elements.forEach(function (element) {
    element.hidden = newHidden;
  });
}

function restoreVisibility(elements, lastState) {
  elements.forEach(function (e) {
    e.hidden = lastState[e.id];
  });
}

},{}],170:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = UpdateAttachmentHandler;

var _Collections = _dereq_(233);

/**
 * A handler that implements reversible attaching/detaching of shapes.
 */
function UpdateAttachmentHandler(modeling) {
  this._modeling = modeling;
}

UpdateAttachmentHandler.$inject = ['modeling'];

UpdateAttachmentHandler.prototype.execute = function (context) {
  var shape = context.shape,
      newHost = context.newHost,
      oldHost = shape.host;

  // (0) detach from old host
  context.oldHost = oldHost;
  context.attacherIdx = removeAttacher(oldHost, shape);

  // (1) attach to new host
  addAttacher(newHost, shape);

  // (2) update host
  shape.host = newHost;

  return shape;
};

UpdateAttachmentHandler.prototype.revert = function (context) {
  var shape = context.shape,
      newHost = context.newHost,
      oldHost = context.oldHost,
      attacherIdx = context.attacherIdx;

  // (2) update host
  shape.host = oldHost;

  // (1) attach to new host
  removeAttacher(newHost, shape);

  // (0) detach from old host
  addAttacher(oldHost, shape, attacherIdx);

  return shape;
};

function removeAttacher(host, attacher) {
  // remove attacher from host
  return (0, _Collections.remove)(host && host.attachers, attacher);
}

function addAttacher(host, attacher, idx) {

  if (!host) {
    return;
  }

  var attachers = host.attachers;

  if (!attachers) {
    host.attachers = attachers = [];
  }

  (0, _Collections.add)(attachers, attacher, idx);
}

},{"233":233}],171:[function(_dereq_,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = UpdateWaypointsHandler;
function UpdateWaypointsHandler() {}

UpdateWaypointsHandler.prototype.execute = function (context) {

  var connection = context.connection,
      newWaypoints = context.newWaypoints;

  context.oldWaypoints = connection.waypoints;

  connection.waypoints = newWaypoints;

  return connection;
};

UpdateWaypointsHandler.prototype.revert = function (context) {

  var connection = context.connection,
      oldWaypoints = context.oldWaypoints;

  connection.waypoints = oldWaypoints;

  return connection;
};

},{}],172:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResizedSourceAnchor = getResizedSourceAnchor;
exports.getResizedTargetAnchor = getResizedTargetAnchor;
exports.getMovedSourceAnchor = getMovedSourceAnchor;
exports.getMovedTargetAnchor = getMovedTargetAnchor;

var _AttachUtil = _dereq_(231);

function getResizedSourceAnchor(connection, shape, oldBounds) {

  var waypoints = safeGetWaypoints(connection),
      oldAnchor = waypoints[0];

  return (0, _AttachUtil.getNewAttachPoint)(oldAnchor.original || oldAnchor, oldBounds, shape);
}

function getResizedTargetAnchor(connection, shape, oldBounds) {

  var waypoints = safeGetWaypoints(connection),
      oldAnchor = waypoints[waypoints.length - 1];

  return (0, _AttachUtil.getNewAttachPoint)(oldAnchor.original || oldAnchor, oldBounds, shape);
}

function getMovedSourceAnchor(connection, source, moveDelta) {
  return getResizedSourceAnchor(connection, source, substractPosition(source, moveDelta));
}

function getMovedTargetAnchor(connection, target, moveDelta) {
  return getResizedTargetAnchor(connection, target, substractPosition(target, moveDelta));
}

// helpers //////////////////////

function substractPosition(bounds, delta) {
  return {
    x: bounds.x - delta.x,
    y: bounds.y - delta.y,
    width: bounds.width,
    height: bounds.height
  };
}

/**
 * Return waypoints of given connection; throw if non exists (should not happen!!).
 *
 * @param {Connection} connection
 *
 * @return {Array<Point>}
 */
function safeGetWaypoints(connection) {

  var waypoints = connection.waypoints;

  if (!waypoints.length) {
    throw new Error('connection#' + connection.id + ': no waypoints');
  }

  return waypoints;
}

},{"231":231}],173:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MoveClosure;

var _minDash = _dereq_(254);

var _Elements = _dereq_(235);

function MoveClosure() {

  this.allShapes = {};
  this.allConnections = {};

  this.enclosedElements = {};
  this.enclosedConnections = {};

  this.topLevel = {};
}

MoveClosure.prototype.add = function (element, isTopLevel) {
  return this.addAll([element], isTopLevel);
};

MoveClosure.prototype.addAll = function (elements, isTopLevel) {

  var newClosure = (0, _Elements.getClosure)(elements, !!isTopLevel, this);

  (0, _minDash.assign)(this, newClosure);

  return this;
};

},{"235":235,"254":254}],174:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MoveHelper;

var _minDash = _dereq_(254);

var _AnchorsHelper = _dereq_(172);

var _MoveClosure = _dereq_(173);

var _MoveClosure2 = _interopRequireDefault(_MoveClosure);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A helper that is able to carry out serialized move
 * operations on multiple elements.
 *
 * @param {Modeling} modeling
 */
function MoveHelper(modeling) {
  this._modeling = modeling;
}

/**
 * Move the specified elements and all children by the given delta.
 *
 * This moves all enclosed connections, too and layouts all affected
 * external connections.
 *
 * @param  {Array<djs.model.Base>} elements
 * @param  {Point} delta
 * @param  {djs.model.Base} newParent applied to the first level of shapes
 *
 * @return {Array<djs.model.Base>} list of touched elements
 */
MoveHelper.prototype.moveRecursive = function (elements, delta, newParent) {
  if (!elements) {
    return [];
  } else {
    return this.moveClosure(this.getClosure(elements), delta, newParent);
  }
};

/**
 * Move the given closure of elmements.
 *
 * @param {Object} closure
 * @param {Point} delta
 * @param {djs.model.Base} [newParent]
 * @param {djs.model.Base} [newHost]
 */
MoveHelper.prototype.moveClosure = function (closure, delta, newParent, newHost, primaryShape) {
  var modeling = this._modeling;

  var allShapes = closure.allShapes,
      allConnections = closure.allConnections,
      enclosedConnections = closure.enclosedConnections,
      topLevel = closure.topLevel,
      keepParent = false;

  if (primaryShape && primaryShape.parent === newParent) {
    keepParent = true;
  }

  // move all shapes
  (0, _minDash.forEach)(allShapes, function (shape) {

    // move the element according to the given delta
    modeling.moveShape(shape, delta, topLevel[shape.id] && !keepParent && newParent, {
      recurse: false,
      layout: false
    });
  });

  // move all child connections / layout external connections
  (0, _minDash.forEach)(allConnections, function (c) {

    var sourceMoved = !!allShapes[c.source.id],
        targetMoved = !!allShapes[c.target.id];

    if (enclosedConnections[c.id] && sourceMoved && targetMoved) {
      modeling.moveConnection(c, delta, topLevel[c.id] && !keepParent && newParent);
    } else {
      modeling.layoutConnection(c, {
        connectionStart: sourceMoved && (0, _AnchorsHelper.getMovedSourceAnchor)(c, c.source, delta),
        connectionEnd: targetMoved && (0, _AnchorsHelper.getMovedTargetAnchor)(c, c.target, delta)
      });
    }
  });
};

/**
 * Returns the closure for the selected elements
 *
 * @param  {Array<djs.model.Base>} elements
 * @return {MoveClosure} closure
 */
MoveHelper.prototype.getClosure = function (elements) {
  return new _MoveClosure2.default().addAll(elements, true);
};

},{"172":172,"173":173,"254":254}],175:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MouseTracking;

var _minDash = _dereq_(254);

function MouseTracking(eventBus, canvas) {
  this._eventBus = eventBus;
  this._canvas = canvas;

  this._init();
}

MouseTracking.$inject = ['eventBus', 'canvas'];

MouseTracking.prototype.getHoverContext = function () {
  var viewbox = this._canvas.viewbox();

  return {
    element: this._hoverElement,
    point: {
      x: viewbox.x + Math.round(this._mouseX / viewbox.scale),
      y: viewbox.y + Math.round(this._mouseY / viewbox.scale)
    }
  };
};

MouseTracking.prototype._init = function () {
  var eventBus = this._eventBus,
      canvas = this._canvas;

  var container = canvas.getContainer();

  this._setMousePosition = (0, _minDash.bind)(this._setMousePosition, this);

  container.addEventListener('mousemove', this._setMousePosition);

  eventBus.on('diagram.destroy', function () {
    container.removeEventListener('mousemove', this._setMousePosition);
  }, this);

  eventBus.on('element.hover', this._setHoverElement, this);
};

MouseTracking.prototype._setHoverElement = function (event) {
  this._hoverElement = event.element;
};

MouseTracking.prototype._setMousePosition = function (event) {
  this._mouseX = event.layerX;
  this._mouseY = event.layerY;
};

},{"254":254}],176:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _MouseTracking = _dereq_(175);

var _MouseTracking2 = _interopRequireDefault(_MouseTracking);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['mouseTracking'],
  mouseTracking: ['type', _MouseTracking2.default]
};

},{"175":175}],177:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MoveEvents;

var _minDash = _dereq_(254);

var _Event = _dereq_(237);

var LOW_PRIORITY = 500,
    MEDIUM_PRIORITY = 1250,
    HIGH_PRIORITY = 1500;

var round = Math.round;

function mid(element) {
  return {
    x: element.x + round(element.width / 2),
    y: element.y + round(element.height / 2)
  };
}

/**
 * A plugin that makes shapes draggable / droppable.
 *
 * @param {EventBus} eventBus
 * @param {Dragging} dragging
 * @param {Modeling} modeling
 * @param {Selection} selection
 * @param {Rules} rules
 */
function MoveEvents(eventBus, dragging, modeling, selection, rules) {

  // rules

  function canMove(shapes, delta, position, target) {

    return rules.allowed('elements.move', {
      shapes: shapes,
      delta: delta,
      position: position,
      target: target
    });
  }

  // move events

  // assign a high priority to this handler to setup the environment
  // others may hook up later, e.g. at default priority and modify
  // the move environment.
  //
  // This sets up the context with
  //
  // * shape: the primary shape being moved
  // * shapes: a list of shapes to be moved
  // * validatedShapes: a list of shapes that are being checked
  //                    against the rules before and during move
  //
  eventBus.on('shape.move.start', HIGH_PRIORITY, function (event) {

    var context = event.context,
        shape = event.shape,
        shapes = selection.get().slice();

    // move only single shape if the dragged element
    // is not part of the current selection
    if (shapes.indexOf(shape) === -1) {
      shapes = [shape];
    }

    // ensure we remove nested elements in the collection
    // and add attachers for a proper dragger
    shapes = removeNested(shapes);

    // attach shapes to drag context
    (0, _minDash.assign)(context, {
      shapes: shapes,
      validatedShapes: shapes,
      shape: shape
    });
  });

  // assign a high priority to this handler to setup the environment
  // others may hook up later, e.g. at default priority and modify
  // the move environment
  //
  eventBus.on('shape.move.start', MEDIUM_PRIORITY, function (event) {

    var context = event.context,
        validatedShapes = context.validatedShapes,
        canExecute;

    canExecute = context.canExecute = canMove(validatedShapes);

    // check if we can move the elements
    if (!canExecute) {
      return false;
    }
  });

  // assign a low priority to this handler
  // to let others modify the move event before we update
  // the context
  //
  eventBus.on('shape.move.move', LOW_PRIORITY, function (event) {

    var context = event.context,
        validatedShapes = context.validatedShapes,
        hover = event.hover,
        delta = { x: event.dx, y: event.dy },
        position = { x: event.x, y: event.y },
        canExecute;

    // check if we can move the elements
    canExecute = canMove(validatedShapes, delta, position, hover);

    context.delta = delta;
    context.canExecute = canExecute;

    // simply ignore move over
    if (canExecute === null) {
      context.target = null;

      return;
    }

    context.target = hover;
  });

  eventBus.on('shape.move.end', function (event) {

    var context = event.context;

    var delta = context.delta,
        canExecute = context.canExecute,
        isAttach = canExecute === 'attach',
        shapes = context.shapes;

    if (canExecute === false) {
      return false;
    }

    // ensure we have actual pixel values deltas
    // (important when zoom level was > 1 during move)
    delta.x = round(delta.x);
    delta.y = round(delta.y);

    if (delta.x === 0 && delta.y === 0) {

      // didn't move
      return;
    }

    modeling.moveElements(shapes, delta, context.target, {
      primaryShape: context.shape,
      attach: isAttach
    });
  });

  // move activation

  eventBus.on('element.mousedown', function (event) {

    var originalEvent = (0, _Event.getOriginal)(event);

    if (!originalEvent) {
      throw new Error('must supply DOM mousedown event');
    }

    return start(originalEvent, event.element);
  });

  /**
   * Start move.
   *
   * @param {MouseEvent} event
   * @param {djs.model.Shape} shape
   * @param {boolean} [activate]
   * @param {Object} [context]
   */
  function start(event, element, activate, context) {
    if ((0, _minDash.isObject)(activate)) {
      context = activate;
      activate = false;
    }

    // do not move connections or the root element
    if (element.waypoints || !element.parent) {
      return;
    }

    var referencePoint = mid(element);

    dragging.init(event, referencePoint, 'shape.move', {
      cursor: 'grabbing',
      autoActivate: activate,
      data: {
        shape: element,
        context: context || {}
      }
    });

    // we've handled the event
    return true;
  }

  // API

  this.start = start;
}

MoveEvents.$inject = ['eventBus', 'dragging', 'modeling', 'selection', 'rules'];

/**
 * Return a filtered list of elements that do not contain
 * those nested into others.
 *
 * @param  {Array<djs.model.Base>} elements
 *
 * @return {Array<djs.model.Base>} filtered
 */
function removeNested(elements) {

  var ids = (0, _minDash.groupBy)(elements, 'id');

  return (0, _minDash.filter)(elements, function (element) {
    while (element = element.parent) {

      // parent in selection
      if (ids[element.id]) {
        return false;
      }
    }

    return true;
  });
}

},{"237":237,"254":254}],178:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MovePreview;

var _minDash = _dereq_(254);

var _Elements = _dereq_(235);

var _tinySvg = _dereq_(275);

var _SvgTransformUtil = _dereq_(248);

var LOW_PRIORITY = 499;

var MARKER_DRAGGING = 'djs-dragging',
    MARKER_OK = 'drop-ok',
    MARKER_NOT_OK = 'drop-not-ok',
    MARKER_NEW_PARENT = 'new-parent',
    MARKER_ATTACH = 'attach-ok';

/**
 * Provides previews for moving shapes when moving.
 *
 * @param {EventBus} eventBus
 * @param {ElementRegistry} elementRegistry
 * @param {Canvas} canvas
 * @param {Styles} styles
 */
function MovePreview(eventBus, canvas, styles, previewSupport) {

  function getVisualDragShapes(shapes) {
    var elements = getAllDraggedElements(shapes);

    var filteredElements = removeEdges(elements);

    return filteredElements;
  }

  function getAllDraggedElements(shapes) {
    var allShapes = (0, _Elements.selfAndAllChildren)(shapes, true);

    var allConnections = (0, _minDash.map)(allShapes, function (shape) {
      return (shape.incoming || []).concat(shape.outgoing || []);
    });

    return (0, _minDash.flatten)(allShapes.concat(allConnections));
  }

  /**
   * Sets drop marker on an element.
   */
  function setMarker(element, marker) {

    [MARKER_ATTACH, MARKER_OK, MARKER_NOT_OK, MARKER_NEW_PARENT].forEach(function (m) {

      if (m === marker) {
        canvas.addMarker(element, m);
      } else {
        canvas.removeMarker(element, m);
      }
    });
  }

  /**
   * Make an element draggable.
   *
   * @param {Object} context
   * @param {djs.model.Base} element
   * @param {Boolean} addMarker
   */
  function makeDraggable(context, element, addMarker) {

    previewSupport.addDragger(element, context.dragGroup);

    if (addMarker) {
      canvas.addMarker(element, MARKER_DRAGGING);
    }

    if (context.allDraggedElements) {
      context.allDraggedElements.push(element);
    } else {
      context.allDraggedElements = [element];
    }
  }

  // assign a low priority to this handler
  // to let others modify the move context before
  // we draw things
  eventBus.on('shape.move.start', LOW_PRIORITY, function (event) {
    var context = event.context,
        dragShapes = context.shapes,
        allDraggedElements = context.allDraggedElements;

    var visuallyDraggedShapes = getVisualDragShapes(dragShapes);

    if (!context.dragGroup) {
      var dragGroup = (0, _tinySvg.create)('g');

      (0, _tinySvg.attr)(dragGroup, styles.cls('djs-drag-group', ['no-events']));

      var defaultLayer = canvas.getDefaultLayer();

      (0, _tinySvg.append)(defaultLayer, dragGroup);

      context.dragGroup = dragGroup;
    }

    // add previews
    visuallyDraggedShapes.forEach(function (shape) {
      previewSupport.addDragger(shape, context.dragGroup);
    });

    // cache all dragged elements / gfx
    // so that we can quickly undo their state changes later
    if (!allDraggedElements) {
      allDraggedElements = getAllDraggedElements(dragShapes);
    } else {
      allDraggedElements = (0, _minDash.flatten)([allDraggedElements, getAllDraggedElements(dragShapes)]);
    }

    // add dragging marker
    (0, _minDash.forEach)(allDraggedElements, function (e) {
      canvas.addMarker(e, MARKER_DRAGGING);
    });

    context.allDraggedElements = allDraggedElements;

    // determine, if any of the dragged elements have different parents
    context.differentParents = haveDifferentParents(dragShapes);
  });

  // update previews
  eventBus.on('shape.move.move', LOW_PRIORITY, function (event) {

    var context = event.context,
        dragGroup = context.dragGroup,
        target = context.target,
        parent = context.shape.parent,
        canExecute = context.canExecute;

    if (target) {
      if (canExecute === 'attach') {
        setMarker(target, MARKER_ATTACH);
      } else if (context.canExecute && target && target.id !== parent.id) {
        setMarker(target, MARKER_NEW_PARENT);
      } else {
        setMarker(target, context.canExecute ? MARKER_OK : MARKER_NOT_OK);
      }
    }

    (0, _SvgTransformUtil.translate)(dragGroup, event.dx, event.dy);
  });

  eventBus.on(['shape.move.out', 'shape.move.cleanup'], function (event) {
    var context = event.context,
        target = context.target;

    if (target) {
      setMarker(target, null);
    }
  });

  // remove previews
  eventBus.on('shape.move.cleanup', function (event) {

    var context = event.context,
        allDraggedElements = context.allDraggedElements,
        dragGroup = context.dragGroup;

    // remove dragging marker
    (0, _minDash.forEach)(allDraggedElements, function (e) {
      canvas.removeMarker(e, MARKER_DRAGGING);
    });

    if (dragGroup) {
      (0, _tinySvg.remove)(dragGroup);
    }
  });

  // API //////////////////////

  /**
   * Make an element draggable.
   *
   * @param {Object} context
   * @param {djs.model.Base} element
   * @param {Boolean} addMarker
   */
  this.makeDraggable = makeDraggable;
}

MovePreview.$inject = ['eventBus', 'canvas', 'styles', 'previewSupport'];

// helpers //////////////////////

/**
 * returns elements minus all connections
 * where source or target is not elements
 */
function removeEdges(elements) {

  var filteredElements = (0, _minDash.filter)(elements, function (element) {

    if (!isConnection(element)) {
      return true;
    } else {

      return (0, _minDash.find)(elements, (0, _minDash.matchPattern)({ id: element.source.id })) && (0, _minDash.find)(elements, (0, _minDash.matchPattern)({ id: element.target.id }));
    }
  });

  return filteredElements;
}

function haveDifferentParents(elements) {
  return (0, _minDash.size)((0, _minDash.groupBy)(elements, function (e) {
    return e.parent && e.parent.id;
  })) !== 1;
}

/**
 * Checks if an element is a connection.
 */
function isConnection(element) {
  return element.waypoints;
}

},{"235":235,"248":248,"254":254,"275":275}],179:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _interactionEvents = _dereq_(139);

var _interactionEvents2 = _interopRequireDefault(_interactionEvents);

var _selection = _dereq_(206);

var _selection2 = _interopRequireDefault(_selection);

var _outline = _dereq_(182);

var _outline2 = _interopRequireDefault(_outline);

var _rules = _dereq_(200);

var _rules2 = _interopRequireDefault(_rules);

var _dragging = _dereq_(131);

var _dragging2 = _interopRequireDefault(_dragging);

var _previewSupport = _dereq_(190);

var _previewSupport2 = _interopRequireDefault(_previewSupport);

var _Move = _dereq_(177);

var _Move2 = _interopRequireDefault(_Move);

var _MovePreview = _dereq_(178);

var _MovePreview2 = _interopRequireDefault(_MovePreview);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_interactionEvents2.default, _selection2.default, _outline2.default, _rules2.default, _dragging2.default, _previewSupport2.default],
  __init__: ['move', 'movePreview'],
  move: ['type', _Move2.default],
  movePreview: ['type', _MovePreview2.default]
};

},{"131":131,"139":139,"177":177,"178":178,"182":182,"190":190,"200":200,"206":206}],180:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OrderingProvider;

var _inherits = _dereq_(253);

var _inherits2 = _interopRequireDefault(_inherits);

var _CommandInterceptor = _dereq_(91);

var _CommandInterceptor2 = _interopRequireDefault(_CommandInterceptor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * An abstract provider that allows modelers to implement a custom
 * ordering of diagram elements on the canvas.
 *
 * It makes sure that the order is always preserved during element
 * creation and move operations.
 *
 * In order to use this behavior, inherit from it and override
 * the method {@link OrderingProvider#getOrdering}.
 *
 * @example
 *
 * ```javascript
 * function CustomOrderingProvider(eventBus) {
 *   OrderingProvider.call(this, eventBus);
 *
 *   this.getOrdering = function(element, newParent) {
 *     // always insert elements at the front
 *     // when moving
 *     return {
 *       index: 0,
 *       parent: newParent
 *     };
 *   };
 * }
 * ```
 *
 * @param {EventBus} eventBus
 */
function OrderingProvider(eventBus) {

  _CommandInterceptor2.default.call(this, eventBus);

  var self = this;

  this.preExecute(['shape.create', 'connection.create'], function (event) {

    var context = event.context,
        element = context.shape || context.connection,
        parent = context.parent;

    var ordering = self.getOrdering(element, parent);

    if (ordering) {

      if (ordering.parent !== undefined) {
        context.parent = ordering.parent;
      }

      context.parentIndex = ordering.index;
    }
  });

  this.preExecute(['shape.move', 'connection.move'], function (event) {

    var context = event.context,
        element = context.shape || context.connection,
        parent = context.newParent || element.parent;

    var ordering = self.getOrdering(element, parent);

    if (ordering) {

      if (ordering.parent !== undefined) {
        context.newParent = ordering.parent;
      }

      context.newParentIndex = ordering.index;
    }
  });
}

/**
 * Return a custom ordering of the element, both in terms
 * of parent element and index in the new parent.
 *
 * Implementors of this method must return an object with
 * `parent` _and_ `index` in it.
 *
 * @param {djs.model.Base} element
 * @param {djs.model.Shape} newParent
 *
 * @return {Object} ordering descriptor
 */
OrderingProvider.prototype.getOrdering = function (element, newParent) {
  return null;
};

(0, _inherits2.default)(OrderingProvider, _CommandInterceptor2.default);

},{"253":253,"91":91}],181:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Outline;

var _Elements = _dereq_(235);

var _tinySvg = _dereq_(275);

var _minDom = _dereq_(255);

var _minDash = _dereq_(254);

var LOW_PRIORITY = 500;

/**
 * @class
 *
 * A plugin that adds an outline to shapes and connections that may be activated and styled
 * via CSS classes.
 *
 * @param {EventBus} eventBus
 * @param {Styles} styles
 * @param {ElementRegistry} elementRegistry
 */
function Outline(eventBus, styles, elementRegistry) {

  this.offset = 6;

  var OUTLINE_STYLE = styles.cls('djs-outline', ['no-fill']);

  var self = this;

  function createOutline(gfx, bounds) {
    var outline = (0, _tinySvg.create)('rect');

    (0, _tinySvg.attr)(outline, (0, _minDash.assign)({
      x: 10,
      y: 10,
      width: 100,
      height: 100
    }, OUTLINE_STYLE));

    (0, _tinySvg.append)(gfx, outline);

    return outline;
  }

  // A low priortity is necessary, because outlines of labels have to be updated
  // after the label bounds have been updated in the renderer.
  eventBus.on(['shape.added', 'shape.changed'], LOW_PRIORITY, function (event) {
    var element = event.element,
        gfx = event.gfx;

    var outline = (0, _minDom.query)('.djs-outline', gfx);

    if (!outline) {
      outline = createOutline(gfx, element);
    }

    self.updateShapeOutline(outline, element);
  });

  eventBus.on(['connection.added', 'connection.changed'], function (event) {
    var element = event.element,
        gfx = event.gfx;

    var outline = (0, _minDom.query)('.djs-outline', gfx);

    if (!outline) {
      outline = createOutline(gfx, element);
    }

    self.updateConnectionOutline(outline, element);
  });
}

/**
 * Updates the outline of a shape respecting the dimension of the
 * element and an outline offset.
 *
 * @param  {SVGElement} outline
 * @param  {djs.model.Base} element
 */
Outline.prototype.updateShapeOutline = function (outline, element) {

  (0, _tinySvg.attr)(outline, {
    x: -this.offset,
    y: -this.offset,
    width: element.width + this.offset * 2,
    height: element.height + this.offset * 2
  });
};

/**
 * Updates the outline of a connection respecting the bounding box of
 * the connection and an outline offset.
 *
 * @param  {SVGElement} outline
 * @param  {djs.model.Base} element
 */
Outline.prototype.updateConnectionOutline = function (outline, connection) {

  var bbox = (0, _Elements.getBBox)(connection);

  (0, _tinySvg.attr)(outline, {
    x: bbox.x - this.offset,
    y: bbox.y - this.offset,
    width: bbox.width + this.offset * 2,
    height: bbox.height + this.offset * 2
  });
};

Outline.$inject = ['eventBus', 'styles', 'elementRegistry'];

},{"235":235,"254":254,"255":255,"275":275}],182:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _Outline = _dereq_(181);

var _Outline2 = _interopRequireDefault(_Outline);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['outline'],
  outline: ['type', _Outline2.default]
};

},{"181":181}],183:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Overlays;

var _minDash = _dereq_(254);

var _minDom = _dereq_(255);

var _Elements = _dereq_(235);

var _IdGenerator = _dereq_(240);

var _IdGenerator2 = _interopRequireDefault(_IdGenerator);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// document wide unique overlay ids
var ids = new _IdGenerator2.default('ov');

var LOW_PRIORITY = 500;

/**
 * A service that allows users to attach overlays to diagram elements.
 *
 * The overlay service will take care of overlay positioning during updates.
 *
 * @example
 *
 * // add a pink badge on the top left of the shape
 * overlays.add(someShape, {
 *   position: {
 *     top: -5,
 *     left: -5
 *   },
 *   html: '<div style="width: 10px; background: fuchsia; color: white;">0</div>'
 * });
 *
 * // or add via shape id
 *
 * overlays.add('some-element-id', {
 *   position: {
 *     top: -5,
 *     left: -5
 *   }
 *   html: '<div style="width: 10px; background: fuchsia; color: white;">0</div>'
 * });
 *
 * // or add with optional type
 *
 * overlays.add(someShape, 'badge', {
 *   position: {
 *     top: -5,
 *     left: -5
 *   }
 *   html: '<div style="width: 10px; background: fuchsia; color: white;">0</div>'
 * });
 *
 *
 * // remove an overlay
 *
 * var id = overlays.add(...);
 * overlays.remove(id);
 *
 *
 * You may configure overlay defaults during tool by providing a `config` module
 * with `overlays.defaults` as an entry:
 *
 * {
 *   overlays: {
 *     defaults: {
 *       show: {
 *         minZoom: 0.7,
 *         maxZoom: 5.0
 *       },
 *       scale: {
 *         min: 1
 *       }
 *     }
 * }
 *
 * @param {Object} config
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {ElementRegistry} elementRegistry
 */
function Overlays(config, eventBus, canvas, elementRegistry) {

  this._eventBus = eventBus;
  this._canvas = canvas;
  this._elementRegistry = elementRegistry;

  this._ids = ids;

  this._overlayDefaults = (0, _minDash.assign)({
    // no show constraints
    show: null,

    // always scale
    scale: true
  }, config && config.defaults);

  /**
   * Mapping overlayId -> overlay
   */
  this._overlays = {};

  /**
   * Mapping elementId -> overlay container
   */
  this._overlayContainers = [];

  // root html element for all overlays
  this._overlayRoot = createRoot(canvas.getContainer());

  this._init();
}

Overlays.$inject = ['config.overlays', 'eventBus', 'canvas', 'elementRegistry'];

/**
 * Returns the overlay with the specified id or a list of overlays
 * for an element with a given type.
 *
 * @example
 *
 * // return the single overlay with the given id
 * overlays.get('some-id');
 *
 * // return all overlays for the shape
 * overlays.get({ element: someShape });
 *
 * // return all overlays on shape with type 'badge'
 * overlays.get({ element: someShape, type: 'badge' });
 *
 * // shape can also be specified as id
 * overlays.get({ element: 'element-id', type: 'badge' });
 *
 *
 * @param {Object} search
 * @param {String} [search.id]
 * @param {String|djs.model.Base} [search.element]
 * @param {String} [search.type]
 *
 * @return {Object|Array<Object>} the overlay(s)
 */
Overlays.prototype.get = function (search) {

  if ((0, _minDash.isString)(search)) {
    search = { id: search };
  }

  if ((0, _minDash.isString)(search.element)) {
    search.element = this._elementRegistry.get(search.element);
  }

  if (search.element) {
    var container = this._getOverlayContainer(search.element, true);

    // return a list of overlays when searching by element (+type)
    if (container) {
      return search.type ? (0, _minDash.filter)(container.overlays, (0, _minDash.matchPattern)({ type: search.type })) : container.overlays.slice();
    } else {
      return [];
    }
  } else if (search.type) {
    return (0, _minDash.filter)(this._overlays, (0, _minDash.matchPattern)({ type: search.type }));
  } else {
    // return single element when searching by id
    return search.id ? this._overlays[search.id] : null;
  }
};

/**
 * Adds a HTML overlay to an element.
 *
 * @param {String|djs.model.Base}   element   attach overlay to this shape
 * @param {String}                  [type]    optional type to assign to the overlay
 * @param {Object}                  overlay   the overlay configuration
 *
 * @param {String|DOMElement}       overlay.html                 html element to use as an overlay
 * @param {Object}                  [overlay.show]               show configuration
 * @param {Number}                  [overlay.show.minZoom]       minimal zoom level to show the overlay
 * @param {Number}                  [overlay.show.maxZoom]       maximum zoom level to show the overlay
 * @param {Object}                  overlay.position             where to attach the overlay
 * @param {Number}                  [overlay.position.left]      relative to element bbox left attachment
 * @param {Number}                  [overlay.position.top]       relative to element bbox top attachment
 * @param {Number}                  [overlay.position.bottom]    relative to element bbox bottom attachment
 * @param {Number}                  [overlay.position.right]     relative to element bbox right attachment
 * @param {Boolean|Object}          [overlay.scale=true]         false to preserve the same size regardless of
 *                                                               diagram zoom
 * @param {Number}                  [overlay.scale.min]
 * @param {Number}                  [overlay.scale.max]
 *
 * @return {String}                 id that may be used to reference the overlay for update or removal
 */
Overlays.prototype.add = function (element, type, overlay) {

  if ((0, _minDash.isObject)(type)) {
    overlay = type;
    type = null;
  }

  if (!element.id) {
    element = this._elementRegistry.get(element);
  }

  if (!overlay.position) {
    throw new Error('must specifiy overlay position');
  }

  if (!overlay.html) {
    throw new Error('must specifiy overlay html');
  }

  if (!element) {
    throw new Error('invalid element specified');
  }

  var id = this._ids.next();

  overlay = (0, _minDash.assign)({}, this._overlayDefaults, overlay, {
    id: id,
    type: type,
    element: element,
    html: overlay.html
  });

  this._addOverlay(overlay);

  return id;
};

/**
 * Remove an overlay with the given id or all overlays matching the given filter.
 *
 * @see Overlays#get for filter options.
 *
 * @param {String} [id]
 * @param {Object} [filter]
 */
Overlays.prototype.remove = function (filter) {

  var overlays = this.get(filter) || [];

  if (!(0, _minDash.isArray)(overlays)) {
    overlays = [overlays];
  }

  var self = this;

  (0, _minDash.forEach)(overlays, function (overlay) {

    var container = self._getOverlayContainer(overlay.element, true);

    if (overlay) {
      (0, _minDom.remove)(overlay.html);
      (0, _minDom.remove)(overlay.htmlContainer);

      delete overlay.htmlContainer;
      delete overlay.element;

      delete self._overlays[overlay.id];
    }

    if (container) {
      var idx = container.overlays.indexOf(overlay);
      if (idx !== -1) {
        container.overlays.splice(idx, 1);
      }
    }
  });
};

Overlays.prototype.show = function () {
  setVisible(this._overlayRoot);
};

Overlays.prototype.hide = function () {
  setVisible(this._overlayRoot, false);
};

Overlays.prototype.clear = function () {
  this._overlays = {};

  this._overlayContainers = [];

  (0, _minDom.clear)(this._overlayRoot);
};

Overlays.prototype._updateOverlayContainer = function (container) {
  var element = container.element,
      html = container.html;

  // update container left,top according to the elements x,y coordinates
  // this ensures we can attach child elements relative to this container

  var x = element.x,
      y = element.y;

  if (element.waypoints) {
    var bbox = (0, _Elements.getBBox)(element);
    x = bbox.x;
    y = bbox.y;
  }

  setPosition(html, x, y);

  (0, _minDom.attr)(container.html, 'data-container-id', element.id);
};

Overlays.prototype._updateOverlay = function (overlay) {

  var position = overlay.position,
      htmlContainer = overlay.htmlContainer,
      element = overlay.element;

  // update overlay html relative to shape because
  // it is already positioned on the element

  // update relative
  var left = position.left,
      top = position.top;

  if (position.right !== undefined) {

    var width;

    if (element.waypoints) {
      width = (0, _Elements.getBBox)(element).width;
    } else {
      width = element.width;
    }

    left = position.right * -1 + width;
  }

  if (position.bottom !== undefined) {

    var height;

    if (element.waypoints) {
      height = (0, _Elements.getBBox)(element).height;
    } else {
      height = element.height;
    }

    top = position.bottom * -1 + height;
  }

  setPosition(htmlContainer, left || 0, top || 0);
};

Overlays.prototype._createOverlayContainer = function (element) {
  var html = (0, _minDom.domify)('<div class="djs-overlays" style="position: absolute" />');

  this._overlayRoot.appendChild(html);

  var container = {
    html: html,
    element: element,
    overlays: []
  };

  this._updateOverlayContainer(container);

  this._overlayContainers.push(container);

  return container;
};

Overlays.prototype._updateRoot = function (viewbox) {
  var scale = viewbox.scale || 1;

  var matrix = 'matrix(' + [scale, 0, 0, scale, -1 * viewbox.x * scale, -1 * viewbox.y * scale].join(',') + ')';

  setTransform(this._overlayRoot, matrix);
};

Overlays.prototype._getOverlayContainer = function (element, raw) {
  var container = (0, _minDash.find)(this._overlayContainers, function (c) {
    return c.element === element;
  });

  if (!container && !raw) {
    return this._createOverlayContainer(element);
  }

  return container;
};

Overlays.prototype._addOverlay = function (overlay) {

  var id = overlay.id,
      element = overlay.element,
      html = overlay.html,
      htmlContainer,
      overlayContainer;

  // unwrap jquery (for those who need it)
  if (html.get && html.constructor.prototype.jquery) {
    html = html.get(0);
  }

  // create proper html elements from
  // overlay HTML strings
  if ((0, _minDash.isString)(html)) {
    html = (0, _minDom.domify)(html);
  }

  overlayContainer = this._getOverlayContainer(element);

  htmlContainer = (0, _minDom.domify)('<div class="djs-overlay" data-overlay-id="' + id + '" style="position: absolute">');

  htmlContainer.appendChild(html);

  if (overlay.type) {
    (0, _minDom.classes)(htmlContainer).add('djs-overlay-' + overlay.type);
  }

  overlay.htmlContainer = htmlContainer;

  overlayContainer.overlays.push(overlay);
  overlayContainer.html.appendChild(htmlContainer);

  this._overlays[id] = overlay;

  this._updateOverlay(overlay);
  this._updateOverlayVisibilty(overlay, this._canvas.viewbox());
};

Overlays.prototype._updateOverlayVisibilty = function (overlay, viewbox) {
  var show = overlay.show,
      minZoom = show && show.minZoom,
      maxZoom = show && show.maxZoom,
      htmlContainer = overlay.htmlContainer,
      visible = true;

  if (show) {
    if ((0, _minDash.isDefined)(minZoom) && minZoom > viewbox.scale || (0, _minDash.isDefined)(maxZoom) && maxZoom < viewbox.scale) {
      visible = false;
    }

    setVisible(htmlContainer, visible);
  }

  this._updateOverlayScale(overlay, viewbox);
};

Overlays.prototype._updateOverlayScale = function (overlay, viewbox) {
  var shouldScale = overlay.scale,
      minScale,
      maxScale,
      htmlContainer = overlay.htmlContainer;

  var scale,
      transform = '';

  if (shouldScale !== true) {

    if (shouldScale === false) {
      minScale = 1;
      maxScale = 1;
    } else {
      minScale = shouldScale.min;
      maxScale = shouldScale.max;
    }

    if ((0, _minDash.isDefined)(minScale) && viewbox.scale < minScale) {
      scale = (1 / viewbox.scale || 1) * minScale;
    }

    if ((0, _minDash.isDefined)(maxScale) && viewbox.scale > maxScale) {
      scale = (1 / viewbox.scale || 1) * maxScale;
    }
  }

  if ((0, _minDash.isDefined)(scale)) {
    transform = 'scale(' + scale + ',' + scale + ')';
  }

  setTransform(htmlContainer, transform);
};

Overlays.prototype._updateOverlaysVisibilty = function (viewbox) {

  var self = this;

  (0, _minDash.forEach)(this._overlays, function (overlay) {
    self._updateOverlayVisibilty(overlay, viewbox);
  });
};

Overlays.prototype._init = function () {

  var eventBus = this._eventBus;

  var self = this;

  // scroll/zoom integration

  function updateViewbox(viewbox) {
    self._updateRoot(viewbox);
    self._updateOverlaysVisibilty(viewbox);

    self.show();
  }

  eventBus.on('canvas.viewbox.changing', function (event) {
    self.hide();
  });

  eventBus.on('canvas.viewbox.changed', function (event) {
    updateViewbox(event.viewbox);
  });

  // remove integration

  eventBus.on(['shape.remove', 'connection.remove'], function (e) {
    var element = e.element;
    var overlays = self.get({ element: element });

    (0, _minDash.forEach)(overlays, function (o) {
      self.remove(o.id);
    });

    var container = self._getOverlayContainer(element);

    if (container) {
      (0, _minDom.remove)(container.html);
      var i = self._overlayContainers.indexOf(container);
      if (i !== -1) {
        self._overlayContainers.splice(i, 1);
      }
    }
  });

  // move integration

  eventBus.on('element.changed', LOW_PRIORITY, function (e) {
    var element = e.element;

    var container = self._getOverlayContainer(element, true);

    if (container) {
      (0, _minDash.forEach)(container.overlays, function (overlay) {
        self._updateOverlay(overlay);
      });

      self._updateOverlayContainer(container);
    }
  });

  // marker integration, simply add them on the overlays as classes, too.

  eventBus.on('element.marker.update', function (e) {
    var container = self._getOverlayContainer(e.element, true);
    if (container) {
      (0, _minDom.classes)(container.html)[e.add ? 'add' : 'remove'](e.marker);
    }
  });

  // clear overlays with diagram

  eventBus.on('diagram.clear', this.clear, this);
};

// helpers /////////////////////////////

function createRoot(parentNode) {
  var root = (0, _minDom.domify)('<div class="djs-overlay-container" style="position: absolute; width: 0; height: 0;" />');

  parentNode.insertBefore(root, parentNode.firstChild);

  return root;
}

function setPosition(el, x, y) {
  (0, _minDash.assign)(el.style, { left: x + 'px', top: y + 'px' });
}

function setVisible(el, visible) {
  el.style.display = visible === false ? 'none' : '';
}

function setTransform(el, transform) {

  el.style['transform-origin'] = 'top left';

  ['', '-ms-', '-webkit-'].forEach(function (prefix) {
    el.style[prefix + 'transform'] = transform;
  });
}

},{"235":235,"240":240,"254":254,"255":255}],184:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _Overlays = _dereq_(183);

var _Overlays2 = _interopRequireDefault(_Overlays);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['overlays'],
  overlays: ['type', _Overlays2.default]
};

},{"183":183}],185:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Palette;

var _minDash = _dereq_(254);

var _minDom = _dereq_(255);

var TOGGLE_SELECTOR = '.djs-palette-toggle',
    ENTRY_SELECTOR = '.entry',
    ELEMENT_SELECTOR = TOGGLE_SELECTOR + ', ' + ENTRY_SELECTOR;

var PALETTE_OPEN_CLS = 'open',
    PALETTE_TWO_COLUMN_CLS = 'two-column';

/**
 * A palette containing modeling elements.
 */
function Palette(eventBus, canvas) {

  this._eventBus = eventBus;
  this._canvas = canvas;

  this._providers = [];

  var self = this;

  eventBus.on('tool-manager.update', function (event) {
    var tool = event.tool;

    self.updateToolHighlight(tool);
  });

  eventBus.on('i18n.changed', function () {
    self._update();
  });

  eventBus.on('diagram.init', function () {

    self._diagramInitialized = true;

    // initialize + update once diagram is ready
    if (self._providers.length) {
      self._init();

      self._update();
    }
  });
}

Palette.$inject = ['eventBus', 'canvas'];

/**
 * Register a provider with the palette
 *
 * @param  {PaletteProvider} provider
 */
Palette.prototype.registerProvider = function (provider) {
  this._providers.push(provider);

  // postpone init / update until diagram is initialized
  if (!this._diagramInitialized) {
    return;
  }

  if (!this._container) {
    this._init();
  }

  this._update();
};

/**
 * Returns the palette entries for a given element
 *
 * @return {Array<PaletteEntryDescriptor>} list of entries
 */
Palette.prototype.getEntries = function () {

  var entries = {};

  // loop through all providers and their entries.
  // group entries by id so that overriding an entry is possible
  (0, _minDash.forEach)(this._providers, function (provider) {
    var e = provider.getPaletteEntries();

    (0, _minDash.forEach)(e, function (entry, id) {
      entries[id] = entry;
    });
  });

  return entries;
};

/**
 * Initialize
 */
Palette.prototype._init = function () {
  var canvas = this._canvas,
      eventBus = this._eventBus;

  var parent = canvas.getContainer(),
      container = this._container = (0, _minDom.domify)(Palette.HTML_MARKUP),
      self = this;

  parent.appendChild(container);

  _minDom.delegate.bind(container, ELEMENT_SELECTOR, 'click', function (event) {

    var target = event.delegateTarget;

    if ((0, _minDom.matches)(target, TOGGLE_SELECTOR)) {
      return self.toggle();
    }

    self.trigger('click', event);
  });

  // prevent drag propagation
  _minDom.event.bind(container, 'mousedown', function (event) {
    event.stopPropagation();
  });

  // prevent drag propagation
  _minDom.delegate.bind(container, ENTRY_SELECTOR, 'dragstart', function (event) {
    self.trigger('dragstart', event);
  });

  eventBus.on('canvas.resized', this._layoutChanged, this);

  eventBus.fire('palette.create', {
    container: container
  });
};

/**
 * Update palette state.
 *
 * @param  {Object} [state] { open, twoColumn }
 */
Palette.prototype._toggleState = function (state) {

  state = state || {};

  var parent = this._getParentContainer(),
      container = this._container;

  var eventBus = this._eventBus;

  var twoColumn;

  var cls = (0, _minDom.classes)(container);

  if ('twoColumn' in state) {
    twoColumn = state.twoColumn;
  } else {
    twoColumn = this._needsCollapse(parent.clientHeight, this._entries || {});
  }

  // always update two column
  cls.toggle(PALETTE_TWO_COLUMN_CLS, twoColumn);

  if ('open' in state) {
    cls.toggle(PALETTE_OPEN_CLS, state.open);
  }

  eventBus.fire('palette.changed', {
    twoColumn: twoColumn,
    open: this.isOpen()
  });
};

Palette.prototype._update = function () {

  var entriesContainer = (0, _minDom.query)('.djs-palette-entries', this._container),
      entries = this._entries = this.getEntries();

  (0, _minDom.clear)(entriesContainer);

  (0, _minDash.forEach)(entries, function (entry, id) {

    var grouping = entry.group || 'default';

    var container = (0, _minDom.query)('[data-group=' + grouping + ']', entriesContainer);
    if (!container) {
      container = (0, _minDom.domify)('<div class="group" data-group="' + grouping + '"></div>');
      entriesContainer.appendChild(container);
    }

    var html = entry.html || (entry.separator ? '<hr class="separator" />' : '<div class="entry" draggable="true"></div>');

    var control = (0, _minDom.domify)(html);
    container.appendChild(control);

    if (!entry.separator) {
      (0, _minDom.attr)(control, 'data-action', id);

      if (entry.title) {
        (0, _minDom.attr)(control, 'title', entry.title);
      }

      if (entry.className) {
        addClasses(control, entry.className);
      }

      if (entry.imageUrl) {
        control.appendChild((0, _minDom.domify)('<img src="' + entry.imageUrl + '">'));
      }
    }
  });

  // open after update
  this.open();
};

/**
 * Trigger an action available on the palette
 *
 * @param  {String} action
 * @param  {Event} event
 */
Palette.prototype.trigger = function (action, event, autoActivate) {
  var entries = this._entries,
      entry,
      handler,
      originalEvent,
      button = event.delegateTarget || event.target;

  if (!button) {
    return event.preventDefault();
  }

  entry = entries[(0, _minDom.attr)(button, 'data-action')];

  // when user clicks on the palette and not on an action
  if (!entry) {
    return;
  }

  handler = entry.action;

  originalEvent = event.originalEvent || event;

  // simple action (via callback function)
  if ((0, _minDash.isFunction)(handler)) {
    if (action === 'click') {
      handler(originalEvent, autoActivate);
    }
  } else {
    if (handler[action]) {
      handler[action](originalEvent, autoActivate);
    }
  }

  // silence other actions
  event.preventDefault();
};

Palette.prototype._layoutChanged = function () {
  this._toggleState({});
};

/**
 * Do we need to collapse to two columns?
 *
 * @param {Number} availableHeight
 * @param {Object} entries
 *
 * @return {Boolean}
 */
Palette.prototype._needsCollapse = function (availableHeight, entries) {

  // top margin + bottom toggle + bottom margin
  // implementors must override this method if they
  // change the palette styles
  var margin = 20 + 10 + 20;

  var entriesHeight = Object.keys(entries).length * 46;

  return availableHeight < entriesHeight + margin;
};

/**
 * Close the palette
 */
Palette.prototype.close = function () {

  this._toggleState({
    open: false,
    twoColumn: false
  });
};

/**
 * Open the palette
 */
Palette.prototype.open = function () {
  this._toggleState({ open: true });
};

Palette.prototype.toggle = function (open) {
  if (this.isOpen()) {
    this.close();
  } else {
    this.open();
  }
};

Palette.prototype.isActiveTool = function (tool) {
  return tool && this._activeTool === tool;
};

Palette.prototype.updateToolHighlight = function (name) {
  var entriesContainer, toolsContainer;

  if (!this._toolsContainer) {
    entriesContainer = (0, _minDom.query)('.djs-palette-entries', this._container);

    this._toolsContainer = (0, _minDom.query)('[data-group=tools]', entriesContainer);
  }

  toolsContainer = this._toolsContainer;

  (0, _minDash.forEach)(toolsContainer.children, function (tool) {
    var actionName = tool.getAttribute('data-action');

    if (!actionName) {
      return;
    }

    var toolClasses = (0, _minDom.classes)(tool);

    actionName = actionName.replace('-tool', '');

    if (toolClasses.contains('entry') && actionName === name) {
      toolClasses.add('highlighted-entry');
    } else {
      toolClasses.remove('highlighted-entry');
    }
  });
};

/**
 * Return true if the palette is opened.
 *
 * @example
 *
 * palette.open();
 *
 * if (palette.isOpen()) {
 *   // yes, we are open
 * }
 *
 * @return {boolean} true if palette is opened
 */
Palette.prototype.isOpen = function () {
  return (0, _minDom.classes)(this._container).has(PALETTE_OPEN_CLS);
};

/**
 * Get container the palette lives in.
 *
 * @return {Element}
 */
Palette.prototype._getParentContainer = function () {
  return this._canvas.getContainer();
};

/* markup definition */

Palette.HTML_MARKUP = '<div class="djs-palette">' + '<div class="djs-palette-entries"></div>' + '<div class="djs-palette-toggle"></div>' + '</div>';

// helpers //////////////////////

function addClasses(element, classNames) {

  var classes = (0, _minDom.classes)(element);

  var actualClassNames = (0, _minDash.isArray)(classNames) ? classNames : classNames.split(/\s+/g);
  actualClassNames.forEach(function (cls) {
    classes.add(cls);
  });
}

},{"254":254,"255":255}],186:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _Palette = _dereq_(185);

var _Palette2 = _interopRequireDefault(_Palette);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['palette'],
  palette: ['type', _Palette2.default]
};

},{"185":185}],187:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PopupMenu;

var _minDash = _dereq_(254);

var _minDom = _dereq_(255);

var DATA_REF = 'data-id';

/**
 * A popup menu that can be used to display a list of actions anywhere in the canvas.
 *
 * @param {Object} config
 * @param {Boolean|Object} [config.scale={ min: 1.0, max: 1.5 }]
 * @param {Number} [config.scale.min]
 * @param {Number} [config.scale.max]
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 *
 * @class
 * @constructor
 */
function PopupMenu(config, eventBus, canvas) {

  var scale = (0, _minDash.isDefined)(config && config.scale) ? config.scale : {
    min: 1,
    max: 1.5
  };

  this._config = {
    scale: scale
  };

  this._eventBus = eventBus;
  this._canvas = canvas;
  this._providers = {};
  this._current = {};
}

PopupMenu.$inject = ['config.popupMenu', 'eventBus', 'canvas'];

/**
 * Registers a popup menu provider
 *
 * @param  {String} id
 * @param  {Object} provider
 *
 * @example
 *
 * popupMenu.registerProvider('myMenuID', {
 *   getEntries: function(element) {
 *     return [
 *       {
 *         id: 'entry-1',
 *         label: 'My Entry',
 *         action: 'alert("I have been clicked!")'
 *       }
 *     ];
 *   }
 * });
 */
PopupMenu.prototype.registerProvider = function (id, provider) {
  this._providers[id] = provider;
};

/**
 * Determine if the popup menu has entries.
 *
 * @return {Boolean} true if empty
 */
PopupMenu.prototype.isEmpty = function (element, providerId) {
  if (!element) {
    throw new Error('element parameter is missing');
  }

  if (!providerId) {
    throw new Error('providerId parameter is missing');
  }

  var provider = this._providers[providerId];

  var entries = provider.getEntries(element),
      headerEntries = provider.getHeaderEntries && provider.getHeaderEntries(element);

  var hasEntries = entries.length > 0,
      hasHeaderEntries = headerEntries && headerEntries.length > 0;

  return !hasEntries && !hasHeaderEntries;
};

/**
 * Create entries and open popup menu at given position
 *
 * @param  {Object} element
 * @param  {String} id provider id
 * @param  {Object} position
 *
 * @return {Object} popup menu instance
 */
PopupMenu.prototype.open = function (element, id, position) {

  var provider = this._providers[id];

  if (!element) {
    throw new Error('Element is missing');
  }

  if (!provider) {
    throw new Error('Provider is not registered: ' + id);
  }

  if (!position) {
    throw new Error('the position argument is missing');
  }

  if (this.isOpen()) {
    this.close();
  }

  this._emit('open');

  var current = this._current = {
    provider: provider,
    className: id,
    element: element,
    position: position
  };

  if (provider.getHeaderEntries) {
    current.headerEntries = provider.getHeaderEntries(element);
  }

  current.entries = provider.getEntries(element);

  current.container = this._createContainer();

  var headerEntries = current.headerEntries || [],
      entries = current.entries || [];

  if (headerEntries.length) {
    current.container.appendChild(this._createEntries(current.headerEntries, 'djs-popup-header'));
  }

  if (entries.length) {
    current.container.appendChild(this._createEntries(current.entries, 'djs-popup-body'));
  }

  var canvas = this._canvas,
      parent = canvas.getContainer();

  this._attachContainer(current.container, parent, position.cursor);
};

/**
 * Removes the popup menu and unbinds the event handlers.
 */
PopupMenu.prototype.close = function () {

  if (!this.isOpen()) {
    return;
  }

  this._emit('close');

  this._unbindHandlers();
  (0, _minDom.remove)(this._current.container);
  this._current.container = null;
};

/**
 * Determine if an open popup menu exist.
 *
 * @return {Boolean} true if open
 */
PopupMenu.prototype.isOpen = function () {
  return !!this._current.container;
};

/**
 * Trigger an action associated with an entry.
 *
 * @param {Object} event
 *
 * @return the result of the action callback, if any
 */
PopupMenu.prototype.trigger = function (event) {

  // silence other actions
  event.preventDefault();

  var element = event.delegateTarget || event.target,
      entryId = (0, _minDom.attr)(element, DATA_REF);

  var entry = this._getEntry(entryId);

  if (entry.action) {
    return entry.action.call(null, event, entry);
  }
};

/**
 * Gets an entry instance (either entry or headerEntry) by id.
 *
 * @param  {String} entryId
 *
 * @return {Object} entry instance
 */
PopupMenu.prototype._getEntry = function (entryId) {

  var search = (0, _minDash.matchPattern)({ id: entryId });

  var entry = (0, _minDash.find)(this._current.entries, search) || (0, _minDash.find)(this._current.headerEntries, search);

  if (!entry) {
    throw new Error('entry not found');
  }

  return entry;
};

PopupMenu.prototype._emit = function (eventName) {
  this._eventBus.fire('popupMenu.' + eventName);
};

/**
 * Creates the popup menu container.
 *
 * @return {Object} a DOM container
 */
PopupMenu.prototype._createContainer = function () {
  var container = (0, _minDom.domify)('<div class="djs-popup">'),
      position = this._current.position,
      className = this._current.className;

  (0, _minDash.assign)(container.style, {
    position: 'absolute',
    left: position.x + 'px',
    top: position.y + 'px',
    visibility: 'hidden'
  });

  (0, _minDom.classes)(container).add(className);

  return container;
};

/**
 * Attaches the container to the DOM and binds the event handlers.
 *
 * @param {Object} container
 * @param {Object} parent
 */
PopupMenu.prototype._attachContainer = function (container, parent, cursor) {
  var self = this;

  // Event handler
  _minDom.delegate.bind(container, '.entry', 'click', function (event) {
    self.trigger(event);
  });

  this._updateScale(container);

  // Attach to DOM
  parent.appendChild(container);

  if (cursor) {
    this._assureIsInbounds(container, cursor);
  }

  // Add Handler
  this._bindHandlers();
};

/**
 * Updates popup style.transform with respect to the config and zoom level.
 *
 * @method _updateScale
 *
 * @param {Object} container
 */
PopupMenu.prototype._updateScale = function (container) {
  var zoom = this._canvas.zoom();

  var scaleConfig = this._config.scale,
      minScale,
      maxScale,
      scale = zoom;

  if (scaleConfig !== true) {

    if (scaleConfig === false) {
      minScale = 1;
      maxScale = 1;
    } else {
      minScale = scaleConfig.min;
      maxScale = scaleConfig.max;
    }

    if ((0, _minDash.isDefined)(minScale) && zoom < minScale) {
      scale = minScale;
    }

    if ((0, _minDash.isDefined)(maxScale) && zoom > maxScale) {
      scale = maxScale;
    }
  }

  setTransform(container, 'scale(' + scale + ')');
};

/**
 * Make sure that the menu is always fully shown
 *
 * @method function
 *
 * @param  {Object} container
 * @param  {Position} cursor {x, y}
 */
PopupMenu.prototype._assureIsInbounds = function (container, cursor) {
  var canvas = this._canvas,
      clientRect = canvas._container.getBoundingClientRect();

  var containerX = container.offsetLeft,
      containerY = container.offsetTop,
      containerWidth = container.scrollWidth,
      containerHeight = container.scrollHeight,
      overAxis = {},
      left,
      top;

  var cursorPosition = {
    x: cursor.x - clientRect.left,
    y: cursor.y - clientRect.top
  };

  if (containerX + containerWidth > clientRect.width) {
    overAxis.x = true;
  }

  if (containerY + containerHeight > clientRect.height) {
    overAxis.y = true;
  }

  if (overAxis.x && overAxis.y) {
    left = cursorPosition.x - containerWidth + 'px';
    top = cursorPosition.y - containerHeight + 'px';
  } else if (overAxis.x) {
    left = cursorPosition.x - containerWidth + 'px';
    top = cursorPosition.y + 'px';
  } else if (overAxis.y && cursorPosition.y < containerHeight) {
    left = cursorPosition.x + 'px';
    top = 10 + 'px';
  } else if (overAxis.y) {
    left = cursorPosition.x + 'px';
    top = cursorPosition.y - containerHeight + 'px';
  }

  (0, _minDash.assign)(container.style, { left: left, top: top }, { visibility: 'visible', 'z-index': 1000 });
};

/**
 * Creates a list of entries and returns them as a DOM container.
 *
 * @param {Array<Object>} entries an array of entry objects
 * @param {String} className the class name of the entry container
 *
 * @return {Object} a DOM container
 */
PopupMenu.prototype._createEntries = function (entries, className) {

  var entriesContainer = (0, _minDom.domify)('<div>'),
      self = this;

  (0, _minDom.classes)(entriesContainer).add(className);

  (0, _minDash.forEach)(entries, function (entry) {
    var entryContainer = self._createEntry(entry, entriesContainer);
    entriesContainer.appendChild(entryContainer);
  });

  return entriesContainer;
};

/**
 * Creates a single entry and returns it as a DOM container.
 *
 * @param  {Object} entry
 *
 * @return {Object} a DOM container
 */
PopupMenu.prototype._createEntry = function (entry) {

  if (!entry.id) {
    throw new Error('every entry must have the id property set');
  }

  var entryContainer = (0, _minDom.domify)('<div>'),
      entryClasses = (0, _minDom.classes)(entryContainer);

  entryClasses.add('entry');

  if (entry.className) {
    entry.className.split(' ').forEach(function (className) {
      entryClasses.add(className);
    });
  }

  (0, _minDom.attr)(entryContainer, DATA_REF, entry.id);

  if (entry.label) {
    var label = (0, _minDom.domify)('<span>');
    label.textContent = entry.label;
    entryContainer.appendChild(label);
  }

  if (entry.imageUrl) {
    entryContainer.appendChild((0, _minDom.domify)('<img src="' + entry.imageUrl + '" />'));
  }

  if (entry.active === true) {
    entryClasses.add('active');
  }

  if (entry.disabled === true) {
    entryClasses.add('disabled');
  }

  if (entry.title) {
    entryContainer.title = entry.title;
  }

  return entryContainer;
};

/**
 * Binds the `close` method to 'contextPad.close' & 'canvas.viewbox.changed'.
 */
PopupMenu.prototype._bindHandlers = function () {

  var eventBus = this._eventBus,
      self = this;

  function close() {
    self.close();
  }

  eventBus.once('contextPad.close', close);
  eventBus.once('canvas.viewbox.changing', close);
  eventBus.once('commandStack.changed', close);
};

/**
 * Unbinds the `close` method to 'contextPad.close' & 'canvas.viewbox.changing'.
 */
PopupMenu.prototype._unbindHandlers = function () {

  var eventBus = this._eventBus,
      self = this;

  function close() {
    self.close();
  }

  eventBus.off('contextPad.close', close);
  eventBus.off('canvas.viewbox.changed', close);
  eventBus.off('commandStack.changed', close);
};

// helpers /////////////////////////////

function setTransform(element, transform) {
  element.style['transform-origin'] = 'top left';

  ['', '-ms-', '-webkit-'].forEach(function (prefix) {
    element.style[prefix + 'transform'] = transform;
  });
}

},{"254":254,"255":255}],188:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _PopupMenu = _dereq_(187);

var _PopupMenu2 = _interopRequireDefault(_PopupMenu);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['popupMenu'],
  popupMenu: ['type', _PopupMenu2.default]
};

},{"187":187}],189:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PreviewSupport;

var _minDash = _dereq_(254);

var _tinySvg = _dereq_(275);

var _minDom = _dereq_(255);

var _GraphicsUtil = _dereq_(239);

var MARKER_TYPES = ['marker-start', 'marker-mid', 'marker-end'];

var NODES_CAN_HAVE_MARKER = ['circle', 'ellipse', 'line', 'path', 'polygon', 'polyline', 'rect'];

/**
 * Adds support for previews of moving/resizing elements.
 */
function PreviewSupport(elementRegistry, eventBus, canvas, styles) {
  this._elementRegistry = elementRegistry;
  this._canvas = canvas;
  this._styles = styles;

  this._clonedMarkers = {};

  var self = this;

  eventBus.on('drag.cleanup', function () {
    (0, _minDash.forEach)(self._clonedMarkers, function (clonedMarker) {
      (0, _tinySvg.remove)(clonedMarker);
    });

    self._clonedMarkers = {};
  });
}

PreviewSupport.$inject = ['elementRegistry', 'eventBus', 'canvas', 'styles'];

/**
 * Returns graphics of an element.
 *
 * @param {djs.model.Base} element
 *
 * @return {SVGElement}
 */
PreviewSupport.prototype.getGfx = function (element) {
  return this._elementRegistry.getGraphics(element);
};

/**
 * Adds a move preview of a given shape to a given svg group.
 *
 * @param {djs.model.Base} element
 * @param {SVGElement} group
 *
 * @return {SVGElement} dragger
 */
PreviewSupport.prototype.addDragger = function (shape, group) {
  var gfx = this.getGfx(shape);

  var dragger = (0, _tinySvg.clone)(gfx);
  var bbox = gfx.getBoundingClientRect();

  this._cloneMarkers((0, _GraphicsUtil.getVisual)(dragger));

  (0, _tinySvg.attr)(dragger, this._styles.cls('djs-dragger', [], {
    x: bbox.top,
    y: bbox.left
  }));

  (0, _tinySvg.append)(group, dragger);

  return dragger;
};

/**
 * Adds a resize preview of a given shape to a given svg group.
 *
 * @param {djs.model.Base} element
 * @param {SVGElement} group
 *
 * @return {SVGElement} frame
 */
PreviewSupport.prototype.addFrame = function (shape, group) {

  var frame = (0, _tinySvg.create)('rect', {
    class: 'djs-resize-overlay',
    width: shape.width,
    height: shape.height,
    x: shape.x,
    y: shape.y
  });

  (0, _tinySvg.append)(group, frame);

  return frame;
};

/**
 * Clone all markers referenced by a node and its child nodes.
 *
 * @param {SVGElement} gfx
 */
PreviewSupport.prototype._cloneMarkers = function (gfx) {
  var self = this;

  if (gfx.childNodes) {

    // TODO: use forEach once we drop PhantomJS
    for (var i = 0; i < gfx.childNodes.length; i++) {

      // recursively clone markers of child nodes
      self._cloneMarkers(gfx.childNodes[i]);
    }
  }

  if (!canHaveMarker(gfx)) {
    return;
  }

  MARKER_TYPES.forEach(function (markerType) {
    if ((0, _tinySvg.attr)(gfx, markerType)) {
      var marker = getMarker(gfx, markerType, self._canvas.getContainer());

      self._cloneMarker(gfx, marker, markerType);
    }
  });
};

/**
 * Clone marker referenced by an element.
 *
 * @param {SVGElement} gfx
 * @param {SVGElement} marker
 * @param {string} markerType
 */
PreviewSupport.prototype._cloneMarker = function (gfx, marker, markerType) {
  var markerId = marker.id;

  var clonedMarker = this._clonedMarkers[markerId];

  if (!clonedMarker) {
    clonedMarker = (0, _tinySvg.clone)(marker);

    var clonedMarkerId = markerId + '-clone';

    clonedMarker.id = clonedMarkerId;

    (0, _tinySvg.classes)(clonedMarker).add('djs-dragger').add('djs-dragger-marker');

    this._clonedMarkers[markerId] = clonedMarker;

    var defs = (0, _minDom.query)('defs', this._canvas._svg);

    if (!defs) {
      defs = (0, _tinySvg.create)('defs');

      (0, _tinySvg.append)(this._canvas._svg, defs);
    }

    (0, _tinySvg.append)(defs, clonedMarker);
  }

  var reference = idToReference(this._clonedMarkers[markerId].id);

  (0, _tinySvg.attr)(gfx, markerType, reference);
};

// helpers //////////

/**
 * Get marker of given type referenced by node.
 *
 * @param {Node} node
 * @param {string} markerType
 * @param {Node} [parentNode]
 *
 * @param {Node}
 */
function getMarker(node, markerType, parentNode) {
  var id = referenceToId((0, _tinySvg.attr)(node, markerType));

  return (0, _minDom.query)('marker#' + id, parentNode || document);
}

/**
 * Get ID of fragment within current document from its functional IRI reference.
 * References may use single or double quotes.
 *
 * @param {string} reference
 *
 * @returns {string}
 */
function referenceToId(reference) {
  return reference.match(/url\(['"]?#([^'"]*)['"]?\)/)[1];
}

/**
 * Get functional IRI reference for given ID of fragment within current document.
 *
 * @param {string} id
 *
 * @returns {string}
 */
function idToReference(id) {
  return 'url(#' + id + ')';
}

/**
 * Check wether node type can have marker attributes.
 *
 * @param {Node} node
 *
 * @returns {boolean}
 */
function canHaveMarker(node) {
  return NODES_CAN_HAVE_MARKER.indexOf(node.nodeName) !== -1;
}

},{"239":239,"254":254,"255":255,"275":275}],190:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _PreviewSupport = _dereq_(189);

var _PreviewSupport2 = _interopRequireDefault(_PreviewSupport);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['previewSupport'],
  previewSupport: ['type', _PreviewSupport2.default]
};

},{"189":189}],191:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Replace;
var round = Math.round;

/**
 * Service that allow replacing of elements.
 */
function Replace(modeling) {

  this._modeling = modeling;
}

Replace.$inject = ['modeling'];

/**
 * @param {Element} oldElement - Element to be replaced
 * @param {Object}  newElementData - Containing information about the new Element, for example height, width, type.
 * @param {Object}  options - Custom options that will be attached to the context. It can be used to inject data
 *                            that is needed in the command chain. For example it could be used in
 *                            eventbus.on('commandStack.shape.replace.postExecute') to change shape attributes after
 *                            shape creation.
 */
Replace.prototype.replaceElement = function (oldElement, newElementData, options) {

  var modeling = this._modeling;

  var newElement = null;

  if (oldElement.waypoints) {
    // TODO
    // modeling.replaceConnection
  } else {
    // set center of element for modeling API
    // if no new width / height is given use old elements size
    newElementData.x = round(oldElement.x + (newElementData.width || oldElement.width) / 2);
    newElementData.y = round(oldElement.y + (newElementData.height || oldElement.height) / 2);

    newElement = modeling.replaceShape(oldElement, newElementData, options);
  }

  return newElement;
};

},{}],192:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _Replace = _dereq_(191);

var _Replace2 = _interopRequireDefault(_Replace);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['replace'],
  replace: ['type', _Replace2.default]
};

},{"191":191}],193:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Resize;

var _minDash = _dereq_(254);

var _ResizeUtil = _dereq_(196);

var _LayoutUtil = _dereq_(221);

var DEFAULT_MIN_WIDTH = 10;

/**
 * A component that provides resizing of shapes on the canvas.
 *
 * The following components are part of shape resize:
 *
 *  * adding resize handles,
 *  * creating a visual during resize
 *  * checking resize rules
 *  * committing a change once finished
 *
 *
 * ## Customizing
 *
 * It's possible to customize the resizing behaviour by intercepting 'resize.start'
 * and providing the following parameters through the 'context':
 *
 *   * minDimensions ({ width, height }): minimum shape dimensions
 *
 *   * childrenBoxPadding ({ left, top, bottom, right } || number):
 *     gap between the minimum bounding box and the container
 *
 * f.ex:
 *
 * ```javascript
 * eventBus.on('resize.start', 1500, function(event) {
 *   var context = event.context,
 *
 *  context.minDimensions = { width: 140, height: 120 };
 *
 *  // Passing general padding
 *  context.childrenBoxPadding = 30;
 *
 *  // Passing padding to a specific side
 *  context.childrenBoxPadding.left = 20;
 * });
 * ```
 */
function Resize(eventBus, rules, modeling, dragging) {

  this._dragging = dragging;
  this._rules = rules;

  var self = this;

  /**
   * Handle resize move by specified delta.
   *
   * @param {Object} context
   * @param {Point} delta
   */
  function handleMove(context, delta) {

    var shape = context.shape,
        direction = context.direction,
        resizeConstraints = context.resizeConstraints,
        newBounds;

    context.delta = delta;

    newBounds = (0, _ResizeUtil.resizeBounds)(shape, direction, delta);

    // ensure constraints during resize
    context.newBounds = (0, _ResizeUtil.ensureConstraints)(newBounds, resizeConstraints);

    // update + cache executable state
    context.canExecute = self.canResize(context);
  }

  /**
   * Handle resize start.
   *
   * @param  {Object} context
   */
  function handleStart(context) {

    var resizeConstraints = context.resizeConstraints,

    // evaluate minBounds for backwards compatibility
    minBounds = context.minBounds;

    if (resizeConstraints !== undefined) {
      return;
    }

    if (minBounds === undefined) {
      minBounds = self.computeMinResizeBox(context);
    }

    context.resizeConstraints = {
      min: (0, _LayoutUtil.asTRBL)(minBounds)
    };
  }

  /**
   * Handle resize end.
   *
   * @param  {Object} context
   */
  function handleEnd(context) {
    var shape = context.shape,
        canExecute = context.canExecute,
        newBounds = context.newBounds;

    if (canExecute) {

      // ensure we have actual pixel values for new bounds
      // (important when zoom level was > 1 during move)
      newBounds = (0, _LayoutUtil.roundBounds)(newBounds);

      if (!boundsChanged(shape, newBounds)) {

        // no resize necessary
        return;
      }

      // perform the actual resize
      modeling.resizeShape(shape, newBounds);
    }
  }

  eventBus.on('resize.start', function (event) {
    handleStart(event.context);
  });

  eventBus.on('resize.move', function (event) {
    var delta = {
      x: event.dx,
      y: event.dy
    };

    handleMove(event.context, delta);
  });

  eventBus.on('resize.end', function (event) {
    handleEnd(event.context);
  });
}

Resize.prototype.canResize = function (context) {
  var rules = this._rules;

  var ctx = (0, _minDash.pick)(context, ['newBounds', 'shape', 'delta', 'direction']);

  return rules.allowed('shape.resize', ctx);
};

/**
 * Activate a resize operation.
 *
 * You may specify additional contextual information and must specify a
 * resize direction during activation of the resize event.
 *
 * @param {MouseEvent} event
 * @param {djs.model.Shape} shape
 * @param {Object|String} contextOrDirection
 */
Resize.prototype.activate = function (event, shape, contextOrDirection) {
  var dragging = this._dragging,
      context,
      direction;

  if (typeof contextOrDirection === 'string') {
    contextOrDirection = {
      direction: contextOrDirection
    };
  }

  context = (0, _minDash.assign)({ shape: shape }, contextOrDirection);

  direction = context.direction;

  if (!direction) {
    throw new Error('must provide a direction (nw|se|ne|sw)');
  }

  var referencePoint = {
    x: /w/.test(direction) ? shape.x : shape.x + shape.width,
    y: /n/.test(direction) ? shape.y : shape.y + shape.height
  };

  dragging.init(event, referencePoint, 'resize', {
    autoActivate: true,
    cursor: 'resize-' + (/nw|se/.test(direction) ? 'nwse' : 'nesw'),
    data: {
      shape: shape,
      context: context
    }
  });
};

Resize.prototype.computeMinResizeBox = function (context) {
  var shape = context.shape,
      direction = context.direction,
      minDimensions,
      childrenBounds;

  minDimensions = context.minDimensions || {
    width: DEFAULT_MIN_WIDTH,
    height: DEFAULT_MIN_WIDTH
  };

  // get children bounds
  childrenBounds = (0, _ResizeUtil.computeChildrenBBox)(shape, context.childrenBoxPadding);

  // get correct minimum bounds from given resize direction
  // basically ensures that the minBounds is max(childrenBounds, minDimensions)
  return (0, _ResizeUtil.getMinResizeBounds)(direction, shape, minDimensions, childrenBounds);
};

Resize.$inject = ['eventBus', 'rules', 'modeling', 'dragging'];

// helpers //////////

function boundsChanged(shape, newBounds) {
  return shape.x !== newBounds.x || shape.y !== newBounds.y || shape.width !== newBounds.width || shape.height !== newBounds.height;
}

},{"196":196,"221":221,"254":254}],194:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ResizeHandles;

var _minDash = _dereq_(254);

var _tinySvg = _dereq_(275);

var _minDom = _dereq_(255);

var _Mouse = _dereq_(243);

var _LayoutUtil = _dereq_(221);

var _SvgTransformUtil = _dereq_(248);

var HANDLE_OFFSET = -2,
    HANDLE_SIZE = 5,
    HANDLE_HIT_SIZE = 20;

var CLS_RESIZER = 'djs-resizer';

/**
 * This component is responsible for adding resize handles.
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {Selection} selection
 * @param {Resize} resize
 */
function ResizeHandles(eventBus, canvas, selection, resize) {

  this._resize = resize;
  this._canvas = canvas;

  var self = this;

  eventBus.on('selection.changed', function (e) {
    var newSelection = e.newSelection;

    // remove old selection markers
    self.removeResizers();

    // add new selection markers ONLY if single selection
    if (newSelection.length === 1) {
      (0, _minDash.forEach)(newSelection, (0, _minDash.bind)(self.addResizer, self));
    }
  });

  eventBus.on('shape.changed', function (e) {
    var shape = e.element;

    if (selection.isSelected(shape)) {
      self.removeResizers();

      self.addResizer(shape);
    }
  });
}

ResizeHandles.prototype.makeDraggable = function (element, gfx, direction) {
  var resize = this._resize;

  function startResize(event) {
    // only trigger on left mouse button
    if ((0, _Mouse.isPrimaryButton)(event)) {
      resize.activate(event, element, direction);
    }
  }

  _minDom.event.bind(gfx, 'mousedown', startResize);
  _minDom.event.bind(gfx, 'touchstart', startResize);
};

ResizeHandles.prototype._createResizer = function (element, x, y, rotation, direction) {
  var resizersParent = this._getResizersParent();

  var group = (0, _tinySvg.create)('g');
  (0, _tinySvg.classes)(group).add(CLS_RESIZER);
  (0, _tinySvg.classes)(group).add(CLS_RESIZER + '-' + element.id);
  (0, _tinySvg.classes)(group).add(CLS_RESIZER + '-' + direction);

  (0, _tinySvg.append)(resizersParent, group);

  var origin = -HANDLE_SIZE + HANDLE_OFFSET;

  // Create four drag indicators on the outline
  var visual = (0, _tinySvg.create)('rect');
  (0, _tinySvg.attr)(visual, {
    x: origin,
    y: origin,
    width: HANDLE_SIZE,
    height: HANDLE_SIZE
  });
  (0, _tinySvg.classes)(visual).add(CLS_RESIZER + '-visual');

  (0, _tinySvg.append)(group, visual);

  var hit = (0, _tinySvg.create)('rect');
  (0, _tinySvg.attr)(hit, {
    x: origin,
    y: origin,
    width: HANDLE_HIT_SIZE,
    height: HANDLE_HIT_SIZE
  });
  (0, _tinySvg.classes)(hit).add(CLS_RESIZER + '-hit');

  (0, _tinySvg.append)(group, hit);

  (0, _SvgTransformUtil.transform)(group, x, y, rotation);

  return group;
};

ResizeHandles.prototype.createResizer = function (element, direction) {
  var resizer;

  var trbl = (0, _LayoutUtil.asTRBL)(element);

  if (direction === 'nw') {
    resizer = this._createResizer(element, trbl.left, trbl.top, 0, direction);
  } else if (direction === 'ne') {
    resizer = this._createResizer(element, trbl.right, trbl.top, 90, direction);
  } else if (direction === 'se') {
    resizer = this._createResizer(element, trbl.right, trbl.bottom, 180, direction);
  } else {
    resizer = this._createResizer(element, trbl.left, trbl.bottom, 270, direction);
  }

  this.makeDraggable(element, resizer, direction);
};

// resize handles implementation ///////////////////////////////

/**
 * Add resizers for a given element.
 *
 * @param {djs.model.Shape} shape
 */
ResizeHandles.prototype.addResizer = function (shape) {
  var resize = this._resize;

  if (!resize.canResize({ shape: shape })) {
    return;
  }

  this.createResizer(shape, 'nw');
  this.createResizer(shape, 'ne');
  this.createResizer(shape, 'se');
  this.createResizer(shape, 'sw');
};

/**
 * Remove all resizers
 */
ResizeHandles.prototype.removeResizers = function () {
  var resizersParent = this._getResizersParent();

  (0, _tinySvg.clear)(resizersParent);
};

ResizeHandles.prototype._getResizersParent = function () {
  return this._canvas.getLayer('resizers');
};

ResizeHandles.$inject = ['eventBus', 'canvas', 'selection', 'resize'];

},{"221":221,"243":243,"248":248,"254":254,"255":255,"275":275}],195:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ResizePreview;

var _tinySvg = _dereq_(275);

var MARKER_RESIZING = 'djs-resizing',
    MARKER_RESIZE_NOT_OK = 'resize-not-ok';

var LOW_PRIORITY = 500;

/**
 * Provides previews for resizing shapes when resizing.
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 * @param {PreviewSupport} previewSupport
 */
function ResizePreview(eventBus, canvas, previewSupport) {

  /**
   * Update resizer frame.
   *
   * @param {Object} context
   */
  function updateFrame(context) {

    var shape = context.shape,
        bounds = context.newBounds,
        frame = context.frame;

    if (!frame) {
      frame = context.frame = previewSupport.addFrame(shape, canvas.getDefaultLayer());

      canvas.addMarker(shape, MARKER_RESIZING);
    }

    if (bounds.width > 5) {
      (0, _tinySvg.attr)(frame, { x: bounds.x, width: bounds.width });
    }

    if (bounds.height > 5) {
      (0, _tinySvg.attr)(frame, { y: bounds.y, height: bounds.height });
    }

    if (context.canExecute) {
      (0, _tinySvg.classes)(frame).remove(MARKER_RESIZE_NOT_OK);
    } else {
      (0, _tinySvg.classes)(frame).add(MARKER_RESIZE_NOT_OK);
    }
  }

  /**
   * Remove resizer frame.
   *
   * @param {Object} context
   */
  function removeFrame(context) {
    var shape = context.shape,
        frame = context.frame;

    if (frame) {
      (0, _tinySvg.remove)(context.frame);
    }

    canvas.removeMarker(shape, MARKER_RESIZING);
  }

  // add and update previews
  eventBus.on('resize.move', LOW_PRIORITY, function (event) {
    updateFrame(event.context);
  });

  // remove previews
  eventBus.on('resize.cleanup', function (event) {
    removeFrame(event.context);
  });
}

ResizePreview.$inject = ['eventBus', 'canvas', 'previewSupport'];

},{"275":275}],196:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.substractTRBL = substractTRBL;
exports.resizeBounds = resizeBounds;
exports.resizeTRBL = resizeTRBL;
exports.reattachPoint = reattachPoint;
exports.ensureConstraints = ensureConstraints;
exports.getMinResizeBounds = getMinResizeBounds;
exports.addPadding = addPadding;
exports.computeChildrenBBox = computeChildrenBBox;

var _minDash = _dereq_(254);

var _Elements = _dereq_(235);

var _LayoutUtil = _dereq_(221);

var max = Math.max,
    min = Math.min;

var DEFAULT_CHILD_BOX_PADDING = 20;

/**
 * Substract a TRBL from another
 *
 * @param  {TRBL} trblA
 * @param  {TRBL} trblB
 *
 * @return {TRBL}
 */
function substractTRBL(trblA, trblB) {
  return {
    top: trblA.top - trblB.top,
    right: trblA.right - trblB.right,
    bottom: trblA.bottom - trblB.bottom,
    left: trblA.left - trblB.left
  };
}

/**
 * Resize the given bounds by the specified delta from a given anchor point.
 *
 * @param {Bounds} bounds the bounding box that should be resized
 * @param {String} direction in which the element is resized (nw, ne, se, sw)
 * @param {Point} delta of the resize operation
 *
 * @return {Bounds} resized bounding box
 */
function resizeBounds(bounds, direction, delta) {

  var dx = delta.x,
      dy = delta.y;

  switch (direction) {

    case 'nw':
      return {
        x: bounds.x + dx,
        y: bounds.y + dy,
        width: bounds.width - dx,
        height: bounds.height - dy
      };

    case 'sw':
      return {
        x: bounds.x + dx,
        y: bounds.y,
        width: bounds.width - dx,
        height: bounds.height + dy
      };

    case 'ne':
      return {
        x: bounds.x,
        y: bounds.y + dy,
        width: bounds.width + dx,
        height: bounds.height - dy
      };

    case 'se':
      return {
        x: bounds.x,
        y: bounds.y,
        width: bounds.width + dx,
        height: bounds.height + dy
      };

    default:
      throw new Error('unrecognized direction: ' + direction);
  }
}

/**
 * Resize the given bounds by applying the passed
 * { top, right, bottom, left } delta.
 *
 * @param {Bounds} bounds
 * @param {TRBL} trblResize
 *
 * @return {Bounds}
 */
function resizeTRBL(bounds, resize) {
  return {
    x: bounds.x + (resize.left || 0),
    y: bounds.y + (resize.top || 0),
    width: bounds.width - (resize.left || 0) + (resize.right || 0),
    height: bounds.height - (resize.top || 0) + (resize.bottom || 0)
  };
}

function reattachPoint(bounds, newBounds, point) {

  var sx = bounds.width / newBounds.width,
      sy = bounds.height / newBounds.height;

  return {
    x: Math.round(newBounds.x + newBounds.width / 2) - Math.floor((bounds.x + bounds.width / 2 - point.x) / sx),
    y: Math.round(newBounds.y + newBounds.height / 2) - Math.floor((bounds.y + bounds.height / 2 - point.y) / sy)
  };
}

function applyConstraints(attr, trbl, resizeConstraints) {

  var value = trbl[attr],
      minValue = resizeConstraints.min && resizeConstraints.min[attr],
      maxValue = resizeConstraints.max && resizeConstraints.max[attr];

  if ((0, _minDash.isNumber)(minValue)) {
    value = (/top|left/.test(attr) ? min : max)(value, minValue);
  }

  if ((0, _minDash.isNumber)(maxValue)) {
    value = (/top|left/.test(attr) ? max : min)(value, maxValue);
  }

  return value;
}

function ensureConstraints(currentBounds, resizeConstraints) {

  if (!resizeConstraints) {
    return currentBounds;
  }

  var currentTrbl = (0, _LayoutUtil.asTRBL)(currentBounds);

  return (0, _LayoutUtil.asBounds)({
    top: applyConstraints('top', currentTrbl, resizeConstraints),
    right: applyConstraints('right', currentTrbl, resizeConstraints),
    bottom: applyConstraints('bottom', currentTrbl, resizeConstraints),
    left: applyConstraints('left', currentTrbl, resizeConstraints)
  });
}

function getMinResizeBounds(direction, currentBounds, minDimensions, childrenBounds) {

  var currentBox = (0, _LayoutUtil.asTRBL)(currentBounds);

  var minBox = {
    top: /n/.test(direction) ? currentBox.bottom - minDimensions.height : currentBox.top,
    left: /w/.test(direction) ? currentBox.right - minDimensions.width : currentBox.left,
    bottom: /s/.test(direction) ? currentBox.top + minDimensions.height : currentBox.bottom,
    right: /e/.test(direction) ? currentBox.left + minDimensions.width : currentBox.right
  };

  var childrenBox = childrenBounds ? (0, _LayoutUtil.asTRBL)(childrenBounds) : minBox;

  var combinedBox = {
    top: min(minBox.top, childrenBox.top),
    left: min(minBox.left, childrenBox.left),
    bottom: max(minBox.bottom, childrenBox.bottom),
    right: max(minBox.right, childrenBox.right)
  };

  return (0, _LayoutUtil.asBounds)(combinedBox);
}

function asPadding(mayBePadding, defaultValue) {
  if (typeof mayBePadding !== 'undefined') {
    return mayBePadding;
  } else {
    return DEFAULT_CHILD_BOX_PADDING;
  }
}

function addPadding(bbox, padding) {
  var left, right, top, bottom;

  if ((typeof padding === 'undefined' ? 'undefined' : _typeof(padding)) === 'object') {
    left = asPadding(padding.left);
    right = asPadding(padding.right);
    top = asPadding(padding.top);
    bottom = asPadding(padding.bottom);
  } else {
    left = right = top = bottom = asPadding(padding);
  }

  return {
    x: bbox.x - left,
    y: bbox.y - top,
    width: bbox.width + left + right,
    height: bbox.height + top + bottom
  };
}

/**
 * Is the given element part of the resize
 * targets min boundary box?
 *
 * This is the default implementation which excludes
 * connections and labels.
 *
 * @param {djs.model.Base} element
 */
function isBBoxChild(element) {

  // exclude connections
  if (element.waypoints) {
    return false;
  }

  // exclude labels
  if (element.type === 'label') {
    return false;
  }

  return true;
}

/**
 * Return children bounding computed from a shapes children
 * or a list of prefiltered children.
 *
 * @param  {djs.model.Shape|Array<djs.model.Shape>} shapeOrChildren
 * @param  {Number|Object} padding
 *
 * @return {Bounds}
 */
function computeChildrenBBox(shapeOrChildren, padding) {

  var elements;

  // compute based on shape
  if (shapeOrChildren.length === undefined) {
    // grab all the children that are part of the
    // parents children box
    elements = (0, _minDash.filter)(shapeOrChildren.children, isBBoxChild);
  } else {
    elements = shapeOrChildren;
  }

  if (elements.length) {
    return addPadding((0, _Elements.getBBox)(elements), padding);
  }
}

},{"221":221,"235":235,"254":254}],197:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _rules = _dereq_(200);

var _rules2 = _interopRequireDefault(_rules);

var _dragging = _dereq_(131);

var _dragging2 = _interopRequireDefault(_dragging);

var _previewSupport = _dereq_(190);

var _previewSupport2 = _interopRequireDefault(_previewSupport);

var _Resize = _dereq_(193);

var _Resize2 = _interopRequireDefault(_Resize);

var _ResizePreview = _dereq_(195);

var _ResizePreview2 = _interopRequireDefault(_ResizePreview);

var _ResizeHandles = _dereq_(194);

var _ResizeHandles2 = _interopRequireDefault(_ResizeHandles);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_rules2.default, _dragging2.default, _previewSupport2.default],
  __init__: ['resize', 'resizePreview', 'resizeHandles'],
  resize: ['type', _Resize2.default],
  resizePreview: ['type', _ResizePreview2.default],
  resizeHandles: ['type', _ResizeHandles2.default]
};

},{"131":131,"190":190,"193":193,"194":194,"195":195,"200":200}],198:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RuleProvider;

var _inherits = _dereq_(253);

var _inherits2 = _interopRequireDefault(_inherits);

var _CommandInterceptor = _dereq_(91);

var _CommandInterceptor2 = _interopRequireDefault(_CommandInterceptor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A basic provider that may be extended to implement modeling rules.
 *
 * Extensions should implement the init method to actually add their custom
 * modeling checks. Checks may be added via the #addRule(action, fn) method.
 *
 * @param {EventBus} eventBus
 */
function RuleProvider(eventBus) {
  _CommandInterceptor2.default.call(this, eventBus);

  this.init();
}

RuleProvider.$inject = ['eventBus'];

(0, _inherits2.default)(RuleProvider, _CommandInterceptor2.default);

/**
 * Adds a modeling rule for the given action, implemented through
 * a callback function.
 *
 * The function will receive the modeling specific action context
 * to perform its check. It must return `false` to disallow the
 * action from happening or `true` to allow the action.
 *
 * A rule provider may pass over the evaluation to lower priority
 * rules by returning return nothing (or <code>undefined</code>).
 *
 * @example
 *
 * ResizableRules.prototype.init = function() {
 *
 *   \/**
 *    * Return `true`, `false` or nothing to denote
 *    * _allowed_, _not allowed_ and _continue evaluating_.
 *    *\/
 *   this.addRule('shape.resize', function(context) {
 *
 *     var shape = context.shape;
 *
 *     if (!context.newBounds) {
 *       // check general resizability
 *       if (!shape.resizable) {
 *         return false;
 *       }
 *
 *       // not returning anything (read: undefined)
 *       // will continue the evaluation of other rules
 *       // (with lower priority)
 *       return;
 *     } else {
 *       // element must have minimum size of 10*10 points
 *       return context.newBounds.width > 10 && context.newBounds.height > 10;
 *     }
 *   });
 * };
 *
 * @param {String|Array<String>} actions the identifier for the modeling action to check
 * @param {Number} [priority] the priority at which this rule is being applied
 * @param {Function} fn the callback function that performs the actual check
 */
RuleProvider.prototype.addRule = function (actions, priority, fn) {

  var self = this;

  if (typeof actions === 'string') {
    actions = [actions];
  }

  actions.forEach(function (action) {

    self.canExecute(action, priority, function (context, action, event) {
      return fn(context);
    }, true);
  });
};

/**
 * Implement this method to add new rules during provider initialization.
 */
RuleProvider.prototype.init = function () {};

},{"253":253,"91":91}],199:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Rules;
/**
 * A service that provides rules for certain diagram actions.
 *
 * The default implementation will hook into the {@link CommandStack}
 * to perform the actual rule evaluation. Make sure to provide the
 * `commandStack` service with this module if you plan to use it.
 *
 * Together with this implementation you may use the {@link RuleProvider}
 * to implement your own rule checkers.
 *
 * This module is ment to be easily replaced, thus the tiny foot print.
 *
 * @param {Injector} injector
 */
function Rules(injector) {
  this._commandStack = injector.get('commandStack', false);
}

Rules.$inject = ['injector'];

/**
 * Returns whether or not a given modeling action can be executed
 * in the specified context.
 *
 * This implementation will respond with allow unless anyone
 * objects.
 *
 * @param {String} action the action to be checked
 * @param {Object} [context] the context to check the action in
 *
 * @return {Boolean} returns true, false or null depending on whether the
 *                   operation is allowed, not allowed or should be ignored.
 */
Rules.prototype.allowed = function (action, context) {
  var allowed = true;

  var commandStack = this._commandStack;

  if (commandStack) {
    allowed = commandStack.canExecute(action, context);
  }

  // map undefined to true, i.e. no rules
  return allowed === undefined ? true : allowed;
};

},{}],200:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _Rules = _dereq_(199);

var _Rules2 = _interopRequireDefault(_Rules);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['rules'],
  rules: ['type', _Rules2.default]
};

},{"199":199}],201:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SearchPad;

var _minDom = _dereq_(255);

var _Elements = _dereq_(235);

var _EscapeUtil = _dereq_(236);

/**
 * Provides searching infrastructure
 */
function SearchPad(canvas, eventBus, overlays, selection) {
  this._open = false;
  this._results = [];
  this._eventMaps = [];

  this._canvas = canvas;
  this._eventBus = eventBus;
  this._overlays = overlays;
  this._selection = selection;

  // setup elements
  this._container = (0, _minDom.domify)(SearchPad.BOX_HTML);
  this._searchInput = (0, _minDom.query)(SearchPad.INPUT_SELECTOR, this._container);
  this._resultsContainer = (0, _minDom.query)(SearchPad.RESULTS_CONTAINER_SELECTOR, this._container);

  // attach search pad
  this._canvas.getContainer().appendChild(this._container);

  // cleanup on destroy
  eventBus.on(['canvas.destroy', 'diagram.destroy'], this.close, this);
}

SearchPad.$inject = ['canvas', 'eventBus', 'overlays', 'selection'];

/**
 * Binds and keeps track of all event listereners
 */
SearchPad.prototype._bindEvents = function () {
  var self = this;

  function listen(el, selector, type, fn) {
    self._eventMaps.push({
      el: el,
      type: type,
      listener: _minDom.delegate.bind(el, selector, type, fn)
    });
  }

  // close search on clicking anywhere outside
  listen(document, 'html', 'click', function (e) {
    self.close();
  }, true);

  // stop event from propagating and closing search
  // focus on input
  listen(this._container, SearchPad.INPUT_SELECTOR, 'click', function (e) {
    e.stopPropagation();
    e.delegateTarget.focus();
  });

  // preselect result on hover
  listen(this._container, SearchPad.RESULT_SELECTOR, 'mouseover', function (e) {
    e.stopPropagation();
    self._scrollToNode(e.delegateTarget);
    self._preselect(e.delegateTarget);
  });

  // selects desired result on mouse click
  listen(this._container, SearchPad.RESULT_SELECTOR, 'click', function (e) {
    e.stopPropagation();
    self._select(e.delegateTarget);
  });

  // prevent cursor in input from going left and right when using up/down to
  // navigate results
  listen(this._container, SearchPad.INPUT_SELECTOR, 'keydown', function (e) {
    // up
    if (e.keyCode === 38) {
      e.preventDefault();
    }

    // down
    if (e.keyCode === 40) {
      e.preventDefault();
    }
  });

  // handle keyboard input
  listen(this._container, SearchPad.INPUT_SELECTOR, 'keyup', function (e) {
    // escape
    if (e.keyCode === 27) {
      return self.close();
    }

    // enter
    if (e.keyCode === 13) {
      var selected = self._getCurrentResult();

      return selected ? self._select(selected) : self.close();
    }

    // up
    if (e.keyCode === 38) {
      return self._scrollToDirection(true);
    }

    // down
    if (e.keyCode === 40) {
      return self._scrollToDirection();
    }

    // left && right
    // do not search while navigating text input
    if (e.keyCode === 37 || e.keyCode === 39) {
      return;
    }

    // anything else
    self._search(e.delegateTarget.value);
  });
};

/**
 * Unbinds all previously established listeners
 */
SearchPad.prototype._unbindEvents = function () {
  this._eventMaps.forEach(function (m) {
    _minDom.delegate.unbind(m.el, m.type, m.listener);
  });
};

/**
 * Performs a search for the given pattern.
 *
 * @param  {String} pattern
 */
SearchPad.prototype._search = function (pattern) {
  var self = this;

  this._clearResults();

  // do not search on empty query
  if (!pattern || pattern === '') {
    return;
  }

  var searchResults = this._searchProvider.find(pattern);

  if (!searchResults.length) {
    return;
  }

  // append new results
  searchResults.forEach(function (result) {
    var id = result.element.id;
    var node = self._createResultNode(result, id);
    self._results[id] = {
      element: result.element,
      node: node
    };
  });

  // preselect first result
  var node = (0, _minDom.query)(SearchPad.RESULT_SELECTOR, this._resultsContainer);
  this._scrollToNode(node);
  this._preselect(node);
};

/**
 * Navigate to the previous/next result. Defaults to next result.
 * @param  {Boolean} previous
 */
SearchPad.prototype._scrollToDirection = function (previous) {
  var selected = this._getCurrentResult();
  if (!selected) {
    return;
  }

  var node = previous ? selected.previousElementSibling : selected.nextElementSibling;
  if (node) {
    this._scrollToNode(node);
    this._preselect(node);
  }
};

/**
 * Scroll to the node if it is not visible.
 *
 * @param  {Element} node
 */
SearchPad.prototype._scrollToNode = function (node) {
  if (!node || node === this._getCurrentResult()) {
    return;
  }

  var nodeOffset = node.offsetTop;
  var containerScroll = this._resultsContainer.scrollTop;

  var bottomScroll = nodeOffset - this._resultsContainer.clientHeight + node.clientHeight;

  if (nodeOffset < containerScroll) {
    this._resultsContainer.scrollTop = nodeOffset;
  } else if (containerScroll < bottomScroll) {
    this._resultsContainer.scrollTop = bottomScroll;
  }
};

/**
 * Clears all results data.
 */
SearchPad.prototype._clearResults = function () {
  (0, _minDom.clear)(this._resultsContainer);

  this._results = [];

  this._resetOverlay();

  this._eventBus.fire('searchPad.cleared');
};

/**
 * Get currently selected result.
 *
 * @return {Element}
 */
SearchPad.prototype._getCurrentResult = function () {
  return (0, _minDom.query)(SearchPad.RESULT_SELECTED_SELECTOR, this._resultsContainer);
};

/**
 * Create result DOM element within results container
 * that corresponds to a search result.
 *
 * 'result' : one of the elements returned by SearchProvider
 * 'id' : id attribute value to assign to the new DOM node
 * return : created DOM element
 *
 * @param  {SearchResult} result
 * @param  {String} id
 * @return {Element}
 */
SearchPad.prototype._createResultNode = function (result, id) {
  var node = (0, _minDom.domify)(SearchPad.RESULT_HTML);

  // create only if available
  if (result.primaryTokens.length > 0) {
    createInnerTextNode(node, result.primaryTokens, SearchPad.RESULT_PRIMARY_HTML);
  }

  // secondary tokens (represent element ID) are allways available
  createInnerTextNode(node, result.secondaryTokens, SearchPad.RESULT_SECONDARY_HTML);

  (0, _minDom.attr)(node, SearchPad.RESULT_ID_ATTRIBUTE, id);

  this._resultsContainer.appendChild(node);

  return node;
};

/**
 * Register search element provider.
 *
 * SearchProvider.find - provides search function over own elements
 *  (pattern) => [{ text: <String>, element: <Element>}, ...]
 *
 * @param  {SearchProvider} provider
 */
SearchPad.prototype.registerProvider = function (provider) {
  this._searchProvider = provider;
};

/**
 * Open search pad.
 */
SearchPad.prototype.open = function () {
  if (!this._searchProvider) {
    throw new Error('no search provider registered');
  }

  if (this.isOpen()) {
    return;
  }

  this._bindEvents();

  this._open = true;

  (0, _minDom.classes)(this._container).add('open');

  this._searchInput.focus();

  this._eventBus.fire('searchPad.opened');
};

/**
 * Close search pad.
 */
SearchPad.prototype.close = function () {
  if (!this.isOpen()) {
    return;
  }

  this._unbindEvents();

  this._open = false;

  (0, _minDom.classes)(this._container).remove('open');

  this._clearResults();

  this._searchInput.value = '';
  this._searchInput.blur();

  this._resetOverlay();

  this._eventBus.fire('searchPad.closed');
};

/**
 * Toggles search pad on/off.
 */
SearchPad.prototype.toggle = function () {
  this.isOpen() ? this.close() : this.open();
};

/**
 * Report state of search pad.
 */
SearchPad.prototype.isOpen = function () {
  return this._open;
};

/**
 * Preselect result entry.
 *
 * @param  {Element} element
 */
SearchPad.prototype._preselect = function (node) {
  var selectedNode = this._getCurrentResult();

  // already selected
  if (node === selectedNode) {
    return;
  }

  // removing preselection from current node
  if (selectedNode) {
    (0, _minDom.classes)(selectedNode).remove(SearchPad.RESULT_SELECTED_CLASS);
  }

  var id = (0, _minDom.attr)(node, SearchPad.RESULT_ID_ATTRIBUTE);
  var element = this._results[id].element;

  (0, _minDom.classes)(node).add(SearchPad.RESULT_SELECTED_CLASS);

  this._resetOverlay(element);

  this._centerViewbox(element);

  this._selection.select(element);

  this._eventBus.fire('searchPad.preselected', element);
};

/**
 * Select result node.
 *
 * @param  {Element} element
 */
SearchPad.prototype._select = function (node) {
  var id = (0, _minDom.attr)(node, SearchPad.RESULT_ID_ATTRIBUTE);
  var element = this._results[id].element;

  this.close();

  this._resetOverlay();

  this._centerViewbox(element);

  this._selection.select(element);

  this._eventBus.fire('searchPad.selected', element);
};

/**
 * Center viewbox on the element middle point.
 *
 * @param  {Element} element
 */
SearchPad.prototype._centerViewbox = function (element) {
  var viewbox = this._canvas.viewbox();

  var box = (0, _Elements.getBBox)(element);

  var newViewbox = {
    x: box.x + box.width / 2 - viewbox.outer.width / 2,
    y: box.y + box.height / 2 - viewbox.outer.height / 2,
    width: viewbox.outer.width,
    height: viewbox.outer.height
  };

  this._canvas.viewbox(newViewbox);

  this._canvas.zoom(viewbox.scale);
};

/**
 * Reset overlay removes and, optionally, set
 * overlay to a new element.
 *
 * @param  {Element} element
 */
SearchPad.prototype._resetOverlay = function (element) {
  if (this._overlayId) {
    this._overlays.remove(this._overlayId);
  }

  if (element) {
    var box = (0, _Elements.getBBox)(element);
    var overlay = constructOverlay(box);
    this._overlayId = this._overlays.add(element, overlay);
  }
};

/**
 * Construct overlay object for the given bounding box.
 *
 * @param  {BoundingBox} box
 * @return {Object}
 */
function constructOverlay(box) {

  var offset = 6;
  var w = box.width + offset * 2;
  var h = box.height + offset * 2;

  var styles = ['width: ' + w + 'px', 'height: ' + h + 'px'].join('; ');

  return {
    position: {
      bottom: h - offset,
      right: w - offset
    },
    show: true,
    html: '<div style="' + styles + '" class="' + SearchPad.OVERLAY_CLASS + '"></div>'
  };
}

/**
 * Creates and appends child node from result tokens and HTML template.
 *
 * @param  {Element} node
 * @param  {Array<Object>} tokens
 * @param  {String} template
 */
function createInnerTextNode(parentNode, tokens, template) {
  var text = createHtmlText(tokens);
  var childNode = (0, _minDom.domify)(template);
  childNode.innerHTML = text;
  parentNode.appendChild(childNode);
}

/**
 * Create internal HTML markup from result tokens.
 * Caters for highlighting pattern matched tokens.
 *
 * @param  {Array<Object>} tokens
 * @return {String}
 */
function createHtmlText(tokens) {
  var htmlText = '';

  tokens.forEach(function (t) {
    if (t.matched) {
      htmlText += '<strong class="' + SearchPad.RESULT_HIGHLIGHT_CLASS + '">' + (0, _EscapeUtil.escapeHTML)(t.matched) + '</strong>';
    } else {
      htmlText += (0, _EscapeUtil.escapeHTML)(t.normal);
    }
  });

  return htmlText !== '' ? htmlText : null;
}

/**
 * CONSTANTS
 */
SearchPad.CONTAINER_SELECTOR = '.djs-search-container';
SearchPad.INPUT_SELECTOR = '.djs-search-input input';
SearchPad.RESULTS_CONTAINER_SELECTOR = '.djs-search-results';
SearchPad.RESULT_SELECTOR = '.djs-search-result';
SearchPad.RESULT_SELECTED_CLASS = 'djs-search-result-selected';
SearchPad.RESULT_SELECTED_SELECTOR = '.' + SearchPad.RESULT_SELECTED_CLASS;
SearchPad.RESULT_ID_ATTRIBUTE = 'data-result-id';
SearchPad.RESULT_HIGHLIGHT_CLASS = 'djs-search-highlight';
SearchPad.OVERLAY_CLASS = 'djs-search-overlay';

SearchPad.BOX_HTML = '<div class="djs-search-container djs-draggable djs-scrollable">' + '<div class="djs-search-input">' + '<input type="text"/>' + '</div>' + '<div class="djs-search-results"></div>' + '</div>';

SearchPad.RESULT_HTML = '<div class="djs-search-result"></div>';

SearchPad.RESULT_PRIMARY_HTML = '<div class="djs-search-result-primary"></div>';

SearchPad.RESULT_SECONDARY_HTML = '<p class="djs-search-result-secondary"></p>';

},{"235":235,"236":236,"255":255}],202:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _overlays = _dereq_(184);

var _overlays2 = _interopRequireDefault(_overlays);

var _selection = _dereq_(206);

var _selection2 = _interopRequireDefault(_selection);

var _SearchPad = _dereq_(201);

var _SearchPad2 = _interopRequireDefault(_SearchPad);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_overlays2.default, _selection2.default],
  searchPad: ['type', _SearchPad2.default]
};

},{"184":184,"201":201,"206":206}],203:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Selection;

var _minDash = _dereq_(254);

/**
 * A service that offers the current selection in a diagram.
 * Offers the api to control the selection, too.
 *
 * @class
 *
 * @param {EventBus} eventBus the event bus
 */
function Selection(eventBus) {

  this._eventBus = eventBus;

  this._selectedElements = [];

  var self = this;

  eventBus.on(['shape.remove', 'connection.remove'], function (e) {
    var element = e.element;
    self.deselect(element);
  });

  eventBus.on(['diagram.clear'], function (e) {
    self.select(null);
  });
}

Selection.$inject = ['eventBus'];

Selection.prototype.deselect = function (element) {
  var selectedElements = this._selectedElements;

  var idx = selectedElements.indexOf(element);

  if (idx !== -1) {
    var oldSelection = selectedElements.slice();

    selectedElements.splice(idx, 1);

    this._eventBus.fire('selection.changed', { oldSelection: oldSelection, newSelection: selectedElements });
  }
};

Selection.prototype.get = function () {
  return this._selectedElements;
};

Selection.prototype.isSelected = function (element) {
  return this._selectedElements.indexOf(element) !== -1;
};

/**
 * This method selects one or more elements on the diagram.
 *
 * By passing an additional add parameter you can decide whether or not the element(s)
 * should be added to the already existing selection or not.
 *
 * @method Selection#select
 *
 * @param  {Object|Object[]} elements element or array of elements to be selected
 * @param  {boolean} [add] whether the element(s) should be appended to the current selection, defaults to false
 */
Selection.prototype.select = function (elements, add) {
  var selectedElements = this._selectedElements,
      oldSelection = selectedElements.slice();

  if (!(0, _minDash.isArray)(elements)) {
    elements = elements ? [elements] : [];
  }

  // selection may be cleared by passing an empty array or null
  // to the method
  if (add) {
    (0, _minDash.forEach)(elements, function (element) {
      if (selectedElements.indexOf(element) !== -1) {
        // already selected
        return;
      } else {
        selectedElements.push(element);
      }
    });
  } else {
    this._selectedElements = selectedElements = elements.slice();
  }

  this._eventBus.fire('selection.changed', { oldSelection: oldSelection, newSelection: selectedElements });
};

},{"254":254}],204:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SelectionBehavior;

var _Mouse = _dereq_(243);

var _minDash = _dereq_(254);

function SelectionBehavior(eventBus, selection, canvas, elementRegistry) {

  eventBus.on('create.end', 500, function (e) {

    // select the created shape after a
    // successful create operation
    if (e.context.canExecute) {
      selection.select(e.context.shape);
    }
  });

  eventBus.on('connect.end', 500, function (e) {

    // select the connect end target
    // after a connect operation
    if (e.context.canExecute && e.context.target) {
      selection.select(e.context.target);
    }
  });

  eventBus.on('shape.move.end', 500, function (e) {
    var previousSelection = e.previousSelection || [];

    var shape = elementRegistry.get(e.context.shape.id);

    // make sure at least the main moved element is being
    // selected after a move operation
    var inSelection = (0, _minDash.find)(previousSelection, function (selectedShape) {
      return shape.id === selectedShape.id;
    });

    if (!inSelection) {
      selection.select(shape);
    }
  });

  // Shift + click selection
  eventBus.on('element.click', function (event) {

    var element = event.element;

    // do not select the root element
    // or connections
    if (element === canvas.getRootElement()) {
      element = null;
    }

    var isSelected = selection.isSelected(element),
        isMultiSelect = selection.get().length > 1;

    // mouse-event: SELECTION_KEY
    var add = (0, _Mouse.hasPrimaryModifier)(event);

    // select OR deselect element in multi selection
    if (isSelected && isMultiSelect) {
      if (add) {
        return selection.deselect(element);
      } else {
        return selection.select(element);
      }
    } else if (!isSelected) {
      selection.select(element, add);
    } else {
      selection.deselect(element);
    }
  });
}

SelectionBehavior.$inject = ['eventBus', 'selection', 'canvas', 'elementRegistry'];

},{"243":243,"254":254}],205:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SelectionVisuals;

var _minDash = _dereq_(254);

var MARKER_HOVER = 'hover',
    MARKER_SELECTED = 'selected';

/**
 * A plugin that adds a visible selection UI to shapes and connections
 * by appending the <code>hover</code> and <code>selected</code> classes to them.
 *
 * @class
 *
 * Makes elements selectable, too.
 *
 * @param {EventBus} events
 * @param {SelectionService} selection
 * @param {Canvas} canvas
 */
function SelectionVisuals(events, canvas, selection, styles) {

  this._multiSelectionBox = null;

  function addMarker(e, cls) {
    canvas.addMarker(e, cls);
  }

  function removeMarker(e, cls) {
    canvas.removeMarker(e, cls);
  }

  events.on('element.hover', function (event) {
    addMarker(event.element, MARKER_HOVER);
  });

  events.on('element.out', function (event) {
    removeMarker(event.element, MARKER_HOVER);
  });

  events.on('selection.changed', function (event) {

    function deselect(s) {
      removeMarker(s, MARKER_SELECTED);
    }

    function select(s) {
      addMarker(s, MARKER_SELECTED);
    }

    var oldSelection = event.oldSelection,
        newSelection = event.newSelection;

    (0, _minDash.forEach)(oldSelection, function (e) {
      if (newSelection.indexOf(e) === -1) {
        deselect(e);
      }
    });

    (0, _minDash.forEach)(newSelection, function (e) {
      if (oldSelection.indexOf(e) === -1) {
        select(e);
      }
    });
  });
}

SelectionVisuals.$inject = ['eventBus', 'canvas', 'selection', 'styles'];

},{"254":254}],206:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _interactionEvents = _dereq_(139);

var _interactionEvents2 = _interopRequireDefault(_interactionEvents);

var _outline = _dereq_(182);

var _outline2 = _interopRequireDefault(_outline);

var _Selection = _dereq_(203);

var _Selection2 = _interopRequireDefault(_Selection);

var _SelectionVisuals = _dereq_(205);

var _SelectionVisuals2 = _interopRequireDefault(_SelectionVisuals);

var _SelectionBehavior = _dereq_(204);

var _SelectionBehavior2 = _interopRequireDefault(_SelectionBehavior);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['selectionVisuals', 'selectionBehavior'],
  __depends__: [_interactionEvents2.default, _outline2.default],
  selection: ['type', _Selection2.default],
  selectionVisuals: ['type', _SelectionVisuals2.default],
  selectionBehavior: ['type', _SelectionBehavior2.default]
};

},{"139":139,"182":182,"203":203,"204":204,"205":205}],207:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CreateMoveSnapping;

var _SnapContext = _dereq_(209);

var _SnapContext2 = _interopRequireDefault(_SnapContext);

var _SnapUtil = _dereq_(210);

var _KeyboardUtil = _dereq_(144);

var _minDash = _dereq_(254);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HIGHER_PRIORITY = 1250;

/**
 * Snap during create and move.
 *
 * @param {EventBus} eventBus
 * @param {Snapping} snapping
 */
function CreateMoveSnapping(eventBus, snapping) {
  var self = this;

  eventBus.on(['create.start', 'shape.move.start'], function (event) {
    self.initSnap(event);
  });

  eventBus.on(['create.move', 'create.end', 'shape.move.move', 'shape.move.end'], HIGHER_PRIORITY, function (event) {
    var context = event.context,
        shape = context.shape,
        snapContext = context.snapContext,
        target = context.target;

    if (event.originalEvent && (0, _KeyboardUtil.isCmd)(event.originalEvent)) {
      return;
    }

    if ((0, _SnapUtil.isSnapped)(event) || !target) {
      return;
    }

    var snapPoints = snapContext.pointsForTarget(target);

    if (!snapPoints.initialized) {
      snapPoints = self.addSnapTargetPoints(snapPoints, shape, target);

      snapPoints.initialized = true;
    }

    snapping.snap(event, snapPoints);
  });

  eventBus.on(['create.cleanup', 'shape.move.cleanup'], function () {
    snapping.hide();
  });
}

CreateMoveSnapping.$inject = ['eventBus', 'snapping'];

CreateMoveSnapping.prototype.initSnap = function (event) {
  var context = event.context,
      shape = context.shape,
      snapContext = context.snapContext;

  if (!snapContext) {
    snapContext = context.snapContext = new _SnapContext2.default();
  }

  var shapeMid = (0, _SnapUtil.mid)(shape, event),
      shapeTopLeft = {
    x: shapeMid.x - shape.width / 2,
    y: shapeMid.y - shape.height / 2
  },
      shapeBottomRight = {
    x: shapeMid.x + shape.width / 2,
    y: shapeMid.y + shape.height / 2
  };

  snapContext.setSnapOrigin('mid', {
    x: shapeMid.x - event.x,
    y: shapeMid.y - event.y
  });

  // snap labels to mid only
  if (isLabel(shape)) {
    return snapContext;
  }

  snapContext.setSnapOrigin('top-left', {
    x: shapeTopLeft.x - event.x,
    y: shapeTopLeft.y - event.y
  });

  snapContext.setSnapOrigin('bottom-right', {
    x: shapeBottomRight.x - event.x,
    y: shapeBottomRight.y - event.y
  });

  return snapContext;
};

CreateMoveSnapping.prototype.addSnapTargetPoints = function (snapPoints, shape, target) {
  var snapTargets = this.getSnapTargets(shape, target);

  (0, _minDash.forEach)(snapTargets, function (snapTarget) {

    // handle labels
    if (isLabel(snapTarget)) {

      if (isLabel(shape)) {
        snapPoints.add('mid', (0, _SnapUtil.mid)(snapTarget));
      }

      return;
    }

    // handle connections
    if (isConnection(snapTarget)) {

      // ignore single segment connections
      if (snapTarget.waypoints.length < 3) {
        return;
      }

      // ignore first and last waypoint
      var waypoints = snapTarget.waypoints.slice(1, -1);

      (0, _minDash.forEach)(waypoints, function (waypoint) {
        snapPoints.add('mid', waypoint);
      });

      return;
    }

    // handle shapes
    snapPoints.add('mid', (0, _SnapUtil.mid)(snapTarget));
  });

  if (!(0, _minDash.isNumber)(shape.x) || !(0, _minDash.isNumber)(shape.y)) {
    return snapPoints;
  }

  snapPoints.add('mid', (0, _SnapUtil.mid)(shape));

  return snapPoints;
};

CreateMoveSnapping.prototype.getSnapTargets = function (shape, target) {
  return (0, _SnapUtil.getChildren)(target).filter(function (child) {
    return !isHidden(child);
  });
};

// helpers //////////

function isConnection(element) {
  return !!element.waypoints;
}

function isHidden(element) {
  return !!element.hidden;
}

function isLabel(element) {
  return !!element.labelTarget;
}

},{"144":144,"209":209,"210":210,"254":254}],208:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ResizeSnapping;

var _SnapContext = _dereq_(209);

var _SnapContext2 = _interopRequireDefault(_SnapContext);

var _SnapUtil = _dereq_(210);

var _KeyboardUtil = _dereq_(144);

var _minDash = _dereq_(254);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HIGHER_PRIORITY = 1250;

/**
 * Snap during resize.
 *
 * @param {EventBus} eventBus
 * @param {Snapping} snapping
 */
function ResizeSnapping(eventBus, snapping) {
  var self = this;

  eventBus.on(['resize.start'], function (event) {
    self.initSnap(event);
  });

  eventBus.on(['resize.move', 'resize.end'], HIGHER_PRIORITY, function (event) {
    var context = event.context,
        shape = context.shape,
        parent = shape.parent,
        direction = context.direction,
        snapContext = context.snapContext;

    if (event.originalEvent && (0, _KeyboardUtil.isCmd)(event.originalEvent)) {
      return;
    }

    if ((0, _SnapUtil.isSnapped)(event)) {
      return;
    }

    var snapPoints = snapContext.pointsForTarget(parent);

    if (!snapPoints.initialized) {
      snapPoints = self.addSnapTargetPoints(snapPoints, shape, parent, direction);

      snapPoints.initialized = true;
    }

    snapping.snap(event, snapPoints);
  });

  eventBus.on(['resize.cleanup'], function () {
    snapping.hide();
  });
}

ResizeSnapping.prototype.initSnap = function (event) {
  var context = event.context,
      shape = context.shape,
      direction = context.direction,
      snapContext = context.snapContext;

  if (!snapContext) {
    snapContext = context.snapContext = new _SnapContext2.default();
  }

  var snapCorner = getCorner(shape, direction);

  snapContext.setSnapOrigin('corner', {
    x: snapCorner.x - event.x,
    y: snapCorner.y - event.y
  });

  return snapContext;
};

ResizeSnapping.prototype.addSnapTargetPoints = function (snapPoints, shape, target, direction) {
  var snapTargets = this.getSnapTargets(shape, target);

  (0, _minDash.forEach)(snapTargets, function (snapTarget) {
    snapPoints.add('corner', (0, _SnapUtil.bottomRight)(snapTarget));
    snapPoints.add('corner', (0, _SnapUtil.topLeft)(snapTarget));
  });

  snapPoints.add('corner', getCorner(shape, direction));

  return snapPoints;
};

ResizeSnapping.$inject = ['eventBus', 'snapping'];

ResizeSnapping.prototype.getSnapTargets = function (shape, target) {
  return (0, _SnapUtil.getChildren)(target).filter(function (child) {
    return !isAttached(child, shape) && !isConnection(child) && !isHidden(child) && !isLabel(child);
  });
};

// helpers //////////

function getCorner(shape, direction) {
  if (direction === 'nw') {
    return (0, _SnapUtil.topLeft)(shape);
  } else if (direction === 'ne') {
    return (0, _SnapUtil.topRight)(shape);
  } else if (direction === 'sw') {
    return (0, _SnapUtil.bottomLeft)(shape);
  } else {
    return (0, _SnapUtil.bottomRight)(shape);
  }
}

function isAttached(element, host) {
  return element.host === host;
}

function isConnection(element) {
  return !!element.waypoints;
}

function isHidden(element) {
  return !!element.hidden;
}

function isLabel(element) {
  return !!element.labelTarget;
}

},{"144":144,"209":209,"210":210,"254":254}],209:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SnapContext;
exports.SnapPoints = SnapPoints;

var _minDash = _dereq_(254);

var _SnapUtil = _dereq_(210);

/**
 * A snap context, containing the (possibly incomplete)
 * mappings of drop targets (to identify the snapping)
 * to computed snap points.
 */
function SnapContext() {

  /**
   * Map<String, SnapPoints> mapping drop targets to
   * a list of possible snappings.
   *
   * @type {Object}
   */
  this._targets = {};

  /**
   * Map<String, Point> initial positioning of element
   * regarding various snap directions.
   *
   * @type {Object}
   */
  this._snapOrigins = {};

  /**
   * List of snap locations
   *
   * @type {Array<String>}
   */
  this._snapLocations = [];

  /**
   * Map<String, Array<Point>> of default snapping locations
   *
   * @type {Object}
   */
  this._defaultSnaps = {};
}

SnapContext.prototype.getSnapOrigin = function (snapLocation) {
  return this._snapOrigins[snapLocation];
};

SnapContext.prototype.setSnapOrigin = function (snapLocation, initialValue) {
  this._snapOrigins[snapLocation] = initialValue;

  if (this._snapLocations.indexOf(snapLocation) === -1) {
    this._snapLocations.push(snapLocation);
  }
};

SnapContext.prototype.addDefaultSnap = function (type, point) {

  var snapValues = this._defaultSnaps[type];

  if (!snapValues) {
    snapValues = this._defaultSnaps[type] = [];
  }

  snapValues.push(point);
};

/**
 * Return a number of initialized snaps, i.e. snap locations such as
 * top-left, mid, bottom-right and so forth.
 *
 * @return {Array<String>} snapLocations
 */
SnapContext.prototype.getSnapLocations = function () {
  return this._snapLocations;
};

/**
 * Set the snap locations for this context.
 *
 * The order of locations determines precedence.
 *
 * @param {Array<String>} snapLocations
 */
SnapContext.prototype.setSnapLocations = function (snapLocations) {
  this._snapLocations = snapLocations;
};

/**
 * Get snap points for a given target
 *
 * @param {Element|String} target
 */
SnapContext.prototype.pointsForTarget = function (target) {

  var targetId = target.id || target;

  var snapPoints = this._targets[targetId];

  if (!snapPoints) {
    snapPoints = this._targets[targetId] = new SnapPoints();
    snapPoints.initDefaults(this._defaultSnaps);
  }

  return snapPoints;
};

/**
 * Creates the snap points and initializes them with the
 * given default values.
 *
 * @param {Object<String, Array<Point>>} [defaultPoints]
 */
function SnapPoints(defaultSnaps) {

  /**
   * Map<String, Map<(x|y), Array<Number>>> mapping snap locations,
   * i.e. top-left, bottom-right, center to actual snap values.
   *
   * @type {Object}
   */
  this._snapValues = {};
}

SnapPoints.prototype.add = function (snapLocation, point) {

  var snapValues = this._snapValues[snapLocation];

  if (!snapValues) {
    snapValues = this._snapValues[snapLocation] = { x: [], y: [] };
  }

  if (snapValues.x.indexOf(point.x) === -1) {
    snapValues.x.push(point.x);
  }

  if (snapValues.y.indexOf(point.y) === -1) {
    snapValues.y.push(point.y);
  }
};

SnapPoints.prototype.snap = function (point, snapLocation, axis, tolerance) {
  var snappingValues = this._snapValues[snapLocation];

  return snappingValues && (0, _SnapUtil.snapTo)(point[axis], snappingValues[axis], tolerance);
};

/**
 * Initialize a number of default snapping points.
 *
 * @param  {Object} defaultSnaps
 */
SnapPoints.prototype.initDefaults = function (defaultSnaps) {

  var self = this;

  (0, _minDash.forEach)(defaultSnaps || {}, function (snapPoints, snapLocation) {
    (0, _minDash.forEach)(snapPoints, function (point) {
      self.add(snapLocation, point);
    });
  });
};

},{"210":210,"254":254}],210:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.snapTo = snapTo;
exports.topLeft = topLeft;
exports.topRight = topRight;
exports.bottomLeft = bottomLeft;
exports.bottomRight = bottomRight;
exports.mid = mid;
exports.isSnapped = isSnapped;
exports.setSnapped = setSnapped;
exports.getChildren = getChildren;
var abs = Math.abs,
    round = Math.round;

/**
 * Snap value to a collection of reference values.
 *
 * @param  {Number} value
 * @param  {Array<Number>} values
 * @param  {Number} [tolerance=10]
 *
 * @return {Number} the value we snapped to or null, if none snapped
 */
function snapTo(value, values, tolerance) {
  tolerance = tolerance === undefined ? 10 : tolerance;

  var idx, snapValue;

  for (idx = 0; idx < values.length; idx++) {
    snapValue = values[idx];

    if (abs(snapValue - value) <= tolerance) {
      return snapValue;
    }
  }
}

function topLeft(bounds) {
  return {
    x: bounds.x,
    y: bounds.y
  };
}

function topRight(bounds) {
  return {
    x: bounds.x + bounds.width,
    y: bounds.y
  };
}

function bottomLeft(bounds) {
  return {
    x: bounds.x,
    y: bounds.y + bounds.height
  };
}

function bottomRight(bounds) {
  return {
    x: bounds.x + bounds.width,
    y: bounds.y + bounds.height
  };
}

function mid(bounds, defaultValue) {

  if (!bounds || isNaN(bounds.x) || isNaN(bounds.y)) {
    return defaultValue;
  }

  return {
    x: round(bounds.x + bounds.width / 2),
    y: round(bounds.y + bounds.height / 2)
  };
}

/**
 * Retrieve the snap state of the given event.
 *
 * @param  {Event} event
 * @param  {String} axis
 *
 * @return {Boolean} the snapped state
 *
 */
function isSnapped(event, axis) {
  var snapped = event.snapped;

  if (!snapped) {
    return false;
  }

  if (typeof axis === 'string') {
    return snapped[axis];
  }

  return snapped.x && snapped.y;
}

/**
 * Set the given event as snapped.
 *
 * This method may change the x and/or y position of the shape
 * from the given event!
 *
 * @param {Event} event
 * @param {String} axis
 * @param {Number|Boolean} value
 *
 * @return {Number} old value
 */
function setSnapped(event, axis, value) {
  if (typeof axis !== 'string') {
    throw new Error('axis must be in [x, y]');
  }

  if (typeof value !== 'number' && value !== false) {
    throw new Error('value must be Number or false');
  }

  var delta,
      previousValue = event[axis];

  var snapped = event.snapped = event.snapped || {};

  if (value === false) {
    snapped[axis] = false;
  } else {
    snapped[axis] = true;

    delta = value - previousValue;

    event[axis] += delta;
    event['d' + axis] += delta;
  }

  return previousValue;
}

/**
 * Get children of a shape.
 *
 * @param {djs.model.Shape} parent
 *
 * @returns {Array<djs.model.Shape|djs.model.Connection>}
 */
function getChildren(parent) {
  return parent.children || [];
}

},{}],211:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SNAP_LINE_HIDE_DELAY = undefined;
exports.default = Snapping;

var _minDash = _dereq_(254);

var _SnapUtil = _dereq_(210);

var _tinySvg = _dereq_(275);

var SNAP_TOLERANCE = 7;

var SNAP_LINE_HIDE_DELAY = exports.SNAP_LINE_HIDE_DELAY = 1000;

/**
 * Generic snapping feature.
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 */
function Snapping(canvas) {
  this._canvas = canvas;

  // delay hide by 1000 seconds since last snap
  this._asyncHide = (0, _minDash.debounce)((0, _minDash.bind)(this.hide, this), SNAP_LINE_HIDE_DELAY);
}

Snapping.$inject = ['canvas'];

/**
 * Snap an event to given snap points.
 *
 * @param {Event} event
 * @param {SnapPoints} snapPoints
 */
Snapping.prototype.snap = function (event, snapPoints) {
  var context = event.context,
      snapContext = context.snapContext,
      snapLocations = snapContext.getSnapLocations();

  var snapping = {
    x: (0, _SnapUtil.isSnapped)(event, 'x'),
    y: (0, _SnapUtil.isSnapped)(event, 'y')
  };

  (0, _minDash.forEach)(snapLocations, function (location) {
    var snapOrigin = snapContext.getSnapOrigin(location);

    var snapCurrent = {
      x: event.x + snapOrigin.x,
      y: event.y + snapOrigin.y
    };

    // snap both axis if not snapped already
    (0, _minDash.forEach)(['x', 'y'], function (axis) {
      var locationSnapping;

      if (!snapping[axis]) {
        locationSnapping = snapPoints.snap(snapCurrent, location, axis, SNAP_TOLERANCE);

        if (locationSnapping !== undefined) {
          snapping[axis] = {
            value: locationSnapping,
            originValue: locationSnapping - snapOrigin[axis]
          };
        }
      }
    });

    // no need to continue snapping
    if (snapping.x && snapping.y) {
      return false;
    }
  });

  // show snap lines
  this.showSnapLine('vertical', snapping.x && snapping.x.value);
  this.showSnapLine('horizontal', snapping.y && snapping.y.value);

  // snap event
  (0, _minDash.forEach)(['x', 'y'], function (axis) {
    var axisSnapping = snapping[axis];

    if ((0, _minDash.isObject)(axisSnapping)) {
      (0, _SnapUtil.setSnapped)(event, axis, axisSnapping.originValue);
    }
  });
};

Snapping.prototype._createLine = function (orientation) {
  var root = this._canvas.getLayer('snap');

  var line = (0, _tinySvg.create)('path');

  (0, _tinySvg.attr)(line, { d: 'M0,0 L0,0' });

  (0, _tinySvg.classes)(line).add('djs-snap-line');

  (0, _tinySvg.append)(root, line);

  return {
    update: function update(position) {

      if (!(0, _minDash.isNumber)(position)) {
        (0, _tinySvg.attr)(line, { display: 'none' });
      } else {
        if (orientation === 'horizontal') {
          (0, _tinySvg.attr)(line, {
            d: 'M-100000,' + position + ' L+100000,' + position,
            display: ''
          });
        } else {
          (0, _tinySvg.attr)(line, {
            d: 'M ' + position + ',-100000 L ' + position + ', +100000',
            display: ''
          });
        }
      }
    }
  };
};

Snapping.prototype._createSnapLines = function () {
  this._snapLines = {
    horizontal: this._createLine('horizontal'),
    vertical: this._createLine('vertical')
  };
};

Snapping.prototype.showSnapLine = function (orientation, position) {

  var line = this.getSnapLine(orientation);

  if (line) {
    line.update(position);
  }

  this._asyncHide();
};

Snapping.prototype.getSnapLine = function (orientation) {
  if (!this._snapLines) {
    this._createSnapLines();
  }

  return this._snapLines[orientation];
};

Snapping.prototype.hide = function () {
  (0, _minDash.forEach)(this._snapLines, function (snapLine) {
    snapLine.update();
  });
};

},{"210":210,"254":254,"275":275}],212:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _CreateMoveSnapping = _dereq_(207);

var _CreateMoveSnapping2 = _interopRequireDefault(_CreateMoveSnapping);

var _ResizeSnapping = _dereq_(208);

var _ResizeSnapping2 = _interopRequireDefault(_ResizeSnapping);

var _Snapping = _dereq_(211);

var _Snapping2 = _interopRequireDefault(_Snapping);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['createMoveSnapping', 'resizeSnapping', 'snapping'],
  createMoveSnapping: ['type', _CreateMoveSnapping2.default],
  resizeSnapping: ['type', _ResizeSnapping2.default],
  snapping: ['type', _Snapping2.default]
};

},{"207":207,"208":208,"211":211}],213:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SpaceTool;

var _SpaceUtil = _dereq_(215);

var _Cursor = _dereq_(234);

var _Mouse = _dereq_(243);

var _Elements = _dereq_(235);

var _minDash = _dereq_(254);

var abs = Math.abs,
    round = Math.round;

var HIGH_PRIORITY = 1500,
    SPACE_TOOL_CURSOR = 'crosshair';

var AXIS_TO_DIMENSION = { x: 'width', y: 'height' },
    AXIS_INVERTED = { x: 'y', y: 'x' };

/**
 * A tool that allows users to create and remove space in a diagram.
 *
 * The tool needs to be activated manually via {@link SpaceTool#activate(MouseEvent)}.
 */
function SpaceTool(eventBus, dragging, canvas, modeling, rules, toolManager) {

  this._canvas = canvas;
  this._dragging = dragging;
  this._modeling = modeling;
  this._rules = rules;
  this._toolManager = toolManager;

  var self = this;

  toolManager.registerTool('space', {
    tool: 'spaceTool.selection',
    dragging: 'spaceTool'
  });

  eventBus.on('spaceTool.selection.end', function (event) {
    var target = event.originalEvent.target;

    // only reactive on diagram click
    // on some occasions, event.hover is not set and we have to check if the target is an svg
    if (!event.hover && !(target instanceof SVGElement)) {
      return;
    }

    eventBus.once('spaceTool.selection.ended', function () {
      self.activateMakeSpace(event.originalEvent);
    });
  });

  eventBus.on('spaceTool.move', HIGH_PRIORITY, function (event) {

    var context = event.context;

    if (!context.initialized) {
      context.initialized = self.initializeMakeSpace(event, context);
    }
  });

  eventBus.on('spaceTool.end', function (event) {

    var context = event.context,
        axis = context.axis,
        direction = context.direction,
        movingShapes = context.movingShapes,
        resizingShapes = context.resizingShapes;

    // skip if create space has not been initialized yet
    if (!context.initialized) {
      return;
    }

    var delta = { x: round(event.dx), y: round(event.dy) };
    delta[AXIS_INVERTED[axis]] = 0;

    var insideBounds = true;

    // check if the space tool cursor is inside of bounds of
    // any of the shapes that would be resized.
    (0, _minDash.forEach)(resizingShapes, function (shape) {

      if (direction === 'w' && event.x > shape.x + shape.width || direction === 'e' && event.x < shape.x || direction === 'n' && event.y > shape.y + shape.height || direction === 's' && event.y < shape.y) {

        insideBounds = false;
        return;
      }
    });

    if (insideBounds) {
      // make space only if the cursor is inside bounds
      self.makeSpace(movingShapes, resizingShapes, delta, direction);
    }

    eventBus.once('spaceTool.ended', function (event) {
      // reactivate space tool after usage
      self.activateSelection(event.originalEvent, true, true);
    });
  });
}

SpaceTool.$inject = ['eventBus', 'dragging', 'canvas', 'modeling', 'rules', 'toolManager'];

/**
 * Activate space tool selection
 *
 * @param  {MouseEvent} event
 * @param  {Boolean} autoActivate
 */
SpaceTool.prototype.activateSelection = function (event, autoActivate, reactivate) {
  this._dragging.init(event, 'spaceTool.selection', {
    trapClick: false,
    cursor: SPACE_TOOL_CURSOR,
    autoActivate: autoActivate,
    data: {
      context: {
        reactivate: reactivate
      }
    }
  });
};

/**
 * Activate make space
 *
 * @param  {MouseEvent} event
 */
SpaceTool.prototype.activateMakeSpace = function (event) {
  this._dragging.init(event, 'spaceTool', {
    autoActivate: true,
    cursor: SPACE_TOOL_CURSOR,
    data: {
      context: {}
    }
  });
};

/**
 * Actually make space on the diagram
 *
 * @param  {Array<djs.model.Shape>} movingShapes
 * @param  {Array<djs.model.Shape>} resizingShapes
 * @param  {Point} delta
 * @param  {String} direction
 */
SpaceTool.prototype.makeSpace = function (movingShapes, resizingShapes, delta, direction) {
  return this._modeling.createSpace(movingShapes, resizingShapes, delta, direction);
};

/**
 * Initialize make space and return true if that was successful.
 *
 * @param {Event} event
 * @param {Object} context
 *
 * @return {Boolean} true, if successful
 */
SpaceTool.prototype.initializeMakeSpace = function (event, context) {

  var axis = abs(event.dx) > abs(event.dy) ? 'x' : 'y',
      offset = event['d' + axis],

  // start point of create space operation
  spacePos = event[axis] - offset;

  if (abs(offset) < 5) {
    return false;
  }

  // invert the offset in order to remove space when moving left
  if (offset < 0) {
    offset *= -1;
  }

  // inverts the offset to choose the shapes
  // on the opposite side of the resizer if
  // a key modifier is pressed
  if ((0, _Mouse.hasPrimaryModifier)(event)) {
    offset *= -1;
  }

  var rootShape = this._canvas.getRootElement();

  var allShapes = (0, _Elements.selfAndAllChildren)(rootShape, true);

  var adjustments = this.calculateAdjustments(allShapes, axis, offset, spacePos);

  // store data in context
  (0, _minDash.assign)(context, adjustments, {
    axis: axis,
    direction: (0, _SpaceUtil.getDirection)(axis, offset)
  });

  (0, _Cursor.set)('resize-' + (axis === 'x' ? 'ew' : 'ns'));

  return true;
};

/**
 * Calculate adjustments needed when making space
 *
 * @param  {Array<djs.model.Shape>} elements
 * @param  {String} axis
 * @param  {Number} offset
 * @param  {Number} spacePos
 *
 * @return {Object}
 */
SpaceTool.prototype.calculateAdjustments = function (elements, axis, offset, spacePos) {

  var movingShapes = [],
      resizingShapes = [];

  var rules = this._rules;

  // collect all elements that need to be moved _AND_
  // resized given on the initial create space position
  elements.forEach(function (shape) {

    var shapeStart = shape[axis],
        shapeEnd = shapeStart + shape[AXIS_TO_DIMENSION[axis]];

    // checking if it's root
    if (!shape.parent) {
      return;
    }

    // checking if it's a shape
    if (shape.waypoints) {
      return;
    }

    // shape after spacePos
    if (offset > 0 && shapeStart > spacePos) {
      return movingShapes.push(shape);
    }

    // shape before spacePos
    if (offset < 0 && shapeEnd < spacePos) {
      return movingShapes.push(shape);
    }

    // shape on top of spacePos, resize only if allowed
    if (shapeStart < spacePos && shapeEnd > spacePos && rules.allowed('shape.resize', { shape: shape })) {

      return resizingShapes.push(shape);
    }
  });

  return {
    movingShapes: movingShapes,
    resizingShapes: resizingShapes
  };
};

SpaceTool.prototype.toggle = function () {
  if (this.isActive()) {
    this._dragging.cancel();
  } else {
    this.activateSelection();
  }
};

SpaceTool.prototype.isActive = function () {
  var context = this._dragging.context();

  return context && /^spaceTool/.test(context.prefix);
};

},{"215":215,"234":234,"235":235,"243":243,"254":254}],214:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SpaceToolPreview;

var _minDash = _dereq_(254);

var _tinySvg = _dereq_(275);

var _SvgTransformUtil = _dereq_(248);

var MARKER_DRAGGING = 'djs-dragging',
    MARKER_RESIZING = 'djs-resizing';

var LOW_PRIORITY = 250;

var max = Math.max;

/**
 * Provides previews for selecting/moving/resizing shapes when creating/removing space.
 *
 * @param {EventBus} eventBus
 * @param {ElementRegistry} elementRegistry
 * @param {Canvas} canvas
 * @param {Styles} styles
 */
function SpaceToolPreview(eventBus, elementRegistry, canvas, styles, previewSupport) {

  function addPreviewGfx(collection, dragGroup) {
    (0, _minDash.forEach)(collection, function (element) {
      previewSupport.addDragger(element, dragGroup);

      canvas.addMarker(element, MARKER_DRAGGING);
    });
  }

  // add crosshair
  eventBus.on('spaceTool.selection.start', function (event) {
    var space = canvas.getLayer('space'),
        context = event.context;

    var orientation = {
      x: 'M 0,-10000 L 0,10000',
      y: 'M -10000,0 L 10000,0'
    };

    var crosshairGroup = (0, _tinySvg.create)('g');
    (0, _tinySvg.attr)(crosshairGroup, styles.cls('djs-crosshair-group', ['no-events']));

    (0, _tinySvg.append)(space, crosshairGroup);

    // horizontal path
    var pathX = (0, _tinySvg.create)('path');
    (0, _tinySvg.attr)(pathX, 'd', orientation.x);
    (0, _tinySvg.classes)(pathX).add('djs-crosshair');

    (0, _tinySvg.append)(crosshairGroup, pathX);

    // vertical path
    var pathY = (0, _tinySvg.create)('path');
    (0, _tinySvg.attr)(pathY, 'd', orientation.y);
    (0, _tinySvg.classes)(pathY).add('djs-crosshair');

    (0, _tinySvg.append)(crosshairGroup, pathY);

    context.crosshairGroup = crosshairGroup;
  });

  // update crosshair
  eventBus.on('spaceTool.selection.move', function (event) {
    var crosshairGroup = event.context.crosshairGroup;

    (0, _SvgTransformUtil.translate)(crosshairGroup, event.x, event.y);
  });

  // remove crosshair
  eventBus.on('spaceTool.selection.cleanup', function (event) {
    var context = event.context,
        crosshairGroup = context.crosshairGroup;

    if (crosshairGroup) {
      (0, _tinySvg.remove)(crosshairGroup);
    }
  });

  // add and update move/resize previews
  eventBus.on('spaceTool.move', LOW_PRIORITY, function (event) {

    var context = event.context,
        line = context.line,
        axis = context.axis,
        movingShapes = context.movingShapes,
        resizingShapes = context.resizingShapes;

    if (!context.initialized) {
      return;
    }

    if (!context.dragGroup) {
      var spaceLayer = canvas.getLayer('space');

      line = (0, _tinySvg.create)('path');
      (0, _tinySvg.attr)(line, 'd', 'M0,0 L0,0');
      (0, _tinySvg.classes)(line).add('djs-crosshair');

      (0, _tinySvg.append)(spaceLayer, line);

      context.line = line;

      var dragGroup = (0, _tinySvg.create)('g');
      (0, _tinySvg.attr)(dragGroup, styles.cls('djs-drag-group', ['no-events']));

      (0, _tinySvg.append)(canvas.getDefaultLayer(), dragGroup);

      // shapes
      addPreviewGfx(movingShapes, dragGroup);

      // connections
      var movingConnections = context.movingConnections = elementRegistry.filter(function (element) {
        var sourceIsMoving = false;

        (0, _minDash.forEach)(movingShapes, function (shape) {
          (0, _minDash.forEach)(shape.outgoing, function (connection) {
            if (element === connection) {
              sourceIsMoving = true;
            }
          });
        });

        var targetIsMoving = false;

        (0, _minDash.forEach)(movingShapes, function (shape) {
          (0, _minDash.forEach)(shape.incoming, function (connection) {
            if (element === connection) {
              targetIsMoving = true;
            }
          });
        });

        var sourceIsResizing = false;

        (0, _minDash.forEach)(resizingShapes, function (shape) {
          (0, _minDash.forEach)(shape.outgoing, function (connection) {
            if (element === connection) {
              sourceIsResizing = true;
            }
          });
        });

        var targetIsResizing = false;

        (0, _minDash.forEach)(resizingShapes, function (shape) {
          (0, _minDash.forEach)(shape.incoming, function (connection) {
            if (element === connection) {
              targetIsResizing = true;
            }
          });
        });

        return isConnection(element) && (sourceIsMoving || sourceIsResizing) && (targetIsMoving || targetIsResizing);
      });

      addPreviewGfx(movingConnections, dragGroup);

      context.dragGroup = dragGroup;
    }

    if (!context.frameGroup) {
      var frameGroup = (0, _tinySvg.create)('g');
      (0, _tinySvg.attr)(frameGroup, styles.cls('djs-frame-group', ['no-events']));

      (0, _tinySvg.append)(canvas.getDefaultLayer(), frameGroup);

      var frames = [];

      (0, _minDash.forEach)(resizingShapes, function (shape) {
        var frame = previewSupport.addFrame(shape, frameGroup);

        var initialBounds = frame.getBBox();

        frames.push({
          element: frame,
          initialBounds: initialBounds
        });

        canvas.addMarker(shape, MARKER_RESIZING);
      });

      context.frameGroup = frameGroup;
      context.frames = frames;
    }

    var orientation = {
      x: 'M' + event.x + ', -10000 L' + event.x + ', 10000',
      y: 'M -10000, ' + event.y + ' L 10000, ' + event.y
    };

    (0, _tinySvg.attr)(line, { path: orientation[axis], display: '' });

    var opposite = { x: 'y', y: 'x' };
    var delta = { x: event.dx, y: event.dy };
    delta[opposite[context.axis]] = 0;

    // update move previews
    (0, _SvgTransformUtil.translate)(context.dragGroup, delta.x, delta.y);

    // update resize previews
    (0, _minDash.forEach)(context.frames, function (frame) {
      var element = frame.element,
          initialBounds = frame.initialBounds,
          width,
          height;

      if (context.direction === 'e') {
        (0, _tinySvg.attr)(element, {
          width: max(initialBounds.width + delta.x, 5)
        });
      } else {
        width = max(initialBounds.width - delta.x, 5);

        (0, _tinySvg.attr)(element, {
          width: width,
          x: initialBounds.x + initialBounds.width - width
        });
      }

      if (context.direction === 's') {
        (0, _tinySvg.attr)(element, {
          height: max(initialBounds.height + delta.y, 5)
        });
      } else {
        height = max(initialBounds.height - delta.y, 5);

        (0, _tinySvg.attr)(element, {
          height: height,
          y: initialBounds.y + initialBounds.height - height
        });
      }
    });
  });

  // remove move/resize previews
  eventBus.on('spaceTool.cleanup', function (event) {

    var context = event.context,
        movingShapes = context.movingShapes,
        movingConnections = context.movingConnections,
        resizingShapes = context.resizingShapes,
        line = context.line,
        dragGroup = context.dragGroup,
        frameGroup = context.frameGroup;

    // moving shapes
    (0, _minDash.forEach)(movingShapes, function (shape) {
      canvas.removeMarker(shape, MARKER_DRAGGING);
    });

    // moving connections
    (0, _minDash.forEach)(movingConnections, function (connection) {
      canvas.removeMarker(connection, MARKER_DRAGGING);
    });

    if (dragGroup) {
      (0, _tinySvg.remove)(line);
      (0, _tinySvg.remove)(dragGroup);
    }

    (0, _minDash.forEach)(resizingShapes, function (shape) {
      canvas.removeMarker(shape, MARKER_RESIZING);
    });

    if (frameGroup) {
      (0, _tinySvg.remove)(frameGroup);
    }
  });
}

SpaceToolPreview.$inject = ['eventBus', 'elementRegistry', 'canvas', 'styles', 'previewSupport'];

// helpers //////////////////////

/**
 * Checks if an element is a connection.
 */
function isConnection(element) {
  return element.waypoints;
}

},{"248":248,"254":254,"275":275}],215:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDirection = getDirection;
exports.resizeBounds = resizeBounds;
/**
 * Get Resize direction given axis + offset
 *
 * @param {String} axis (x|y)
 * @param {Number} offset
 *
 * @return {String} (e|w|n|s)
 */
function getDirection(axis, offset) {

  if (axis === 'x') {
    if (offset > 0) {
      return 'e';
    }

    if (offset < 0) {
      return 'w';
    }
  }

  if (axis === 'y') {
    if (offset > 0) {
      return 's';
    }

    if (offset < 0) {
      return 'n';
    }
  }

  return null;
}

/**
 * Resize the given bounds by the specified delta from a given anchor point.
 *
 * @param {Bounds} bounds the bounding box that should be resized
 * @param {String} direction in which the element is resized (n, s, e, w)
 * @param {Point} delta of the resize operation
 *
 * @return {Bounds} resized bounding box
 */
function resizeBounds(bounds, direction, delta) {

  var dx = delta.x,
      dy = delta.y;

  switch (direction) {

    case 'n':
      return {
        x: bounds.x,
        y: bounds.y + dy,
        width: bounds.width,
        height: bounds.height - dy
      };

    case 's':
      return {
        x: bounds.x,
        y: bounds.y,
        width: bounds.width,
        height: bounds.height + dy
      };

    case 'w':
      return {
        x: bounds.x + dx,
        y: bounds.y,
        width: bounds.width - dx,
        height: bounds.height
      };

    case 'e':
      return {
        x: bounds.x,
        y: bounds.y,
        width: bounds.width + dx,
        height: bounds.height
      };

    default:
      throw new Error('unrecognized direction: ' + direction);
  }
}

},{}],216:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _dragging = _dereq_(131);

var _dragging2 = _interopRequireDefault(_dragging);

var _rules = _dereq_(200);

var _rules2 = _interopRequireDefault(_rules);

var _toolManager = _dereq_(218);

var _toolManager2 = _interopRequireDefault(_toolManager);

var _previewSupport = _dereq_(190);

var _previewSupport2 = _interopRequireDefault(_previewSupport);

var _SpaceTool = _dereq_(213);

var _SpaceTool2 = _interopRequireDefault(_SpaceTool);

var _SpaceToolPreview = _dereq_(214);

var _SpaceToolPreview2 = _interopRequireDefault(_SpaceToolPreview);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['spaceToolPreview'],
  __depends__: [_dragging2.default, _rules2.default, _toolManager2.default, _previewSupport2.default],
  spaceTool: ['type', _SpaceTool2.default],
  spaceToolPreview: ['type', _SpaceToolPreview2.default]
};

},{"131":131,"190":190,"200":200,"213":213,"214":214,"218":218}],217:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ToolManager;

var _minDash = _dereq_(254);

var _minDom = _dereq_(255);

var LOW_PRIORITY = 250;

/**
 * The tool manager acts as middle-man between the available tool's and the Palette,
 * it takes care of making sure that the correct active state is set.
 *
 * @param  {Object}    eventBus
 * @param  {Object}    dragging
 */
function ToolManager(eventBus, dragging) {
  this._eventBus = eventBus;
  this._dragging = dragging;

  this._tools = [];
  this._active = null;
}

ToolManager.$inject = ['eventBus', 'dragging'];

ToolManager.prototype.registerTool = function (name, events) {
  var tools = this._tools;

  if (!events) {
    throw new Error('A tool has to be registered with it\'s "events"');
  }

  tools.push(name);

  this.bindEvents(name, events);
};

ToolManager.prototype.isActive = function (tool) {
  return tool && this._active === tool;
};

ToolManager.prototype.length = function (tool) {
  return this._tools.length;
};

ToolManager.prototype.setActive = function (tool) {
  var eventBus = this._eventBus;

  if (this._active !== tool) {
    this._active = tool;

    eventBus.fire('tool-manager.update', { tool: tool });
  }
};

ToolManager.prototype.bindEvents = function (name, events) {
  var eventBus = this._eventBus,
      dragging = this._dragging;

  var eventsToRegister = [];

  eventBus.on(events.tool + '.init', function (event) {
    var context = event.context;

    // Active tools that want to reactivate themselves must do this explicitly
    if (!context.reactivate && this.isActive(name)) {
      this.setActive(null);

      dragging.cancel();
      return;
    }

    this.setActive(name);
  }, this);

  // Todo[ricardo]: add test cases
  (0, _minDash.forEach)(events, function (event) {
    eventsToRegister.push(event + '.ended');
    eventsToRegister.push(event + '.canceled');
  });

  eventBus.on(eventsToRegister, LOW_PRIORITY, function (event) {
    var originalEvent = event.originalEvent;

    // We defer the de-activation of the tool to the .activate phase,
    // so we're able to check if we want to toggle off the current
    // active tool or switch to a new one
    if (!this._active) {
      return;
    }

    if (originalEvent && (0, _minDom.closest)(originalEvent.target, '.group[data-group="tools"]')) {
      return;
    }

    this.setActive(null);
  }, this);
};

},{"254":254,"255":255}],218:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _dragging = _dereq_(131);

var _dragging2 = _interopRequireDefault(_dragging);

var _ToolManager = _dereq_(217);

var _ToolManager2 = _interopRequireDefault(_ToolManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_dragging2.default],
  __init__: ['toolManager'],
  toolManager: ['type', _ToolManager2.default]
};

},{"131":131,"217":217}],219:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = BaseLayouter;

var _LayoutUtil = _dereq_(221);

/**
 * A base connection layouter implementation
 * that layouts the connection by directly connecting
 * mid(source) + mid(target).
 */
function BaseLayouter() {}

/**
 * Return the new layouted waypoints for the given connection.
 *
 * The connection passed is still unchanged; you may figure out about
 * the new connection start / end via the layout hints provided.
 *
 * @param {djs.model.Connection} connection
 * @param {Object} [hints]
 * @param {Point} [hints.connectionStart]
 * @param {Point} [hints.connectionEnd]
 * @param {Point} [hints.source]
 * @param {Point} [hints.target]
 *
 * @return {Array<Point>} the layouted connection waypoints
 */
BaseLayouter.prototype.layoutConnection = function (connection, hints) {

  hints = hints || {};

  return [hints.connectionStart || (0, _LayoutUtil.getMid)(hints.source || connection.source), hints.connectionEnd || (0, _LayoutUtil.getMid)(hints.target || connection.target)];
};

},{"221":221}],220:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CroppingConnectionDocking;

var _minDash = _dereq_(254);

var _LayoutUtil = _dereq_(221);

function dockingToPoint(docking) {
  // use the dockings actual point and
  // retain the original docking
  return (0, _minDash.assign)({ original: docking.point.original || docking.point }, docking.actual);
}

/**
 * A {@link ConnectionDocking} that crops connection waypoints based on
 * the path(s) of the connection source and target.
 *
 * @param {djs.core.ElementRegistry} elementRegistry
 */
function CroppingConnectionDocking(elementRegistry, graphicsFactory) {
  this._elementRegistry = elementRegistry;
  this._graphicsFactory = graphicsFactory;
}

CroppingConnectionDocking.$inject = ['elementRegistry', 'graphicsFactory'];

/**
 * @inheritDoc ConnectionDocking#getCroppedWaypoints
 */
CroppingConnectionDocking.prototype.getCroppedWaypoints = function (connection, source, target) {

  source = source || connection.source;
  target = target || connection.target;

  var sourceDocking = this.getDockingPoint(connection, source, true),
      targetDocking = this.getDockingPoint(connection, target);

  var croppedWaypoints = connection.waypoints.slice(sourceDocking.idx + 1, targetDocking.idx);

  croppedWaypoints.unshift(dockingToPoint(sourceDocking));
  croppedWaypoints.push(dockingToPoint(targetDocking));

  return croppedWaypoints;
};

/**
 * Return the connection docking point on the specified shape
 *
 * @inheritDoc ConnectionDocking#getDockingPoint
 */
CroppingConnectionDocking.prototype.getDockingPoint = function (connection, shape, dockStart) {

  var waypoints = connection.waypoints,
      dockingIdx,
      dockingPoint,
      croppedPoint;

  dockingIdx = dockStart ? 0 : waypoints.length - 1;
  dockingPoint = waypoints[dockingIdx];

  croppedPoint = this._getIntersection(shape, connection, dockStart);

  return {
    point: dockingPoint,
    actual: croppedPoint || dockingPoint,
    idx: dockingIdx
  };
};

// helpers //////////////////////

CroppingConnectionDocking.prototype._getIntersection = function (shape, connection, takeFirst) {

  var shapePath = this._getShapePath(shape),
      connectionPath = this._getConnectionPath(connection);

  return (0, _LayoutUtil.getElementLineIntersection)(shapePath, connectionPath, takeFirst);
};

CroppingConnectionDocking.prototype._getConnectionPath = function (connection) {
  return this._graphicsFactory.getConnectionPath(connection);
};

CroppingConnectionDocking.prototype._getShapePath = function (shape) {
  return this._graphicsFactory.getShapePath(shape);
};

CroppingConnectionDocking.prototype._getGfx = function (element) {
  return this._elementRegistry.getGraphics(element);
};

},{"221":221,"254":254}],221:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.roundBounds = roundBounds;
exports.roundPoint = roundPoint;
exports.asTRBL = asTRBL;
exports.asBounds = asBounds;
exports.getMid = getMid;
exports.getOrientation = getOrientation;
exports.getElementLineIntersection = getElementLineIntersection;
exports.getIntersections = getIntersections;
exports.filterRedundantWaypoints = filterRedundantWaypoints;

var _minDash = _dereq_(254);

var _Geometry = _dereq_(238);

var _pathIntersection = _dereq_(272);

var _pathIntersection2 = _interopRequireDefault(_pathIntersection);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function roundBounds(bounds) {
  return {
    x: Math.round(bounds.x),
    y: Math.round(bounds.y),
    width: Math.round(bounds.width),
    height: Math.round(bounds.height)
  };
}

function roundPoint(point) {

  return {
    x: Math.round(point.x),
    y: Math.round(point.y)
  };
}

/**
 * Convert the given bounds to a { top, left, bottom, right } descriptor.
 *
 * @param {Bounds|Point} bounds
 *
 * @return {Object}
 */
function asTRBL(bounds) {
  return {
    top: bounds.y,
    right: bounds.x + (bounds.width || 0),
    bottom: bounds.y + (bounds.height || 0),
    left: bounds.x
  };
}

/**
 * Convert a { top, left, bottom, right } to an objects bounds.
 *
 * @param {Object} trbl
 *
 * @return {Bounds}
 */
function asBounds(trbl) {
  return {
    x: trbl.left,
    y: trbl.top,
    width: trbl.right - trbl.left,
    height: trbl.bottom - trbl.top
  };
}

/**
 * Get the mid of the given bounds or point.
 *
 * @param {Bounds|Point} bounds
 *
 * @return {Point}
 */
function getMid(bounds) {
  return roundPoint({
    x: bounds.x + (bounds.width || 0) / 2,
    y: bounds.y + (bounds.height || 0) / 2
  });
}

// orientation utils //////////////////////

/**
 * Get orientation of the given rectangle with respect to
 * the reference rectangle.
 *
 * A padding (positive or negative) may be passed to influence
 * horizontal / vertical orientation and intersection.
 *
 * @param {Bounds} rect
 * @param {Bounds} reference
 * @param {Point|Number} padding
 *
 * @return {String} the orientation; one of top, top-left, left, ..., bottom, right or intersect.
 */
function getOrientation(rect, reference, padding) {

  padding = padding || 0;

  // make sure we can use an object, too
  // for individual { x, y } padding
  if (!(0, _minDash.isObject)(padding)) {
    padding = { x: padding, y: padding };
  }

  var rectOrientation = asTRBL(rect),
      referenceOrientation = asTRBL(reference);

  var top = rectOrientation.bottom + padding.y <= referenceOrientation.top,
      right = rectOrientation.left - padding.x >= referenceOrientation.right,
      bottom = rectOrientation.top - padding.y >= referenceOrientation.bottom,
      left = rectOrientation.right + padding.x <= referenceOrientation.left;

  var vertical = top ? 'top' : bottom ? 'bottom' : null,
      horizontal = left ? 'left' : right ? 'right' : null;

  if (horizontal && vertical) {
    return vertical + '-' + horizontal;
  } else {
    return horizontal || vertical || 'intersect';
  }
}

// intersection utils //////////////////////

/**
 * Get intersection between an element and a line path.
 *
 * @param {PathDef} elementPath
 * @param {PathDef} linePath
 * @param {Boolean} cropStart crop from start or end
 *
 * @return {Point}
 */
function getElementLineIntersection(elementPath, linePath, cropStart) {

  var intersections = getIntersections(elementPath, linePath);

  // recognize intersections
  // only one -> choose
  // two close together -> choose first
  // two or more distinct -> pull out appropriate one
  // none -> ok (fallback to point itself)
  if (intersections.length === 1) {
    return roundPoint(intersections[0]);
  } else if (intersections.length === 2 && (0, _Geometry.pointDistance)(intersections[0], intersections[1]) < 1) {
    return roundPoint(intersections[0]);
  } else if (intersections.length > 1) {

    // sort by intersections based on connection segment +
    // distance from start
    intersections = (0, _minDash.sortBy)(intersections, function (i) {
      var distance = Math.floor(i.t2 * 100) || 1;

      distance = 100 - distance;

      distance = (distance < 10 ? '0' : '') + distance;

      // create a sort string that makes sure we sort
      // line segment ASC + line segment position DESC (for cropStart)
      // line segment ASC + line segment position ASC (for cropEnd)
      return i.segment2 + '#' + distance;
    });

    return roundPoint(intersections[cropStart ? 0 : intersections.length - 1]);
  }

  return null;
}

function getIntersections(a, b) {
  return (0, _pathIntersection2.default)(a, b);
}

function filterRedundantWaypoints(waypoints) {

  // alter copy of waypoints, not original
  waypoints = waypoints.slice();

  var idx = 0,
      point,
      previousPoint,
      nextPoint;

  while (waypoints[idx]) {
    point = waypoints[idx];
    previousPoint = waypoints[idx - 1];
    nextPoint = waypoints[idx + 1];

    if ((0, _Geometry.pointDistance)(point, nextPoint) === 0 || (0, _Geometry.pointsOnLine)(previousPoint, nextPoint, point)) {

      // remove point, if overlapping with {nextPoint}
      // or on line with {previousPoint} -> {point} -> {nextPoint}
      waypoints.splice(idx, 1);
    } else {
      idx++;
    }
  }

  return waypoints;
}

},{"238":238,"254":254,"272":272}],222:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectPoints = connectPoints;
exports.connectRectangles = connectRectangles;
exports.repairConnection = repairConnection;
exports.tryLayoutStraight = tryLayoutStraight;
exports.withoutRedundantPoints = withoutRedundantPoints;

var _minDash = _dereq_(254);

var _LayoutUtil = _dereq_(221);

var _Geometry = _dereq_(238);

var MIN_SEGMENT_LENGTH = 20,
    POINT_ORIENTATION_PADDING = 5;

var round = Math.round;

var INTERSECTION_THRESHOLD = 20,
    ORIENTATION_THRESHOLD = {
  'h:h': 20,
  'v:v': 20,
  'h:v': -10,
  'v:h': -10
};

function needsTurn(orientation, startDirection) {
  return !{
    t: /top/,
    r: /right/,
    b: /bottom/,
    l: /left/,
    h: /./,
    v: /./
  }[startDirection].test(orientation);
}

function canLayoutStraight(direction, targetOrientation) {
  return {
    t: /top/,
    r: /right/,
    b: /bottom/,
    l: /left/,
    h: /left|right/,
    v: /top|bottom/
  }[direction].test(targetOrientation);
}

function getSegmentBendpoints(a, b, directions) {
  var orientation = (0, _LayoutUtil.getOrientation)(b, a, POINT_ORIENTATION_PADDING);

  var startDirection = directions.split(':')[0];

  var xmid = round((b.x - a.x) / 2 + a.x),
      ymid = round((b.y - a.y) / 2 + a.y);

  var segmentEnd, segmentDirections;

  var layoutStraight = canLayoutStraight(startDirection, orientation),
      layoutHorizontal = /h|r|l/.test(startDirection),
      layoutTurn = false;

  var turnNextDirections = false;

  if (layoutStraight) {
    segmentEnd = layoutHorizontal ? { x: xmid, y: a.y } : { x: a.x, y: ymid };

    segmentDirections = layoutHorizontal ? 'h:h' : 'v:v';
  } else {
    layoutTurn = needsTurn(orientation, startDirection);

    segmentDirections = layoutHorizontal ? 'h:v' : 'v:h';

    if (layoutTurn) {

      if (layoutHorizontal) {
        turnNextDirections = ymid === a.y;

        segmentEnd = {
          x: a.x + MIN_SEGMENT_LENGTH * (/l/.test(startDirection) ? -1 : 1),
          y: turnNextDirections ? ymid + MIN_SEGMENT_LENGTH : ymid
        };
      } else {
        turnNextDirections = xmid === a.x;

        segmentEnd = {
          x: turnNextDirections ? xmid + MIN_SEGMENT_LENGTH : xmid,
          y: a.y + MIN_SEGMENT_LENGTH * (/t/.test(startDirection) ? -1 : 1)
        };
      }
    } else {
      segmentEnd = {
        x: xmid,
        y: ymid
      };
    }
  }

  return {
    waypoints: getBendpoints(a, segmentEnd, segmentDirections).concat(segmentEnd),
    directions: segmentDirections,
    turnNextDirections: turnNextDirections
  };
}

function getStartSegment(a, b, directions) {
  return getSegmentBendpoints(a, b, directions);
}

function getEndSegment(a, b, directions) {
  var invertedSegment = getSegmentBendpoints(b, a, invertDirections(directions));

  return {
    waypoints: invertedSegment.waypoints.slice().reverse(),
    directions: invertDirections(invertedSegment.directions),
    turnNextDirections: invertedSegment.turnNextDirections
  };
}

function getMidSegment(startSegment, endSegment) {

  var startDirection = startSegment.directions.split(':')[1],
      endDirection = endSegment.directions.split(':')[0];

  if (startSegment.turnNextDirections) {
    startDirection = startDirection == 'h' ? 'v' : 'h';
  }

  if (endSegment.turnNextDirections) {
    endDirection = endDirection == 'h' ? 'v' : 'h';
  }

  var directions = startDirection + ':' + endDirection;

  var bendpoints = getBendpoints(startSegment.waypoints[startSegment.waypoints.length - 1], endSegment.waypoints[0], directions);

  return {
    waypoints: bendpoints,
    directions: directions
  };
}

function invertDirections(directions) {
  return directions.split(':').reverse().join(':');
}

/**
 * Handle simple layouts with maximum two bendpoints.
 */
function getSimpleBendpoints(a, b, directions) {

  var xmid = round((b.x - a.x) / 2 + a.x),
      ymid = round((b.y - a.y) / 2 + a.y);

  // one point, right or left from a
  if (directions === 'h:v') {
    return [{ x: b.x, y: a.y }];
  }

  // one point, above or below a
  if (directions === 'v:h') {
    return [{ x: a.x, y: b.y }];
  }

  // vertical segment between a and b
  if (directions === 'h:h') {
    return [{ x: xmid, y: a.y }, { x: xmid, y: b.y }];
  }

  // horizontal segment between a and b
  if (directions === 'v:v') {
    return [{ x: a.x, y: ymid }, { x: b.x, y: ymid }];
  }

  throw new Error('invalid directions: can only handle varians of [hv]:[hv]');
}

/**
 * Returns the mid points for a manhattan connection between two points.
 *
 * @example h:h (horizontal:horizontal)
 *
 * [a]----[x]
 *         |
 *        [x]----[b]
 *
 * @example h:v (horizontal:vertical)
 *
 * [a]----[x]
 *         |
 *        [b]
 *
 * @example h:r (horizontal:right)
 *
 * [a]----[x]
 *         |
 *    [b]-[x]
 *
 * @param  {Point} a
 * @param  {Point} b
 * @param  {String} directions
 *
 * @return {Array<Point>}
 */
function getBendpoints(a, b, directions) {
  directions = directions || 'h:h';

  if (!isValidDirections(directions)) {
    throw new Error('unknown directions: <' + directions + '>: ' + 'must be specified as <start>:<end> ' + 'with start/end in { h,v,t,r,b,l }');
  }

  // compute explicit directions, involving trbl dockings
  // using a three segmented layouting algorithm
  if (isExplicitDirections(directions)) {
    var startSegment = getStartSegment(a, b, directions),
        endSegment = getEndSegment(a, b, directions),
        midSegment = getMidSegment(startSegment, endSegment);

    return [].concat(startSegment.waypoints, midSegment.waypoints, endSegment.waypoints);
  }

  // handle simple [hv]:[hv] cases that can be easily computed
  return getSimpleBendpoints(a, b, directions);
}

/**
 * Create a connection between the two points according
 * to the manhattan layout (only horizontal and vertical) edges.
 *
 * @param {Point} a
 * @param {Point} b
 *
 * @param {String} [directions='h:h'] specifies manhattan directions for each point as {adirection}:{bdirection}.
                   A directionfor a point is either `h` (horizontal) or `v` (vertical)
 *
 * @return {Array<Point>}
 */
function connectPoints(a, b, directions) {

  var points = getBendpoints(a, b, directions);

  points.unshift(a);
  points.push(b);

  return withoutRedundantPoints(points);
}

/**
 * Connect two rectangles using a manhattan layouted connection.
 *
 * @param {Bounds} source source rectangle
 * @param {Bounds} target target rectangle
 * @param {Point} [start] source docking
 * @param {Point} [end] target docking
 *
 * @param {Object} [hints]
 * @param {String} [hints.preserveDocking=source] preserve docking on selected side
 * @param {Array<String>} [hints.preferredLayouts]
 * @param {Point|Boolean} [hints.connectionStart] whether the start changed
 * @param {Point|Boolean} [hints.connectionEnd] whether the end changed
 *
 * @return {Array<Point>} connection points
 */
function connectRectangles(source, target, start, end, hints) {

  var preferredLayouts = hints && hints.preferredLayouts || [];

  var preferredLayout = (0, _minDash.without)(preferredLayouts, 'straight')[0] || 'h:h';

  var threshold = ORIENTATION_THRESHOLD[preferredLayout] || 0;

  var orientation = (0, _LayoutUtil.getOrientation)(source, target, threshold);

  var directions = getDirections(orientation, preferredLayout);

  start = start || (0, _LayoutUtil.getMid)(source);
  end = end || (0, _LayoutUtil.getMid)(target);

  var directionSplit = directions.split(':');

  // compute actual docking points for start / end
  // this ensures we properly layout only parts of the
  // connection that lies in between the two rectangles
  var startDocking = getDockingPoint(start, source, directionSplit[0], invertOrientation(orientation)),
      endDocking = getDockingPoint(end, target, directionSplit[1], orientation);

  return connectPoints(startDocking, endDocking, directions);
}

/**
 * Repair the connection between two rectangles, of which one has been updated.
 *
 * @param {Bounds} source
 * @param {Bounds} target
 * @param {Point} [start]
 * @param {Point} [end]
 * @param {Array<Point>} [waypoints]
 * @param {Object} [hints]
 * @param {Array<String>} [hints.preferredLayouts] list of preferred layouts
 * @param {Boolean} [hints.connectionStart]
 * @param {Boolean} [hints.connectionEnd]
 *
 * @return {Array<Point>} repaired waypoints
 */
function repairConnection(source, target, start, end, waypoints, hints) {

  if ((0, _minDash.isArray)(start)) {
    waypoints = start;
    hints = end;

    start = (0, _LayoutUtil.getMid)(source);
    end = (0, _LayoutUtil.getMid)(target);
  }

  hints = (0, _minDash.assign)({ preferredLayouts: [] }, hints);
  waypoints = waypoints || [];

  var preferredLayouts = hints.preferredLayouts,
      preferStraight = preferredLayouts.indexOf('straight') !== -1,
      repairedWaypoints;

  // just layout non-existing or simple connections
  // attempt to render straight lines, if required

  // attempt to layout a straight line
  repairedWaypoints = preferStraight && tryLayoutStraight(source, target, start, end, hints);

  if (repairedWaypoints) {
    return repairedWaypoints;
  }

  // try to layout from end
  repairedWaypoints = hints.connectionEnd && tryRepairConnectionEnd(target, source, end, waypoints);

  if (repairedWaypoints) {
    return repairedWaypoints;
  }

  // try to layout from start
  repairedWaypoints = hints.connectionStart && tryRepairConnectionStart(source, target, start, waypoints);

  if (repairedWaypoints) {
    return repairedWaypoints;
  }

  // or whether nothing seems to have changed
  if (!hints.connectionStart && !hints.connectionEnd && waypoints && waypoints.length) {
    return waypoints;
  }

  // simply reconnect if nothing else worked
  return connectRectangles(source, target, start, end, hints);
}

function inRange(a, start, end) {
  return a >= start && a <= end;
}

function isInRange(axis, a, b) {
  var size = {
    x: 'width',
    y: 'height'
  };

  return inRange(a[axis], b[axis], b[axis] + b[size[axis]]);
}

/**
 * Layout a straight connection
 *
 * @param {Bounds} source
 * @param {Bounds} target
 * @param {Point} start
 * @param {Point} end
 * @param {Object} [hints]
 *
 * @return {Array<Point>|null} waypoints if straight layout worked
 */
function tryLayoutStraight(source, target, start, end, hints) {
  var axis = {},
      primaryAxis,
      orientation;

  orientation = (0, _LayoutUtil.getOrientation)(source, target);

  // only layout a straight connection if shapes are
  // horizontally or vertically aligned
  if (!/^(top|bottom|left|right)$/.test(orientation)) {
    return null;
  }

  if (/top|bottom/.test(orientation)) {
    primaryAxis = 'x';
  }

  if (/left|right/.test(orientation)) {
    primaryAxis = 'y';
  }

  if (hints.preserveDocking === 'target') {

    if (!isInRange(primaryAxis, end, source)) {
      return null;
    }

    axis[primaryAxis] = end[primaryAxis];

    return [{
      x: axis.x !== undefined ? axis.x : start.x,
      y: axis.y !== undefined ? axis.y : start.y,
      original: {
        x: axis.x !== undefined ? axis.x : start.x,
        y: axis.y !== undefined ? axis.y : start.y
      }
    }, {
      x: end.x,
      y: end.y
    }];
  } else {

    if (!isInRange(primaryAxis, start, target)) {
      return null;
    }

    axis[primaryAxis] = start[primaryAxis];

    return [{
      x: start.x,
      y: start.y
    }, {
      x: axis.x !== undefined ? axis.x : end.x,
      y: axis.y !== undefined ? axis.y : end.y,
      original: {
        x: axis.x !== undefined ? axis.x : end.x,
        y: axis.y !== undefined ? axis.y : end.y
      }
    }];
  }
}

/**
 * Repair a connection from start.
 *
 * @param {Bounds} moved
 * @param {Bounds} other
 * @param {Point} newDocking
 * @param {Array<Point>} points originalPoints from moved to other
 *
 * @return {Array<Point>|null} the repaired points between the two rectangles
 */
function tryRepairConnectionStart(moved, other, newDocking, points) {
  return _tryRepairConnectionSide(moved, other, newDocking, points);
}

/**
 * Repair a connection from end.
 *
 * @param {Bounds} moved
 * @param {Bounds} other
 * @param {Point} newDocking
 * @param {Array<Point>} points originalPoints from moved to other
 *
 * @return {Array<Point>|null} the repaired points between the two rectangles
 */
function tryRepairConnectionEnd(moved, other, newDocking, points) {
  var waypoints = points.slice().reverse();

  waypoints = _tryRepairConnectionSide(moved, other, newDocking, waypoints);

  return waypoints ? waypoints.reverse() : null;
}

/**
 * Repair a connection from one side that moved.
 *
 * @param {Bounds} moved
 * @param {Bounds} other
 * @param {Point} newDocking
 * @param {Array<Point>} points originalPoints from moved to other
 *
 * @return {Array<Point>} the repaired points between the two rectangles
 */
function _tryRepairConnectionSide(moved, other, newDocking, points) {

  function needsRelayout(moved, other, points) {

    if (points.length < 3) {
      return true;
    }

    if (points.length > 4) {
      return false;
    }

    // relayout if two points overlap
    // this is most likely due to
    return !!(0, _minDash.find)(points, function (p, idx) {
      var q = points[idx - 1];

      return q && (0, _Geometry.pointDistance)(p, q) < 3;
    });
  }

  function repairBendpoint(candidate, oldPeer, newPeer) {

    var alignment = (0, _Geometry.pointsAligned)(oldPeer, candidate);

    switch (alignment) {
      case 'v':
        // repair horizontal alignment
        return { x: newPeer.x, y: candidate.y };
      case 'h':
        // repair vertical alignment
        return { x: candidate.x, y: newPeer.y };
    }

    return { x: candidate.x, y: candidate.y };
  }

  function removeOverlapping(points, a, b) {
    var i;

    for (i = points.length - 2; i !== 0; i--) {

      // intersects (?) break, remove all bendpoints up to this one and relayout
      if ((0, _Geometry.pointInRect)(points[i], a, INTERSECTION_THRESHOLD) || (0, _Geometry.pointInRect)(points[i], b, INTERSECTION_THRESHOLD)) {

        // return sliced old connection
        return points.slice(i);
      }
    }

    return points;
  }

  // (0) only repair what has layoutable bendpoints

  // (1) if only one bendpoint and on shape moved onto other shapes axis
  //     (horizontally / vertically), relayout

  if (needsRelayout(moved, other, points)) {
    return null;
  }

  var oldDocking = points[0],
      newPoints = points.slice(),
      slicedPoints;

  // (2) repair only last line segment and only if it was layouted before

  newPoints[0] = newDocking;
  newPoints[1] = repairBendpoint(newPoints[1], oldDocking, newDocking);

  // (3) if shape intersects with any bendpoint after repair,
  //     remove all segments up to this bendpoint and repair from there

  slicedPoints = removeOverlapping(newPoints, moved, other);

  if (slicedPoints !== newPoints) {
    return _tryRepairConnectionSide(moved, other, newDocking, slicedPoints);
  }

  return newPoints;
}

/**
 * Returns the manhattan directions connecting two rectangles
 * with the given orientation.
 *
 * Will always return the default layout, if it is specific
 * regarding sides already (trbl).
 *
 * @example
 *
 * getDirections('top'); // -> 'v:v'
 * getDirections('intersect'); // -> 't:t'
 *
 * getDirections('top-right', 'v:h'); // -> 'v:h'
 * getDirections('top-right', 'h:h'); // -> 'h:h'
 *
 *
 * @param {String} orientation
 * @param {String} defaultLayout
 *
 * @return {String}
 */
function getDirections(orientation, defaultLayout) {

  // don't override specific trbl directions
  if (isExplicitDirections(defaultLayout)) {
    return defaultLayout;
  }

  switch (orientation) {
    case 'intersect':
      return 't:t';

    case 'top':
    case 'bottom':
      return 'v:v';

    case 'left':
    case 'right':
      return 'h:h';

    // 'top-left'
    // 'top-right'
    // 'bottom-left'
    // 'bottom-right'
    default:
      return defaultLayout;
  }
}

function isValidDirections(directions) {
  return directions && /^h|v|t|r|b|l:h|v|t|r|b|l$/.test(directions);
}

function isExplicitDirections(directions) {
  return directions && /t|r|b|l/.test(directions);
}

function invertOrientation(orientation) {
  return {
    'top': 'bottom',
    'bottom': 'top',
    'left': 'right',
    'right': 'left',
    'top-left': 'bottom-right',
    'bottom-right': 'top-left',
    'top-right': 'bottom-left',
    'bottom-left': 'top-right'
  }[orientation];
}

function getDockingPoint(point, rectangle, dockingDirection, targetOrientation) {

  // ensure we end up with a specific docking direction
  // based on the targetOrientation, if <h|v> is being passed

  if (dockingDirection === 'h') {
    dockingDirection = /left/.test(targetOrientation) ? 'l' : 'r';
  }

  if (dockingDirection === 'v') {
    dockingDirection = /top/.test(targetOrientation) ? 't' : 'b';
  }

  if (dockingDirection === 't') {
    return { original: point, x: point.x, y: rectangle.y };
  }

  if (dockingDirection === 'r') {
    return { original: point, x: rectangle.x + rectangle.width, y: point.y };
  }

  if (dockingDirection === 'b') {
    return { original: point, x: point.x, y: rectangle.y + rectangle.height };
  }

  if (dockingDirection === 'l') {
    return { original: point, x: rectangle.x, y: point.y };
  }

  throw new Error('unexpected dockingDirection: <' + dockingDirection + '>');
}

/**
 * Return list of waypoints with redundant ones filtered out.
 *
 * @example
 *
 * Original points:
 *
 *   [x] ----- [x] ------ [x]
 *                         |
 *                        [x] ----- [x] - [x]
 *
 * Filtered:
 *
 *   [x] ---------------- [x]
 *                         |
 *                        [x] ----------- [x]
 *
 * @param  {Array<Point>} waypoints
 *
 * @return {Array<Point>}
 */
function withoutRedundantPoints(waypoints) {
  return waypoints.reduce(function (points, p, idx) {

    var previous = points[points.length - 1],
        next = waypoints[idx + 1];

    if (!(0, _Geometry.pointsOnLine)(previous, next, p, 0)) {
      points.push(p);
    }

    return points;
  }, []);
}

},{"221":221,"238":238,"254":254}],223:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Base = Base;
exports.Shape = Shape;
exports.Root = Root;
exports.Label = Label;
exports.Connection = Connection;
exports.create = create;

var _minDash = _dereq_(254);

var _inherits = _dereq_(253);

var _inherits2 = _interopRequireDefault(_inherits);

var _objectRefs = _dereq_(269);

var _objectRefs2 = _interopRequireDefault(_objectRefs);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var parentRefs = new _objectRefs2.default({ name: 'children', enumerable: true, collection: true }, { name: 'parent' }),
    labelRefs = new _objectRefs2.default({ name: 'labels', enumerable: true, collection: true }, { name: 'labelTarget' }),
    attacherRefs = new _objectRefs2.default({ name: 'attachers', collection: true }, { name: 'host' }),
    outgoingRefs = new _objectRefs2.default({ name: 'outgoing', collection: true }, { name: 'source' }),
    incomingRefs = new _objectRefs2.default({ name: 'incoming', collection: true }, { name: 'target' });

/**
 * @namespace djs.model
 */

/**
 * @memberOf djs.model
 */

/**
 * The basic graphical representation
 *
 * @class
 *
 * @abstract
 */
function Base() {

  /**
   * The object that backs up the shape
   *
   * @name Base#businessObject
   * @type Object
   */
  Object.defineProperty(this, 'businessObject', {
    writable: true
  });

  /**
   * Single label support, will mapped to multi label array
   *
   * @name Base#label
   * @type Object
   */
  Object.defineProperty(this, 'label', {
    get: function get() {
      return this.labels[0];
    },
    set: function set(newLabel) {

      var label = this.label,
          labels = this.labels;

      if (!newLabel && label) {
        labels.remove(label);
      } else {
        labels.add(newLabel, 0);
      }
    }
  });

  /**
   * The parent shape
   *
   * @name Base#parent
   * @type Shape
   */
  parentRefs.bind(this, 'parent');

  /**
   * The list of labels
   *
   * @name Base#labels
   * @type Label
   */
  labelRefs.bind(this, 'labels');

  /**
   * The list of outgoing connections
   *
   * @name Base#outgoing
   * @type Array<Connection>
   */
  outgoingRefs.bind(this, 'outgoing');

  /**
   * The list of incoming connections
   *
   * @name Base#incoming
   * @type Array<Connection>
   */
  incomingRefs.bind(this, 'incoming');
}

/**
 * A graphical object
 *
 * @class
 * @constructor
 *
 * @extends Base
 */
function Shape() {
  Base.call(this);

  /**
   * Indicates frame shapes
   *
   * @name Shape#isFrame
   * @type Boolean
   */

  /**
   * The list of children
   *
   * @name Shape#children
   * @type Array<Base>
   */
  parentRefs.bind(this, 'children');

  /**
   * @name Shape#host
   * @type Shape
   */
  attacherRefs.bind(this, 'host');

  /**
   * @name Shape#attachers
   * @type Shape
   */
  attacherRefs.bind(this, 'attachers');
}

(0, _inherits2.default)(Shape, Base);

/**
 * A root graphical object
 *
 * @class
 * @constructor
 *
 * @extends Shape
 */
function Root() {
  Shape.call(this);
}

(0, _inherits2.default)(Root, Shape);

/**
 * A label for an element
 *
 * @class
 * @constructor
 *
 * @extends Shape
 */
function Label() {
  Shape.call(this);

  /**
   * The labeled element
   *
   * @name Label#labelTarget
   * @type Base
   */
  labelRefs.bind(this, 'labelTarget');
}

(0, _inherits2.default)(Label, Shape);

/**
 * A connection between two elements
 *
 * @class
 * @constructor
 *
 * @extends Base
 */
function Connection() {
  Base.call(this);

  /**
   * The element this connection originates from
   *
   * @name Connection#source
   * @type Base
   */
  outgoingRefs.bind(this, 'source');

  /**
   * The element this connection points to
   *
   * @name Connection#target
   * @type Base
   */
  incomingRefs.bind(this, 'target');
}

(0, _inherits2.default)(Connection, Base);

var types = {
  connection: Connection,
  shape: Shape,
  label: Label,
  root: Root
};

/**
 * Creates a new model element of the specified type
 *
 * @method create
 *
 * @example
 *
 * var shape1 = Model.create('shape', { x: 10, y: 10, width: 100, height: 100 });
 * var shape2 = Model.create('shape', { x: 210, y: 210, width: 100, height: 100 });
 *
 * var connection = Model.create('connection', { waypoints: [ { x: 110, y: 55 }, {x: 210, y: 55 } ] });
 *
 * @param  {String} type lower-cased model name
 * @param  {Object} attrs attributes to initialize the new model instance with
 *
 * @return {Base} the new model instance
 */
function create(type, attrs) {
  var Type = types[type];
  if (!Type) {
    throw new Error('unknown type: <' + type + '>');
  }
  return (0, _minDash.assign)(new Type(), attrs);
}

},{"253":253,"254":254,"269":269}],224:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = KeyboardMove;

var _minDash = _dereq_(254);

var DEFAULT_CONFIG = {
  moveSpeed: 50,
  moveSpeedAccelerated: 200
};

/**
 * A feature that allows users to move the canvas using the keyboard.
 *
 * @param {Object} config
 * @param {Number} [config.moveSpeed=50]
 * @param {Number} [config.moveSpeedAccelerated=200]
 * @param {Keyboard} keyboard
 * @param {Canvas} canvas
 */
function KeyboardMove(config, keyboard, canvas) {

  var self = this;

  this._config = (0, _minDash.assign)({}, DEFAULT_CONFIG, config || {});

  keyboard.addListener(arrowsListener);

  function arrowsListener(context) {

    var event = context.keyEvent,
        config = self._config;

    if (!keyboard.isCmd(event)) {
      return;
    }

    if (keyboard.isKey(['ArrowLeft', 'Left', 'ArrowUp', 'Up', 'ArrowDown', 'Down', 'ArrowRight', 'Right'], event)) {

      var speed = keyboard.isShift(event) ? config.moveSpeedAccelerated : config.moveSpeed;

      var direction;

      switch (event.key) {
        case 'ArrowLeft':
        case 'Left':
          direction = 'left';
          break;
        case 'ArrowUp':
        case 'Up':
          direction = 'up';
          break;
        case 'ArrowRight':
        case 'Right':
          direction = 'right';
          break;
        case 'ArrowDown':
        case 'Down':
          direction = 'down';
          break;
      }

      self.moveCanvas({
        speed: speed,
        direction: direction
      });

      return true;
    }
  }

  this.moveCanvas = function (opts) {

    var dx = 0,
        dy = 0,
        speed = opts.speed;

    var actualSpeed = speed / Math.min(Math.sqrt(canvas.viewbox().scale), 1);

    switch (opts.direction) {
      case 'left':
        // Left
        dx = actualSpeed;
        break;
      case 'up':
        // Up
        dy = actualSpeed;
        break;
      case 'right':
        // Right
        dx = -actualSpeed;
        break;
      case 'down':
        // Down
        dy = -actualSpeed;
        break;
    }

    canvas.scroll({
      dx: dx,
      dy: dy
    });
  };
}

KeyboardMove.$inject = ['config.keyboardMove', 'keyboard', 'canvas'];

},{"254":254}],225:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _keyboard = _dereq_(145);

var _keyboard2 = _interopRequireDefault(_keyboard);

var _KeyboardMove = _dereq_(224);

var _KeyboardMove2 = _interopRequireDefault(_KeyboardMove);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __depends__: [_keyboard2.default],
  __init__: ['keyboardMove'],
  keyboardMove: ['type', _KeyboardMove2.default]
};

},{"145":145,"224":224}],226:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MoveCanvas;

var _Cursor = _dereq_(234);

var _ClickTrap = _dereq_(232);

var _PositionUtil = _dereq_(245);

var _minDom = _dereq_(255);

var _Event = _dereq_(237);

var THRESHOLD = 15;

/**
 * Move the canvas via mouse.
 *
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 */
function MoveCanvas(eventBus, canvas) {

  var context;

  // listen for move on element mouse down;
  // allow others to hook into the event before us though
  // (dragging / element moving will do this)
  eventBus.on('element.mousedown', 500, function (e) {
    return handleStart(e.originalEvent);
  });

  function handleMove(event) {

    var start = context.start,
        position = (0, _Event.toPoint)(event),
        delta = (0, _PositionUtil.delta)(position, start);

    if (!context.dragging && length(delta) > THRESHOLD) {
      context.dragging = true;

      (0, _ClickTrap.install)(eventBus);

      (0, _Cursor.set)('grab');
    }

    if (context.dragging) {

      var lastPosition = context.last || context.start;

      delta = (0, _PositionUtil.delta)(position, lastPosition);

      canvas.scroll({
        dx: delta.x,
        dy: delta.y
      });

      context.last = position;
    }

    // prevent select
    event.preventDefault();
  }

  function handleEnd(event) {
    _minDom.event.unbind(document, 'mousemove', handleMove);
    _minDom.event.unbind(document, 'mouseup', handleEnd);

    context = null;

    (0, _Cursor.unset)();
  }

  function handleStart(event) {
    // event is already handled by '.djs-draggable'
    if ((0, _minDom.closest)(event.target, '.djs-draggable')) {
      return;
    }

    // reject non-left left mouse button or modifier key
    if (event.button || event.ctrlKey || event.shiftKey || event.altKey) {
      return;
    }

    context = {
      start: (0, _Event.toPoint)(event)
    };

    _minDom.event.bind(document, 'mousemove', handleMove);
    _minDom.event.bind(document, 'mouseup', handleEnd);

    // we've handled the event
    return true;
  }
}

MoveCanvas.$inject = ['eventBus', 'canvas'];

// helpers ///////

function length(point) {
  return Math.sqrt(Math.pow(point.x, 2) + Math.pow(point.y, 2));
}

},{"232":232,"234":234,"237":237,"245":245,"255":255}],227:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _MoveCanvas = _dereq_(226);

var _MoveCanvas2 = _interopRequireDefault(_MoveCanvas);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['moveCanvas'],
  moveCanvas: ['type', _MoveCanvas2.default]
};

},{"226":226}],228:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ZoomScroll;

var _minDom = _dereq_(255);

var _ZoomUtil = _dereq_(229);

var _Math = _dereq_(242);

var _minDash = _dereq_(254);

var sign = Math.sign || function (n) {
  return n >= 0 ? 1 : -1;
};

var RANGE = { min: 0.2, max: 4 },
    NUM_STEPS = 10;

var DELTA_THRESHOLD = 0.1;

var DEFAULT_SCALE = 0.75;

/**
 * An implementation of zooming and scrolling within the
 * {@link Canvas} via the mouse wheel.
 *
 * Mouse wheel zooming / scrolling may be disabled using
 * the {@link toggle(enabled)} method.
 *
 * @param {Object} [config]
 * @param {Boolean} [config.enabled=true] default enabled state
 * @param {Number} [config.scale=.75] scroll sensivity
 * @param {EventBus} eventBus
 * @param {Canvas} canvas
 */
function ZoomScroll(config, eventBus, canvas) {

  config = config || {};

  this._enabled = false;

  this._canvas = canvas;
  this._container = canvas._container;

  this._handleWheel = (0, _minDash.bind)(this._handleWheel, this);

  this._totalDelta = 0;
  this._scale = config.scale || DEFAULT_SCALE;

  var self = this;

  eventBus.on('canvas.init', function (e) {
    self._init(config.enabled !== false);
  });
}

ZoomScroll.$inject = ['config.zoomScroll', 'eventBus', 'canvas'];

ZoomScroll.prototype.scroll = function scroll(delta) {
  this._canvas.scroll(delta);
};

ZoomScroll.prototype.reset = function reset() {
  this._canvas.zoom('fit-viewport');
};

/**
 * Zoom depending on delta.
 *
 * @param {number} delta
 * @param {Object} position
 */
ZoomScroll.prototype.zoom = function zoom(delta, position) {

  // zoom with half the step size of stepZoom
  var stepSize = (0, _ZoomUtil.getStepSize)(RANGE, NUM_STEPS * 2);

  // add until threshold reached
  this._totalDelta += delta;

  if (Math.abs(this._totalDelta) > DELTA_THRESHOLD) {
    this._zoom(delta, position, stepSize);

    // reset
    this._totalDelta = 0;
  }
};

ZoomScroll.prototype._handleWheel = function handleWheel(event) {
  // event is already handled by '.djs-scrollable'
  if ((0, _minDom.closest)(event.target, '.djs-scrollable', true)) {
    return;
  }

  var element = this._container;

  event.preventDefault();

  // pinch to zoom is mapped to wheel + ctrlKey = true
  // in modern browsers (!)

  var isZoom = event.ctrlKey;

  var isHorizontalScroll = event.shiftKey;

  var factor = -1 * this._scale,
      delta;

  if (isZoom) {
    factor *= event.deltaMode === 0 ? 0.020 : 0.32;
  } else {
    factor *= event.deltaMode === 0 ? 1.0 : 16.0;
  }

  if (isZoom) {
    var elementRect = element.getBoundingClientRect();

    var offset = {
      x: event.clientX - elementRect.left,
      y: event.clientY - elementRect.top
    };

    delta = Math.sqrt(Math.pow(event.deltaY, 2) + Math.pow(event.deltaX, 2)) * sign(event.deltaY) * factor;

    // zoom in relative to diagram {x,y} coordinates
    this.zoom(delta, offset);
  } else {

    if (isHorizontalScroll) {
      delta = {
        dx: factor * event.deltaY,
        dy: 0
      };
    } else {
      delta = {
        dx: factor * event.deltaX,
        dy: factor * event.deltaY
      };
    }

    this.scroll(delta);
  }
};

/**
 * Zoom with fixed step size.
 *
 * @param {number} delta - Zoom delta (1 for zooming in, -1 for out).
 * @param {Object} position
 */
ZoomScroll.prototype.stepZoom = function stepZoom(delta, position) {

  var stepSize = (0, _ZoomUtil.getStepSize)(RANGE, NUM_STEPS);

  this._zoom(delta, position, stepSize);
};

/**
 * Zoom in/out given a step size.
 *
 * @param {number} delta
 * @param {Object} position
 * @param {number} stepSize
 */
ZoomScroll.prototype._zoom = function (delta, position, stepSize) {
  var canvas = this._canvas;

  var direction = delta > 0 ? 1 : -1;

  var currentLinearZoomLevel = (0, _Math.log10)(canvas.zoom());

  // snap to a proximate zoom step
  var newLinearZoomLevel = Math.round(currentLinearZoomLevel / stepSize) * stepSize;

  // increase or decrease one zoom step in the given direction
  newLinearZoomLevel += stepSize * direction;

  // calculate the absolute logarithmic zoom level based on the linear zoom level
  // (e.g. 2 for an absolute x2 zoom)
  var newLogZoomLevel = Math.pow(10, newLinearZoomLevel);

  canvas.zoom((0, _ZoomUtil.cap)(RANGE, newLogZoomLevel), position);
};

/**
 * Toggle the zoom scroll ability via mouse wheel.
 *
 * @param  {Boolean} [newEnabled] new enabled state
 */
ZoomScroll.prototype.toggle = function toggle(newEnabled) {

  var element = this._container;
  var handleWheel = this._handleWheel;

  var oldEnabled = this._enabled;

  if (typeof newEnabled === 'undefined') {
    newEnabled = !oldEnabled;
  }

  // only react on actual changes
  if (oldEnabled !== newEnabled) {

    // add or remove wheel listener based on
    // changed enabled state
    _minDom.event[newEnabled ? 'bind' : 'unbind'](element, 'wheel', handleWheel, false);
  }

  this._enabled = newEnabled;

  return newEnabled;
};

ZoomScroll.prototype._init = function (newEnabled) {
  this.toggle(newEnabled);
};

},{"229":229,"242":242,"254":254,"255":255}],229:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStepSize = getStepSize;
exports.cap = cap;

var _Math = _dereq_(242);

/**
 * Get step size for given range and number of steps.
 *
 * @param {Object} range
 * @param {number} range.min
 * @param {number} range.max
 */
function getStepSize(range, steps) {

  var minLinearRange = (0, _Math.log10)(range.min),
      maxLinearRange = (0, _Math.log10)(range.max);

  var absoluteLinearRange = Math.abs(minLinearRange) + Math.abs(maxLinearRange);

  return absoluteLinearRange / steps;
}

function cap(range, scale) {
  return Math.max(range.min, Math.min(range.max, scale));
}

},{"242":242}],230:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ZoomScroll = _dereq_(228);

var _ZoomScroll2 = _interopRequireDefault(_ZoomScroll);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  __init__: ['zoomScroll'],
  zoomScroll: ['type', _ZoomScroll2.default]
};

},{"228":228}],231:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNewAttachPoint = getNewAttachPoint;
exports.getNewAttachShapeDelta = getNewAttachShapeDelta;

var _LayoutUtil = _dereq_(221);

var _PositionUtil = _dereq_(245);

/**
 * Calculates the absolute point relative to the new element's position
 *
 * @param {point} point [absolute]
 * @param {bounds} oldBounds
 * @param {bounds} newBounds
 *
 * @return {point} point [absolute]
 */
function getNewAttachPoint(point, oldBounds, newBounds) {
  var oldCenter = (0, _PositionUtil.center)(oldBounds),
      newCenter = (0, _PositionUtil.center)(newBounds),
      oldDelta = (0, _PositionUtil.delta)(point, oldCenter);

  var newDelta = {
    x: oldDelta.x * (newBounds.width / oldBounds.width),
    y: oldDelta.y * (newBounds.height / oldBounds.height)
  };

  return (0, _LayoutUtil.roundPoint)({
    x: newCenter.x + newDelta.x,
    y: newCenter.y + newDelta.y
  });
}

/**
 * Calculates the shape's delta relative to a new position
 * of a certain element's bounds
 *
 * @param {djs.model.Shape} point [absolute]
 * @param {bounds} oldBounds
 * @param {bounds} newBounds
 *
 * @return {delta} delta
 */
function getNewAttachShapeDelta(shape, oldBounds, newBounds) {
  var shapeCenter = (0, _PositionUtil.center)(shape),
      oldCenter = (0, _PositionUtil.center)(oldBounds),
      newCenter = (0, _PositionUtil.center)(newBounds),
      shapeDelta = (0, _PositionUtil.delta)(shape, shapeCenter),
      oldCenterDelta = (0, _PositionUtil.delta)(shapeCenter, oldCenter);

  var newCenterDelta = {
    x: oldCenterDelta.x * (newBounds.width / oldBounds.width),
    y: oldCenterDelta.y * (newBounds.height / oldBounds.height)
  };

  var newShapeCenter = {
    x: newCenter.x + newCenterDelta.x,
    y: newCenter.y + newCenterDelta.y
  };

  return (0, _LayoutUtil.roundPoint)({
    x: newShapeCenter.x + shapeDelta.x - shape.x,
    y: newShapeCenter.y + shapeDelta.y - shape.y
  });
}

},{"221":221,"245":245}],232:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.install = install;
var TRAP_PRIORITY = 5000;

/**
 * Installs a click trap that prevents a ghost click following a dragging operation.
 *
 * @return {Function} a function to immediately remove the installed trap.
 */
function install(eventBus, eventName) {

  eventName = eventName || 'element.click';

  function trap() {
    return false;
  }

  eventBus.once(eventName, TRAP_PRIORITY, trap);

  return function () {
    eventBus.off(eventName, trap);
  };
}

},{}],233:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.remove = remove;
exports.add = add;
exports.indexOf = indexOf;
/**
 * Failsafe remove an element from a collection
 *
 * @param  {Array<Object>} [collection]
 * @param  {Object} [element]
 *
 * @return {Number} the previous index of the element
 */
function remove(collection, element) {

  if (!collection || !element) {
    return -1;
  }

  var idx = collection.indexOf(element);

  if (idx !== -1) {
    collection.splice(idx, 1);
  }

  return idx;
}

/**
 * Fail save add an element to the given connection, ensuring
 * it does not yet exist.
 *
 * @param {Array<Object>} collection
 * @param {Object} element
 * @param {Number} idx
 */
function add(collection, element, idx) {

  if (!collection || !element) {
    return;
  }

  if (typeof idx !== 'number') {
    idx = -1;
  }

  var currentIdx = collection.indexOf(element);

  if (currentIdx !== -1) {

    if (currentIdx === idx) {
      // nothing to do, position has not changed
      return;
    } else {

      if (idx !== -1) {
        // remove from current position
        collection.splice(currentIdx, 1);
      } else {
        // already exists in collection
        return;
      }
    }
  }

  if (idx !== -1) {
    // insert at specified position
    collection.splice(idx, 0, element);
  } else {
    // push to end
    collection.push(element);
  }
}

/**
 * Fail save get the index of an element in a collection.
 *
 * @param {Array<Object>} collection
 * @param {Object} element
 *
 * @return {Number} the index or -1 if collection or element do
 *                  not exist or the element is not contained.
 */
function indexOf(collection, element) {

  if (!collection || !element) {
    return -1;
  }

  return collection.indexOf(element);
}

},{}],234:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.set = set;
exports.unset = unset;
exports.has = has;

var _minDom = _dereq_(255);

var CURSOR_CLS_PATTERN = /^djs-cursor-.*$/;

function set(mode) {
  var classes = (0, _minDom.classes)(document.body);

  classes.removeMatching(CURSOR_CLS_PATTERN);

  if (mode) {
    classes.add('djs-cursor-' + mode);
  }
}

function unset() {
  set(null);
}

function has(mode) {
  var classes = (0, _minDom.classes)(document.body);

  return classes.has('djs-cursor-' + mode);
}

},{"255":255}],235:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.add = add;
exports.eachElement = eachElement;
exports.selfAndChildren = selfAndChildren;
exports.selfAndDirectChildren = selfAndDirectChildren;
exports.selfAndAllChildren = selfAndAllChildren;
exports.getClosure = getClosure;
exports.getBBox = getBBox;
exports.getEnclosedElements = getEnclosedElements;
exports.getType = getType;
exports.isFrameElement = isFrameElement;

var _minDash = _dereq_(254);

/**
 * Adds an element to a collection and returns true if the
 * element was added.
 *
 * @param {Array<Object>} elements
 * @param {Object} e
 * @param {Boolean} unique
 */
function add(elements, e, unique) {
  var canAdd = !unique || elements.indexOf(e) === -1;

  if (canAdd) {
    elements.push(e);
  }

  return canAdd;
}

/**
 * Iterate over each element in a collection, calling the iterator function `fn`
 * with (element, index, recursionDepth).
 *
 * Recurse into all elements that are returned by `fn`.
 *
 * @param  {Object|Array<Object>} elements
 * @param  {Function} fn iterator function called with (element, index, recursionDepth)
 * @param  {Number} [depth] maximum recursion depth
 */
function eachElement(elements, fn, depth) {

  depth = depth || 0;

  if (!(0, _minDash.isArray)(elements)) {
    elements = [elements];
  }

  (0, _minDash.forEach)(elements, function (s, i) {
    var filter = fn(s, i, depth);

    if ((0, _minDash.isArray)(filter) && filter.length) {
      eachElement(filter, fn, depth + 1);
    }
  });
}

/**
 * Collects self + child elements up to a given depth from a list of elements.
 *
 * @param  {djs.model.Base|Array<djs.model.Base>} elements the elements to select the children from
 * @param  {Boolean} unique whether to return a unique result set (no duplicates)
 * @param  {Number} maxDepth the depth to search through or -1 for infinite
 *
 * @return {Array<djs.model.Base>} found elements
 */
function selfAndChildren(elements, unique, maxDepth) {
  var result = [],
      processedChildren = [];

  eachElement(elements, function (element, i, depth) {
    add(result, element, unique);

    var children = element.children;

    // max traversal depth not reached yet
    if (maxDepth === -1 || depth < maxDepth) {

      // children exist && children not yet processed
      if (children && add(processedChildren, children, unique)) {
        return children;
      }
    }
  });

  return result;
}

/**
 * Return self + direct children for a number of elements
 *
 * @param  {Array<djs.model.Base>} elements to query
 * @param  {Boolean} allowDuplicates to allow duplicates in the result set
 *
 * @return {Array<djs.model.Base>} the collected elements
 */
function selfAndDirectChildren(elements, allowDuplicates) {
  return selfAndChildren(elements, !allowDuplicates, 1);
}

/**
 * Return self + ALL children for a number of elements
 *
 * @param  {Array<djs.model.Base>} elements to query
 * @param  {Boolean} allowDuplicates to allow duplicates in the result set
 *
 * @return {Array<djs.model.Base>} the collected elements
 */
function selfAndAllChildren(elements, allowDuplicates) {
  return selfAndChildren(elements, !allowDuplicates, -1);
}

/**
 * Gets the the closure for all selected elements,
 * their enclosed children and connections.
 *
 * @param {Array<djs.model.Base>} elements
 * @param {Boolean} [isTopLevel=true]
 * @param {Object} [existingClosure]
 *
 * @return {Object} newClosure
 */
function getClosure(elements, isTopLevel, closure) {

  if ((0, _minDash.isUndefined)(isTopLevel)) {
    isTopLevel = true;
  }

  if ((0, _minDash.isObject)(isTopLevel)) {
    closure = isTopLevel;
    isTopLevel = true;
  }

  closure = closure || {};

  var allShapes = copyObject(closure.allShapes),
      allConnections = copyObject(closure.allConnections),
      enclosedElements = copyObject(closure.enclosedElements),
      enclosedConnections = copyObject(closure.enclosedConnections);

  var topLevel = copyObject(closure.topLevel, isTopLevel && (0, _minDash.groupBy)(elements, function (e) {
    return e.id;
  }));

  function handleConnection(c) {
    if (topLevel[c.source.id] && topLevel[c.target.id]) {
      topLevel[c.id] = [c];
    }

    // not enclosed as a child, but maybe logically
    // (connecting two moved elements?)
    if (allShapes[c.source.id] && allShapes[c.target.id]) {
      enclosedConnections[c.id] = enclosedElements[c.id] = c;
    }

    allConnections[c.id] = c;
  }

  function handleElement(element) {

    enclosedElements[element.id] = element;

    if (element.waypoints) {
      // remember connection
      enclosedConnections[element.id] = allConnections[element.id] = element;
    } else {
      // remember shape
      allShapes[element.id] = element;

      // remember all connections
      (0, _minDash.forEach)(element.incoming, handleConnection);

      (0, _minDash.forEach)(element.outgoing, handleConnection);

      // recurse into children
      return element.children;
    }
  }

  eachElement(elements, handleElement);

  return {
    allShapes: allShapes,
    allConnections: allConnections,
    topLevel: topLevel,
    enclosedConnections: enclosedConnections,
    enclosedElements: enclosedElements
  };
}

/**
 * Returns the surrounding bbox for all elements in
 * the array or the element primitive.
 *
 * @param {Array<djs.model.Shape>|djs.model.Shape} elements
 * @param {Boolean} stopRecursion
 */
function getBBox(elements, stopRecursion) {

  stopRecursion = !!stopRecursion;
  if (!(0, _minDash.isArray)(elements)) {
    elements = [elements];
  }

  var minX, minY, maxX, maxY;

  (0, _minDash.forEach)(elements, function (element) {

    // If element is a connection the bbox must be computed first
    var bbox = element;
    if (element.waypoints && !stopRecursion) {
      bbox = getBBox(element.waypoints, true);
    }

    var x = bbox.x,
        y = bbox.y,
        height = bbox.height || 0,
        width = bbox.width || 0;

    if (x < minX || minX === undefined) {
      minX = x;
    }
    if (y < minY || minY === undefined) {
      minY = y;
    }

    if (x + width > maxX || maxX === undefined) {
      maxX = x + width;
    }
    if (y + height > maxY || maxY === undefined) {
      maxY = y + height;
    }
  });

  return {
    x: minX,
    y: minY,
    height: maxY - minY,
    width: maxX - minX
  };
}

/**
 * Returns all elements that are enclosed from the bounding box.
 *
 *   * If bbox.(width|height) is not specified the method returns
 *     all elements with element.x/y > bbox.x/y
 *   * If only bbox.x or bbox.y is specified, method return all elements with
 *     e.x > bbox.x or e.y > bbox.y
 *
 * @param {Array<djs.model.Shape>} elements List of Elements to search through
 * @param {djs.model.Shape} bbox the enclosing bbox.
 *
 * @return {Array<djs.model.Shape>} enclosed elements
 */
function getEnclosedElements(elements, bbox) {

  var filteredElements = {};

  (0, _minDash.forEach)(elements, function (element) {

    var e = element;

    if (e.waypoints) {
      e = getBBox(e);
    }

    if (!(0, _minDash.isNumber)(bbox.y) && e.x > bbox.x) {
      filteredElements[element.id] = element;
    }
    if (!(0, _minDash.isNumber)(bbox.x) && e.y > bbox.y) {
      filteredElements[element.id] = element;
    }
    if (e.x > bbox.x && e.y > bbox.y) {
      if ((0, _minDash.isNumber)(bbox.width) && (0, _minDash.isNumber)(bbox.height) && e.width + e.x < bbox.width + bbox.x && e.height + e.y < bbox.height + bbox.y) {

        filteredElements[element.id] = element;
      } else if (!(0, _minDash.isNumber)(bbox.width) || !(0, _minDash.isNumber)(bbox.height)) {
        filteredElements[element.id] = element;
      }
    }
  });

  return filteredElements;
}

function getType(element) {

  if ('waypoints' in element) {
    return 'connection';
  }

  if ('x' in element) {
    return 'shape';
  }

  return 'root';
}

function isFrameElement(element) {

  return !!(element && element.isFrame);
}

// helpers ///////////////////////////////

function copyObject(src1, src2) {
  return (0, _minDash.assign)({}, src1 || {}, src2 || {});
}

},{"254":254}],236:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _css = _dereq_(85);

Object.defineProperty(exports, 'escapeCSS', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_css).default;
  }
});
exports.escapeHTML = escapeHTML;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HTML_ESCAPE_MAP = {
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;',
  '"': '&quot;',
  '\'': '&#39;'
};

function escapeHTML(str) {
  str = '' + str;

  return str && str.replace(/[&<>"']/g, function (match) {
    return HTML_ESCAPE_MAP[match];
  });
}

},{"85":85}],237:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOriginal = getOriginal;
exports.stopPropagation = stopPropagation;
exports.toPoint = toPoint;
function __stopPropagation(event) {
  if (!event || typeof event.stopPropagation !== 'function') {
    return;
  }

  event.stopPropagation();
}

function getOriginal(event) {
  return event.originalEvent || event.srcEvent;
}

function stopPropagation(event, immediate) {
  __stopPropagation(event, immediate);
  __stopPropagation(getOriginal(event), immediate);
}

function toPoint(event) {

  if (event.pointers && event.pointers.length) {
    event = event.pointers[0];
  }

  if (event.touches && event.touches.length) {
    event = event.touches[0];
  }

  return event ? {
    x: event.clientX,
    y: event.clientY
  } : null;
}

},{}],238:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pointDistance = pointDistance;
exports.pointsOnLine = pointsOnLine;
exports.pointsAligned = pointsAligned;
exports.pointInRect = pointInRect;
exports.getMidPoint = getMidPoint;
/**
 * Computes the distance between two points
 *
 * @param  {Point}  p
 * @param  {Point}  q
 *
 * @return {Number}  distance
 */
function pointDistance(a, b) {
  if (!a || !b) {
    return -1;
  }

  return Math.sqrt(Math.pow(a.x - b.x, 2) + Math.pow(a.y - b.y, 2));
}

/**
 * Returns true if the point r is on the line between p and q
 *
 * @param  {Point}  p
 * @param  {Point}  q
 * @param  {Point}  r
 * @param  {Number} [accuracy=5] accuracy for points on line check (lower is better)
 *
 * @return {Boolean}
 */
function pointsOnLine(p, q, r, accuracy) {

  if (typeof accuracy === 'undefined') {
    accuracy = 5;
  }

  if (!p || !q || !r) {
    return false;
  }

  var val = (q.x - p.x) * (r.y - p.y) - (q.y - p.y) * (r.x - p.x),
      dist = pointDistance(p, q);

  // @see http://stackoverflow.com/a/907491/412190
  return Math.abs(val / dist) <= accuracy;
}

var ALIGNED_THRESHOLD = 2;

/**
 * Returns whether two points are in a horizontal or vertical line.
 *
 * @param {Point} a
 * @param {Point} b
 *
 * @return {String|Boolean} returns false if the points are not
 *                          aligned or 'h|v' if they are aligned
 *                          horizontally / vertically.
 */
function pointsAligned(a, b) {
  if (Math.abs(a.x - b.x) <= ALIGNED_THRESHOLD) {
    return 'v';
  }

  if (Math.abs(a.y - b.y) <= ALIGNED_THRESHOLD) {
    return 'h';
  }

  return false;
}

/**
 * Returns true if the point p is inside the rectangle rect
 *
 * @param  {Point}  p
 * @param  {Rect}   rect
 * @param  {Number} tolerance
 *
 * @return {Boolean}
 */
function pointInRect(p, rect, tolerance) {
  tolerance = tolerance || 0;

  return p.x > rect.x - tolerance && p.y > rect.y - tolerance && p.x < rect.x + rect.width + tolerance && p.y < rect.y + rect.height + tolerance;
}

/**
 * Returns a point in the middle of points p and q
 *
 * @param  {Point}  p
 * @param  {Point}  q
 *
 * @return {Point} middle point
 */
function getMidPoint(p, q) {
  return {
    x: Math.round(p.x + (q.x - p.x) / 2.0),
    y: Math.round(p.y + (q.y - p.y) / 2.0)
  };
}

},{}],239:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVisual = getVisual;
exports.getChildren = getChildren;

var _minDom = _dereq_(255);

/**
 * SVGs for elements are generated by the {@link GraphicsFactory}.
 *
 * This utility gives quick access to the important semantic
 * parts of an element.
 */

/**
 * Returns the visual part of a diagram element
 *
 * @param {Snap<SVGElement>} gfx
 *
 * @return {Snap<SVGElement>}
 */
function getVisual(gfx) {
  return (0, _minDom.query)('.djs-visual', gfx);
}

/**
 * Returns the children for a given diagram element.
 *
 * @param {Snap<SVGElement>} gfx
 * @return {Snap<SVGElement>}
 */
function getChildren(gfx) {
  return gfx.parentNode.childNodes[1];
}

},{"255":255}],240:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = IdGenerator;
/**
 * Util that provides unique IDs.
 *
 * @class djs.util.IdGenerator
 * @constructor
 * @memberOf djs.util
 *
 * The ids can be customized via a given prefix and contain a random value to avoid collisions.
 *
 * @param {String} prefix a prefix to prepend to generated ids (for better readability)
 */
function IdGenerator(prefix) {

  this._counter = 0;
  this._prefix = (prefix ? prefix + '-' : '') + Math.floor(Math.random() * 1000000000) + '-';
}

/**
 * Returns a next unique ID.
 *
 * @method djs.util.IdGenerator#next
 *
 * @returns {String} the id
 */
IdGenerator.prototype.next = function () {
  return this._prefix + ++this._counter;
};

},{}],241:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApproxIntersection = getApproxIntersection;

var _Geometry = _dereq_(238);

var _pathIntersection = _dereq_(272);

var _pathIntersection2 = _interopRequireDefault(_pathIntersection);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var round = Math.round,
    max = Math.max;

function circlePath(center, r) {
  var x = center.x,
      y = center.y;

  return [['M', x, y], ['m', 0, -r], ['a', r, r, 0, 1, 1, 0, 2 * r], ['a', r, r, 0, 1, 1, 0, -2 * r], ['z']];
}

function linePath(points) {
  var segments = [];

  points.forEach(function (p, idx) {
    segments.push([idx === 0 ? 'M' : 'L', p.x, p.y]);
  });

  return segments;
}

var INTERSECTION_THRESHOLD = 10;

function getBendpointIntersection(waypoints, reference) {

  var i, w;

  for (i = 0; w = waypoints[i]; i++) {

    if ((0, _Geometry.pointDistance)(w, reference) <= INTERSECTION_THRESHOLD) {
      return {
        point: waypoints[i],
        bendpoint: true,
        index: i
      };
    }
  }

  return null;
}

function getPathIntersection(waypoints, reference) {

  var intersections = (0, _pathIntersection2.default)(circlePath(reference, INTERSECTION_THRESHOLD), linePath(waypoints));

  var a = intersections[0],
      b = intersections[intersections.length - 1],
      idx;

  if (!a) {
    // no intersection
    return null;
  }

  if (a !== b) {

    if (a.segment2 !== b.segment2) {
      // we use the bendpoint in between both segments
      // as the intersection point

      idx = max(a.segment2, b.segment2) - 1;

      return {
        point: waypoints[idx],
        bendpoint: true,
        index: idx
      };
    }

    return {
      point: {
        x: round(a.x + b.x) / 2,
        y: round(a.y + b.y) / 2
      },
      index: a.segment2
    };
  }

  return {
    point: {
      x: round(a.x),
      y: round(a.y)
    },
    index: a.segment2
  };
}

/**
 * Returns the closest point on the connection towards a given reference point.
 *
 * @param  {Array<Point>} waypoints
 * @param  {Point} reference
 *
 * @return {Object} intersection data (segment, point)
 */
function getApproxIntersection(waypoints, reference) {
  return getBendpointIntersection(waypoints, reference) || getPathIntersection(waypoints, reference);
}

},{"238":238,"272":272}],242:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.log10 = log10;

var _PositionUtil = _dereq_(245);

Object.defineProperty(exports, 'substract', {
  enumerable: true,
  get: function get() {
    return _PositionUtil.delta;
  }
});
/**
 * Get the logarithm of x with base 10
 * @param  {Integer} value
 */
function log10(x) {
  return Math.log(x) / Math.log(10);
}

},{"245":245}],243:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMac = undefined;

var _Platform = _dereq_(244);

Object.defineProperty(exports, 'isMac', {
  enumerable: true,
  get: function get() {
    return _Platform.isMac;
  }
});
exports.isPrimaryButton = isPrimaryButton;
exports.hasPrimaryModifier = hasPrimaryModifier;
exports.hasSecondaryModifier = hasSecondaryModifier;

var _Event = _dereq_(237);

function isPrimaryButton(event) {
  // button === 0 -> left áka primary mouse button
  return !((0, _Event.getOriginal)(event) || event).button;
}

function hasPrimaryModifier(event) {
  var originalEvent = (0, _Event.getOriginal)(event) || event;

  if (!isPrimaryButton(event)) {
    return false;
  }

  // Use alt as primary modifier key for mac OS
  if ((0, _Platform.isMac)()) {
    return originalEvent.metaKey;
  } else {
    return originalEvent.ctrlKey;
  }
}

function hasSecondaryModifier(event) {
  var originalEvent = (0, _Event.getOriginal)(event) || event;

  return isPrimaryButton(event) && originalEvent.shiftKey;
}

},{"237":237,"244":244}],244:[function(_dereq_,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMac = isMac;
function isMac() {
  return (/mac/i.test(navigator.platform)
  );
}

},{}],245:[function(_dereq_,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.center = center;
exports.delta = delta;
function center(bounds) {
  return {
    x: bounds.x + bounds.width / 2,
    y: bounds.y + bounds.height / 2
  };
}

function delta(a, b) {
  return {
    x: a.x - b.x,
    y: a.y - b.y
  };
}

},{}],246:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveClear = saveClear;
/**
 * Remove from the beginning of a collection until it is empty.
 *
 * This is a null-safe operation that ensures elements
 * are being removed from the given collection until the
 * collection is empty.
 *
 * The implementation deals with the fact that a remove operation
 * may touch, i.e. remove multiple elements in the collection
 * at a time.
 *
 * @param {Array<Object>} [collection]
 * @param {Function} removeFn
 *
 * @return {Array<Object>} the cleared collection
 */
function saveClear(collection, removeFn) {

  if (typeof removeFn !== 'function') {
    throw new Error('removeFn iterator must be a function');
  }

  if (!collection) {
    return;
  }

  var e;

  while (e = collection[0]) {
    removeFn(e);
  }

  return collection;
}

},{}],247:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.componentsToPath = componentsToPath;
exports.toSVGPoints = toSVGPoints;
exports.createLine = createLine;
exports.updateLine = updateLine;

var _tinySvg = _dereq_(275);

function componentsToPath(elements) {
  return elements.join(',').replace(/,?([A-z]),?/g, '$1');
}

function toSVGPoints(points) {
  var result = '';

  for (var i = 0, p; p = points[i]; i++) {
    result += p.x + ',' + p.y + ' ';
  }

  return result;
}

function createLine(points, attrs) {

  var line = (0, _tinySvg.create)('polyline');
  (0, _tinySvg.attr)(line, { points: toSVGPoints(points) });

  if (attrs) {
    (0, _tinySvg.attr)(line, attrs);
  }

  return line;
}

function updateLine(gfx, points) {
  (0, _tinySvg.attr)(gfx, { points: toSVGPoints(points) });

  return gfx;
}

},{"275":275}],248:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transform = transform;
exports.translate = translate;
exports.rotate = rotate;
exports.scale = scale;

var _tinySvg = _dereq_(275);

/**
 * @param {<SVGElement>} element
 * @param {Number} x
 * @param {Number} y
 * @param {Number} angle
 * @param {Number} amount
 */
function transform(gfx, x, y, angle, amount) {
  var translate = (0, _tinySvg.createTransform)();
  translate.setTranslate(x, y);

  var rotate = (0, _tinySvg.createTransform)();
  rotate.setRotate(angle, 0, 0);

  var scale = (0, _tinySvg.createTransform)();
  scale.setScale(amount || 1, amount || 1);

  (0, _tinySvg.transform)(gfx, [translate, rotate, scale]);
}

/**
 * @param {SVGElement} element
 * @param {Number} x
 * @param {Number} y
 */
function translate(gfx, x, y) {
  var translate = (0, _tinySvg.createTransform)();
  translate.setTranslate(x, y);

  (0, _tinySvg.transform)(gfx, translate);
}

/**
 * @param {SVGElement} element
 * @param {Number} angle
 */
function rotate(gfx, angle) {
  var rotate = (0, _tinySvg.createTransform)();
  rotate.setRotate(angle, 0, 0);

  (0, _tinySvg.transform)(gfx, rotate);
}

/**
 * @param {SVGElement} element
 * @param {Number} amount
 */
function scale(gfx, amount) {
  var scale = (0, _tinySvg.createTransform)();
  scale.setScale(amount, amount);

  (0, _tinySvg.transform)(gfx, scale);
}

},{"275":275}],249:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Text;

var _minDash = _dereq_(254);

var _tinySvg = _dereq_(275);

var DEFAULT_BOX_PADDING = 0;

var DEFAULT_LABEL_SIZE = {
  width: 150,
  height: 50
};

function parseAlign(align) {

  var parts = align.split('-');

  return {
    horizontal: parts[0] || 'center',
    vertical: parts[1] || 'top'
  };
}

function parsePadding(padding) {

  if ((0, _minDash.isObject)(padding)) {
    return (0, _minDash.assign)({ top: 0, left: 0, right: 0, bottom: 0 }, padding);
  } else {
    return {
      top: padding,
      left: padding,
      right: padding,
      bottom: padding
    };
  }
}

function getTextBBox(text, fakeText) {

  fakeText.textContent = text;

  var textBBox;

  try {
    var bbox,
        emptyLine = text === '';

    // add dummy text, when line is empty to
    // determine correct height
    fakeText.textContent = emptyLine ? 'dummy' : text;

    textBBox = fakeText.getBBox();

    // take text rendering related horizontal
    // padding into account
    bbox = {
      width: textBBox.width + textBBox.x * 2,
      height: textBBox.height
    };

    if (emptyLine) {
      // correct width
      bbox.width = 0;
    }

    return bbox;
  } catch (e) {
    return { width: 0, height: 0 };
  }
}

/**
 * Layout the next line and return the layouted element.
 *
 * Alters the lines passed.
 *
 * @param  {Array<String>} lines
 * @return {Object} the line descriptor, an object { width, height, text }
 */
function layoutNext(lines, maxWidth, fakeText) {

  var originalLine = lines.shift(),
      fitLine = originalLine;

  var textBBox;

  for (;;) {
    textBBox = getTextBBox(fitLine, fakeText);

    textBBox.width = fitLine ? textBBox.width : 0;

    // try to fit
    if (fitLine === ' ' || fitLine === '' || textBBox.width < Math.round(maxWidth) || fitLine.length < 2) {
      return fit(lines, fitLine, originalLine, textBBox);
    }

    fitLine = shortenLine(fitLine, textBBox.width, maxWidth);
  }
}

function fit(lines, fitLine, originalLine, textBBox) {
  if (fitLine.length < originalLine.length) {
    var remainder = originalLine.slice(fitLine.length).trim();

    lines.unshift(remainder);
  }

  return {
    width: textBBox.width,
    height: textBBox.height,
    text: fitLine
  };
}

/**
 * Shortens a line based on spacing and hyphens.
 * Returns the shortened result on success.
 *
 * @param  {String} line
 * @param  {Number} maxLength the maximum characters of the string
 * @return {String} the shortened string
 */
function semanticShorten(line, maxLength) {
  var parts = line.split(/(\s|-)/g),
      part,
      shortenedParts = [],
      length = 0;

  // try to shorten via spaces + hyphens
  if (parts.length > 1) {
    while (part = parts.shift()) {
      if (part.length + length < maxLength) {
        shortenedParts.push(part);
        length += part.length;
      } else {
        // remove previous part, too if hyphen does not fit anymore
        if (part === '-') {
          shortenedParts.pop();
        }

        break;
      }
    }
  }

  return shortenedParts.join('');
}

function shortenLine(line, width, maxWidth) {
  var length = Math.max(line.length * (maxWidth / width), 1);

  // try to shorten semantically (i.e. based on spaces and hyphens)
  var shortenedLine = semanticShorten(line, length);

  if (!shortenedLine) {

    // force shorten by cutting the long word
    shortenedLine = line.slice(0, Math.max(Math.round(length - 1), 1));
  }

  return shortenedLine;
}

function getHelperSvg() {
  var helperSvg = document.getElementById('helper-svg');

  if (!helperSvg) {
    helperSvg = (0, _tinySvg.create)('svg');

    (0, _tinySvg.attr)(helperSvg, {
      id: 'helper-svg',
      width: 0,
      height: 0,
      style: 'visibility: hidden; position: fixed'
    });

    document.body.appendChild(helperSvg);
  }

  return helperSvg;
}

/**
 * Creates a new label utility
 *
 * @param {Object} config
 * @param {Dimensions} config.size
 * @param {Number} config.padding
 * @param {Object} config.style
 * @param {String} config.align
 */
function Text(config) {

  this._config = (0, _minDash.assign)({}, {
    size: DEFAULT_LABEL_SIZE,
    padding: DEFAULT_BOX_PADDING,
    style: {},
    align: 'center-top'
  }, config || {});
}

/**
 * Returns the layouted text as an SVG element.
 *
 * @param {String} text
 * @param {Object} options
 *
 * @return {SVGElement}
 */
Text.prototype.createText = function (text, options) {
  return this.layoutText(text, options).element;
};

/**
 * Returns a labels layouted dimensions.
 *
 * @param {String} text to layout
 * @param {Object} options
 *
 * @return {Dimensions}
 */
Text.prototype.getDimensions = function (text, options) {
  return this.layoutText(text, options).dimensions;
};

/**
 * Creates and returns a label and its bounding box.
 *
 * @method Text#createText
 *
 * @param {String} text the text to render on the label
 * @param {Object} options
 * @param {String} options.align how to align in the bounding box.
 *                               Any of { 'center-middle', 'center-top' },
 *                               defaults to 'center-top'.
 * @param {String} options.style style to be applied to the text
 * @param {boolean} options.fitBox indicates if box will be recalculated to
 *                                 fit text
 *
 * @return {Object} { element, dimensions }
 */
Text.prototype.layoutText = function (text, options) {
  var box = (0, _minDash.assign)({}, this._config.size, options.box),
      style = (0, _minDash.assign)({}, this._config.style, options.style),
      align = parseAlign(options.align || this._config.align),
      padding = parsePadding(options.padding !== undefined ? options.padding : this._config.padding),
      fitBox = options.fitBox || false;

  var lineHeight = getLineHeight(style);

  var lines = text.split(/\r?\n/g),
      layouted = [];

  var maxWidth = box.width - padding.left - padding.right;

  // ensure correct rendering by attaching helper text node to invisible SVG
  var helperText = (0, _tinySvg.create)('text');
  (0, _tinySvg.attr)(helperText, { x: 0, y: 0 });
  (0, _tinySvg.attr)(helperText, style);

  var helperSvg = getHelperSvg();

  (0, _tinySvg.append)(helperSvg, helperText);

  while (lines.length) {
    layouted.push(layoutNext(lines, maxWidth, helperText));
  }

  if (align.vertical === 'middle') {
    padding.top = padding.bottom = 0;
  }

  var totalHeight = (0, _minDash.reduce)(layouted, function (sum, line, idx) {
    return sum + (lineHeight || line.height);
  }, 0) + padding.top + padding.bottom;

  var maxLineWidth = (0, _minDash.reduce)(layouted, function (sum, line, idx) {
    return line.width > sum ? line.width : sum;
  }, 0);

  // the y position of the next line
  var y = padding.top;

  if (align.vertical === 'middle') {
    y += (box.height - totalHeight) / 2;
  }

  // magic number initial offset
  y -= (lineHeight || layouted[0].height) / 4;

  var textElement = (0, _tinySvg.create)('text');

  (0, _tinySvg.attr)(textElement, style);

  // layout each line taking into account that parent
  // shape might resize to fit text size
  (0, _minDash.forEach)(layouted, function (line) {

    var x;

    y += lineHeight || line.height;

    switch (align.horizontal) {
      case 'left':
        x = padding.left;
        break;

      case 'right':
        x = (fitBox ? maxLineWidth : maxWidth) - padding.right - line.width;
        break;

      default:
        // aka center
        x = Math.max(((fitBox ? maxLineWidth : maxWidth) - line.width) / 2 + padding.left, 0);
    }

    var tspan = (0, _tinySvg.create)('tspan');
    (0, _tinySvg.attr)(tspan, { x: x, y: y });

    tspan.textContent = line.text;

    (0, _tinySvg.append)(textElement, tspan);
  });

  (0, _tinySvg.remove)(helperText);

  var dimensions = {
    width: maxLineWidth,
    height: totalHeight
  };

  return {
    dimensions: dimensions,
    element: textElement
  };
};

function getLineHeight(style) {
  if ('fontSize' in style && 'lineHeight' in style) {
    return style.lineHeight * parseInt(style.fontSize, 10);
  }
}

},{"254":254,"275":275}],250:[function(_dereq_,module,exports){
'use strict';

var _typeof2 = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

Object.defineProperty(exports, '__esModule', { value: true });

var CLASS_PATTERN = /^class /;

function isClass(fn) {
  return CLASS_PATTERN.test(fn.toString());
}

function isArray(obj) {
  return Object.prototype.toString.call(obj) === '[object Array]';
}

function annotate() {
  var args = Array.prototype.slice.call(arguments);

  if (args.length === 1 && isArray(args[0])) {
    args = args[0];
  }

  var fn = args.pop();

  fn.$inject = args;

  return fn;
}

// Current limitations:
// - can't put into "function arg" comments
// function /* (no parenthesis like this) */ (){}
// function abc( /* xx (no parenthesis like this) */ a, b) {}
//
// Just put the comment before function or inside:
// /* (((this is fine))) */ function(a, b) {}
// function abc(a) { /* (((this is fine))) */}
//
// - can't reliably auto-annotate constructor; we'll match the
// first constructor(...) pattern found which may be the one
// of a nested class, too.

var CONSTRUCTOR_ARGS = /constructor\s*[^(]*\(\s*([^)]*)\)/m;
var FN_ARGS = /^function\s*[^(]*\(\s*([^)]*)\)/m;
var FN_ARG = /\/\*([^*]*)\*\//m;

function parse(fn) {

  if (typeof fn !== 'function') {
    throw new Error('Cannot annotate "' + fn + '". Expected a function!');
  }

  var match = fn.toString().match(isClass(fn) ? CONSTRUCTOR_ARGS : FN_ARGS);

  // may parse class without constructor
  if (!match) {
    return [];
  }

  return match[1] && match[1].split(',').map(function (arg) {
    match = arg.match(FN_ARG);
    return match ? match[1].trim() : arg.trim();
  }) || [];
}

function Module() {
  var providers = [];

  this.factory = function (name, factory) {
    providers.push([name, 'factory', factory]);
    return this;
  };

  this.value = function (name, value) {
    providers.push([name, 'value', value]);
    return this;
  };

  this.type = function (name, type) {
    providers.push([name, 'type', type]);
    return this;
  };

  this.forEach = function (iterator) {
    providers.forEach(iterator);
  };
}

var _typeof = typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol" ? function (obj) {
  return typeof obj === 'undefined' ? 'undefined' : _typeof2(obj);
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj === 'undefined' ? 'undefined' : _typeof2(obj);
};

function _toConsumableArray(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
      arr2[i] = arr[i];
    }return arr2;
  } else {
    return Array.from(arr);
  }
}

function Injector(modules, parent) {
  parent = parent || {
    get: function get(name, strict) {
      currentlyResolving.push(name);

      if (strict === false) {
        return null;
      } else {
        throw error('No provider for "' + name + '"!');
      }
    }
  };

  var currentlyResolving = [];
  var providers = this._providers = Object.create(parent._providers || null);
  var instances = this._instances = Object.create(null);

  var self = instances.injector = this;

  var error = function error(msg) {
    var stack = currentlyResolving.join(' -> ');
    currentlyResolving.length = 0;
    return new Error(stack ? msg + ' (Resolving: ' + stack + ')' : msg);
  };

  /**
   * Return a named service.
   *
   * @param {String} name
   * @param {Boolean} [strict=true] if false, resolve missing services to null
   *
   * @return {Object}
   */
  var get = function get(name, strict) {
    if (!providers[name] && name.indexOf('.') !== -1) {
      var parts = name.split('.');
      var pivot = get(parts.shift());

      while (parts.length) {
        pivot = pivot[parts.shift()];
      }

      return pivot;
    }

    if (hasProp(instances, name)) {
      return instances[name];
    }

    if (hasProp(providers, name)) {
      if (currentlyResolving.indexOf(name) !== -1) {
        currentlyResolving.push(name);
        throw error('Cannot resolve circular dependency!');
      }

      currentlyResolving.push(name);
      instances[name] = providers[name][0](providers[name][1]);
      currentlyResolving.pop();

      return instances[name];
    }

    return parent.get(name, strict);
  };

  var fnDef = function fnDef(fn) {
    var locals = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (typeof fn !== 'function') {
      if (isArray(fn)) {
        fn = annotate(fn.slice());
      } else {
        throw new Error('Cannot invoke "' + fn + '". Expected a function!');
      }
    }

    var inject = fn.$inject || parse(fn);
    var dependencies = inject.map(function (dep) {
      if (hasProp(locals, dep)) {
        return locals[dep];
      } else {
        return get(dep);
      }
    });

    return {
      fn: fn,
      dependencies: dependencies
    };
  };

  var instantiate = function instantiate(Type) {
    var _fnDef = fnDef(Type),
        dependencies = _fnDef.dependencies,
        fn = _fnDef.fn;

    return new (Function.prototype.bind.apply(fn, [null].concat(_toConsumableArray(dependencies))))();
  };

  var invoke = function invoke(func, context, locals) {
    var _fnDef2 = fnDef(func, locals),
        dependencies = _fnDef2.dependencies,
        fn = _fnDef2.fn;

    return fn.call.apply(fn, [context].concat(_toConsumableArray(dependencies)));
  };

  var createPrivateInjectorFactory = function createPrivateInjectorFactory(privateChildInjector) {
    return annotate(function (key) {
      return privateChildInjector.get(key);
    });
  };

  var createChild = function createChild(modules, forceNewInstances) {
    if (forceNewInstances && forceNewInstances.length) {
      var fromParentModule = Object.create(null);
      var matchedScopes = Object.create(null);

      var privateInjectorsCache = [];
      var privateChildInjectors = [];
      var privateChildFactories = [];

      var provider;
      var cacheIdx;
      var privateChildInjector;
      var privateChildInjectorFactory;
      for (var name in providers) {
        provider = providers[name];

        if (forceNewInstances.indexOf(name) !== -1) {
          if (provider[2] === 'private') {
            cacheIdx = privateInjectorsCache.indexOf(provider[3]);
            if (cacheIdx === -1) {
              privateChildInjector = provider[3].createChild([], forceNewInstances);
              privateChildInjectorFactory = createPrivateInjectorFactory(privateChildInjector);
              privateInjectorsCache.push(provider[3]);
              privateChildInjectors.push(privateChildInjector);
              privateChildFactories.push(privateChildInjectorFactory);
              fromParentModule[name] = [privateChildInjectorFactory, name, 'private', privateChildInjector];
            } else {
              fromParentModule[name] = [privateChildFactories[cacheIdx], name, 'private', privateChildInjectors[cacheIdx]];
            }
          } else {
            fromParentModule[name] = [provider[2], provider[1]];
          }
          matchedScopes[name] = true;
        }

        if ((provider[2] === 'factory' || provider[2] === 'type') && provider[1].$scope) {
          /* jshint -W083 */
          forceNewInstances.forEach(function (scope) {
            if (provider[1].$scope.indexOf(scope) !== -1) {
              fromParentModule[name] = [provider[2], provider[1]];
              matchedScopes[scope] = true;
            }
          });
        }
      }

      forceNewInstances.forEach(function (scope) {
        if (!matchedScopes[scope]) {
          throw new Error('No provider for "' + scope + '". Cannot use provider from the parent!');
        }
      });

      modules.unshift(fromParentModule);
    }

    return new Injector(modules, self);
  };

  var factoryMap = {
    factory: invoke,
    type: instantiate,
    value: function value(_value) {
      return _value;
    }
  };

  modules.forEach(function (module) {

    function arrayUnwrap(type, value) {
      if (type !== 'value' && isArray(value)) {
        value = annotate(value.slice());
      }

      return value;
    }

    // TODO(vojta): handle wrong inputs (modules)
    if (module instanceof Module) {
      module.forEach(function (provider) {
        var name = provider[0];
        var type = provider[1];
        var value = provider[2];

        providers[name] = [factoryMap[type], arrayUnwrap(type, value), type];
      });
    } else if ((typeof module === 'undefined' ? 'undefined' : _typeof(module)) === 'object') {
      if (module.__exports__) {
        var clonedModule = Object.keys(module).reduce(function (m, key) {
          if (key.substring(0, 2) !== '__') {
            m[key] = module[key];
          }
          return m;
        }, Object.create(null));

        var privateInjector = new Injector((module.__modules__ || []).concat([clonedModule]), self);
        var getFromPrivateInjector = annotate(function (key) {
          return privateInjector.get(key);
        });
        module.__exports__.forEach(function (key) {
          providers[key] = [getFromPrivateInjector, key, 'private', privateInjector];
        });
      } else {
        Object.keys(module).forEach(function (name) {
          if (module[name][2] === 'private') {
            providers[name] = module[name];
            return;
          }

          var type = module[name][0];
          var value = module[name][1];

          providers[name] = [factoryMap[type], arrayUnwrap(type, value), type];
        });
      }
    }
  });

  // public API
  this.get = get;
  this.invoke = invoke;
  this.instantiate = instantiate;
  this.createChild = createChild;
}

// helpers /////////////////

function hasProp(obj, prop) {
  return Object.hasOwnProperty.call(obj, prop);
}

exports.annotate = annotate;
exports.Module = Module;
exports.Injector = Injector;

},{}],251:[function(_dereq_,module,exports){
'use strict';

var hat = module.exports = function (bits, base) {
    if (!base) base = 16;
    if (bits === undefined) bits = 128;
    if (bits <= 0) return '0';

    var digits = Math.log(Math.pow(2, bits)) / Math.log(base);
    for (var i = 2; digits === Infinity; i *= 2) {
        digits = Math.log(Math.pow(2, bits / i)) / Math.log(base) * i;
    }

    var rem = digits - Math.floor(digits);

    var res = '';

    for (var i = 0; i < Math.floor(digits); i++) {
        var x = Math.floor(Math.random() * base).toString(base);
        res = x + res;
    }

    if (rem) {
        var b = Math.pow(base, rem);
        var x = Math.floor(Math.random() * b).toString(base);
        res = x + res;
    }

    var parsed = parseInt(res, base);
    if (parsed !== Infinity && parsed >= Math.pow(2, bits)) {
        return hat(bits, base);
    } else return res;
};

hat.rack = function (bits, base, expandBy) {
    var fn = function fn(data) {
        var iters = 0;
        do {
            if (iters++ > 10) {
                if (expandBy) bits += expandBy;else throw new Error('too many ID collisions, use more bits');
            }

            var id = hat(bits, base);
        } while (Object.hasOwnProperty.call(hats, id));

        hats[id] = data;
        return id;
    };
    var hats = fn.hats = {};

    fn.get = function (id) {
        return fn.hats[id];
    };

    fn.set = function (id, value) {
        fn.hats[id] = value;
        return fn;
    };

    fn.bits = bits || 128;
    fn.base = base || 16;
    return fn;
};

},{}],252:[function(_dereq_,module,exports){
'use strict';

var hat = _dereq_(251);

/**
 * Create a new id generator / cache instance.
 *
 * You may optionally provide a seed that is used internally.
 *
 * @param {Seed} seed
 */
function Ids(seed) {

  if (!(this instanceof Ids)) {
    return new Ids(seed);
  }

  seed = seed || [128, 36, 1];
  this._seed = seed.length ? hat.rack(seed[0], seed[1], seed[2]) : seed;
}

module.exports = Ids;

/**
 * Generate a next id.
 *
 * @param {Object} [element] element to bind the id to
 *
 * @return {String} id
 */
Ids.prototype.next = function (element) {
  return this._seed(element || true);
};

/**
 * Generate a next id with a given prefix.
 *
 * @param {Object} [element] element to bind the id to
 *
 * @return {String} id
 */
Ids.prototype.nextPrefixed = function (prefix, element) {
  var id;

  do {
    id = prefix + this.next(true);
  } while (this.assigned(id));

  // claim {prefix}{random}
  this.claim(id, element);

  // return
  return id;
};

/**
 * Manually claim an existing id.
 *
 * @param {String} id
 * @param {String} [element] element the id is claimed by
 */
Ids.prototype.claim = function (id, element) {
  this._seed.set(id, element || true);
};

/**
 * Returns true if the given id has already been assigned.
 *
 * @param  {String} id
 * @return {Boolean}
 */
Ids.prototype.assigned = function (id) {
  return this._seed.get(id) || false;
};

/**
 * Unclaim an id.
 *
 * @param  {String} id the id to unclaim
 */
Ids.prototype.unclaim = function (id) {
  delete this._seed.hats[id];
};

/**
 * Clear all claimed ids.
 */
Ids.prototype.clear = function () {

  var hats = this._seed.hats,
      id;

  for (id in hats) {
    this.unclaim(id);
  }
};

},{"251":251}],253:[function(_dereq_,module,exports){
'use strict';

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor;
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor;
    var TempCtor = function TempCtor() {};
    TempCtor.prototype = superCtor.prototype;
    ctor.prototype = new TempCtor();
    ctor.prototype.constructor = ctor;
  };
}

},{}],254:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * Flatten array, one level deep.
 *
 * @param {Array<?>} arr
 *
 * @return {Array<?>}
 */
function flatten(arr) {
  return Array.prototype.concat.apply([], arr);
}

var nativeToString = Object.prototype.toString;
var nativeHasOwnProperty = Object.prototype.hasOwnProperty;
function isUndefined(obj) {
  return obj === undefined;
}
function isDefined(obj) {
  return obj !== undefined;
}
function isNil(obj) {
  return obj == null;
}
function isArray(obj) {
  return nativeToString.call(obj) === '[object Array]';
}
function isObject(obj) {
  return nativeToString.call(obj) === '[object Object]';
}
function isNumber(obj) {
  return nativeToString.call(obj) === '[object Number]';
}
function isFunction(obj) {
  var tag = nativeToString.call(obj);
  return tag === '[object Function]' || tag === '[object AsyncFunction]' || tag === '[object GeneratorFunction]' || tag === '[object AsyncGeneratorFunction]' || tag === '[object Proxy]';
}
function isString(obj) {
  return nativeToString.call(obj) === '[object String]';
}
/**
 * Ensure collection is an array.
 *
 * @param {Object} obj
 */

function ensureArray(obj) {
  if (isArray(obj)) {
    return;
  }

  throw new Error('must supply array');
}
/**
 * Return true, if target owns a property with the given key.
 *
 * @param {Object} target
 * @param {String} key
 *
 * @return {Boolean}
 */

function has(target, key) {
  return nativeHasOwnProperty.call(target, key);
}

/**
 * Find element in collection.
 *
 * @param  {Array|Object} collection
 * @param  {Function|Object} matcher
 *
 * @return {Object}
 */

function find(collection, matcher) {
  matcher = toMatcher(matcher);
  var match;
  forEach(collection, function (val, key) {
    if (matcher(val, key)) {
      match = val;
      return false;
    }
  });
  return match;
}
/**
 * Find element index in collection.
 *
 * @param  {Array|Object} collection
 * @param  {Function} matcher
 *
 * @return {Object}
 */

function findIndex(collection, matcher) {
  matcher = toMatcher(matcher);
  var idx = isArray(collection) ? -1 : undefined;
  forEach(collection, function (val, key) {
    if (matcher(val, key)) {
      idx = key;
      return false;
    }
  });
  return idx;
}
/**
 * Find element in collection.
 *
 * @param  {Array|Object} collection
 * @param  {Function} matcher
 *
 * @return {Array} result
 */

function filter(collection, matcher) {
  var result = [];
  forEach(collection, function (val, key) {
    if (matcher(val, key)) {
      result.push(val);
    }
  });
  return result;
}
/**
 * Iterate over collection; returning something
 * (non-undefined) will stop iteration.
 *
 * @param  {Array|Object} collection
 * @param  {Function} iterator
 *
 * @return {Object} return result that stopped the iteration
 */

function forEach(collection, iterator) {
  var val, result;

  if (isUndefined(collection)) {
    return;
  }

  var convertKey = isArray(collection) ? toNum : identity;

  for (var key in collection) {
    if (has(collection, key)) {
      val = collection[key];
      result = iterator(val, convertKey(key));

      if (result === false) {
        return val;
      }
    }
  }
}
/**
 * Return collection without element.
 *
 * @param  {Array} arr
 * @param  {Function} matcher
 *
 * @return {Array}
 */

function without(arr, matcher) {
  if (isUndefined(arr)) {
    return [];
  }

  ensureArray(arr);
  matcher = toMatcher(matcher);
  return arr.filter(function (el, idx) {
    return !matcher(el, idx);
  });
}
/**
 * Reduce collection, returning a single result.
 *
 * @param  {Object|Array} collection
 * @param  {Function} iterator
 * @param  {Any} result
 *
 * @return {Any} result returned from last iterator
 */

function reduce(collection, iterator, result) {
  forEach(collection, function (value, idx) {
    result = iterator(result, value, idx);
  });
  return result;
}
/**
 * Return true if every element in the collection
 * matches the criteria.
 *
 * @param  {Object|Array} collection
 * @param  {Function} matcher
 *
 * @return {Boolean}
 */

function every(collection, matcher) {
  return reduce(collection, function (matches, val, key) {
    return matches && matcher(val, key);
  }, true);
}
/**
 * Return true if some elements in the collection
 * match the criteria.
 *
 * @param  {Object|Array} collection
 * @param  {Function} matcher
 *
 * @return {Boolean}
 */

function some(collection, matcher) {
  return !!find(collection, matcher);
}
/**
 * Transform a collection into another collection
 * by piping each member through the given fn.
 *
 * @param  {Object|Array}   collection
 * @param  {Function} fn
 *
 * @return {Array} transformed collection
 */

function map(collection, fn) {
  var result = [];
  forEach(collection, function (val, key) {
    result.push(fn(val, key));
  });
  return result;
}
/**
 * Get the collections keys.
 *
 * @param  {Object|Array} collection
 *
 * @return {Array}
 */

function keys(collection) {
  return collection && Object.keys(collection) || [];
}
/**
 * Shorthand for `keys(o).length`.
 *
 * @param  {Object|Array} collection
 *
 * @return {Number}
 */

function size(collection) {
  return keys(collection).length;
}
/**
 * Get the values in the collection.
 *
 * @param  {Object|Array} collection
 *
 * @return {Array}
 */

function values(collection) {
  return map(collection, function (val) {
    return val;
  });
}
/**
 * Group collection members by attribute.
 *
 * @param  {Object|Array} collection
 * @param  {Function} extractor
 *
 * @return {Object} map with { attrValue => [ a, b, c ] }
 */

function groupBy(collection, extractor) {
  var grouped = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  extractor = toExtractor(extractor);
  forEach(collection, function (val) {
    var discriminator = extractor(val) || '_';
    var group = grouped[discriminator];

    if (!group) {
      group = grouped[discriminator] = [];
    }

    group.push(val);
  });
  return grouped;
}
function uniqueBy(extractor) {
  extractor = toExtractor(extractor);
  var grouped = {};

  for (var _len = arguments.length, collections = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    collections[_key - 1] = arguments[_key];
  }

  forEach(collections, function (c) {
    return groupBy(c, extractor, grouped);
  });
  var result = map(grouped, function (val, key) {
    return val[0];
  });
  return result;
}
var unionBy = uniqueBy;
/**
 * Sort collection by criteria.
 *
 * @param  {Object|Array} collection
 * @param  {String|Function} extractor
 *
 * @return {Array}
 */

function sortBy(collection, extractor) {
  extractor = toExtractor(extractor);
  var sorted = [];
  forEach(collection, function (value, key) {
    var disc = extractor(value, key);
    var entry = {
      d: disc,
      v: value
    };

    for (var idx = 0; idx < sorted.length; idx++) {
      var d = sorted[idx].d;

      if (disc < d) {
        sorted.splice(idx, 0, entry);
        return;
      }
    } // not inserted, append (!)


    sorted.push(entry);
  });
  return map(sorted, function (e) {
    return e.v;
  });
}
/**
 * Create an object pattern matcher.
 *
 * @example
 *
 * const matcher = matchPattern({ id: 1 });
 *
 * var element = find(elements, matcher);
 *
 * @param  {Object} pattern
 *
 * @return {Function} matcherFn
 */

function matchPattern(pattern) {
  return function (el) {
    return every(pattern, function (val, key) {
      return el[key] === val;
    });
  };
}

function toExtractor(extractor) {
  return isFunction(extractor) ? extractor : function (e) {
    return e[extractor];
  };
}

function toMatcher(matcher) {
  return isFunction(matcher) ? matcher : function (e) {
    return e === matcher;
  };
}

function identity(arg) {
  return arg;
}

function toNum(arg) {
  return Number(arg);
}

/**
 * Debounce fn, calling it only once if
 * the given time elapsed between calls.
 *
 * @param  {Function} fn
 * @param  {Number} timeout
 *
 * @return {Function} debounced function
 */
function debounce(fn, timeout) {
  var timer;
  var lastArgs;
  var lastThis;
  var lastNow;

  function fire() {
    var now = Date.now();
    var scheduledDiff = lastNow + timeout - now;

    if (scheduledDiff > 0) {
      return schedule(scheduledDiff);
    }

    fn.apply(lastThis, lastArgs);
    timer = lastNow = lastArgs = lastThis = undefined;
  }

  function schedule(timeout) {
    timer = setTimeout(fire, timeout);
  }

  return function () {
    lastNow = Date.now();

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    lastArgs = args;
    lastThis = this; // ensure an execution is scheduled

    if (!timer) {
      schedule(timeout);
    }
  };
}
/**
 * Throttle fn, calling at most once
 * in the given interval.
 *
 * @param  {Function} fn
 * @param  {Number} interval
 *
 * @return {Function} throttled function
 */

function throttle(fn, interval) {
  var throttling = false;
  return function () {
    if (throttling) {
      return;
    }

    fn.apply(void 0, arguments);
    throttling = true;
    setTimeout(function () {
      throttling = false;
    }, interval);
  };
}
/**
 * Bind function against target <this>.
 *
 * @param  {Function} fn
 * @param  {Object}   target
 *
 * @return {Function} bound function
 */

function bind(fn, target) {
  return fn.bind(target);
}

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

/**
 * Convenience wrapper for `Object.assign`.
 *
 * @param {Object} target
 * @param {...Object} others
 *
 * @return {Object} the target
 */

function assign(target) {
  for (var _len = arguments.length, others = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    others[_key - 1] = arguments[_key];
  }

  return _extends.apply(void 0, [target].concat(others));
}
/**
 * Pick given properties from the target object.
 *
 * @param {Object} target
 * @param {Array} properties
 *
 * @return {Object} target
 */

function pick(target, properties) {
  var result = {};
  var obj = Object(target);
  forEach(properties, function (prop) {
    if (prop in obj) {
      result[prop] = target[prop];
    }
  });
  return result;
}
/**
 * Pick all target properties, excluding the given ones.
 *
 * @param {Object} target
 * @param {Array} properties
 *
 * @return {Object} target
 */

function omit(target, properties) {
  var result = {};
  var obj = Object(target);
  forEach(obj, function (prop, key) {
    if (properties.indexOf(key) === -1) {
      result[key] = prop;
    }
  });
  return result;
}
/**
 * Recursively merge `...sources` into given target.
 *
 * Does support merging objects; does not support merging arrays.
 *
 * @param {Object} target
 * @param {...Object} sources
 *
 * @return {Object} the target
 */

function merge(target) {
  for (var _len2 = arguments.length, sources = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    sources[_key2 - 1] = arguments[_key2];
  }

  if (!sources.length) {
    return target;
  }

  forEach(sources, function (source) {
    // skip non-obj sources, i.e. null
    if (!source || !isObject(source)) {
      return;
    }

    forEach(source, function (sourceVal, key) {
      var targetVal = target[key];

      if (isObject(sourceVal)) {
        if (!isObject(targetVal)) {
          // override target[key] with object
          targetVal = {};
        }

        target[key] = merge(targetVal, sourceVal);
      } else {
        target[key] = sourceVal;
      }
    });
  });
  return target;
}

exports.flatten = flatten;
exports.find = find;
exports.findIndex = findIndex;
exports.filter = filter;
exports.forEach = forEach;
exports.without = without;
exports.reduce = reduce;
exports.every = every;
exports.some = some;
exports.map = map;
exports.keys = keys;
exports.size = size;
exports.values = values;
exports.groupBy = groupBy;
exports.uniqueBy = uniqueBy;
exports.unionBy = unionBy;
exports.sortBy = sortBy;
exports.matchPattern = matchPattern;
exports.debounce = debounce;
exports.throttle = throttle;
exports.bind = bind;
exports.isUndefined = isUndefined;
exports.isDefined = isDefined;
exports.isNil = isNil;
exports.isArray = isArray;
exports.isObject = isObject;
exports.isNumber = isNumber;
exports.isFunction = isFunction;
exports.isString = isString;
exports.ensureArray = ensureArray;
exports.has = has;
exports.assign = assign;
exports.pick = pick;
exports.omit = omit;
exports.merge = merge;

},{}],255:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * Set attribute `name` to `val`, or get attr `name`.
 *
 * @param {Element} el
 * @param {String} name
 * @param {String} [val]
 * @api public
 */
function attr(el, name, val) {
  // get
  if (arguments.length == 2) {
    return el.getAttribute(name);
  }

  // remove
  if (val === null) {
    return el.removeAttribute(name);
  }

  // set
  el.setAttribute(name, val);

  return el;
}

var indexOf = [].indexOf;

var indexof = function indexof(arr, obj) {
  if (indexOf) return arr.indexOf(obj);
  for (var i = 0; i < arr.length; ++i) {
    if (arr[i] === obj) return i;
  }
  return -1;
};

/**
 * Taken from https://github.com/component/classes
 *
 * Without the component bits.
 */

/**
 * Whitespace regexp.
 */

var re = /\s+/;

/**
 * toString reference.
 */

var toString = Object.prototype.toString;

/**
 * Wrap `el` in a `ClassList`.
 *
 * @param {Element} el
 * @return {ClassList}
 * @api public
 */

function classes(el) {
  return new ClassList(el);
}

/**
 * Initialize a new ClassList for `el`.
 *
 * @param {Element} el
 * @api private
 */

function ClassList(el) {
  if (!el || !el.nodeType) {
    throw new Error('A DOM element reference is required');
  }
  this.el = el;
  this.list = el.classList;
}

/**
 * Add class `name` if not already present.
 *
 * @param {String} name
 * @return {ClassList}
 * @api public
 */

ClassList.prototype.add = function (name) {
  // classList
  if (this.list) {
    this.list.add(name);
    return this;
  }

  // fallback
  var arr = this.array();
  var i = indexof(arr, name);
  if (!~i) arr.push(name);
  this.el.className = arr.join(' ');
  return this;
};

/**
 * Remove class `name` when present, or
 * pass a regular expression to remove
 * any which match.
 *
 * @param {String|RegExp} name
 * @return {ClassList}
 * @api public
 */

ClassList.prototype.remove = function (name) {
  if ('[object RegExp]' == toString.call(name)) {
    return this.removeMatching(name);
  }

  // classList
  if (this.list) {
    this.list.remove(name);
    return this;
  }

  // fallback
  var arr = this.array();
  var i = indexof(arr, name);
  if (~i) arr.splice(i, 1);
  this.el.className = arr.join(' ');
  return this;
};

/**
 * Remove all classes matching `re`.
 *
 * @param {RegExp} re
 * @return {ClassList}
 * @api private
 */

ClassList.prototype.removeMatching = function (re) {
  var arr = this.array();
  for (var i = 0; i < arr.length; i++) {
    if (re.test(arr[i])) {
      this.remove(arr[i]);
    }
  }
  return this;
};

/**
 * Toggle class `name`, can force state via `force`.
 *
 * For browsers that support classList, but do not support `force` yet,
 * the mistake will be detected and corrected.
 *
 * @param {String} name
 * @param {Boolean} force
 * @return {ClassList}
 * @api public
 */

ClassList.prototype.toggle = function (name, force) {
  // classList
  if (this.list) {
    if ('undefined' !== typeof force) {
      if (force !== this.list.toggle(name, force)) {
        this.list.toggle(name); // toggle again to correct
      }
    } else {
      this.list.toggle(name);
    }
    return this;
  }

  // fallback
  if ('undefined' !== typeof force) {
    if (!force) {
      this.remove(name);
    } else {
      this.add(name);
    }
  } else {
    if (this.has(name)) {
      this.remove(name);
    } else {
      this.add(name);
    }
  }

  return this;
};

/**
 * Return an array of classes.
 *
 * @return {Array}
 * @api public
 */

ClassList.prototype.array = function () {
  var className = this.el.getAttribute('class') || '';
  var str = className.replace(/^\s+|\s+$/g, '');
  var arr = str.split(re);
  if ('' === arr[0]) arr.shift();
  return arr;
};

/**
 * Check if class `name` is present.
 *
 * @param {String} name
 * @return {ClassList}
 * @api public
 */

ClassList.prototype.has = ClassList.prototype.contains = function (name) {
  return this.list ? this.list.contains(name) : !!~indexof(this.array(), name);
};

/**
 * Remove all children from the given element.
 */
function clear(el) {

  var c;

  while (el.childNodes.length) {
    c = el.childNodes[0];
    el.removeChild(c);
  }

  return el;
}

/**
 * Element prototype.
 */

var proto = Element.prototype;

/**
 * Vendor function.
 */

var vendor = proto.matchesSelector || proto.webkitMatchesSelector || proto.mozMatchesSelector || proto.msMatchesSelector || proto.oMatchesSelector;

/**
 * Expose `match()`.
 */

var matchesSelector = match;

/**
 * Match `el` to `selector`.
 *
 * @param {Element} el
 * @param {String} selector
 * @return {Boolean}
 * @api public
 */

function match(el, selector) {
  if (vendor) return vendor.call(el, selector);
  var nodes = el.parentNode.querySelectorAll(selector);
  for (var i = 0; i < nodes.length; ++i) {
    if (nodes[i] == el) return true;
  }
  return false;
}

var closest = function closest(element, selector, checkYoSelf) {
  var parent = checkYoSelf ? element : element.parentNode;

  while (parent && parent !== document) {
    if (matchesSelector(parent, selector)) return parent;
    parent = parent.parentNode;
  }
};

var bind = window.addEventListener ? 'addEventListener' : 'attachEvent',
    unbind = window.removeEventListener ? 'removeEventListener' : 'detachEvent',
    prefix = bind !== 'addEventListener' ? 'on' : '';

/**
 * Bind `el` event `type` to `fn`.
 *
 * @param {Element} el
 * @param {String} type
 * @param {Function} fn
 * @param {Boolean} capture
 * @return {Function}
 * @api public
 */

var bind_1 = function bind_1(el, type, fn, capture) {
  el[bind](prefix + type, fn, capture || false);
  return fn;
};

/**
 * Unbind `el` event `type`'s callback `fn`.
 *
 * @param {Element} el
 * @param {String} type
 * @param {Function} fn
 * @param {Boolean} capture
 * @return {Function}
 * @api public
 */

var unbind_1 = function unbind_1(el, type, fn, capture) {
  el[unbind](prefix + type, fn, capture || false);
  return fn;
};

var componentEvent = {
  bind: bind_1,
  unbind: unbind_1
};

/**
 * Module dependencies.
 */

/**
 * Delegate event `type` to `selector`
 * and invoke `fn(e)`. A callback function
 * is returned which may be passed to `.unbind()`.
 *
 * @param {Element} el
 * @param {String} selector
 * @param {String} type
 * @param {Function} fn
 * @param {Boolean} capture
 * @return {Function}
 * @api public
 */

// Some events don't bubble, so we want to bind to the capture phase instead
// when delegating.
var forceCaptureEvents = ['focus', 'blur'];

var bind$1 = function bind$1(el, selector, type, fn, capture) {
  if (forceCaptureEvents.indexOf(type) !== -1) capture = true;

  return componentEvent.bind(el, type, function (e) {
    var target = e.target || e.srcElement;
    e.delegateTarget = closest(target, selector, true, el);
    if (e.delegateTarget) fn.call(el, e);
  }, capture);
};

/**
 * Unbind event `type`'s callback `fn`.
 *
 * @param {Element} el
 * @param {String} type
 * @param {Function} fn
 * @param {Boolean} capture
 * @api public
 */

var unbind$1 = function unbind$1(el, type, fn, capture) {
  if (forceCaptureEvents.indexOf(type) !== -1) capture = true;

  componentEvent.unbind(el, type, fn, capture);
};

var delegateEvents = {
  bind: bind$1,
  unbind: unbind$1
};

/**
 * Expose `parse`.
 */

var domify = parse;

/**
 * Tests for browser support.
 */

var innerHTMLBug = false;
var bugTestDiv;
if (typeof document !== 'undefined') {
  bugTestDiv = document.createElement('div');
  // Setup
  bugTestDiv.innerHTML = '  <link/><table></table><a href="/a">a</a><input type="checkbox"/>';
  // Make sure that link elements get serialized correctly by innerHTML
  // This requires a wrapper element in IE
  innerHTMLBug = !bugTestDiv.getElementsByTagName('link').length;
  bugTestDiv = undefined;
}

/**
 * Wrap map from jquery.
 */

var map = {
  legend: [1, '<fieldset>', '</fieldset>'],
  tr: [2, '<table><tbody>', '</tbody></table>'],
  col: [2, '<table><tbody></tbody><colgroup>', '</colgroup></table>'],
  // for script/link/style tags to work in IE6-8, you have to wrap
  // in a div with a non-whitespace character in front, ha!
  _default: innerHTMLBug ? [1, 'X<div>', '</div>'] : [0, '', '']
};

map.td = map.th = [3, '<table><tbody><tr>', '</tr></tbody></table>'];

map.option = map.optgroup = [1, '<select multiple="multiple">', '</select>'];

map.thead = map.tbody = map.colgroup = map.caption = map.tfoot = [1, '<table>', '</table>'];

map.polyline = map.ellipse = map.polygon = map.circle = map.text = map.line = map.path = map.rect = map.g = [1, '<svg xmlns="http://www.w3.org/2000/svg" version="1.1">', '</svg>'];

/**
 * Parse `html` and return a DOM Node instance, which could be a TextNode,
 * HTML DOM Node of some kind (<div> for example), or a DocumentFragment
 * instance, depending on the contents of the `html` string.
 *
 * @param {String} html - HTML string to "domify"
 * @param {Document} doc - The `document` instance to create the Node for
 * @return {DOMNode} the TextNode, DOM Node, or DocumentFragment instance
 * @api private
 */

function parse(html, doc) {
  if ('string' != typeof html) throw new TypeError('String expected');

  // default to the global `document` object
  if (!doc) doc = document;

  // tag name
  var m = /<([\w:]+)/.exec(html);
  if (!m) return doc.createTextNode(html);

  html = html.replace(/^\s+|\s+$/g, ''); // Remove leading/trailing whitespace

  var tag = m[1];

  // body support
  if (tag == 'body') {
    var el = doc.createElement('html');
    el.innerHTML = html;
    return el.removeChild(el.lastChild);
  }

  // wrap map
  var wrap = map[tag] || map._default;
  var depth = wrap[0];
  var prefix = wrap[1];
  var suffix = wrap[2];
  var el = doc.createElement('div');
  el.innerHTML = prefix + html + suffix;
  while (depth--) {
    el = el.lastChild;
  } // one element
  if (el.firstChild == el.lastChild) {
    return el.removeChild(el.firstChild);
  }

  // several elements
  var fragment = doc.createDocumentFragment();
  while (el.firstChild) {
    fragment.appendChild(el.removeChild(el.firstChild));
  }

  return fragment;
}

var proto$1 = typeof Element !== 'undefined' ? Element.prototype : {};
var vendor$1 = proto$1.matches || proto$1.matchesSelector || proto$1.webkitMatchesSelector || proto$1.mozMatchesSelector || proto$1.msMatchesSelector || proto$1.oMatchesSelector;

var matchesSelector$1 = match$1;

/**
 * Match `el` to `selector`.
 *
 * @param {Element} el
 * @param {String} selector
 * @return {Boolean}
 * @api public
 */

function match$1(el, selector) {
  if (!el || el.nodeType !== 1) return false;
  if (vendor$1) return vendor$1.call(el, selector);
  var nodes = el.parentNode.querySelectorAll(selector);
  for (var i = 0; i < nodes.length; i++) {
    if (nodes[i] == el) return true;
  }
  return false;
}

function query(selector, el) {
  el = el || document;

  return el.querySelector(selector);
}

function all(selector, el) {
  el = el || document;

  return el.querySelectorAll(selector);
}

function remove(el) {
  el.parentNode && el.parentNode.removeChild(el);
}

exports.attr = attr;
exports.classes = classes;
exports.clear = clear;
exports.closest = closest;
exports.delegate = delegateEvents;
exports.domify = domify;
exports.event = componentEvent;
exports.matches = matchesSelector$1;
exports.query = query;
exports.queryAll = all;
exports.remove = remove;

},{}],256:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _read = _dereq_(258);

Object.defineProperty(exports, 'Reader', {
  enumerable: true,
  get: function get() {
    return _read.Reader;
  }
});

var _write = _dereq_(259);

Object.defineProperty(exports, 'Writer', {
  enumerable: true,
  get: function get() {
    return _write.Writer;
  }
});

},{"258":258,"259":259}],257:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasLowerCaseAlias = hasLowerCaseAlias;
exports.serializeAsType = serializeAsType;
exports.serializeAsProperty = serializeAsProperty;
function hasLowerCaseAlias(pkg) {
  return pkg.xml && pkg.xml.tagAlias === 'lowerCase';
}

var DEFAULT_NS_MAP = exports.DEFAULT_NS_MAP = {
  'xsi': 'http://www.w3.org/2001/XMLSchema-instance'
};

var XSI_TYPE = exports.XSI_TYPE = 'xsi:type';

function serializeFormat(element) {
  return element.xml && element.xml.serialize;
}

function serializeAsType(element) {
  return serializeFormat(element) === XSI_TYPE;
}

function serializeAsProperty(element) {
  return serializeFormat(element) === 'property';
}

},{}],258:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Context = Context;
exports.ElementHandler = ElementHandler;
exports.Reader = Reader;

var _minDash = _dereq_(254);

var _tinyStack = _dereq_(274);

var _tinyStack2 = _interopRequireDefault(_tinyStack);

var _saxen = _dereq_(273);

var _moddle = _dereq_(260);

var _moddle2 = _interopRequireDefault(_moddle);

var _ns = _dereq_(265);

var _types = _dereq_(268);

var _common = _dereq_(257);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function capitalize(str) {
  return str.charAt(0).toUpperCase() + str.slice(1);
}

function aliasToName(aliasNs, pkg) {

  if (!(0, _common.hasLowerCaseAlias)(pkg)) {
    return aliasNs.name;
  }

  return aliasNs.prefix + ':' + capitalize(aliasNs.localName);
}

function prefixedToName(nameNs, pkg) {

  var name = nameNs.name,
      localName = nameNs.localName;

  var typePrefix = pkg.xml && pkg.xml.typePrefix;

  if (typePrefix && localName.indexOf(typePrefix) === 0) {
    return nameNs.prefix + ':' + localName.slice(typePrefix.length);
  } else {
    return name;
  }
}

function normalizeXsiTypeName(name, model) {

  var nameNs = (0, _ns.parseName)(name);
  var pkg = model.getPackage(nameNs.prefix);

  return prefixedToName(nameNs, pkg);
}

function error(message) {
  return new Error(message);
}

/**
 * Get the moddle descriptor for a given instance or type.
 *
 * @param  {ModdleElement|Function} element
 *
 * @return {Object} the moddle descriptor
 */
function getModdleDescriptor(element) {
  return element.$descriptor;
}

function defer(fn) {
  setTimeout(fn, 0);
}

/**
 * A parse context.
 *
 * @class
 *
 * @param {Object} options
 * @param {ElementHandler} options.rootHandler the root handler for parsing a document
 * @param {boolean} [options.lax=false] whether or not to ignore invalid elements
 */
function Context(options) {

  /**
   * @property {ElementHandler} rootHandler
   */

  /**
   * @property {Boolean} lax
   */

  (0, _minDash.assign)(this, options);

  this.elementsById = {};
  this.references = [];
  this.warnings = [];

  /**
   * Add an unresolved reference.
   *
   * @param {Object} reference
   */
  this.addReference = function (reference) {
    this.references.push(reference);
  };

  /**
   * Add a processed element.
   *
   * @param {ModdleElement} element
   */
  this.addElement = function (element) {

    if (!element) {
      throw error('expected element');
    }

    var elementsById = this.elementsById;

    var descriptor = getModdleDescriptor(element);

    var idProperty = descriptor.idProperty,
        id;

    if (idProperty) {
      id = element.get(idProperty.name);

      if (id) {

        if (elementsById[id]) {
          throw error('duplicate ID <' + id + '>');
        }

        elementsById[id] = element;
      }
    }
  };

  /**
   * Add an import warning.
   *
   * @param {Object} warning
   * @param {String} warning.message
   * @param {Error} [warning.error]
   */
  this.addWarning = function (warning) {
    this.warnings.push(warning);
  };
}

function BaseHandler() {}

BaseHandler.prototype.handleEnd = function () {};
BaseHandler.prototype.handleText = function () {};
BaseHandler.prototype.handleNode = function () {};

/**
 * A simple pass through handler that does nothing except for
 * ignoring all input it receives.
 *
 * This is used to ignore unknown elements and
 * attributes.
 */
function NoopHandler() {}

NoopHandler.prototype = Object.create(BaseHandler.prototype);

NoopHandler.prototype.handleNode = function () {
  return this;
};

function BodyHandler() {}

BodyHandler.prototype = Object.create(BaseHandler.prototype);

BodyHandler.prototype.handleText = function (text) {
  this.body = (this.body || '') + text;
};

function ReferenceHandler(property, context) {
  this.property = property;
  this.context = context;
}

ReferenceHandler.prototype = Object.create(BodyHandler.prototype);

ReferenceHandler.prototype.handleNode = function (node) {

  if (this.element) {
    throw error('expected no sub nodes');
  } else {
    this.element = this.createReference(node);
  }

  return this;
};

ReferenceHandler.prototype.handleEnd = function () {
  this.element.id = this.body;
};

ReferenceHandler.prototype.createReference = function (node) {
  return {
    property: this.property.ns.name,
    id: ''
  };
};

function ValueHandler(propertyDesc, element) {
  this.element = element;
  this.propertyDesc = propertyDesc;
}

ValueHandler.prototype = Object.create(BodyHandler.prototype);

ValueHandler.prototype.handleEnd = function () {

  var value = this.body || '',
      element = this.element,
      propertyDesc = this.propertyDesc;

  value = (0, _types.coerceType)(propertyDesc.type, value);

  if (propertyDesc.isMany) {
    element.get(propertyDesc.name).push(value);
  } else {
    element.set(propertyDesc.name, value);
  }
};

function BaseElementHandler() {}

BaseElementHandler.prototype = Object.create(BodyHandler.prototype);

BaseElementHandler.prototype.handleNode = function (node) {
  var parser = this,
      element = this.element;

  if (!element) {
    element = this.element = this.createElement(node);

    this.context.addElement(element);
  } else {
    parser = this.handleChild(node);
  }

  return parser;
};

/**
 * @class Reader.ElementHandler
 *
 */
function ElementHandler(model, typeName, context) {
  this.model = model;
  this.type = model.getType(typeName);
  this.context = context;
}

ElementHandler.prototype = Object.create(BaseElementHandler.prototype);

ElementHandler.prototype.addReference = function (reference) {
  this.context.addReference(reference);
};

ElementHandler.prototype.handleEnd = function () {

  var value = this.body,
      element = this.element,
      descriptor = getModdleDescriptor(element),
      bodyProperty = descriptor.bodyProperty;

  if (bodyProperty && value !== undefined) {
    value = (0, _types.coerceType)(bodyProperty.type, value);
    element.set(bodyProperty.name, value);
  }
};

/**
 * Create an instance of the model from the given node.
 *
 * @param  {Element} node the xml node
 */
ElementHandler.prototype.createElement = function (node) {
  var attributes = node.attributes,
      Type = this.type,
      descriptor = getModdleDescriptor(Type),
      context = this.context,
      instance = new Type({}),
      model = this.model,
      propNameNs;

  (0, _minDash.forEach)(attributes, function (value, name) {

    var prop = descriptor.propertiesByName[name],
        values;

    if (prop && prop.isReference) {

      if (!prop.isMany) {
        context.addReference({
          element: instance,
          property: prop.ns.name,
          id: value
        });
      } else {
        // IDREFS: parse references as whitespace-separated list
        values = value.split(' ');

        (0, _minDash.forEach)(values, function (v) {
          context.addReference({
            element: instance,
            property: prop.ns.name,
            id: v
          });
        });
      }
    } else {
      if (prop) {
        value = (0, _types.coerceType)(prop.type, value);
      } else if (name !== 'xmlns') {
        propNameNs = (0, _ns.parseName)(name, descriptor.ns.prefix);

        // check whether attribute is defined in a well-known namespace
        // if that is the case we emit a warning to indicate potential misuse
        if (model.getPackage(propNameNs.prefix)) {

          context.addWarning({
            message: 'unknown attribute <' + name + '>',
            element: instance,
            property: name,
            value: value
          });
        }
      }

      instance.set(name, value);
    }
  });

  return instance;
};

ElementHandler.prototype.getPropertyForNode = function (node) {

  var name = node.name;
  var nameNs = (0, _ns.parseName)(name);

  var type = this.type,
      model = this.model,
      descriptor = getModdleDescriptor(type);

  var propertyName = nameNs.name,
      property = descriptor.propertiesByName[propertyName],
      elementTypeName,
      elementType;

  // search for properties by name first

  if (property) {

    if ((0, _common.serializeAsType)(property)) {
      elementTypeName = node.attributes[_common.XSI_TYPE];

      // xsi type is optional, if it does not exists the
      // default type is assumed
      if (elementTypeName) {

        // take possible type prefixes from XML
        // into account, i.e.: xsi:type="t{ActualType}"
        elementTypeName = normalizeXsiTypeName(elementTypeName, model);

        elementType = model.getType(elementTypeName);

        return (0, _minDash.assign)({}, property, {
          effectiveType: getModdleDescriptor(elementType).name
        });
      }
    }

    // search for properties by name first
    return property;
  }

  var pkg = model.getPackage(nameNs.prefix);

  if (pkg) {
    elementTypeName = aliasToName(nameNs, pkg);
    elementType = model.getType(elementTypeName);

    // search for collection members later
    property = (0, _minDash.find)(descriptor.properties, function (p) {
      return !p.isVirtual && !p.isReference && !p.isAttribute && elementType.hasType(p.type);
    });

    if (property) {
      return (0, _minDash.assign)({}, property, {
        effectiveType: getModdleDescriptor(elementType).name
      });
    }
  } else {
    // parse unknown element (maybe extension)
    property = (0, _minDash.find)(descriptor.properties, function (p) {
      return !p.isReference && !p.isAttribute && p.type === 'Element';
    });

    if (property) {
      return property;
    }
  }

  throw error('unrecognized element <' + nameNs.name + '>');
};

ElementHandler.prototype.toString = function () {
  return 'ElementDescriptor[' + getModdleDescriptor(this.type).name + ']';
};

ElementHandler.prototype.valueHandler = function (propertyDesc, element) {
  return new ValueHandler(propertyDesc, element);
};

ElementHandler.prototype.referenceHandler = function (propertyDesc) {
  return new ReferenceHandler(propertyDesc, this.context);
};

ElementHandler.prototype.handler = function (type) {
  if (type === 'Element') {
    return new GenericElementHandler(this.model, type, this.context);
  } else {
    return new ElementHandler(this.model, type, this.context);
  }
};

/**
 * Handle the child element parsing
 *
 * @param  {Element} node the xml node
 */
ElementHandler.prototype.handleChild = function (node) {
  var propertyDesc, type, element, childHandler;

  propertyDesc = this.getPropertyForNode(node);
  element = this.element;

  type = propertyDesc.effectiveType || propertyDesc.type;

  if ((0, _types.isSimple)(type)) {
    return this.valueHandler(propertyDesc, element);
  }

  if (propertyDesc.isReference) {
    childHandler = this.referenceHandler(propertyDesc).handleNode(node);
  } else {
    childHandler = this.handler(type).handleNode(node);
  }

  var newElement = childHandler.element;

  // child handles may decide to skip elements
  // by not returning anything
  if (newElement !== undefined) {

    if (propertyDesc.isMany) {
      element.get(propertyDesc.name).push(newElement);
    } else {
      element.set(propertyDesc.name, newElement);
    }

    if (propertyDesc.isReference) {
      (0, _minDash.assign)(newElement, {
        element: element
      });

      this.context.addReference(newElement);
    } else {
      // establish child -> parent relationship
      newElement.$parent = element;
    }
  }

  return childHandler;
};

/**
 * An element handler that performs special validation
 * to ensure the node it gets initialized with matches
 * the handlers type (namespace wise).
 *
 * @param {Moddle} model
 * @param {String} typeName
 * @param {Context} context
 */
function RootElementHandler(model, typeName, context) {
  ElementHandler.call(this, model, typeName, context);
}

RootElementHandler.prototype = Object.create(ElementHandler.prototype);

RootElementHandler.prototype.createElement = function (node) {

  var name = node.name,
      nameNs = (0, _ns.parseName)(name),
      model = this.model,
      type = this.type,
      pkg = model.getPackage(nameNs.prefix),
      typeName = pkg && aliasToName(nameNs, pkg) || name;

  // verify the correct namespace if we parse
  // the first element in the handler tree
  //
  // this ensures we don't mistakenly import wrong namespace elements
  if (!type.hasType(typeName)) {
    throw error('unexpected element <' + node.originalName + '>');
  }

  return ElementHandler.prototype.createElement.call(this, node);
};

function GenericElementHandler(model, typeName, context) {
  this.model = model;
  this.context = context;
}

GenericElementHandler.prototype = Object.create(BaseElementHandler.prototype);

GenericElementHandler.prototype.createElement = function (node) {

  var name = node.name,
      ns = (0, _ns.parseName)(name),
      prefix = ns.prefix,
      uri = node.ns[prefix + '$uri'],
      attributes = node.attributes;

  return this.model.createAny(name, uri, attributes);
};

GenericElementHandler.prototype.handleChild = function (node) {

  var handler = new GenericElementHandler(this.model, 'Element', this.context).handleNode(node),
      element = this.element;

  var newElement = handler.element,
      children;

  if (newElement !== undefined) {
    children = element.$children = element.$children || [];
    children.push(newElement);

    // establish child -> parent relationship
    newElement.$parent = element;
  }

  return handler;
};

GenericElementHandler.prototype.handleText = function (text) {
  this.body = this.body || '' + text;
};

GenericElementHandler.prototype.handleEnd = function () {
  if (this.body) {
    this.element.$body = this.body;
  }
};

/**
 * A reader for a meta-model
 *
 * @param {Object} options
 * @param {Model} options.model used to read xml files
 * @param {Boolean} options.lax whether to make parse errors warnings
 */
function Reader(options) {

  if (options instanceof _moddle2.default) {
    options = {
      model: options
    };
  }

  (0, _minDash.assign)(this, { lax: false }, options);
}

/**
 * Parse the given XML into a moddle document tree.
 *
 * @param {String} xml
 * @param {ElementHandler|Object} options or rootHandler
 * @param  {Function} done
 */
Reader.prototype.fromXML = function (xml, options, done) {

  var rootHandler = options.rootHandler;

  if (options instanceof ElementHandler) {
    // root handler passed via (xml, { rootHandler: ElementHandler }, ...)
    rootHandler = options;
    options = {};
  } else {
    if (typeof options === 'string') {
      // rootHandler passed via (xml, 'someString', ...)
      rootHandler = this.handler(options);
      options = {};
    } else if (typeof rootHandler === 'string') {
      // rootHandler passed via (xml, { rootHandler: 'someString' }, ...)
      rootHandler = this.handler(rootHandler);
    }
  }

  var model = this.model,
      lax = this.lax;

  var context = new Context((0, _minDash.assign)({}, options, { rootHandler: rootHandler })),
      parser = new _saxen.Parser({ proxy: true }),
      stack = new _tinyStack2.default();

  rootHandler.context = context;

  // push root handler
  stack.push(rootHandler);

  /**
   * Handle error.
   *
   * @param  {Error} err
   * @param  {Function} getContext
   * @param  {boolean} lax
   *
   * @return {boolean} true if handled
   */
  function handleError(err, getContext, lax) {

    var ctx = getContext();

    var line = ctx.line,
        column = ctx.column,
        data = ctx.data;

    // we receive the full context data here,
    // for elements trim down the information
    // to the tag name, only
    if (data.charAt(0) === '<' && data.indexOf(' ') !== -1) {
      data = data.slice(0, data.indexOf(' ')) + '>';
    }

    var message = 'unparsable content ' + (data ? data + ' ' : '') + 'detected\n\t' + 'line: ' + line + '\n\t' + 'column: ' + column + '\n\t' + 'nested error: ' + err.message;

    if (lax) {
      context.addWarning({
        message: message,
        error: err
      });

      console.warn('could not parse node');
      console.warn(err);

      return true;
    } else {
      console.error('could not parse document');
      console.error(err);

      throw error(message);
    }
  }

  function handleWarning(err, getContext) {
    // just like handling errors in <lax=true> mode
    return handleError(err, getContext, true);
  }

  /**
   * Resolve collected references on parse end.
   */
  function resolveReferences() {

    var elementsById = context.elementsById;
    var references = context.references;

    var i, r;

    for (i = 0; r = references[i]; i++) {
      var element = r.element;
      var reference = elementsById[r.id];
      var property = getModdleDescriptor(element).propertiesByName[r.property];

      if (!reference) {
        context.addWarning({
          message: 'unresolved reference <' + r.id + '>',
          element: r.element,
          property: r.property,
          value: r.id
        });
      }

      if (property.isMany) {
        var collection = element.get(property.name),
            idx = collection.indexOf(r);

        // we replace an existing place holder (idx != -1) or
        // append to the collection instead
        if (idx === -1) {
          idx = collection.length;
        }

        if (!reference) {
          // remove unresolvable reference
          collection.splice(idx, 1);
        } else {
          // add or update reference in collection
          collection[idx] = reference;
        }
      } else {
        element.set(property.name, reference);
      }
    }
  }

  function handleClose() {
    stack.pop().handleEnd();
  }

  var PREAMBLE_START_PATTERN = /^<\?xml /i;

  var ENCODING_PATTERN = / encoding="([^"]+)"/i;

  var UTF_8_PATTERN = /^utf-8$/i;

  function handleQuestion(question) {

    if (!PREAMBLE_START_PATTERN.test(question)) {
      return;
    }

    var match = ENCODING_PATTERN.exec(question);
    var encoding = match && match[1];

    if (!encoding || UTF_8_PATTERN.test(encoding)) {
      return;
    }

    context.addWarning({
      message: 'unsupported document encoding <' + encoding + '>, ' + 'falling back to UTF-8'
    });
  }

  function handleOpen(node, getContext) {
    var handler = stack.peek();

    try {
      stack.push(handler.handleNode(node));
    } catch (err) {

      if (handleError(err, getContext, lax)) {
        stack.push(new NoopHandler());
      }
    }
  }

  function handleCData(text) {
    stack.peek().handleText(text);
  }

  function handleText(text) {
    // strip whitespace only nodes, i.e. before
    // <!CDATA[ ... ]> sections and in between tags
    text = text.trim();

    if (!text) {
      return;
    }

    stack.peek().handleText(text);
  }

  var uriMap = model.getPackages().reduce(function (uriMap, p) {
    uriMap[p.uri] = p.prefix;

    return uriMap;
  }, {});

  parser.ns(uriMap).on('openTag', function (obj, decodeStr, selfClosing, getContext) {

    // gracefully handle unparsable attributes (attrs=false)
    var attrs = obj.attrs || {};

    var decodedAttrs = Object.keys(attrs).reduce(function (d, key) {
      var value = decodeStr(attrs[key]);

      d[key] = value;

      return d;
    }, {});

    var node = {
      name: obj.name,
      originalName: obj.originalName,
      attributes: decodedAttrs,
      ns: obj.ns
    };

    handleOpen(node, getContext);
  }).on('question', handleQuestion).on('closeTag', handleClose).on('cdata', handleCData).on('text', function (text, decodeEntities) {
    handleText(decodeEntities(text));
  }).on('error', handleError).on('warn', handleWarning);

  // deferred parse XML to make loading really ascnchronous
  // this ensures the execution environment (node or browser)
  // is kept responsive and that certain optimization strategies
  // can kick in
  defer(function () {
    var err;

    try {
      parser.parse(xml);

      resolveReferences();
    } catch (e) {
      err = e;
    }

    var element = rootHandler.element;

    // handle the situation that we could not extract
    // the desired root element from the document
    if (!err && !element) {
      err = error('failed to parse document as <' + rootHandler.type.$descriptor.name + '>');
    }

    done(err, err ? undefined : element, context);
  });
};

Reader.prototype.handler = function (name) {
  return new RootElementHandler(this.model, name);
};

},{"254":254,"257":257,"260":260,"265":265,"268":268,"273":273,"274":274}],259:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Namespaces = Namespaces;
exports.Writer = Writer;

var _minDash = _dereq_(254);

var _types = _dereq_(268);

var _ns = _dereq_(265);

var _common = _dereq_(257);

var XML_PREAMBLE = '<?xml version="1.0" encoding="UTF-8"?>\n';

var ESCAPE_ATTR_CHARS = /<|>|'|"|&|\n\r|\n/g;
var ESCAPE_CHARS = /<|>|&/g;

function Namespaces(parent) {

  var prefixMap = {};
  var uriMap = {};
  var used = {};

  var wellknown = [];
  var custom = [];

  // API

  this.byUri = function (uri) {
    return uriMap[uri] || parent && parent.byUri(uri);
  };

  this.add = function (ns, isWellknown) {

    uriMap[ns.uri] = ns;

    if (isWellknown) {
      wellknown.push(ns);
    } else {
      custom.push(ns);
    }

    this.mapPrefix(ns.prefix, ns.uri);
  };

  this.uriByPrefix = function (prefix) {
    return prefixMap[prefix || 'xmlns'];
  };

  this.mapPrefix = function (prefix, uri) {
    prefixMap[prefix || 'xmlns'] = uri;
  };

  this.logUsed = function (ns) {
    var uri = ns.uri;

    used[uri] = this.byUri(uri);
  };

  this.getUsed = function (ns) {

    function isUsed(ns) {
      return used[ns.uri];
    }

    var allNs = [].concat(wellknown, custom);

    return allNs.filter(isUsed);
  };
}

function lower(string) {
  return string.charAt(0).toLowerCase() + string.slice(1);
}

function nameToAlias(name, pkg) {
  if ((0, _common.hasLowerCaseAlias)(pkg)) {
    return lower(name);
  } else {
    return name;
  }
}

function inherits(ctor, superCtor) {
  ctor.super_ = superCtor;
  ctor.prototype = Object.create(superCtor.prototype, {
    constructor: {
      value: ctor,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
}

function nsName(ns) {
  if ((0, _minDash.isString)(ns)) {
    return ns;
  } else {
    return (ns.prefix ? ns.prefix + ':' : '') + ns.localName;
  }
}

function getNsAttrs(namespaces) {

  return (0, _minDash.map)(namespaces.getUsed(), function (ns) {
    var name = 'xmlns' + (ns.prefix ? ':' + ns.prefix : '');
    return { name: name, value: ns.uri };
  });
}

function getElementNs(ns, descriptor) {
  if (descriptor.isGeneric) {
    return (0, _minDash.assign)({ localName: descriptor.ns.localName }, ns);
  } else {
    return (0, _minDash.assign)({ localName: nameToAlias(descriptor.ns.localName, descriptor.$pkg) }, ns);
  }
}

function getPropertyNs(ns, descriptor) {
  return (0, _minDash.assign)({ localName: descriptor.ns.localName }, ns);
}

function getSerializableProperties(element) {
  var descriptor = element.$descriptor;

  return (0, _minDash.filter)(descriptor.properties, function (p) {
    var name = p.name;

    if (p.isVirtual) {
      return false;
    }

    // do not serialize defaults
    if (!element.hasOwnProperty(name)) {
      return false;
    }

    var value = element[name];

    // do not serialize default equals
    if (value === p.default) {
      return false;
    }

    // do not serialize null properties
    if (value === null) {
      return false;
    }

    return p.isMany ? value.length : true;
  });
}

var ESCAPE_ATTR_MAP = {
  '\n': '#10',
  '\n\r': '#10',
  '"': '#34',
  '\'': '#39',
  '<': '#60',
  '>': '#62',
  '&': '#38'
};

var ESCAPE_MAP = {
  '<': 'lt',
  '>': 'gt',
  '&': 'amp'
};

function escape(str, charPattern, replaceMap) {

  // ensure we are handling strings here
  str = (0, _minDash.isString)(str) ? str : '' + str;

  return str.replace(charPattern, function (s) {
    return '&' + replaceMap[s] + ';';
  });
}

/**
 * Escape a string attribute to not contain any bad values (line breaks, '"', ...)
 *
 * @param {String} str the string to escape
 * @return {String} the escaped string
 */
function escapeAttr(str) {
  return escape(str, ESCAPE_ATTR_CHARS, ESCAPE_ATTR_MAP);
}

function escapeBody(str) {
  return escape(str, ESCAPE_CHARS, ESCAPE_MAP);
}

function filterAttributes(props) {
  return (0, _minDash.filter)(props, function (p) {
    return p.isAttr;
  });
}

function filterContained(props) {
  return (0, _minDash.filter)(props, function (p) {
    return !p.isAttr;
  });
}

function ReferenceSerializer(tagName) {
  this.tagName = tagName;
}

ReferenceSerializer.prototype.build = function (element) {
  this.element = element;
  return this;
};

ReferenceSerializer.prototype.serializeTo = function (writer) {
  writer.appendIndent().append('<' + this.tagName + '>' + this.element.id + '</' + this.tagName + '>').appendNewLine();
};

function BodySerializer() {}

BodySerializer.prototype.serializeValue = BodySerializer.prototype.serializeTo = function (writer) {
  writer.append(this.escape ? escapeBody(this.value) : this.value);
};

BodySerializer.prototype.build = function (prop, value) {
  this.value = value;

  if (prop.type === 'String' && value.search(ESCAPE_CHARS) !== -1) {
    this.escape = true;
  }

  return this;
};

function ValueSerializer(tagName) {
  this.tagName = tagName;
}

inherits(ValueSerializer, BodySerializer);

ValueSerializer.prototype.serializeTo = function (writer) {

  writer.appendIndent().append('<' + this.tagName + '>');

  this.serializeValue(writer);

  writer.append('</' + this.tagName + '>').appendNewLine();
};

function ElementSerializer(parent, propertyDescriptor) {
  this.body = [];
  this.attrs = [];

  this.parent = parent;
  this.propertyDescriptor = propertyDescriptor;
}

ElementSerializer.prototype.build = function (element) {
  this.element = element;

  var elementDescriptor = element.$descriptor,
      propertyDescriptor = this.propertyDescriptor;

  var otherAttrs, properties;

  var isGeneric = elementDescriptor.isGeneric;

  if (isGeneric) {
    otherAttrs = this.parseGeneric(element);
  } else {
    otherAttrs = this.parseNsAttributes(element);
  }

  if (propertyDescriptor) {
    this.ns = this.nsPropertyTagName(propertyDescriptor);
  } else {
    this.ns = this.nsTagName(elementDescriptor);
  }

  // compute tag name
  this.tagName = this.addTagName(this.ns);

  if (!isGeneric) {
    properties = getSerializableProperties(element);

    this.parseAttributes(filterAttributes(properties));
    this.parseContainments(filterContained(properties));
  }

  this.parseGenericAttributes(element, otherAttrs);

  return this;
};

ElementSerializer.prototype.nsTagName = function (descriptor) {
  var effectiveNs = this.logNamespaceUsed(descriptor.ns);
  return getElementNs(effectiveNs, descriptor);
};

ElementSerializer.prototype.nsPropertyTagName = function (descriptor) {
  var effectiveNs = this.logNamespaceUsed(descriptor.ns);
  return getPropertyNs(effectiveNs, descriptor);
};

ElementSerializer.prototype.isLocalNs = function (ns) {
  return ns.uri === this.ns.uri;
};

/**
 * Get the actual ns attribute name for the given element.
 *
 * @param {Object} element
 * @param {Boolean} [element.inherited=false]
 *
 * @return {Object} nsName
 */
ElementSerializer.prototype.nsAttributeName = function (element) {

  var ns;

  if ((0, _minDash.isString)(element)) {
    ns = (0, _ns.parseName)(element);
  } else {
    ns = element.ns;
  }

  // return just local name for inherited attributes
  if (element.inherited) {
    return { localName: ns.localName };
  }

  // parse + log effective ns
  var effectiveNs = this.logNamespaceUsed(ns);

  // LOG ACTUAL namespace use
  this.getNamespaces().logUsed(effectiveNs);

  // strip prefix if same namespace like parent
  if (this.isLocalNs(effectiveNs)) {
    return { localName: ns.localName };
  } else {
    return (0, _minDash.assign)({ localName: ns.localName }, effectiveNs);
  }
};

ElementSerializer.prototype.parseGeneric = function (element) {

  var self = this,
      body = this.body;

  var attributes = [];

  (0, _minDash.forEach)(element, function (val, key) {

    var nonNsAttr;

    if (key === '$body') {
      body.push(new BodySerializer().build({ type: 'String' }, val));
    } else if (key === '$children') {
      (0, _minDash.forEach)(val, function (child) {
        body.push(new ElementSerializer(self).build(child));
      });
    } else if (key.indexOf('$') !== 0) {
      nonNsAttr = self.parseNsAttribute(element, key, val);

      if (nonNsAttr) {
        attributes.push({ name: key, value: val });
      }
    }
  });

  return attributes;
};

ElementSerializer.prototype.parseNsAttribute = function (element, name, value) {
  var model = element.$model;

  var nameNs = (0, _ns.parseName)(name);

  var ns;

  // parse xmlns:foo="http://foo.bar"
  if (nameNs.prefix === 'xmlns') {
    ns = { prefix: nameNs.localName, uri: value };
  }

  // parse xmlns="http://foo.bar"
  if (!nameNs.prefix && nameNs.localName === 'xmlns') {
    ns = { uri: value };
  }

  if (!ns) {
    return {
      name: name,
      value: value
    };
  }

  if (model && model.getPackage(value)) {
    // register well known namespace
    this.logNamespace(ns, true, true);
  } else {
    // log custom namespace directly as used
    var actualNs = this.logNamespaceUsed(ns, true);

    this.getNamespaces().logUsed(actualNs);
  }
};

/**
 * Parse namespaces and return a list of left over generic attributes
 *
 * @param  {Object} element
 * @return {Array<Object>}
 */
ElementSerializer.prototype.parseNsAttributes = function (element, attrs) {
  var self = this;

  var genericAttrs = element.$attrs;

  var attributes = [];

  // parse namespace attributes first
  // and log them. push non namespace attributes to a list
  // and process them later
  (0, _minDash.forEach)(genericAttrs, function (value, name) {

    var nonNsAttr = self.parseNsAttribute(element, name, value);

    if (nonNsAttr) {
      attributes.push(nonNsAttr);
    }
  });

  return attributes;
};

ElementSerializer.prototype.parseGenericAttributes = function (element, attributes) {

  var self = this;

  (0, _minDash.forEach)(attributes, function (attr) {

    // do not serialize xsi:type attribute
    // it is set manually based on the actual implementation type
    if (attr.name === _common.XSI_TYPE) {
      return;
    }

    try {
      self.addAttribute(self.nsAttributeName(attr.name), attr.value);
    } catch (e) {
      console.warn('missing namespace information for ', attr.name, '=', attr.value, 'on', element, e);
    }
  });
};

ElementSerializer.prototype.parseContainments = function (properties) {

  var self = this,
      body = this.body,
      element = this.element;

  (0, _minDash.forEach)(properties, function (p) {
    var value = element.get(p.name),
        isReference = p.isReference,
        isMany = p.isMany;

    if (!isMany) {
      value = [value];
    }

    if (p.isBody) {
      body.push(new BodySerializer().build(p, value[0]));
    } else if ((0, _types.isSimple)(p.type)) {
      (0, _minDash.forEach)(value, function (v) {
        body.push(new ValueSerializer(self.addTagName(self.nsPropertyTagName(p))).build(p, v));
      });
    } else if (isReference) {
      (0, _minDash.forEach)(value, function (v) {
        body.push(new ReferenceSerializer(self.addTagName(self.nsPropertyTagName(p))).build(v));
      });
    } else {
      // allow serialization via type
      // rather than element name
      var asType = (0, _common.serializeAsType)(p),
          asProperty = (0, _common.serializeAsProperty)(p);

      (0, _minDash.forEach)(value, function (v) {
        var serializer;

        if (asType) {
          serializer = new TypeSerializer(self, p);
        } else if (asProperty) {
          serializer = new ElementSerializer(self, p);
        } else {
          serializer = new ElementSerializer(self);
        }

        body.push(serializer.build(v));
      });
    }
  });
};

ElementSerializer.prototype.getNamespaces = function (local) {

  var namespaces = this.namespaces,
      parent = this.parent,
      parentNamespaces;

  if (!namespaces) {
    parentNamespaces = parent && parent.getNamespaces();

    if (local || !parentNamespaces) {
      this.namespaces = namespaces = new Namespaces(parentNamespaces);
    } else {
      namespaces = parentNamespaces;
    }
  }

  return namespaces;
};

ElementSerializer.prototype.logNamespace = function (ns, wellknown, local) {
  var namespaces = this.getNamespaces(local);

  var nsUri = ns.uri,
      nsPrefix = ns.prefix;

  var existing = namespaces.byUri(nsUri);

  if (!existing) {
    namespaces.add(ns, wellknown);
  }

  namespaces.mapPrefix(nsPrefix, nsUri);

  return ns;
};

ElementSerializer.prototype.logNamespaceUsed = function (ns, local) {
  var element = this.element,
      model = element.$model,
      namespaces = this.getNamespaces(local);

  // ns may be
  //
  //   * prefix only
  //   * prefix:uri
  //   * localName only

  var prefix = ns.prefix,
      uri = ns.uri,
      newPrefix,
      idx,
      wellknownUri;

  // handle anonymous namespaces (elementForm=unqualified), cf. #23
  if (!prefix && !uri) {
    return { localName: ns.localName };
  }

  wellknownUri = _common.DEFAULT_NS_MAP[prefix] || model && (model.getPackage(prefix) || {}).uri;

  uri = uri || wellknownUri || namespaces.uriByPrefix(prefix);

  if (!uri) {
    throw new Error('no namespace uri given for prefix <' + prefix + '>');
  }

  ns = namespaces.byUri(uri);

  if (!ns) {
    newPrefix = prefix;
    idx = 1;

    // find a prefix that is not mapped yet
    while (namespaces.uriByPrefix(newPrefix)) {
      newPrefix = prefix + '_' + idx++;
    }

    ns = this.logNamespace({ prefix: newPrefix, uri: uri }, wellknownUri === uri);
  }

  if (prefix) {
    namespaces.mapPrefix(prefix, uri);
  }

  return ns;
};

ElementSerializer.prototype.parseAttributes = function (properties) {
  var self = this,
      element = this.element;

  (0, _minDash.forEach)(properties, function (p) {

    var value = element.get(p.name);

    if (p.isReference) {

      if (!p.isMany) {
        value = value.id;
      } else {
        var values = [];
        (0, _minDash.forEach)(value, function (v) {
          values.push(v.id);
        });
        // IDREFS is a whitespace-separated list of references.
        value = values.join(' ');
      }
    }

    self.addAttribute(self.nsAttributeName(p), value);
  });
};

ElementSerializer.prototype.addTagName = function (nsTagName) {
  var actualNs = this.logNamespaceUsed(nsTagName);

  this.getNamespaces().logUsed(actualNs);

  return nsName(nsTagName);
};

ElementSerializer.prototype.addAttribute = function (name, value) {
  var attrs = this.attrs;

  if ((0, _minDash.isString)(value)) {
    value = escapeAttr(value);
  }

  attrs.push({ name: name, value: value });
};

ElementSerializer.prototype.serializeAttributes = function (writer) {
  var attrs = this.attrs,
      namespaces = this.namespaces;

  if (namespaces) {
    attrs = getNsAttrs(namespaces).concat(attrs);
  }

  (0, _minDash.forEach)(attrs, function (a) {
    writer.append(' ').append(nsName(a.name)).append('="').append(a.value).append('"');
  });
};

ElementSerializer.prototype.serializeTo = function (writer) {
  var firstBody = this.body[0],
      indent = firstBody && firstBody.constructor !== BodySerializer;

  writer.appendIndent().append('<' + this.tagName);

  this.serializeAttributes(writer);

  writer.append(firstBody ? '>' : ' />');

  if (firstBody) {

    if (indent) {
      writer.appendNewLine().indent();
    }

    (0, _minDash.forEach)(this.body, function (b) {
      b.serializeTo(writer);
    });

    if (indent) {
      writer.unindent().appendIndent();
    }

    writer.append('</' + this.tagName + '>');
  }

  writer.appendNewLine();
};

/**
 * A serializer for types that handles serialization of data types
 */
function TypeSerializer(parent, propertyDescriptor) {
  ElementSerializer.call(this, parent, propertyDescriptor);
}

inherits(TypeSerializer, ElementSerializer);

TypeSerializer.prototype.parseNsAttributes = function (element) {

  // extracted attributes
  var attributes = ElementSerializer.prototype.parseNsAttributes.call(this, element);

  var descriptor = element.$descriptor;

  // only serialize xsi:type if necessary
  if (descriptor.name === this.propertyDescriptor.type) {
    return attributes;
  }

  var typeNs = this.typeNs = this.nsTagName(descriptor);
  this.getNamespaces().logUsed(this.typeNs);

  // add xsi:type attribute to represent the elements
  // actual type

  var pkg = element.$model.getPackage(typeNs.uri),
      typePrefix = pkg.xml && pkg.xml.typePrefix || '';

  this.addAttribute(this.nsAttributeName(_common.XSI_TYPE), (typeNs.prefix ? typeNs.prefix + ':' : '') + typePrefix + descriptor.ns.localName);

  return attributes;
};

TypeSerializer.prototype.isLocalNs = function (ns) {
  return ns.uri === (this.typeNs || this.ns).uri;
};

function SavingWriter() {
  this.value = '';

  this.write = function (str) {
    this.value += str;
  };
}

function FormatingWriter(out, format) {

  var indent = [''];

  this.append = function (str) {
    out.write(str);

    return this;
  };

  this.appendNewLine = function () {
    if (format) {
      out.write('\n');
    }

    return this;
  };

  this.appendIndent = function () {
    if (format) {
      out.write(indent.join('  '));
    }

    return this;
  };

  this.indent = function () {
    indent.push('');
    return this;
  };

  this.unindent = function () {
    indent.pop();
    return this;
  };
}

/**
 * A writer for meta-model backed document trees
 *
 * @param {Object} options output options to pass into the writer
 */
function Writer(options) {

  options = (0, _minDash.assign)({ format: false, preamble: true }, options || {});

  function toXML(tree, writer) {
    var internalWriter = writer || new SavingWriter();
    var formatingWriter = new FormatingWriter(internalWriter, options.format);

    if (options.preamble) {
      formatingWriter.append(XML_PREAMBLE);
    }

    new ElementSerializer().build(tree).serializeTo(formatingWriter);

    if (!writer) {
      return internalWriter.value;
    }
  }

  return {
    toXML: toXML
  };
}

},{"254":254,"257":257,"265":265,"268":268}],260:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _moddle = _dereq_(264);

Object.defineProperty(exports, 'default', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_moddle).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

},{"264":264}],261:[function(_dereq_,module,exports){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Base;
/**
 * Moddle base element.
 */
function Base() {}

Base.prototype.get = function (name) {
  return this.$model.properties.get(this, name);
};

Base.prototype.set = function (name, value) {
  this.$model.properties.set(this, name, value);
};

},{}],262:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DescriptorBuilder;

var _minDash = _dereq_(254);

var _ns = _dereq_(265);

/**
 * A utility to build element descriptors.
 */
function DescriptorBuilder(nameNs) {
  this.ns = nameNs;
  this.name = nameNs.name;
  this.allTypes = [];
  this.allTypesByName = {};
  this.properties = [];
  this.propertiesByName = {};
}

DescriptorBuilder.prototype.build = function () {
  return (0, _minDash.pick)(this, ['ns', 'name', 'allTypes', 'allTypesByName', 'properties', 'propertiesByName', 'bodyProperty', 'idProperty']);
};

/**
 * Add property at given index.
 *
 * @param {Object} p
 * @param {Number} [idx]
 * @param {Boolean} [validate=true]
 */
DescriptorBuilder.prototype.addProperty = function (p, idx, validate) {

  if (typeof idx === 'boolean') {
    validate = idx;
    idx = undefined;
  }

  this.addNamedProperty(p, validate !== false);

  var properties = this.properties;

  if (idx !== undefined) {
    properties.splice(idx, 0, p);
  } else {
    properties.push(p);
  }
};

DescriptorBuilder.prototype.replaceProperty = function (oldProperty, newProperty, replace) {
  var oldNameNs = oldProperty.ns;

  var props = this.properties,
      propertiesByName = this.propertiesByName,
      rename = oldProperty.name !== newProperty.name;

  if (oldProperty.isId) {
    if (!newProperty.isId) {
      throw new Error('property <' + newProperty.ns.name + '> must be id property ' + 'to refine <' + oldProperty.ns.name + '>');
    }

    this.setIdProperty(newProperty, false);
  }

  if (oldProperty.isBody) {

    if (!newProperty.isBody) {
      throw new Error('property <' + newProperty.ns.name + '> must be body property ' + 'to refine <' + oldProperty.ns.name + '>');
    }

    // TODO: Check compatibility
    this.setBodyProperty(newProperty, false);
  }

  // validate existence and get location of old property
  var idx = props.indexOf(oldProperty);
  if (idx === -1) {
    throw new Error('property <' + oldNameNs.name + '> not found in property list');
  }

  // remove old property
  props.splice(idx, 1);

  // replacing the named property is intentional
  //
  //  * validate only if this is a "rename" operation
  //  * add at specific index unless we "replace"
  //
  this.addProperty(newProperty, replace ? undefined : idx, rename);

  // make new property available under old name
  propertiesByName[oldNameNs.name] = propertiesByName[oldNameNs.localName] = newProperty;
};

DescriptorBuilder.prototype.redefineProperty = function (p, targetPropertyName, replace) {

  var nsPrefix = p.ns.prefix;
  var parts = targetPropertyName.split('#');

  var name = (0, _ns.parseName)(parts[0], nsPrefix);
  var attrName = (0, _ns.parseName)(parts[1], name.prefix).name;

  var redefinedProperty = this.propertiesByName[attrName];
  if (!redefinedProperty) {
    throw new Error('refined property <' + attrName + '> not found');
  } else {
    this.replaceProperty(redefinedProperty, p, replace);
  }

  delete p.redefines;
};

DescriptorBuilder.prototype.addNamedProperty = function (p, validate) {
  var ns = p.ns,
      propsByName = this.propertiesByName;

  if (validate) {
    this.assertNotDefined(p, ns.name);
    this.assertNotDefined(p, ns.localName);
  }

  propsByName[ns.name] = propsByName[ns.localName] = p;
};

DescriptorBuilder.prototype.removeNamedProperty = function (p) {
  var ns = p.ns,
      propsByName = this.propertiesByName;

  delete propsByName[ns.name];
  delete propsByName[ns.localName];
};

DescriptorBuilder.prototype.setBodyProperty = function (p, validate) {

  if (validate && this.bodyProperty) {
    throw new Error('body property defined multiple times ' + '(<' + this.bodyProperty.ns.name + '>, <' + p.ns.name + '>)');
  }

  this.bodyProperty = p;
};

DescriptorBuilder.prototype.setIdProperty = function (p, validate) {

  if (validate && this.idProperty) {
    throw new Error('id property defined multiple times ' + '(<' + this.idProperty.ns.name + '>, <' + p.ns.name + '>)');
  }

  this.idProperty = p;
};

DescriptorBuilder.prototype.assertNotDefined = function (p, name) {
  var propertyName = p.name,
      definedProperty = this.propertiesByName[propertyName];

  if (definedProperty) {
    throw new Error('property <' + propertyName + '> already defined; ' + 'override of <' + definedProperty.definedBy.ns.name + '#' + definedProperty.ns.name + '> by ' + '<' + p.definedBy.ns.name + '#' + p.ns.name + '> not allowed without redefines');
  }
};

DescriptorBuilder.prototype.hasProperty = function (name) {
  return this.propertiesByName[name];
};

DescriptorBuilder.prototype.addTrait = function (t, inherited) {

  var typesByName = this.allTypesByName,
      types = this.allTypes;

  var typeName = t.name;

  if (typeName in typesByName) {
    return;
  }

  (0, _minDash.forEach)(t.properties, (0, _minDash.bind)(function (p) {

    // clone property to allow extensions
    p = (0, _minDash.assign)({}, p, {
      name: p.ns.localName,
      inherited: inherited
    });

    Object.defineProperty(p, 'definedBy', {
      value: t
    });

    var replaces = p.replaces,
        redefines = p.redefines;

    // add replace/redefine support
    if (replaces || redefines) {
      this.redefineProperty(p, replaces || redefines, replaces);
    } else {
      if (p.isBody) {
        this.setBodyProperty(p);
      }
      if (p.isId) {
        this.setIdProperty(p);
      }
      this.addProperty(p);
    }
  }, this));

  types.push(t);
  typesByName[typeName] = t;
};

},{"254":254,"265":265}],263:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Factory;

var _minDash = _dereq_(254);

var _base = _dereq_(261);

var _base2 = _interopRequireDefault(_base);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A model element factory.
 *
 * @param {Moddle} model
 * @param {Properties} properties
 */
function Factory(model, properties) {
  this.model = model;
  this.properties = properties;
}

Factory.prototype.createType = function (descriptor) {

  var model = this.model;

  var props = this.properties,
      prototype = Object.create(_base2.default.prototype);

  // initialize default values
  (0, _minDash.forEach)(descriptor.properties, function (p) {
    if (!p.isMany && p.default !== undefined) {
      prototype[p.name] = p.default;
    }
  });

  props.defineModel(prototype, model);
  props.defineDescriptor(prototype, descriptor);

  var name = descriptor.ns.name;

  /**
   * The new type constructor
   */
  function ModdleElement(attrs) {
    props.define(this, '$type', { value: name, enumerable: true });
    props.define(this, '$attrs', { value: {} });
    props.define(this, '$parent', { writable: true });

    (0, _minDash.forEach)(attrs, (0, _minDash.bind)(function (val, key) {
      this.set(key, val);
    }, this));
  }

  ModdleElement.prototype = prototype;

  ModdleElement.hasType = prototype.$instanceOf = this.model.hasType;

  // static links
  props.defineModel(ModdleElement, model);
  props.defineDescriptor(ModdleElement, descriptor);

  return ModdleElement;
};

},{"254":254,"261":261}],264:[function(_dereq_,module,exports){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Moddle;

var _minDash = _dereq_(254);

var _factory = _dereq_(263);

var _factory2 = _interopRequireDefault(_factory);

var _registry = _dereq_(267);

var _registry2 = _interopRequireDefault(_registry);

var _properties = _dereq_(266);

var _properties2 = _interopRequireDefault(_properties);

var _ns = _dereq_(265);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

//// Moddle implementation /////////////////////////////////////////////////

/**
 * @class Moddle
 *
 * A model that can be used to create elements of a specific type.
 *
 *