"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Lint = require('tslint/lib/lint');
var sprintf_js_1 = require('sprintf-js');
var SyntaxKind = require('./util/syntaxKind');
var Rule = (function (_super) {
    __extends(Rule, _super);
    function Rule() {
        _super.apply(this, arguments);
    }
    Rule.prototype.apply = function (sourceFile) {
        return this.applyWithWalker(new ConstructorMetadataWalker(sourceFile, this.getOptions()));
    };
    Rule.FAILURE_STRING = 'In the constructor of class "%s",' +
        ' the parameter "%s" uses the @Attribute decorator, ' +
        'which is considered as a bad practice. Please,' +
        ' consider construction of type "@Input() %s: string"';
    return Rule;
}(Lint.Rules.AbstractRule));
exports.Rule = Rule;
var ConstructorMetadataWalker = (function (_super) {
    __extends(ConstructorMetadataWalker, _super);
    function ConstructorMetadataWalker() {
        _super.apply(this, arguments);
    }
    ConstructorMetadataWalker.prototype.visitConstructorDeclaration = function (node) {
        var syntaxKind = SyntaxKind.current();
        var parentName = "";
        var parent = node.parent;
        if (parent.kind === syntaxKind.ClassExpression) {
            parentName = parent.parent.name.text;
        }
        else if (parent.kind = syntaxKind.ClassDeclaration) {
            parentName = parent.name.text;
        }
        (node.parameters || []).forEach(this.validateParameter.bind(this, parentName));
        _super.prototype.visitConstructorDeclaration.call(this, node);
    };
    ConstructorMetadataWalker.prototype.validateParameter = function (className, parameter) {
        var _this = this;
        var parameterName = parameter.name.text;
        if (parameter.decorators) {
            parameter.decorators.forEach(function (decorator) {
                var baseExpr = decorator.expression || {};
                var expr = baseExpr.expression || {};
                var name = expr.text;
                if (name == 'Attribute') {
                    var failureConfig = [className, parameterName, parameterName];
                    failureConfig.unshift(Rule.FAILURE_STRING);
                    _this.addFailure(_this.createFailure(parameter.getStart(), parameter.getWidth(), sprintf_js_1.sprintf.apply(_this, failureConfig)));
                }
            });
        }
    };
    return ConstructorMetadataWalker;
}(Lint.RuleWalker));
exports.ConstructorMetadataWalker = ConstructorMetadataWalker;
