"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Lint = require('tslint/lib/lint');
var ts = require('typescript');
var compiler_1 = require('@angular/compiler');
var templateParser_1 = require('./templateParser');
var recursiveAngularExpressionVisitor_1 = require('./recursiveAngularExpressionVisitor');
var expressionTypes_1 = require('./expressionTypes');
var getDecoratorName = function (decorator) {
    var baseExpr = decorator.expression || {};
    var expr = baseExpr.expression || {};
    return expr.text;
};
var getDecoratorStringArgs = function (decorator) {
    var baseExpr = decorator.expression || {};
    var args = baseExpr.arguments || [];
    return args.map(function (a) { return (a.kind === ts.SyntaxKind.StringLiteral) ? a.text : null; });
};
var getExpressionDisplacement = function (binding) {
    var attrLen = 0;
    var valLen = 0;
    var totalLength = 0;
    var result = 0;
    if (binding instanceof compiler_1.BoundEventAst || binding instanceof compiler_1.BoundElementPropertyAst) {
        var subBindingLen = 0;
        if (binding instanceof compiler_1.BoundElementPropertyAst) {
            var prop = binding;
            switch (prop.type) {
                case compiler_1.PropertyBindingType.Animation:
                    subBindingLen = 'animate'.length + 1;
                    break;
                case compiler_1.PropertyBindingType.Attribute:
                    subBindingLen = 'attr'.length + 1;
                    break;
                case compiler_1.PropertyBindingType.Class:
                    subBindingLen = 'class'.length + 1;
                    break;
                case compiler_1.PropertyBindingType.Style:
                    subBindingLen = 'style'.length + 1;
                    break;
            }
        }
        attrLen = binding.name.length + 4 + subBindingLen;
        if (binding instanceof compiler_1.BoundEventAst) {
            valLen = binding.handler.span.end;
        }
        else {
            valLen = binding.value.span.end;
        }
        totalLength = binding.sourceSpan.end.offset - binding.sourceSpan.start.offset;
        var whitespace = totalLength - (attrLen + valLen) - 1;
        result = whitespace + attrLen + binding.sourceSpan.start.offset;
    }
    else if (binding instanceof compiler_1.BoundTextAst) {
        result = binding.sourceSpan.start.offset;
    }
    return result;
};
var Ng2Walker = (function (_super) {
    __extends(Ng2Walker, _super);
    function Ng2Walker(sourceFile, _originalOptions, TemplateVisitorCtr) {
        if (TemplateVisitorCtr === void 0) { TemplateVisitorCtr = recursiveAngularExpressionVisitor_1.RecursiveAngularExpressionVisitor; }
        _super.call(this, sourceFile, _originalOptions);
        this._originalOptions = _originalOptions;
        this.TemplateVisitorCtr = TemplateVisitorCtr;
    }
    Ng2Walker.prototype.visitClassDeclaration = function (declaration) {
        (declaration.decorators || []).forEach(this.visitClassDecorator.bind(this));
        _super.prototype.visitClassDeclaration.call(this, declaration);
    };
    Ng2Walker.prototype.visitMethodDeclaration = function (method) {
        (method.decorators || []).forEach(this.visitMethodDecorator.bind(this));
        _super.prototype.visitMethodDeclaration.call(this, method);
    };
    Ng2Walker.prototype.visitPropertyDeclaration = function (prop) {
        (prop.decorators || []).forEach(this.visitPropertyDecorator.bind(this));
        _super.prototype.visitPropertyDeclaration.call(this, prop);
    };
    Ng2Walker.prototype.visitMethodDecorator = function (decorator) {
        var name = getDecoratorName(decorator);
        if (name === 'HostListener') {
            this.visitNg2HostListener(decorator.parent, decorator, getDecoratorStringArgs(decorator));
        }
    };
    Ng2Walker.prototype.visitPropertyDecorator = function (decorator) {
        var name = getDecoratorName(decorator);
        switch (name) {
            case 'Input':
                this.visitNg2Input(decorator.parent, decorator, getDecoratorStringArgs(decorator));
                break;
            case 'Output':
                this.visitNg2Output(decorator.parent, decorator, getDecoratorStringArgs(decorator));
                break;
            case 'HostBinding':
                this.visitNg2HostBinding(decorator.parent, decorator, getDecoratorStringArgs(decorator));
                break;
        }
    };
    Ng2Walker.prototype.visitClassDecorator = function (decorator) {
        var name = getDecoratorName(decorator);
        if (name === 'Component') {
            this.visitNg2Component(decorator.parent, decorator);
            var inlineTemplate = decorator.expression.arguments[0]
                .properties.map(function (prop) {
                if (prop.name.text === 'template') {
                    return prop;
                }
                return null;
            }).filter(function (el) { return !!el; }).map(function (prop) { return prop.initializer; }).pop();
            if (inlineTemplate) {
                this.visitNg2TemplateHelper(templateParser_1.parseTemplate(inlineTemplate.text), decorator.parent, inlineTemplate.pos + 2);
            }
        }
        else if (name === 'Directive') {
            this.visitNg2Directive(decorator.parent, decorator);
        }
    };
    Ng2Walker.prototype.visitNg2TemplateAST = function (ast, context, templateStart) {
        var _this = this;
        var templateVisitor = new this.TemplateVisitorCtr(this.getSourceFile(), this._originalOptions, context, templateStart);
        templateVisitor.visit(ast);
        templateVisitor.getFailures().forEach(function (f) { return _this.addFailure(f); });
    };
    Ng2Walker.prototype.visitNg2TemplateBoundText = function (text, context, templateStart) {
        if (expressionTypes_1.ExpTypes.ASTWithSource(text.value)) {
            var ast = text.value.ast;
            ast.expression = text.value.source;
            this.visitNg2TemplateAST(ast, context, templateStart + getExpressionDisplacement(text));
        }
    };
    Ng2Walker.prototype.visitNg2TemplateBoundElementPropertyAst = function (prop, context, templateStart) {
        this.visitNg2TemplateAST(prop.value, context, templateStart + getExpressionDisplacement(prop));
    };
    Ng2Walker.prototype.visitNg2TemplateBoundElementEventAst = function (event, context, templateStart) {
        this.visitNg2TemplateAST(event.handler, context, templateStart + getExpressionDisplacement(event));
    };
    Ng2Walker.prototype.visitNg2TemplateElement = function (element, context, templateStart) {
        var _this = this;
        element.inputs.forEach(function (i) { return _this.visitNg2TemplateBoundElementPropertyAst(i, context, templateStart); });
        element.outputs.forEach(function (o) { return _this.visitNg2TemplateBoundElementEventAst(o, context, templateStart); });
        element.attrs.forEach(function (a) { return _this.visitNg2TemplateAttribute(a, templateStart); });
        element.children.forEach(function (e) { return _this.visitNg2Template(e, context, templateStart); });
    };
    Ng2Walker.prototype.visitNg2Component = function (controller, decorator) { };
    Ng2Walker.prototype.visitNg2Directive = function (controller, decorator) { };
    Ng2Walker.prototype.visitNg2Input = function (property, input, args) { };
    Ng2Walker.prototype.visitNg2Output = function (property, output, args) { };
    Ng2Walker.prototype.visitNg2HostBinding = function (property, decorator, args) { };
    Ng2Walker.prototype.visitNg2HostListener = function (method, decorator, args) { };
    Ng2Walker.prototype.visitNg2TemplateAttribute = function (attr, templateStart) { };
    Ng2Walker.prototype.visitNg2TemplateText = function (text, context, templateStart) { };
    Ng2Walker.prototype.visitNg2Template = function (root, context, templateStart) {
        if (root instanceof compiler_1.ElementAst) {
            return this.visitNg2TemplateElement(root, context, templateStart);
        }
        else if (root instanceof compiler_1.TextAst) {
            return this.visitNg2TemplateText(root, context, templateStart);
        }
        else if (root instanceof compiler_1.BoundTextAst) {
            return this.visitNg2TemplateBoundText(root, context, templateStart);
        }
    };
    Ng2Walker.prototype.visitNg2TemplateHelper = function (roots, context, baseStart) {
        var _this = this;
        if (!roots || !roots.length) {
            return;
        }
        else {
            roots.forEach(function (root) {
                return _this.visitNg2Template(root, context, baseStart);
            });
        }
    };
    return Ng2Walker;
}(Lint.RuleWalker));
exports.Ng2Walker = Ng2Walker;
