"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Lint = require('tslint/lib/lint');
var ts = require('typescript');
var compiler = require('@angular/compiler');
var templateParser_1 = require('./templates/templateParser');
var parseCss_1 = require('./styles/parseCss');
var basicCssAstVisitor_1 = require('./styles/basicCssAstVisitor');
var basicTemplateAstVisitor_1 = require('./templates/basicTemplateAstVisitor');
var recursiveAngularExpressionVisitor_1 = require('./templates/recursiveAngularExpressionVisitor');
var utils_1 = require('../util/utils');
var SyntaxKind = require('../util/syntaxKind');
var getDecoratorStringArgs = function (decorator) {
    var baseExpr = decorator.expression || {};
    var args = baseExpr.arguments || [];
    return args.map(function (a) { return (a.kind === ts.SyntaxKind.StringLiteral) ? a.text : null; });
};
var Ng2Walker = (function (_super) {
    __extends(Ng2Walker, _super);
    function Ng2Walker(sourceFile, _originalOptions, _config) {
        _super.call(this, sourceFile, _originalOptions);
        this._originalOptions = _originalOptions;
        this._config = _config;
        this._normalizeConfig(_config);
    }
    Ng2Walker.prototype.visitClassDeclaration = function (declaration) {
        (declaration.decorators || []).forEach(this.visitClassDecorator.bind(this));
        _super.prototype.visitClassDeclaration.call(this, declaration);
    };
    Ng2Walker.prototype.visitMethodDeclaration = function (method) {
        (method.decorators || []).forEach(this.visitMethodDecorator.bind(this));
        _super.prototype.visitMethodDeclaration.call(this, method);
    };
    Ng2Walker.prototype.visitPropertyDeclaration = function (prop) {
        (prop.decorators || []).forEach(this.visitPropertyDecorator.bind(this));
        _super.prototype.visitPropertyDeclaration.call(this, prop);
    };
    Ng2Walker.prototype.visitMethodDecorator = function (decorator) {
        var name = utils_1.getDecoratorName(decorator);
        if (name === 'HostListener') {
            this.visitNg2HostListener(decorator.parent, decorator, getDecoratorStringArgs(decorator));
        }
    };
    Ng2Walker.prototype.visitPropertyDecorator = function (decorator) {
        var name = utils_1.getDecoratorName(decorator);
        switch (name) {
            case 'Input':
                this.visitNg2Input(decorator.parent, decorator, getDecoratorStringArgs(decorator));
                break;
            case 'Output':
                this.visitNg2Output(decorator.parent, decorator, getDecoratorStringArgs(decorator));
                break;
            case 'HostBinding':
                this.visitNg2HostBinding(decorator.parent, decorator, getDecoratorStringArgs(decorator));
                break;
        }
    };
    Ng2Walker.prototype.visitClassDecorator = function (decorator) {
        var _this = this;
        var name = utils_1.getDecoratorName(decorator);
        if (!decorator.expression.arguments ||
            !decorator.expression.arguments.length ||
            !decorator.expression.arguments[0].properties) {
            return;
        }
        if (name === 'Component') {
            this.visitNg2Component(decorator.parent, decorator);
            var inlineTemplate = utils_1.getDecoratorPropertyInitializer(decorator, 'template');
            if (inlineTemplate) {
                try {
                    if (utils_1.isSimpleTemplateString(inlineTemplate)) {
                        var templateAst = templateParser_1.parseTemplate(inlineTemplate.text);
                        this.visitNg2TemplateHelper(templateAst, decorator.parent, inlineTemplate.pos + 2);
                    }
                }
                catch (e) {
                }
            }
            var inlineStyles = utils_1.getDecoratorPropertyInitializer(decorator, 'styles');
            if (inlineStyles && inlineStyles.kind === SyntaxKind.current().ArrayLiteralExpression) {
                inlineStyles.elements.forEach(function (inlineStyle) {
                    try {
                        if (utils_1.isSimpleTemplateString(inlineStyle)) {
                            _this.visitNg2StyleHelper(parseCss_1.parseCss(inlineStyle.text), decorator.parent, inlineStyle.pos + 2);
                        }
                    }
                    catch (e) {
                    }
                });
            }
        }
        else if (name === 'Directive') {
            this.visitNg2Directive(decorator.parent, decorator);
        }
        else if (name === 'Pipe') {
            this.visitNg2Pipe(decorator.parent, decorator);
        }
    };
    Ng2Walker.prototype.visitNg2Component = function (controller, decorator) { };
    Ng2Walker.prototype.visitNg2Directive = function (controller, decorator) { };
    Ng2Walker.prototype.visitNg2Pipe = function (controller, decorator) { };
    Ng2Walker.prototype.visitNg2Input = function (property, input, args) { };
    Ng2Walker.prototype.visitNg2Output = function (property, output, args) { };
    Ng2Walker.prototype.visitNg2HostBinding = function (property, decorator, args) { };
    Ng2Walker.prototype.visitNg2HostListener = function (method, decorator, args) { };
    Ng2Walker.prototype.visitNg2TemplateHelper = function (roots, context, baseStart) {
        var _this = this;
        if (!roots || !roots.length) {
            return;
        }
        else {
            var visitor = new this._config.templateVisitorCtrl(this.getSourceFile(), this._originalOptions, context, baseStart, this._config.expressionVisitorCtrl);
            compiler.templateVisitAll(visitor, roots, context);
            visitor.getFailures().forEach(function (f) { return _this.addFailure(f); });
        }
    };
    Ng2Walker.prototype.visitNg2StyleHelper = function (style, context, baseStart) {
        var _this = this;
        if (!style) {
            return;
        }
        else {
            var visitor = new this._config.cssVisitorCtrl(this.getSourceFile(), this._originalOptions, context, baseStart);
            style.visit(visitor);
            visitor.getFailures().forEach(function (f) { return _this.addFailure(f); });
        }
    };
    Ng2Walker.prototype._normalizeConfig = function (config) {
        this._config = Object.assign({
            templateVisitorCtrl: basicTemplateAstVisitor_1.BasicTemplateAstVisitor,
            expressionVisitorCtrl: recursiveAngularExpressionVisitor_1.RecursiveAngularExpressionVisitor,
            cssVisitorCtrl: basicCssAstVisitor_1.BasicCssAstVisitor
        }, this._config || {});
    };
    return Ng2Walker;
}(Lint.RuleWalker));
exports.Ng2Walker = Ng2Walker;
