"use strict";
var core_1 = require('@angular/core');
var config_1 = require('../config');
var compiler = require('@angular/compiler');
exports.parseTemplate = function (template) {
    var TemplateParser = compiler.TemplateParser;
    var expressionParser = new compiler.Parser(new compiler.Lexer());
    var elementSchemaRegistry = new compiler.DomElementSchemaRegistry();
    var ngConsole = new core_1.__core_private__.Console();
    var htmlParser = new compiler.I18NHtmlParser(new compiler.HtmlParser());
    var tmplParser = new TemplateParser(expressionParser, elementSchemaRegistry, htmlParser, ngConsole, []);
    var interpolation = config_1.INTERPOLATION;
    var templateMetadata = {
        encapsulation: 0,
        template: template,
        templateUrl: '',
        styles: [],
        styleUrls: [],
        ngContentSelectors: [],
        animations: [],
        externalStylesheets: [],
        interpolation: interpolation
    };
    var type = new compiler.CompileTypeMetadata({ diDeps: [] });
    return tmplParser.tryParse(compiler.CompileDirectiveMetadata.create({ type: type, template: templateMetadata }), template, [], [], [core_1.NO_ERRORS_SCHEMA], '').templateAst;
};
