"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var selectorNameBase_1 = require("./selectorNameBase");
var Lint = require("tslint");
var Rule = (function (_super) {
    __extends(Rule, _super);
    function Rule() {
        var _this = _super.apply(this, arguments) || this;
        _this.handleType = 'Directive';
        return _this;
    }
    Rule.prototype.getTypeFailure = function () { return 'The selector of the directive "%s" should be used as %s (https://goo.gl/QS8kEs)'; };
    Rule.prototype.getStyleFailure = function () { return 'The selector of the directive "%s" should be named %s (https://goo.gl/QS8kEs)'; };
    Rule.prototype.getPrefixFailure = function (prefixes) {
        if (prefixes.length === 1) {
            return 'The selector of the directive "%s" should have prefix "%s" (https://goo.gl/uacjKR)';
        }
        else {
            return 'The selector of the directive "%s" should have one of the prefixes "%s" (https://goo.gl/uacjKR)';
        }
    };
    return Rule;
}(selectorNameBase_1.SelectorRule));
Rule.metadata = {
    ruleName: 'directive-selector',
    type: 'style',
    description: "Directive selectors should follow given naming rules.",
    descriptionDetails: "See more at https://angular.io/styleguide#!#02-07, https://angular.io/styleguide#!#05-02, " +
        "and https://angular.io/styleguide#!#05-03.",
    rationale: (_a = ["\n    * Consistent conventions make it easy to quickly identify and reference assets of different types.\n    * Makes it easier to promote and share the directive in other apps.\n    * Directives are easy to identify in the DOM.\n    * It is easier to recognize that a symbol is a directive by looking at the template's HTML.\n    "], _a.raw = ["\n    * Consistent conventions make it easy to quickly identify and reference assets of different types.\n    * Makes it easier to promote and share the directive in other apps.\n    * Directives are easy to identify in the DOM.\n    * It is easier to recognize that a symbol is a directive by looking at the template's HTML.\n    "], Lint.Utils.dedent(_a)),
    options: {
        'type': 'array',
        'items': [
            {
                'enum': ['element', 'attribute']
            },
            {
                'oneOf': [
                    {
                        'type': 'array',
                        'items': {
                            'type': 'string'
                        }
                    },
                    {
                        'type': 'string'
                    }
                ]
            },
            {
                'enum': ['kebab-case', 'camelCase']
            }
        ],
        'minItems': 3,
        'maxItems': 3
    },
    optionExamples: [
        "[\"element\", \"my-prefix\", \"kebab-case\"]",
        "[\"element\", [\"ng\", \"ngx\"], \"kebab-case\"]",
        "[\"attribute\", \"myPrefix\", \"camelCase\"]",
    ],
    optionsDescription: (_b = ["\n    Options accept three obligatory items as an array:\n\n    1. `\"element\"` or `\"attribute\"` forces components either to be elements or attributes.\n    2. A single prefix (string) or array of prefixes (strings) which have to be used in directive selectors.\n    3. `\"kebab-case\"` or `\"camelCase\"` allows you to pick a case.\n    "], _b.raw = ["\n    Options accept three obligatory items as an array:\n\n    1. \\`\"element\"\\` or \\`\"attribute\"\\` forces components either to be elements or attributes.\n    2. A single prefix (string) or array of prefixes (strings) which have to be used in directive selectors.\n    3. \\`\"kebab-case\"\\` or \\`\"camelCase\"\\` allows you to pick a case.\n    "], Lint.Utils.dedent(_b)),
    typescriptOnly: true,
};
exports.Rule = Rule;
var _a, _b;
