"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Lint = require("tslint");
var ngWalker_1 = require("./angular/ngWalker");
var ast = require("@angular/compiler");
var basicTemplateAstVisitor_1 = require("./angular/templates/basicTemplateAstVisitor");
var expressionTypes_1 = require("./angular/expressionTypes");
var config_1 = require("./angular/config");
var recursiveAngularExpressionVisitor_1 = require("./angular/templates/recursiveAngularExpressionVisitor");
var InterpolationOpen = config_1.Config.interpolation[0];
var InterpolationClose = config_1.Config.interpolation[1];
var InterpolationNoWhitespaceRe = new RegExp(InterpolationOpen + "\\S(.*?)\\S" + InterpolationClose + "|" + InterpolationOpen + "\\s(.*?)\\S" + InterpolationClose + "|" + InterpolationOpen + "\\S(.*?)\\s" + InterpolationClose);
var InterpolationExtraWhitespaceRe = new RegExp(InterpolationOpen + "\\s\\s(.*?)\\s" + InterpolationClose + "|" + InterpolationOpen + "\\s(.*?)\\s\\s" + InterpolationClose);
var getReplacements = function (text, absolutePosition) {
    var expr = text.value.source;
    var internalStart = expr.indexOf(InterpolationOpen);
    var internalEnd = expr.lastIndexOf(InterpolationClose);
    var len = expr.trim().length - InterpolationOpen.length - InterpolationClose.length;
    var trimmed = expr.substr(internalStart + InterpolationOpen.length, len).trim();
    return [
        new Lint.Replacement(absolutePosition, internalEnd - internalStart + InterpolationClose.length, InterpolationOpen + " " + trimmed + " " + InterpolationClose)
    ];
};
var InterpolationWhitespaceVisitor = (function (_super) {
    __extends(InterpolationWhitespaceVisitor, _super);
    function InterpolationWhitespaceVisitor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    InterpolationWhitespaceVisitor.prototype.visitBoundText = function (text, context) {
        if (expressionTypes_1.ExpTypes.ASTWithSource(text.value)) {
            var error = null;
            var expr = text.value.source;
            if (InterpolationNoWhitespaceRe.test(expr)) {
                error = "Missing whitespace in interpolation; expecting " + InterpolationOpen + " expr " + InterpolationClose;
            }
            if (InterpolationExtraWhitespaceRe.test(expr)) {
                error = "Extra whitespace in interpolation; expecting " + InterpolationOpen + " expr " + InterpolationClose;
            }
            if (error) {
                var internalStart = expr.indexOf(InterpolationOpen);
                var start = text.sourceSpan.start.offset + internalStart;
                var absolutePosition = context.getSourcePosition(start);
                return context.addFailure(context.createFailure(start, expr.trim().length, error, getReplacements(text, absolutePosition)));
            }
        }
        _super.prototype.visitBoundText.call(this, text, context);
        return null;
    };
    InterpolationWhitespaceVisitor.prototype.getOption = function () {
        return 'check-interpolation';
    };
    return InterpolationWhitespaceVisitor;
}(basicTemplateAstVisitor_1.BasicTemplateAstVisitor));
var WhitespaceTemplateVisitor = (function (_super) {
    __extends(WhitespaceTemplateVisitor, _super);
    function WhitespaceTemplateVisitor() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.visitors = [
            new InterpolationWhitespaceVisitor(_this.getSourceFile(), _this.getOptions(), _this.context, _this.templateStart)
        ];
        return _this;
    }
    WhitespaceTemplateVisitor.prototype.visitBoundText = function (text, context) {
        var _this = this;
        var options = this.getOptions();
        this.visitors
            .filter(function (v) { return options.indexOf(v.getOption()) >= 0; })
            .map(function (v) { return v.visitBoundText(text, _this); })
            .filter(function (f) { return !!f; })
            .forEach(function (f) { return _this.addFailure(f); });
        _super.prototype.visitBoundText.call(this, text, context);
    };
    return WhitespaceTemplateVisitor;
}(basicTemplateAstVisitor_1.BasicTemplateAstVisitor));
var PipeWhitespaceVisitor = (function (_super) {
    __extends(PipeWhitespaceVisitor, _super);
    function PipeWhitespaceVisitor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PipeWhitespaceVisitor.prototype.visitPipe = function (ast, context) {
        var start = ast.span.start;
        var exprStart = context.getSourcePosition(ast.exp.span.start);
        var exprEnd = context.getSourcePosition(ast.exp.span.end);
        var sf = context.getSourceFile().getFullText();
        var exprText = sf.substring(exprStart, exprEnd);
        var replacements = [];
        var leftBeginning = exprEnd + 1;
        if (sf[leftBeginning] === ' ') {
            var ignoreSpace = 1;
            while (sf[leftBeginning + ignoreSpace] === ' ') {
                ignoreSpace += 1;
            }
            if (ignoreSpace > 1) {
                replacements.push(new Lint.Replacement(exprEnd + 1, ignoreSpace, ' '));
            }
        }
        else {
            replacements.push(new Lint.Replacement(exprEnd + 1, 0, ' '));
        }
        if (exprText[exprText.length - 1] === ' ') {
            var ignoreSpace = 1;
            while (exprText[exprText.length - 1 - ignoreSpace] === ' ') {
                ignoreSpace += 1;
            }
            if (ignoreSpace > 1) {
                replacements.push(new Lint.Replacement(exprEnd - ignoreSpace, ignoreSpace, ' '));
            }
        }
        else {
            replacements.push(new Lint.Replacement(exprEnd, 0, ' '));
        }
        if (replacements.length) {
            context.addFailure(context.createFailure(ast.exp.span.end - 1, 3, 'The pipe operator should be surrounded by one space on each side, i.e. " | ".', replacements));
        }
        _super.prototype.visitPipe.call(this, ast, context);
        return null;
    };
    PipeWhitespaceVisitor.prototype.isAsyncBinding = function (expr) {
        return expr instanceof ast.BindingPipe && expr.name === 'async';
    };
    PipeWhitespaceVisitor.prototype.getOption = function () {
        return 'check-pipe';
    };
    return PipeWhitespaceVisitor;
}(recursiveAngularExpressionVisitor_1.RecursiveAngularExpressionVisitor));
var TemplateExpressionVisitor = (function (_super) {
    __extends(TemplateExpressionVisitor, _super);
    function TemplateExpressionVisitor() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.visitors = [
            new PipeWhitespaceVisitor(_this.getSourceFile(), _this.getOptions(), _this.context, _this.basePosition)
        ];
        return _this;
    }
    TemplateExpressionVisitor.prototype.visitPipe = function (expr, context) {
        var _this = this;
        var options = this.getOptions();
        this.visitors
            .filter(function (v) { return options.indexOf(v.getOption()) >= 0; })
            .map(function (v) { return v.visitPipe(expr, _this); })
            .filter(function (f) { return !!f; })
            .forEach(function (f) { return _this.addFailure(f); });
    };
    return TemplateExpressionVisitor;
}(recursiveAngularExpressionVisitor_1.RecursiveAngularExpressionVisitor));
var Rule = (function (_super) {
    __extends(Rule, _super);
    function Rule() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Rule.prototype.apply = function (sourceFile) {
        return this.applyWithWalker(new ngWalker_1.NgWalker(sourceFile, this.getOptions(), {
            templateVisitorCtrl: WhitespaceTemplateVisitor,
            expressionVisitorCtrl: TemplateExpressionVisitor
        }));
    };
    Rule.metadata = {
        ruleName: 'angular-whitespace',
        type: 'style',
        description: "Ensures the proper formatting of Angular expressions.",
        rationale: "Having whitespace in the right places in an Angular expression makes the template more readable.",
        optionsDescription: (_a = ["\n      One argument may be optionally provided:\n      * `\"check-interpolation\"` checks for whitespace before and after the interpolation characters"], _a.raw = ["\n      One argument may be optionally provided:\n      * \\`\"check-interpolation\"\\` checks for whitespace before and after the interpolation characters"], Lint.Utils.dedent(_a)),
        options: {
            type: 'array',
            items: {
                type: 'string',
                enum: ['check-interpolation'],
            },
            minLength: 0,
            maxLength: 1,
        },
        optionExamples: ['[true, "check-interpolation"]'],
        typescriptOnly: true,
    };
    Rule.FAILURE = 'The %s "%s" that you\'re trying to access does not exist in the class declaration.';
    return Rule;
}(Lint.Rules.AbstractRule));
exports.Rule = Rule;
var _a;
