"use strict";

var _chai = require("chai");

var _codemirror = _interopRequireDefault(require("codemirror"));

require("codemirror/addon/runmode/runmode");

require("../mode");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 *  Copyright (c) 2019 GraphQL Contributors
 *  All rights reserved.
 *
 *  This source code is licensed under the BSD-style license found in the
 *  LICENSE file in the root directory of this source tree. An additional grant
 *  of patent rights can be found in the PATENTS file in the same directory.
 */
describe('graphql-results-mode', function () {
  it('provides correct tokens and styles after parsing', function () {
    var queryStr = '{ "data": { "field": "value" }, "errors": [ { "message": "bork" } ] }';
    var tokens = [];

    _codemirror["default"].runMode(queryStr, 'graphql-results', function (token, style) {
      if (style && style !== 'ws') {
        tokens.push([token, style]);
      }
    });

    (0, _chai.expect)(tokens).to.deep.equal([['{', 'punctuation'], ['"data"', 'def'], [':', 'punctuation'], ['{', 'punctuation'], ['"field"', 'property'], [':', 'punctuation'], ['"value"', 'string'], ['}', 'punctuation'], [',', 'punctuation'], ['"errors"', 'def'], [':', 'punctuation'], ['[', 'punctuation'], ['{', 'punctuation'], ['"message"', 'property'], [':', 'punctuation'], ['"bork"', 'string'], ['}', 'punctuation'], [']', 'punctuation'], ['}', 'punctuation']]);
  });
});