"use strict";

var _chai = require("chai");

var _jsonParse = _interopRequireDefault(require("../jsonParse"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 *  Copyright (c) 2019 GraphQL Contributors
 *  All rights reserved.
 *
 *  This source code is licensed under the BSD-style license found in the
 *  LICENSE file in the root directory of this source tree. An additional grant
 *  of patent rights can be found in the PATENTS file in the same directory.
 */
describe('jsonParse', function () {
  function checkEscapedString(str, key, value) {
    var ast = (0, _jsonParse["default"])(str);
    (0, _chai.expect)(ast.kind).to.equal('Object');
    (0, _chai.expect)(ast.members[0].key).to.deep.equal(key);
    (0, _chai.expect)(ast.members[0].value).to.deep.equal(value);
  }

  it('correctly parses escaped strings', function () {
    checkEscapedString('{ "test": "\\"" }', {
      kind: 'String',
      start: 2,
      end: 8,
      value: 'test'
    }, {
      kind: 'String',
      start: 10,
      end: 14,
      value: '"'
    });
    checkEscapedString('{ "test": "\\\\" }', {
      kind: 'String',
      start: 2,
      end: 8,
      value: 'test'
    }, {
      kind: 'String',
      start: 10,
      end: 14,
      value: '\\'
    });
    checkEscapedString('{ "slash": "\\/" }', {
      kind: 'String',
      start: 2,
      end: 9,
      value: 'slash'
    }, {
      kind: 'String',
      start: 11,
      end: 15,
      value: '/'
    });
  });
});