"use strict";

var _chai = require("chai");

var _codemirror = _interopRequireDefault(require("codemirror"));

require("codemirror/addon/hint/show-hint");

var _graphql = require("graphql");

require("../hint");

var _collectVariables = _interopRequireDefault(require("../../utils/collectVariables"));

var _testSchema = require("../../__tests__/testSchema");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function createEditorWithHint(query) {
  return (0, _codemirror["default"])(document.createElement('div'), {
    mode: 'graphql-variables',
    hintOptions: {
      variableToType: query && (0, _collectVariables["default"])(_testSchema.TestSchema, (0, _graphql.parse)(query)),
      closeOnUnfocus: false,
      completeSingle: false
    }
  });
}

function getHintSuggestions(query, variables, cursor) {
  var editor = createEditorWithHint(query);
  return new Promise(function (resolve) {
    var graphqlVariablesHint = _codemirror["default"].hint['graphql-variables'];

    _codemirror["default"].hint['graphql-variables'] = function (cm, options) {
      var result = graphqlVariablesHint(cm, options);
      resolve(result);
      _codemirror["default"].hint['graphql-variables'] = graphqlVariablesHint;
      return result;
    };

    editor.doc.setValue(variables);
    editor.doc.setCursor(cursor);
    editor.execCommand('autocomplete');
  });
}

function checkSuggestions(source, suggestions) {
  var titles = suggestions.map(function (suggestion) {
    return suggestion.text;
  });
  (0, _chai.expect)(titles).to.deep.equal(source);
}

describe('graphql-variables-hint', function () {
  it('attaches a GraphQL hint function with correct mode/hint options',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee() {
    var editor;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return createEditorWithHint('{ f }');

          case 2:
            editor = _context.sent;
            (0, _chai.expect)(editor.getHelpers(editor.getCursor(), 'hint')).to.not.have.lengthOf(0);

          case 4:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));
  it('provides correct initial token',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee2() {
    var suggestions, initialKeywords;
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return getHintSuggestions('', '', {
              line: 0,
              ch: 0
            });

          case 2:
            suggestions = _context2.sent;
            initialKeywords = ['{'];
            checkSuggestions(initialKeywords, suggestions.list);

          case 5:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  })));
  it('provides correct field name suggestions',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee3() {
    var suggestions;
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return getHintSuggestions('query ($foo: String!, $bar: Int) { f }', '{ ', {
              line: 0,
              ch: 2
            });

          case 2:
            suggestions = _context3.sent;
            checkSuggestions(['"foo": ', '"bar": '], suggestions.list);

          case 4:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  })));
  it('provides correct variable suggestion indentation',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee4() {
    var suggestions;
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return getHintSuggestions('query ($foo: String!, $bar: Int) { f }', '{\n  ', {
              line: 1,
              ch: 2
            });

          case 2:
            suggestions = _context4.sent;
            (0, _chai.expect)(suggestions.from).to.deep.equal({
              line: 1,
              ch: 2,
              sticky: null
            });
            (0, _chai.expect)(suggestions.to).to.deep.equal({
              line: 1,
              ch: 2,
              sticky: null
            });

          case 5:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  })));
  it('provides correct variable completion',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee5() {
    var suggestions;
    return regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return getHintSuggestions('query ($foo: String!, $bar: Int) { f }', '{\n  ba', {
              line: 1,
              ch: 4
            });

          case 2:
            suggestions = _context5.sent;
            checkSuggestions(['"bar": '], suggestions.list);
            (0, _chai.expect)(suggestions.from).to.deep.equal({
              line: 1,
              ch: 2,
              sticky: null
            });
            (0, _chai.expect)(suggestions.to).to.deep.equal({
              line: 1,
              ch: 4,
              sticky: null
            });

          case 6:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  })));
  it('provides correct variable completion with open quote',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee6() {
    var suggestions;
    return regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            _context6.next = 2;
            return getHintSuggestions('query ($foo: String!, $bar: Int) { f }', '{\n  "', {
              line: 1,
              ch: 4
            });

          case 2:
            suggestions = _context6.sent;
            checkSuggestions(['"foo": ', '"bar": '], suggestions.list);
            (0, _chai.expect)(suggestions.from).to.deep.equal({
              line: 1,
              ch: 2,
              sticky: null
            });
            (0, _chai.expect)(suggestions.to).to.deep.equal({
              line: 1,
              ch: 3,
              sticky: null
            });

          case 6:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6);
  })));
  it('provides correct Enum suggestions',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee7() {
    var suggestions, TestEnum;
    return regeneratorRuntime.wrap(function _callee7$(_context7) {
      while (1) {
        switch (_context7.prev = _context7.next) {
          case 0:
            _context7.next = 2;
            return getHintSuggestions('query ($myEnum: TestEnum) { f }', '{\n  "myEnum": ', {
              line: 1,
              ch: 12
            });

          case 2:
            suggestions = _context7.sent;
            TestEnum = _testSchema.TestSchema.getType('TestEnum');
            checkSuggestions(TestEnum.getValues().map(function (value) {
              return "\"".concat(value.name, "\"");
            }), suggestions.list);

          case 5:
          case "end":
            return _context7.stop();
        }
      }
    }, _callee7);
  })));
  it('suggests to open an Input Object',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee8() {
    var suggestions;
    return regeneratorRuntime.wrap(function _callee8$(_context8) {
      while (1) {
        switch (_context8.prev = _context8.next) {
          case 0:
            _context8.next = 2;
            return getHintSuggestions('query ($myInput: TestInput) { f }', '{\n  "myInput": ', {
              line: 1,
              ch: 13
            });

          case 2:
            suggestions = _context8.sent;
            checkSuggestions(['{'], suggestions.list);

          case 4:
          case "end":
            return _context8.stop();
        }
      }
    }, _callee8);
  })));
  it('provides Input Object fields',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee9() {
    var suggestions, TestInput;
    return regeneratorRuntime.wrap(function _callee9$(_context9) {
      while (1) {
        switch (_context9.prev = _context9.next) {
          case 0:
            _context9.next = 2;
            return getHintSuggestions('query ($myInput: TestInput) { f }', '{\n  "myInput": {\n    ', {
              line: 2,
              ch: 4
            });

          case 2:
            suggestions = _context9.sent;
            TestInput = _testSchema.TestSchema.getType('TestInput');
            checkSuggestions(Object.keys(TestInput.getFields()).map(function (name) {
              return "\"".concat(name, "\": ");
            }), suggestions.list);
            (0, _chai.expect)(suggestions.from).to.deep.equal({
              line: 2,
              ch: 4,
              sticky: null
            });
            (0, _chai.expect)(suggestions.to).to.deep.equal({
              line: 2,
              ch: 4,
              sticky: null
            });

          case 7:
          case "end":
            return _context9.stop();
        }
      }
    }, _callee9);
  })));
  it('provides correct Input Object field completion',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee10() {
    var suggestions;
    return regeneratorRuntime.wrap(function _callee10$(_context10) {
      while (1) {
        switch (_context10.prev = _context10.next) {
          case 0:
            _context10.next = 2;
            return getHintSuggestions('query ($myInput: TestInput) { f }', '{\n  "myInput": {\n    bool', {
              line: 2,
              ch: 8
            });

          case 2:
            suggestions = _context10.sent;
            checkSuggestions(['"boolean": ', '"listBoolean": '], suggestions.list);
            (0, _chai.expect)(suggestions.from).to.deep.equal({
              line: 2,
              ch: 4,
              sticky: null
            });
            (0, _chai.expect)(suggestions.to).to.deep.equal({
              line: 2,
              ch: 8,
              sticky: null
            });

          case 6:
          case "end":
            return _context10.stop();
        }
      }
    }, _callee10);
  })));
  it('provides correct Input Object field value completion',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee11() {
    var suggestions;
    return regeneratorRuntime.wrap(function _callee11$(_context11) {
      while (1) {
        switch (_context11.prev = _context11.next) {
          case 0:
            _context11.next = 2;
            return getHintSuggestions('query ($myInput: TestInput) { f }', '{\n  "myInput": {\n    "boolean": ', {
              line: 2,
              ch: 15
            });

          case 2:
            suggestions = _context11.sent;
            checkSuggestions(['true', 'false'], suggestions.list);

          case 4:
          case "end":
            return _context11.stop();
        }
      }
    }, _callee11);
  })));
});