"use strict";

var _chai = require("chai");

var _codemirror = _interopRequireDefault(require("codemirror"));

require("codemirror/addon/lint/lint");

var _graphql = require("graphql");

require("../lint");

var _collectVariables = _interopRequireDefault(require("../../utils/collectVariables"));

var _testSchema = require("../../__tests__/testSchema");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function createEditorWithLint(lintConfig) {
  return (0, _codemirror["default"])(document.createElement('div'), {
    mode: 'graphql-variables',
    lint: lintConfig ? lintConfig : true
  });
}

function printLintErrors(query, variables) {
  var editor = createEditorWithLint({
    variableToType: query && (0, _collectVariables["default"])(_testSchema.TestSchema, (0, _graphql.parse)(query))
  });
  return new Promise(function (resolve) {
    editor.state.lint.options.onUpdateLinting = function (errors) {
      if (errors && errors[0]) {
        if (!errors[0].message.match('Unexpected EOF')) {
          resolve(errors);
        }
      }

      resolve([]);
    };

    editor.doc.setValue(variables);
  });
}

describe('graphql-variables-lint', function () {
  it('attaches a GraphQL lint function with correct mode/lint options', function () {
    var editor = createEditorWithLint();
    (0, _chai.expect)(editor.getHelpers(editor.getCursor(), 'lint')).to.not.have.lengthOf(0);
  });
  it('catches syntax errors',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee() {
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.t0 = _chai.expect;
            _context.next = 3;
            return printLintErrors(null, '{ foo: "bar" }');

          case 3:
            _context.t1 = _context.sent[0].message;
            (0, _context.t0)(_context.t1).to.equal('Expected String but found `foo`.');

          case 5:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));
  it('catches type validation errors',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee2() {
    var errors;
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return printLintErrors('query ($foo: Int) { f }', ' { "foo": "NaN" }');

          case 2:
            errors = _context2.sent;
            (0, _chai.expect)(errors[0]).to.deep.equal({
              message: 'Expected value of type "Int".',
              severity: 'error',
              type: 'validation',
              from: {
                line: 0,
                ch: 10,
                sticky: null
              },
              to: {
                line: 0,
                ch: 15,
                sticky: null
              }
            });

          case 4:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  })));
  it('reports unknown variable names',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee3() {
    var errors;
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return printLintErrors('query ($foo: Int) { f }', ' { "food": "NaN" }');

          case 2:
            errors = _context3.sent;
            (0, _chai.expect)(errors[0]).to.deep.equal({
              message: 'Variable "$food" does not appear in any GraphQL query.',
              severity: 'error',
              type: 'validation',
              from: {
                line: 0,
                ch: 3,
                sticky: null
              },
              to: {
                line: 0,
                ch: 9,
                sticky: null
              }
            });

          case 4:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  })));
  it('reports nothing when not configured',
  /*#__PURE__*/
  _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee4() {
    var errors;
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return printLintErrors(null, ' { "foo": "NaN" }');

          case 2:
            errors = _context4.sent;
            (0, _chai.expect)(errors.length).to.equal(0);

          case 4:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  })));
});