"use strict";

var _chai = require("chai");

var _codemirror = _interopRequireDefault(require("codemirror"));

require("codemirror/addon/runmode/runmode");

require("../mode");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 *  Copyright (c) 2019 GraphQL Contributors
 *  All rights reserved.
 *
 *  This source code is licensed under the BSD-style license found in the
 *  LICENSE file in the root directory of this source tree. An additional grant
 *  of patent rights can be found in the PATENTS file in the same directory.
 */
describe('graphql-variables-mode', function () {
  it('provides correct tokens and styles after parsing', function () {
    var queryStr = '{ "variable": { "field": "value" }, "list": [ 1, true, null ] }';
    var tokens = [];

    _codemirror["default"].runMode(queryStr, 'graphql-variables', function (token, style) {
      if (style && style !== 'ws') {
        tokens.push([token, style]);
      }
    });

    (0, _chai.expect)(tokens).to.deep.equal([['{', 'punctuation'], ['"variable"', 'variable'], [':', 'punctuation'], ['{', 'punctuation'], ['"field"', 'attribute'], [':', 'punctuation'], ['"value"', 'string'], ['}', 'punctuation'], [',', 'punctuation'], ['"list"', 'variable'], [':', 'punctuation'], ['[', 'punctuation'], ['1', 'number'], [',', 'punctuation'], ['true', 'builtin'], [',', 'punctuation'], ['null', 'keyword'], [']', 'punctuation'], ['}', 'punctuation']]);
  });
  it('is resilient to missing commas', function () {
    var queryStr = '{ "variable": { "field": "value" } "list": [ 1 true null ] }';
    var tokens = [];

    _codemirror["default"].runMode(queryStr, 'graphql-variables', function (token, style) {
      if (style && style !== 'ws') {
        tokens.push([token, style]);
      }
    });

    (0, _chai.expect)(tokens).to.deep.equal([['{', 'punctuation'], ['"variable"', 'variable'], [':', 'punctuation'], ['{', 'punctuation'], ['"field"', 'attribute'], [':', 'punctuation'], ['"value"', 'string'], ['}', 'punctuation'], ['"list"', 'variable'], [':', 'punctuation'], ['[', 'punctuation'], ['1', 'number'], ['true', 'builtin'], ['null', 'keyword'], [']', 'punctuation'], ['}', 'punctuation']]);
  });
  it('returns "invalidchar" message when there is no matching token', function () {
    _codemirror["default"].runMode('herp derp', 'graphql-variables', function (token, style) {
      if (token.trim()) {
        (0, _chai.expect)(style).to.equal('invalidchar');
      }
    });

    _codemirror["default"].runMode('{ foo', 'graphql-variables', function (token, style) {
      if (token === 'foo') {
        (0, _chai.expect)(style).to.equal('invalidchar');
      }
    });
  });
});