"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = runParser;

var _graphqlLanguageServiceParser = require("graphql-language-service-parser");

/**
 *  Copyright (c) 2019 GraphQL Contributors
 *  All rights reserved.
 *
 *  This source code is licensed under the BSD-style license found in the
 *  LICENSE file in the root directory of this source tree. An additional grant
 *  of patent rights can be found in the PATENTS file in the same directory.
 */
function runParser(sourceText, parserOptions, callbackFn) {
  const parser = (0, _graphqlLanguageServiceParser.onlineParser)(parserOptions);
  const state = parser.startState();
  const lines = sourceText.split('\n');
  lines.forEach(line => {
    const stream = new _graphqlLanguageServiceParser.CharacterStream(line);

    while (!stream.eol()) {
      const style = parser.token(stream, state);
      callbackFn(stream, state, style);
    }
  });
}