/**
 *  Copyright (c) 2020 GraphQL Contributors
 *  All rights reserved.
 *
 *  This source code is licensed under the BSD-style license found in the
 *  LICENSE file in the root directory of this source tree. An additional grant
 *  of patent rights can be found in the PATENTS file in the same directory.
 */
// Utility for iterating through a CodeMirror parse state stack bottom-up.
export default function forEachState(stack, fn) {
  const reverseStateStack = [];
  let state = stack;

  while (state && state.kind) {
    reverseStateStack.push(state);
    state = state.prevState;
  }

  for (let i = reverseStateStack.length - 1; i >= 0; i--) {
    fn(reverseStateStack[i]);
  }
}