"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getTokenAtPosition;


/**
 * Provides an utility function to construct a `token` context object.
 * A token context provides useful information about the token/style
 * that CharacterStream currently possesses.
 *
 * Options:
 *   - stream: CharacterStream.
 *   - state: A state object from onlineParser.
 *   - style: A style string obtained by running `token` function from
 *     onlineParser.
 */

function getTokenAtPosition(stream, // : CharacterStream
state, style) {
  return {
    start: stream.getStartOfToken(),
    end: stream.getCurrentPosition(),
    string: stream.current(),
    state: state,
    style: style
  };
} /**
   *  Copyright (c) 2015, Facebook, Inc.
   *  All rights reserved.
   *
   *  This source code is licensed under the BSD-style license found in the
   *  LICENSE file in the root directory of this source tree. An additional grant
   *  of patent rights can be found in the PATENTS file in the same directory.
   */