"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var graphql_1 = require("graphql");
function collectVariables(schema, documentAST) {
    var variableToType = Object.create(null);
    documentAST.definitions.forEach(function (definition) {
        if (definition.kind === 'OperationDefinition') {
            var variableDefinitions = definition.variableDefinitions;
            if (variableDefinitions) {
                variableDefinitions.forEach(function (_a) {
                    var variable = _a.variable, type = _a.type;
                    var inputType = graphql_1.typeFromAST(schema, type);
                    if (inputType) {
                        variableToType[variable.name.value] = inputType;
                    }
                });
            }
        }
    });
    return variableToType;
}
exports.default = collectVariables;
//# sourceMappingURL=collectVariables.js.map