"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var codemirror_1 = __importDefault(require("codemirror"));
var graphql_language_service_parser_1 = require("graphql-language-service-parser");
codemirror_1.default.defineMode('graphql', function (config) {
    var parser = graphql_language_service_parser_1.onlineParser({
        eatWhitespace: function (stream) { return stream.eatWhile(graphql_language_service_parser_1.isIgnored); },
        lexRules: graphql_language_service_parser_1.LexRules,
        parseRules: graphql_language_service_parser_1.ParseRules,
        editorConfig: { tabSize: config.tabSize },
    });
    return {
        config: config,
        startState: parser.startState,
        token: parser.token,
        indent: indent,
        electricInput: /^\s*[})\]]/,
        fold: 'brace',
        lineComment: '#',
        closeBrackets: {
            pairs: '()[]{}""',
            explode: '()[]{}',
        },
    };
});
function indent(state, textAfter) {
    var _a, _b;
    var levels = state.levels;
    var level = !levels || levels.length === 0
        ? state.indentLevel
        : levels[levels.length - 1] -
            (((_a = this.electricInput) === null || _a === void 0 ? void 0 : _a.test(textAfter)) ? 1 : 0);
    return (level || 0) * (((_b = this.config) === null || _b === void 0 ? void 0 : _b.indentUnit) || 0);
}
//# sourceMappingURL=mode.js.map