"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var graphql_language_service_parser_1 = require("graphql-language-service-parser");
function runParser(sourceText, parserOptions, callbackFn) {
    var parser = graphql_language_service_parser_1.onlineParser(parserOptions);
    var state = parser.startState();
    var lines = sourceText.split('\n');
    lines.forEach(function (line) {
        var stream = new graphql_language_service_parser_1.CharacterStream(line);
        while (!stream.eol()) {
            var style = parser.token(stream, state);
            callbackFn(stream, state, style);
        }
    });
}
exports.default = runParser;
//# sourceMappingURL=runParser.js.map