"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var codemirror_1 = __importDefault(require("codemirror"));
var getTypeInfo_1 = __importDefault(require("./utils/getTypeInfo"));
var SchemaReference_1 = require("./utils/SchemaReference");
require("./utils/jump-addon");
codemirror_1.default.registerHelper('jump', 'graphql', function (token, options) {
    if (!options.schema || !options.onClick || !token.state) {
        return;
    }
    var state = token.state;
    var kind = state.kind;
    var step = state.step;
    var typeInfo = getTypeInfo_1.default(options.schema, state);
    if ((kind === 'Field' && step === 0 && typeInfo.fieldDef) ||
        (kind === 'AliasedField' && step === 2 && typeInfo.fieldDef)) {
        return SchemaReference_1.getFieldReference(typeInfo);
    }
    else if (kind === 'Directive' && step === 1 && typeInfo.directiveDef) {
        return SchemaReference_1.getDirectiveReference(typeInfo);
    }
    else if (kind === 'Argument' && step === 0 && typeInfo.argDef) {
        return SchemaReference_1.getArgumentReference(typeInfo);
    }
    else if (kind === 'EnumValue' && typeInfo.enumValue) {
        return SchemaReference_1.getEnumValueReference(typeInfo);
    }
    else if (kind === 'NamedType' && typeInfo.type) {
        return SchemaReference_1.getTypeReference(typeInfo);
    }
});
//# sourceMappingURL=jump.js.map