import { typeFromAST, } from 'graphql';
export default function collectVariables(schema, documentAST) {
    const variableToType = Object.create(null);
    documentAST.definitions.forEach(definition => {
        if (definition.kind === 'OperationDefinition') {
            const variableDefinitions = definition.variableDefinitions;
            if (variableDefinitions) {
                variableDefinitions.forEach(({ variable, type }) => {
                    const inputType = typeFromAST(schema, type);
                    if (inputType) {
                        variableToType[variable.name.value] = inputType;
                    }
                });
            }
        }
    });
    return variableToType;
}
//# sourceMappingURL=collectVariables.js.map