'use strict';

var language = require('@codemirror/language');
var langHtml = require('@codemirror/lang-html');
var langJavascript = require('@codemirror/lang-javascript');
var highlight = require('@lezer/highlight');
var common = require('@lezer/common');
var lr = require('@lezer/lr');

// This file was generated by lezer-generator. You probably shouldn't edit it.
const Text = 1,
  attributeContentSingle = 33,
  attributeContentDouble = 34,
  scriptAttributeContentSingle = 35,
  scriptAttributeContentDouble = 36;

const text = new lr.ExternalTokenizer(input => {
    let start = input.pos;
    for (;;) {
        if (input.next == 10 /* Ch.Newline */) {
            input.advance();
            break;
        }
        else if (input.next == 123 /* Ch.BraceL */ && input.peek(1) == 123 /* Ch.BraceL */ || input.next < 0) {
            break;
        }
        input.advance();
    }
    if (input.pos > start)
        input.acceptToken(Text);
});
function attrContent(quote, token, script) {
    return new lr.ExternalTokenizer(input => {
        let start = input.pos;
        while (input.next != quote && input.next >= 0 &&
            (script || input.next != 38 /* Ch.Ampersand */ && (input.next != 123 /* Ch.BraceL */ || input.peek(1) != 123 /* Ch.BraceL */)))
            input.advance();
        if (input.pos > start)
            input.acceptToken(token);
    });
}
const attrSingle = attrContent(39 /* Ch.SingleQuote */, attributeContentSingle, false);
const attrDouble = attrContent(34 /* Ch.DoubleQuote */, attributeContentDouble, false);
const scriptAttrSingle = attrContent(39 /* Ch.SingleQuote */, scriptAttributeContentSingle, true);
const scriptAttrDouble = attrContent(34 /* Ch.DoubleQuote */, scriptAttributeContentDouble, true);

// This file was generated by lezer-generator. You probably shouldn't edit it.
const parser = lr.LRParser.deserialize({
  version: 14,
  states: "(jOVOqOOOeQpOOOvO!bO'#CaOOOP'#Cx'#CxQVOqOOO!OQpO'#CfO!WQpO'#ClO!]QpO'#CrO!bQpO'#CsOOQO'#Cv'#CvQ!gQpOOQ!lQpOOQ!qQpOOOOOV,58{,58{O!vOpO,58{OOOP-E6v-E6vO!{QpO,59QO#TQpO,59QOOQO,59W,59WO#YQpO,59^OOQO,59_,59_O#_QpOOO#_QpOOO#gQpOOOOOV1G.g1G.gO#oQpO'#CyO#tQpO1G.lOOQO1G.l1G.lO#|QpO1G.lOOQO1G.x1G.xO$UO`O'#DUO$ZOWO'#DUOOQO'#Co'#CoQOQpOOOOQO'#Cu'#CuO$`OtO'#CwO$qOrO'#CwOOQO,59e,59eOOQO-E6w-E6wOOQO7+$W7+$WO%SQpO7+$WO%[QpO7+$WOOOO'#Cp'#CpO%aOpO,59pOOOO'#Cq'#CqO%fOpO,59pOOOS'#Cz'#CzO%kOtO,59cOOQO,59c,59cOOOQ'#C{'#C{O%|OrO,59cO&_QpO<<GrOOQO<<Gr<<GrOOQO1G/[1G/[OOOS-E6x-E6xOOQO1G.}1G.}OOOQ-E6y-E6yOOQOAN=^AN=^",
  stateData: "&d~OvOS~OPROSQOVROWRO~OZTO[XO^VOaUOhWO~OR]OU^O~O[`O^aO~O[bO~O[cO~O[dO~ObeO~ObfO~ObgO~ORhO~O]kOwiO~O[lO~O_mO~OynOzoO~OysOztO~O[uO~O]wOwiO~O_yOwiO~OtzO~Os|O~OSQOV!OOW!OOr!OOy!QO~OSQOV!ROW!ROq!ROz!QO~O_!TOwiO~O]!UO~Oy!VO~Oz!VO~OSQOV!OOW!OOr!OOy!XO~OSQOV!ROW!ROq!ROz!XO~O]!ZO~O",
  goto: "#dyPPPPPzPPPP!WPPPPP!WPP!Z!^!a!d!dP!g!j!m!p!v#Q#WPPPPPPPP#^SROSS!Os!PT!Rt!SRYPRqeR{nR}oRZPRqfR[PRqgQSOR_SQj`SvjxRxlQ!PsR!W!PQ!StR!Y!SQpeRrf",
  nodeNames: "⚠ Text Content }} {{ Interpolation InterpolationContent Entity InvalidEntity Attribute BoundAttributeName [ Identifier ] ( ) ReferenceName # Is ExpressionAttributeValue AttributeInterpolation AttributeInterpolation EventName DirectiveName * StatementAttributeValue AttributeName AttributeValue",
  maxTerm: 42,
  nodeProps: [
    ["openedBy", 3,"{{",15,"("],
    ["closedBy", 4,"}}",14,")"],
    ["isolate", -4,5,19,25,27,""]
  ],
  skippedNodes: [0],
  repeatNodeCount: 4,
  tokenData: "0r~RyOX#rXY$mYZ$mZ]#r]^$m^p#rpq$mqr#rrs%jst&Qtv#rvw&hwx)zxy*byz*xz{+`{}#r}!O+v!O!P-]!P!Q#r!Q![+v![!]+v!]!_#r!_!`-s!`!c#r!c!}+v!}#O.Z#O#P#r#P#Q.q#Q#R#r#R#S+v#S#T#r#T#o+v#o#p/X#p#q#r#q#r0Z#r%W#r%W;'S+v;'S;:j-V;:j;=`$g<%lO+vQ#wTUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rQ$ZSO#q#r#r;'S#r;'S;=`$g<%lO#rQ$jP;=`<%l#rR$t[UQvPOX#rXY$mYZ$mZ]#r]^$m^p#rpq$mq#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR%qTyPUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR&XTaPUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR&oXUQWPOp'[pq#rq!]'[!]!^#r!^#q'[#q#r(d#r;'S'[;'S;=`)t<%lO'[R'aXUQOp'[pq#rq!]'[!]!^'|!^#q'[#q#r(d#r;'S'[;'S;=`)t<%lO'[R(TTVPUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR(gXOp'[pq#rq!]'[!]!^'|!^#q'[#q#r)S#r;'S'[;'S;=`)t<%lO'[P)VUOp)Sq!])S!]!^)i!^;'S)S;'S;=`)n<%lO)SP)nOVPP)qP;=`<%l)SR)wP;=`<%l'[R*RTzPUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR*iT^PUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR+PT_PUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR+gThPUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR+}b[PUQO}#r}!O+v!O!Q#r!Q![+v![!]+v!]!c#r!c!}+v!}#R#r#R#S+v#S#T#r#T#o+v#o#q#r#q#r$W#r%W#r%W;'S+v;'S;:j-V;:j;=`$g<%lO+vR-YP;=`<%l+vR-dTwPUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR-zTUQbPO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR.bTZPUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR.xT]PUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR/^VUQO#o#r#o#p/s#p#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#rR/zTSPUQO#q#r#q#r$W#r;'S#r;'S;=`$g<%lO#r~0^TO#q#r#q#r0m#r;'S#r;'S;=`$g<%lO#r~0rOR~",
  tokenizers: [text, attrSingle, attrDouble, scriptAttrSingle, scriptAttrDouble, 0, 1],
  topRules: {"Content":[0,2],"Attribute":[1,9]},
  tokenPrec: 0
});

const exprParser = langJavascript.javascriptLanguage.parser.configure({
    top: "SingleExpression"
});
const baseParser = parser.configure({
    props: [
        highlight.styleTags({
            Text: highlight.tags.content,
            Is: highlight.tags.definitionOperator,
            AttributeName: highlight.tags.attributeName,
            "AttributeValue ExpressionAttributeValue StatementAttributeValue": highlight.tags.attributeValue,
            Entity: highlight.tags.character,
            InvalidEntity: highlight.tags.invalid,
            "BoundAttributeName/Identifier": highlight.tags.attributeName,
            "EventName/Identifier": highlight.tags.special(highlight.tags.attributeName),
            "ReferenceName/Identifier": highlight.tags.variableName,
            "DirectiveName/Identifier": highlight.tags.keyword,
            "{{ }}": highlight.tags.brace,
            "( )": highlight.tags.paren,
            "[ ]": highlight.tags.bracket,
            "# '*'": highlight.tags.punctuation
        })
    ]
});
const exprMixed = { parser: exprParser }, statementMixed = { parser: langJavascript.javascriptLanguage.parser };
const textParser = baseParser.configure({
    wrap: common.parseMixed((node, input) => node.name == "InterpolationContent" ? exprMixed : null),
});
const attrParser = baseParser.configure({
    wrap: common.parseMixed((node, input) => {
        var _a;
        return node.name == "InterpolationContent" ? exprMixed
            : node.name != "AttributeInterpolation" ? null
                : ((_a = node.node.parent) === null || _a === void 0 ? void 0 : _a.name) == "StatementAttributeValue" ? statementMixed : exprMixed;
    }),
    top: "Attribute"
});
const textMixed = { parser: textParser }, attrMixed = { parser: attrParser };
const baseHTML = langHtml.html();
function mkAngular(language) {
    return language.configure({ wrap: common.parseMixed(mixAngular) }, "angular");
}
/**
A language provider for Angular Templates.
*/
const angularLanguage = mkAngular(baseHTML.language);
function mixAngular(node, input) {
    switch (node.name) {
        case "Attribute":
            return /^[*#(\[]|\{\{/.test(input.read(node.from, node.to)) ? attrMixed : null;
        case "Text":
            return textMixed;
    }
    return null;
}
/**
Angular Template language support.
*/
function angular(config = {}) {
    let base = baseHTML;
    if (config.base) {
        if (config.base.language.name != "html" || !(config.base.language instanceof language.LRLanguage))
            throw new RangeError("The base option must be the result of calling html(...)");
        base = config.base;
    }
    return new language.LanguageSupport(base.language == baseHTML.language ? angularLanguage : mkAngular(base.language), [base.support, base.language.data.of({
            closeBrackets: { brackets: ["[", "{", '"'] },
            indentOnInput: /^\s*[\}\]]$/
        })]);
}

exports.angular = angular;
exports.angularLanguage = angularLanguage;
