import * as vue from 'vue';
import { DirectiveBinding, VNode } from 'vue';

type Input = number | string;
interface Options$1 {
    prefix: string;
    suffix: string;
    separator: string;
    decimal: string;
    precision: number;
    minimumFractionDigits: number;
    prefill: boolean;
    reverseFill: boolean;
    min?: number;
    max?: number;
    nullValue: string;
}
interface CustomInputElement extends HTMLInputElement {
    options: Options$1;
    masked?: Input;
    unmasked?: Input;
    oldValue?: Input;
    cleanup: () => void;
}

declare const _default$2: vue.DefineComponent<{
    modelValue: {
        type: (StringConstructor | NumberConstructor)[];
        required: true;
    };
    nullValue: {
        type: (StringConstructor | NumberConstructor)[];
        default: any;
    };
    masked: BooleanConstructor;
    readonly: BooleanConstructor;
    disabled: BooleanConstructor;
    reverseFill: {
        type: BooleanConstructor;
        default: any;
    };
    prefill: {
        type: BooleanConstructor;
        default: any;
    };
    precision: {
        type: NumberConstructor;
        default: () => any;
    };
    minimumFractionDigits: {
        type: NumberConstructor;
        default: () => any;
    };
    decimal: {
        type: StringConstructor;
        default: () => any;
    };
    min: {
        type: NumberConstructor;
        default: () => any;
    };
    max: {
        type: NumberConstructor;
        default: () => any;
    };
    separator: {
        type: StringConstructor;
        default: () => any;
    };
    prefix: {
        type: StringConstructor;
        default: () => any;
    };
    suffix: {
        type: StringConstructor;
        default: () => any;
    };
    inputmode: {
        type: StringConstructor;
        default: () => any;
    };
}, {
    config: vue.ComputedRef<{
        modelValue: string | number;
        masked: boolean;
        readonly: boolean;
        disabled: boolean;
        nullValue: string | number | undefined;
        reverseFill: boolean | undefined;
        prefill: boolean | undefined;
        precision: number | undefined;
        minimumFractionDigits: number | undefined;
        decimal: string | undefined;
        min: number | undefined;
        max: number | undefined;
        separator: string | undefined;
        prefix: string | undefined;
        suffix: string | undefined;
        inputmode: string | undefined;
        "onUpdate:model-value": ((...args: any[]) => any) | undefined;
        "onInput:model-value": ((...args: any[]) => any) | undefined;
    }>;
    maskedValue: vue.Ref<string | number>;
    unmaskedValue: vue.Ref<Input | undefined>;
    input: (event: Event) => void;
    blur: () => void;
    change: () => void;
}, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, ("update:model-value" | "input:model-value")[], "update:model-value" | "input:model-value", vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps, Readonly<vue.ExtractPropTypes<{
    modelValue: {
        type: (StringConstructor | NumberConstructor)[];
        required: true;
    };
    nullValue: {
        type: (StringConstructor | NumberConstructor)[];
        default: any;
    };
    masked: BooleanConstructor;
    readonly: BooleanConstructor;
    disabled: BooleanConstructor;
    reverseFill: {
        type: BooleanConstructor;
        default: any;
    };
    prefill: {
        type: BooleanConstructor;
        default: any;
    };
    precision: {
        type: NumberConstructor;
        default: () => any;
    };
    minimumFractionDigits: {
        type: NumberConstructor;
        default: () => any;
    };
    decimal: {
        type: StringConstructor;
        default: () => any;
    };
    min: {
        type: NumberConstructor;
        default: () => any;
    };
    max: {
        type: NumberConstructor;
        default: () => any;
    };
    separator: {
        type: StringConstructor;
        default: () => any;
    };
    prefix: {
        type: StringConstructor;
        default: () => any;
    };
    suffix: {
        type: StringConstructor;
        default: () => any;
    };
    inputmode: {
        type: StringConstructor;
        default: () => any;
    };
}>> & {
    "onUpdate:model-value"?: ((...args: any[]) => any) | undefined;
    "onInput:model-value"?: ((...args: any[]) => any) | undefined;
}, {
    nullValue: string | number;
    masked: boolean;
    readonly: boolean;
    disabled: boolean;
    reverseFill: boolean;
    prefill: boolean;
    precision: number;
    minimumFractionDigits: number;
    decimal: string;
    min: number;
    max: number;
    separator: string;
    prefix: string;
    suffix: string;
    inputmode: string;
}>;

declare const _default$1: {
    beforeMount: (el: CustomInputElement, { value, modifiers }: DirectiveBinding, vnode: VNode) => void;
    mounted: (el: CustomInputElement) => void;
    updated: (el: CustomInputElement, { value, oldValue, modifiers }: DirectiveBinding, vnode: VNode) => void;
    unmounted: (el: CustomInputElement) => void;
};

interface Options {
    prefix?: string;
    suffix?: string;
    separator?: string;
    decimal?: string;
    inputmode?: string;
    precision?: number;
    minimumFractionDigits?: number;
    prefill?: boolean;
    reverseFill?: boolean;
    min?: number;
    max?: number;
    nullValue?: string;
}
declare const _default: {
    prefix: string;
    suffix: string;
    separator: string;
    decimal: string;
    inputmode: string;
    precision: number;
    minimumFractionDigits: null;
    prefill: boolean;
    reverseFill: boolean;
    min: null;
    max: null;
    nullValue: string;
};

interface Config {
    prefix: string;
    suffix: string;
    separator: string;
    decimal: string;
    precision: number;
    minimumFractionDigits: number;
    prefill: boolean;
    reverseFill: boolean;
    min: number;
    max: number;
    nullValue: string;
}
/**
 * Number format class
 * @param {Options} config
 */
declare class NumberFormat {
    options: Config;
    input: Input;
    number: Input;
    isClean: boolean;
    isCustomDecimal: boolean;
    noPreSuffix: boolean;
    hasPreOrSuffix: boolean;
    prefix: string;
    preSufRegExp?: RegExp;
    prefixRegExp?: RegExp;
    suffixRegExp?: RegExp;
    numberRegExp: RegExp;
    cleanRegExp: RegExp;
    negativeRegExp: RegExp;
    constructor(config?: Options);
    isNull(): boolean;
    clean(clean?: boolean): this;
    sign(): "" | "-";
    toFixed(): string;
    toNumber(str: Input): number;
    numberOnly(regExp?: RegExp): string;
    inputWithPreOrSuffix(): boolean;
    isNegative(): boolean;
    isNumber(val?: any): boolean;
    numbers(): string;
    unformatNumber(): string;
    realNumber(): number;
    parts(num: Input, separator?: string): Input[];
    addSeparator(): string;
    /**
     * Format the input with default config if there is no constructor config
     * @param {Input} input
     * @return {String}
     */
    format(input: Input): string;
    /**
     * Unformat the input with default config if there is no constructor config
     * @param {Input} input
     * @return {String}
     */
    unformat(input: Input): string;
}

declare const VueNumberFormat: {
    install(app: any, config?: Options): void;
};

export { NumberFormat, _default$2 as component, VueNumberFormat as default, _default$1 as directive, _default as options };
