// Generated by CoffeeScript 1.7.0
(function() {
  var CoffeeScript, addHistory, addMultilineHandler, fs, merge, nodeREPL, path, replDefaults, updateSyntaxError, vm, _ref;

  fs = require('fs');

  path = require('path');

  vm = require('vm');

  nodeREPL = require('repl');

  CoffeeScript = require('./coffee-script');

  _ref = require('./helpers'), merge = _ref.merge, updateSyntaxError = _ref.updateSyntaxError;

  replDefaults = {
    prompt: 'coffee> ',
    historyFile: process.env.HOME ? path.join(process.env.HOME, '.coffee_history') : void 0,
    historyMaxInputSize: 10240,
    "eval": function(input, context, filename, cb) {
      var Assign, Block, Literal, Value, ast, err, js, result, _ref1;
      input = input.replace(/\uFF00/g, '\n');
      input = input.replace(/^\(([\s\S]*)\n\)$/m, '$1');
      _ref1 = require('./nodes'), Block = _ref1.Block, Assign = _ref1.Assign, Value = _ref1.Value, Literal = _ref1.Literal;
      try {
        ast = CoffeeScript.nodes(input);
        ast = new Block([new Assign(new Value(new Literal('_')), ast, '=')]);
        js = ast.compile({
          bare: true,
          locals: Object.keys(context)
        });
        result = context === global ? vm.runInThisContext(js, filename) : vm.runInContext(js, context, filename);
        return cb(null, result);
      } catch (_error) {
        err = _error;
        updateSyntaxError(err, input);
        return cb(err);
      }
    }
  };

  addMultilineHandler = function(repl) {
    var inputStream, multiline, nodeLineListener, outputStream, rli;
    rli = repl.rli, inputStream = repl.inputStream, outputStream = repl.outputStream;
    multiline = {
      enabled: false,
      initialPrompt: repl.prompt.replace(/^[^> ]*/, function(x) {
        return x.replace(/./g, '-');
      }),
      prompt: repl.prompt.replace(/^[^> ]*>?/, function(x) {
        return x.replace(/./g, '.');
      }),
      buffer: ''
    };
    nodeLineListener = rli.listeners('line')[0];
    rli.removeListener('line', nodeLineListener);
    rli.on('line', function(cmd) {
      if (multiline.enabled) {
        multiline.buffer += "" + cmd + "\n";
        rli.setPrompt(multiline.prompt);
        rli.prompt(true);
      } else {
        nodeLineListener(cmd);
      }
    });
    return inputStream.on('keypress', function(char, key) {
      if (!(key && key.ctrl && !key.meta && !key.shift && key.name === 'v')) {
        return;
      }
      if (multiline.enabled) {
        if (!multiline.buffer.match(/\n/)) {
          multiline.enabled = !multiline.enabled;
          rli.setPrompt(repl.prompt);
          rli.prompt(true);
          return;
        }
        if ((rli.line != null) && !rli.line.match(/^\s*$/)) {
          return;
        }
        multiline.enabled = !multiline.enabled;
        rli.line = '';
        rli.cursor = 0;
        rli.output.cursorTo(0);
        rli.output.clearLine(1);
        multiline.buffer = multiline.buffer.replace(/\n/g, '\uFF00');
        rli.emit('line', multiline.buffer);
        multiline.buffer = '';
      } else {
        multiline.enabled = !multiline.enabled;
        rli.setPrompt(multiline.initialPrompt);
        rli.prompt(true);
      }
    });
  };

  addHistory = function(repl, filename, maxSize) {
    var buffer, fd, lastLine, readFd, size, stat;
    lastLine = null;
    try {
      stat = fs.statSync(filename);
      size = Math.min(maxSize, stat.size);
      readFd = fs.openSync(filename, 'r');
      buffer = new Buffer(size);
      fs.readSync(readFd, buffer, 0, size, stat.size - size);
      repl.rli.history = buffer.toString().split('\n').reverse();
      if (stat.size > maxSize) {
        repl.rli.history.pop();
      }
      if (repl.rli.history[0] === '') {
        repl.rli.history.shift();
      }
      repl.rli.historyIndex = -1;
      lastLine = repl.rli.history[0];
    } catch (_error) {}
    fd = fs.openSync(filename, 'a');
    repl.rli.addListener('line', function(code) {
      if (code && code.length && code !== '.history' && lastLine !== code) {
        fs.write(fd, "" + code + "\n");
        return lastLine = code;
      }
    });
    repl.rli.on('exit', function() {
      return fs.close(fd);
    });
    return repl.commands['.history'] = {
      help: 'Show command history',
      action: function() {
        repl.outputStream.write("" + (repl.rli.history.slice(0).reverse().join('\n')) + "\n");
        return repl.displayPrompt();
      }
    };
  };

  module.exports = {
    start: function(opts) {
      var build, major, minor, repl, _ref1;
      if (opts == null) {
        opts = {};
      }
      _ref1 = process.versions.node.split('.').map(function(n) {
        return parseInt(n);
      }), major = _ref1[0], minor = _ref1[1], build = _ref1[2];
      if (major === 0 && minor < 8) {
        console.warn("Node 0.8.0+ required for CoffeeScript REPL");
        process.exit(1);
      }
      CoffeeScript.register();
      process.argv = ['coffee'].concat(process.argv.slice(2));
      opts = merge(replDefaults, opts);
      repl = nodeREPL.start(opts);
      repl.on('exit', function() {
        return repl.outputStream.write('\n');
      });
      addMultilineHandler(repl);
      if (opts.historyFile) {
        addHistory(repl, opts.historyFile, opts.historyMaxInputSize);
      }
      return repl;
    }
  };

}).call(this);
