(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["collection-view"] = factory();
	else
		root["collection-view"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _interopRequireDefault = __webpack_require__(1)['default'];

	Object.defineProperty(exports, '__esModule', {
	  value: true
	});

	var _collectionView = __webpack_require__(2);

	var _collectionView2 = _interopRequireDefault(_collectionView);

	var _gridLayout = __webpack_require__(67);

	var _gridLayout2 = _interopRequireDefault(_gridLayout);

	var _listLayout = __webpack_require__(68);

	var _listLayout2 = _interopRequireDefault(_listLayout);

	exports.CollectionView = _collectionView2['default'];
	exports.GridLayout = _gridLayout2['default'];
	exports.ListLayout = _listLayout2['default'];

/***/ },
/* 1 */
/***/ function(module, exports) {

	"use strict";

	exports["default"] = function (obj) {
	  return obj && obj.__esModule ? obj : {
	    "default": obj
	  };
	};

	exports.__esModule = true;

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createClass = __webpack_require__(3)['default'];

	var _classCallCheck = __webpack_require__(7)['default'];

	var _slicedToArray = __webpack_require__(8)['default'];

	var _Object$values = __webpack_require__(49)['default'];

	var _Object$keys = __webpack_require__(53)['default'];

	var _interopRequireDefault = __webpack_require__(1)['default'];

	Object.defineProperty(exports, '__esModule', {
	  value: true
	});

	var _bezierEasing = __webpack_require__(58);

	var _bezierEasing2 = _interopRequireDefault(_bezierEasing);

	var _lodashThrottle = __webpack_require__(59);

	var _lodashThrottle2 = _interopRequireDefault(_lodashThrottle);

	var _polyfills = __webpack_require__(62);

	var _styleCss = __webpack_require__(63);

	var _styleCss2 = _interopRequireDefault(_styleCss);

	var CollectionView = (function () {
	  _createClass(CollectionView, null, [{
	    key: 'THRESHOLD_PROPERTIES',
	    value: ['left', 'top', 'right', 'bottom'],
	    enumerable: true
	  }, {
	    key: 'DEFAULT_THRESHOLD',
	    value: 3000,
	    enumerable: true
	  }, {
	    key: 'DEFAULT_REPOSITIONING_CLASS_NAME',
	    value: 'repositioning',
	    enumerable: true
	  }, {
	    key: 'DEFAULT_APPEARING_CLASS_NAME',
	    value: 'appearing',
	    enumerable: true
	  }, {
	    key: 'DEFAULT_DISAPPEARING_CLASS_NAME',
	    value: 'disappearing',
	    enumerable: true
	  }, {
	    key: 'DEFAULT_ANIMATION_DURATION',
	    value: 400,
	    enumerable: true
	  }, {
	    key: 'DEFAULT_RESIZE_THROTTLE',
	    value: 1000,
	    enumerable: true
	  }, {
	    key: 'EASING',
	    value: (0, _bezierEasing2['default'])(0.25, 0.1, 0.25, 1.0),
	    enumerable: true
	  }]);

	  function CollectionView(content, layout, delegate) {
	    var _this = this;

	    _classCallCheck(this, CollectionView);

	    this.content = content;
	    content.classList.add(_styleCss2['default'].content);
	    this.layout = layout;
	    this.delegate = delegate;
	    this.container = content.parentElement;
	    this.container.classList.add(_styleCss2['default'].container);
	    this.scrollPosition = [0, 0];
	    this.containerSize = [0, 0];
	    this.contentSize = [0, 0];
	    this.elements = {};
	    this.updating = false;
	    this.resizing = false;
	    this.visibleIndices = [];
	    this.animationDuration = CollectionView.DEFAULT_ANIMATION_DURATION;
	    this.thresholds = {};
	    var defaultThreshold = CollectionView.DEFAULT_THRESHOLD;
	    CollectionView.THRESHOLD_PROPERTIES.forEach(function (property) {
	      return _this.thresholds[property] = defaultThreshold;
	    });
	    this.repositioningClassName = CollectionView.DEFAULT_REPOSITIONING_CLASS_NAME;
	    this.appearingClassName = CollectionView.DEFAULT_APPEARING_CLASS_NAME;
	    this.disappearingClassName = CollectionView.DEFAULT_DISAPPEARING_CLASS_NAME;

	    this.updateContainerSize(this.layout);
	    this.updateCount();
	    this.updateContentSize(this.layout);

	    this.onScroll = this.onScroll.bind(this);
	    this.onResize = (0, _lodashThrottle2['default'])(function () {
	      return _this.resize();
	    }, CollectionView.DEFAULT_RESIZE_THROTTLE, { leading: false });

	    this.container.addEventListener('scroll', this.onScroll, false);
	    window.addEventListener('resize', this.onResize, false);

	    // DEBUG: keep scroll position
	    // let savedPos = localStorage['pos']
	    // if (savedPos)
	    //   this.scrollTo(JSON.parse(savedPos))
	    // window.addEventListener("beforeunload", () => {
	    //   localStorage['pos'] = JSON.stringify(this.scrollPosition)
	    // })

	    this.updateCurrentIndices();
	    this.installed = true;
	  }

	  _createClass(CollectionView, [{
	    key: 'uninstall',
	    value: function uninstall() {
	      this.installed = false;

	      this.content.classList.remove(_styleCss2['default'].content);
	      this.content.removeAttribute('style');

	      this.container.classList.remove(_styleCss2['default'].container);
	      this.container.removeEventListener('scroll', this.onScroll, false);

	      window.removeEventListener('resize', this.onResize, false);

	      this.forEachVisibleElement(function (element) {
	        return element.parentElement.removeChild(element);
	      });
	    }
	  }, {
	    key: 'getContainerSize',
	    value: function getContainerSize() {
	      return [this.container.clientWidth, this.container.clientHeight];
	    }
	  }, {
	    key: 'updateContainerSize',
	    value: function updateContainerSize(layout) {
	      this.containerSize = this.getContainerSize();
	      layout.updateContainerSize(this.containerSize);
	    }
	  }, {
	    key: 'updateCount',
	    value: function updateCount() {
	      this.count = this.delegate.getCount();
	    }
	  }, {
	    key: 'updateContentSize',
	    value: function updateContentSize(layout) {
	      this.contentSize = layout.getContentSize(this.count, this.getContainerSize());

	      var _contentSize = _slicedToArray(this.contentSize, 2);

	      var contentWidth = _contentSize[0];
	      var contentHeight = _contentSize[1];

	      this.content.style.minWidth = contentWidth + 'px';
	      this.content.style.minHeight = contentHeight + 'px';
	    }
	  }, {
	    key: 'getScrollPosition',
	    value: function getScrollPosition() {
	      return [this.container.scrollLeft, this.container.scrollTop];
	    }
	  }, {
	    key: 'onScroll',
	    value: function onScroll() {
	      var _this2 = this;

	      this.scrollPosition = this.getScrollPosition();

	      if (this.updating) return;
	      this.updating = true;
	      (0, _polyfills.requestAnimFrame)(function () {
	        _this2.updateCurrentIndices();
	        if (_this2.delegate.onScroll) _this2.delegate.onScroll(_this2);
	        _this2.updating = false;
	      });
	    }
	  }, {
	    key: 'getAxisOffsets',
	    value: function getAxisOffsets(position, range, startThreshold, endThreshold) {
	      var offset = Math.max(0, position - startThreshold);
	      var fullRange = startThreshold + range + endThreshold;
	      var endOffset = offset + fullRange;
	      return [offset, endOffset];
	    }
	  }, {
	    key: 'getOffsets',
	    value: function getOffsets(position) {
	      var _position = _slicedToArray(position, 2);

	      var x = _position[0];
	      var y = _position[1];

	      var _containerSize = _slicedToArray(this.containerSize, 2);

	      var containerWidth = _containerSize[0];
	      var containerHeight = _containerSize[1];
	      var _thresholds = this.thresholds;
	      var left = _thresholds.left;
	      var top = _thresholds.top;
	      var right = _thresholds.right;
	      var bottom = _thresholds.bottom;

	      var xOffsets = this.getAxisOffsets(x, containerWidth, left, right);
	      var yOffsets = this.getAxisOffsets(y, containerHeight, top, bottom);
	      return [xOffsets, yOffsets];
	    }
	  }, {
	    key: 'getIndices',
	    value: function getIndices(layout, position, containerSize) {
	      var _getOffsets = this.getOffsets(position);

	      var _getOffsets2 = _slicedToArray(_getOffsets, 2);

	      var xOffsets = _getOffsets2[0];
	      var yOffsets = _getOffsets2[1];

	      return layout.getIndices(xOffsets, yOffsets, this.count, containerSize);
	    }
	  }, {
	    key: 'getCurrentIndices',
	    value: function getCurrentIndices() {
	      return this.getIndices(this.layout, this.scrollPosition, this.containerSize);
	    }
	  }, {
	    key: 'updateCurrentIndices',
	    value: function updateCurrentIndices() {
	      this.updateIndices(this.getCurrentIndices());
	    }
	  }, {
	    key: 'forEachVisibleElement',
	    value: function forEachVisibleElement(fn) {
	      var _this3 = this;

	      this.keysAsNumbers(this.elements).forEach(function (index) {
	        var element = _this3.elements[index];
	        fn(element, index);
	      });
	    }
	  }, {
	    key: 'updateIndices',
	    value: function updateIndices(newIndices) {
	      var _this4 = this;

	      // determine old elements
	      var invalidElements = [];

	      this.forEachVisibleElement(function (element, index) {
	        if (newIndices.indexOf(index) >= 0) return;

	        delete _this4.elements[index];
	        invalidElements.push(element);
	      });

	      // add missing elements
	      var currentIndices = this.visibleIndices;
	      newIndices.filter(function (index) {
	        return currentIndices.indexOf(index) < 0;
	      }).forEach(function (index) {
	        var element = invalidElements.pop() || _this4.createAndAddElement();
	        _this4.configureElement(_this4.layout, element, index);
	        _this4.positionElement(_this4.layout, element, index);
	        element.classList.remove(_this4.repositioningClassName);
	        _this4.elements[index] = element;
	      });
	      this.visibleIndices = newIndices;

	      // actually remove old elements, which weren't reused
	      invalidElements.forEach(function (element) {
	        return element.parentElement.removeChild(element);
	      });
	    }
	  }, {
	    key: 'configureElement',
	    value: function configureElement(layout, element, index) {
	      this.delegate.configureElement(element, index);
	      layout.configureElement(element, index);
	    }
	  }, {
	    key: 'positionElement',
	    value: function positionElement(layout, element, index) {
	      element.style.zIndex = index + 1;

	      var _layout$getElementPosition = layout.getElementPosition(index);

	      var _layout$getElementPosition2 = _slicedToArray(_layout$getElementPosition, 2);

	      var x = _layout$getElementPosition2[0];
	      var y = _layout$getElementPosition2[1];

	      element.style.transform = 'translate3d(' + x + 'px, ' + y + 'px, 0)';
	    }
	  }, {
	    key: 'createAndAddElement',
	    value: function createAndAddElement() {
	      var element = document.createElement('div');
	      element.classList.add(_styleCss2['default'].element);
	      this.content.appendChild(element);
	      return element;
	    }
	  }, {
	    key: 'unique',
	    value: function unique(items) {
	      var seen = {};
	      return items.filter(function (item) {
	        if (seen.hasOwnProperty(item)) return false;
	        return seen[item] = true;
	      });
	    }
	  }, {
	    key: 'repositionVisibleElements',
	    value: function repositionVisibleElements(layout) {
	      var _this5 = this;

	      this.forEachVisibleElement(function (element, index) {
	        var onTransitionEnd = function onTransitionEnd() {
	          element.removeEventListener(_polyfills.transitionEndEventName, onTransitionEnd, false);
	          element.classList.remove(_this5.repositioningClassName);
	        };

	        element.addEventListener(_polyfills.transitionEndEventName, onTransitionEnd, false);
	        element.classList.add(_this5.repositioningClassName);

	        _this5.positionElement(layout, element, index);
	      });
	    }
	  }, {
	    key: 'resize',
	    value: function resize() {
	      var _this6 = this;

	      if (this.resizing) {
	        this.wantsResize = true;
	        return;
	      }
	      this.resizing = true;

	      this.updateLayout(this.layout, function () {
	        _this6.resizing = false;

	        if (_this6.wantsResize) {
	          _this6.wantsResize = false;
	          _this6.resize();
	        }
	      });
	    }
	  }, {
	    key: 'updateLayout',
	    value: function updateLayout(newLayout, completion) {
	      var _this7 = this;

	      this.container.removeEventListener('scroll', this.onScroll, false);

	      // update with elements that will be visible after resize

	      var newContainerSize = this.getContainerSize();
	      var newPosition = newLayout.convertPositionInSize(this.scrollPosition, newContainerSize, this.layout);
	      var futureIndices = this.getIndices(newLayout, newPosition, newContainerSize);
	      var indices = this.unique(this.visibleIndices.concat(futureIndices));
	      this.updateIndices(indices);

	      // temporarily shift position of visible elements and scroll
	      // to future position, so elements appear to "stay"

	      var diffX = newPosition[0] - this.scrollPosition[0];
	      var diffY = newPosition[1] - this.scrollPosition[1];

	      if (diffX || diffY) {
	        _Object$values(this.elements).forEach(function (element) {
	          return element.style.transform += ' translate3d(' + diffX + 'px, ' + diffY + 'px, 0)';
	        });
	      }

	      this.updateContentSize(newLayout);

	      this.scrollTo(newPosition);

	      this.scrollPosition = newPosition;

	      this.updateContainerSize(newLayout);

	      // reposition (NOTE: setTimeout important)
	      setTimeout(function () {

	        _this7.repositionVisibleElements(newLayout);

	        _this7.forEachVisibleElement(function (element, index) {
	          return newLayout.configureElement(element, index);
	        });

	        _this7.layout = newLayout;

	        if (_this7.installed) _this7.container.addEventListener('scroll', _this7.onScroll, false);

	        setTimeout(function () {
	          if (completion) completion();
	        }, _this7.animationDuration);
	      }, 0);
	    }
	  }, {
	    key: 'scrollTo',
	    value: function scrollTo(position) {
	      var _position2 = _slicedToArray(position, 2);

	      var x = _position2[0];
	      var y = _position2[1];

	      this.container.scrollLeft = x;
	      this.container.scrollTop = y;
	    }
	  }, {
	    key: 'animatedScrollTo',
	    value: function animatedScrollTo(position) {
	      var _this8 = this;

	      var start = Date.now();

	      var _getScrollPosition = this.getScrollPosition();

	      var _getScrollPosition2 = _slicedToArray(_getScrollPosition, 2);

	      var fromX = _getScrollPosition2[0];
	      var fromY = _getScrollPosition2[1];

	      var _position3 = _slicedToArray(position, 2);

	      var toX = _position3[0];
	      var toY = _position3[1];

	      var easing = CollectionView.EASING;
	      var scroll = function scroll() {
	        var now = Date.now();
	        var progress = Math.min(1, (now - start) / _this8.animationDuration);
	        var easedProgress = easing(progress);
	        var targetX = fromX + easedProgress * (toX - fromX);
	        var targetY = fromY + easedProgress * (toY - fromY);
	        _this8.scrollTo([targetX, targetY]);

	        if (progress < 1) (0, _polyfills.requestAnimFrame)(scroll);
	      };

	      (0, _polyfills.requestAnimFrame)(scroll);
	    }
	  }, {
	    key: 'sort',
	    value: function sort(indices) {
	      return indices.sort(function (a, b) {
	        return a < b ? -1 : 1;
	      });
	    }
	  }, {
	    key: 'keysAsNumbers',
	    value: function keysAsNumbers(map) {
	      return _Object$keys(map).map(Number);
	    }
	  }, {
	    key: 'changeIndices',
	    value: function changeIndices(removedIndices, addedIndices, movedIndexMap) {
	      var _this9 = this;

	      this.container.removeEventListener('scroll', this.onScroll, false);

	      // prepare moved mapping

	      var oldMovedIndices = this.keysAsNumbers(movedIndexMap);
	      var reverseMovedIndexMap = {};
	      oldMovedIndices.forEach(function (oldIndex) {
	        var newIndex = movedIndexMap[oldIndex];
	        reverseMovedIndexMap[newIndex] = oldIndex;
	      });
	      var newMovedIndices = this.keysAsNumbers(reverseMovedIndexMap);

	      // update count

	      this.updateCount();

	      var countDifference = addedIndices.length - removedIndices.length;

	      // TODO: assert countDifference == this.count - oldCount

	      if (countDifference > 0) this.updateContentSize(this.layout);

	      // scroll if current position will be out of bounds

	      var _layout$getContentSize = this.layout.getContentSize(this.count, this.containerSize);

	      var _layout$getContentSize2 = _slicedToArray(_layout$getContentSize, 2);

	      var newContentWidth = _layout$getContentSize2[0];
	      var newContentHeight = _layout$getContentSize2[1];

	      var _containerSize2 = _slicedToArray(this.containerSize, 2);

	      var containerWidth = _containerSize2[0];
	      var containerHeight = _containerSize2[1];

	      var right = this.scrollPosition[0] + containerWidth;
	      var adjustX = right > newContentWidth;
	      if (adjustX) this.scrollPosition[0] -= right - newContentWidth;

	      var bottom = this.scrollPosition[1] + containerHeight;
	      var adjustY = bottom > newContentHeight;
	      if (adjustY) this.scrollPosition[1] -= bottom - newContentHeight;

	      if (adjustX || adjustY) this.animatedScrollTo(this.scrollPosition);

	      // disappear and remove elements

	      removedIndices.forEach(function (index) {
	        var element = _this9.elements[index];
	        if (!element) return;

	        element.classList.add(_this9.disappearingClassName);
	        element.style.zIndex = 0;
	        setTimeout(function () {
	          return element.parentElement.removeChild(element);
	        }, _this9.animationDuration);
	        delete _this9.elements[index];
	      });

	      // reorder visible elements

	      var removedOrMovedIndices = this.sort(removedIndices.concat(oldMovedIndices));
	      var addedOrMovedIndices = this.sort(addedIndices.concat(newMovedIndices));

	      var removedOrMovedReorderOffset = 0;
	      var newElements = {};

	      this.forEachVisibleElement(function (element, index) {
	        var newIndex = undefined;
	        if (movedIndexMap.hasOwnProperty(index)) {
	          newIndex = movedIndexMap[index];
	        } else {
	          while (removedOrMovedReorderOffset < removedOrMovedIndices.length && removedOrMovedIndices[removedOrMovedReorderOffset] <= index) {
	            removedOrMovedReorderOffset += 1;
	          }

	          var addedOrMovedReorderOffset = 0;
	          while (addedOrMovedReorderOffset < addedOrMovedIndices.length && addedOrMovedIndices[addedOrMovedReorderOffset] <= index - removedOrMovedReorderOffset + addedOrMovedReorderOffset) {
	            addedOrMovedReorderOffset += 1;
	          }

	          newIndex = index - removedOrMovedReorderOffset + addedOrMovedReorderOffset;
	        }

	        newElements[newIndex] = element;
	      });
	      this.elements = newElements;

	      // load visible elements

	      var newIndices = this.getCurrentIndices();

	      var removedOrMovedLoadOffset = 0;
	      var addedOrMovedLoadOffset = 0;

	      newIndices.forEach(function (index) {

	        var oldIndex = undefined;
	        if (reverseMovedIndexMap.hasOwnProperty(index)) {
	          oldIndex = reverseMovedIndexMap[index];
	        } else {
	          while (addedOrMovedLoadOffset < addedOrMovedIndices.length && addedOrMovedIndices[addedOrMovedLoadOffset] <= index) {
	            addedOrMovedLoadOffset += 1;
	          }

	          while (removedOrMovedLoadOffset < removedOrMovedIndices.length && removedOrMovedIndices[removedOrMovedLoadOffset] <= index - addedOrMovedLoadOffset + removedOrMovedLoadOffset) {
	            removedOrMovedLoadOffset += 1;
	          }

	          oldIndex = index - addedOrMovedLoadOffset + removedOrMovedLoadOffset;
	        }

	        var existingElement = _this9.elements[index];
	        if (existingElement) return;

	        var element = _this9.createAndAddElement();
	        var isNew = addedIndices.indexOf(index) >= 0;
	        _this9.configureElement(_this9.layout, element, index);
	        _this9.positionElement(_this9.layout, element, isNew ? index : oldIndex);
	        if (isNew) {
	          element.classList.add(_this9.appearingClassName);
	          window.getComputedStyle(element).opacity;
	          element.classList.remove(_this9.appearingClassName);
	        }
	        _this9.elements[index] = element;
	      });

	      this.visibleIndices = newIndices;

	      // reposition (NOTE: setTimeout important)

	      setTimeout(function () {

	        _this9.repositionVisibleElements(_this9.layout);

	        if (_this9.installed) _this9.container.addEventListener('scroll', _this9.onScroll, false);

	        setTimeout(function () {
	          if (countDifference < 0) _this9.updateContentSize(_this9.layout);
	        }, _this9.animationDuration);
	      }, 0);
	    }
	  }]);

	  return CollectionView;
	})();

	exports['default'] = CollectionView;
	module.exports = exports['default'];

/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var _Object$defineProperty = __webpack_require__(4)["default"];

	exports["default"] = (function () {
	  function defineProperties(target, props) {
	    for (var i = 0; i < props.length; i++) {
	      var descriptor = props[i];
	      descriptor.enumerable = descriptor.enumerable || false;
	      descriptor.configurable = true;
	      if ("value" in descriptor) descriptor.writable = true;

	      _Object$defineProperty(target, descriptor.key, descriptor);
	    }
	  }

	  return function (Constructor, protoProps, staticProps) {
	    if (protoProps) defineProperties(Constructor.prototype, protoProps);
	    if (staticProps) defineProperties(Constructor, staticProps);
	    return Constructor;
	  };
	})();

	exports.__esModule = true;

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = { "default": __webpack_require__(5), __esModule: true };

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	var $ = __webpack_require__(6);
	module.exports = function defineProperty(it, key, desc){
	  return $.setDesc(it, key, desc);
	};

/***/ },
/* 6 */
/***/ function(module, exports) {

	var $Object = Object;
	module.exports = {
	  create:     $Object.create,
	  getProto:   $Object.getPrototypeOf,
	  isEnum:     {}.propertyIsEnumerable,
	  getDesc:    $Object.getOwnPropertyDescriptor,
	  setDesc:    $Object.defineProperty,
	  setDescs:   $Object.defineProperties,
	  getKeys:    $Object.keys,
	  getNames:   $Object.getOwnPropertyNames,
	  getSymbols: $Object.getOwnPropertySymbols,
	  each:       [].forEach
	};

/***/ },
/* 7 */
/***/ function(module, exports) {

	"use strict";

	exports["default"] = function (instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	};

	exports.__esModule = true;

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var _getIterator = __webpack_require__(9)["default"];

	var _isIterable = __webpack_require__(46)["default"];

	exports["default"] = (function () {
	  function sliceIterator(arr, i) {
	    var _arr = [];
	    var _n = true;
	    var _d = false;
	    var _e = undefined;

	    try {
	      for (var _i = _getIterator(arr), _s; !(_n = (_s = _i.next()).done); _n = true) {
	        _arr.push(_s.value);

	        if (i && _arr.length === i) break;
	      }
	    } catch (err) {
	      _d = true;
	      _e = err;
	    } finally {
	      try {
	        if (!_n && _i["return"]) _i["return"]();
	      } finally {
	        if (_d) throw _e;
	      }
	    }

	    return _arr;
	  }

	  return function (arr, i) {
	    if (Array.isArray(arr)) {
	      return arr;
	    } else if (_isIterable(Object(arr))) {
	      return sliceIterator(arr, i);
	    } else {
	      throw new TypeError("Invalid attempt to destructure non-iterable instance");
	    }
	  };
	})();

	exports.__esModule = true;

/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = { "default": __webpack_require__(10), __esModule: true };

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(11);
	__webpack_require__(38);
	module.exports = __webpack_require__(41);

/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(12);
	var Iterators = __webpack_require__(15);
	Iterators.NodeList = Iterators.HTMLCollection = Iterators.Array;

/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var addToUnscopables = __webpack_require__(13)
	  , step             = __webpack_require__(14)
	  , Iterators        = __webpack_require__(15)
	  , toIObject        = __webpack_require__(16);

	// 22.1.3.4 Array.prototype.entries()
	// 22.1.3.13 Array.prototype.keys()
	// 22.1.3.29 Array.prototype.values()
	// 22.1.3.30 Array.prototype[@@iterator]()
	module.exports = __webpack_require__(20)(Array, 'Array', function(iterated, kind){
	  this._t = toIObject(iterated); // target
	  this._i = 0;                   // next index
	  this._k = kind;                // kind
	// 22.1.5.2.1 %ArrayIteratorPrototype%.next()
	}, function(){
	  var O     = this._t
	    , kind  = this._k
	    , index = this._i++;
	  if(!O || index >= O.length){
	    this._t = undefined;
	    return step(1);
	  }
	  if(kind == 'keys'  )return step(0, index);
	  if(kind == 'values')return step(0, O[index]);
	  return step(0, [index, O[index]]);
	}, 'values');

	// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
	Iterators.Arguments = Iterators.Array;

	addToUnscopables('keys');
	addToUnscopables('values');
	addToUnscopables('entries');

/***/ },
/* 13 */
/***/ function(module, exports) {

	module.exports = function(){ /* empty */ };

/***/ },
/* 14 */
/***/ function(module, exports) {

	module.exports = function(done, value){
	  return {value: value, done: !!done};
	};

/***/ },
/* 15 */
/***/ function(module, exports) {

	module.exports = {};

/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	// to indexed object, toObject with fallback for non-array-like ES3 strings
	var IObject = __webpack_require__(17)
	  , defined = __webpack_require__(19);
	module.exports = function(it){
	  return IObject(defined(it));
	};

/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	// fallback for non-array-like ES3 and non-enumerable old V8 strings
	var cof = __webpack_require__(18);
	module.exports = Object('z').propertyIsEnumerable(0) ? Object : function(it){
	  return cof(it) == 'String' ? it.split('') : Object(it);
	};

/***/ },
/* 18 */
/***/ function(module, exports) {

	var toString = {}.toString;

	module.exports = function(it){
	  return toString.call(it).slice(8, -1);
	};

/***/ },
/* 19 */
/***/ function(module, exports) {

	// 7.2.1 RequireObjectCoercible(argument)
	module.exports = function(it){
	  if(it == undefined)throw TypeError("Can't call method on  " + it);
	  return it;
	};

/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var LIBRARY        = __webpack_require__(21)
	  , $export        = __webpack_require__(22)
	  , redefine       = __webpack_require__(27)
	  , hide           = __webpack_require__(28)
	  , has            = __webpack_require__(32)
	  , Iterators      = __webpack_require__(15)
	  , $iterCreate    = __webpack_require__(33)
	  , setToStringTag = __webpack_require__(34)
	  , getProto       = __webpack_require__(6).getProto
	  , ITERATOR       = __webpack_require__(35)('iterator')
	  , BUGGY          = !([].keys && 'next' in [].keys()) // Safari has buggy iterators w/o `next`
	  , FF_ITERATOR    = '@@iterator'
	  , KEYS           = 'keys'
	  , VALUES         = 'values';

	var returnThis = function(){ return this; };

	module.exports = function(Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED){
	  $iterCreate(Constructor, NAME, next);
	  var getMethod = function(kind){
	    if(!BUGGY && kind in proto)return proto[kind];
	    switch(kind){
	      case KEYS: return function keys(){ return new Constructor(this, kind); };
	      case VALUES: return function values(){ return new Constructor(this, kind); };
	    } return function entries(){ return new Constructor(this, kind); };
	  };
	  var TAG        = NAME + ' Iterator'
	    , DEF_VALUES = DEFAULT == VALUES
	    , VALUES_BUG = false
	    , proto      = Base.prototype
	    , $native    = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT]
	    , $default   = $native || getMethod(DEFAULT)
	    , methods, key;
	  // Fix native
	  if($native){
	    var IteratorPrototype = getProto($default.call(new Base));
	    // Set @@toStringTag to native iterators
	    setToStringTag(IteratorPrototype, TAG, true);
	    // FF fix
	    if(!LIBRARY && has(proto, FF_ITERATOR))hide(IteratorPrototype, ITERATOR, returnThis);
	    // fix Array#{values, @@iterator}.name in V8 / FF
	    if(DEF_VALUES && $native.name !== VALUES){
	      VALUES_BUG = true;
	      $default = function values(){ return $native.call(this); };
	    }
	  }
	  // Define iterator
	  if((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])){
	    hide(proto, ITERATOR, $default);
	  }
	  // Plug for library
	  Iterators[NAME] = $default;
	  Iterators[TAG]  = returnThis;
	  if(DEFAULT){
	    methods = {
	      values:  DEF_VALUES  ? $default : getMethod(VALUES),
	      keys:    IS_SET      ? $default : getMethod(KEYS),
	      entries: !DEF_VALUES ? $default : getMethod('entries')
	    };
	    if(FORCED)for(key in methods){
	      if(!(key in proto))redefine(proto, key, methods[key]);
	    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
	  }
	  return methods;
	};

/***/ },
/* 21 */
/***/ function(module, exports) {

	module.exports = true;

/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	var global    = __webpack_require__(23)
	  , core      = __webpack_require__(24)
	  , ctx       = __webpack_require__(25)
	  , PROTOTYPE = 'prototype';

	var $export = function(type, name, source){
	  var IS_FORCED = type & $export.F
	    , IS_GLOBAL = type & $export.G
	    , IS_STATIC = type & $export.S
	    , IS_PROTO  = type & $export.P
	    , IS_BIND   = type & $export.B
	    , IS_WRAP   = type & $export.W
	    , exports   = IS_GLOBAL ? core : core[name] || (core[name] = {})
	    , target    = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE]
	    , key, own, out;
	  if(IS_GLOBAL)source = name;
	  for(key in source){
	    // contains in native
	    own = !IS_FORCED && target && key in target;
	    if(own && key in exports)continue;
	    // export native or passed
	    out = own ? target[key] : source[key];
	    // prevent global pollution for namespaces
	    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
	    // bind timers to global for call from export context
	    : IS_BIND && own ? ctx(out, global)
	    // wrap global constructors for prevent change them in library
	    : IS_WRAP && target[key] == out ? (function(C){
	      var F = function(param){
	        return this instanceof C ? new C(param) : C(param);
	      };
	      F[PROTOTYPE] = C[PROTOTYPE];
	      return F;
	    // make static versions for prototype methods
	    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
	    if(IS_PROTO)(exports[PROTOTYPE] || (exports[PROTOTYPE] = {}))[key] = out;
	  }
	};
	// type bitmap
	$export.F = 1;  // forced
	$export.G = 2;  // global
	$export.S = 4;  // static
	$export.P = 8;  // proto
	$export.B = 16; // bind
	$export.W = 32; // wrap
	module.exports = $export;

/***/ },
/* 23 */
/***/ function(module, exports) {

	// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
	var global = module.exports = typeof window != 'undefined' && window.Math == Math
	  ? window : typeof self != 'undefined' && self.Math == Math ? self : Function('return this')();
	if(typeof __g == 'number')__g = global; // eslint-disable-line no-undef

/***/ },
/* 24 */
/***/ function(module, exports) {

	var core = module.exports = {version: '1.2.6'};
	if(typeof __e == 'number')__e = core; // eslint-disable-line no-undef

/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	// optional / simple context binding
	var aFunction = __webpack_require__(26);
	module.exports = function(fn, that, length){
	  aFunction(fn);
	  if(that === undefined)return fn;
	  switch(length){
	    case 1: return function(a){
	      return fn.call(that, a);
	    };
	    case 2: return function(a, b){
	      return fn.call(that, a, b);
	    };
	    case 3: return function(a, b, c){
	      return fn.call(that, a, b, c);
	    };
	  }
	  return function(/* ...args */){
	    return fn.apply(that, arguments);
	  };
	};

/***/ },
/* 26 */
/***/ function(module, exports) {

	module.exports = function(it){
	  if(typeof it != 'function')throw TypeError(it + ' is not a function!');
	  return it;
	};

/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(28);

/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	var $          = __webpack_require__(6)
	  , createDesc = __webpack_require__(29);
	module.exports = __webpack_require__(30) ? function(object, key, value){
	  return $.setDesc(object, key, createDesc(1, value));
	} : function(object, key, value){
	  object[key] = value;
	  return object;
	};

/***/ },
/* 29 */
/***/ function(module, exports) {

	module.exports = function(bitmap, value){
	  return {
	    enumerable  : !(bitmap & 1),
	    configurable: !(bitmap & 2),
	    writable    : !(bitmap & 4),
	    value       : value
	  };
	};

/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	// Thank's IE8 for his funny defineProperty
	module.exports = !__webpack_require__(31)(function(){
	  return Object.defineProperty({}, 'a', {get: function(){ return 7; }}).a != 7;
	});

/***/ },
/* 31 */
/***/ function(module, exports) {

	module.exports = function(exec){
	  try {
	    return !!exec();
	  } catch(e){
	    return true;
	  }
	};

/***/ },
/* 32 */
/***/ function(module, exports) {

	var hasOwnProperty = {}.hasOwnProperty;
	module.exports = function(it, key){
	  return hasOwnProperty.call(it, key);
	};

/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var $              = __webpack_require__(6)
	  , descriptor     = __webpack_require__(29)
	  , setToStringTag = __webpack_require__(34)
	  , IteratorPrototype = {};

	// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
	__webpack_require__(28)(IteratorPrototype, __webpack_require__(35)('iterator'), function(){ return this; });

	module.exports = function(Constructor, NAME, next){
	  Constructor.prototype = $.create(IteratorPrototype, {next: descriptor(1, next)});
	  setToStringTag(Constructor, NAME + ' Iterator');
	};

/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	var def = __webpack_require__(6).setDesc
	  , has = __webpack_require__(32)
	  , TAG = __webpack_require__(35)('toStringTag');

	module.exports = function(it, tag, stat){
	  if(it && !has(it = stat ? it : it.prototype, TAG))def(it, TAG, {configurable: true, value: tag});
	};

/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	var store  = __webpack_require__(36)('wks')
	  , uid    = __webpack_require__(37)
	  , Symbol = __webpack_require__(23).Symbol;
	module.exports = function(name){
	  return store[name] || (store[name] =
	    Symbol && Symbol[name] || (Symbol || uid)('Symbol.' + name));
	};

/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	var global = __webpack_require__(23)
	  , SHARED = '__core-js_shared__'
	  , store  = global[SHARED] || (global[SHARED] = {});
	module.exports = function(key){
	  return store[key] || (store[key] = {});
	};

/***/ },
/* 37 */
/***/ function(module, exports) {

	var id = 0
	  , px = Math.random();
	module.exports = function(key){
	  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
	};

/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var $at  = __webpack_require__(39)(true);

	// 21.1.3.27 String.prototype[@@iterator]()
	__webpack_require__(20)(String, 'String', function(iterated){
	  this._t = String(iterated); // target
	  this._i = 0;                // next index
	// 21.1.5.2.1 %StringIteratorPrototype%.next()
	}, function(){
	  var O     = this._t
	    , index = this._i
	    , point;
	  if(index >= O.length)return {value: undefined, done: true};
	  point = $at(O, index);
	  this._i += point.length;
	  return {value: point, done: false};
	});

/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	var toInteger = __webpack_require__(40)
	  , defined   = __webpack_require__(19);
	// true  -> String#at
	// false -> String#codePointAt
	module.exports = function(TO_STRING){
	  return function(that, pos){
	    var s = String(defined(that))
	      , i = toInteger(pos)
	      , l = s.length
	      , a, b;
	    if(i < 0 || i >= l)return TO_STRING ? '' : undefined;
	    a = s.charCodeAt(i);
	    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
	      ? TO_STRING ? s.charAt(i) : a
	      : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
	  };
	};

/***/ },
/* 40 */
/***/ function(module, exports) {

	// 7.1.4 ToInteger
	var ceil  = Math.ceil
	  , floor = Math.floor;
	module.exports = function(it){
	  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
	};

/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	var anObject = __webpack_require__(42)
	  , get      = __webpack_require__(44);
	module.exports = __webpack_require__(24).getIterator = function(it){
	  var iterFn = get(it);
	  if(typeof iterFn != 'function')throw TypeError(it + ' is not iterable!');
	  return anObject(iterFn.call(it));
	};

/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	var isObject = __webpack_require__(43);
	module.exports = function(it){
	  if(!isObject(it))throw TypeError(it + ' is not an object!');
	  return it;
	};

/***/ },
/* 43 */
/***/ function(module, exports) {

	module.exports = function(it){
	  return typeof it === 'object' ? it !== null : typeof it === 'function';
	};

/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	var classof   = __webpack_require__(45)
	  , ITERATOR  = __webpack_require__(35)('iterator')
	  , Iterators = __webpack_require__(15);
	module.exports = __webpack_require__(24).getIteratorMethod = function(it){
	  if(it != undefined)return it[ITERATOR]
	    || it['@@iterator']
	    || Iterators[classof(it)];
	};

/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	// getting tag from 19.1.3.6 Object.prototype.toString()
	var cof = __webpack_require__(18)
	  , TAG = __webpack_require__(35)('toStringTag')
	  // ES3 wrong here
	  , ARG = cof(function(){ return arguments; }()) == 'Arguments';

	module.exports = function(it){
	  var O, T, B;
	  return it === undefined ? 'Undefined' : it === null ? 'Null'
	    // @@toStringTag case
	    : typeof (T = (O = Object(it))[TAG]) == 'string' ? T
	    // builtinTag case
	    : ARG ? cof(O)
	    // ES3 arguments fallback
	    : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
	};

/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = { "default": __webpack_require__(47), __esModule: true };

/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(11);
	__webpack_require__(38);
	module.exports = __webpack_require__(48);

/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	var classof   = __webpack_require__(45)
	  , ITERATOR  = __webpack_require__(35)('iterator')
	  , Iterators = __webpack_require__(15);
	module.exports = __webpack_require__(24).isIterable = function(it){
	  var O = Object(it);
	  return O[ITERATOR] !== undefined
	    || '@@iterator' in O
	    || Iterators.hasOwnProperty(classof(O));
	};

/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = { "default": __webpack_require__(50), __esModule: true };

/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(51);
	module.exports = __webpack_require__(24).Object.values;

/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	// http://goo.gl/XkBrjD
	var $export = __webpack_require__(22)
	  , $values = __webpack_require__(52)(false);

	$export($export.S, 'Object', {
	  values: function values(it){
	    return $values(it);
	  }
	});

/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	var $         = __webpack_require__(6)
	  , toIObject = __webpack_require__(16)
	  , isEnum    = $.isEnum;
	module.exports = function(isEntries){
	  return function(it){
	    var O      = toIObject(it)
	      , keys   = $.getKeys(O)
	      , length = keys.length
	      , i      = 0
	      , result = []
	      , key;
	    while(length > i)if(isEnum.call(O, key = keys[i++])){
	      result.push(isEntries ? [key, O[key]] : O[key]);
	    } return result;
	  };
	};

/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = { "default": __webpack_require__(54), __esModule: true };

/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(55);
	module.exports = __webpack_require__(24).Object.keys;

/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	// 19.1.2.14 Object.keys(O)
	var toObject = __webpack_require__(56);

	__webpack_require__(57)('keys', function($keys){
	  return function keys(it){
	    return $keys(toObject(it));
	  };
	});

/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	// 7.1.13 ToObject(argument)
	var defined = __webpack_require__(19);
	module.exports = function(it){
	  return Object(defined(it));
	};

/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	// most Object methods by ES6 should accept primitives
	var $export = __webpack_require__(22)
	  , core    = __webpack_require__(24)
	  , fails   = __webpack_require__(31);
	module.exports = function(KEY, exec){
	  var fn  = (core.Object || {})[KEY] || Object[KEY]
	    , exp = {};
	  exp[KEY] = exec(fn);
	  $export($export.S + $export.F * fails(function(){ fn(1); }), 'Object', exp);
	};

/***/ },
/* 58 */
/***/ function(module, exports) {

	/**
	 * https://github.com/gre/bezier-easing
	 * BezierEasing - use bezier curve for transition easing function
	 * by Gaëtan Renaudeau 2014 - 2015 – MIT License
	 */

	// These values are established by empiricism with tests (tradeoff: performance VS precision)
	var NEWTON_ITERATIONS = 4;
	var NEWTON_MIN_SLOPE = 0.001;
	var SUBDIVISION_PRECISION = 0.0000001;
	var SUBDIVISION_MAX_ITERATIONS = 10;

	var kSplineTableSize = 11;
	var kSampleStepSize = 1.0 / (kSplineTableSize - 1.0);

	var float32ArraySupported = typeof Float32Array === 'function';

	function A (aA1, aA2) { return 1.0 - 3.0 * aA2 + 3.0 * aA1; }
	function B (aA1, aA2) { return 3.0 * aA2 - 6.0 * aA1; }
	function C (aA1)      { return 3.0 * aA1; }

	// Returns x(t) given t, x1, and x2, or y(t) given t, y1, and y2.
	function calcBezier (aT, aA1, aA2) { return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT; }

	// Returns dx/dt given t, x1, and x2, or dy/dt given t, y1, and y2.
	function getSlope (aT, aA1, aA2) { return 3.0 * A(aA1, aA2) * aT * aT + 2.0 * B(aA1, aA2) * aT + C(aA1); }

	function binarySubdivide (aX, aA, aB, mX1, mX2) {
	  var currentX, currentT, i = 0;
	  do {
	    currentT = aA + (aB - aA) / 2.0;
	    currentX = calcBezier(currentT, mX1, mX2) - aX;
	    if (currentX > 0.0) {
	      aB = currentT;
	    } else {
	      aA = currentT;
	    }
	  } while (Math.abs(currentX) > SUBDIVISION_PRECISION && ++i < SUBDIVISION_MAX_ITERATIONS);
	  return currentT;
	}

	function newtonRaphsonIterate (aX, aGuessT, mX1, mX2) {
	 for (var i = 0; i < NEWTON_ITERATIONS; ++i) {
	   var currentSlope = getSlope(aGuessT, mX1, mX2);
	   if (currentSlope === 0.0) {
	     return aGuessT;
	   }
	   var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
	   aGuessT -= currentX / currentSlope;
	 }
	 return aGuessT;
	}

	module.exports = function bezier (mX1, mY1, mX2, mY2) {
	  if (!(0 <= mX1 && mX1 <= 1 && 0 <= mX2 && mX2 <= 1)) {
	    throw new Error('bezier x values must be in [0, 1] range');
	  }

	  // Precompute samples table
	  var sampleValues = float32ArraySupported ? new Float32Array(kSplineTableSize) : new Array(kSplineTableSize);
	  if (mX1 !== mY1 || mX2 !== mY2) {
	    for (var i = 0; i < kSplineTableSize; ++i) {
	      sampleValues[i] = calcBezier(i * kSampleStepSize, mX1, mX2);
	    }
	  }

	  function getTForX (aX) {
	    var intervalStart = 0.0;
	    var currentSample = 1;
	    var lastSample = kSplineTableSize - 1;

	    for (; currentSample !== lastSample && sampleValues[currentSample] <= aX; ++currentSample) {
	      intervalStart += kSampleStepSize;
	    }
	    --currentSample;

	    // Interpolate to provide an initial guess for t
	    var dist = (aX - sampleValues[currentSample]) / (sampleValues[currentSample + 1] - sampleValues[currentSample]);
	    var guessForT = intervalStart + dist * kSampleStepSize;

	    var initialSlope = getSlope(guessForT, mX1, mX2);
	    if (initialSlope >= NEWTON_MIN_SLOPE) {
	      return newtonRaphsonIterate(aX, guessForT, mX1, mX2);
	    } else if (initialSlope === 0.0) {
	      return guessForT;
	    } else {
	      return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize, mX1, mX2);
	    }
	  }

	  return function BezierEasing (x) {
	    if (mX1 === mY1 && mX2 === mY2) {
	      return x; // linear
	    }
	    // Because JavaScript number are imprecise, we should guarantee the extremes are right.
	    if (x === 0) {
	      return 0;
	    }
	    if (x === 1) {
	      return 1;
	    }
	    return calcBezier(getTForX(x), mY1, mY2);
	  };
	};


/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * lodash 3.0.4 (Custom Build) <https://lodash.com/>
	 * Build: `lodash modern modularize exports="npm" -o ./`
	 * Copyright 2012-2015 The Dojo Foundation <http://dojofoundation.org/>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 * Available under MIT license <https://lodash.com/license>
	 */
	var debounce = __webpack_require__(60);

	/** Used as the `TypeError` message for "Functions" methods. */
	var FUNC_ERROR_TEXT = 'Expected a function';

	/**
	 * Creates a throttled function that only invokes `func` at most once per
	 * every `wait` milliseconds. The throttled function comes with a `cancel`
	 * method to cancel delayed invocations. Provide an options object to indicate
	 * that `func` should be invoked on the leading and/or trailing edge of the
	 * `wait` timeout. Subsequent calls to the throttled function return the
	 * result of the last `func` call.
	 *
	 * **Note:** If `leading` and `trailing` options are `true`, `func` is invoked
	 * on the trailing edge of the timeout only if the the throttled function is
	 * invoked more than once during the `wait` timeout.
	 *
	 * See [David Corbacho's article](http://drupalmotion.com/article/debounce-and-throttle-visual-explanation)
	 * for details over the differences between `_.throttle` and `_.debounce`.
	 *
	 * @static
	 * @memberOf _
	 * @category Function
	 * @param {Function} func The function to throttle.
	 * @param {number} [wait=0] The number of milliseconds to throttle invocations to.
	 * @param {Object} [options] The options object.
	 * @param {boolean} [options.leading=true] Specify invoking on the leading
	 *  edge of the timeout.
	 * @param {boolean} [options.trailing=true] Specify invoking on the trailing
	 *  edge of the timeout.
	 * @returns {Function} Returns the new throttled function.
	 * @example
	 *
	 * // avoid excessively updating the position while scrolling
	 * jQuery(window).on('scroll', _.throttle(updatePosition, 100));
	 *
	 * // invoke `renewToken` when the click event is fired, but not more than once every 5 minutes
	 * jQuery('.interactive').on('click', _.throttle(renewToken, 300000, {
	 *   'trailing': false
	 * }));
	 *
	 * // cancel a trailing throttled call
	 * jQuery(window).on('popstate', throttled.cancel);
	 */
	function throttle(func, wait, options) {
	  var leading = true,
	      trailing = true;

	  if (typeof func != 'function') {
	    throw new TypeError(FUNC_ERROR_TEXT);
	  }
	  if (options === false) {
	    leading = false;
	  } else if (isObject(options)) {
	    leading = 'leading' in options ? !!options.leading : leading;
	    trailing = 'trailing' in options ? !!options.trailing : trailing;
	  }
	  return debounce(func, wait, { 'leading': leading, 'maxWait': +wait, 'trailing': trailing });
	}

	/**
	 * Checks if `value` is the [language type](https://es5.github.io/#x8) of `Object`.
	 * (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	 * @example
	 *
	 * _.isObject({});
	 * // => true
	 *
	 * _.isObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isObject(1);
	 * // => false
	 */
	function isObject(value) {
	  // Avoid a V8 JIT bug in Chrome 19-20.
	  // See https://code.google.com/p/v8/issues/detail?id=2291 for more details.
	  var type = typeof value;
	  return !!value && (type == 'object' || type == 'function');
	}

	module.exports = throttle;


/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * lodash 3.1.1 (Custom Build) <https://lodash.com/>
	 * Build: `lodash modern modularize exports="npm" -o ./`
	 * Copyright 2012-2015 The Dojo Foundation <http://dojofoundation.org/>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 * Available under MIT license <https://lodash.com/license>
	 */
	var getNative = __webpack_require__(61);

	/** Used as the `TypeError` message for "Functions" methods. */
	var FUNC_ERROR_TEXT = 'Expected a function';

	/* Native method references for those with the same name as other `lodash` methods. */
	var nativeMax = Math.max,
	    nativeNow = getNative(Date, 'now');

	/**
	 * Gets the number of milliseconds that have elapsed since the Unix epoch
	 * (1 January 1970 00:00:00 UTC).
	 *
	 * @static
	 * @memberOf _
	 * @category Date
	 * @example
	 *
	 * _.defer(function(stamp) {
	 *   console.log(_.now() - stamp);
	 * }, _.now());
	 * // => logs the number of milliseconds it took for the deferred function to be invoked
	 */
	var now = nativeNow || function() {
	  return new Date().getTime();
	};

	/**
	 * Creates a debounced function that delays invoking `func` until after `wait`
	 * milliseconds have elapsed since the last time the debounced function was
	 * invoked. The debounced function comes with a `cancel` method to cancel
	 * delayed invocations. Provide an options object to indicate that `func`
	 * should be invoked on the leading and/or trailing edge of the `wait` timeout.
	 * Subsequent calls to the debounced function return the result of the last
	 * `func` invocation.
	 *
	 * **Note:** If `leading` and `trailing` options are `true`, `func` is invoked
	 * on the trailing edge of the timeout only if the the debounced function is
	 * invoked more than once during the `wait` timeout.
	 *
	 * See [David Corbacho's article](http://drupalmotion.com/article/debounce-and-throttle-visual-explanation)
	 * for details over the differences between `_.debounce` and `_.throttle`.
	 *
	 * @static
	 * @memberOf _
	 * @category Function
	 * @param {Function} func The function to debounce.
	 * @param {number} [wait=0] The number of milliseconds to delay.
	 * @param {Object} [options] The options object.
	 * @param {boolean} [options.leading=false] Specify invoking on the leading
	 *  edge of the timeout.
	 * @param {number} [options.maxWait] The maximum time `func` is allowed to be
	 *  delayed before it is invoked.
	 * @param {boolean} [options.trailing=true] Specify invoking on the trailing
	 *  edge of the timeout.
	 * @returns {Function} Returns the new debounced function.
	 * @example
	 *
	 * // avoid costly calculations while the window size is in flux
	 * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
	 *
	 * // invoke `sendMail` when the click event is fired, debouncing subsequent calls
	 * jQuery('#postbox').on('click', _.debounce(sendMail, 300, {
	 *   'leading': true,
	 *   'trailing': false
	 * }));
	 *
	 * // ensure `batchLog` is invoked once after 1 second of debounced calls
	 * var source = new EventSource('/stream');
	 * jQuery(source).on('message', _.debounce(batchLog, 250, {
	 *   'maxWait': 1000
	 * }));
	 *
	 * // cancel a debounced call
	 * var todoChanges = _.debounce(batchLog, 1000);
	 * Object.observe(models.todo, todoChanges);
	 *
	 * Object.observe(models, function(changes) {
	 *   if (_.find(changes, { 'user': 'todo', 'type': 'delete'})) {
	 *     todoChanges.cancel();
	 *   }
	 * }, ['delete']);
	 *
	 * // ...at some point `models.todo` is changed
	 * models.todo.completed = true;
	 *
	 * // ...before 1 second has passed `models.todo` is deleted
	 * // which cancels the debounced `todoChanges` call
	 * delete models.todo;
	 */
	function debounce(func, wait, options) {
	  var args,
	      maxTimeoutId,
	      result,
	      stamp,
	      thisArg,
	      timeoutId,
	      trailingCall,
	      lastCalled = 0,
	      maxWait = false,
	      trailing = true;

	  if (typeof func != 'function') {
	    throw new TypeError(FUNC_ERROR_TEXT);
	  }
	  wait = wait < 0 ? 0 : (+wait || 0);
	  if (options === true) {
	    var leading = true;
	    trailing = false;
	  } else if (isObject(options)) {
	    leading = !!options.leading;
	    maxWait = 'maxWait' in options && nativeMax(+options.maxWait || 0, wait);
	    trailing = 'trailing' in options ? !!options.trailing : trailing;
	  }

	  function cancel() {
	    if (timeoutId) {
	      clearTimeout(timeoutId);
	    }
	    if (maxTimeoutId) {
	      clearTimeout(maxTimeoutId);
	    }
	    lastCalled = 0;
	    maxTimeoutId = timeoutId = trailingCall = undefined;
	  }

	  function complete(isCalled, id) {
	    if (id) {
	      clearTimeout(id);
	    }
	    maxTimeoutId = timeoutId = trailingCall = undefined;
	    if (isCalled) {
	      lastCalled = now();
	      result = func.apply(thisArg, args);
	      if (!timeoutId && !maxTimeoutId) {
	        args = thisArg = undefined;
	      }
	    }
	  }

	  function delayed() {
	    var remaining = wait - (now() - stamp);
	    if (remaining <= 0 || remaining > wait) {
	      complete(trailingCall, maxTimeoutId);
	    } else {
	      timeoutId = setTimeout(delayed, remaining);
	    }
	  }

	  function maxDelayed() {
	    complete(trailing, timeoutId);
	  }

	  function debounced() {
	    args = arguments;
	    stamp = now();
	    thisArg = this;
	    trailingCall = trailing && (timeoutId || !leading);

	    if (maxWait === false) {
	      var leadingCall = leading && !timeoutId;
	    } else {
	      if (!maxTimeoutId && !leading) {
	        lastCalled = stamp;
	      }
	      var remaining = maxWait - (stamp - lastCalled),
	          isCalled = remaining <= 0 || remaining > maxWait;

	      if (isCalled) {
	        if (maxTimeoutId) {
	          maxTimeoutId = clearTimeout(maxTimeoutId);
	        }
	        lastCalled = stamp;
	        result = func.apply(thisArg, args);
	      }
	      else if (!maxTimeoutId) {
	        maxTimeoutId = setTimeout(maxDelayed, remaining);
	      }
	    }
	    if (isCalled && timeoutId) {
	      timeoutId = clearTimeout(timeoutId);
	    }
	    else if (!timeoutId && wait !== maxWait) {
	      timeoutId = setTimeout(delayed, wait);
	    }
	    if (leadingCall) {
	      isCalled = true;
	      result = func.apply(thisArg, args);
	    }
	    if (isCalled && !timeoutId && !maxTimeoutId) {
	      args = thisArg = undefined;
	    }
	    return result;
	  }
	  debounced.cancel = cancel;
	  return debounced;
	}

	/**
	 * Checks if `value` is the [language type](https://es5.github.io/#x8) of `Object`.
	 * (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	 * @example
	 *
	 * _.isObject({});
	 * // => true
	 *
	 * _.isObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isObject(1);
	 * // => false
	 */
	function isObject(value) {
	  // Avoid a V8 JIT bug in Chrome 19-20.
	  // See https://code.google.com/p/v8/issues/detail?id=2291 for more details.
	  var type = typeof value;
	  return !!value && (type == 'object' || type == 'function');
	}

	module.exports = debounce;


/***/ },
/* 61 */
/***/ function(module, exports) {

	/**
	 * lodash 3.9.1 (Custom Build) <https://lodash.com/>
	 * Build: `lodash modern modularize exports="npm" -o ./`
	 * Copyright 2012-2015 The Dojo Foundation <http://dojofoundation.org/>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 * Available under MIT license <https://lodash.com/license>
	 */

	/** `Object#toString` result references. */
	var funcTag = '[object Function]';

	/** Used to detect host constructors (Safari > 5). */
	var reIsHostCtor = /^\[object .+?Constructor\]$/;

	/**
	 * Checks if `value` is object-like.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
	 */
	function isObjectLike(value) {
	  return !!value && typeof value == 'object';
	}

	/** Used for native method references. */
	var objectProto = Object.prototype;

	/** Used to resolve the decompiled source of functions. */
	var fnToString = Function.prototype.toString;

	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;

	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objToString = objectProto.toString;

	/** Used to detect if a method is native. */
	var reIsNative = RegExp('^' +
	  fnToString.call(hasOwnProperty).replace(/[\\^$.*+?()[\]{}|]/g, '\\$&')
	  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	);

	/**
	 * Gets the native function at `key` of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {string} key The key of the method to get.
	 * @returns {*} Returns the function if it's native, else `undefined`.
	 */
	function getNative(object, key) {
	  var value = object == null ? undefined : object[key];
	  return isNative(value) ? value : undefined;
	}

	/**
	 * Checks if `value` is classified as a `Function` object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isFunction(_);
	 * // => true
	 *
	 * _.isFunction(/abc/);
	 * // => false
	 */
	function isFunction(value) {
	  // The use of `Object#toString` avoids issues with the `typeof` operator
	  // in older versions of Chrome and Safari which return 'function' for regexes
	  // and Safari 8 equivalents which return 'object' for typed array constructors.
	  return isObject(value) && objToString.call(value) == funcTag;
	}

	/**
	 * Checks if `value` is the [language type](https://es5.github.io/#x8) of `Object`.
	 * (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	 * @example
	 *
	 * _.isObject({});
	 * // => true
	 *
	 * _.isObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isObject(1);
	 * // => false
	 */
	function isObject(value) {
	  // Avoid a V8 JIT bug in Chrome 19-20.
	  // See https://code.google.com/p/v8/issues/detail?id=2291 for more details.
	  var type = typeof value;
	  return !!value && (type == 'object' || type == 'function');
	}

	/**
	 * Checks if `value` is a native function.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a native function, else `false`.
	 * @example
	 *
	 * _.isNative(Array.prototype.push);
	 * // => true
	 *
	 * _.isNative(_);
	 * // => false
	 */
	function isNative(value) {
	  if (value == null) {
	    return false;
	  }
	  if (isFunction(value)) {
	    return reIsNative.test(fnToString.call(value));
	  }
	  return isObjectLike(value) && reIsHostCtor.test(value);
	}

	module.exports = getNative;


/***/ },
/* 62 */
/***/ function(module, exports) {

	"use strict";

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	var transitionEndEventName = (function () {
	  var el = document.createElement("div");
	  var transitions = {
	    "transition": "transitionend",
	    "OTransition": "oTransitionEnd",
	    "MozTransition": "transitionend",
	    "WebkitTransition": "webkitTransitionEnd"
	  };

	  for (var t in transitions) {
	    if (el.style[t] !== undefined) return transitions[t];
	  }
	})();

	exports.transitionEndEventName = transitionEndEventName;
	var requestAnimFrame = (function () {
	  return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.msRequestAnimationFrame || window.oRequestAnimationFrame || function (callback) {
	    return setTimeout(callback, 1000 / 60);
	  };
	})();
	exports.requestAnimFrame = requestAnimFrame;

/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag

	// load the styles
	var content = __webpack_require__(64);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(66)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../node_modules/css-loader/index.js?modules!./style.css", function() {
				var newContent = require("!!./../node_modules/css-loader/index.js?modules!./style.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(65)();
	// imports


	// module
	exports.push([module.id, ".wbUj_oHMpBitHI_JMg7Yo {\n    overflow: scroll;\n    -webkit-overflow-scrolling: touch;\n}\n\n._11wNc97h0GEOyKrpmt-cyQ {\n    min-height: 100%;\n    position: relative;\n    overflow: hidden;\n    transform: translate3d(0, 0, 0);\n}\n\n._27p2BGBGtjsj4-bKv8FdAQ {\n    display: block;\n    position: absolute;\n    opacity: 1;\n    transition-duration: 400ms;\n    transition-property: width, height, opacity;\n}\n\n.repositioning {\n    transition-property: width, height, opacity, transform;\n}\n\n.appearing,\n.disappearing {\n    opacity: 0;\n}\n", ""]);

	// exports
	exports.locals = {
		"container": "wbUj_oHMpBitHI_JMg7Yo",
		"content": "_11wNc97h0GEOyKrpmt-cyQ",
		"element": "_27p2BGBGtjsj4-bKv8FdAQ"
	};

/***/ },
/* 65 */
/***/ function(module, exports) {

	/*
		MIT License http://www.opensource.org/licenses/mit-license.php
		Author Tobias Koppers @sokra
	*/
	// css base code, injected by the css-loader
	module.exports = function() {
		var list = [];

		// return the list of modules as css string
		list.toString = function toString() {
			var result = [];
			for(var i = 0; i < this.length; i++) {
				var item = this[i];
				if(item[2]) {
					result.push("@media " + item[2] + "{" + item[1] + "}");
				} else {
					result.push(item[1]);
				}
			}
			return result.join("");
		};

		// import a list of modules into the list
		list.i = function(modules, mediaQuery) {
			if(typeof modules === "string")
				modules = [[null, modules, ""]];
			var alreadyImportedModules = {};
			for(var i = 0; i < this.length; i++) {
				var id = this[i][0];
				if(typeof id === "number")
					alreadyImportedModules[id] = true;
			}
			for(i = 0; i < modules.length; i++) {
				var item = modules[i];
				// skip already imported module
				// this implementation is not 100% perfect for weird media query combinations
				//  when a module is imported multiple times with different media queries.
				//  I hope this will never occur (Hey this way we have smaller bundles)
				if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
					if(mediaQuery && !item[2]) {
						item[2] = mediaQuery;
					} else if(mediaQuery) {
						item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
					}
					list.push(item);
				}
			}
		};
		return list;
	};


/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	/*
		MIT License http://www.opensource.org/licenses/mit-license.php
		Author Tobias Koppers @sokra
	*/
	var stylesInDom = {},
		memoize = function(fn) {
			var memo;
			return function () {
				if (typeof memo === "undefined") memo = fn.apply(this, arguments);
				return memo;
			};
		},
		isOldIE = memoize(function() {
			return /msie [6-9]\b/.test(window.navigator.userAgent.toLowerCase());
		}),
		getHeadElement = memoize(function () {
			return document.head || document.getElementsByTagName("head")[0];
		}),
		singletonElement = null,
		singletonCounter = 0,
		styleElementsInsertedAtTop = [];

	module.exports = function(list, options) {
		if(false) {
			if(typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
		}

		options = options || {};
		// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
		// tags it will allow on a page
		if (typeof options.singleton === "undefined") options.singleton = isOldIE();

		// By default, add <style> tags to the bottom of <head>.
		if (typeof options.insertAt === "undefined") options.insertAt = "bottom";

		var styles = listToStyles(list);
		addStylesToDom(styles, options);

		return function update(newList) {
			var mayRemove = [];
			for(var i = 0; i < styles.length; i++) {
				var item = styles[i];
				var domStyle = stylesInDom[item.id];
				domStyle.refs--;
				mayRemove.push(domStyle);
			}
			if(newList) {
				var newStyles = listToStyles(newList);
				addStylesToDom(newStyles, options);
			}
			for(var i = 0; i < mayRemove.length; i++) {
				var domStyle = mayRemove[i];
				if(domStyle.refs === 0) {
					for(var j = 0; j < domStyle.parts.length; j++)
						domStyle.parts[j]();
					delete stylesInDom[domStyle.id];
				}
			}
		};
	}

	function addStylesToDom(styles, options) {
		for(var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];
			if(domStyle) {
				domStyle.refs++;
				for(var j = 0; j < domStyle.parts.length; j++) {
					domStyle.parts[j](item.parts[j]);
				}
				for(; j < item.parts.length; j++) {
					domStyle.parts.push(addStyle(item.parts[j], options));
				}
			} else {
				var parts = [];
				for(var j = 0; j < item.parts.length; j++) {
					parts.push(addStyle(item.parts[j], options));
				}
				stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
			}
		}
	}

	function listToStyles(list) {
		var styles = [];
		var newStyles = {};
		for(var i = 0; i < list.length; i++) {
			var item = list[i];
			var id = item[0];
			var css = item[1];
			var media = item[2];
			var sourceMap = item[3];
			var part = {css: css, media: media, sourceMap: sourceMap};
			if(!newStyles[id])
				styles.push(newStyles[id] = {id: id, parts: [part]});
			else
				newStyles[id].parts.push(part);
		}
		return styles;
	}

	function insertStyleElement(options, styleElement) {
		var head = getHeadElement();
		var lastStyleElementInsertedAtTop = styleElementsInsertedAtTop[styleElementsInsertedAtTop.length - 1];
		if (options.insertAt === "top") {
			if(!lastStyleElementInsertedAtTop) {
				head.insertBefore(styleElement, head.firstChild);
			} else if(lastStyleElementInsertedAtTop.nextSibling) {
				head.insertBefore(styleElement, lastStyleElementInsertedAtTop.nextSibling);
			} else {
				head.appendChild(styleElement);
			}
			styleElementsInsertedAtTop.push(styleElement);
		} else if (options.insertAt === "bottom") {
			head.appendChild(styleElement);
		} else {
			throw new Error("Invalid value for parameter 'insertAt'. Must be 'top' or 'bottom'.");
		}
	}

	function removeStyleElement(styleElement) {
		styleElement.parentNode.removeChild(styleElement);
		var idx = styleElementsInsertedAtTop.indexOf(styleElement);
		if(idx >= 0) {
			styleElementsInsertedAtTop.splice(idx, 1);
		}
	}

	function createStyleElement(options) {
		var styleElement = document.createElement("style");
		styleElement.type = "text/css";
		insertStyleElement(options, styleElement);
		return styleElement;
	}

	function createLinkElement(options) {
		var linkElement = document.createElement("link");
		linkElement.rel = "stylesheet";
		insertStyleElement(options, linkElement);
		return linkElement;
	}

	function addStyle(obj, options) {
		var styleElement, update, remove;

		if (options.singleton) {
			var styleIndex = singletonCounter++;
			styleElement = singletonElement || (singletonElement = createStyleElement(options));
			update = applyToSingletonTag.bind(null, styleElement, styleIndex, false);
			remove = applyToSingletonTag.bind(null, styleElement, styleIndex, true);
		} else if(obj.sourceMap &&
			typeof URL === "function" &&
			typeof URL.createObjectURL === "function" &&
			typeof URL.revokeObjectURL === "function" &&
			typeof Blob === "function" &&
			typeof btoa === "function") {
			styleElement = createLinkElement(options);
			update = updateLink.bind(null, styleElement);
			remove = function() {
				removeStyleElement(styleElement);
				if(styleElement.href)
					URL.revokeObjectURL(styleElement.href);
			};
		} else {
			styleElement = createStyleElement(options);
			update = applyToTag.bind(null, styleElement);
			remove = function() {
				removeStyleElement(styleElement);
			};
		}

		update(obj);

		return function updateStyle(newObj) {
			if(newObj) {
				if(newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap)
					return;
				update(obj = newObj);
			} else {
				remove();
			}
		};
	}

	var replaceText = (function () {
		var textStore = [];

		return function (index, replacement) {
			textStore[index] = replacement;
			return textStore.filter(Boolean).join('\n');
		};
	})();

	function applyToSingletonTag(styleElement, index, remove, obj) {
		var css = remove ? "" : obj.css;

		if (styleElement.styleSheet) {
			styleElement.styleSheet.cssText = replaceText(index, css);
		} else {
			var cssNode = document.createTextNode(css);
			var childNodes = styleElement.childNodes;
			if (childNodes[index]) styleElement.removeChild(childNodes[index]);
			if (childNodes.length) {
				styleElement.insertBefore(cssNode, childNodes[index]);
			} else {
				styleElement.appendChild(cssNode);
			}
		}
	}

	function applyToTag(styleElement, obj) {
		var css = obj.css;
		var media = obj.media;
		var sourceMap = obj.sourceMap;

		if(media) {
			styleElement.setAttribute("media", media)
		}

		if(styleElement.styleSheet) {
			styleElement.styleSheet.cssText = css;
		} else {
			while(styleElement.firstChild) {
				styleElement.removeChild(styleElement.firstChild);
			}
			styleElement.appendChild(document.createTextNode(css));
		}
	}

	function updateLink(linkElement, obj) {
		var css = obj.css;
		var media = obj.media;
		var sourceMap = obj.sourceMap;

		if(sourceMap) {
			// http://stackoverflow.com/a/26603875
			css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
		}

		var blob = new Blob([css], { type: "text/css" });

		var oldSrc = linkElement.href;

		linkElement.href = URL.createObjectURL(blob);

		if(oldSrc)
			URL.revokeObjectURL(oldSrc);
	}


/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var _createClass = __webpack_require__(3)["default"];

	var _classCallCheck = __webpack_require__(7)["default"];

	var _slicedToArray = __webpack_require__(8)["default"];

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var GridLayout = (function () {
	  _createClass(GridLayout, null, [{
	    key: "Direction",
	    value: {
	      VERTICAL: 0,
	      HORIZONTAL: 1
	    },
	    enumerable: true
	  }]);

	  function GridLayout() {
	    _classCallCheck(this, GridLayout);

	    this.itemSize = [200, 200];
	    this.spacing = [20, 20];
	    this.insets = [[10, 10], [10, 10]];
	    this.itemCount = 0;
	    this.containerSizeConstraint = 0;
	    this.direction = GridLayout.Direction.VERTICAL;
	  }

	  _createClass(GridLayout, [{
	    key: "getItemCount",
	    value: function getItemCount(containerSize) {
	      var spacing = this.spacing[this.direction];

	      var _insets$direction = _slicedToArray(this.insets[this.direction], 2);

	      var startInset = _insets$direction[0];
	      var endInset = _insets$direction[1];

	      var availableSpace = containerSize[this.direction] - startInset - endInset;
	      var spaceAndSpacing = availableSpace + spacing;
	      var itemAndSpacing = this.itemSize[this.direction] + spacing;
	      return Math.floor(spaceAndSpacing / itemAndSpacing);
	    }
	  }, {
	    key: "configureElement",
	    value: function configureElement(element, _index) {
	      var _itemSize = _slicedToArray(this.itemSize, 2);

	      var width = _itemSize[0];
	      var height = _itemSize[1];

	      element.style.width = width + "px";
	      element.style.height = height + "px";
	    }
	  }, {
	    key: "updateContainerSize",
	    value: function updateContainerSize(containerSize) {
	      this.containerSizeConstraint = containerSize[this.direction];
	      this.itemCount = this.getItemCount(containerSize);
	    }
	  }, {
	    key: "getIndices",
	    value: function getIndices(xOffsets, yOffsets, count, containerSize) {
	      var offsets = [xOffsets, yOffsets];
	      var otherDirection = 1 - this.direction;

	      var _insets$otherDirection = _slicedToArray(this.insets[otherDirection], 2);

	      var otherStartInset = _insets$otherDirection[0];
	      var otherEndInset = _insets$otherDirection[1];

	      var _offsets$otherDirection = _slicedToArray(offsets[otherDirection], 2);

	      var offset = _offsets$otherDirection[0];
	      var endOffset = _offsets$otherDirection[1];

	      offset -= otherStartInset;
	      endOffset -= otherEndInset;
	      var itemCount = this.getItemCount(containerSize);
	      var spacing = this.spacing[otherDirection];
	      var itemAndSpacing = this.itemSize[otherDirection] + spacing;
	      var startIndex = Math.max(0, Math.floor(offset / itemAndSpacing) * itemCount);
	      var endIndex = Math.min(Math.ceil(endOffset / itemAndSpacing) * itemCount, count);
	      var indices = [];
	      for (var i = startIndex; i < endIndex; i += 1) {
	        indices.push(i);
	      }return indices;
	    }
	  }, {
	    key: "getElementPosition",
	    value: function getElementPosition(index) {
	      var sectionIndex = Math.floor(index / this.itemCount);
	      var itemIndex = index % this.itemCount;
	      var spacing = this.spacing[this.direction];

	      var _insets$direction2 = _slicedToArray(this.insets[this.direction], 2);

	      var startInset = _insets$direction2[0];
	      var endInset = _insets$direction2[1];

	      var otherDirection = 1 - this.direction;

	      var _insets$otherDirection2 = _slicedToArray(this.insets[otherDirection], 1);

	      var otherStartInset = _insets$otherDirection2[0];

	      var itemAndSpacing = this.itemSize[this.direction] + spacing;
	      var availableSpace = this.containerSizeConstraint - startInset - endInset;
	      var diff = availableSpace + spacing - this.itemCount * itemAndSpacing;
	      var otherspacing = this.spacing[otherDirection];
	      var otherItemAndspacing = this.itemSize[otherDirection] + otherspacing;
	      var result = [];
	      result[this.direction] = startInset + itemIndex * itemAndSpacing + Math.max(0, diff / 2);
	      result[otherDirection] = otherStartInset + sectionIndex * otherItemAndspacing;
	      return result;
	    }
	  }, {
	    key: "getContentSize",
	    value: function getContentSize(count, containerSize) {
	      var itemCount = this.getItemCount(containerSize);
	      var sectionCount = Math.ceil(count / itemCount);
	      var otherDirection = 1 - this.direction;

	      var _insets$otherDirection3 = _slicedToArray(this.insets[otherDirection], 2);

	      var startInset = _insets$otherDirection3[0];
	      var endInset = _insets$otherDirection3[1];

	      var spacing = this.spacing[otherDirection];
	      var itemAndSpacing = this.itemSize[otherDirection] + spacing;
	      var space = startInset + sectionCount * itemAndSpacing + endInset;
	      var result = [];
	      result[this.direction] = containerSize[this.direction];
	      result[otherDirection] = space;
	      return result;
	    }
	  }, {
	    key: "convertPositionInSize",
	    value: function convertPositionInSize(position, newContainerSize, oldLayout) {
	      var oldGridLayout = oldLayout instanceof GridLayout ? oldLayout : this;
	      var oldOtherDimension = 1 - oldGridLayout.direction;
	      var oldOtherPosition = position[oldOtherDimension];
	      var oldOtherspacing = oldGridLayout.spacing[oldOtherDimension];
	      var oldOtherItemAndSpacing = oldGridLayout.itemSize[oldOtherDimension] + oldOtherspacing;
	      var oldSectionIndex = Math.floor(oldOtherPosition / oldOtherItemAndSpacing);
	      var oldItemIndex = oldSectionIndex * oldGridLayout.itemCount;
	      var oldItemOffset = oldOtherPosition % oldOtherItemAndSpacing;

	      var newItemCount = this.getItemCount(newContainerSize);
	      var newSectionIndex = Math.floor(oldItemIndex / newItemCount);
	      var newOtherDimension = 1 - this.direction;
	      var newOtherspacing = this.spacing[newOtherDimension];
	      var newOtherItemAndSpacing = this.itemSize[newOtherDimension] + newOtherspacing;
	      var newOtherPosition = newSectionIndex * newOtherItemAndSpacing + oldItemOffset;

	      var result = [];
	      result[this.direction] = 0;
	      result[newOtherDimension] = newOtherPosition;
	      return result;
	    }
	  }]);

	  return GridLayout;
	})();

	exports["default"] = GridLayout;
	module.exports = exports["default"];

/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var _createClass = __webpack_require__(3)["default"];

	var _classCallCheck = __webpack_require__(7)["default"];

	var _slicedToArray = __webpack_require__(8)["default"];

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var ListLayout = (function () {
	  function ListLayout() {
	    _classCallCheck(this, ListLayout);

	    this.rowHeight = 200;
	  }

	  _createClass(ListLayout, [{
	    key: "updateContainerSize",
	    value: function updateContainerSize() {}
	  }, {
	    key: "configureElement",
	    value: function configureElement(element, _index) {
	      element.style.height = this.rowHeight + "px";
	    }
	  }, {
	    key: "getIndices",
	    value: function getIndices(xOffsets, yOffsets, count, _containerSize) {
	      var _yOffsets = _slicedToArray(yOffsets, 2);

	      var offset = _yOffsets[0];
	      var endOffset = _yOffsets[1];

	      var startIndex = Math.max(0, Math.floor(offset / this.rowHeight));
	      var endIndex = Math.min(Math.ceil(endOffset / this.rowHeight), count);
	      var indices = [];
	      for (var i = startIndex; i < endIndex; i += 1) {
	        indices.push(i);
	      }return indices;
	    }
	  }, {
	    key: "getElementPosition",
	    value: function getElementPosition(index) {
	      return [0, index * this.rowHeight];
	    }
	  }, {
	    key: "getContentSize",
	    value: function getContentSize(count, containerSize) {
	      var _containerSize2 = _slicedToArray(containerSize, 1);

	      var containerWidth = _containerSize2[0];

	      return [containerWidth, count * this.rowHeight];
	    }
	  }, {
	    key: "convertPositionInSize",
	    value: function convertPositionInSize(position, _newContainerSize, oldLayout) {
	      var oldListLayout = oldLayout instanceof ListLayout ? oldLayout : this;

	      var _position = _slicedToArray(position, 2);

	      var x = _position[0];
	      var y = _position[1];

	      var oldRowIndex = Math.floor(y / oldListLayout.rowHeight);
	      var oldRowOffset = y % oldListLayout.rowHeight;
	      var newY = oldRowIndex * this.rowHeight + oldRowOffset;
	      return [x, newY];
	    }
	  }]);

	  return ListLayout;
	})();

	exports["default"] = ListLayout;
	module.exports = exports["default"];

/***/ }
/******/ ])
});
;